;=============================================================================
; PathFinder() is for parsing pathnames to determine their validity.  The
; variable pathname.a must be received from the calling script.  The global
; variables are so the calling script can see/display the imporper part of
; the pathname if needed; otherwise they can be made private.
; The table "pathmsg" can/should be used to look up and display the
; results of erronious pathnames if entered by a user.
;
; Written and (c) CopyRighted 1991 by Ray Templin (516-957-5813)
; Last revision 5/2/91.
;=============================================================================

;                    Results returned to calling script
;                   in the form of a three digit number.
;                    XYZ: X = Drive, Y = Path, Z = File

;             ͻ
;              Result \ PathName      Drive    Path    File 
;             Ķ
;              Not Received             1       1       1   
;             Ķ
;              Invalid                  2       2       2   
;             Ķ
;              Unaccessable/Unknown     3       3       3   
;             Ķ
;              Verified                 4       4       4   
;             ͼ

PROC PathFinder(pathname.a)
     PRIVATE len.n, count.n, ext.a

;                   *** Set Global variables ***

     drive.a=""
     path.a=""
     file.a=""
;                     *** Check if anything received ***


     IF pathname.a="" THEN
          RETURN 111
     ENDIF

;                        *** Get drive ***

     WHILE MATCH (pathname.a, "@:..", drive.a, pathname.a)
          drive.a=drive.a+":"
     ENDWHILE

;                 *** Get path and/or file name ***

     file.a=pathname.a
     WHILE MATCH(file.a, "..\\..", strip.a, file.a)
          path.a=path.a+strip.a+"\\"
     ENDWHILE

;                    *** Check drive status ***

IF drive.a="" THEN
     result.n=100
ELSE
    SWITCH
        CASE LEN(drive.a)=1 OR LEN(drive.a)>2:
            result.n=200   ;This is not really needed at this time.
        CASE DIREXISTS(drive.a)=-1: result.n=200
        CASE DRIVESTATUS(SUBSTR(drive.a,1,1)): result.n=400
        OTHERWISE: result.n=300
    ENDSWITCH
ENDIF

;                       *** Check path status ***

IF path.a="" OR path.a="\\" THEN
     result.n=result.n+10
ELSE
    SWITCH
      CASE SEARCH("\\",path.a)>1:
          result.n=result.n+20
      CASE DIREXISTS(drive.a+path.a)=1:
          result.n=result.n+40
      CASE DIREXISTS(drive.a+path.a)=0:
          result.n=result.n+30
      CASE DIREXISTS(drive.a+path.a)=-1:
          result.n=result.n+20
      OTHERWISE:
          result.n=result.n+30
    ENDSWITCH
ENDIF

;                    *** Check file status as file ***

IF file.a="" THEN
     RETURN (result.n+1)
ENDIF

     len.n=LEN(file.a)
     count.n=SEARCH(".",file.a)

    IF count.n>0 THEN;                       There's an extension.
         ext.a=SUBSTR(file.a,count.n+1,len.n-count.n+1)
         SWITCH
            CASE count.n=1 OR count.n>9 OR LEN(ext.a)>3 OR len.n>12:
                RETURN (result.n+2)
            CASE ISFILE(drive.a+path.a+file.a):
                RETURN (result.n+4)
            CASE ISFILE(path.a+file.a) OR ISFILE(drive.a+"\\"+file.a):
                RETURN (result.n+4)
           OTHERWISE: RETURN (result.n+3)
         ENDSWITCH
    ENDIF

     IF len.n>8 THEN
          RETURN (result.n+2)
     ENDIF

;               *** Check file.a for path and/or file  ***

IF result.n=410 OR result.n=110 THEN
    SWITCH
        CASE ISFILE(drive.a+"\\"+file.a):
           RETURN (result.n+4)
        CASE DIREXISTS(drive.a+path.a+file.a)=1:  ; = d:pcplus (?)
           path.a=path.a+file.a file.a=""
           RETURN (result.n+31)  ;Asumme file.a is a path.
        CASE DIREXISTS(drive.a+path.a+file.a)=0:  ; = c:pdox35 (?)
           RETURN (result.n+3)   ;Assume file.a is a file.
        CASE DIREXISTS(drive.a+path.a+file.a)=-1:
           RETURN (result.n+3)   ;Assume file.a is a file name (and check validity?).
        OTHERWISE:
           RETURN (result.n+3)
    ENDSWITCH
ENDIF

IF result.n=440 OR result.n=140 THEN
    SWITCH
        CASE ISFILE(drive.a+path.a+file.a):
           RETURN (result.n+4)
        CASE DIREXISTS(drive.a+path.a+file.a)=1:
          path.a=path.a+file.a
          file.a=""
          RETURN (result.n+1)    ;Assume file.a is a path.
        CASE DIREXISTS(drive.a+path.a+file.a)=-1:
           RETURN (result.n+2)   ;Assume file.a is a file name (and check validity?).
        CASE DIREXISTS(drive.a+path.a+file.a)=0:
           RETURN (result.n+3)   ;Assume file.a should be a file.
        OTHERWISE:
           RETURN (result.n+3)
    ENDSWITCH
ELSE
   RETURN (result.n+3)
ENDIF

ENDPROC

;=====================================================================
; This script is only for testing the PathFinder() procedure.  It
; demonstrates how PathFinder() may be used and requires "pathmsg" 
; table to be accessible for reading/displaying the results.  It
; can be run simply by running "pathfind.sc".
;=====================================================================

VIEW "pathmsg"
MOVETO [Code]
CLEAR
WHILE (True)
     pathname.a=""
     @ 24,25 ??"Press [Enter] or [Esc] to quit."
     @ 10,02 ??"Enter a pathname: "+pathname.a
     @ 10,20 CLEAR EOL
     ACCEPT "A40" to pathname.a
     IF NOT retval OR pathname.a="" THEN
          ClearImage
          QUIT
     ENDIF
     result=PathFinder(pathname.a)
     LOCATE result
     message.a=[Message]
     @ 14,02 CLEAR EOL ?? "Drive = "+drive.a
     @ 15,02 CLEAR EOL ?? "Path = "+path.a
     @ 16,02 CLEAR EOL ?? "File = "+file.a
     @ 18,02 CLEAR EOL ?? "Result = "+message.a
ENDWHILE
