;****************************************************************************
; Password Utilities Extracted from an application -- In the application a
; table of authorized users is kept called "UserTbl".  The procedures listed
; below use this table to allow access to an application:
;
;   Passwd(Prmt,Tble) - Asks for a Password using the 'Prmt' provided.  If
;    this allows All tablerights for the 'Tble' specified it returns true.
;   ChngPasswd(Tble) - Changes the password on a table (Encrypts the table)
;   InitApp() - Initializes the Application.
;
; The script with these procs should be encrypted to guard against "prying eyes"
; The Procs should be read into your application's library.  The script that
; Initiates the application should have AUTOLIB = "Applibs" and InitApp()
; at the top and should be encrypted (See the Sample Application below).
;*****************************************************************************


; Procedure which displays 'Prmt' and accepts a password from the keyboard
;  this procedure is used in Passwd() and ChngPasswd()
;----------------------------------------------------------------------------
Proc GetPasswd(Prmt)
Private Char, Pswd
 @0,0 Clear EOL ?? Prmt+": "
 Char = Getchar()
 Pswd = ""
 While True
  Switch
   Case Char = 8:
    Pswd = SubStr(Pswd,1,Len(Pswd)-1)
   Case Char > 32:
    Pswd = Pswd + Chr(Char)
   Otherwise:
    Quitloop
  EndSwitch
  Char = Getchar()
 EndWhile
 Return Pswd
EndProc


; Procedure which checks a password to see if it supplies sufficient rights
;  to the 'Tble' specified
;--------------------------------------------------------------------------
Proc Passwd(Prmt,Tble)
Private Tries, Pswd
 Tries = 0
 While Tries < 3
  Tries = Tries + 1
  Pswd = GetPasswd(Prmt)
  If Pswd = "" then
   Return False
  Endif
  Password Pswd
  If Tablerights(Tble,"All") then
   Return True
    Else
   Unpassword Pswd
   @1,0 ?? "Invalid Password -- Try Again"
   Sleep 1000
  Endif
 Endwhile
 Return False
Endproc


; Procedure to Change the Password--must be in Main Mode
;  You can modify this to change the passwords on more than one table
;----------------------------------------------------------------------
Proc ChngPasswd(Tble)
Private Pswd
 Lock Tble FL
 If Retval = False then
  Message "Others are using the Application...Cannot Change Password"
  Sleep 3000
  Return False
 Endif
 If IsEncrypted(Tble) and Not Passwd("Enter Old Password",Tble) then
  Message "Access Denied..."
  Sleep 1000
  Unlock Tble FL
  Return False
 Endif
 Pswd = GetPasswd("Enter New Password")
 While Pswd <> GetPasswd("Re-type the New Password")
  Message "Incorrect Re-type..Try Again"
  Pswd = GetPasswd("Enter New Password again")
 Endwhile
 Message "Applying Password..."
 Protect Tble Pswd
 ;Protect "Table1" Pswd
 ;Protect "Table2" Pswd
 ;Etc.
 Message "Password Accepted..."
 Sleep 1000
 Unlock Tble FL
 Return True
EndProc


; Template for the script/procedure which initiates an application
;  Of course, this is only an example...yours will be different
;--------------------------------------------------------------------
Proc InitApp()
 Reset
 @6,0 Clear
 Text
                       Ŀ
                                  XYZ Company              
                                                           
                                  Professional             
                              *** Application ***          
                                     (V1.0)                
                                                           
                       Splash
                                                   
                                                   
                                                   




                                                          By Gary Samuelson
 Endtext
 Paintcanvas Attribute 16 0, 0, 24, 79
 Paintcanvas Border Attribute 49 6, 23, 13, 60
 Paintcanvas Attribute 127 7, 24, 12, 59
 Paintcanvas Attribute 15  13, 39, 13, 44
 Paintcanvas Attribute 80 7, 22, 13, 22
 Paintcanvas Attribute 46  17, 0, 24, 79
 Lock "UserTbl" PFL
 If Retval = False then
  Message Erroruser()+" has Exclusive use of the Application..."
  Sleep 3000
  Exit
 Endif
 If IsEncrypted("UserTbl") and Not Passwd("Enter the Password","UserTbl") then
  Message "Access Denied...System Locked"
  Sleep 3000
  Exit
 Endif
 View "UserTbl"
 Moveto [User]
 Locate Username()
 If Retval = False then
  Message Username()+" is not Authorized to Use Application..."
  Sleep 3000
  Exit
 Endif
 If [Status] > "" then
  ;Clean.Up()
  Message "This App was abnormally terminated when last used...Checking Files"
  Sleep 5000
 Endif
 CoEditKey
 [Status] = "O"
 Do_it!
 SetPrinter [Printer]
Endproc


;**************************** Sample Application ****************************
;  This small application will illustrate some of the capabilities of this
; method of password protection.
;
;  InitApp() Puts a PFL on the UserTbl, prompts for passwords if it is
;             Encrypted, then checks to see if the user is listed in the
;             Table.  If any one of these operations fail, access is denied.
;             The UserTbl is then updated to show that the user is in the app.
;  ChngPasswd() Puts a FL on the UserTbl, Changes the password, and then
;                Removes the FL.  This operation will fail if anyone else
;                is using the application (because of the PFL's placed)
;
;   If Change Password is chosen, ChngPasswd() is called and then the app is
; "prematurely" ended.  This models what would happen if the power went out
; in the middle of the app or the user "broke out".  Exit shows what a
; "normal" exit would do (Update the Usertbl).
;-----------------------------------------------------------------------------
InitApp()
Showmenu
 "Change Password" : "Change the Application's Master Password",
 "Exit" : "Exit the Application"
 To Choice
 If Choice = "Change Password" then
  ChngPasswd("UserTbl")
  Exit ;used to simulate an abnormal exit
 Endif

 ; Use the following in the procedure for a Normal Exit
 Moveto [UserTbl->User]
 CoEditKey
 [Status] = ""
 Do_it!
 Exit
