program Invoices;

uses
  DOS, CRT, PXEngine;

type
  NameString = string[25];

const
  Cust_N      = 10;
  Cust_Fields : array[1..Cust_N] of NameString =
                ('Code','Company Name','Contact','Addr1','Addr2','City','State','Zip',
                 'Telephone','Date Entered');
  Cust_Types  : array[1..Cust_N] of NameString =
                ('A6','A30','A30','A30','A30','A25','A2','A10','A14','D');

  Invoice_N   = 6;
  Invoice_Fields : array[1..Invoice_N] of NameString =
                ('Code','InvNum','Date','Subtotal','Tax','Total');

  Invoice_Types  : array[1..Invoice_N] of NameString =
                ('A6','A10','D','N','N','N');

  InvDet_N   = 4;
  InvDet_Fields : array[1..InvDet_N] of NameString =
                ('InvNum','Quan','Desc','Price');

  InvDet_Types  : array[1..InvDet_N] of NameString =
                ('A10','N','A50','N');

var
  Done, OK    : boolean;
  c,c2        : char;
  Cust_Tbl,
  Invoice_Tbl,
  InvDet_Tbl  : TableHandle;
  Cust_Rec,
  Invoice_Rec,
  InvDet_Rec  : RecordHandle;
  Cust_Edit   : record
                  Code        : string[6];
                  CompanyName,
                  Contact,
                  Addr1,
                  Addr2       : string[30];
                  City        : string[25];
                  State       : string[2];
                  Zip         : string[10];
                  Telephone   : string[14];
                  DateEntered : string[8];
                end;

procedure Error(n : integer);
begin
  if n <> PXsuccess then
  begin
    writeln('Error in Paradox Engine - ',PxErrMsg(n));
    halt(1);
  end;
end;  {Error}


procedure Msg(s : string);
begin
  Window(1,1,80,25);
  GotoXY(1,25);
  TextColor(black);
  TextBackground(lightgray);
  ClrEOL;
  GotoXY(2,25);
  write(s);
  GotoXY(80,25);
  TextColor(lightgray);
  TextBackground(blue);
end;  {Msg}


procedure ClearTop;
begin
  Window(1,1,80,25);
  GotoXY(1,1);
  TextColor(lightgray);
  TextBackground(blue);
  ClrEOL;
end;  {ClearTop}


procedure DrawMenu(s : string);
var
  i : byte;
begin
  GotoXY(1,1);
  TextBackground(blue);
  ClrEOL;
  for i := 1 to length(s) do
  begin
    if (s[i] >= 'A') and (s[i] <='Z') then
      TextColor(white)
    else
      TextColor(lightgray);
    write(s[i]);
  end;
  msg('Pick an item from the menu by pressing the highlighted letter.');
end;  {DrawMenu}


procedure InvoiceMenu;
var
  c : char;
begin
  repeat
    DrawMenu('INVOICES: New  Lookup  Summary  Quit');
    repeat
      c := upcase(readkey);
    until (c in ['N','L','S','Q',#27]);
{    case c of
    end;}
  until (c in ['Q',#27]);
end;  {InvoiceMenu}


procedure ClearCust;
begin
  with Cust_Edit do
  begin
    Code        := '';
    CompanyName := '';
    Contact     := '';
    Addr1       := '';
    Addr2       := '';
    City        := '';
    State       := '';
    Zip         := '';
    Telephone   := '';
    DateEntered := '';
  end;
end;  {ClearCust}


procedure EditCurrCust;
var
  item : byte;
begin
  item := 1;
  Window(3,3,78,23);
  TextBackground(blue);
  TextColor(lightgray);
  ClrScr;
  GotoXY(1,1);
  with Cust_Edit do
  begin
    Writeln('Code            : '+code);
    Writeln('Company name    : '+CompanyName);
    Writeln('Contact         : '+Contact);
    Writeln('Address (line 1): '+addr1);
    Writeln('Address (line 2): '+addr2);
    Writeln('City            : '+city);
    Writeln('State           : '+state);
    Writeln('Zip             : '+zip);
    Writeln('Telephone       : '+telephone);
    Writeln('DateEntered     : '+dateentered);
  end;

  Done := false;
  OK   := false;

  repeat
    Msg('Press [Enter] to edit field, [F2] to save, or [Esc] to leave without saving.');
    Window(3,3,78,23);
    GotoXY(19,item);
    c := readkey;
    if keypressed then          {Extended key was pressed}
      c2 := readkey;
    case c of
      #13 : with Cust_Edit do
            begin
              Msg('Enter field information; press [Enter] when done.');
              Window(3,3,78,23);
              GotoXY(19,item);
              case item of
                1 : readln(code);
                2 : readln(CompanyName);
                3 : readln(Contact);
                4 : readln(Addr1);
                5 : readln(Addr2);
                6 : readln(City);
                7 : readln(State);
                8 : readln(Zip);
                9 : readln(Telephone);
                10: readln(DateEntered);
              end;
            end;
      #0  : case c2 of
              #72 : if item <> 1 then dec(item);
              #80 : if item <> Cust_N then inc(item);
              #60  : begin
                       Done := true;
                       OK   := true;
                     end;
            end;
      #27 : begin
              Done := true;
              OK := false;
            end;
    end;
  until Done;
  ClrScr;
  Window(1,1,80,25);
end;  {EditCurrCust}


procedure AddCustomer;
var
  m,d,y,x : integer;
  date : Tdate;
begin
  ClearCust;
  EditCurrCust;
  if OK then        {Go ahead and save this new record}
  with Cust_Edit do
  begin
    Error(PXPutAlpha(Cust_Rec,1,code));
    Error(PXPutAlpha(Cust_Rec,2,CompanyName));
    Error(PXPutAlpha(Cust_Rec,3,Contact));
    Error(PXPutAlpha(Cust_Rec,4,Addr1));
    Error(PXPutAlpha(Cust_Rec,5,Addr2));
    Error(PXPutAlpha(Cust_Rec,6,City));
    Error(PXPutAlpha(Cust_Rec,7,State));
    Error(PXPutAlpha(Cust_Rec,8,Zip));
    Error(PXPutAlpha(Cust_Rec,9,Telephone));
    val(copy(DateEntered,1,2),m,x);
    val(copy(DateEntered,4,2),d,x);
    val(copy(DateEntered,7,2),y,x);
    y := y + 1900;
    Error(PXDateEncode(m,d,y,date));
    Error(PXPutDate(Cust_Rec,10,date));
    Error(PXRecAppend(Cust_Tbl,Cust_Rec));
  end;
end;  {AddCustomer}


procedure ChangeCustomer;
var
  cn : string;
  n : RecordNumber;
  found : boolean;
  s : string;
  i,m,d,y,x : integer;
  date : Tdate;
  ms,ds,ys : string[4];
begin
  Msg('Enter the code of the customer to change and press [Enter].');
  ClearTop;
  write('Customer to change: ');
  cn := '';
  readln(cn);
  if cn = '' then exit;
  Msg('Searching for customer...');
  Error(PXTblNRecs(Cust_Tbl,n));
  i := 1;
  found := false;
  while (not found) and (i<=n) do
  begin
    Error(PXRecGoto(Cust_Tbl,i));
    Error(PXRecGet(Cust_Tbl,Cust_Rec));
    Error(PXGetAlpha(Cust_Rec,1,s));
    if s = cn then
      found := true
    else
      inc(i);
  end;
  if i>n then
  begin
    Msg('Customer '+cn+' not found.  Press any key...');
    repeat until keypressed;
    exit;
  end;

  with Cust_Edit do
  begin
    Error(PXGetAlpha(Cust_Rec,1,code));
    Error(PXGetAlpha(Cust_Rec,2,CompanyName));
    Error(PXGetAlpha(Cust_Rec,3,Contact));
    Error(PXGetAlpha(Cust_Rec,4,Addr1));
    Error(PXGetAlpha(Cust_Rec,5,Addr2));
    Error(PXGetAlpha(Cust_Rec,6,City));
    Error(PXGetAlpha(Cust_Rec,7,State));
    Error(PXGetAlpha(Cust_Rec,8,Zip));
    Error(PXGetAlpha(Cust_Rec,9,Telephone));
    Error(PXGetDate(Cust_Rec,10,date));
    Error(PXDateDecode(date,m,d,y));
    str(m:2,ms);
    str(d:2,ds);
    str((y-1900):2,ys);
    DateEntered := ms+'/'+ds+'/'+ys;
    val(copy(DateEntered,1,2),m,x);
    val(copy(DateEntered,4,2),d,x);
    val(copy(DateEntered,7,2),y,x);
    y := y + 1900;
  end;

  EditCurrCust;
  if OK then        {Go ahead and save this new record}
  with Cust_Edit do
  begin
    Error(PXPutAlpha(Cust_Rec,1,code));
    Error(PXPutAlpha(Cust_Rec,2,CompanyName));
    Error(PXPutAlpha(Cust_Rec,3,Contact));
    Error(PXPutAlpha(Cust_Rec,4,Addr1));
    Error(PXPutAlpha(Cust_Rec,5,Addr2));
    Error(PXPutAlpha(Cust_Rec,6,City));
    Error(PXPutAlpha(Cust_Rec,7,State));
    Error(PXPutAlpha(Cust_Rec,8,Zip));
    Error(PXPutAlpha(Cust_Rec,9,Telephone));
    val(copy(DateEntered,1,2),m,x);
    val(copy(DateEntered,4,2),d,x);
    val(copy(DateEntered,7,2),y,x);
    y := y + 1900;
    Error(PXDateEncode(m,d,y,date));
    Error(PXPutDate(Cust_Rec,10,date));
    Error(PXRecUpdate(Cust_Tbl,Cust_Rec));
  end;
end;


procedure CustomerMenu;
var
  c : char;
begin
  repeat
    DrawMenu('CUSTOMERS: Add  Change  Report  Quit');
    repeat
      c := upcase(readkey);
    until (c in ['A','C','R','Q',#27]);
    case c of
      'A' : AddCustomer;
      'C' : ChangeCustomer;
    end;
  until (c in ['Q',#27]);
end;  {CustomerMenu}


procedure MainMenu;
var
  c : char;
begin
  repeat
    DrawMenu('MAIN: Customers  Invoices  Quit');
    repeat
      c := upcase(readkey);
    until (c in ['C','I','Q',#27]);
    case c of
      'C' : CustomerMenu;
      'I' : InvoiceMenu;
    end;
  until (c in ['Q',#27]);
end;  {MainMenu}


procedure InitScreen;
var
  i : integer;
begin
  Window(1,1,80,24);
  TextBackground(blue);
  TextColor(white);
  ClrScr;
  Window(1,1,80,25);

  for i := 2 to 79 do
  begin
    GotoXY(i,2);
    write('');
    GotoXY(i,24);
    write('');
  end;

  for i := 2 to 24 do
  begin
    GotoXY(1,i);
    write('');
    GotoXY(80,i);
    write('');
  end;
end;


function CheckQuit : boolean;
var
  yn : char;
begin
  GotoXY(1,1);
  TextBackground(blue);
  TextColor(lightgray);
  ClrEOL;
  write('Are you sure you want to quit? (Y/N) ');
  msg('Press [Y] to quit, or [N] to not quit.');
  repeat
    yn := upcase(readkey);
  until yn in ['Y','N',#27];
  CheckQuit := (yn = 'Y');
end;  {CheckQuit}


procedure InitDB;
begin
  Msg('Initializing database system...');
  Error(PXinit);

  if PXTblOpen('customer',Cust_Tbl,0,false) <> 0 then
  begin
    Error(PXTblCreate('customer',Cust_N,@Cust_Fields,@Cust_Types));
    Error(PXTblOpen('customer',Cust_Tbl,0,false));
  end;
  Error(PXRecBufOpen(Cust_Tbl,Cust_Rec));

  if PXTblOpen('invoice',Invoice_Tbl,0,false) <> 0 then
  begin
    Error(PXTblCreate('invoice',Invoice_N,@Invoice_Fields,@Invoice_Types));
    Error(PXTblOpen('invoice',Invoice_Tbl,0,false));
  end;
  Error(PXRecBufOpen(Invoice_Tbl,Invoice_Rec));

  if PXTblOpen('invdet',InvDet_Tbl,0,false) <> 0 then
  begin
    Error(PXTblCreate('invdet',InvDet_N,@InvDet_Fields,@InvDet_Types));
    Error(PXTblOpen('invdet',InvDet_Tbl,0,false));
  end;
  Error(PXRecBufOpen(InvDet_Tbl,InvDet_Rec));
end;  {InitDB}


procedure CloseDB;
begin
  Error(PXTblClose(Cust_Tbl));
  Error(PXExit);
end;  {CloseDB}


begin
  InitScreen;
  InitDB;

  repeat
    MainMenu;
  until CheckQuit;

  Msg('Closing system...');
  CloseDB;
  window(1,1,80,25);
  clrscr;
end.
