#include <stdio.h>    /* for fprint operations */
#include <dos.h>      /* for inregs/outregs */

/********************************************************************/
int main(int argc, char *argv[])

{
int RowCount,ColCount;       /* counters to step through video memory      */
int Color;                   /* the color we are currently processing      */
int ColorStartCol;           /* the column in which Color started          */
int WinningCount=0;          /* number times most prevalent color occurred */
int WinningColor=0;          /* the most prevalent color                   */
int ColorCount[255]={0};     /* used to determine most prevalent color     */
FILE *OutPutScript;          /* output file handle                         */
char far *VideoMemory;       /* pointer to beginning of video memory       */
union REGS inregs, outregs;  /* register vars used to determine video mode */


if (argc!=2)
  badexit();

OutPutScript=fopen(argv[1],"wt");
if (OutPutScript==0)
  {
  printf("Unable to open output file\n");
  badexit();
  }

inregs.h.ah = 0x0f;
int86(0x10, &inregs, &outregs);
if (outregs.h.al==7)
  VideoMemory=(char far *) 0xb0000000;
else
  VideoMemory=(char far *) 0xb8000000;


fprintf(OutPutScript,"@0,0\nText\n");

for (RowCount=0; RowCount<25; RowCount++)
  {
  for (ColCount=0; ColCount<160; ColCount+=2)
    {
    /* Print out character as it appears in video memory */
    fprintf(OutPutScript,"%c",*(VideoMemory + RowCount*160 + ColCount));

    /* Keep track of colors so can determine a winning color */
    Color=(int) *(VideoMemory + RowCount*160 + (ColCount*2)+1 );
    ColorCount[Color]++;                    /* add one to array element */
    if (ColorCount[Color]>WinningCount)
      {
      WinningCount=ColorCount[Color];
      WinningColor=Color;
      }
    }
  fprintf(OutPutScript,"\n");
  }

fprintf(OutPutScript,"Endtext\n");

fprintf(OutPutScript,"PaintCanvas Attribute %d 0,0,24,79\n",
       WinningColor);

for (RowCount=0; RowCount<25; RowCount++)
  {
  Color=(int) *(VideoMemory + RowCount*160 + 1);
  ColorStartCol=0;
  for (ColCount=0; ColCount<80; ColCount++)
    {
    if ( Color != (int) *(VideoMemory + RowCount*160 + (ColCount*2)+1) )
      {
      if (Color != WinningColor)
        fprintf(OutPutScript,"PaintCanvas Attribute %d %d,%d,%d,%d\n",
                   Color, RowCount, ColorStartCol, RowCount, ColCount-1);
      ColorStartCol=ColCount;
      Color=(int) *(VideoMemory + RowCount*160 + (ColCount*2)+1);
      }
    }
  if (Color!=WinningColor)
    fprintf(OutPutScript,"PaintCanvas Attribute %d %d,%d,%d,%d\n",
               Color, RowCount, ColorStartCol, RowCount, ColCount-1);
  }

fclose(OutPutScript);
exit(0);
}

badexit()
{
printf("PushScrn.exe V1.4 (C) Copyright 1992, David R. Faulkner (DrF)\n");
printf("Dumps Screen Information to a Pal Script.\n");
printf("Syntex: PushScrn OutPut.Sc\n");
exit(1);
}
