; Mid

; This is an example of how to use the P_Mid Proc.

; The purpose of P_Mid Proc is to allow you to change a portion
; (ie: a sub-string) of a variable to another value.

; The syntax is:

; targetstring = P_Mid(sourcestring, searchstring, replacementstring)

; for instance, if a variable called Example1 has a value of
; "oldsameoldsame" and you want to change all occurances of the
; string "old" with the string "new", then a call to P_Mid would be:

; Example1 = P_Mid(Example1, "old", "new")

; P_Mid is not case sensitive for the searchstring.

ReadLib "PALPABLE" P_Mid

Example1 = "oldsameoldsame"
@ 4, 0 ?? "Before call to P_Mid: ", Example1
Example1 = P_Mid(Example1, "old", "new")
@ 5, 0 ?? " After call to P_Mid: ", Example1

Example2 = "oldsameoldsame"
@ 7, 0 ?? "Before call to P_Mid: ", Example2
Example2 = P_Mid(Example2, "OLD", "new")
@ 8, 0 ?? " After call to P_Mid: ", Example2

Example3 = "long winded variable"
@ 10, 0 ?? "Before call to P_Mid: ", Example3
Example3 = P_Mid(Example3, "long winded", "short")
@ 11, 0 ?? " After call to P_Mid: ", Example3

Example4 = "one half = 1/2"
@ 13, 0 ?? "Before call to P_Mid: ", Example4
Example4 = P_Mid(Example4, "1/2", "")
@ 14, 0 ?? " After call to P_Mid: ", Example4

Sleep 3000
Release Procs P_Mid
