; RightTrim

; This is an example of how to use the P_RightTrim Proc.
; The purpose of the P_RightTrim Proc is to delete any trailing
; spaces from a variable.

; The syntax is:

; targetvar = P_RightTrim(sourcevar)

; for instance, if the value of a variable called P_Example is
; "five trailing spaces.     " then a call to P_RightTrim will
; return a value of "five trailing spaces.".

; Sending a value of all spaces will return a null string.
; If a variable contains no trailing spaces, then no action is taken.

ReadLib "PALPABLE" P_RightTrim

P_Example1 = "five trailing spaces.     "
@ 5, 0 ?? "Before call to P_RightTrim: ", P_Example1, "<"
P_Example1 = P_RightTrim(P_Example1)
@ 6, 0 ?? " After call to P_RightTrim: ", P_Example1, "<"

P_Example2 = "No trailing spaces."
@ 8, 0 ?? "Before call to P_RightTrim: ", P_Example2, "<"
P_Example2 = P_RightTrim(P_Example2)
@ 9, 0 ?? " After call to P_RightTrim: ", P_Example2, "<"

Sleep 3000

Release Procs P_RightTrim
