; ****************************************************************************
; SCRIPT NAME: ds4_WORK.sc               (c) 1992, 1993 DataStar International
; APPDEV TEAM: Dan Paolini, David Kelton, Micah Bleecher, Patty Paolini
; APPLICATION: DataStar Utilities for Paradox 4
; DESCRIPTION: Contains the following Workspace Management routines:
;                 quExecute.l
;                 quIsAnswer.l
;                 quPAL.u
;                 quPALCreate.l
;                 tbCreate.l
;                 tbDelete.l
;                 tbEmpty.u
;                 tbLockTables.l
;                 tbLockTablesDynArray.l
;                 tbProblemsRename.u
;                 tbRestructure.l
;                 tbView.u
;                 utEditorHandler.u
;                 utEditorHandlerMenu.u
;                 utEditorHandlerSave.u
;                 utSpeedButtonsEnable.u
;                 utSpeedButtonsSetup.u
;                 utSpeedButtonsPressed.u
;                 utSpeedButtonsDispatch.u
;                 utSpeedButtonsHelp.u
;                 utSpeedButtonsHelpDB.l
;                 wsDeleteDetails.u
;                 wsFieldView.u
;                 wsFieldViewHandler.n
;                 wsGetHandle.v
;                 wsPickForm.l
;                 wsWindowPark.u
;                 wsWindowSetup.u
;                 wsZoom.l
; ============================================================================
? Format("w40"," ds4_WORK.sc - Workspace Routines")
IF NOT IsAssigned(libname.a) THEN
   Beep Beep Beep QUIT "Variable \"libname.a\" is not assigned!.."
ENDIF
IF NOT IsFile(libname.a+".LIB") THEN
   CreateLib libname.a Size 640
ENDIF
@ Row(),40
; ============================================================================
;       TITLE: quExecute.l               (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false IF Query successful
; DESCRIPTION: Generic Query processor
; ----------------------------------------------------------------------------
PROC quExecute.l(                ; Generic Query Processor
         clear.l)                ; Should resultant table be cleared?
Private  error.l,                ; Error routine flag
         retval.l                ; Value to return

   error.l = false
   Do_It!                        ; Main Errorproc checks IF Query Completes
   IF error.l OR Window() <> "" THEN
      msContinue.u("","Query Error - " + Window(),79,"RED",4)
      retval.l = false
      IF IsAssigned(g.debug.l) AND g.debug.l THEN
         DEBUG
      ENDIF
   ELSE
      IF clear.l THEN
         ClearImage
      ENDIF
      WHILE NImages() > 0
         MoveTo 1
         IF ImageType() = "Query" THEN
            ClearImage
         ELSE
            QUITLOOP
         ENDIF
      ENDWHILE
      retval.l = true
   ENDIF
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a quExecute.l
; ============================================================================
;       TITLE: quIsAnswer.l              (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false IF Query successful
; DESCRIPTION: Generic Query processor
; ----------------------------------------------------------------------------
PROC quIsAnswer.l(               ; Tests for Answer from Query
         message.a,              ; Message to display, or blank
         beep.l)                 ; Whether to beep constantly
Private  retval.l
   retval.l = IsTable("Answer") AND NOT IsEmpty("Answer")
   IF NOT retval.l THEN
      msContinue.u("","No Records were Located.  The Answer Table is " +
                       IIF(IsTable("Answer"),"Empty.  ","not Found.  ") +
                       message.a,79,"RED",IIF(beep.l,3,1))
   ENDIF
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a quIsAnswer.l
; ============================================================================
;       TITLE: quPAL.u()                 (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Dialog box user interface to present utility options
;              and control execution.  Requires the following procedures:
;                 dbAlert.l               Alert procedure for dialog boxes
;                 dbButtonPress.v         Pauses depressed dbox button
;                 dbEventHandler.l        Generic dbox event handler
;                 msContinue.u            Generic message dialog box
;                 inAllFieldsChecked.l    Determines if every field is checked
;                 inBackSlashDouble.a     Doubles backslashes in a string
;                 inBackslashQuotes.a     Adds backslashes to quotes
;                 ioAcceptDialog.v        Accepts procedure name
;                 ioAcceptDialogValue.v   Generic Accept sub-routine
; ----------------------------------------------------------------------------
PROC quPAL.u()                   ; Turns Query Image into PAL code
Private  pushButton.l,           ; Button variable
         justification.n,        ; Output justification type
         outputFile.a,           ; Output file name
         proceduralize.n,        ; Proceduralize flag
         frameTag.a,             ; Current tag for framing
         frameHigh.n,            ; Highlight color for framing
         frameLow.n,             ; lowlight color for framing
         dBoxPalette.a,          ; Color palette for dialog box
         toprow.n,
         leftcol.n
   frameHigh.n     = 127
   frameLow.n      = 112
   pushButton.l    = false
   outputFile.a    = "INSTANT"
   justification.n = 1
   proceduralize.n = 1
   dBoxPalette.a   = "GRAY"
   toprow.n = 4
   leftcol.n = 14

   IF NImages() > 0 THEN
      SHOWDIALOG "Paladin Query Converter"
         Proc "dbEventHandler.n"
            Trigger "ARRIVE"
         @ -200, -200 Height 15 Width 53

         Frame Single From 2,1 To 4,49
            PaintCanvas Attribute IIF(frameTag.a = "FILE",frameHigh.n,frameLow.n)
                        2,1,4,49
            PaintCanvas Attribute IIF(frameTag.a = "FILE",frameLow.n,frameHigh.n)
                        2,49,4,49
            PaintCanvas Attribute IIF(frameTag.a = "FILE",frameLow.n,frameHigh.n)
                        4,2,4,49

         Frame Single From 5,1 To 8,49
            PaintCanvas Attribute IIF(Search("JUST",frameTag.a) = 1,
                                      frameHigh.n,frameLow.n)
                        5,1,8,49
            PaintCanvas Attribute IIF(Search("JUST",frameTag.a) = 1,
                                      frameLow.n,frameHigh.n)
                        5,49,8,49
            PaintCanvas Attribute IIF(Search("JUST",frameTag.a) = 1,
                                      frameLow.n,frameHigh.n)
                        8,2,8,49

         Frame Single From 9,1 To 12,49
            PaintCanvas Attribute IIF(Search("PUSH",frameTag.a) = 1,
                                      frameHigh.n,frameLow.n)
                        9,1,12,49
            PaintCanvas Attribute IIF(Search("PUSH",frameTag.a) = 1,
                                      frameLow.n,frameHigh.n)
                        9,49,12,49
            PaintCanvas Attribute IIF(Search("PUSH",frameTag.a) = 1,
                                      frameLow.n,frameHigh.n)
                        12,2,12,49

         PaintCanvas Fill "Output File Name:"
                     Attribute 112 3,3,3,19
         PaintCanvas Fill "Justification:"
                     Attribute 112 6,3,6,16
         PaintCanvas Fill "Proceduralize:"
                     Attribute 112 7,3,7,16
         PaintCanvas Fill " Paladin Query-To-PAL Converter "
                     Attribute 94 0,9,0,40
         PaintCanvas Fill Fill("",32)
                     Attribute 112 1,10,1,41
         PaintCanvas Fill ""
                     Attribute 112 0,41,0,41

         Accept @3,20 Width 28
            "A8" Picture "*!" Tag "FILE"
         To outputFile.a

         RadioButtons @6,17 Height 1 Width 32
            "Flush",
            "Right",
            "Left"
            Tag "JUST1"
         To justification.n

         RadioButtons @7,17 Height 1 Width 18
            "No",
            "Yes"
            Tag "JUST2"
         To proceduralize.n

         PushButton @10,8 Width 15 "~D~o_It!"
            Default Value quPALCreate.l(outputFile.a) Tag "PUSH1"
         To pushButton.l

         PushButton @10,28 Width 15 "~C~ancel"
            Cancel Value dbButtonPress.v(false) Tag "PUSH2"
         To pushButton.l
      ENDDIALOG
   ELSE
      msContinue.u("","Sorry, there are no images present",31,"BLUE",1)
   ENDIF
   Return
ENDPROC
?? "\004"
WriteLib libname.a quPAL.u
; ============================================================================
;       TITLE: quPALCreate.u()           (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Converts interactive query images to PAL code
; ----------------------------------------------------------------------------
PROC quPALCreate.l(              ; Converts Query images to PAL code
         outputFile.a)           ; Name of output file
Private  columns.n,              ; Number of columns in query image
         firstImage.a,           ; Query image 1
         blankRow.l,             ; True if entire row is blank
         row.n,                  ; Image row numbers
         fieldValues.y,          ; Contents of fields
         checkStatus.y,          ; Check mark status of fields
         fieldOrder.r,           ; Sequential order of fields
         allChecks.l,            ; True if checkmark status same in all fields
         maxLength.n,            ; Maximum length of field for output format
         retval.l,               ; Return variable
         outputProc.a,           ; Output procedure name
         n, n1, n2               ; Transient loop counters
   WHILE true
      retval.l = false
      IF NImages() = 0 THEN                  ; Check for no images
         msContinue.u("","Sorry, there are no images present",31,"BLUE",1)
         QUITLOOP
      ENDIF

      IF Search(".",outputFile.a) > 0 THEN   ; Check for file extensions
         msContinue.u("","Sorry, the Filename cannot have an extension",31,"BLUE",1)
         SelectControl "FILE"
         QUITLOOP
      ENDIF

      MoveTo 1                               ; If any query images, they start
      IF ImageType() <> "Query" THEN         ;  at Image #1
         msContinue.u("","Sorry, there are no Query images present",31,"BLUE",1)
         QUITLOOP
      ENDIF

      outputFile.a = outputFile.a + ".SC"
      IF IsFile(outputFile.a) THEN           ; Check for file name
         Beep Sleep 50 Beep Sleep 50 Beep
         SHOWPOPUP Upper(outputFile.a) + " Already Exists" CENTERED
            "~A~ppend"     : "Append Current File Name"     : "APPEND",
            "~O~verwrite"  : "Overwrite Current File Name"  : "OVER",
            "~R~ename"     : "Rename Current File Name"     : "RENAME"
         ENDMENU
         TO menuchoice.a

         IF NOT retval then
            QUITLOOP
         ENDIF

         SWITCH
            CASE menuchoice.a = "OVERWRITE"  :
               Editor New outputFile.a
               {Cancel} {Yes}
            CASE menuchoice.a =  "RENAME"    :
               SelectControl "FILE"
               QUITLOOP
         ENDSWITCH
      ENDIF

      IF proceduralize.n = 2 THEN    ;proceduralize output
         outputProc.a = ioAcceptDialog.v(3, 15, "Query Procedure Name",
                                        "Enter Proc Name", "A40", "", "",
                                         false, "")
         IF outputProc.a = false THEN
            QUITLOOP
         ENDIF
      ENDIF

      Print File outputFile.a "\n",
                              ";         quPAL: Begin Query \n",
                              ";     Generated: " +
                               Format("d2",Today()) + " - " + Time() + "\n",
                              ";   Description:\n\n"
      IF proceduralize.n = 2 THEN    ;proceduralize output
         Print File outputFile.a "PROC " + outputProc.a + "\n\n",
                                 "Private  retval.v\n\n\n"
      ENDIF

      MoveTo 1
      FOR n2 FROM 1 TO NImages()
         IF ImageType() = "Query" THEN       ; Process query images only
            firstImage.a = Table()
            columns.n = Nfields(Table())+1
            blankRow.l = true
            row.n = 1

            Print File outputFile.a "\n {Ask} SELECT \"" +
                                    inBackSlashDouble.a(Table()) + "\"\n"
            Home
            WHILE true
               CtrlHome
               DynArray fieldValues.y[]
               DynArray checkStatus.y[]
               Array fieldOrder.r[columns.n]
               maxLength.n = 0
               FOR n From 1 To columns.n
                  Message "Reading - Row: "+StrVal(row.n)+", Column: "+Strval(n)
                  fieldValues.y[Field()] = []
                  checkStatus.y[Field()] = CheckMarkStatus()
                  fieldOrder.r[n] = Field()
                  IF NOT IsBlank([] + CheckMarkStatus()) THEN
                     maxLength.n = Max(Len(Field()),maxLength.n)
                     blankRow.l = false
                  ENDIF
                  Right
               ENDFOR
               IF blankRow.l THEN
                  QUITLOOP
               ELSE
                  IF row.n > 1 THEN
                     Print File outputFile.a "  DOWN\n"
                  ENDIF
               ENDIF

               allChecks.l = inAllFieldsChecked.l(fieldOrder.r,
                                                   checkStatus.y,
                                                   columns.n)
               IF allChecks.l THEN
                  Print File outputFile.a
                              "  CTRLHOME " +
                              Upper(checkStatus.y[fieldOrder.r[2]]) +"\n"
               ENDIF

               IF NOT IsBlank(fieldValues.y[fieldOrder.r[1]]) THEN
                  Print File outputFile.a
                              "  \"" +
                              inBackslashQuotes.a(Upper(fieldValues.y[fieldOrder.r[1]]))+"\"\n"
               ENDIF

               FOR n1 FROM 2 To columns.n
                  Message "Writing Row: " + StrVal(row.n) +
                           ", Column: " + Strval(n)
                  IF NOT allChecks.l AND
                     NOT IsBlank(checkStatus.y[fieldOrder.r[n1]]) THEN
                     SWITCH
                        CASE justification.n = 1 : ; Full justification
                           Print File outputFile.a
                                       "  MoveTo" +
                                       Spaces((maxLength.n)-(len(fieldOrder.r[n1]))+1) +
                                       "[" + fieldOrder.r[n1] + "]   " +
                                       Upper(checkStatus.y[fieldOrder.r[n1]]) + "\n"

                        CASE justification.n = 2 :  ;Right justification
                           Print File outputFile.a
                                       Spaces((maxLength.n)-(len(fieldOrder.r[n1]))+3) +
                                       "MoveTo [" + fieldOrder.r[n1] + "]   " +
                                       Upper(checkStatus.y[fieldOrder.r[n1]]) + "\n"

                        CASE justification.n = 3 :   ;left justification
                           Print File outputFile.a
                                       "MoveTo [" + fieldOrder.r[n1] + "]   " +
                                       Upper(checkStatus.y[fieldOrder.r[n1]]) + "\n"
                     ENDSWITCH
                  ENDIF

                  IF NOT IsBlank(fieldValues.y[fieldOrder.r[n1]]) THEN
                     SWITCH
                        CASE justification.n = 1 : ; Full justification
                           Print File outputFile.a
                                       Spaces((maxLength.n+7)-(len(fieldOrder.r[n1]))+2) +
                                       "[" + fieldOrder.r[n1] + "] = \"" +
                                       inBackslashQuotes.a(fieldValues.y[fieldOrder.r[n1]]) +
                                       "\"\n"

                        CASE justification.n = 2 : ; Right justification
                           Print File outputFile.a
                                       Spaces((maxLength.n+7)-(len(fieldOrder.r[n1]))+3) +
                                       "[" + fieldOrder.r[n1] + "] = \"" +
                                       inBackslashQuotes.a(fieldValues.y[fieldOrder.r[n1]]) +
                                       "\"\n"

                        CASE justification.n = 3 : ; Left justification
                           Print File outputFile.a
                                       "[" + fieldOrder.r[n1] + "] = \"" +
                                       inBackslashQuotes.a(fieldValues.y[fieldOrder.r[n1]]) +
                                       "\"\n"
                     ENDSWITCH
                  ENDIF
               ENDFOR
               row.n = row.n + 1
               blankRow.l = true
            ENDWHILE
            Home CtrlHome
         ENDIF
         DownImage
      ENDFOR
      CtrlHome
      Print File outputFile.a "\n",
                              "; Do_It! \n",
                              "; quExecute.l(True)\n",
                              "; IF NOT retval THEN\n",
                              ";    DEBUG\n",
                              "; ENDIF\n",
                              ";\n",
                              ";== End Query ==\n"

      IF proceduralize.n = 2 THEN  ;proceduralize output
         Print File outputFile.a "\n",
                                 "ENDPROC\n",
                                 ";??\"\\004\"\n",
                                 ";WRITELIB libname.a ",
                                 IIF(Search("(",outputProc.a) = 0,
                                     outputProc.a + "\n",
                                     SubStr(outputProc.a,1,(Search("(",outputProc.a)-1)) +
                                     "\n")
      ENDIF

      SelectControl "PUSH2"
      Message "Conversion Complete"
      retval.l = true
      QUITLOOP
   ENDWHILE
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a quPALCreate.l
; ============================================================================
;       TITLE: tbCreate.l                (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false if table created
; DESCRIPTION: Creates a table like a table, and copies family
; ----------------------------------------------------------------------------
PROC tbCreate.l(                 ; Create new table like old table
         source.a,               ; Source table
         target.a)               ; New table
Private  a1,a2,a3,a4,            ; Match string-parsing variables
         lock.a,                 ; Lock string for lock procedure
         retval.l                ; Value to return
   IF NOT IsTable(source.a) THEN
      msContinue.u("Table " +table.a+ " was not found!",79,999,999,"",3)
      retval.l = false
   ELSE
      a1 = source.a
      a2 = ""
      WHILE Match(a1,"..\\..",a3,a1)
         a2 = a2 + a3 +"\\\\"
      ENDWHILE
      IF a1 <> source.a THEN
         a4 = a2 + a1
      ELSE
         a4 = source.a
      ENDIF

      lock.a = "\"" +a4+ "\" PFL"
      retval.l = tbLockTables.l(lock.a)
      IF retval THEN
         Create target.a LIKE source.a
         {Tools} {Copy} {JustFamily} SELECT source.a SELECT target.a {Replace}
         UnLock source.a PFL
      ENDIF
   ENDIF
   Return retval.l
ENDPROC
WriteLib libname.a   tbCreate.l
?? ""
; ============================================================================
;       TITLE: tbDelete.l                (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false if table deleted
; DESCRIPTION: Generic Delete Table Routine - Table should be locked first
; ----------------------------------------------------------------------------
PROC tbDelete.l(                 ; Deletes table if it Exists
         table.a)                ; Name of table to delete
Private  a1,a2,a3,a4,            ; Match string-parsing variables
         lock.a,                 ; Lock string for lock procedure
         retval.l                ; Value to return
   msWindow.u("W",49,0,0)
   a1 = table.a
   a2 = ""
   WHILE Match(a1,"..\\..",a3,a1)
      a2 = a2 + a3 +"\\\\"
   ENDWHILE
   IF a1 <> source.a THEN
      a4 = a2 + a1
   ELSE
      a4 = table.a
   ENDIF

   lock.a = "\"" +a4+ "\" FL"
   retval.l = tbLockTable.l(lock.a)
   IF retval THEN
      IF IsTable(table.a) THEN
         Delete table.a
      ENDIF
   ENDIF
   Return retval.l
ENDPROC
WriteLib libname.a   tbDelete.l
?? ""
; ============================================================================
;       TITLE: tbEmpty.u                 (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Generic Empty Table Routine
; ----------------------------------------------------------------------------
PROC tbEmpty.u(                  ; Generic table empty
         table.a)                ; Name of table to empty
   IF IsTable(table.a) AND not IsEmpty(table.a) THEN
      Empty table.a                       ; Next line flushes buffers
      SaveTables
   ENDIF
   Return
ENDPROC
WriteLib libname.a   tbEmpty.u
?? ""
; ============================================================================
;       TITLE: tbLockTables.l            (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false IF lock successful
; DESCRIPTION: Generic lock table procedure using a lock string
;              lock.a must be created with QUADRUPLE backslashes, and the
;              quotes around the tables must be preceded by a backslash,
;              like so:  lock.a = "\"d\\\\Table1\" PWL, \"d\\\\Table2\" WL"
; ----------------------------------------------------------------------------
PROC tbLockTables.l(             ; Generic table locker
         lock.a)                 ; tables and locks to try
Private  lock.n,                 ; Lock increment counter
         retval.l,               ; Value to return
         oldRetry.n

   lock.n = 0
   oldRetry.n = RetryPeriod()
   SetRetryPeriod 2
   WHILE true
      Execute "LOCK " + lock.a                ; using lock string
      IF retval THEN                          ; successful!
         retval.l = true
         QUITLOOP
      ENDIF
      IF lock.n < 5 THEN                      ; try 1 to 5 times in 5 seconds
         lock.n = lock.n + 1
         LOOP
      ELSE                                    ; uh-oh
         msConfirm.l("", "Lock(s) Failed: " + ErrorMessage() +
                          ".  Do you want to try to lock the table(s) again?",
                      79,"RED",0,"~T~ry Again","~C~ancel",true)
         IF retval THEN
            lock.n = 0                      ; reset loop counter
            Message "Trying to Lock Table Again..."
            LOOP
         ELSE
            msWorking.u("C",31,1,2)              ; let's get out of here!
            retval.l = false
            QUITLOOP
         ENDIF
      ENDIF
   ENDWHILE
   SetRetryPeriod oldRetry.n
   Message ""
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a tbLockTables.l
; ============================================================================
;       TITLE: tbLockTablesDynArray.l    (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false IF all locks successful
; DESCRIPTION: Generic table locking procedure from DynArray of locks/types,
;              which is split if length of locklist > 154.
; ----------------------------------------------------------------------------
PROC tbLockTablesDynArray.l(     ; dynarray based table locking procedure
         toLockList.y,           ; dynarray of tables and lock types
         lockAction.a)           ; LOCK or UNLOCK
Private  retval.l,               ; return variable
         n,                      ; numeric counter
         lockingList.y,          ; holds multiple file lock lists
         a,                      ; foreach loop tag
         oldRetry.n,
         lock.n

   oldRetry.n = RetryPeriod()
   SetRetryPeriod 2
   WHILE true
      IF Search(" " + lockAction.a + " "," LOCK UNLOCK ") = 0 THEN
         retval.l = false
         msContinue.u("Invalid Locking Action Specified",79,999,999,"",2)
         QUITLOOP
      ENDIF
      retval.l = true

      FOREACH a In toLockList.y
         IF Search(toLockList.y[a], "PFL PWL") = 0 THEN
            retval.l = false
         ENDIF
      ENDFOREACH

      IF NOT retval.l THEN
         msContinue.u("Invalid Locking Command Issued",79,999,999,"",2)
         QUITLOOP
      ENDIF

      dynarray lockingList.y[]
      n = 1
      lockingList.y[n] = ""

      FOREACH a IN toLockList.y
         IF Len(lockingList.y[n] + "\"" + inBackSlashDouble.a(a) +
                                   "\" " + toLockList.y[a] + ",") >= 155 THEN
            n = n + 1
            lockingList.y[n] = ""
         ENDIF
         lockingList.y[n] = lockingList.y[n] + "\"" + inBackSlashDouble.a(a) +
                                               "\"" + toLockList.y[a] + ","
      ENDFOREACH

      FOREACH a IN lockingList.y
         lockingList.y[a] = SubStr(lockingList.y[a],1,Len(lockingList.y[a])-1)
      ENDFOREACH

      lock.n = 0
      WHILE true
         FOREACH a IN lockingList.y
            Execute lockAction.a + " " + lockingList.y[a]
            retval.l = retval
            IF NOT retval.l THEN
               QUITLOOP
            ENDIF
         ENDFOREACH
         IF NOT retval.l THEN
            IF lock.n < 5 THEN                      ; try 1 to 5 times in 5 seconds
               lock.n = lock.n + 1
               LOOP
            ELSE                                    ; uh-oh
               IF Upper(lockAction.a) = "LOCK" THEN
                  msConfirm.l("", "Lock(s) Failed: " + ErrorMessage() +
                                   ".  Do you want to try to lock the table(s) again?",
                              79,"RED",0,"~T~ry Again","~C~ancel",true)
                  IF retval.l THEN
                     lock.n = 0                      ; reset loop counter
                     Message "Trying to Lock Table Again..."
                     LOOP
                  ELSE
                     msWorking.u("C",31,1,2)              ; let's get out of here!
                     IF Upper(lockAction.a) = "LOCK" THEN
                        FOREACH a IN lockingList.y
                           Execute "UnLock " + lockingList.y[a]
                        ENDFOREACH
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
         QUITLOOP
      ENDWHILE
      QUITLOOP
   ENDWHILE
   SetRetryPeriod oldRetry.n
   Return retval.l
ENDPROC
?? "\004"
WRITELIB libname.a tbLockTablesDynArray.l
; ============================================================================
;       TITLE: tbProblemsRename.u        (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Renames a problem Table into a RProblem directory
; ----------------------------------------------------------------------------
PROC tbProblemsRename.u(         ; Renames a Restructure problems table
         message.a,              ; Message for error dialog
         source.a)               ; Source table for rename
Private  target.a,
         suffix.n
   IF DirExists("RProblem") <> 1 THEN
      Run NoRefresh "MD RProblem"
   ENDIF
   suffix.n = 0
   target.a = "RProblem\\" + SubStr(inPathStrip.a(source.a),1,6)
   WHILE IsTable(target.a + SubStr(Format("w3,ez",suffix.n),2,2))
      suffix.n = suffix.n + 1
   ENDWHILE
   Rename "Problems" target.a + SubStr(Format("w3,ez",suffix.n),2,2)
   msContinue!.u("",message.a + "  The Problems table has been renamed " +
                    target.a + SubStr(Format("w3,ez",suffix.n),2,2) + ", " +
                   "and placed in the RProblems Directory.",79,"RED",4)
   Return
ENDPROC
?? "\004"
WriteLib libname.a tbProblemsRename.u
; ============================================================================
;       TITLE: tbRestructure.l           (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false if successful
; DESCRIPTION: Restructures a Table to match another table
; ----------------------------------------------------------------------------
PROC tbRestructure.l(            ; Restructures one table to match other
         target.a,               ; Table to restructure
         source.a,               ; Source of structure
         family.l)               ; Copy family of source?
Private  retval.l                ; Value to return
   Lock target.a FL, source.a PFL
   retval.l = retval
   IF retval.l THEN
      IF IsTable("Problems") THEN
         tbProblemsRename.u("An Unknown Problems table has been located.","UNKNOWN")
      ENDIF
      {Modify} {Restructure} Select target.a
      IF MenuChoice() = "Cancel" THEN
         {OK}
      ENDIF
      WHILE NImageRecords() > 1
         Del
      ENDWHILE
      Del
      {Borrow} Select source.a
      Do_It!
      IF MenuChoice() = "Convert" THEN
         {Convert}
      ENDIF
      WHILE MenuChoice() = "Delete"
         {Delete}
      ENDWHILE
      IF IsTable("Problems") THEN
         tbProblemsRename.u("There was a problem Restructuring the " + target.a +
                            " table to match the " + source.a + " table.",source.a)
      ENDIF
      IF family.l THEN
         {Tools} {Copy} {JustFamily} Select source.a Select target.a {Replace}
      ENDIF
      SaveTables
      UnLock target.a FL, source.a PFL
   ENDIF
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a tbRestructure.l
; ============================================================================
;       TITLE: tbView.u                  (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Checks for table on Workspace - Place Locks first
; ----------------------------------------------------------------------------
PROC tbView.u(                   ; Views table, locates it if on workspace
         table.a,                ; Table to view
         park.l)                 ; If true then move off screen
Private n,                       ; Transient image counter
        w                        ; Transient window handle
   IF NImages() > 0 THEN
      IF Upper(Table()) <> Upper(table.a) THEN
         FOR n From 1 to NImages()
            MoveTo n
            IF ImageType() <> "Query" AND Upper(Table()) = Upper(table.a) THEN
               Window Handle Image ImageNo() To w
               IF park.l THEN
                wsWindowPark.u(w)
               ENDIF
               QUITLOOP
            ENDIF
         ENDFOR
         IF ImageType() = "Query" OR Upper(Table()) <> Upper(table.a) THEN
            View table.a
            Window Handle Image ImageNo() To w
            IF park.l THEN
               wsWindowPark.u(w)
            ENDIF
         ENDIF
      ELSE
         Window Handle Image ImageNo() To w
      ENDIF
   ELSE
      View table.a
      Window Handle Image ImageNo() To w
      IF park.l THEN
         wsWindowPark.u(w)
      ENDIF
   ENDIF
   IF NOT IsAssigned(g.handles.y) THEN
      DynArray g.handles.y[]
   ENDIF
   g.handles.y[table.a] = w
   Return
ENDPROC
?? "\004"
WriteLib libname.a tbView.u
; ============================================================================
;       TITLE: utEditorHandler.u               (c) 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Provides user with editor interface for file or memo editing
;              that protects the system menu and system files. Only allows
;              user to write files to a private directory.
; ----------------------------------------------------------------------------
PROC utEditorHandler.u(          ; generic editor handler
         fileName.a,             ; file name or Table()->Field()
         windowTitle.a,          ; Title of editor window
         editorMode.a,           ; NEW, EXISTING, or MEMO
         wordWrap.l,             ; start with word wrap on
         autoIndent.l,           ; start with autoindent on
         caseSensitive.l)        ; start with case sensitive on
Private  windowName.a,           ; window name
         editor.y,               ; holds editor handle
         menu.y,                 ; get event dynarray
         search.v,               ; search variable
         replace.v,              ; replace variable
         gotonum.v,              ; goto variable
         fileDefault.a,          ; default file name
         insert.l,               ; insert mode
         prompt.a,               ; prompt variable
         insertFile.v,           ; insert file variable
         y,                      ; window attributes dynarray
         illegalKeys.a,          ; illegal key list
         insertFile.m            ; name of file to be inserted into editor session
;Global  waitmode.a              ; waitmode if called within wait handler

   DynArray editor.y[]
   utEditorHandlerMenu.u()    ;display menu

   SWITCH
      CASE Upper(editorMode.a) = "NEW" :
         windowName.a = IIF(IsBlank(PrivDir()),Directory(),Privdir())+fileName.a
         Editor NEW windowName.a
         IF windowTitle.a = "Viewing Contents Of ClipBoard" THEN
            ClipPaste
         ENDIF
      CASE Upper(editorMode.a) = "EXISTING" :
         windowName.a = IIF(IsBlank(PrivDir()),Directory(),Privdir())+fileName.a
         Editor OPEN windowName.a
      CASE Upper(editorMode.a) = "MEMO" :
         windowName.a = fileName.a
   ENDSWITCH

   editor.y[windowName.a] = wsGetHandle.v(IIF(editorMode.a = "MEMO","FIELDVIEW","EDITOR"),windowName.a)
   IF windowTitle.a > "" THEN
      WINDOW GetAttributes editor.y[windowName.a] TO y
      y["Title"] = windowTitle.a
      WINDOW SetAttributes editor.y[windowName.a] FROM y
   ENDIF

   IF wordWrap.l THEN                        ;Set editor defaults
      Menu {Options} {WordWrap} {Set}
   ELSE
      Menu {Options} {WordWrap} {Clear}
   ENDIF

   IF caseSensitive.l THEN
      Menu {Options} {CaseSensitive} {Set}
   ELSE
      Menu {Options} {CaseSensitive} {Clear}
   ENDIF

   IF autoIndent.l THEN
      Menu {Options} {Autoindent} {Set}
   ELSE
      Menu {Options} {Autoindent} {Clear}
   ENDIF

  insert.l      = true
  illegalKeys.a = "-61,-62,-97,-107,-88,-98,-108,-65,-66,-101,-111,-67,"+
                  "-24,15,18,21,-18,-32,-31,-45,-38,-37,11,-112"

   Echo Normal
   WHILE true
      msWorkingClear.u()
      prompt.a = IIF(IsAssigned(waitmode.a),IIF(IsFieldView(),"Memo "+waitmode.a,
      "File Edit"),IIF(IsFieldView(),"Memo Edit","File Edit"))
      prompt.a = prompt.a + "  WordWrap: "+IIF(wordWrap.l,"ON ","OFF")
      prompt.a = prompt.a + "  CaseSensitive: "+IIF(caseSensitive.l,"ON ","OFF")
      prompt.a = prompt.a + "  AutoIndent: "+IIF(autoIndent.l,"ON ","OFF")
      prompt.a = prompt.a + "  Insert: "+IIF(insert.l,"ON ","OFF")
      prompt.a = prompt.a + Spaces(79-Len(prompt.a))+""
      Prompt prompt.a

      GetEvent MESSAGE "ALL"
          KEY -60,1,-82,-59,-35
              ;contents of illegalKeys.a
              -61,-62,-97,-107,-88,-98,-108,-65,-66,-101,-111,-67,
              -24,15,18,21,-18,-32,-31,-45,-38,-37,11,-112
          MOUSE "DOWN"
      To menu.y

      IF menu.y["TYPE"] = "MOUSE" THEN     ;keeps user on editor window
         IF menu.y["ACTION"] = "DOWN" THEN
            IF WindowAt(menu.y["ROW"],menu.y["COL"]) = editor.y[windowName.a] THEN
               ExecEvent menu.y
            ELSE
               SWITCH
                  CASE menu.y["ROW"] = 24 AND menu.y["COL"] >= 12
                   AND menu.y["COL"] <= 27 :
                     IF wordWrap.l THEN
                        Menu {Options} {WordWrap} {Clear}
                        wordWrap.l = false
                     ELSE
                        Menu {Options} {WordWrap} {Set}
                        wordWrap.l = true
                     ENDIF
                  CASE menu.y["ROW"] = 24 AND menu.y["COL"] >= 28
                   AND menu.y["COL"] <= 48 :
                     IF caseSensitive.l THEN
                        Menu {Options} {CaseSensitive} {Clear}
                        caseSensitive.l = false
                     ELSE
                        Menu {Options} {CaseSensitive} {Set}
                        caseSensitive.l = true
                     ENDIF
                  CASE menu.y["ROW"] = 24 AND menu.y["COL"] >= 49
                   AND menu.y["COL"] <= 66 :
                     IF autoIndent.l THEN
                        Menu {Options} {Autoindent} {Clear}
                        autoIndent.l = false
                     ELSE
                        Menu {Options} {Autoindent} {Set}
                        autoIndent.l = true
                     ENDIF
                  CASE menu.y["ROW"] = 24 AND menu.y["COL"] >= 67
                   AND menu.y["COL"] <= 79 :
                     insert.l = NOT insert.l
                     KeyPress -82
                  OTHERWISE:
                     Beep
               ENDSWITCH
            ENDIF
         ENDIF
         LOOP
      ENDIF

      IF menu.y["TYPE"] = "KEY" THEN
         SWITCH
            CASE menu.y["KeyCode"] = -59 :
               IF IsAssigned(waitproc.y["Lookup!"+Table()+Field()]) THEN
                  ExecProc waitproc.y["Lookup!"+Table()+Field()]
               ELSE
                  Beep
               ENDIF
               LOOP
            CASE Search(","+StrVal(menu.y["KeyCode"])+",",    ;illegal keys
                 ","+illegalKeys.a+"," ) > 0 :
               Beep
               LOOP
            CASE menu.y["KeyCode"] = 1 :
               menu.y["Type"] = "MESSAGE"              ;convert certain keypresses
               menu.y["MESSAGE"] = "MENUSELECT"        ;to menuchoices
               menu.y["MENUTAG"] = "SEARCH.REPLACE"
            CASE menu.y["KeyCode"] = -60 :
               menu.y["Type"] = "MESSAGE"
               menu.y["MESSAGE"] = "MENUSELECT"
               menu.y["MENUTAG"] = "SAVE"
            CASE menu.y["KeyCode"] = -82 :
               insert.l = NOT insert.l
               KeyPress menu.y["KeyCode"]
               LOOP
            CASE menu.y["KeyCode"] = -59 OR menu.y["KeyCode"] = 35 :
               menu.y["Type"] = "MESSAGE"
               menu.y["MESSAGE"] = "MENUSELECT"
               menu.y["MENUTAG"] = "HELP"
         ENDSWITCH
      ENDIF

      IF menu.y["TYPE"] = "MESSAGE" THEN
         SWITCH
            CASE menu.y["MESSAGE"]  = "MAXIMIZE" :
               Window Maximize editor.y[windowName.a]
            CASE menu.y["MESSAGE"]  = "CLOSE" :
               ECHO OFF
               Menu {File} {Save}
               ECHO NORMAL
               QUITLOOP
            CASE menu.y["MESSAGE"]  = "MENUKEY" :
               IF menu.y["MENUKEY"] = "F2" THEN
                  ECHO OFF
                  Menu {File} {Save}
                  ECHO NORMAL
                  QUITLOOP
               ENDIF
            CASE menu.y["MESSAGE"]  = "MENUSELECT" :
               ECHO OFF
               SWITCH
                  CASE Search("FILE.",menu.y["MENUTAG"]) = 1 :
                     SWITCH
                        CASE menu.y["MENUTAG"] = "FILE.SAVE"    :
                           Menu {File} {Save}
                        CASE menu.y["MENUTAG"] = "FILE.SAVEAS"  :
                           utEditorHandlerSaveToFile.u(false)
                        CASE menu.y["MENUTAG"] = "FILE.INSERT"  :
                           WHILE true
                              insertFile.v = ioAcceptDialog.v(999,999,"Enter File Name",
                                                            "File","A45","","",FALSE,"")
                              IF insertFile.v <> false THEN
                                 IF NOT IsFile(insertFile.v) THEN
                                    msWorking.u("File Does Not Exist",79,2,2)
                                    LOOP
                                 ELSE
                                    msWorking.u("W",111,0,0)
                                    FileRead insertFile.v TO insertFile.m
                                    Editor Insert insertFile.m
                                    msWorkingClear.u()
                                    QUITLOOP
                                 ENDIF
                              ELSE
                                 QUITLOOP
                              ENDIF
                           ENDWHILE
                        CASE menu.y["MENUTAG"] = "FILE.WRITE"   :
                           msWorking.u("W",111,0,0)
                           utEditorHandlerSaveToFile.u(true)
                        CASE menu.y["MENUTAG"] = "FILE.PRINT"   :
                           IF ioPrinterStatus.l() THEN
                              msWorking.u("P",111,0,0)
                              Menu {File} {Print}
                              msWorkingClear.u()
                           ENDIF
                        CASE menu.y["MENUTAG"] = "FILE.SAVE"      :
                           Menu {File} {Save}
                     ENDSWITCH
                  CASE Search("SEARCH.",menu.y["MENUTAG"]) = 1 :
                     SWITCH
                        CASE menu.y["MENUTAG"] = "SEARCH.FIND" :
                           Zoom
                           Echo Normal
                        CASE menu.y["MENUTAG"] = "SEARCH.NEXT" :
                           ZoomNext
                           Echo Normal
                        CASE menu.y["MENUTAG"] = "SEARCH.REPLACE" :
                           search.v = ioAcceptDialog.v(999,999,"Enter Search Text",
                                                      "Text","A35","","",FALSE,"")
                           IF search.v <> FALSE AND NOT IsBlank(search.v) THEN
                              replace.v = ioAcceptDialog.v(999,999,"Enter Replace Text",
                                                         "Text","A35","","",FALSE,"")
                              IF replace.v <> FALSE AND NOT IsBlank(replace.v) THEN
                                 Menu {Search} {Replace}
                                 Select search.v Select replace.v
                                 ReplaceNext
                              ENDIF
                           ENDIF
                        CASE menu.y["MENUTAG"] = "SEARCH.REPLACENEXT" :
                           IF NOT IsBlank(search.v) AND search.v <> FALSE AND
                              NOT IsBlank(replace.v) AND replace.v <> FALSE THEN
                              Menu {Search} {Replace}
                              Select search.v Select replace.v
                              ReplaceNext
                           ENDIF
                        CASE menu.y["MENUTAG"] = "SEARCH.END"     :
                           search.v = ioAcceptDialog.v(999,999,"Enter Search Text",
                                                      "Text","A35","","",FALSE,"")
                           IF search.v <> FALSE AND NOT IsBlank(search.v) THEN
                              replace.v = ioAcceptDialog.v(999,999,"Enter Replace Text",
                                                         "Text","A35","","",FALSE,"")
                              IF replace.v <> FALSE AND NOT IsBlank(replace.v) THEN
                                 msWorking.u("W",111,0,0)
                                 Menu {Search} {ChangeToEnd}
                                 Select search.v Select replace.v
                                 {Yes}
                              ENDIF
                           ENDIF
                     ENDSWITCH
                  CASE Search("EDIT.",menu.y["MENUTAG"]) = 1 :
                     SWITCH
                        CASE menu.y["MENUTAG"] = "EDIT.CUT" :
                           Menu {Edit} {XCut}
                        CASE menu.y["MENUTAG"] = "EDIT.COPY" :
                           Menu {Edit} {Copy}
                        CASE menu.y["MENUTAG"] = "EDIT.PASTE" :
                           Menu {Edit} {Paste}
                        CASE menu.y["MENUTAG"] = "EDIT.ERASE" :
                           Menu {Edit} {Erase}
                        CASE menu.y["MENUTAG"] = "EDIT.VIEW" :
                           msWorking.u("W",111,0,0)
                           utEditorHandler.u("INSTANT.SC",
                                             "Viewing Contents Of ClipBoard",
                                             "NEW",true,true,false)
                           utEditorHandlerMenu.u()    ;display menu
                        CASE menu.y["MENUTAG"] = "EDIT.GOTO" :
                           gotonum.v = ioAcceptDialog.v(999,999,"Goto Line Number",
                                                      "Line","S","",BlankNum(),FALSE,"")
                           IF gotonum.v <> FALSE AND gotonum.v > 0 THEN
                              Editor GOTO Line gotonum.v
                           ENDIF
                     ENDSWITCH
                  CASE Search("OPTIONS.",menu.y["MENUTAG"]) = 1 :
                     SWITCH
                        CASE menu.y["MENUTAG"] = "OPTIONS.CASE.SET" :
                           Menu {Options} {CaseSensitive} {Set}
                           caseSensitive.l = true
                        CASE menu.y["MENUTAG"] = "OPTIONS.CASE.CLEAR" :
                           Menu {Options} {CaseSensitive} {Clear}
                           caseSensitive.l = false
                        CASE menu.y["MENUTAG"] = "OPTIONS.WRAP.CLEAR" :
                           Menu {Options} {WordWrap} {Clear}
                           wordWrap.l = false
                        CASE menu.y["MENUTAG"] = "OPTIONS.WRAP.SET" :
                           Menu {Options} {WordWrap} {Set}
                           wordWrap.l = true
                        CASE menu.y["MENUTAG"] = "OPTIONS.AUTO.SET" :
                           Menu {Options} {Autoindent} {Set}
                           autoIndent.l =  true
                        CASE menu.y["MENUTAG"] = "OPTIONS.AUTO.CLEAR" :
                           Menu {Options} {Autoindent} {Clear}
                           autoIndent.l = false
                     ENDSWITCH
                  CASE menu.y["MENUTAG"] = "HELP"     :
                     msWorking.u("Editor Help Not Yet Available",79,2,2)
                     LOOP
                  CASE menu.y["MENUTAG"] = "SAVE" :
                     msWorking.u("W",111,0,0)
                     Menu {DO-IT!}
                     QUITLOOP
                  CASE menu.y["MENUTAG"] = "CANCEL.CANCEL" :
                     msWorking.u("W",111,0,0)
                     Menu {Cancel} {Yes}
                     QUITLOOP
               ENDSWITCH
               ECHO NORMAL
         ENDSWITCH
      ENDIF
   ENDWHILE
   msWorkingClear.u()
   Return
ENDPROC
?? "\004"
WRITELIB libname.a utEditorHandler.u
; ============================================================================
;       TITLE: utEditorHandlerMenu.u           (c) 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Menu for controlled editor user interface
; ----------------------------------------------------------------------------
PROC utEditorHandlerMenu.u()
;Global  windowTitle.a

   SHOWPULLDOWN
      "File"            : "File menu"                    : "FILE"
      SubMenu
         "Save"         :  "Save current file"           : "FILE.SAVE",
         "Save~A~s"     :  "Save file as..."             : "FILE.SAVEAS",
         "InsertFile"   :  "Insert file from disk"       : "FILE.INSERT",
         "WriteBlock"   :  "Write block to disk"         : "FILE.WRITE",
         SEPARATOR,
         "Print"        :  "Print current file"          : "FILE.PRINT"
      EndSubMenu,
      "Edit"            :  "Edit menu"                   : "EDIT"
      SubMenu
         "XCut"         :  "Cut selected text"           : "EDIT.CUT",
         "Copy"         :  "Copy selected text"          : "EDIT.COPY",
         "Paste"        :  "Paste clipboard contents"    : "EDIT.PASTE",
         "Erase"        :  "Erase current line"          : "EDIT.ERASE",
         "ViewClipBoard":  "View contents of ClipBoard"  : "EDIT.VIEW",
         "GotoLine"     :  "Goto line number"            : "EDIT.GOTO"
      EndSubMenu,
      "Search"          :  "Search Menu"                 : "SEARCH"
      SubMenu
         "Find"         :  "Find text"                   : "SEARCH.FIND",
         "Next"         :  "Find next"                   : "SEARCH.NEXT",
         SEPARATOR,
         "Replace"      : "Search and replace"           : "SEARCH.REPLACE",
         "Re~p~laceNext": "Replace Next Value"           : "SEARCH.REPLACENEXT",
        "ChangeToEnd"   : "Replace non-stop"             : "SEARCH.END"
      EndSubMenu,
     "Options"          :  "Options Menu"                : "OPTIONS"
      SubMenu
         "AutoIndent"   : "Toggle autoindent"            : "OPTIONS.AUTO"
         SubMenu
            "Set"       :  "Set autoindent"              : "OPTIONS.AUTO.SET",
            "Clear"     : "Clear autoindent"             : "OPTIONS.AUTO.CLEAR"
         EndSubMenu,
         "WordWrap"     : "Set word wrap options"        : "OPTIONS.WRAP"
         SubMenu
            "Set"       : "Set word wrap"                : "OPTIONS.WRAP.SET",
            "Clear"     : "Clear word wrap"              : "OPTIONS.WRAP.CLEAR"
         EndSubMenu,
         "CaseSensitive": "Set case sensitivity"         : "OPTIONS.CASE"
         SubMenu
            "Set"       : "Set case sensitivity"         : "OPTIONS.CASE.SET",
            "Clear"     : "Clear case sensitivity"       : "OPTIONS.CASE.CLEAR"
         EndSubMenu
      EndSubmenu,
      "DO-IT!"          :  "Save and Quit"               : "SAVE",
      "Cancel"          :  "Cancel Edit Session"         : "CANCEL"
      SubMenu
         "No"           : "Return to edit session"       : "CANCEL.RETURN",
         "Yes"          : "Cancel edit session"          : "CANCEL.CANCEL"
      EndSubMenu,
      "Help"            :  "Help for editor session"     : "HELP"
   ENDMENU

   ;restrict certain menu choices while viewing clipboard contents
   IF windowTitle.a = "Viewing Contents Of ClipBoard" THEN
      MenuDisable "EDIT"
      MenuDisable "SEARCH"
      MenuDisable "OPTIONS"
      MenuDisable "FILE.SAVE"
      MenuDisable "FILE.SAVEAS"
      MenuDisable "FILE.INSERT"
      MenuDisable "FILE.WRITE"
   ENDIF

   ;restrict certain menu choices while in view mode
   IF IsAssigned(waitmode.a) AND waitmode.a = "View" THEN
      MenuDisable "FILE.INSERT"
      MenuDisable "EDIT.PASTE"
      MenuDisable "EDIT.CUT"
      MenuDisable "EDIT.ERASE"
      MenuDisable "SEARCH.REPLACE"
      MenuDisable "SEARCH.REPLACENEXT"
      MenuDisable "SEARCH.END"
   ENDIF
   Return
ENDPROC
?? "\004"
WRITELIB libname.a utEditorHandlerMenu.u
; ============================================================================
;       TITLE: utEditorHandlerSaveToFile.u     (c) 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Saves contents of editor or highlited block to another
;              file name. Checks if file already exists. Only allows user
;              to write to private directory to avoid any conflicts.
; ----------------------------------------------------------------------------
PROC utEditorHandlerSaveToFile.u( ;
         writeBlock.l)            ;true if writing block, false otherwise
Private  fileDefault.a,           ;default file name
         period.n,                ;period counter
         file.v,                  ;file name
         n,                       ;counter index
         block.m                  ;holds contents of editor

   fileDefault.a = ""
   WHILE (true)
      period.n = 0
      msWorkingClear.u()
      file.v = ioAcceptDialog.v(999,999,"Save As File Name",
      "File","A12","*{!,#_,-,~.}",fileDefault.a,FALSE,"")
      IF file.v = false THEN
         QUITLOOP
      ENDIF
      FOR n FROM 1 TO Len(file.v)
         IF SubStr(file.v,n,1) = "." THEN
            period.n = period.n + 1
         ENDIF
      ENDFOR
      IF period.n > 1 OR Search(".",file.v) > 9 THEN
         msWorking.u("Invalid File Name",79,2,2)
         fileDefault.a = file.v
      ELSE
         IF period.n = 0 THEN
            IF Len(file.v) > 8 THEN
               file.v = SubStr(file.v,1,8)
            ENDIF
         ENDIF
         IF IsFile(PrivDir()+file.v) THEN
            msConfirm.l("","File Already Exists",79,"RED",
                         2,"~O~verwrite","~C~ancel",false)
            IF retval THEN
            msWorking.u("W",111,0,0)
               IF NOT writeBlock.l THEN
                  Menu {File} {CopyToFile} Select PrivDir()+file.v
                  IF Menuchoice() = "Cancel"THEN
                     {Replace}
                  ENDIF
               ELSE
                 EDITOR Extract TO block.m
                 IF NOT IsBlank(block.m) THEN
                   FileWrite file.v FROM block.m
                 ENDIF
               ENDIF
            ELSE
               file.v = retval
            ENDIF
         ELSE
           IF NOT writeBlock.l THEN
              Menu {File} {CopyToFile} Select PrivDir()+file.v
           ELSE
              EDITOR Extract TO block.m
              IF NOT IsBlank(block.m) THEN
                 FileWrite file.v FROM block.m
              ENDIF
           ENDIF
         ENDIF
         QUITLOOP
      ENDIF
   ENDWHILE
   Return
ENDPROC
?? "\004"
WRITELIB libname.a utEditorHandlerSaveToFile.u
; ============================================================================
;       TITLE: utSpeedButtonsEnable.u    (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Places SpeedButtons at desired location; creates Window if it
;              does not exist.
;                 utSpeedButtonsEnable.u   - called to place Buttons on screen
;                 utSpeedButtonsSetup.u    - called to create Button Window
;                 utSpeedButtonsPressed.u  - called when Button is clicked
;                 utSpeedButtonsDispatch.n - handles selected Button action
;                 utSpeedButtonsHelp.u     - description of Button icons
;                 utSpeedButtonsHelpDB.u   - called to set scroll rate
; ----------------------------------------------------------------------------
PROC utSpeedButtonsEnable.u(     ; Restores or establishes SpeedButtons
         row.n,                  ; Row to establish SpeedButtons window
         column.n,               ; Column to establish SpeedButtons window
         colors.v)               ; DynArray of custom colors, or ""
;Global  g.handles.y             ; Stores application window handles
   IF NOT IsAssigned(g.handles.y) THEN
      DynArray g.handles.y[]
   ENDIF

   IF NOT IsAssigned(g.handles.y["SpeedButtons"]) OR
      NOT IsWindow(g.handles.y["SpeedButtons"]) THEN
      utSpeedButtonsSetup.u(colors.v)        ; Establish a new window
   ENDIF

   Window MOVE g.handles.y["SpeedButtons"]
          To row.n, column.n                 ; Bring it to desired location
   Return
ENDPROC
WriteLib libname.a utSpeedButtonsEnable.u
?? "\004"
; ============================================================================
;       TITLE: utSpeedButtonsSetup.u     (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Sets up mouse SpeedButtons
; ----------------------------------------------------------------------------
PROC utSpeedButtonsSetup.u(      ; Generic Mouse SpeedButtons Setup
         colors.v)               ; DynArray of Colors, or ""
Private  current.w,              ; Current Window Handle
         canvas.w,               ; Current Canvas Window Handle
         speedButtons.y,         ; SpeedButtons window dynarray
         iconColor.n,            ; Color of SpeedButton icons
         barColor.n,             ; Color of SpeedButton divider bars
         n,                      ; Loop incrementer
         y                       ; Transient window attributes dynarray
;Global  g.handles.y             ; Global window handle dynarray

   IF NOT IsAssigned(g.handles.y) THEN
      DynArray g.handles.y[]     ; Create window-tracking dynarray
   ENDIF

   iconColor.n = IIF(IsBlank(colors.v),SysColor(1003),colors.v["1003"])
   barColor.n  = IIF(IsBlank(colors.v),SysColor(1001),colors.v["1001"])
   Window HANDLE CURRENT To current.w        ; Save current window handle
   canvas.w = GetCanvas()                    ; Save current window handle

   DynArray speedButtons.y[]                 ; Create a dynamic array for specs
      speedButtons.y["CanClose"] = False
      speedButtons.y["CanMaximize"] = False
      speedButtons.y["CanMove"] = False
      speedButtons.y["CanResize"] = False
      speedButtons.y["Echo"] = False
      speedButtons.y["HasShadow"] = False
      speedButtons.y["HasFrame"] = False     ; IF Framed, window is *5* rows!!!
      speedButtons.y["Style"] = iconColor.n
   Window CREATE  FLOATING @ -200,-200
                  HEIGHT 1 WIDTH 37
                  ATTRIBUTES speedButtons.y To g.handles.y["SpeedButtons"]

   SetCanvas g.handles.y["SpeedButtons"]     ; Set Canvas to SpeedButtons Window
   @ 0,0 ?? " \30  \174  \27 Pg\24 ? Pg\25 \26  \175  \31 "
   FOR n From 0 To 9                         ; Color divider bars
      PaintCanvas ATTRIBUTE barColor.n  0,0+(n*4),0,0+(n*4)
   ENDFOR

   IF IsWindow(canvas.w) THEN                ; Restore focus
      SetCanvas canvas.w
   ELSE
      SetCanvas Default
   ENDIF

   IF IsWindow(current.w) THEN
      Window SELECT current.w                ; Restore original Window
   ENDIF
   Return
ENDPROC
WriteLib libname.a utSpeedButtonsSetup.u
?? "\004"
; ============================================================================
;       TITLE: utSpeedButtonsPressed.u   (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Determines which button was selected, colors it to appear
;              depressed, and calls the SpeedBar dispatch procedure
; ----------------------------------------------------------------------------
PROC utSpeedButtonsPressed.u(    ; Handles Mouse Events on Buttons window
         event.y,                ; Wait Proc Event DynArray
         pushColor.n)            ; Color for "depressed" button (11 is good)
Private  canvas.w,               ; Current canvas
         current.w,              ; Current window
         button.n,               ; Which button was "pressed"
         y                       ; DynArray of Window attributes
   IF NImages() = 0 OR IsEmpty(Table()) THEN
      msWorking.u("Table is Empty",79,3,2)
   ELSE
      ; You may need code here to block activity if editing/adding a record,
      ;  if you do not control how this proc is called from within your wait
      ;  handler.
      canvas.w = GetCanvas()                 ; Current canvas focus
      LocalizeEvent event.y                  ; Set Row/Column position
      SetCanvas g.handles.y["SpeedButtons"]  ;  relative to current window
                                             ; Determines current Style attrib
      Window GetAttributes g.handles.y["SpeedButtons"] To y

      IF Mod(event.y["Col"],4) <> 0 THEN     ; 0 = Clicked on a divider bar
         button.n = Int(event.y["Col"]/4)+1  ; Buttons are evenly spaced
         PaintCanvas Attribute pushColor.n 0,(button.n*4)-3,0,(button.n*4)-1
         utSpeedButtonsDispatch.u(button.n,pushColor.n)
         Sleep 300                           ; Pause for "depressed" effect
         PaintCanvas Attribute y["Style"]  0,(button.n*4)-3,0,(button.n*4)-1
      ELSE
         Beep
      ENDIF

      IF IsWindow(canvas.w) THEN             ; Restore focus
         SetCanvas canvas.w
      ELSE
         SetCanvas Default
      ENDIF
   ENDIF
   Return
ENDPROC
WriteLib libname.a utSpeedButtonsPressed.u
?? "\004"
; ============================================================================
;       TITLE: utSpeedButtonsDispatch.u  (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Dispatches actions based upon which button was pressed
; ----------------------------------------------------------------------------
PROC utSpeedButtonsDispatch.u(   ; Calls action appropriate to button
         button.n)               ; Button number
Private  y                       ; Transient GetEvent DynArray
;Global  g.config.y              ; Scroll rate in milliseconds
   IF NOT IsAssigned(g.config.y) THEN
      DynArray g.config.y[]
   ENDIF
   IF NOT IsAssigned(g.config.y["scrollRate.n"]) THEN    ; Initialize scroll variable
      g.config.y["scrollRate.n"] = 300
   ENDIF

   SWITCH
      CASE button.n = 1 :                    ; Home
         Home
         Message "Beginning of Table..."
      CASE button.n = 2 :                    ; Reverse Scroll
         IF NOT AtFirst() THEN
            WHILE NOT AtFirst()
               Skip -1
               Echo NORMAL Echo OFF
               Message "Reverse Scroll, Record ",RecNo()," - MouseClick or Press Any Key to Stop..."
               Sleep g.config.y["scrollRate.n"]
               GetEvent ALL To y
               IF (y["Type"] = "MOUSE" AND y["Action"] = "UP") OR
                  y["Type"] = "KEY" THEN
                  QUITLOOP
               ENDIF
            ENDWHILE
            Message "You are on Record " + StrVal(RecNo()) + "..."
         ELSE
            Beep
            Message "You are at the First Record in this Image..."
         ENDIF
      CASE button.n = 3 :                    ; Skip -1
         IF NOT AtFirst() THEN
            Skip -1
            Message "Record " +Strval([#])+ "..."
         ELSE
            Beep
            Message "You are at the First Record in this Image..."
         ENDIF
      CASE button.n = 4 :                    ; PgUp
         IF IsFormView() THEN
            IF AtFirst() AND PageNo() = 1 THEN
               Beep
               IF NPages() = 1 THEN
                  Message "You are at the First Record in this Image..."
               ELSE
                  Message "You are at the First Record's First Page in this Image..."
               ENDIF
            ELSE
               PgUp
               IF NPages() = 1 THEN
                  Message "Record " +StrVal([#])+ "..."
               ELSE
                  Message "Page " +StrVal(PageNo())+ " of Record "+Strval([#])+ "..."
               ENDIF
            ENDIF
         ELSE
            PgUp
            Message "Record " +StrVal([#])+ "..."
         ENDIF
      CASE button.n = 5 :                    ; Help
         utSpeedButtonsHelp.u()
      CASE button.n = 6 :                    ; PgDn
         IF IsFormView() THEN
            IF AtLast() AND PageNo() = NPages() THEN
               Beep
               IF NPages() = 1 THEN
                  Message "You are at the Last Record in this Image..."
               ELSE
                  Message "You are at the Last Record's Last Page in this Image..."
               ENDIF
            ELSE
               PgDn
               IF NPages() = 1 THEN
                  Message "Record " +StrVal([#])+ "..."
               ELSE
                  Message "Page " +StrVal(PageNo())+ " of Record "+Strval([#])+ "..."
               ENDIF
            ENDIF
         ELSE
            PgDn
            Message "Record " +StrVal([#])+ "..."
         ENDIF
      CASE button.n = 7 :                    ; Skip 1
         IF NOT AtLast() THEN
            Skip 1
            Message "Record " +Strval([#])+ "..."
         ELSE
            Beep
         ENDIF
      CASE button.n = 8 :                    ; Forward Scroll
         IF NOT AtLast() THEN
            WHILE NOT AtLast()
               Skip 1
               Echo NORMAL Echo OFF
               Message "Forward Scroll, Record ",RecNo()," - MouseClick or Press Any Key to Stop..."
               Sleep g.config.y["scrollRate.n"]
               GetEvent ALL To y
               IF (y["Type"] = "MOUSE" AND y["Action"] = "UP") OR
                  y["Type"] = "KEY" THEN
                  QUITLOOP
               ENDIF
            ENDWHILE
            Message "You are on Record " + StrVal(RecNo()) + "..."
         ELSE
            Beep
            Message "You are at the Last Record in this Image..."
         ENDIF
      CASE button.n = 9 :                    ; End
         End
         Message "End of Table..."
      OTHERWISE   : Beep                     ; Clicked a divider bar
   ENDSWITCH
   Return
ENDPROC
WriteLib libname.a utSpeedButtonsDispatch.u
?? "\004"
; ============================================================================
;       TITLE: utSpeedButtonsHelp.u      (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Popup Dialog with descriptions of SpeedButton icons, and
;              embedded Dialog Box to set scroll rate in milliseconds
; ----------------------------------------------------------------------------
PROC utSpeedButtonsHelp.u()      ; Description of SpeedButton icons
Private  button.l,               ; Pushbutton variable
         dBoxProcs.y,
         dBoxPalette.a
   dBoxPalette.a = "MAGENTA"
   DynArray dBoxProcs.y[]
      dBoxProcs.y["UPDATE"] = "utSpeedButtonsScroll.l"
   SHOWDIALOG "Help on Using Speed Buttons"
      Proc "utSpeedButtonsHelpDB.l"
         Trigger "UPDATE"
      @ 1,0
      Height 18 Width 37

      @ 1,1 ?? "Ŀ"
      @ 2,1 ?? "                               "
      @ 3,1 ?? "  \030  Home: 1st record in table "
      @ 4,1 ?? "  \174  Reverse continuous scroll "
      @ 5,1 ?? "  \027  Back/Up one record        "
      @ 6,1 ?? " Pg\024 Page up                   "
      @ 7,1 ?? " Pg\025 Page down                 "
      @ 8,1 ?? "  \026  Next/Down one record      "
      @ 9,1 ?? "  \175  Forward continuous scroll "
      @10,1 ?? "  \031  End: Last record in table "
      @11,1 ?? "                               "
      @12,1 ?? ""
      PaintCanvas Attribute 113 1,1,12,33
      PaintCanvas Border Attribute 127 1,1,12,33
      PaintCanvas Attribute 112 12,2,12,33
      PaintCanvas Attribute 112 1,33,12,33
      PaintCanvas Attribute 127 3,3,10,5

      PushButton @ 14,3
         Width 14 "~C~ontinue"
         OK Default Value true Tag "OK"
      To button.l

      PushButton @ 14,19
         Width 14 "~S~crollRate"
         Value false Tag "RATE"
      To button.l
   ENDDIALOG
   Return
ENDPROC
WriteLib libname.a utSpeedButtonsHelp.u
?? "\004"
; ============================================================================
;       TITLE: utSpeedButtonsScroll.l    (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Embedded Dialog Box to set scroll rate for Scrolling icons
; ----------------------------------------------------------------------------
PROC utSpeedButtonsScroll.l()    ; Set scroll rate for SpeedButtons
Private  button.l,
         scrollRate.n
;Global  g.config.y
   scrollRate.n = g.config.y["scrollRate.n"]
   IF type.a = "UPDATE" AND tag.a = "RATE" THEN
      SHOWDIALOG "In Tenth Seconds"
         @ 17,15
         Height 6 Width 26

         PaintCanvas Fill "1   5   9  13  17 20"
                     Attribute SysColor(1003) 1,2,1,21

         Slider @ 0,1
            Horizontal Length 22 Min 100 Max 2000
            ArrowStep 100 PageStep 500 Tag "SLIDER"
         To scrollRate.n

         PushButton @ 2,7
            Width 10 "~S~elect"
            OK Default Value true Tag "OK"
         To button.l
      ENDDIALOG
   ENDIF
   g.config.y["scrollRate.n"] = scrollRate.n
   Return true
ENDPROC
WriteLib libname.a utSpeedButtonsScroll.l
?? "\004"
; ============================================================================
;       TITLE: wsDeleteDetails.u         (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Deletes all linked details in a MultiTable form
; ----------------------------------------------------------------------------
PROC wsDeleteDetails.u()         ; Deletes linked details in MultiTable form
Private  n1, a, n2
   WHILE FormType("Linked") OR FormType("Detail")
      UpImage
   ENDWHILE
   n1 = NPages()
   CtrlHome
   a = Table()
   DownImage
   WHILE a <> Table()
      IF FormType("Linked") AND FormType("MultiRecord") AND
         NOT FormType("DisplayOnly") THEN
         ImageRights
         WHILE NImageRecords() > 2
            Del
         ENDWHILE
         Del
      ENDIF
      DownImage
   ENDWHILE
   IF n1 > 1 THEN
      FOR n2 From 2 to n1
         PgDn
         DownImage
         WHILE a <> Table()
            IF FormType("Linked") AND FormType("MultiRecord") AND
               NOT FormType("DisplayOnly") THEN
               WHILE NImageRecords() > 2
                  Del
               ENDWHILE
               Del
            ENDIF
            DownImage
         ENDWHILE
      ENDFOR
   ENDIF             ; Master has not been deleted
   Return
ENDPROC
WriteLib libname.a wsDeleteDetails.u
?? "\004"
; ============================================================================
;       TITLE: wsFieldView.u             (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Generic Field View which traps for problems during a Wait.
; ----------------------------------------------------------------------------
PROC wsFieldView.u(              ; Simulates Paradox FieldView
         mode.a)                 ; "View", "Edit", or "Add"
Private  error.l,
         n, w,
         prompt.a
;Global  speedButtons.l              ; Make formal parameter?

   Echo Off
   SWITCH
      CASE mode.a = "View" AND IsBlank([]) :
         msWorking.u("Sorry, that Field is empty",111,1,2)
      CASE Field() = "#"   :
         msWorking.u("Cannot use FieldView in Record Number Column",111,1,2)
      CASE RecNo() > 65535 :
         msWorking.u("Cannot use FieldView beyond Record #65535",111,1,2)
      CASE IsLinkLocked() :
         msContinue.u("Current field value is:  " +Format("w48",[]),
                       30,999,999,"",0)
      OTHERWISE:
         error.l = False
         IF mode.a = "View" THEN
            ImageRights
            [] = []
            IF error.l THEN
               UnDo
            ENDIF
            ImageRights READONLY
         ENDIF
         IF NOT error.l THEN
            IF speedButtons.l THEN
               wsWindowPark.u(g.handles.y["SpeedButtons"])
               wsWindowPark.u(g.handles.y["SpeedBar"])
            ENDIF
            IF Search("M",FieldType()) = 1 THEN
               IF NOT IsFieldView() THEN
                  FieldView
               ENDIF
               utEditorHandler.u(Table()+"->"+Field(),
                                 waitmode.a+"ing Memo Field: "+Field(),
                                 "MEMO",true,true,false)
            ELSE
               ShowPullDown
                  "Press ~<F2>~ when Finished" : "" : "FIELDVIEW.DONE"
               EndMenu
               IF mode.a = "View" THEN
                  prompt.a = "Viewing [" +Field()+ "] in FieldView..."
               ELSE    ;"Add" or "Edit"
                  prompt.a = "Editing [" +Field()+ "] in FieldView..."
               ENDIF
               IF NOT IsFieldView() THEN
                  FieldView
               ENDIF
               Prompt prompt.a
               Echo Normal
               Wait Field
                  PROC "wsFieldViewHandler.n"
                     Key "Dos", "DosBig", -103, -59, 27, -60, -18 , 13
                     Message "CLOSE", "MENUSELECT"
                     Trigger "DEPARTFIELD"
               EndWait
               ENDIF
               IF IsFieldView() THEN
                  Do_It!
               ENDIF
               IF SpeedButtons.l THEN
                  Window MOVE g.handles.y["SpeedButtons"]
                        To 0,g.sysInfo.y["ScreenWidth"]-33
                  Window MOVE g.handles.y["SpeedBar"]
                        To g.sysInfo.y["ScreenHeight"]-1,g.sysInfo.y["ScreenWidth"]-56
               ENDIF

            IF IsAssigned(waitproc.y[waitmode.a+"Menu!"+module.a+StrVal(g.level.v)]) THEN
               ExecProc waitproc.y[waitmode.a+"Menu!"+Module.a+Strval(g.level.v)]
            ELSE
               ExecProc "dsWaitMenu"+waitmode.a+".u"
            ENDIF
         ENDIF
   ENDSWITCH
   Return
ENDPROC
WriteLib libname.a wsFieldView.u
?? "\004"
; ============================================================================
;       TITLE: wsFieldViewHandler.n      (c) 1992, 1993 DataStar International
;     RETURNS: WaitProc value of 0, 1 or 2
; DESCRIPTION: Generic Field View Wait Handler
; ----------------------------------------------------------------------------
PROC wsFieldViewHandler.n(       ; Simulates Paradox FieldView
         event.a,
         event.y,
         cycle.n)
Private  retval.n

   SWITCH
      CASE event.a = "EVENT" AND event.y["Type"] = "KEY" AND
           event.y["KeyCode"] <> -60 AND event.y["KeyCode"] <> 27 AND
           event.y["KeyCode"] <> 13 :
         Beep
         retval.n = 1
      OTHERWISE :
         IF event.y["Type"] = "KEY" THEN
            IF event.y["KeyCode"] = 13 And Search("M",FieldType()) = 1 THEN
               Retval.n = 0
            ELSE
               retval.n = 2
            ENDIF
         ELSE
            retval.n = 2
         ENDIF
   ENDSWITCH
   Return retval.n
ENDPROC
WriteLib libname.a wsFieldViewHandler.n
?? "\004"
; ============================================================================
;       TITLE: wsGetHandle.v             (c) 1992, 1993 DataStar International
;     RETURNS: Window handle integer or "Error"
; DESCRIPTION: Generic window handle capturing procedure. Used especially
;              for capturing editor and fieldview window handles when
;              dialog boxes or floating windows exist in the z-order.
; ---------------------------------------------------------------------------
PROC wsGetHandle.v(              ; retrieves window for specified object
         handleType.a,           ; handle type
         editorTitle.a)          ; file name for editor
Private  retval.v,               ; return variable - handle# or "Error"
         r,                      ; array of window handles
         n,                      ; numeric index for FOR LOOP
         y                       ; window attribute dynarray to evaluate title

   SWITCH
      CASE Upper(handleType.a) = "IMAGE"           :
         Window Handle IMAGE ImageNo() To retval.v
      CASE Upper(handleType.a) = "FORM"            :
         Window Handle FORM To retval.v
      CASE Upper(handleType.a) = "DIALOG"          :
         Window Handle DIALOG To retval.v
      CASE Upper(handleType.a) = "FORMDESIGN"      :
         Window Handle FORM DESIGN To retval.v
      CASE Upper(handleType.a) = "REPORTDESIGN"    :
         Window Handle REPORT DESIGN To retval.v
      CASE Upper(handleType.a) = "EDITOR"  OR
           Upper(handleType.a) = "FIELDVIEW"       :
         Window List To r
         FOR n From 1 TO ArraySize(r)
            Window Select r[n]
            Window GetAttributes r[n] To y
            IF Upper(y["Title"]) = Upper(editorTitle.a) THEN
               retval.v = r[n]
               QUITLOOP
            ENDIF
         ENDFOR
      CASE Upper(handleType.a) = "OTHERWISE"       :
         retval.v = "Error"
   ENDSWITCH
   RETURN IIF(IsAssigned(retval.v),retval.v,"Error")
ENDPROC
?? "\004"
WRITELIB libname.a wsGetHandle.v
; ============================================================================
;       TITLE: wsPickForm.l              (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: GenericWindow Parking Routine (hides windows)
; ----------------------------------------------------------------------------
PROC wsPickForm.l(
         form.a)
Private  h, y,
         error.l
   error.l = false
   PickForm form.a               ; Calls errorproc IF tables locked
   IF NOT error.l THEN
      Window Handle FORM To h
      Window GetAttributes h To y
         y["HasFrame"] = false
         y["HasShadow"] = false
         y["Maximized"] = true
         y["OriginCol"] = 0
      Window SetAttributes h From y
      Window Select h
   ENDIF
   Return NOT error.l
ENDPROC
WriteLib libname.a wsPickForm.l
?? "\004"
; ============================================================================
;       TITLE: wsWindowPark.u            (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: GenericWindow Parking Routine (hides windows)
; ----------------------------------------------------------------------------
PROC wsWindowPark.u(             ; Parks window off screen
         w)                      ; Window to park
   IF IsWindow(w) THEN                       ; Make sure it still exists
      Window MOVE w To -200,-200             ; Park it in left field
   ENDIF
ENDPROC
?? "\004"
WriteLib libname.a wsWindowPark.u
; ============================================================================
;       TITLE: wsWindowSetup.u           (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Sets up mouse SpeedButtons and speed buttons
; ----------------------------------------------------------------------------
PROC wsWindowSetup.u()           ; Generic Mouse SpeedButtons/SpeedBar
Private  current.w,              ; Current Window Handle
         n,                      ; Loop incrementer
         y                       ; Transient window attributes dynarray
;Global  g.handles.y             ; Global message window dynamic array
;        g.sysInfo.y             ; Global message window handle
;        g.speedButtons.y        ; Global message window handle
;        g.speedBar.y            ; Global message window handle
;        g.appColors.y           ; Global message window handle

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo To g.sysInfo.y
   ENDIF
   IF g.sysInfo.y["UIMode"] = "COMPATIBLE" THEN
      Return
   ENDIF
   IF NOT IsAssigned(g.handles.y) THEN
      DynArray g.handles.y[]
   ENDIF
   Window HANDLE CURRENT To current.w        ; Save current window handle

;*****[SpeedButtons]*****
   IF NOT IsAssigned(g.speedButtons.y) OR        ; Must be first time, or var released
      NOT IsAssigned(g.handles.y["SpeedButtons"]) OR
      NOT IsWindow(g.handles.y["SpeedButtons"]) THEN
      DynArray g.speedButtons.y[]                ; Create a dynamic array for specs
         g.speedButtons.y["CanClose"] = False
         g.speedButtons.y["CanMaximize"] = False
         g.speedButtons.y["CanMove"] = False
         g.speedButtons.y["CanResize"] = False
         g.speedButtons.y["Echo"] = False
         g.speedButtons.y["HasShadow"] = False
         g.speedButtons.y["HasFrame"] = False    ; IF Framed, window is *5* rows!!!
         g.speedButtons.y["Style"] = g.appColors.y[1001]
      Window CREATE  FLOATING @ -200,-200
                     HEIGHT 1 WIDTH 39
                     ATTRIBUTES g.speedButtons.y To g.handles.y["SpeedButtons"]
   ENDIF
   SetCanvas g.handles.y["SpeedButtons"]         ; Set Canvas to SpeedButtons Window
   PaintCanvas FILL "<Z> \30  \174  \27 Pg\24Pg\25 \26  \175  \31 ?"
               ATTRIBUTE g.appColors.y[1003]  0,0,0,38
   FOR n From 0 To 9
      PaintCanvas ATTRIBUTE g.appColors.y[1001]  0,0+(n*4),0,0+(n*4)
   ENDFOR
   PaintCanvas ATTRIBUTE g.appColors.y[1001]  0,38,0,38
;*****[SpeedBar DynArray]*****
   IF NOT IsAssigned(g.speedBar.y) OR        ; Must be first time, or var released
      NOT IsAssigned(g.handles.y["SpeedBar"]) OR
      NOT IsWindow(g.handles.y["SpeedBar"]) THEN
      DynArray g.speedBar.y[]             ; Create a dynamic array for specs
         g.speedBar.y["CanClose"] = False
         g.speedBar.y["CanMaximize"] = False
         g.speedBar.y["CanMove"] = False
         g.speedBar.y["CanResize"] = False
         g.speedBar.y["Echo"] = False
         g.speedBar.y["HasShadow"] = False
         g.speedBar.y["HasFrame"] = False    ; IF Framed, window is *5* rows!!!
         g.speedBar.y["Style"] = g.appColors.y[1001]
      Window CREATE  FLOATING @ -200,-200
                     HEIGHT 1 WIDTH 56
                     ATTRIBUTES g.speedBar.y To g.handles.y["SpeedBar"]
   ENDIF
   Canvas ON                                 ; Show screen
   IF IsWindow(current.w) THEN
      Window SELECT current.w                ; Restore original Window
      Window SELECT current.w                ; Restore original Window
   ELSE
      SetCanvas DEFAULT
   ENDIF
   Return
ENDPROC
?? "\004"
WriteLib libname.a wsWindowSetup.u
; ============================================================================
;       TITLE: wsZoom.l                  (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false IF Value located
; DESCRIPTION: Substitue Zoom procedure to catch problems while in a WAIT
; ----------------------------------------------------------------------------
PROC wsZoom.l(                   ; Replacement for Zoom command
         type.a)                 ; First or Next
Private  n2,
         match.l,                ; Logical true/false IF match found
         n,                      ; Assigned by GETCHAR().
         window.a,               ; Message returned by Window()
         fieldView.l,            ; Keeps track of fieldview status while in zoom prompt.
         event.y
   match.l = false
   IF NImageRecords() < 2 or ColNo() = 1 THEN
      msWorking.u("Sorry, you cannot Search in RecNo Field, or in 1-record Table",79,3,3)
   ELSE
      IF Upper(type.a) = "NEXT" THEN
         Message "Searching for Next Value..."
         ZoomNext
         window.a = Window()
         match.l = IsBlank(window.a)
      ELSE
         Zoom
         IF NOT IsBlank(MenuChoice()) THEN
            CtrlBackSpace                        ; erase previous value
         ENDIF
         fieldView.l = false
         WHILE true
            GetEvent
               Key "ALL"
               Message "ALL"
            To event.y
            IF event.y["Type"] = "KEY" THEN
               n = event.y["KEYCODE"]
            ENDIF
            SWITCH
               CASE event.y["Type"] = "MESSAGE" AND
                    event.y["Message"] = "CLOSE" :
                  window.a = Window()
                  match.l = IsBlank(window.a)
                  QUITLOOP
               CASE n = -108 OR
                  n = 6      :       ; [Alt+F5] fieldview or [Ctrl+F].
                     FieldView                    ; Press the key.
                     fieldView.l = NOT fieldView.l ; Fieldview is started/finished.
               CASE n = -71 OR
                  n = -75 OR
                  n = -77 OR
                  n = -79 OR
                  n = -82 OR
                  n = -83    :
                  KeyPress n
               CASE n < 0 OR
                  n = 15     :                ; Includes unwanted function keys & ^O.
                  Beep                          ; Beep on error.
               CASE fieldView.l AND
                  n = 13     :                ; User pressed [Enter] while in fieldview.
                  Enter                         ; End field view.
                  fieldView.l = False
               CASE n = 13     :                ; User pressed [Enter].
                  Enter                         ; Press the key as IF the user typed it.
                  window.a = Window()
                  match.l = IsBlank(window.a)
                  QUITLOOP
               CASE n = 27     :                ; Pressed [Esc].
                  Esc                           ; Get out of zoom with Esc.
                  window.a = "Zoom Canceled"
                  match.l = false
                  QUITLOOP
               OTHERWISE       :                ; Any legitimate key.
                  KeyPress n                    ; Press the user's key.
            ENDSWITCH
         ENDWHILE
      ENDIF
   ENDIF
   IF match.l THEN
      Message "Value located..."
   ENDIF
   Return match.l
ENDPROC
WriteLib libname.a wsZoom.l
?? "\004"
