; ****************************************************************************
; SCRIPT NAME: ds4_MSG.sc                (c) 1992, 1993 DataStar International
; APPDEV TEAM: Dan Paolini, David Kelton, Micah Bleecher, Patty Paolini
; APPLICATION: DataStar Utilities for Paradox 4
; DESCRIPTION: Contains the following Dialog Box & Messaging procedures:
;                 dbAlert.l
;                 dbButtonPress.v
;                 dbEventHandler.l
;                 dbPaletteSet.u
;                 msAlertDialog.l
;                 msConfirm.l
;                 msContinue.u
;                 msIcon.a
;                 msPauser.u
;                 msProgressBar.u
;                 msScreenBlanker.u
;                 msScreenTimeOut.l
;                 msShortCuts.a
;                 msSplashWindow.u
;                 msTeleType.u
;                 msTickerTape.u
;                 msWorking.u
;                 msWorkingClear.u
;                 msWrap.a
; ============================================================================
? Format("w40"," ds4_MSG.sc  - dBox/Messaging Routines")
IF NOT IsAssigned(libname.a) THEN
   Beep Beep Beep QUIT "Variable \"libname.a\" is not assigned!.."
ENDIF
IF NOT IsFile(libname.a+".LIB") THEN
   CreateLib libname.a Size 640
ENDIF
@ Row(),40
; ============================================================================
;       TITLE: dbAlert.l               (c) 1992, 1993 DataStar International
;     RETURNS: True, for dBox Event Handler
; DESCRIPTION: Dialog Event Handler proc for IDLE event Alerts
; ----------------------------------------------------------------------------
PROC dbAlert.l()                 ; Idle Alert called from Event Handler
Private  n1, n2                  ; Transient loop counter
;Global  alert.n                 ; Alert Value from dBox (0 - 5)
;        onceFlag.l              ; For non-continuous Alert (1, 2)
   IF NOT IsAssigned(onceFlag.l) THEN
      onceFlag.l = true
   ENDIF
   SWITCH
      CASE alert.n = 1 AND onceFlag.l :
         Beep Sleep 50
         Beep Sleep 50
         Beep
         onceFlag.l = false            ; Turns off subsequent Alerts
      CASE alert.n = 2 AND onceFlag.l :
         Sound 770 150
         Sound 440 150
         Sound 770 150
         Sound 440 150
         Sound 770 150
         onceFlag.l = false            ; Turns off subsequent Alerts
      CASE alert.n = 3  :
         Beep Sleep 50 Beep Sleep 1000
      CASE alert.n = 4  :
         Sound 300 50 Sleep 100
         Sound 300 50 Sleep 100
         Sound 150 50 Sleep 100
         Sound 150 50 Sleep 100
         Sleep 200
      CASE alert.n = 5  :
         Sound 770 150
         Sound 440 150
      CASE alert.n = 86 and onceFlag.l :
         FOR n1 From 4 To 0 Step -1
            FOR n2 From 11 To 0 Step -1
               Sound Int(Pow(2,n1+n2/12)*110) 5
            ENDFOR
         ENDFOR
         Sound 10 3000
         onceFlag.l = false            ; Turns off subsequent Alerts
   ENDSWITCH
   Return true
ENDPROC
?? "\004"
WriteLib libname.a dbAlert.l
; ============================================================================
;       TITLE: dbButtonPress.v         (c) 1992, 1993 DataStar International
;     RETURNS: Whatever value is passed as parameter
; DESCRIPTION: Adds 300 millisecond delay to PushButton press
; ----------------------------------------------------------------------------
PROC dbButtonPress.v(            ; Adds 300 ms delay to button press
         retval.v)               ; Value to assign to Pushbutton variable
   Sleep 300
   Return retval.v
ENDPROC
?? "\004"
WriteLib libname.a dbButtonPress.v
; ============================================================================
;       TITLE: dbEventHandler.l        (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false id dBox accepted
; DESCRIPTION: Generic Dialog Box Event Handler
; ----------------------------------------------------------------------------
PROC dbEventHandler.l(           ; Alert Siren in Idle Dialog Box
         type.a,                 ; EVENT, or TRIGGER Name
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null
Private  h,                      ; Transient window handle
         y,                      ; Transient window attributes dynarray
         retval.l,               ; Value to return
         dBoxColors.y,           ; Custom Dialog Box Color Palette
         procTag.a               ; Trigger name, or event type
;Global  alert.n                 ; Alert Value from dBox (0 - 5)
;        onceFlag.l              ; For non-continuous Alert (1, 2)
;        dBoxPalette.a           ; Palette name for custom colors
;        startTicks.n             ; Starting Ticks, if assigned, enables timeout
;        frameTag.a              ; Can be used by calling proc to paint frame
;        topRow.n
;        leftCol.n
   retval.l = true
   SWITCH
      CASE type.a = "OPEN" :
         IF IsAssigned(dBoxProcs.y["OPEN"]) THEN
            ExecProc dBoxProcs.y["OPEN"]
            retval.l = retval
         ELSE
            Window Handle Dialog To h
            DynArray y[]
               y["OriginRow"] = topRow.n
               y["OriginCol"] = leftCol.n
            IF IsAssigned(dBoxPalette.a) AND NOT IsBlank(dBoxPalette.a) THEN
               dbPaletteSet.u(dBoxPalette.a)
               Window SetColors h From dBoxColors.y
               RepaintDialog
            ENDIF
            Window SetAttributes h From y
         ENDIF
      CASE type.a = "EVENT" AND event.v["Type"] = "IDLE" :
         IF IsAssigned(dBoxProcs.y["IDLE"]) THEN
            ExecProc dBoxProcs.y["IDLE"]
            retval.l = retval
         ELSE
            IF IsAssigned(startTicks.n) AND Ticks() > startTicks.n + 600000 THEN
               CancelDialog
            ENDIF
         ENDIF
      OTHERWISE :
         procTag.a = IIF(type.a = "EVENT",event.v["Type"],type.a)
         IF IsAssigned(dBoxProcs.y[procTag.a]) THEN
            ExecProc dBoxProcs.y[procTag.a]
            retval.l = retval
         ENDIF
   ENDSWITCH
   frameTag.a = tag.a
   RepaintDialog
   Return retval.l
ENDPROC
?? "\004"
WriteLib libname.a dbEventHandler.l
; ============================================================================
;       TITLE: dbPaletteSet.u          (c) 1992, 1993 DataStar International
;     RETURNS: No value (sets local global dynarray:  dBoxColors.y)
; DESCRIPTION: Creates a dynarray of dialog box colors based upon palette.a
; ----------------------------------------------------------------------------
PROC dbPaletteSet.u(
         palette.a)
;Global  dBoxColors.y
   DynArray dBoxColors.y[]
   SWITCH
      CASE Upper(palette.a) = "BLUE" :
         dBoxColors.y["1"]  = 27   ; Active dialog box frame and title
         dBoxColors.y["2"]  = 26   ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 48   ; Scroll bar
         dBoxColors.y["4"]  = 63   ; Scroll bar controls
         dBoxColors.y["5"]  = 31   ; Default background text
         dBoxColors.y["6"]  = 23   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 31   ; Label when linked control is active
         dBoxColors.y["8"]  = 30   ; Label hot key
         dBoxColors.y["9"]  = 32   ; Text for normal   push button label
         dBoxColors.y["10"] = 43   ; Text for default  push button label
         dBoxColors.y["11"] = 47   ; Text for selected push button label
         dBoxColors.y["13"] = 46   ; Hot key for push button label
         dBoxColors.y["14"] = 16   ; Button shadow
         dBoxColors.y["15"] = 27   ; Normal      radio button / check box
         dBoxColors.y["16"] = 31   ; Highlighted radio button / check box
         dBoxColors.y["17"] = 30   ; Hot key for radio button / check box
         dBoxColors.y["18"] = 63   ; Normal   typein box text
         dBoxColors.y["19"] = 47   ; Selected typein box text
         dBoxColors.y["20"] = 49   ; Typein box arrows
         dBoxColors.y["25"] = 48   ; Normal   pick list item text
         dBoxColors.y["26"] = 47   ; Selected text when pick list is active
         dBoxColors.y["27"] = 63   ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 49   ; Column dividers
         frameHigh.n        = 25   ; Frame highlight (sunny side)
         frameLow.n         = 16   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "RED" :
         dBoxColors.y["1"]  = 79   ; Active dialog box frame and title
         dBoxColors.y["2"]  = 75   ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 112  ; Scroll bar
         dBoxColors.y["4"]  = 127  ; Scroll bar controls
         dBoxColors.y["5"]  = 71   ; Default background text
         dBoxColors.y["6"]  = 65   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 79   ; Label when linked control is active
         dBoxColors.y["8"]  = 78   ; Label hot key
         dBoxColors.y["9"]  = 32   ; Text for normal   push button label
         dBoxColors.y["10"] = 43   ; Text for default  push button label
         dBoxColors.y["11"] = 47   ; Text for selected push button label
         dBoxColors.y["13"] = 46   ; Hot key for push button label
         dBoxColors.y["14"] = 64   ; Button shadow
         dBoxColors.y["15"] = 71   ; Normal      radio button / check box
         dBoxColors.y["16"] = 79   ; Highlighted radio button / check box
         dBoxColors.y["17"] = 78   ; Hot key for radio button / check box
         dBoxColors.y["18"] = 31   ; Normal   typein box text
         dBoxColors.y["19"] = 47   ; Selected typein box text
         dBoxColors.y["20"] = 27   ; Typein box arrows
         dBoxColors.y["25"] = 112  ; Normal   pick list item text
         dBoxColors.y["26"] = 31   ; Selected text when pick list is active
         dBoxColors.y["27"] = 127  ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 116  ; Column dividers
         frameHigh.n        = 76   ; Frame highlight (sunny side)
         frameLow.n         = 64   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "CYAN" :
         dBoxColors.y["1"]  = 63   ; Active dialog box frame and title
         dBoxColors.y["2"]  = 59   ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 23   ; Scroll bar
         dBoxColors.y["4"]  = 31   ; Scroll bar controls
         dBoxColors.y["5"]  = 49   ; Default background text
         dBoxColors.y["6"]  = 48   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 63   ; Label when linked control is active
         dBoxColors.y["8"]  = 62   ; Label hot key
         dBoxColors.y["9"]  = 32   ; Text for normal   push button label
         dBoxColors.y["10"] = 43   ; Text for default  push button label
         dBoxColors.y["11"] = 47   ; Text for selected push button label
         dBoxColors.y["13"] = 46   ; Hot key for push button label
         dBoxColors.y["14"] = 48   ; Button shadow
         dBoxColors.y["15"] = 49   ; Normal      radio button / check box
         dBoxColors.y["16"] = 63   ; Highlighted radio button / check box
         dBoxColors.y["17"] = 62   ; Hot key for radio button / check box
         dBoxColors.y["18"] = 31   ; Normal   typein box text
         dBoxColors.y["19"] = 47   ; Selected typein box text
         dBoxColors.y["20"] = 27   ; Typein box arrows
         dBoxColors.y["25"] = 112  ; Normal   pick list item text
         dBoxColors.y["26"] = 31   ; Selected text when pick list is active
         dBoxColors.y["27"] = 127  ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 115  ; Column dividers
         frameHigh.n        = 59   ; Frame highlight (sunny side)
         frameLow.n         = 48   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "GREEN" :
         dBoxColors.y["1"]  = 47   ; Active dialog box frame and title
         dBoxColors.y["2"]  = 43   ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 96   ; Scroll bar
         dBoxColors.y["4"]  = 111  ; Scroll bar controls
         dBoxColors.y["5"]  = 32   ; Default background text
         dBoxColors.y["6"]  = 42   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 47   ; Label when linked control is active
         dBoxColors.y["8"]  = 46   ; Label hot key
         dBoxColors.y["9"]  = 23   ; Text for normal   push button label
         dBoxColors.y["10"] = 29   ; Text for default  push button label
         dBoxColors.y["11"] = 31   ; Text for selected push button label
         dBoxColors.y["13"] = 30   ; Hot key for push button label
         dBoxColors.y["14"] = 32   ; Button shadow
         dBoxColors.y["15"] = 33   ; Normal      radio button / check box
         dBoxColors.y["16"] = 47   ; Highlighted radio button / check box
         dBoxColors.y["17"] = 46   ; Hot key for radio button / check box
         dBoxColors.y["18"] = 112  ; Normal   typein box text
         dBoxColors.y["19"] = 31   ; Selected typein box text
         dBoxColors.y["20"] = 114  ; Typein box arrows
         dBoxColors.y["25"] = 112  ; Normal   pick list item text
         dBoxColors.y["26"] = 31   ; Selected text when pick list is active
         dBoxColors.y["27"] = 127  ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 114  ; Column dividers
         frameHigh.n        = 42   ; Frame highlight (sunny side)
         frameLow.n         = 32   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "BROWN" :
         dBoxColors.y["1"]  = 111  ; Active dialog box frame and title
         dBoxColors.y["2"]  = 107  ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 112  ; Scroll bar
         dBoxColors.y["4"]  = 127  ; Scroll bar controls
         dBoxColors.y["5"]  = 96   ; Default background text
         dBoxColors.y["6"]  = 97   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 111  ; Label when linked control is active
         dBoxColors.y["8"]  = 110  ; Label hot key
         dBoxColors.y["9"]  = 32   ; Text for normal   push button label
         dBoxColors.y["10"] = 43   ; Text for default  push button label
         dBoxColors.y["11"] = 47   ; Text for selected push button label
         dBoxColors.y["13"] = 46   ; Hot key for push button label
         dBoxColors.y["14"] = 96   ; Button shadow
         dBoxColors.y["15"] = 97   ; Normal      radio button / check box
         dBoxColors.y["16"] = 111  ; Highlighted radio button / check box
         dBoxColors.y["17"] = 110  ; Hot key for radio button / check box
         dBoxColors.y["18"] = 112  ; Normal   typein box text
         dBoxColors.y["19"] = 47   ; Selected typein box text
         dBoxColors.y["20"] = 118  ; Typein box arrows
         dBoxColors.y["25"] = 112  ; Normal   pick list item text
         dBoxColors.y["26"] = 47   ; Selected text when pick list is active
         dBoxColors.y["27"] = 127  ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 118  ; Column dividers
         frameHigh.n        = 110  ; Frame highlight (sunny side)
         frameLow.n         = 96   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "MAGENTA" :
         dBoxColors.y["1"]  = 95   ; Active dialog box frame and title
         dBoxColors.y["2"]  = 91   ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 23   ; Scroll bar
         dBoxColors.y["4"]  = 31   ; Scroll bar controls
         dBoxColors.y["5"]  = 80   ; Default background text
         dBoxColors.y["6"]  = 81   ; Label when linked control is inactive
         dBoxColors.y["7"]  = 95   ; Label when linked control is active
         dBoxColors.y["8"]  = 94   ; Label hot key
         dBoxColors.y["9"]  = 23   ; Text for normal   push button label
         dBoxColors.y["10"] = 29   ; Text for default  push button label
         dBoxColors.y["11"] = 31   ; Text for selected push button label
         dBoxColors.y["13"] = 30   ; Hot key for push button label
         dBoxColors.y["14"] = 80   ; Button shadow
         dBoxColors.y["15"] = 81   ; Normal      radio button / check box
         dBoxColors.y["16"] = 95   ; Highlighted radio button / check box
         dBoxColors.y["17"] = 94   ; Hot key for radio button / check box
         dBoxColors.y["18"] = 112  ; Normal   typein box text
         dBoxColors.y["19"] = 31   ; Selected typein box text
         dBoxColors.y["20"] = 113  ; Typein box arrows
         dBoxColors.y["25"] = 112  ; Normal   pick list item text
         dBoxColors.y["26"] = 31   ; Selected text when pick list is active
         dBoxColors.y["27"] = 127  ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 117  ; Column dividers
         frameHigh.n        = 93   ; Frame highlight (sunny side)
         frameLow.n         = 80   ; Frame lowlight (shadow side)
      CASE Upper(palette.a) = "GRAY" :
         dBoxColors.y["1"]  = 127  ; Active dialog box frame and title
         dBoxColors.y["2"]  = 123  ; Selected dialog box frame when dragging
         dBoxColors.y["3"]  = 19   ; Scroll bar
         dBoxColors.y["4"]  = 27   ; Scroll bar controls
         dBoxColors.y["5"]  = 112  ; Default background text
         dBoxColors.y["6"]  = 113  ; Label when linked control is inactive
         dBoxColors.y["7"]  = 127  ; Label when linked control is active
         dBoxColors.y["8"]  = 126  ; Label hot key
         dBoxColors.y["9"]  = 32   ; Text for normal   push button label
         dBoxColors.y["10"] = 43   ; Text for default  push button label
         dBoxColors.y["11"] = 47   ; Text for selected push button label
         dBoxColors.y["13"] = 46   ; Hot key for push button label
         dBoxColors.y["14"] = 112  ; Button shadow
         dBoxColors.y["15"] = 112  ; Normal      radio button / check box
         dBoxColors.y["16"] = 127  ; Highlighted radio button / check box
         dBoxColors.y["17"] = 126  ; Hot key for radio button / check box
         dBoxColors.y["18"] = 31   ; Normal   typein box text
         dBoxColors.y["19"] = 47   ; Selected typein box text
         dBoxColors.y["20"] = 26   ; Typein box arrows
         dBoxColors.y["25"] = 48   ; Normal   pick list item text
         dBoxColors.y["26"] = 47   ; Selected text when pick list is active
         dBoxColors.y["27"] = 63   ; Selected text when pick list is inactive
         dBoxColors.y["28"] = 55   ; Column dividers
         frameHigh.n        = 127  ; Frame highlight (sunny side)
         frameLow.n         = 112  ; Frame lowlight (shadow side)
   ENDSWITCH
   Return
ENDPROC
?? "\004"
WriteLib libname.a dbPaletteSet.u
; ============================================================================
;       TITLE: msAbortRetry.l                  (c) 1993 DataStar International
;     RETURNS: Logical true/false if User said RETRY
; DESCRIPTION: Generic ABORT or RETRY Message routine
; ----------------------------------------------------------------------------
PROC msAbortRetry.l(             ; Abort/Retry DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a)              ; Message to display (< 70 chars)
Private  width.n,                ; Width of Dialog Box
         button.l,               ; Value of selected Pushbutton
         icon.a,                 ; Message Box Icon
         frameHigh.n,            ; Chiseled Frame Highlight
         frameLow.n              ; Chiseled Frame Lowlight
;Global  g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("?")

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   button.l    = false
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)
   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a Attribute frameLow.n + 14 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a Attribute frameLow.n + 15 1,15,5,54

      PushButton  @ 7,14 Width 9 "~A~bort"
         CANCEL Value dbButtonPress.v(false) Tag "BUTTON"
      To button.l

      PushButton  @ 7,35 Width 9 "~R~etry"
         OK Value dbButtonPress.v(true) Tag "BUTTON"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return button.l
ENDPROC
?? "\004"
WriteLib libname.a msAbortRetry.l
; ============================================================================
;       TITLE: msAbortRetryIgnore.l            (c) 1993 DataStar International
;     RETURNS: ABORT RETRY IGNORE
; DESCRIPTION: Generic ABORT/RETRY/IGNORE Message routine
; ----------------------------------------------------------------------------
PROC msAbortRetryIgnore.a(       ; Abort/Retry/Ignore DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a)              ; Message to display (< 70 chars)
Private  width.n,                ; Width of Dialog Box
         button.a,               ; Value of selected Pushbutton
         icon.a,                 ; Message Box Icon
         frameHigh.n,            ; Chiseled Frame Highlight
         frameLow.n              ; Chiseled Frame Lowlight
;Global  g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("?")

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   button.a    = "ABORT"
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)
   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a Attribute frameLow.n + 14 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a Attribute frameLow.n + 15 1,15,5,54

      PushButton  @ 7,8 Width 10 "~A~bort"
         CANCEL Value dbButtonPress.v("ABORT") Tag "BUTTON"
      To button.a

      PushButton  @ 7,24 Width 10 "~R~etry"
         OK Value dbButtonPress.v("RETRY") Tag "BUTTON"
      To button.a

      PushButton  @ 7,40 Width 10 "~I~gnore"
         OK Value dbButtonPress.v("IGNORE") Tag "BUTTON"
      To button.a
   ENDDIALOG
   msWorkingClear.u()
   Return button.l
ENDPROC
?? "\004"
WriteLib libname.a msAbortRetryIgnore.a
; ============================================================================
;       TITLE: msAlertDialog.l         (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Dialog PROC for IDLE events in Messages
; ----------------------------------------------------------------------------
PROC msAlertDialog.l(            ; DBox EventHandler for non-icon messages
         type.a,                 ; EVENT or TRIGGER
         tag.a,                  ; Control element tag or null
         event.v,                ; DynArray of GetEvent, or control value
         element.a)              ; Checkbox label or null
Private  h, y
;Global  alert.n                 ; Alert Value from dBox (0 - 5)
;        onceFlag.l              ; For non-continuous Alert (1, 2)
   IF NOT IsAssigned(onceFlag.l) THEN
      onceFlag.l = true
   ENDIF
   SWITCH
      CASE alert.n = 1 AND onceFlag.l :
         Beep Sleep 50
         Beep Sleep 50
         Beep
         onceFlag.l = false            ; Turns off subsequent Alerts
      CASE alert.n = 2 AND onceFlag.l :
         Sound 770 150
         Sound 440 150
         Sound 770 150
         Sound 440 150
         Sound 770 150
         onceFlag.l = false            ; Turns off subsequent Alerts
      CASE alert.n = 3  :
         Beep Sleep 50 Beep Sleep 300
      CASE alert.n = 4  :
         Sound 300 50 Sleep 100
         Sound 300 50 Sleep 100
         Sound 150 50 Sleep 100
         Sound 150 50 Sleep 100
         Sleep 200
      CASE alert.n = 5  :
         Sound 770 150
         Sound 440 150
      CASE alert.n = 86 and onceFlag.l :
         FOR n1 From 4 To 0 Step -1
            FOR n2 From 11 To 0 Step -1
               Sound Int(Pow(2,n1+n2/12)*110) 5
            ENDFOR
         ENDFOR
         Sound 10 3000
         onceFlag.l = false            ; Turns off subsequent Alerts
   ENDSWITCH
   Return true
ENDPROC
?? "\004"
WriteLib libname.a msAlertDialog.l
; ============================================================================
;       TITLE: msConfirm.l               (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false if User Confirmed/Canceled
; DESCRIPTION: Generic Continue-or-Cancel Message routine
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
; ----------------------------------------------------------------------------
PROC msConfirm.l(                ; Confirmation DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a,              ; Message to display (< 70 chars)
         msgColor.n,             ; Color for message (not DialogBox!)
         dBoxPalette.a,          ; Palette name for custom dBox window colors
         alert.n,                ; Sound level of Alert (0 - 4)
         okLabel.a,              ; Label of CONTINUE Pushbutton
         cxLabel.a,              ; Label of CANCEL Pushbutton
         confirm.l)              ; Should Confirm be default?
Private  width.n,                ; Width of Dialog Box
         a1, a2,                 ; Match variables
         n1, n2,                 ; Button length comparisons
         buttonLength.n,         ; Width of Pushbuttons
         button.l,               ; Value of selected Pushbutton
         onceFlag.l,             ; True = Non-continuous Alert
         icon.a,
         frameHigh.n,
         frameLow.n
;Global  g.appColors.y           ; Global Application Colors
;        g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      icon.a = msIcon.a(message.a)
      message.a = msShortCuts.a(message.a)
   ELSE
      IF alert.n > 3 THEN
         icon.a = msIcon.a("!")
      ELSE
         icon.a = msIcon.a("?")
      ENDIF
   ENDIF

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   onceFlag.l  = alert.n < 3 OR alert.n > 50
   button.l    = false
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)

   DynArray dBoxProcs.y[]
      dBoxProcs.y["IDLE"] = "dbAlert.l"

   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   a1 = ""
   a2 = okLabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n1 = Len(a1+a2)

   a1 = ""
   a2 = cxLabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n2 = Len(a1+a2)
   buttonLength.n = Max(n1,n2)+4

   SHOWDIALOG title.a
      Proc "dbEventHandler.l"
         IDLE
         TRIGGER "Open"
      @ -200,-200
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a Attribute msgColor.n 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a Attribute msgColor.n 1,15,5,54

      PushButton  @ 7,10
         Width buttonLength.n IIF(confirm.l,okLabel.a,cxLabel.a)
         OK Value dbButtonPress.v(confirm.l) Tag "BUTTON"
      To button.l

      PushButton  @ 7,48 - buttonLength.n
         Width buttonLength.n IIF(confirm.l,cxLabel.a,okLabel.a)
         OK Value dbButtonPress.v(NOT confirm.l) Tag "BUTTON"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return button.l
ENDPROC
?? "\004"
WriteLib libname.a msConfirm.l
; ============================================================================
;       TITLE: msContinue.u              (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
; ----------------------------------------------------------------------------
PROC msContinue.u(               ; Generic Continue DialogBox
         title.a,                ; Title for dBox, "" for Default
         message.a,              ; Message to display
         msgColor.n,             ; Color for Message (not DialogBox!)
         dBoxPalette.a,          ; Dynarray of custom colors
         alert.n)                ; Sound level of Alert (0 - 5)
Private  icon.a,
         button.l,               ; Value of selected Pushbutton
         onceFlag.l,             ; True = non-continuous alert
         frameHigh.n,
         frameLow.n,
         topRow.n,
         leftCol.n
;Global  g.appColors.y           ; Global Application Colors
;        g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF Len(message.a) = 1 THEN
      icon.a = msIcon.a(message.a)
      message.a = msShortCuts.a(message.a)
   ELSE
      IF alert.n > 3 THEN
         icon.a = msIcon.a("!")
      ELSE
         icon.a = msIcon.a("I")
      ENDIF
   ENDIF

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   DynArray dBoxProcs.y[]
      dBoxProcs.y["IDLE"] = "dbAlert.l"

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   onceFlag.l  = alert.n < 3 OR alert.n > 50
   message.a   = msWrap.a(message.a)
   button.l    = true
   topRow.n    = 7
   leftCol.n   = Int((g.sysInfo.y["ScreenWidth"]-60)/2)
   title.a     = IIF(title.a = "", "Press <Enter> to Continue", title.a)

   SHOWDIALOG title.a
      Proc "dbEventHandler.l"
         Idle Trigger "OPEN"    ; Wait for Key Alert
      @ -200,-200
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a
                     Attribute msgColor.n 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a
                     Attribute msgColor.n 1,15,5,54

      PushButton @ 7,23
         Width 12 "~C~ontinue"
         OK Default Value dbButtonPress.v(true) Tag "OK"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a msContinue.u
?? "\004"
; ============================================================================
;       TITLE: msIcon.a                (c) 1992, 1993 DataStar International
;     RETURNS: String containing message box icon
; DESCRIPTION: Assigns Icon based upon icon code
; ----------------------------------------------------------------------------
PROC msIcon.a(                   ; Create icon for message dBoxes
         icon.a)
   icon.a = Upper(icon.a)
   SWITCH
      CASE Search(icon.a,"IWM") <> 0 :
         icon.a = "        " +
                  "       " +
                  "        " +
                  "        " +
                  "      "
      CASE Search(icon.a,"DKA?") <> 0 :
         icon.a = "    " +
                  "       " +
                  "      " +
                  "        " +
                  "        "
      CASE Search(icon.a,"!U") <> 0 :
         icon.a = "        " +
                  "      " +
                  "        " +
                  "        " +
                  "        "
      CASE Search(icon.a,"PN") <> 0 :
         icon.a = "  " +
                  "  " +
                  "  " +
                  "Ŀ" +
                  ""
      CASE Search(icon.a,"CR") <> 0 :
         icon.a = "       " +
                  "     " +
                  "      " +
                  "     " +
                  "         "
      CASE Search(icon.a,"S") <> 0 :
         icon.a = "    " +
                  "     " +
                  " STOP! " +
                  "     " +
                  "    "
      OTHERWISE :
         icon.a = "        " +
                  "    " +
                  "  " +
                  "      " +
                  "         "
   ENDSWITCH
   Return icon.a
ENDPROC
?? "\004"
WriteLib libname.a msIcon.a
; ============================================================================
;       TITLE: msInfo.u                        (c) 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
; ----------------------------------------------------------------------------
PROC msInfo.u(                   ; Generic Continue DialogBox
         title.a,                ; Title for dBox, "" for Default
         message.a)              ; Message to display
Private  icon.a,
         button.l,               ; Value of selected Pushbutton
         frameHigh.n,
         frameLow.n,
         topRow.n,
         leftCol.n
;Global  g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("I")

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   message.a   = msWrap.a(message.a)
   button.l    = true
   topRow.n    = 7
   leftCol.n   = Int((g.sysInfo.y["ScreenWidth"]-60)/2)
   title.a     = IIF(title.a = "", "Press <Enter> to Continue", title.a)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a
                     Attribute frameLow.n + 14 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a
                     Attribute frameLow.n + 15 1,15,5,54

      PushButton @ 7,24 Width 10 "~O~K"
         OK Default Value dbButtonPress.v(true) Tag "OK"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a msInfo.u
?? "\004"
; ============================================================================
;       TITLE: msPauser.u              (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Pauses for specified time, but continues with keypress
; ----------------------------------------------------------------------------
PROC msPauser.u(                 ; Generic Wait for Event, with timeout
         seconds.n)              ; Maximum number of seconds to wait
Private  count.n,                ; Loop counter
         y                       ; Event Dynarray
   WHILE CharWaiting()                    ; Clear keyboard buffer
      retval = GetChar()
   ENDWHILE
   Message "Please MouseClick or Press Any Key to Continue..."
   count.n = 0
   WHILE count.n < (40 * seconds.n)
      GetEvent ALL To y
      IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
         y["Type"] = "KEY" OR y["Type"] = "MESSAGE" THEN
         QUITLOOP
      ENDIF
      Sleep 20
      count.n = count.n + 1
   ENDWHILE
   Message ""
   Return
ENDPROC
WriteLib libname.a msPauser.u
?? "\004"
; ============================================================================
;       TITLE: msProgressBar.u()       (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Displays progress bar on screen indicating to user
;              processing messages and percent complete.
; ----------------------------------------------------------------------------
PROC msProgressBar.u(            ; Creates Progress Bar thermometer
         topRow.n,               ; Top row for Window
         leftCol.n,              ; Left column for Window
         title.a,                ; Title for bar
         message.a,              ; Message, below title
         winColor.n,             ; Color of Window, includes Title
         barColor.n,             ; Color of Bar
         msgColor.n,             ; Color of Message
         percentDone.n)          ; 0 = SetUpWindow and MoveIntoPosition
Private  y,                      ; Throwaway Window DynArray
         oldCanvas.h,            ; Current Canvas
         oldWindow.h             ; Current Window
;Global  g.sysInfo.y             ; SysInfo
;        g.handles.y             ; Window Handles

   oldWindow.h = GetWindow()
   oldCanvas.h = GetCanvas()
   IF percentDone.n = -1 THEN
      Window Select g.handles.y["PROGRESS"]
      SetCanvas g.handles.y["PROGRESS"]
      WinClose
   ELSE
      IF NOT IsAssigned(g.sysInfo.y) THEN
         SysInfo To g.sysInfo.y
      ENDIF

      Dynarray y[]
         y["hasframe"] = false
         y["Style"]    = winColor.n
         y["height"]   = 8
         y["width"]    = 64

      IF NOT IsAssigned(g.handles.y) Then
         DynArray g.handles.y[]
      ENDIF

      IF NOT IsAssigned(g.handles.y["PROGRESS"]) OR
         NOT IsWindow(g.handles.y["PROGRESS"])  THEN
         Window Create Floating @ -200, -200
               Attributes y To g.handles.y["PROGRESS"]
      ENDIF

      Window Select g.handles.y["PROGRESS"]
      SetCanvas g.handles.y["PROGRESS"]
      Canvas Off

      IF topRow.n = 999 THEN
         topRow.n = 7
      ENDIF

      IF leftCol.n = 999 THEN
         leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-64)/2)
      ENDIF

      IF percentDone.n = 0 THEN     ; 0 = 1st time through Setup
         Window Move g.handles.y["PROGRESS"] To topRow.n,leftCol.n

         @ 0,0  ??"Ŀ"
         @ 1,0  ??"                                                              "
         @ 2,0  ??"                                                              "
         @ 3,0  ??"                                                              "
         @ 4,0  ??"          "
         @ 5,0  ??"      0           25         50          75          100      "
         @ 6,0  ??"                      Percent Complete                        "
         @ 7,0  ??""

         @ 1,2 ?? Format("ac,w60",Title.a)
         PaintCanvas Attribute winColor.n 0,0,6,63
         PaintCanvas Attribute barColor.n 4,6,4,57

         PaintCanvas Border Attribute 112 0,0,7,63
         PaintCanvas Attribute 127 0,0,7,0
         PaintCanvas Attribute 127 7,0,7,62
      ENDIF

      Style Attribute msgColor.n
         @ 2,2 ?? Format("ac,w60",message.a)
      Style Attribute barColor.n
         @ 4,7 ?? Fill("\219",Min(Int(percentDone.n/2),50))
      Style

      Canvas On
   ENDIF
   IF IsWindow(oldCanvas.h) THEN
      SetCanvas oldCanvas.h
   ELSE
      SetCanvas Default
   ENDIF
   IF IsWindow(oldWindow.h) THEN
      Window Select oldWindow.h
   ENDIF
   Return
ENDPROC
WriteLib libname.a msProgressBar.u
?? "\004"
; ============================================================================
;       TITLE: msQuestion.l                    (c) 1993 DataStar International
;     RETURNS: Logical true/false if User said YES
; DESCRIPTION: Generic YES or NO Message routine
; ----------------------------------------------------------------------------
PROC msQuestion.l(               ; Confirmation DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a)              ; Message to display (< 70 chars)
Private  width.n,                ; Width of Dialog Box
         button.l,               ; Value of selected Pushbutton
         icon.a,
         frameHigh.n,
         frameLow.n,
         topRow.n,
         leftCol.n
;Global  g.appColors.y           ; Global Application Colors
;        g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("?")

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   button.l    = false
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)
   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a Attribute frameLow.n + 14 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a Attribute frameLow.n + 15 1,15,5,54

      PushButton  @ 7,14 Width 8 "~Y~es"
         OK Value dbButtonPress.v(true) Tag "BUTTON"
      To button.l

      PushButton  @ 7,36 Width 8 "~N~o"
         OK Value dbButtonPress.v(false) Tag "BUTTON"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return button.l
ENDPROC
?? "\004"
WriteLib libname.a msQuestion.l
; ============================================================================
;       TITLE: msScreenBlanker.u       (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Snaking worm screen blanker
; ----------------------------------------------------------------------------
PROC msScreenBlanker.u()         ; Screen blanking routine
Private  row.r,                  ; Row location array
         column.r,               ; Column location array
         n1, n2,                 ; Loop counters
         fill.a,                 ; Message fill string
         worm.r,                 ; Worm segment array
         direction.n,            ; Current direction
         oldDirection.n,         ; Last direction
         y,                      ; Getevent dynarray
         oldCanvas.h,            ; Previous Canvas
         oldWindow.h,            ; Previous Window
         height.n,
         width.n,
         blanker.h
;Global  g.sysInfo.y             ; SysInfo
;        g.handles.y             ; Window Handles

   oldWindow.h = GetWindow()
   oldCanvas.h = GetCanvas()
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo To g.sysInfo.y
   ENDIF
   height.n = g.sysInfo.y["ScreenHeight"]
   width.n = g.sysInfo.y["ScreenWidth"]

   DynArray w.y[]
      w.y["HasFrame"] = false
      w.y["HasShadow"] = false
      w.y["Style"]    = 15
      w.y["Height"]   = g.sysInfo.y["ScreenHeight"]
      w.y["Width"]    = g.sysInfo.y["ScreenWidth"]
   Window Create Floating @ 0,0 Attributes w.y to blanker.h

   Array worm.r[4]                        ; Set up worm using ASCII
      worm.r[1] = "\10\10"
      worm.r[2] = ""
      worm.r[3] = ""
      worm.r[4] = ""
   Array row.r[4]                         ; Initialize starting rows
      row.r[1] = 12
      row.r[2] = 12
      row.r[3] = 12
      row.r[4] = 12
   Array column.r[4]                      ; Initialize starting columns
      column.r[1] = 40
      column.r[2] = 42
      column.r[3] = 44
      column.r[4] = 46
   Style ATTRIBUTE 9
   fill.a = "  P R E S S   A N Y   K E Y   T O   R E T U R N  "
   oldDirection.n = 0                     ; Initialize
   WHILE NOT IsAssigned(g.debug.l) OR NOT g.debug.l
      direction.n = Int(Rand()*8)         ; Randomize next direction
      IF Mod(direction.n,4) = Mod(oldDirection.n,4) THEN
                                          ; Prevent same direct or reverse
         IF direction.n = 7 THEN
            direction.n = 0
         ELSE
            direction.n = direction.n + 1
         ENDIF
      ENDIF
      FOR n2 From 1 To 3
         Canvas OFF
         PaintCanvas Fill " " ATTRIBUTE 0 0,0,24,79   ; Black screen
         SWITCH                           ; Randomize and display message
            CASE Mod(direction.n,4) = 0 :
               PaintCanvas FILL Format("w80,ac",fill.a) ATTRIBUTE 79 0,0,0,79
            CASE Mod(direction.n,4) = 1 :
               PaintCanvas FILL fill.a+" " ATTRIBUTE 95 0,0,24,1
            CASE Mod(direction.n,4) = 2 :
               PaintCanvas FILL Format("w80,ac",fill.a) ATTRIBUTE 31 24,0,24,79
            CASE Mod(direction.n,4) = 3 :
               PaintCanvas FILL " "+fill.a ATTRIBUTE 47 0,78,24,79
         ENDSWITCH
         FOR n1 From 4 To 1 Step -1       ; Countdown loop places worm
            @ row.r[n1], column.r[n1] ?? worm.r[n1]
         ENDFOR
         Canvas ON                        ; Increment worm segment locations
         row.r[4] = row.r[3]
         row.r[3] = row.r[2]
         row.r[2] = row.r[1]
         column.r[4] = column.r[3]
         column.r[3] = column.r[2]
         column.r[2] = column.r[1]
         SWITCH                           ; Check for Out-of-bounds movement
            CASE direction.n = 0 :        ;  and then assign head position
               SWITCH
                  CASE row.r[1] > 1  : row.r[1] = row.r[1] - 1
                  CASE column.r[1] = width.n - 4 :
                     column.r[1] = width.n - 6
                  OTHERWISE          : column.r[1] = column.r[1] + 2
               ENDSWITCH
            CASE direction.n = 1 :
               SWITCH
                  CASE row.r[1] < 2
                   AND column.r[1] > width.n - 5 :
                     row.r[1] = 2
                     column.r[1] = width.n - 6
                  CASE row.r[1] < 2  :
                     column.r[1] = column.r[1] + 2
                  CASE column.r[1] > width.n - 5 :
                     row.r[1] = row.r[1] - 1
                  OTHERWISE          :
                     row.r[1] = row.r[1] - 1
                     column.r[1] = column.r[1] + 2
               ENDSWITCH
            CASE direction.n = 2 :
               SWITCH
                  CASE column.r[1] < width.n - 5 :
                     column.r[1] = column.r[1] + 2
                  CASE row.r[1] < 2  : row.r[1] = 2
                  OTHERWISE          : row.r[1] = row.r[1] - 1
               ENDSWITCH
            CASE direction.n = 3 :
               SWITCH
                  CASE row.r[1] > height.n - 3
                   AND column.r[1] > width.n - 5 :
                     row.r[1] = height.n - 3
                     column.r[1] = height.n - 6
                  CASE row.r[1] > height.n - 3 :
                     column.r[1] = column.r[1] + 2
                  CASE column.r[1] > width.n - 5 :
                     row.r[1] = row.r[1] + 1
                  OTHERWISE          :
                     row.r[1] = row.r[1] + 1
                     column.r[1] = column.r[1] + 2
               ENDSWITCH
            CASE direction.n = 4 :
               SWITCH
                  CASE row.r[1] < height.n - 2 : row.r[1] = row.r[1] + 1
                  CASE column.r[1] > width.n - 5 : column.r[1] = width.n - 6
                  OTHERWISE          : column.r[1] = column.r[1] + 2
               ENDSWITCH
            CASE direction.n = 5 :
               SWITCH
                  CASE row.r[1] > height.n - 3
                   AND column.r[1] < 3 :
                     row.r[1] = height.n - 3
                     column.r[1] = 4
                  CASE row.r[1] > height.n - 3 :
                     column.r[1] = column.r[1] - 2
                  CASE column.r[1] < 3  :
                     row.r[1] = row.r[1] + 1
                  OTHERWISE          :
                     row.r[1] = row.r[1] + 1
                     column.r[1] = column.r[1] - 2
               ENDSWITCH
            CASE direction.n = 6 :
               SWITCH
                  CASE column.r[1] > 3 : column.r[1] = column.r[1] - 2
                  CASE row.r[1] < 2 : row.r[1] = 2
                  OTHERWISE         : row.r[1] = row.r[1] - 1
               ENDSWITCH
            CASE direction.n = 7 :
               SWITCH
                  CASE row.r[1] < 2
                   AND column.r[1] < 3 :
                     row.r[1] = 2
                     column.r[1] = 4
                  CASE row.r[1] < 2 :
                     column.r[1] = column.r[1] - 2
                  CASE column.r[1] < 3 :
                     row.r[1] = row.r[1] - 1
                  OTHERWISE         :
                     row.r[1] = row.r[1] - 1
                     column.r[1] = column.r[1] - 2
               ENDSWITCH
         ENDSWITCH
         Sleep 500                        ; Pause 1/2 second (adjustable)
      ENDFOR
      oldDirection.n = direction.n                    ; Store previous direction
      GetEvent ALL To y
      IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
         y["Type"] = "KEY" THEN
         QUITLOOP
      ENDIF
   ENDWHILE
   IF IsWindow(oldCanvas.h) THEN
      SetCanvas oldCanvas.h
   ELSE
      SetCanvas Default
   ENDIF
   IF IsWindow(oldWindow.h) THEN
      Window Select oldWindow.h
   ENDIF
   Return
ENDPROC
WriteLib libname.a msScreenBlanker.u
?? "\004"
; ============================================================================
;       TITLE: msScreenTimeOut.l       (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Warning - the end is near!  Message
; ----------------------------------------------------------------------------
PROC msScreenTimeOut.l(          ; Generic Inactivity Warning
         time.a)                 ; Current time
Private  y,                      ; Getevent dynarray
         oldCanvas.n,            ; Previous Canvas
         oldWindow.n             ; Previous Window

   oldCanvas.n = GetCanvas()
   oldWindow.n = GetWindow()
   SetCanvas DEFAULT
   Style ATTRIBUTE SysColor(3)
   @ 0,0 ?? Format("w80,ac","Inactivity Warning!!!  " +
                     "Logout will occur in less than One Minute!")
   Style ATTRIBUTE status.n
   retval.l = false
   WHILE true
      IF time.a = SubStr(Time(),1,5) THEN
         Beep Sleep 50 Beep Sleep 50 Beep Sleep 350
         ?? " P r e s s   a   K e y !  "
      ELSE
         QUITLOOP
      ENDIF
      GetEvent ALL To y
      IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
         y["Type"] = "KEY" OR y["Type"] = "MESSAGE" THEN
         retval.l = true
         QUITLOOP
      ENDIF
   ENDWHILE
   Return retval.l
ENDPROC
WriteLib libname.a msScreenTimeOut.l
?? "\004"
; ============================================================================
;       TITLE: msShortCuts.a           (c) 1992, 1993 DataStar International
;     RETURNS: Expanded Message Value
; DESCRIPTION: Shortcuts for Generic Information Messages
; ----------------------------------------------------------------------------
PROC msShortCuts.a(              ; Shortcuts for Messages
         message.a)              ; Message Code
   SWITCH                                 ; shortcuts
      CASE message.a = "C" : message.a = "Operation Canceled - Returning"
      CASE message.a = "M" : message.a = "One Moment - Returning to MENU"
      CASE message.a = "P" : message.a = "P R I N T I N G  -  This will take a few moments"
      CASE message.a = "Q" : message.a = "Q U E R Y I N G  -  This will take a few moments"
      CASE message.a = "R" : message.a = "Report NOT Printed - Returning"
      CASE message.a = "W" : message.a = "W O R K I N G  -  One Moment"
      CASE message.a = "K" : message.a = "Key Violation!  Do You Want to Overwrite the Existing Record?"
      CASE message.a = "A" : message.a = "A R E   Y O U   S U R E ?"
      CASE message.a = "U" : message.a = "Unable to Lock Necessary Tables, Please Try Later"
      CASE message.a = "N" : message.a = "The Printer is NOT Responding!  Please fix Printer, or Cancel Report"
      CASE message.a = "D" : message.a = "Do You Want to DELETE This Record?"
      OTHERWISE            : message.a = "DataStar International"
   ENDSWITCH
   Return message.a
ENDPROC
?? "\004"
WriteLib libname.a msShortCuts.a
; ============================================================================
;       TITLE: msSignBoard.u           (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
; ----------------------------------------------------------------------------
PROC msSignBoard.u(              ; Generic Continue DialogBox
         title.a,                ; Title for dBox, "" for Default
         message.a,              ; Message to display
         msgColor.n,             ; Color for Message (not DialogBox!)
         dBoxPalette.a)          ; Dynarray of custom colors
Private  icon.a,
         button.l,               ; Value of selected Pushbutton
         onceFlag.l,             ; True = non-continuous alert
         frameHigh.n,
         frameLow.n,
         display.a
;Global  g.appColors.y           ; Global Application Colors
;        g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF Len(message.a) = 1 THEN
      icon.a = msIcon.a(message.a)
      message.a = msShortCuts.a(message.a)
   ELSE
      IF alert.n > 3 THEN
         icon.a = msIcon.a("!")
      ELSE
         icon.a = msIcon.a("I")
      ENDIF
   ENDIF

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   DynArray dBoxProcs.y[]
      dBoxProcs.y["IDLE"] = "msSignBoardIdle.l"

   frameHigh.n = 76 ; inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = 64 ; inAttributeConvert.n(SysColor(1036),false)
   button.l    = true
   topRow.n    = 7
   leftCol.n   = Int((g.sysInfo.y["ScreenWidth"]-60)/2)
   title.a     = IIF(title.a = "", "Press <Enter> to Continue", title.a)
   message.a   = Spaces(54) + message.a
   display.a   = Spaces(54)

   SHOWDIALOG title.a
      Proc "dbEventHandler.l"
         Idle Trigger "OPEN"    ; Wait for Key Alert
      @ -200,-200
      Height 7 Width 60

      Frame From 0,1 To 2,56
         PaintCanvas Border Attribute frameLow.n  0,1,2,56
         PaintCanvas Border Attribute frameHigh.n 0,1,0,55
         PaintCanvas Border Attribute frameHigh.n 0,1,2,1

      PaintCanvas Fill display.a Attribute msgColor.n 1,2,1,55

      PushButton @ 3,23
         Width 12 "~C~ontinue"
         OK Default Value dbButtonPress.v(true) Tag "OK"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a msSignBoard.u
?? "\004"
; ============================================================================
;       TITLE: msSignBoardIdle.l           (c) 1992, 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Signboard IDLE Procedure
; ----------------------------------------------------------------------------
PROC msSignBoardIdle.l()              ; Signboard IDLE Procedure
;Global  display.a
;        message.a
;        counter.n
   display.a = SubStr(message.a,1,54)
   message.a = SubStr(message.a,2,255) + SubStr(message.a,1,1)
   IF NOT IsAssigned(counter.n) THEN
      counter.n = 0
   ENDIF
   IF counter.n = 8 THEN
      counter.n = 1
      Sound 440 100
   ELSE
      counter.n = counter.n + 1
      Sound 9 2
      Sleep 100
   ENDIF
   Return true
ENDPROC
WriteLib libname.a msSignBoardIdle.l
?? "\004"
; ============================================================================
;       TITLE: msSplashWindow.u        (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Places information box window
; ----------------------------------------------------------------------------
PROC msSplashWindow.u(           ; Places inforamtion/splash screens
         type.a,                 ; Top,Bottom,Left,Right,Explode,None,Random
         height.n,               ; Height of Window
         width.n,                ; Width of Window
         textProc.a,             ; Proc of Canvas Text to execute
         handleTag.a)            ; Handle index for this Window
Private  y,
         oldWindow.h,
         oldCanvas.h,
         finalRow.n,
         finalColumn.n,
         r,
         originRow.n,
         originColumn.n,
         step.n,
         original.n,
         final.n
;Global  g.sysInfo.y

   oldWindow.h = GetWindow()
   oldCanvas.h = GetCanvas()
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo To g.sysInfo.y
   ENDIF
   finalRow.n = Int((g.sysInfo.y["ScreenHeight"]-height.n)/2)
   finalColumn.n = Int((g.sysInfo.y["Screenwidth"]-width.n)/2)
   IF Upper(type.a) = "RANDOM" THEN
      Array r[5]
         r[1] = "TOP"
         r[2] = "BOTTOM"
         r[3] = "LEFT"
         r[4] = "RIGHT"
         r[5] = "EXPLODE"
      type.a = r[Int(Rand() * 5)+1]
   ENDIF

   SWITCH
      CASE Upper(type.a) = "TOP"       :
         originRow.n = finalRow.n - 50
         originColumn.n = finalColumn.n
         step.n = 1
         original.n = originRow.n
         final.n = finalRow.n
      CASE Upper(type.a) = "BOTTOM"   :
         originRow.n = finalRow.n + 50
         originColumn.n = finalColumn.n
         step.n = -1
         original.n = originRow.n
         final.n = finalRow.n
      CASE Upper(type.a) = "LEFT"      :
         originRow.n  = finalRow.n
         originColumn.n = finalColumn.n - 100
         step.n = 2
         original.n = originColumn.n
         final.n = finalColumn.n
      CASE Upper(type.a) = "RIGHT"     :
         originRow.n = finalRow.n
         originColumn.n = finalColumn.n + 100
         step.n = -2
         original.n = originColumn.n
         final.n = finalColumn.n
      OTHERWISE                        :
         originRow.n = finalRow.n
         originColumn.n = finalColumn.n
   ENDSWITCH

   IF NOT IsAssigned(g.handles.y) THEN
      DynArray g.handles.y[]
   ENDIF

   Dynarray y[]
   IF NOT IsAssigned(g.handles.y[handleTag.a]) OR
      NOT IsWindow(g.handles.y[handleTag.a])  THEN
         y["HasFrame"] = false
         y["Height"]   = height.n
         y["Width"]    = width.n
      Window Create Floating @ -200, -200 Attributes y
      To g.handles.y[handleTag.a]
      IF NOT IsBlank(textProc.a) THEN
         ExecProc textProc.a
      ENDIF
   ENDIF

   Window Select g.handles.y[handleTag.a]

   SWITCH
      CASE Upper(type.a) = "NONE"      :
         Window Move g.HANDLES.y[handleTag.a] To finalRow.n, finalColumn.n
      CASE Upper(type.a) = "EXPLODE"   :
         wsWindowPark.u(g.handles.y[handleTag.a])
         Window Resize g.handles.y[handleTag.a] To 2,4
         Window Move g.HANDLES.y[handleTag.a] To finalRow.n, finalColumn.n
         FOR n From 1 To 15
            Window Resize g.handles.y[handleTag.a]
                   To 1 + Int((height.n/16) * n),
                      4 + Int((width.n/16) * n)
            Sleep 50
         ENDFOR
         Window Resize g.handles.y[handleTag.a] To height.n, width.n
      OTHERWISE                        :
         wsWindowPark.u(g.handles.y[handleTag.a])
         FOR n From original.n to final.n Step step.n
            Window Move g.HANDLES.y[handleTag.a]
            To IIF(Abs(step.n)=1,n,finalRow.n), IIF(Abs(step.n)=2,n,finalColumn.n)
            Sleep 1
         ENDFOR
   ENDSWITCH

   IF Upper(handleTag.a) = "ABOUT" THEN
      Message "Please MouseClick or Press Any Key to Continue..."
      WHILE true
         GetEvent To y
         IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
            y["Type"] = "KEY" OR y["Type"] = "MESSAGE" THEN
            QUITLOOP
         ENDIF
      ENDWHILE
      wsWindowPark.u(g.handles.y[handleTag.a])
   ENDIF

   IF IsWindow(oldCanvas.h) THEN
      SetCanvas oldCanvas.h
   ENDIF
   IF IsWindow(oldWindow.h) THEN
      Window Select oldWindow.h
   ENDIF
   Return
ENDPROC
?? "\004"
WriteLib libname.a msSplashWindow.u
; ============================================================================
;       TITLE: msStop.u                        (c) 1993 DataStar International
;     RETURNS: No Value
; DESCRIPTION: Generic Message and wait for a <Continue> keypress
; ----------------------------------------------------------------------------
PROC msStop.u(                   ; Generic Continue DialogBox
         title.a,                ; Title for dBox, "" for Default
         message.a)              ; Message to display
Private  icon.a,
         button.l,               ; Value of selected Pushbutton
         topRow.n,
         leftCol.n
;Global  g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("S")

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   message.a   = msWrap.a(message.a)
   button.l    = true
   topRow.n    = 7
   leftCol.n   = Int((g.sysInfo.y["ScreenWidth"]-60)/2)
   title.a     = IIF(title.a = "", "Press <Enter> to Continue", title.a)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute 64  0,1,6,11
         PaintCanvas Border Attribute 76 0,1,0,10
         PaintCanvas Border Attribute 76 0,1,6,1
         PaintCanvas Fill icon.a Attribute 79 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a
                     Attribute frameLow.n + 15 1,15,5,54

      PushButton @ 7,24 Width 10 "~O~K"
         OK Default Value dbButtonPress.v(true) Tag "OK"
      To button.l
   ENDDIALOG
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a msStop.u
?? "\004"
; ============================================================================
;       TITLE: msTeleType.u            (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Writes string to screen at passed coordinates. Clicks with
;              each letter written. Speed controlled by speed.n variable.
; ----------------------------------------------------------------------------
PROC msTeleType.u(               ; Scrolls text onto canvas
         row.n,                  ; Relative Row position
         column.n,               ; Relative Column position
         string.a,               ; Message to write to Canvas
         speed.n)                ; Speed to write (0=fastest, 10=slowest)
Private  n                       ; Transient Loop Counter
   FOR n from 1 To Len(String.a)
      @ row.n,column.n + n - 1
      ?? SubStr(string.a,n,1)
      Sound 9 2
      Sleep Max(1,Min(speed.n,10))*10
   ENDFOR
   Return
ENDPROC
?? "\004"
WriteLib libname.a msTeletype.u
; ============================================================================
;       TITLE: msTickerTape.u          (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Writes string to screen backwards at passed coordinates.
;              Clicks with each letter. Speed controlled by speed.n variable.
; ----------------------------------------------------------------------------
PROC msTickerTape.u(             ; Scrolls text onto canvas
         row.n,                  ; Relative Row position
         column.n,               ; Relative Column position
         string.a,               ; Message to write to Canvas
         speed.n)                ; Speed to write (0=fastest, 10=slowest)
Private  n,                      ; Transient Loop Counter
         length.n                ; Length of string
   length.n = Len(string.a)
   FOR n from 1 To length.n
      @ row.n,column.n + length.n - n
      ?? SubStr(string.a,1,n)
      Sound 9 2
      Sleep Max(1,Min(speed.n,10))*10
   ENDFOR
   Return
ENDPROC
?? "\004"
WriteLib libname.a msTickerTape.u
; ============================================================================
;       TITLE: msWorking.u             (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Generic Information Message Window, Cleared as follows:
;                 0 Seconds      - must be manually cleared
;                 1 - 5 Seconds  - self-clears
;                -1 Seconds      - pauses while event = IDLE, then clears
; ----------------------------------------------------------------------------
PROC msWorking.u(                ; Generic information message window
         message.a,              ; Message to display (<ScreenWidth
         color.n,                ; Color for message window
         beep.n,                 ; Number of beeps
         sleep.n)                ; # of Seconds to pause (-1 to 5)
Private  y, n, h,
         width.n,
         oldCanvas.h,
         oldWindow.h,
         offset.n
;Global  g.handles.y
;        g.sysInfo.y

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   message.a = "   " + message.a + "..."

   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo To g.sysInfo.y             ; Determine Screen Size
   ENDIF

   msWorkingClear.u()

   DynArray y[]
      y["CanClose"] = False
      y["CanMaximize"] = False
      y["CanMove"] = False
      y["CanResize"] = False
      y["HasFrame"] = False    ; If Framed, window is *5* rows!!!
      y["Style"] = color.n


   width.n = Max(40,Min(Len(message.a)+2,g.sysInfo.y["ScreenWidth"]-4))
   offset.n = Max(4,Int((width.n-Len(message.a)+1)/2)+3)
   oldCanvas.h = GetCanvas()
   oldWindow.h = GetWindow()


   Window Create  Floating @ -200,-200
                  Height 1 Width width.n
                  Attributes y To h

   g.handles.y["Message"] = h
   Style Attribute color.n
   PaintCanvas Fill Format("w"+StrVal(width.n)+",ac",message.a) Attribute color.n  0,0,0,width.n-1
   PaintCanvas Attribute color.n + 128  0,width.n - offset.n,0,width.n-offset.n+2

   Window Move g.handles.y["Message"] To 1, Int((g.sysInfo.y["ScreenWidth"]-width.n)/2)

   FOR n from 1 to Min(5,beep.n)
      Beep Sleep 100                   ; Beep for desired # of Beeps
   ENDFOR

   SWITCH
      CASE sleep.n > 0  :
         Sleep Min(sleep.n,5) * 1000   ; Sleep for desired # of seconds
         Window Select g.handles.y["Message"]
         Window Close
      CASE sleep.n < 0  :
         Message "Mouseclick or Press Any Key to Continue..."
         WHILE true
            GetEvent ALL To y
            IF (y["Type"] = "MOUSE" AND y["Action"] = "DOWN") OR
               y["Type"] = "KEY" THEN
               QUITLOOP
            ENDIF
         ENDWHILE
         Window Select g.handles.y["Message"]
         Window Close
   ENDSWITCH

   IF IsWindow(oldCanvas.h) THEN
      SetCanvas oldCanvas.h
   ELSE
      SetCanvas Default
   ENDIF
   IF IsWindow(oldWindow.h) THEN
      Window Select oldWindow.h
   ENDIF
   Return
ENDPROC
WriteLib libname.a msWorking.u
?? "\004"
; ============================================================================
;       TITLE: msWorkingClear.u        (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Generic Information Message Window Clearer
; ----------------------------------------------------------------------------
PROC msWorkingClear.u()          ; Clears msWorking message
Private  oldWindow.h,
         oldCanvas.h
;Global  g.handles.y["Message"]
   oldWindow.h = GetWindow()
   oldCanvas.h = GetCanvas()
   IF IsAssigned(g.handles.y["Message"]) AND IsWindow(g.handles.y["Message"]) THEN
      Window Select g.handles.y["Message"]
      Window Select g.handles.y["Message"]
      Window Close
   ENDIF
   IF IsWindow(oldCanvas.h) THEN
      SetCanvas oldCanvas.h
   ELSE
      SetCanvas Default
   ENDIF
   IF IsWindow(oldWindow.h) THEN
      Window Select oldWindow.h
   ENDIF
   Return
ENDPROC
WriteLib libname.a msWorkingClear.u
?? "\004"
; ============================================================================
;       TITLE: msWrap.a                (c) 1992, 1993 DataStar International
;     RETURNS: Formatted 200 char message
; DESCRIPTION: Formats message for dBox message routines
; ----------------------------------------------------------------------------
PROC msWrap.a(                   ; Formats message for dBox
         message.a)              ; Message to format
Private  n1, n2, n3              ; Transient counters
   IF Len(message.a) < 41 THEN
      message.a = Spaces(80) + Format("w40,ac",message.a) + Spaces(80)
   ELSE
      IF Len(message.a) < 121 THEN
         message.a = Spaces(40) + message.a
      ENDIF
      FOR n1 From 40 To 160 Step 40
         n2 = n1 + 1
         WHILE SubStr(message.a, n2, 1) <> " "
            n2 = n2 - 1
         ENDWHILE
         n3 = n2 + 1
         WHILE SubStr(message.a, n3, 1) = " "
            n3 = n3 + 1
         ENDWHILE
         message.a = Format("w"+StrVal(n1),SubStr(message.a,1,n2-1)) +
                     Format("w"+StrVal(200-n1),SubStr(message.a,n3,200))
      ENDFOR
   ENDIF
   Return message.a
ENDPROC
?? "\004"
WriteLib libname.a msWrap.a
; ============================================================================
;       TITLE: msYesNoCancel.l                 (c) 1993 DataStar International
;     RETURNS: ABORT RETRY IGNORE
; DESCRIPTION: Generic ABORT/RETRY/IGNORE Message routine
; ----------------------------------------------------------------------------
PROC msYesNoCancel.a(            ; Abort/Retry/Ignore DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a)              ; Message to display (< 70 chars)
Private  width.n,                ; Width of Dialog Box
         button.a,               ; Value of selected Pushbutton
         icon.a,                 ; Message Box Icon
         frameHigh.n,            ; Chiseled Frame Highlight
         frameLow.n              ; Chiseled Frame Lowlight
;Global  g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("?")

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   button.a    = "CANCEL"
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)
   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   SHOWDIALOG title.a
      @ topRow.n, leftCol.n
      Height 11 Width 60

      Frame From 0,1 To 6,11
         PaintCanvas Border Attribute frameLow.n  0,1,6,11
         PaintCanvas Border Attribute frameHigh.n 0,1,0,10
         PaintCanvas Border Attribute frameHigh.n 0,1,6,1
         PaintCanvas Fill icon.a Attribute frameLow.n + 14 1,2,5,10

      Frame From 0,13 To 6,56
         PaintCanvas Border Attribute frameHigh.n 0,13,6,56
         PaintCanvas Border Attribute frameLow.n  0,13,0,55
         PaintCanvas Border Attribute frameLow.n  0,13,6,13
         PaintCanvas Fill message.a Attribute frameLow.n + 15 1,15,5,54

      PushButton  @ 7,8 Width 10 "~Y~es"
         OK Value dbButtonPress.v("YES") Tag "BUTTON"
      To button.a

      PushButton  @ 7,24 Width 10 "~N~o"
         OK Value dbButtonPress.v("NO") Tag "BUTTON"
      To button.a

      PushButton  @ 7,40 Width 10 "~C~ancel"
         CANCEL Value dbButtonPress.v("CANCEL") Tag "BUTTON"
      To button.a
   ENDDIALOG
   msWorkingClear.u()
   Return button.a
ENDPROC
?? "\004"
WriteLib libname.a msYesNoCancel.a
; ============================================================================
;       TITLE: msYesNoCancel.n            (c) 1992, 1993 DataStar International
;     RETURNS: 0=Yes, 1=No, 2=Cancel
; DESCRIPTION: Generic Continue-or-Cancel Message routine
;                 Alert 0 = No sound
;                 Alert 1 = Three beeps
;                 Alert 2 = Siren, short (high-low-high-low-high)
;                 Alert 3 = Two beeps, continuous
;                 Alert 4 = Two high beeps, two low beeps, continuous
;                 Alert 5 = Siren, continuous
; ----------------------------------------------------------------------------
PROC msYesNoCancel.n(               ; Confirmation DialogBox
         title.a,                ; Title for Dialog Box, or "" for Default
         message.a,              ; Message to display (< 70 chars)
         msgColor.n,             ; Color for message (not DialogBox!)
         dBoxPalette.a,          ; Palette name for custom dBox window colors
         alert.n,                ; Sound level of Alert (0 - 4)
         okLabel.a,              ; Label of YES Pushbutton
         noLabel.a,              ; Label of NO Pushbutton
         cxLabel.a,              ; Label of CANCEL Pushbutton
         default.n)              ; Which Button is Default?  0, 1, 2
Private  width.n,                ; Width of Dialog Box
         a1, a2,                 ; Match variables
         n1, n2,                 ; Button length comparisons
         buttonLength.n,         ; Width of Pushbuttons
         button.n,               ; Value of selected Pushbutton
         onceFlag.l,             ; True = Non-continuous Alert
         icon.a,
         frameHigh.n,
         frameLow.n,
         topRow.n,
         leftCol.n
;Global  g.appColors.y           ; Global Application Colors
;        g.sysInfo.y             ; Global System Information

   SetCanvas DEFAULT
   IF NOT IsAssigned(g.sysInfo.y) THEN
      SysInfo to g.sysInfo.y
   ENDIF

   IF Len(message.a) = 1 THEN
      message.a = msShortCuts.a(message.a)
   ENDIF
   icon.a = msIcon.a("?")

   frameHigh.n = inAttributeConvert.n(SysColor(1036),true)
   frameLow.n  = inAttributeConvert.n(SysColor(1036),false)
   onceFlag.l  = alert.n < 3 OR alert.n > 50
   button.n    = 2
   message.a   = msWrap.a(message.a)
   title.a     = IIF(title.a = "", "Press <Tab> to Highlight - <Enter> to Select",
                                    title.a)

   DynArray dBoxProcs.y[]
      dBoxProcs.y["IDLE"] = "dbAlert.l"

   topRow.n = 7
   leftCol.n = Int((g.sysInfo.y["ScreenWidth"]-60)/2)

   a1 = ""
   a2 = okLabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n1 = Len(a1+a2)

   a1 = ""
   a2 = noLabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n1 = Len(a1+a2)

   a1 = ""
   a2 = cxLabel.a
   WHILE Match(a1+a2,"..~..",a1,a2)
   ENDWHILE
   n2 = Len(a1+a2)
   buttonLength.n = Max(n1,n2)+4

   SWITCH
      CASE default.n = 0   :           ; YES
         SHOWDIALOG title.a
            PROC "dbEventHandler.l"
               IDLE
               TRIGGER "Open"
            @ -200,-200
            Height 11 Width 60

            Frame From 0,1 To 6,11
               PaintCanvas Border Attribute frameLow.n  0,1,6,11
               PaintCanvas Border Attribute frameHigh.n 0,1,0,10
               PaintCanvas Border Attribute frameHigh.n 0,1,6,1
               PaintCanvas Fill icon.a Attribute msgColor.n 1,2,5,10

            Frame From 0,13 To 6,56
               PaintCanvas Border Attribute frameHigh.n 0,13,6,56
               PaintCanvas Border Attribute frameLow.n  0,13,0,55
               PaintCanvas Border Attribute frameLow.n  0,13,6,13
               PaintCanvas Fill message.a Attribute msgColor.n 1,15,5,54

            PushButton  @ 7,4
               Width buttonLength.n okLabel.a
               OK DEFAULT Value dbButtonPress.v(0) Tag "BUTTON"
            To button.n

            PushButton  @ 7,28 - Int(buttonLength.n/2)
               Width buttonLength.n noLabel.a
               OK Value dbButtonPress.v(1) Tag "BUTTON"
            To button.n

            PushButton  @ 7,54 - buttonLength.n
               Width buttonLength.n cxLabel.a
               OK Value dbButtonPress.v(2) Tag "BUTTON"
            To button.n
         ENDDIALOG
      CASE default.n = 1   :           ; NO
         SHOWDIALOG title.a
            PROC "dbEventHandler.l"
               IDLE
               TRIGGER "Open"
            @ -200,-200
            Height 11 Width 60

            Frame From 0,1 To 6,11
               PaintCanvas Border Attribute frameLow.n  0,1,6,11
               PaintCanvas Border Attribute frameHigh.n 0,1,0,10
               PaintCanvas Border Attribute frameHigh.n 0,1,6,1
               PaintCanvas Fill icon.a Attribute msgColor.n 1,2,5,10

            Frame From 0,13 To 6,56
               PaintCanvas Border Attribute frameHigh.n 0,13,6,56
               PaintCanvas Border Attribute frameLow.n  0,13,0,55
               PaintCanvas Border Attribute frameLow.n  0,13,6,13
               PaintCanvas Fill message.a Attribute msgColor.n 1,15,5,54

            PushButton  @ 7,4
               Width buttonLength.n okLabel.a
               OK Value dbButtonPress.v(0) Tag "BUTTON"
            To button.n

            PushButton  @ 7,28 - Int(buttonLength.n/2)
               Width buttonLength.n noLabel.a
               OK DEFAULT Value dbButtonPress.v(1) Tag "BUTTON"
            To button.n

            PushButton  @ 7,54 - buttonLength.n
               Width buttonLength.n cxLabel.a
               OK Value dbButtonPress.v(2) Tag "BUTTON"
            To button.n
         ENDDIALOG
      OTHERWISE            :           ; CANCEL
         SHOWDIALOG title.a
            PROC "dbEventHandler.l"
               IDLE
               TRIGGER "Open"
            @ -200,-200
            Height 11 Width 60

            Frame From 0,1 To 6,11
               PaintCanvas Border Attribute frameLow.n  0,1,6,11
               PaintCanvas Border Attribute frameHigh.n 0,1,0,10
               PaintCanvas Border Attribute frameHigh.n 0,1,6,1
               PaintCanvas Fill icon.a Attribute msgColor.n 1,2,5,10

            Frame From 0,13 To 6,56
               PaintCanvas Border Attribute frameHigh.n 0,13,6,56
               PaintCanvas Border Attribute frameLow.n  0,13,0,55
               PaintCanvas Border Attribute frameLow.n  0,13,6,13
               PaintCanvas Fill message.a Attribute msgColor.n 1,15,5,54

            PushButton  @ 7,4
               Width buttonLength.n okLabel.a
               OK Value dbButtonPress.v(0) Tag "BUTTON"
            To button.n

            PushButton  @ 7,28 - Int(buttonLength.n/2)
               Width buttonLength.n noLabel.a
               OK Value dbButtonPress.v(1) Tag "BUTTON"
            To button.n

            PushButton  @ 7,54 - buttonLength.n
               Width buttonLength.n cxLabel.a
               OK DEFAULT Value dbButtonPress.v(2) Tag "BUTTON"
            To button.n
         ENDDIALOG
   ENDSWITCH
   msWorkingClear.u()
   Return button.n
ENDPROC
?? "\004"
WriteLib libname.a msYesNoCancel.n
