; ****************************************************************************
; SCRIPT NAME: ds4_LOOK.sc                (c) 1992,1993 DataStar International
; APPDEV TEAM: Dan Paolini, David Kelton, Micah Bleecher, Patty Paolini
; APPLICATION: DataStar Utilities for Paradox 4
; DESCRIPTION: Contains the following Lookup procedures:
;                 lkHelpDialogFieldSingle.l
;                 lkHelpDialogFieldMulti.u
;                 lkHelpSelectKey.n
;                 lkHelpTable.u
;                 lkHelpTablePlus.u
;                 lkHelpTableAdd.u
;                 lkHelpTableEdit.u
;                 lkHelpUtility.l
; ============================================================================
? Format("w40"," ds4_LOOK.sc - Lookup Routines")
IF NOT IsAssigned(libname.a) THEN
   Beep Beep Beep QUIT "Variable \"libname.a\" is not assigned!.."
ENDIF
IF NOT IsFile(libname.a+".LIB") THEN
   CreateLib libname.a Size 640
ENDIF
@ Row(),40
; ============================================================================
;       TITLE: lkHelpDialogFieldSingle.l (c) 1992, 1993 DataStar International
;     RETURNS: True if a value was selected
; DESCRIPTION: Dialog box Picklist for single field
; ----------------------------------------------------------------------------
PROC lkHelpDialogFieldSingle.l(  ; Lookup dialog for single field
         context.a)              ; Context for Help system
Private  lookup.y,               ; Picklist of values
         lookupChoice.v,         ; Index of Picklist item selected
         pickWidth.n
;Global  lookup.r                ; Array of located record
   lookupChoice.v = false
   Help                                   ; Check if there is assigned lookup help for this field.
   IF HelpMode() <> "LookupHelp" THEN
      IF NOT lkHelpUtility.l() THEN
         Esc                                 ; Back to the main data table.
         IF NOT IsAssigned(g.help.y) THEN
            DynArray g.help.y[]
         ENDIF
         hsEngine.u(context.a,g.help.y)      ; context sensitive help
     ENDIF
   ELSE
      DynArray lookup.y[]
      SCAN
         lookup.y[[]] = []
      ENDSCAN
      IF Search("A",FieldType()) = 1 THEN
         pickWidth.n = NumVal(SubStr(FieldType(),2,3))
      ELSE
         pickWidth.n = 11
      ENDIF

      pickWidth.n = Max(22,pickWidth.n)

      lookupChoice.v = ioPickDynArrayDialog.v(lookup.y,pickWidth.n,
                                             "Select Lookup Value",
                                              Field(),1,0,"")
      IF NOT lookupChoice.v = false THEN
         Locate lookupChoice.v
         IF retval THEN
            CopyToArray lookup.r
         ENDIF
         Esc
         IF NOT lookupChoice.v = "" THEN
            CtrlBackSpace
            TypeIn lookupChoice.v
         ENDIF
      ENDIF
   ENDIF
   Return lookupChoice.v <> false
ENDPROC
WriteLib libname.a lkHelpDialogFieldSingle.l
?? "\004"
; ============================================================================
;       TITLE: lkHelpDialogFieldMulti.u  (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Multi-field DialogBox-based lookup routine
; ----------------------------------------------------------------------------
PROC lkHelpDialogFieldMulti.u(   ; Multi-field dialog box lookup
         context.a,              ; Context for Help system
         fieldList.r,            ; List of fields to place in DynArray
         fixedLength.r)          ; Is each field fixed in length
Private  lookup.y,
         lookupChoice.v
   Help                                   ; Check if there is assigned lookup help for this field.
   IF HelpMode() <> "LookupHelp" THEN
      IF NOT lkHelpSelectKey.l() Then
         Esc                                 ; Back to the main data table.
         IF NOT IsAssigned(g.help.y) THEN
            DynArray g.help.y[]
         ENDIF
         hsEngine.u(context.a,g.help.y)      ; context sensitive help
      ENDIF
   ELSE
      IF NImageRecords() < 500 THEN
         DynArray lookup.y[]
         fields.n = ArraySize(fieldList.r)
         IF fields.n = 1 THEN
            MoveTo Field fieldList.r[1]
         ELSE
            Array fieldwidths.r[fields.n]
            pickWidth.n = 0
            FOR n From 1 To fields.n
               MoveTo Field fieldList.r[n]
               SWITCH
                  CASE Search("A",FieldType()) = 1 :
                     fieldwidths.r[n] = Min(60,NumVal(SubStr(FieldType(),2,Len(FieldType())-1))) + 2
                  CASE Search(FieldType(),"N$") <> 0 :
                     fieldwidths.r[n] = 15
                  CASE FieldType() = "D" :
                     fieldwidths.r[n] = 10
                  CASE FieldType() = "S" :
                     fieldwidths.r[n] = 8
                  CASE Search("M",FieldType()) = 1 :
                     fieldwidths.r[n] = Min(60,NumVal(SubStr(FieldType(),2,Len(FieldType())-1))) + 2
                  OTHERWISE :
                     fieldwidths.r[n] = 1
               ENDSWITCH
               IF pickWidth.n + fieldwidths.r[n] > 72 THEN
                  fields.n = n
               ENDIF
               pickWidth.n = pickWidth.n + fieldwidths.r[n]
               IF NOT fixedLength.r[n] THEN
                  fieldwidths.r[n] = 0
               ENDIF
            ENDFOR
         ENDIF
         SCAN
            IF fields.n > 1 THEN
               item.a = ""
               FOR n From 1 To fields.n
                  MoveTo Field fieldList.r[n]
                  SWITCH
                     CASE fieldwidths.r[n] = 0  :
                        item.a = item.a + []
                        IF n < fields.n THEN
                           item.a = item.a + ", "
                        ENDIF
                     CASE fieldwidths.r[n] = 1  :  ; Skip BLOBS
                     OTHERWISE                  :
                        item.a = item.a + Format("w"+StrVal(fieldwidths.r[n]),[])
                  ENDSWITCH
               ENDFOR
            ELSE
               item.a = []
            ENDIF
            CtrlHome Right
            lookup.y[[]] = item.a         ; Single Key field is dynarray index
         ENDSCAN
         lookupChoice.v = ioPickDynArrayDialog.v(lookup.y,Min(pickWidth.n,72),
                                                "Select Lookup Value",
                                                   Field(),1,0,"")
         IF NOT lookupChoice.v = false THEN
            Locate lookupChoice.v
            IF retval THEN
               CopyToArray lookup.r
            ENDIF
            Esc
            IF NOT lookupChoice.v = "" THEN
               CtrlBackSpace
               Typein lookupChoice.v
            ENDIF
         ENDIF
      ELSE
         msContinue.u("","Sorry, too many records in Lookup!",127,"GREY",1)
      ENDIF
   ENDIF
   Return
ENDPROC
WriteLib libname.a lkHelpDialogFieldMulti.u
?? "\004"
; ============================================================================
;       TITLE: lkHelpSelectKey.n         (c) 1992, 1993 DataStar International
;     RETURNS: Keycode that ended Lookup
; DESCRIPTION: This allows you to simulate a Wait TABLE during Lookup Help.
; ----------------------------------------------------------------------------
PROC lkHelpSelectKey.n(          ; adapted from DE ToolKit procedure
         change.l)               ; Can we add and edit records?
Private  lookup.w
   Window Handle Image ImageNo() To lookup.w
   Window Select lookup.w
   Echo Normal             ;Display the table to the user.
   ImageRights ReadOnly    ;Prevent user from making changes to image.
   WHILE True
      retval = GetChar()
      SWITCH
         CASE (change.l)
          AND (retval = -82
           OR  retval = -67)  : QUITLOOP
         CASE (MenuChoice() = "Error" AND NOT IsFieldView())
          AND (retval =  -60
           OR  retval =   27
           OR  retval =    0) : QUITLOOP
         CASE (retval <  -60 AND retval > -71)
           OR  retval = -110
           OR  retval = -111
           OR  retval = -100
           OR  retval =   15
           OR  retval  =  18
           OR  retval =  -24
           OR  retval =  -59
           OR  retval = -107
           OR  retval = -103
           OR  retval =  -45 : Beep
         CASE  retval =   26 : wsZoom.l("FIRST") Echo NORMAL
         CASE  retval =  -44 : wsZoom.l("NEXT") Echo NORMAL
         OTHERWISE           : KeyPress retval
      ENDSWITCH
   ENDWHILE
   Echo OFF
   SyncCursor
   IF retval = 0 THEN
      retval = 27                     ; [Ctrl+Break] functions as an [Esc].
   ENDIF                               ; from lookup help.
   ImageRights                         ; Restore image status of table.
   Return retval
ENDPROC
WriteLib libname.a lkHelpSelectKey.n
?? "\004"
; ============================================================================
;       TITLE: lkHelpTable.u             (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Routes [F1] to Lookup Table or context help as appropriate
; ----------------------------------------------------------------------------
PROC lkHelpTable.u(              ; Handles LookupHelp in Wait
         context.a)              ; Context for Help system
   Help                                   ; Check if there is assigned lookup help for this field.
   IF HelpMode() <> "LookupHelp" THEN
      IF NOT lkHelpUtility.l() Then
         Esc                                 ; Back to the main data table.
         IF NOT IsAssigned(g.help.y) THEN
            DynArray g.help.y[]
         ENDIF
         hsEngine.u(context.a,g.help.y)      ; context sensitive help
      ENDIF
   ELSE
      WHILE true                          ; Now in the lookup table.
         Prompt " Selecting Value...                       Ctrl+Z-Zoom   F2-Select   Esc-Cancel"
         lkHelpSelectKey.n(false)         ; Lets user view and optionally select from table
         SWITCH
            CASE retval = -60   : Do_It!
            CASE retval = 27    : Esc        ; Return to data table without fill in
         ENDSWITCH
         QUITLOOP
      ENDWHILE
      Prompt                                 ; Cancel lookup prompt.
   ENDIF
   Echo OFF
   Return
ENDPROC
WriteLib libname.a lkHelpTable.u
?? "\004"
; ============================================================================
;       TITLE: lkHelpTablePlus.u         (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Allows Inserting New Values into Lookup Table
; ----------------------------------------------------------------------------
PROC lkHelpTablePlus.u(          ; Lookup Help in Wait, Add records on fly
         context.a,              ; Context for Help system
         table.a,                ; Name of lookup table
         form.a,                 ; Form to add record in
         departProc.a)           ; DepartAdd procedure
   Help                                ; Check if there is assigned lookup help for this field.
   IF HelpMode() <> "LookupHelp" THEN  ; Just in case Valcheck was disabled!
      IF NOT lkHelpSelectKey.l() Then
         Esc                                 ; Back to the main data table.
         IF NOT IsAssigned(g.help.y) THEN
            DynArray g.help.y[]
         ENDIF
         hsEngine.u(context.a,g.help.y)      ; context sensitive help
      ENDIF
   ELSE
      ShowPullDown
         "~[F2]~-Select "      : "" : "",
         "~[Ctrl+Z]~-Search "  : "" : "",
         "~[Ins]~-Add "        : "" : "",
         "~[F9]~-Edit "        : "" : "",
         "~[Esc]~-Cancel"      : "" : ""
      EndMenu
      WHILE true                          ; Now in the lookup table.
         Prompt ""
         lkHelpSelectKey.n(true)             ; Lets user view and optionally select from table
         SWITCH
            CASE retval = -67    :
               CtrlHome Right
               lkHelpTableEdit.u(table.a,form.a,departProc.a,[])
            CASE retval = -82    :
               lkHelpTableAdd.u(table.a,form.a,departProc.a)
            CASE retval = -60    : Do_It!
            CASE retval = 27     : Esc       ; Return to data table without fill in
         ENDSWITCH
         QUITLOOP
      ENDWHILE
      Prompt                                  ; Cancel lookup prompt.
   ENDIF
   Echo Normal
   Return
ENDPROC
WriteLib libname.a lkHelpTablePlus.u
?? "\004"
; ============================================================================
;       TITLE: lkHelpTableAdd.u          (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Allows Inserting New Values into Lookup Table
; ----------------------------------------------------------------------------
PROC lkHelpTableAdd.u(           ; Add a new Lookup value
         table.a,                ; Name of lookup table
         form.a,                 ; Form to add record in
         departProc.a)           ; DepartAdd procedure
Private  originalTable.a,
         origform.a,
         detail.l,
         origfield.a,
         recno.n,
         add.l,
         r,
         original.h,
         detail.r
   msWorking.u("This will take a few moments",95,1,0)
   Esc
   Prompt                     ; Cancel lookup prompt.
   Echo OFF
   originalTable.a = Table()
   origfield.a = Field()
   detail.l    = LinkType() <> "None"
   recno.n     = RecNo()
   IF NOT IsValid() THEN
      CtrlBackSpace             ; Clear the field.
   ENDIF
   IF detail.l THEN
      CopyToArray detail.r
      Del                        ; Remove Detail record
   ENDIF
   Do_It!
   origform.a = Form()
   IF IsFormView() THEN
      FormKey
   ENDIF
   origimage.n = ImageNo()
   Window Handle Image origimage.n To original.h
   Window Move original.h To -200,-200

   tbView.u(table.a,true)
   wsPickForm.l(form.a)
   CoEditKey
   Ins
   msWorkingClear.u()
   ShowPullDown
      "Entering New Lookup Value...   ~<F2>~ to Post and Select " : "" : "",
      "~<Esc>~ to Cancel" : "" : ""
   EndMenu
   WHILE true
      Echo Normal
      Wait RECORD Prompt ""
      Until -24, 15, 18, -38, "Del", -35, "F1", "Esc", "F2"
      Echo Off
      SWITCH
         CASE retval = "F2"   :
            IF NOT IsBlank(departProc.a) THEN
               ExecProc departProc.a
               retval = (retval=0)
            ELSE
               PostRecord4.l(true,false,false)
            ENDIF

            IF retval THEN
               msWorking.u("W",103,0,0)
               add.l = true
               CopyToArray r
               QUITLOOP
            ENDIF
         CASE retval = "Esc"
           OR retval = "Del"  :
            l = msConfirm.l("","Cancel this Lookup Entry?", 79, "RED",
                            1, "~Y~ES - Cancel", "~N~O - Continue", true)
            IF l THEN
               msWorking.u("C",79,1,0)
               Del
               ClearAll
               add.l = false
               QUITLOOP
            ENDIF
         CASE retval = -35
           OR retval = "F1"   : lkHelpTable.u("LOOKUPINSERT")
         OTHERWISE            : Beep
      ENDSWITCH
   ENDWHILE

   Do_It!
   FormKey
   Window Select original.h
   IF origform.a <> "None" THEN
      wsPickForm.l(origform.a)
      CoEditKey
      MoveTo originalTable.a
      IF detail.l THEN
         MoveTo RECORD recno.n
         Down
         IF NOT RecordStatus("New") THEN
            Ins
            CopyFromArray detail.r
            PostRecord NoPost LeaveLocked
         ENDIF
      ENDIF
   ENDIF
   MoveTo FIELD origfield.a
   IF add.l THEN
      [] = r[2]
      ReSyncKey
   ENDIF
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a lkHelpTableAdd.u
?? "\004"
; ============================================================================
;       TITLE: lkHelpTableEdit.u         (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Allows Inserting New Values into Lookup Table
; ----------------------------------------------------------------------------
PROC lkHelpTableEdit.u(          ; Edit a Lookup Record
         table.a,                ; Name of lookup table
         form.a,                 ; Form to add record in
         departProc.a,           ; DepartAdd procedure
         keyValue.v)             ; Key value to locate
Private  originalTable.a,
         originalForm.a,
         detail.l,
         originalField.a,
         recNo.n,
         edit.l,
         r,
         original.h,
         retval.l,
         detail.r
   msWorking.u("This will take a few moments",95,1,0)
   Esc
   Prompt                     ; Cancel lookup prompt.
   Echo OFF
   originalTable.a = Table()
   originalField.a = Field()
   detail.l    = LinkType() <> "None"
   recNo.n     = RecNo()
   IF NOT IsValid() THEN
      CtrlBackSpace             ; Clear the field.
   ENDIF
   IF detail.l THEN
      CopyToArray detail.r
      Del                        ; Remove Detail record
   ENDIF
   Do_It!
   originalForm.a = Form()
   IF IsFormView() THEN
      FormKey
   ENDIF
   origimage.n = ImageNo()
   Window Handle Image origimage.n To original.h
   Window Move original.h To -200,-200

   tbView.u(table.a,true)
   CtrlHome Right
   Locate keyValue.v
   IF retval THEN
      wsPickForm.l(form.a)
      CoEditKey
      msWorkingClear.u()
      WHILE true
         Echo Normal
         Wait RECORD Prompt
   " Press [F2] to Save Value and Select    [Alt+H] for Help    [Esc] to Cancel"
         Until -24, 15, 18, -38, "Del", -35, "F1", "Esc", "F2"
         Echo Off
         SWITCH
            CASE retval = "F2"   :
               IF NOT IsBlank(departProc.a) THEN
                  ExecProc departProc.a
                  retval.l = IIF(retval=0,true,false)
               ELSE
                  retval.l = PostRecord4.l(true,false,false)
               ENDIF

               IF retval.l THEN
                  msWorking.u("W",103,0,0)
                  edit.l = true
                  CopyToArray r
                  QUITLOOP
               ENDIF

            CASE retval = "Esc"
              OR retval = "Del"  :
               msConfirm.l("","Cancel this Lookup Entry?", 79, "RED",
                           1,"~N~O - Continue", "~Y~ES - Cancel",false)
               IF retval THEN
                  UnDo
                  edit.l = false
                  QUITLOOP
               ENDIF
            CASE retval = -35
              OR retval = "F1"   :
               hsEngine.u("LOOKUPINSERT",g.help.y)      ; context sensitive help
            OTHERWISE            : Beep
         ENDSWITCH
      ENDWHILE

      Do_It!
      FormKey
      Window Select original.h
      IF originalForm.a <> "None" THEN
         wsPickForm.l(originalForm.a)
         CoEditKey
         MoveTo originalTable.a
         IF detail.l THEN
            MoveTo RECORD recNo.n
            Down
            IF NOT RecordStatus("New") THEN
               Ins
               CopyFromArray detail.r
               PostRecord NoPost LeaveLocked
            ENDIF
         ENDIF
      ENDIF
      MoveTo FIELD originalField.a
      IF edit.l THEN
         [] = r[2]
      ENDIF
   ELSE
      msContinue.u("","Sorry, that Record has been Deleted!",112,"GRAY",2)
   ENDIF
   msWorkingClear.u()
   Return
ENDPROC
WriteLib libname.a lkHelpTableEdit.u
?? "\004"
; ============================================================================
;       TITLE: lkHelpUtility.l           (c) 1992, 1993 DataStar International
;     RETURNS: Logical True/False if Special Lookup
; DESCRIPTION: Handles Date/Calendar and Number/Calculator lookups
; ----------------------------------------------------------------------------
PROC lkHelpUtility.l()           ; Calls Calculator for #/Calendar for Date
Private  retval.l,
         retval.v,
         mode.a
   retval.l = false
   IF IsAssigned(wp.y) AND IsAssigned(wp.y["Mode.a"]) THEN
      mode.a = wp.y["mode.a"]
   ELSE
      mode.a = IIF(IsAssigned(waitmode.a),waitmode.a,"CANCEL")
   ENDIF
   IF Search(mode.a,"EDIT ADD") <> 0 THEN
      SWITCH
         CASE FieldType() = "D" :
            retval.v = dtHBCalendar.d()
            IF NOT IsBlank(retval.v) THEN
               [] = retval.v
            ENDIF
            retval.l = true
         CASE Search(FieldType(),"N$S") <> 0 :
            retval.v = DT_UTILS_CALCULATOR()
            IF NOT IsBlank(retval.v) THEN
               [] = retval.v
            ENDIF
            retval.l = true
      ENDSWITCH
   ENDIF
  Return retval.l
ENDPROC
WriteLib libname.a lkHelpUtility.l
?? "\004"
