; ****************************************************************************
; SCRIPT NAME: ds4_HELP.sc               (c) 1992, 1993 DataStar International
; APPDEV TEAM: Dan Paolini, David Kelton, Micah Bleecher, Patty Paolini
; APPLICATION: DataStar Utilities for Paradox 4
; DESCRIPTION: Contains the following Help procedures:
;                 hsEngine.u
;                 hsEngineDefaultHelp.u
;                 hsEngineEventhandler.l
;                 hsEngineHelp.l
;                 hsEngineIndex.l
;                 hsEnginePrint.l
;                 hsEngineSeeAlso.l
;                 hsCompileHelpScreens.l
;                 hsCompileDuplicateProcs.l
;                 hsCompileHelpIndex.u
;                 11 Standard Help Screens
; ============================================================================
? Format("w40"," ds4_HELP.sc  - Help Routines")
IF NOT IsAssigned(libname.a) THEN
   Beep Beep Beep QUIT "Variable \"libname.a\" is not assigned!.."
ENDIF
IF NOT IsFile(libname.a+".LIB") THEN
   CreateLib libname.a Size 640
ENDIF
@ Row(),40
;=============================================================================
;       TITLE: hsEngine.u                (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Main help engine procedure. Expects global DynArray called
;              g.help.y to contain tags pointing to procedure created by
;              the help compiler the load the necessary text strings into
;              the proper arrays.
;-----------------------------------------------------------------------------
PROC hsEngine.u(                 ; Help System Display Manager
         context.a,              ; Help procedure DynArray tag
         g.help.y)               ; Help Procedure DynArray
Private  help.n,                 ; pick array index
         colorsHelp.y,           ; color attributes of dialog box
         prompts.y,              ; prompts on dialog box
         helpTag.a,              ; current element
         seeAlso.r,              ; array of linked topics
         seeAlsoTitles.r,        ; array of linked topic titles
         title.a,                ; current title
         dbox.w,                 ; DB window handle
         pushButton.l,           ; button variable
         helpText.r,             ; array of help text
         retval.v                ; return variable

   DynArray colorsHelp.y[]
      colorsHelp.y[1032] = 116
      colorsHelp.y[1034] = 15
      colorsHelp.y[1035] = 15
      colorsHelp.y[1056] = 112
      colorsHelp.y[1057] = 112
      colorsHelp.y[1058] = 112
   SetColors From colorsHelp.y
   IF IsAssigned(g.help.y[context.a]) THEN
      ExecProc g.help.y[context.a]
      ; This procedure should assign the memovar for help, as well as
      ; the ShowPullDown Menu
   ELSE
      ; Default Help Text and Menu
      IF IsAssigned(g.help.y["DEFAULT"]) THEN
         EXECPROC g.help.y["DEFAULT"]
      ELSE
         Array helpText.r[31]
         Array seeAlso.r[1]
         hsEngineDefaultHelp.u()
      ENDIF
   ENDIF

   DynArray prompts.y[]
      prompts.y["TEXT"]  = "Use Mouse, Cursor  Keys or <PgUp>/<PgDn> to Scroll Help Text"
      prompts.y["HELP"]  = "How to Use the Help System"
      prompts.y["INDEX"] = "Index of Available Help Screens"
      prompts.y["ALSO"]  = "Menu of Related Help Topics"
      prompts.y["PRINT"] = "Print this Help Screen"
      prompts.y["BACK"]  = "Return to Previous Help Screen"
      prompts.y["EXIT"]  = "Return to what you were doing before Help"
   retval.v     = ""
   pushButton.l = false
   helpTag.a = "TEXT"

   title.a = IIF(IsAssigned(g.helpIndex.y[context.a]),
                            g.helpIndex.y[context.a],
                           "Application Help System")
   SHOWDIALOG title.a
      PROC "hsEngineEventHandler.l"
         Trigger "ARRIVE","OPEN"  ;MJB 1/27/93
      @ 2, 3 Height 20 Width 74
      PaintCanvas Fill Format("w70,ac",prompts.y[helpTag.a])
                  Attribute 113 17,1,17,70
      Frame Single From 0,1 To 14,70
         PaintCanvas Border Attribute 127 0,1,14,70
         PaintCanvas Attribute 112 0,1,0,69
         PaintCanvas Attribute 112 0,1,14,1
      PickArray @ 1,2 Height 13 Width 67
         helpText.r Tag "TEXT"
      To help.n

      PushButton @ 15, 5 Width 8 "~H~elp"
         Value hsEngineHelp.l() Tag "HELP"
      To pushButton.l

      PushButton @ 15, 17 Width 9 "~I~ndex"
         Value hsEngineIndex.l(g.helpIndex.y)
         Tag "INDEX"
      To pushButton.l

      PushButton @ 15, 30 Width 12 "~S~ee Also"
         Value hsEngineSeeAlso.l(seeAlso.r,seeAlsoTitles.r) Tag "ALSO"
      To pushButton.l

      PushButton @ 15, 46 Width 9 "~P~rint"
         Value hsEnginePrint.l(helpText.r) Tag "PRINT"
      To pushButton.l

      PushButton @ 15, 59 Width 8 "~E~xit"
         Cancel Value False Tag "EXIT"
      To pushButton.l
   ENDDIALOG
   SetColors From g.appColors.y
   msWorkingClear.u()
   Return
ENDPROC
?? "\004"
WRITELIB libname.a hsEngine.u
;=============================================================================
;       TITLE: hsEngineDefaultHelp.u     (c) 1992, 1993 DataStar International
;     RETURNS: No value
; DESCRIPTION: Main help engine default help.
;-----------------------------------------------------------------------------
PROC hsEngineDefaultHelp.u()     ; Help System Default Help
   helpText.r[1] =  ""
   helpText.r[2] =  ""
   helpText.r[3] =  "       Help on Using the DataStar Help System Ŀ"
   helpText.r[4] =  "                                                    "
   helpText.r[5] =  "                                                    "
   helpText.r[6] =  "            Help     Brings Up This Screen.        "
   helpText.r[7] =  "                                           "
   helpText.r[8] =  "       "
   helpText.r[9] =  "       "
   helpText.r[10] = "       "
   helpText.r[11] = "         Index      Displays Index of Help Topics."
   helpText.r[12] = "        "
   helpText.r[13] = "       Ŀ"
   helpText.r[14] = "                                                     "
   helpText.r[15] = "                                                     "
   helpText.r[16] = "          SeeAlso    Displays List of Linked Topics "
   helpText.r[17] = "            if any Exist.                  "
   helpText.r[18] = "                                                     "
   helpText.r[19] = "       "
   helpText.r[20] = "       "
   helpText.r[21] = "       "
   helpText.r[22] = "          Print     Sends Current Help Screen To"
   helpText.r[23] = "           the Printer."
   helpText.r[24] = "       "
   helpText.r[25] = "       Ŀ"
   helpText.r[26] = "                                                     "
   helpText.r[27] = "           Exit      Exit the Help System Back to   "
   helpText.r[28] = "            the Application.               "
   helpText.r[29] = "                                                     "
   helpText.r[30] = "                                                     "
   helpText.r[31] = "      "
   Return
ENDPROC
?? "\004"
WRITELIB libname.a hsEngineDefaultHelp.u
;=============================================================================
;       TITLE: hsEngineEventHandler.l    (c) 1992, 1993 DataStar International
;     RETURNS: Nothing
; DESCRIPTION: Event proc for help engine dialog boxes
;-----------------------------------------------------------------------------
PROC hsEngineEventHandler.l(       ; Event proc for help engine dialog boxes
         type.a,                   ; Event type or trigger
         tag.a,                    ; Name of current TAG
         event.v,                  ; Event bag
         element.a)                ; Element for check boxes
   IF type.a = "OPEN" THEN
      WINDOW HANDLE DIALOG TO dbox.w
   ENDIF
   helpTag.a = tag.a
   RepaintDialog
   Return true
ENDPROC
?? "\004"
WRITELIB libname.a hsEngineEventHandler.l
;=============================================================================
;       TITLE: hsEngineHelp.l            (c) 1992, 1993 DataStar International
;     RETURNS: True, for Help Engine Dialog Button
; DESCRIPTION: Called by Help Engine Help Button
;-----------------------------------------------------------------------------
PROC hsEngineHelp.l()                ; Called by Help Engine Help Button
Private  helpText.r,                 ; Array of help text
         pushButton.l,               ; Pushbutton variable
         help.n,                     ; Pickarray index
         helpTag.a                   ; Current element

   IF IsAssigned(g.help.y["HELP"]) THEN
      EXECPROC g.help.y["HELP"]
   ELSE
      Array helpText.r[31]
      Array seeAlso.r[1]
      hsEngineDefaultHelp.u()
   ENDIF
   helpTag.a = "TEXT"
   SHOWDIALOG "Help on Using Help"
      PROC "hsEngineEventHandler.l"
         Trigger "ARRIVE"
      @ 2, 3 Height 20 Width 74
      PaintCanvas Fill Format("w70,ac",prompts.y[helpTag.a])
                  Attribute 113 17,1,17,70
      Frame Single From 0,1 To 14,70
         PaintCanvas Border Attribute 127 0,1,14,70
         PaintCanvas Attribute 112 0,1,0,69
         PaintCanvas Attribute 112 0,1,14,1
      PickArray @ 1,2 Height 13 Width 67
         helpText.r Tag "TEXT"
      To help.n

      PushButton @ 15, 24 Width 24 "~P~revious Help Screen"
         OK Value True Tag "BACK"
      To pushButton.l
   ENDDIALOG
   Return true
ENDPROC
?? "\004"
WRITELIB libname.a hsEngineHelp.l
;=============================================================================
;       TITLE: hsEngineIndex.l           (c) 1992, 1993 DataStar International
;     RETURNS: Logical true
; DESCRIPTION: Help System index. Select with index button on the help DB.
;-----------------------------------------------------------------------------
PROC hsEngineIndex.l(            ; Help System Index Engine
         helpIndex.y)            ; index DynArray
Private  pushButton.l,           ; button variable
         y                       ; window attributes DynArray

   IF DynArraySize(helpIndex.y) = 0 THEN
      msWorking.u("Sorry, No Help Index is Available in this System",111,2,2)
   ELSE
   pushButton.l = false
   DynArray y[]

   SetColors From g.appColors.y

   SHOWDIALOG "Select Help Topic"
      @ 3,17 Height 15 Width 49 ;46 MJB 1/27/93
      PickDynArray
         @ 1,1 Height 9 Width 43
         helpIndex.y Tag "PICKINDEX"
      To context.a

      PushButton @ 11,8 Width 10 "~S~elect"
         OK Default Value True Tag "INDEXBUTTON"
      To pushButton.l

      PushButton @ 11,26 Width 10 "~C~ancel"
         Cancel Value False Tag "INDEXBUTTON"
      To pushButton.l
   ENDDIALOG
   SetColors From colorsHelp.y

   IF pushButton.l THEN
      ExecProc g.help.y[context.a]
      y["Title"] = IIF(IsAssigned(g.helpIndex.y[context.a]),
                               g.helpIndex.y[context.a],
                               "Application Help System")
      WINDOW SetAttributes dbox.w FROM y
      help.n = 1
      RefreshDialog
      SelectControl "TEXT"
   ENDIF
   ENDIF
   Return true
ENDPROC
?? "\004"
WRITELIB libname.a hsEngineIndex.l
;===========================================================================
;       TITLE: hsEnginePrint.l         (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false if
; DESCRIPTION:
;---------------------------------------------------------------------------
PROC hsEnginePrint.l(            ; Help System Screen Print
         helpText.r)             ; generic editor handler
Private  n1, n2,                 ; counter variables
         a,                      ; temp file name
         file.m,                 ; memo text stream
         line.n                  ; line number counter

   IF ioPrinterStatus.l() THEN   ; test printer
      msWorking.u("One Moment - Printing Help Screen",31,0,0)
      n1 = ArraySize(helpText.r)
      a = PrivDir() + StrVal(Ticks())

      file.m = "\n" + Format("w80,ac","Help Screen: " + g.helpIndex.y[context.a])
      file.m = file.m + "\n" + Spaces(10) + Fill("-",60) + "\n\n"
      line.n = 3

      FOR n2 From 1 To n1
         line.n = line.n + 1
         file.m = file.m +  Spaces(10) + helpText.r[n2] + "\n"
         IF line.n >= 55 AND line.n <> n1 THEN
            file.m = file.m + "\012\n\n"
            line.n = 2
         ENDIF
      ENDFOR

      file.m = file.m + "\012"

      FileWrite a FROM file.m

      OPEN Printer
         Run NOREFRESH "Copy " + a + " LPT1 > NUL"
         EDITOR OPEN a DO_IT!
      CLOSE Printer
      msWorkingClear.u()
   ENDIF
   Return true
ENDPROC
?? "\004"
WRITELIB libname.a hsEnginePrint.l
;===========================================================================
;       TITLE: hsEngineSeeAlso.l       (c) 1992, 1993 DataStar International
;     RETURNS: Logical true/false
; DESCRIPTION:
;---------------------------------------------------------------------------
PROC hsEngineSeeAlso.l(          ; Help System See-Also Engine
         seeAlso.r,              ; Array of module names
         seeAlsoTitles.r)        ; Array of help screen titles
Private  seeAlso.v,              ; return variable from ioPickArray
         helpTag.a,              ; current element
         retval.l,               ; return variable
         help.n,                 ; pick array index
         helpText.r,             ; help text array
         pushButton.l            ; button variable
   retval.l = true

   WHILE true
      IF IsAssigned(seeAlso.r[1]) THEN

         SetColors From g.appColors.y
         seeAlso.v = ioPickArrayDialog.v(seeAlsoTitles.r, 43,
                              "Select See Also Help Topic",
                              "Help Topics",3,17,"")
         SetColors From colorsHelp.y
         IF seeAlso.v <> "" THEN
         IF IsAssigned(seeAlso.r[seeAlso.v]) THEN
            EXECPROC "ds4Help" + seeAlso.r[seeAlso.v] + ".u"
         ELSE
            retval.l = false
            QUITLOOP
         ENDIF
         ELSE
            QUITLOOP
         ENDIF

      ELSE
         retval.l = false
         QUITLOOP
      ENDIF

      helpTag.a = "TEXT"
      SHOWDIALOG seeAlsoTitles.r[seeAlso.v]
         PROC "hsEngineEventHandler.l"
            Trigger "ARRIVE"
         @ 2, 3 Height 20 Width 74
         PaintCanvas Fill Format("w70,ac",prompts.y[helpTag.a])
                     Attribute 113 17,1,17,70
         Frame Single From 0,1 To 14,70
         PaintCanvas Border Attribute 127 0,1,14,70
         PaintCanvas Attribute 112 0,1,0,69
         PaintCanvas Attribute 112 0,1,14,1
         PickArray
            @ 1,2
            Height 13 Width 67
            helpText.r Tag "TEXT"
         To help.n

         PushButton @ 15, 24 Width 24 "~P~revious Help Screen"
            OK Value True Tag "BACK"
         To pushButton.l
      ENDDIALOG
      QUITLOOP
   ENDWHILE
   IF NOT retval.l THEN
    msWorking.u("No Links Available for this Topic - Choose <Index>",31, 3, 2)
   ENDIF
   Return retval.l
ENDPROC
?? "\004"
WRITELIB libname.a hsEngineSeeAlso.l
; ============================================================================
;       TITLE: hsCompileHelpScreens.l        (c) 1993 - DataStar International
;     RETURNS: Logical true/false if successful
; DESCRIPTION: Compiles help screens from memo fields into procedures
;              that assign text lines to array elements. Requires multi-
;              table form with a detail table that refers to see also links.
;
;               HELP.DB has 3 Fields and 1 Primary Key Field
;               Field #   Name                         Type   Key
;              
;                  1      Context                      A40     *
;                  2      ProcName                     A35
;                  3      Help                         M40
;
;               SEEHELP.DB has 2 Fields and 2 Primary Key Fields
;               Field #   Name                         Type   Key
;              
;               1      Context                      A40     *
;               2      ContextLink                  A40     *
; ---------------------------------------------------------------------------
PROC hsCompileHelpScreens.l(       ; Help system Compiler proc
         helptable.a,            ; Name of table with help memos
         helpform.a,             ; Name of multi table help form
         helpdetail.a,           ; Name of embedded see also table
         filename.a)             ; Output file name (No extension)

Private  memo.m,                 ; help memo variable
         line.n,                 ; line length limit
         line.a,                 ; current line variable
         y,                      ; line DynArray
         n1, n2, n3,             ; Loop counters
         lastspace.n,            ; last space pointer
         links.r,                ; array to hold See also links
         filename.a,             ; output file name
         helplines.n,            ; number of help text lines
         linkRecords.n,             ; number of see also records
         helpscreen.n,           ; number of help screens counter
         duplicateProcs.l,       ; duplicate procedure assignments
         duplicateProcs.y,       ; duplicate procedure DynArray
         locklist.a,             ; tables and locks list
         maxlen.n,               ;
         totalhelp.n,            ;
         helpIndex.y,            ;
         quit.l                  ;

   locklist.a = "\"" + inPathDouble.a(helptable.a) + "\" PFL,\"" +
                       inPathDouble.a(helpdetail.a) + "\" PFL"
   IF tbLockTables.l(locklist.a) THEN
      DynArray helpIndex.y[]
      msWorking.u("W",111,0,0)
      duplicateProcs.l  = false
      quit.l            = false
      helpscreen.n      = 0
      maxlen.n          = 66
      totalhelp.n       = NRecords(helptable.a)

      {Ask} Select helptable.a
         MoveTo [ProcName]   CHECK
         TypeIn "calc count ALL as PROCS"
      quExecute.l(True)

      {Ask} Select "Answer"
         [ProcName] = "_procname"
         [PROCS] = "> 1"
      {Ask} Select helptable.a
         MoveTo  [Context]   CHECK
         MoveTo  [ProcName]  CHECK
         TypeIn "_procname"
      quExecute.l(false)

      IF NOT IsEmpty("Answer") THEN
         MoveTo "Answer"
         DynArray duplicateProcs.y[]
         SCAN
            duplicateProcs.y[[Context]] = [Context]+" : "+[ProcName]
         ENDSCAN
         msWorkingClear.u()
         quit.l = NOT hsCompileDuplicateProcs.l.l()
         duplicateProcs.l = true
      ENDIF
      ClearAll

      IF NOT quit.l THEN
         msWorking.u("Compiling Help Screens, Please Wait",111,0,0)
         tbView.u(helptable.a,true)
         wsPickForm.l(helpform.a)
         Editor New PrivDir() + fileName.a + ".SC"
         {Cancel} {Yes}

         CoEditKey
         SCAN
            helpIndex.y[[ProcName]] = [Context]
            helpscreen.n = helpscreen.n + 1
            Message "Processing Help Screen ",helpscreen.n," of ",totalhelp.n

            ; initialize variables for each help
            memo.m = [Help]
            len.n = Len(Memo.m)
            lastspace.n = 0
            line.n = 1
            DynArray y[]
            line.a = ""

            IF NOT IsBlank(memo.m) THEN
               FOR n1 FROM 1 TO len.n
                  memo.m = "" + memo.m  ; Paradox 4 memo bug
                  IF SubStr(line.a,Len(line.a),1) = " " THEN
                     lastspace.n = Len(line.a)
                  ENDIF
                  SWITCH
                     CASE SubStr(memo.m,n1,1) = "\n"
                       OR SubStr(memo.m,n1,1) = "\r" :
                        y[line.n] = line.a
                        line.a = ""
                        lastspace.n = 0
                        line.n = line.n + 1
                     CASE Len(line.a) = maxlen.n :
                        memo.m = "" + memo.m
                        SWITCH
                           CASE SubStr(line.a,Len(line.a),1) = " " :
                              y[line.n] = SubStr(line.a,1,Len(line.a)-1)
                              n1 = n1 - 1
                           CASE SubStr(memo.m,n,1) = "\n"
                             OR SubStr(memo.m,n,1) = "\r" :
                              y[line.n] = line.a
                              n1 = n1 + 1
                           OTHERWISE:
                              IF lastspace.n = 0 THEN
                                 y[line.n] = line.a
                              ELSE
                                 y[line.n] = SubStr(line.a,1,lastspace.n-1)
                                 n1 = n1 - (Len(line.a) - Len(y[line.n]))
                              ENDIF
                        ENDSWITCH
                        line.a = ""
                        lastspace.n = 0
                        line.n = line.n + 1
                     OTHERWISE:
                        memo.m = "" + memo.m
                        IF n1 = len.n THEN
                           line.a = line.a + SubStr(memo.m,n1,1)
                           y[line.n] = line.a
                           line.a = ""
                           lastspace.n = 0
                           line.n = line.n + 1
                        ELSE
                           line.a = line.a + SubStr(memo.m,n1,1)
                        ENDIF
                  ENDSWITCH
               ENDFOR
            ENDIF

            DownImage
            linkRecords.n = IIF(RecordStatus("New"),0,NImageRecords())
            IF linkRecords.n > 0 THEN
               Array links.r[linkRecords.n]
               n2 = 0
               SCAN
                  n2 = n2 + 1
                  links.r[n2] = [ContextLink]
               ENDSCAN
            ENDIF
            UpImage

            helplines.n = DynArraySize(y)
            Print File filename.a + ".SC" "\n\n"
            Print File filename.a + ".SC" "; ",Fill("-",75),"\n"
            Print File filename.a + ".SC" ";       TITLE: ",[ProcName],"\n"
            Print File filename.a + ".SC" ";   GENERATED: ",Today()," - ",Time(),"\n"
            Print File filename.a + ".SC" "; DESCRIPTION: Help Screen: ",[Context],"\n"
            Print File filename.a + ".SC" "; \n"
            Print File filename.a + ".SC" "; ",Fill("=",75),"\n"
            Print File filename.a + ".SC" "PROC ",[ProcName],"()\n\n"
            Print File filename.a + ".SC" ";Global  helpText.r,     ;array of Help Text\n"
            Print File filename.a + ".SC" ";         seeAlso.r      ;array of See Also links\n"
            Print File filename.a + ".SC" "\n\n"
            Print File filename.a + ".SC" "IF NOT IsAssigned(g.helpIndex.y) THEN\n"
            Print File filename.a + ".SC" "   DynArray g.helpIndex.y[]\n"
            Print File filename.a + ".SC" "ENDIF\n"
            Print File filename.a + ".SC" "g.helpIndex.y[\"",[ProcName],"\"] = \"",[Context],"\"\n"
            Print File filename.a + ".SC" "\n\n"
            Print File filename.a + ".SC" "Array helpText.r[",Max(1,helplines.n),"]\n"
            Print File filename.a + ".SC" "Array seeAlso.r[",Max(1,linkRecords.n),"]\n"
            Print File filename.a + ".SC" "\n"

            FOR n1 From 1 TO helplines.n
               len.n = Len(y[n1])
               FOR n3 From len.n To 1 Step -1
                  IF Search(SubStr(y[n1],n3,1),"\\\"") > 0 THEN
                     y[n1] = SubStr(y[n1],1,n3-1)+"\\" +
                           SubStr(y[n1],n3,Len(y[n1]))
                  ENDIF
               ENDFOR
            ENDFOR
            FOR n1 FROM 1 TO helplines.n
               Print File filename.a+".SC" "helpText.r[",n1,"] = \"",y[n1],"\"\n"
            ENDFOR
            Print File filename.a+".SC" "\n"
            IF linkRecords.n > 0 THEN
               FOR n1 FROM 1 TO linkRecords.n
                  Print File filename.a+".SC" "seeAlso.r[",n1,"] = \"",links.r[n1],"\"\n"
               ENDFOR
            ENDIF
            Print File filename.a + ".SC" "\n"
            Print File filename.a + ".SC" "RETURN\n"
            Print File filename.a + ".SC" "ENDPROC\n"
            Print File filename.a + ".SC" "?? \"\\004\"\n"
            Print File filename.a + ".SC" "WRITELIB libname.a ",[ProcName],"\n"
         ENDSCAN
         Do_It!
         hsCompileHelpIndex.u(helpIndex.y,filename.a)
      ENDIF
   ENDIF
   ClearImage
   msWorkingClear.u()
   Execute "UnLock " + locklist.a
   Return IIF(duplicateProcs.l,false,true)
ENDPROC
?? "\004"
WRITELIB libname.a hsCompileHelpScreens.l
; ============================================================================
;       TITLE: hsCompileDuplicateProcs.l()   (c) 1993 - DataStar International
;     RETURNS: Logical
; DESCRIPTION: Displays list of help screens that point to duplicate
;              procedure names giving the user the option to continue/cancel
; ----------------------------------------------------------------------------
PROC hsCompileDuplicateProcs.l() ; Identifies duplicate procedure names
Private  button.l,               ; Button variable
         duplicateProcs.a        ; PickDynArray pointer
;Global  duplicateProcs.y        ; DynArray of duplicate help screens

   button.l = false
   SHOWDIALOG "Duplicate Help Procedure Names"
      @ 3,8 Height 17 Width 66
      Frame Single From 1,0 To 12,63
         PaintCanvas Border Attribute 112 1,0,12,63
         PaintCanvas Attribute 127 12,1,12,63
         PaintCanvas Attribute 127 1,63,12,63

      PaintCanvas Fill "The Following Help Screens Refer To Duplicate Procedure Names"
                  Attribute 116 0,1,0,63

      PickDynArray @2,1 Height 10 Width 61 Columns 1
         duplicateProcs.y Tag "DUPES"
      To duplicateProcs.a

      PushButton @13,1 Width 30 "~C~ontinue Compilation"
         OK Value True Tag "OK"
      To button.l

      PushButton @13,33 Width 30 "~Q~uit Process and Return"
         Cancel Default Value False Tag "CANCEL"
      To button.l
  ENDDIALOG
  Return retval
ENDPROC
?? "\004"
WriteLib libname.a hsCompileDuplicateProcs.l
; ============================================================================
;       TITLE: hsCompileHelpIndex.u()        (c) 1993 - DataStar International
;     RETURNS: No value
; DESCRIPTION: Creates HelpIndex procedure
; ----------------------------------------------------------------------------
PROC hsCompileHelpIndex.u(       ; Creates HelpIndex procedure
         index.y,                ; DynArray of indices
         filename.a)             ; Filename for source script to write
Private  a                       ; ForEach Loop counter

   Print File filename.a + ".SC" "\n\n"
   Print File filename.a + ".SC" "; ",Fill("-",75),"\n"
   Print File filename.a + ".SC" ";       TITLE: LoadhelpIndex.u\n"
   Print File filename.a + ".SC" ";   GENERATED: ",Today()," - ",Time(),"\n"
   Print File filename.a + ".SC" "; DESCRIPTION: Loads Help Index DynArray\n"
   Print File filename.a + ".SC" "; \n"
   Print File filename.a + ".SC" "; ",Fill("=",75),"\n"
   Print File filename.a + ".SC" "PROC LoadhelpIndex.u()\n\n"
   Print File filename.a + ".SC" ";Global  g.helpIndex.y     ;DynArray of Generic Help Calls\n"
   Print File filename.a + ".SC" "\n\n"
   Print File filename.a + ".SC" "IF NOT IsAssigned(g.helpIndex.y) THEN\n"
   Print File filename.a + ".SC" "   DynArray g.helpIndex.y[]\n"
   Print File filename.a + ".SC" "ENDIF\n"
   FOREACH a IN index.y
      Print File filename.a+".SC" "g.helpIndex.y[\"",a,"\"] = \"",index.y[a],"\"\n"
   ENDFOREACH
   Print File filename.a + ".SC" "\n\n"
   Print File filename.a + ".SC" "RETURN\n"
   Print File filename.a + ".SC" "ENDPROC\n"
   Print File filename.a + ".SC" "?? \"\\004\"\n"
   Print File filename.a + ".SC" "WRITELIB libname.a LoadhelpIndex.u\n"
   Return
ENDPROC
?? "\004"
WRITELIB libname.a hsCompileHelpIndex.u
; ===========================================================================
;       TITLE: hsAsk.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No Value
; DESCRIPTION: Help with performing Queries
; ---------------------------------------------------------------------------
PROC hsAsk.u()
Text
  Help on Using Ad Hoc Queries  ͻ
                                                                              
                                                                              
   Unlike Interactive Paradox, Query By Example is not easily handled within  
   an application.  Instead, you are provided with a Query By Form process.   
                                                                              
   You are presented with a form that has the Queriable fields for the type   
   of Query you have selected.  Place any Query criteria in the appropriate   
   fields of this form, and press [F2] to perform the Query.  If any of the   
   criteria that you have entered is not appropriate, you will be advised     
   and given a chance to re-do the Query criteria.  You may not use either    
   an underscore or the word Changeto in your criteria.                       
                                                                              
                           QUERY PATTERN OPERATORS                            
                                                                              
   ..  - Wild card for any characters    LIKE - Like the criterion (close)    
   @   - Wild card for one character     NOT  - Not the criterion             
   >   - Greater than the criterion      >=   - Greater than or equal to      
   <   - Less than the criterion         <=   - Less than or equal to         
   =   - Equal to the criterion          ABCD - Exact match for "ABCD"        
                                                                              
     Wild cards are insensitive to Case, Exact matches are Case Sensitive     
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a   hsAsk.u
Release PROCS        hsAsk.u
?? ""
; ===========================================================================
;       TITLE: hsDitto.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Describes how to use the Ditto Command
; ---------------------------------------------------------------------------
PROC hsDitto.u()
Text
  Help on Using the DITTO Key - [Ctrl+D]  ͻ
                                                                              
   The Ditto Key [Ctrl+D] will duplicate the value of the current field from  
   the previous record, and place it in the current field of the current      
   record.  The current field must be empty.                                  
                                                                              
   This is easy to understand in Table View or when working in Multi-Record   
   Forms.  The value is copied from the record above the current record.      
                                                                              
   It also works while in single record Form View.  You do not need to see    
   the record that is being copied.  It will duplicate a value from the       
   previous record, even when that record is not being displayed.             
                                                                              
   The field that in which you want to place the duplicate value must be      
   empty before you press [Ctrl+D].  If it is not, you can press [Ctrl+       
   BackSpace] to erase the entire field first.                                
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "KEYBOARD"
   Return
ENDPROC
WriteLib libname.a   hsDitto.u
Release PROCS        hsDitto.u
?? ""
; ===========================================================================
;       TITLE: hsDup_Keys.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No Value
; DESCRIPTION:
; ---------------------------------------------------------------------------
PROC hsDup_Keys.u()
Text
  Help on Dealing with Duplicate Keys  ͻ
                                                                              
   When entering records in a Keyed table, Paradox insures that two records   
   can not have duplicate keys.  This helps maintain the integrity of the     
   system (to keep from mixing up information between different records in    
   the database).                                                             
                                                                              
   If you try to edit or add a record that would result in a record with      
   key fields that duplicate an existing record, this is referred to as a     
   key violation.  One of two things will happen, depending on the part of    
   the application you are using:                                             
                                                                              
       * You will be brought to the existing record to continue making        
         changes, and the record you were attempting to add or edit will      
         not be processed.                                                    
                                                                              
       * You will be presented a menu, from which you can choose to:          
                                                                              
          - Edit the current record so as to remove the key violation         
          - Replace the existing record with the current record               
          - Cancel the current record.                                        
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a hsDup_Keys.u
Release PROCS      hsDup_Keys.u
?? ""
; ===========================================================================
;       TITLE: hsFieldEdit.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Describes how to use the FieldView Command
; ---------------------------------------------------------------------------
PROC hsFieldEdit.u()
Text
  Help on Using Field View - [Ctrl+F]  ͻ
                                                                              
   The Field View Key [Ctrl+F] (or alternately [Alt+F5]) allows you to work   
   within the current field.  While this is principally used for Editing,     
   Field View also works when Viewing information.                            
                                                                              
   Without Field View, if you have a field consisting of many characters,     
   and you need to make a correction to the first character, you will have    
   to backspace over the trailing characters to get to the first character.   
   In effect, you will be erasing all of the subsequent characters.           
                                                                              
   With Field View, after hitting [Ctrl+F], you can use the Cursor Keys       
   [-] [-] [Home] [End] to move within the field contents without erasing   
   any of the information.                                                    
                                                                              
   You can use [Del] to Delete the character at the cursor, [Ins] to toggle   
   between Insert/OverStrike, [Ctrl+-] to move one word to the right, and    
   [Ctrl+-] to move one word to the left.                                    
                                                                              
   You must press [Enter] or [F2] to end Field View, before control is        
   returned to normal record movement.                                        
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "KEYBOARD"
   Return
ENDPROC
WriteLib libname.a   hsFieldEdit.u
Release PROCS        hsFieldEdit.u
?? ""
; ===========================================================================
;       TITLE: hsHelp.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No Value
; DESCRIPTION: How to Use the Help System
; ---------------------------------------------------------------------------
PROC hsHelp.u()
Text
  How to Use this Help System  ͻ
                                                                              
  Throughout this application, you will have the opportunity to access what   
  is referred to as Context-sensitive Help.  When you press the Help Key,     
  usually [Alt+H], the application will make an attempt to determine where    
  you are.  It will present you a help screen like this one that provides     
  more information about that part of the application.                        
                                                                              
  The application will not always make the correct decision concerning with   
  what topic you require help.  A menu will be displayed, like the one above  
  this screen, from which you may select other Help topics.  Some choices     
  lead to additional Help Menus.                                              
                                                                              
  RETURN (or [Esc]) will return you to where you were before you chose Help.  
                                                                              
  CUSTOM will present the menu for Custom Help specific to this application.  
                                                                              
  HELPMENU will take you to the main, core Help Menu and this screen.         
                                                                              
                                                                              
                                                                              
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a hsHelp.u
Release PROCS      hsHelp.u
?? ""
; ===========================================================================
;       TITLE: hsKeyboard.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Help for Paradox Keyboard - most text in revised version has
;              been borrowed from the equivalent screen in Wait Plus Pro.
;              Used with permission.
; ---------------------------------------------------------------------------
PROC hsKeyboard.u()
Text
  Help on Using the Keyboard  ͻ
       [Left] Previous field left         [Home] First record                 
      [Right] Next field right       [Ctrl+Home] First field of form or table 
         [Up] Next field up                [End] Last record                  
       [Down] Next field down         [Ctrl+End] Last field of form or table  
       [PgDn] Next screen down            [PgUp] Next screen up               
  [Ctrl+PgDn] Next record            [Ctrl+PgUp] Previous record              
 [Ctrl+Right] Next screen right      [Ctrl+Left] Previous screen left         
Ķ
        [Esc] Exits table or menu           [F1] Field help if available      
         [F3] UpImage                       [F4] DownImage                    
         [F7] FormToggle                   [F10] Gets menu if available       
  [Backspace] Deletes to left   [Ctrl+Backspace] Delete field                 
     [Ctrl+Z] Zoom to first value        [Alt+Z] Zoom to the next value       
     [Ctrl+D] Usually Dittos (copies field from previous record)              
Ķ
 To allow cursor movement within field (FieldView) press [Ctrl+F] or [Alt+F5] 
                   Cursor pad keys while in FieldView                   
       [Left] Previous character          [Home] First character in field     
      [Right] Next character               [End] Last character in field      
 [Ctrl+Right] Next word right              [Del] Deletes character at cursor  
  [Ctrl+Left] Prev word left               [Ins] Toggles insert mode on/off   
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "KEYBOARD"
   Return
ENDPROC
WriteLib libname.a   hsKeyboard.u
Release PROCS        hsKeyboard.u
?? ""
; ===========================================================================
;       TITLE: hsMenus.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Describes how to work with Menus.  This is from the WaitPlus
;              Pro Menu Help text.  Used with permission.
; ---------------------------------------------------------------------------
PROC hsMenus.u()
Text
  Help on Using the Menus  ͻ
                                                                              
  A menu presents you with a list of options available at any given point.    
  Each menu choice has a descriptive line attached to it.  To use Menus:      
Ķ
                                                                              
  Press the first letter of the menu selection.  If there is more than one    
  choice beginning with the first letter, you will be asked to select from    
  those that begin with that letter.                                          
                                                                              
  Use [Left] or [Right] arrow keys to highlight the menu choice, then press   
  [Enter].  When menu choice is highlighted, it displays descriptive prompt   
                                                                              
  To escape from the menu, returning to whatever you were doing before you    
  selected it, press [Esc].                                                   
Ķ
  Special keys:     [F1]  Displays Additional Help (if available).            
                  [Home]  Moves to first menu selection.                      
                   [End]  Moves to last menu selection.                       
                  [Down]  Moves right one screen (if available).              
                    [Up]  Moves left one screen (if available).               
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "KEYBOARD"
   Return
ENDPROC
WriteLib libname.a   hsMenus.u
Release PROCS        hsMenus.u
?? ""
; ===========================================================================
;       TITLE: hsOutput.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No Value
; DESCRIPTION: Help with Printing
; ---------------------------------------------------------------------------
PROC hsOutput.u()
Text
  Help on Printing Reports  ͻ
                                                                              
   In most situations in which you are processing a report, the application   
   will actually save the report to a temporary file on the disk.  Once this  
   is done, you will have the opportunity to select the output destination    
   for the report.  After each output destination is processed, you will be   
   returned to the output destination menu, from which you can choose to      
   send the report to the same destination again, send the report to a new    
   destination, or return from the routine.  Your destination choices are:    
                                                                              
        DEFAULT - The printer assigned to the default printer port for        
                  this application and workstation.                           
                                                                              
        SCREEN  - You can view the report on the Screen.  While here, you     
                  can scroll up, down, left or right.  When finished, press   
                  [Esc] to return to the Destination Menu.                    
                                                                              
        OTHER   - You can send the report to another Printer Port.            
                                                                              
        FILE    - You can save the report to a permanent file, so that you    
                  can return to it for future reference.                      
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a   hsOutput.u
Release PROCS        hsOutput.u
?? ""
; ===========================================================================
;       TITLE: hsPickLists.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: I use the Point and Shoot method for selecting a Master
;              record to work with.  This avoids having to ask the User
;              for input and possibly having a typo or value not found.
; ---------------------------------------------------------------------------
PROC hsPickLists.u()
Text
  Help on Selecting Items for Processing  ͻ
                                                                              
  You will first be presented with a list of Records from which to choose.    
  Find the Record with which you wish to work and Press [F2] while the        
  Cursor "." is within that record.  Press [Esc] to Return to the MAIN MENU.  
                                                                              
  To locate a Record quickly, place the Cursor in the field to be searched    
  and Press [Ctrl+Z] to "Zoom".  At the prompt, enter the value and Press     
  [Enter].  For Names, [Alt+Z] will locate the "next" name, if any.  You      
  must type the value in the appropriate case, unless you use the pattern     
  operator.                                                                   
                                                                              
  You can search for a pattern by substituting the pattern operator (two      
  periods "..") for the part of the value you do not know (i.e. SMI.. will    
  locate all the values that begin with "SMI", such as SMITH, smile, or       
  Smithereens).  ZOOM is not Case Sensitive when using the Pattern operator.  
                                                                              
  The Prompt may advise you that you can Enter a new Record if it is not on   
  the list that you have been presented.  In that case, Press [Ins] to add.   
                                                                              
                                                                              
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a   hsPickLists.u
Release PROCS        hsPickLists.u
?? ""
; ===========================================================================
;       TITLE: hsQuick.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;              Based upon an idea from Ed's Procs (author name misplaced)
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Quick Help for Paradox Keyboard
; ---------------------------------------------------------------------------
PROC hsQuick.u()
Text
  Keyboard Quick Reference  ͻ
                                                                              
͹
         Function Key Commands                 Other Keyboard Commands       
Ķ
 Ŀ               Ŀ                [Esc] - Cancel Current Menu Choice 
 F1  Help Key      F2  Continue or       and/or Return to Previous Menu  
                 Selection Key ͹
 Ŀ               Ŀ                Use these Keys with the [Ctrl] Key 
 F3  Up Image      F4  Down Image    Ķ
                                [D] {Ditto} - Duplicate the Value  
 Ŀ               Ŀ                   in the Previous Record's Field  
 F5  [Alt]         F6  CheckMark      [F] {FieldView/Edit} - View/Edit   
  FieldView                        within the Field contents       
 Ŀ               Ŀ                [BackSpace] - Erase Current Field  
 F7  Form Toggle   F8                 [Z] {Zoom} - Locate Matching Value 
                                [Alt+Z] {ZoomNext} - Locate Next   
 Ŀ               Ŀ               ͹
 F9  Edit Key      F10 Menu Key       [Ins] - Insert a Record            
                                [Del] - Delete a Record            
͹
       Cursor Movment Keys   [--]   [PgUp]   [PgDn]   [Home]   [End]       
ͼ
EndText
; the Keyboard Quick Reference is the only core help proc with custom colors
   hsExplode.u()
   PaintCanvas ATTRIBUTE 116  5, 1, 5,41        ; Section titles white on grey
   PaintCanvas ATTRIBUTE 116  5,43, 5,78        ; Section titles white on grey
   PaintCanvas ATTRIBUTE 116 10,43,10,78        ; Section titles white on grey
   PaintCanvas ATTRIBUTE 116 23, 1,23,78        ; Section titles white on grey
   helpmenu.a = "KEYBOARD"
   Return
ENDPROC
WriteLib libname.a   hsQuick.u
Release PROCS        hsQuick.u
?? ""
; ===========================================================================
;       TITLE: hsSearch.u
;      AUTHOR: (c) 1992 - Daniel J. Paolini II - DataStar International
;     CREATED: 07-01-92 03:50:00am
;     RETURNS: No value
; DESCRIPTION: Describes how to work with Locate Menu.
; ---------------------------------------------------------------------------
PROC hsSearch.u()
Text
  Help on Locating Records  ͻ
                                                                              
While in a TableĶ
   [Home] moves to the first record in table, [End] moves to the last one.    
   The Cursor  Keys and [PgUp] and [PgDn] move between Records.              
                                                                              
While at the Locate MenuĶ
   INCREMENTAL - Perform incremental Search, one character at a time.         
   FUZZY       - Perform a fuzzy Search, as in a "LIKE" Query.                
   ZOOM        - Search for a Value or Pattern (see [Ctrl+Z] below).          
   LOCATE      - Search on the first several Fields of a Table.               
   RECORD MOVE - Move to specified Record Number in the Table.                
   FUZZY, ZOOM and LOCATE all have a NEXT option, to Locate the Next          
   Record that meets the criteria of the last relevent Search.                
                                                                              
While using ZoomĶ
   [Ctrl+Z] Zooms to the first occurrence of a value for the current field.   
   Enter EXACT value (case sensitive) or Use wildcards (not case sensitive).  
   The wildcards are:      @ - one character      .. - String of characters   
   Leave zoom blank for first blank value.                                    
   [Alt+Z] or ZOOM-NEXT finds the next occurrence of the last zoom value.     
                                                                              
ͼ
EndText
   hsExplode.u()
   helpmenu.a = "CORE"
   Return
ENDPROC
WriteLib libname.a   hsSearch.u
Release PROCS        hsSearch.u
?? ""
;---------------------------------------------------------------------------
