;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure OOORG_Chart(),
;                            Line_Right(),
;                            Line_Left(),
;                            Box_Right(),
;                            Box_Left(),
;                            Desktop_Left(),
;                            Desktop_Right(),
;                            Line.Move(),
;                            Box.Move(),
;                            Line.Rotate(),
;                            Line.Add(),
;                            Line.Create(),
;                            Box.Delete(),
;                            Line.Delete(i),
;                            Box.Label(),
;                            Box.Create(),
;                            Desktop.ReDraw(),
;                            GuiFrame()
;                            ErrNotProc(),
;                            Connect(),
;                            Is.OnBoxBorder()
;
;Source File     : ORGCHART.SC
;Author          : Tony Goodman
;                  Ensemble Corporation
;                  (214) 341-6789
;
;Informant Issue : November 1992
;
;Description     : A PAL Org Chart Designer
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

Proc OOORG_Chart()

  private X,Y,Obj.Class,Msg,E,Objects.Class,ErrorProc,
          Objects.Info,Objects.Container,LineCanvas,SH,SW,Desk

  ;Set up a few Global Variables -----------------
  ErrorProc="ErrNotProc"
  BW=14     ;Box Width
  SysInfo To SI
  SH=SI["ScreenHeight"]
  SW=SI["ScreenWidth"]
  Release Vars SI

  ;Set Up Backround Canvas -----------------------
  Clear
  DynArray Desk[]
  Desk["Floating"]=false
  Desk["OriginRow"]=1
  Desk["OriginCol"]=0
  Desk["Height"]=SH-2
  Desk["Width"]=SW
  Desk["Style"]=62
  Desk["HasFrame"]=False
  Desk["HasShadow"]=False
  Window Create Attributes Desk TO LineCanvas
  Clear

  ;Set up Global Object Arrays -------------------
  ;Objects are Identified by the Window Handle----

  DynArray Objects.Class[]      ; Object's Class     : BOX/LINE/DESKTOP
  DynArray Objects.Container[]  ; Line's Parent Box  : Handle#
  DynArray Objects.Info[]       ; Line's Direction   : H/V
                                ; Box's Label        : Alpha

  Objects.Class[LineCanvas]="DESKTOP"
  Objects.Class[0]="DESKTOP"
  Objects.Class[1]="DESKTOP"

  While True
    Echo normal
    Getevent mouse "Down" Key "All" to E

    ; I.  Get The Message ---------------------------
    Switch
      Case E["Type"]<>"MOUSE"        : Sound 1000 100 sound 100 100

      Case E["Buttons"]="LEFT"       : Msg="LEFT"

      Case E["Buttons"]="RIGHT"      : Msg="RIGHT"

      OtherWise                      : Loop
    EndSwitch

    ; II.  Get The Class -------------------------------
    Y=E["Row"]
    X=E["Col"]
    Obj.Handle=WindowAt(y,x)
    Obj.Class=Objects.Class[Obj.Handle]
    If Search(".",Obj.Class)>0 then
      Obj.Class=substr(Obj.Class,1,Search(".",Obj.Class)-1)
    endif

    ; III. Send the Message to the Object Class --------
    ExecProc  Obj.Class+"_"+Msg

    Window List to WinList
    If ArraySize(WinList)=0 then
      return
    endif
  EndWhile
EndProc

;Mouse Class Messages ==========================================

Proc Line_Right()
  Line.Delete(Obj.Handle)
EndProc

Proc Line_Left()
  Line.Move()
  If Not Retval then
    Line.Rotate()
  endif
EndProc

Proc Box_Right()
  Box.Delete()
endProc

Proc Box_Left()
  If Is.OnBoxBorder(E) Then
    Line.Add()
  else
    Box.Move()
    If retval=false then
      Box.Label()
    endif
  endif
endProc

Proc Desktop_Left()
  Box.Create()
EndProc

Proc Desktop_Right()
  Private WinList,i

  Window List to WinList
  For i from 1 to ArraySize(WinList)
    Window Select Winlist(i)
    Window Close
  Endfor
EndProc

;Primitive Class Messages =======================================

Proc Line.Move()
  private E2,j,y2,X2,BoxHand,R2,C2
  Window Select Obj.Handle
  j=IIF(Objects.Class[Obj.Handle]="LINE.A",Obj.Handle+1,Obj.Handle-1)
  Window Getattributes j to Winattrib
  While True
    GetEvent Mouse "MOVE","UP" To E2
    SetCanvas Default
    Echo Normal Echo Off
    Connect(WinAttrib["OriginRow"],WinAttrib["OriginCol"],Objects.Info[j],
            E2["Row"],E2["Col"],Objects.Info[Obj.Handle],63)
    If E2["Action"]="UP" Then
      Quitloop
    Endif
  EndWhile

  R2=e2["Row"]
  C2=e2["Col"]
  If Y=R2 and X=C2 then
    Return False    ;Was Not a Move, Just a Click.
  Endif

  BoxHand=WindowAt(E2["Row"],E2["Col"])
  If Objects.Class[BoxHand]="BOX"  and
     Objects.Container[j]<>BoxHand and
     Is.OnBoxBorder(E2) then
    Window Move Obj.Handle To R2,C2
    Objects.Container[Obj.Handle]=BoxHand
    Localizeevent e2
    Objects.Info[Obj.Handle] = IIF(E2["Row"]=1,"H","V")
  Endif

  Desktop.ReDraw()
    Return True        ;Was an Attempted Line Move
EndProc

Proc Box.Move()
  private Y1,X1,Yoff,Xoff,E2,WinAttrib,i
  Window Select Obj.Handle
  Window Getattributes Obj.Handle to WinAttrib
  Y1=WinAttrib["OriginRow"]
  X1=WinAttrib["OriginCol"]
  While True
    GetEvent Mouse "MOVE","UP" To E2
    Yoff=Min(Max(Desk["OriginRow"],E2["Row"]-E["Row"]),
            (Desk["Height"]+Desk["OriginRow"])-WinAttrib["Height"])
    Xoff=Min(Max(Desk["OriginCol"],E2["Col"]-E["Col"]),
            (Desk["width"]+Desk["OriginCol"])-WinAttrib["Width"])

    Window Move Obj.Handle To Yoff,Xoff
    If E2["Action"]="UP" Then
      Quitloop
    Endif
  EndWhile

  If Y1=Yoff and X1=Xoff then
    Return False            ;Was Not A Move, Just A Click.
  Endif

  Foreach i in Objects.Container
    If Objects.Container[i]=Obj.Handle then
      Window Getattributes Numval(i) to WinAttrib
      Window Move Numval(i) to
        Winattrib["OriginRow"]+(Yoff)-Y1,
        Winattrib["OriginCol"]+(Xoff)-X1
    Endif
  EndForEach

  Desktop.ReDraw()
  Return True                ; Was A Box Move
EndProc

Proc Line.Rotate()
  private Dir

  Dir=Objects.Info[Obj.Handle]
  Dir=IIF(Dir="V","H","V")
  Objects.Info[Obj.Handle]=Dir

  Desktop.ReDraw()
EndProc

Proc Line.Add()
  private Yoff2,Xoff2,Yoff,Xoff,E2,Dir1,Dir2,DroppedOn
  setcanvas Default

  Dir1=IIF(E["Row"]=1,"H","V")
  Dir2=IIF(E["Row"]=1,"H","V")
  SetCanvas Default
  Echo off
  While True
    GetEvent Mouse "MOVE","UP" To E2
    Yoff=E2["Row"]
    Xoff=E2["Col"]
    Canvas off
    echo normal  echo off
    Connect(y,x,Dir1,Yoff,Xoff,Dir2,63)
    Canvas On
    If E2["Action"]="UP" then
      QuitLoop
    Endif
  EndWhile

  If Objects.Class[WindowAt(Yoff,Xoff)]<>"BOX" then
    return
  endif
  If Not Is.OnBoxBorder(E2) then
    Return
  Endif

  Line.Create(Y,X,Dir1,Yoff,Xoff,Dir2)
  Desktop.ReDraw()
EndProc

Proc Line.Create(Y1,X1,Dir1,Y2,X2,Dir2)
  Private Box1,Box2,WinAttrib,Lin1,Lin2

  Box1=WindowAt(Y1,X1)
  Box2=WindowAt(Y2,X2)

  If Box1=Box2 then
    return
  endif

  DynArray WinAttrib[]
  WinAttrib["Floating"]=True
  WinAttrib["OriginRow"]=Y1
  WinAttrib["OriginCol"]=X1
  WinAttrib["Height"]=1
  WinAttrib["Width"]=1
  WinAttrib["CanvasHeight"]=1
  WinAttrib["CanvasWidth"]=1
  WinAttrib["Style"]=60
  WinAttrib["HasFrame"]=False
  WinAttrib["HasShadow"]=False
  Window Create Attributes WinAttrib To Lin1

  WinAttrib["OriginRow"]=Y2
  WinAttrib["OriginCol"]=X2
  Window Create Attributes WinAttrib To Lin2

  Objects.Class[Lin1]="LINE.A"
  Objects.Class[Lin2]="LINE.B"

  Objects.Info[Lin1]=Dir1
  Objects.Info[Lin2]=Dir2

  Objects.Container[Lin1]=Box1
  Objects.Container[Lin2]=Box2
EndProc

Proc Box.Delete()
  private i,j

  Window Select Obj.Handle
  Window Close
  Release vars Objects.Class[Obj.Handle], Objects.Info[Obj.Handle]

  Foreach i in Objects.Container
    if Objects.Container[I]=Obj.Handle then
      Line.Delete(i)
    endif
  endforeach

  Desktop.ReDraw()
endProc

Proc Line.Delete(i)

  j=IIF(Objects.Class[i]="LINE.A",Numval(i)+1,Numval(i)-1)
  Window Select Numval(i)
  Window Close
  Release vars Objects.Class[i], Objects.Info[i], Objects.Container[i]
  Window Select j
  Window Close
  Release vars Objects.Class[j], Objects.Info[j], Objects.Container[j]

  Desktop.ReDraw()
EndProc

Proc Box.Label()
  Private Label

  Mouse Hide
  SetCanvas Obj.Handle
  Canvas On
  Cursor Normal
  @ 1,1 Accept "A12" Default Objects.Info[Obj.Handle]  to Label
  @ 1,1 ?? Format("W12,ac",Label)
  Objects.Info[Obj.Handle]=Label
  Cursor Off
  Mouse Show
EndProc

Proc Box.Create()
  private i,WinAttrib,NewBox

  DynArray WinAttrib[]
  WinAttrib["Floating"]=false
  WinAttrib["OriginRow"]=Y
  WinAttrib["OriginCol"]=X
  WinAttrib["CanvasHeight"]=3
  WinAttrib["CanvasWidth"]=14
  WinAttrib["Height"]=3
  WinAttrib["Width"]=14
  WinAttrib["Style"]=62
  WinAttrib["HasFrame"]=False
  WinAttrib["HasShadow"]=false

  Window Create Attributes WinAttrib To NewBox
  GuiFrame(59,48,0,0,WinAttrib["Height"],WinAttrib["Width"])

  Objects.Class[NewBox]="BOX"
  Objects.Info[NewBox]=""
EndProc

Proc Desktop.ReDraw()
  private I,y1,x1,y2,x2,Dir1,Dir2,WinA,WinB,WinAttrib

  SetCanvas LineCanvas
  Cursor off
  clear
  Foreach I In Objects.Class
    If Objects.Class[i]="LINE.A" then
      Window GetAttributes Numval(i)   to WinA
      Window GetAttributes Numval(i)+1 to WinB
      Dir1=Objects.Info[i]
      Dir2=Objects.Info[numval(i)+1]
      setCanvas LineCanvas
      Canvas off
      Connect(WinA["OriginRow"],WinA["OriginCol"],Dir1,
              WinB["OriginRow"],WinB["OriginCol"],Dir2,57)

      Canvas On
      setcanvas numval(i)   @ 0,0 ?? ""
      setcanvas Numval(i)+1 @ 0,0 ?? ""

    Endif
  EndForEach
  SetCanvas Linecanvas
  Canvas On

  return

  SetCanvas Default
  Echo normal echo off
  Foreach I In Objects.Class
    If Objects.Class[i]="BOX" then
      Window GetAttributes Numval(i)   to WinAttrib
      GUIFrame(127,112,WinAttrib["OriginRow"],WinAttrib["OriginCol"],
                       WinAttrib["Height"],WinAttrib["Width"])
    endif
  EndForeach
EndProc

;Generic Class Utilities ===================================

Proc GuiFrame(Lite,Dark,Y,X,H,W)  ;uses buttonsetup varstring
  GuiFrame=""+fill("",w-2)+""+fill("",(h-2)*2)+""+fill("",w-2)+""
  PaintCanvas Border Fill GUIFrame attribute Dark y,x,y+h-1,x+w-1
  PaintCanvas Border               attribute Lite y,x,y+h-1,x
  PaintCanvas Border               attribute Lite y,x,y,x+w-2
EndProc

Proc ErrNotProc()
  If ErrorCode()=34 and
     match(ErrorMessage(),"..Procedure..") then
    Return 1
  else
    Message ErrorCode()," - ",ErrorMessage()," - ",Time()
    debug ; Type Ctrl-N Ctrl-E to Edit
  endif
EndProc

Proc Connect(y1,x1,Dir1,y2,x2,Dir2,Style1)
  private Style1,CornerVal,Bisector,LoX,HiX,LoY,HiY,Style1,WinAttrib

  ;This Proc Paints a Line Between two Points on the Active
  ;Canvas.  The Dir1, and Dir2 Parameters are can be H or V.

  style attribute Style1

  If GetCanvas()>1 then
    Window GetAttributes GetCanvas() to WinAttrib
    Y1=Y1-WinAttrib["OriginRow"]
    Y2=Y2-WinAttrib["OriginRow"]
    X1=X1-WinAttrib["OriginCol"]
    X2=X2-WinAttrib["OriginCol"]
  Endif

  HiX=Max(X1,X2)
  LoX=Min(X1,X2)
  HiY=Max(Y1,Y2)
  LoY=Min(Y1,Y2)

  CornerVal=IIF(Y1>Y2,"+","-")+IIF(X1>X2,"+","-")

  DynArray Corners[]
  Corners["V++"]=""
  Corners["V-+"]=""
  Corners["V+-"]=""
  Corners["V--"]=""
  Corners["H--"]=""
  Corners["H+-"]=""
  Corners["H-+"]=""
  Corners["H++"]=""

  If Dir1<>Dir2 then
    If Dir1="V" then
      PaintCanvas Border Fill "" attribute style1 Y2,LoX,Y2,HiX
      PaintCanvas Border Fill "" attribute style1 LoY,X1,HiY,X1
      If X2<>X1 then
        PaintCanvas Border Fill Corners["V"+CornerVal]
          attribute style1  Y2,X1,Y2,X1
      endif
    else
      PaintCanvas Border Fill "" attribute style1 Y1,LoX,Y1,HiX
      PaintCanvas Border Fill "" attribute style1 LoY,X2,HiY,X2
      If Y2<>Y1 then
        PaintCanvas Border Fill Corners["H"+CornerVal]
          attribute style1  Y1,X2,Y1,X2
      endif
    Endif
  else

    If Dir1="V" then
      Bisector=int((Y1+Y2)/2)
      If Y1<Y2 then
        LeftX=X1  RightX=X2
      else
        LeftX=X2  RightX=X1
      endif
      PaintCanvas Border Fill "" attribute style1 LoY,LeftX,Bisector,LeftX
      PaintCanvas Border Fill "" attribute style1 Bisector,LoX,Bisector,HiX
      PaintCanvas Border Fill "" attribute style1 Bisector,RightX,HiY,RightX
      If X2<>X1 then
        PaintCanvas Border Fill Corners["V"+CornerVal] attribute style1
        Bisector,X1,Bisector,X1
        PaintCanvas Border Fill Corners["H"+CornerVal] attribute style1
        Bisector,X2,Bisector,X2
      endif
    else
      Bisector=int((X1+X2)/2)
      If X1<X2 then
        LeftY=Y1  RightY=Y2
      else
        LeftY=Y2  RightY=Y1
      endif
      PaintCanvas Border Fill "" attribute style1 LeftY,LoX,LeftY,Bisector
      PaintCanvas Border Fill "" attribute style1 LoY,Bisector,HiY,Bisector
      PaintCanvas Border Fill "" attribute style1 RightY,Bisector,RightY,HiX
      If Y2<>Y1 Then
        PaintCanvas Border Fill Corners["H"+CornerVal] attribute style1
          Y1,Bisector,Y1,Bisector
        PaintCanvas Border Fill Corners["V"+CornerVal] attribute style1
          Y2,Bisector,Y2,Bisector
      Endif
    Endif
  Endif
  style attribute 112
EndProc

Proc Is.OnBoxBorder(E)
  Private Yoff,Xoff,WinAttrib,y,x,retval2

  Y=E["Row"]
  X=E["Col"]
  LocalizeEvent E
  Yoff=E["Row"]
  Xoff=E["Col"]

  Retval2=WindowAt(Y,X)

  Window GetAttributes Retval2 to WinAttrib

  If Yoff=1 and Xoff<>0 and Xoff<>WinAttrib["CanvasWidth"]-1 then
    Return False
  else
    Return True
  endif
EndProc

OOORG_Chart()

