{*********************************************************}
{*		    OPALLIB.PAS 1.10			 *}
{*	  Copyright (c) Tamarack Associates 1993.	 *}
{*		   All rights reserved. 		 *}
{*********************************************************}


LIBRARY OPalLib;

USES	Strings,
	wsString;    {* This is from the Win/Sys Library, a TurboPower *}
		     {* product.  They can be contacted via CompuServe *}
		     {* in PCVENB.				       *}

TYPE	TBuffer      = ARRAY[0..MAXINT] OF CHAR;
	PBuffer      = ^TBuffer;
CONST	tfBufferSize : INTEGER =  0;
	tfErrorCode  : INTEGER = -1;
	ecMemory     = -1;
	ecBusy	     = -2;
	ecParameter  = -3;
	ecNotOpen    = -4;
VAR	tfFile	     : TEXT;
	tfBuffer     : PBuffer;

{* MaxInteger, MaxLong, & MaxDouble are available for your use, but *}
{* are not covered in the documentation.			    *}

FUNCTION MaxInteger(a : INTEGER ; b : INTEGER) : INTEGER; EXPORT;
BEGIN
 IF a > b THEN MaxInteger := a
 ELSE MaxInteger := b
END;

FUNCTION MaxLong(a,b : LONGINT) : LONGINT; EXPORT;
BEGIN
 IF a > b THEN MaxLong := a
 ELSE MaxLong := b
END;

FUNCTION MaxDouble(a,b : DOUBLE) : DOUBLE; EXPORT;
BEGIN
 IF a > b THEN MaxDouble := a
 ELSE MaxDouble := b
END;

FUNCTION RemoveQuotes(D,S : PCHAR ; Quote : CHAR) : PCHAR;
BEGIN
 StrCopy(D,S);
 IF D[0] = Quote THEN
  BEGIN
   StrChDelete(D,S,0);
   {StrChDelete(D,S,StrLen(S) - 1)}
   D[StrLen(D)-1] := #0
  END;
 RemoveQuotes := D
END;

FUNCTION FieldCount(P : PCHAR) : INTEGER; EXPORT;
VAR	 S : PCHAR;
BEGIN
 S := P;
 FieldCount := AsciiCount(S,',','"')
END;

FUNCTION FieldCountPrim(P,Delims,Quote : PCHAR) : INTEGER; EXPORT;
VAR	 S : PCHAR;
	 Q : CHAR;
BEGIN
 S := P;
 Q := Quote[0];
 FieldCountPrim := AsciiCount(S,Delims,Q)
END;

VAR	 Buffer : ARRAY[0..512] OF CHAR; {**.01}

FUNCTION PreProcess(P : PCHAR) : PCHAR; EXPORT; {**.01}
VAR	 S   : PCHAR;
	 Len : INTEGER;
BEGIN
 Len := StrLen(P);
 IF Len < SIZEOF(Buffer) - 2 THEN
  BEGIN
   StrCopy(Buffer,P);
   S := Buffer;
   REPEAT
    S := StrPos(S,',,');
    IF S <> NIL THEN
     BEGIN
      INC(Len,2);
      StrStInsert(S,S,'""',1)
     END
   UNTIL (Len > SIZEOF(Buffer) - 2) OR (S = NIL);
   IF (Buffer[Len - 1] = ',') AND (Len < SIZEOF(Buffer) - 2) THEN StrCat(Buffer,'""')
  END
 ELSE Buffer[0] := #0;
 PreProcess := Buffer
END;

FUNCTION GetField(P : PCHAR ; i : INTEGER) : PCHAR; EXPORT;
VAR	 S : PCHAR;
BEGIN
 S := P;
 ExtractAscii(Buffer,i,S,',','"');
 RemoveQuotes(Buffer,Buffer,'"');
 GetField := Buffer
END;

FUNCTION GetFieldPrim(P : PCHAR ; i : INTEGER ; Delims,Quote : PCHAR) : PCHAR; EXPORT;
VAR	 S : PCHAR;
	 Q : CHAR;
BEGIN
 S := P;
 Q := Quote[0];
 ExtractAscii(Buffer,i,S,Delims,Q);
 RemoveQuotes(Buffer,Buffer,Q);
 GetFieldPrim := Buffer
END;

FUNCTION FieldPosition(P : PCHAR ; i : INTEGER) : INTEGER; EXPORT;
VAR	 S : PCHAR;
BEGIN
 S := P;
 FieldPosition := AsciiPosition(i,S,',','"') + 1
END;

FUNCTION FieldPositionPrim(P : PCHAR ; i : INTEGER ; Delims,Quote : PCHAR) : INTEGER; EXPORT;
VAR	 S : PCHAR;
	 Q : CHAR;
BEGIN
 S := P;
 Q := Quote[0];
 FieldPositionPrim := AsciiPosition(i,S,Delims,Q) + 1
END;

FUNCTION tfOpen(S : PCHAR ; BufferSize : INTEGER) : INTEGER; EXPORT;
BEGIN
 IF tfBufferSize > 0 THEN
  BEGIN
   tfErrorCode := ecBusy;
   tfOpen      := tfErrorCode
  END
 ELSE
  IF BufferSize < 1 THEN
   BEGIN
    tfErrorCode  := ecParameter;
    tfOpen	 := tfErrorCode;
    tfBuffer	 := NIL;
    tfBufferSize := -1
   END
  ELSE
   BEGIN
    ASSIGN(tfFile,S);
    {$I-}
    RESET(tfFile);
    {$I+}
    tfErrorCode := IORESULT;
    tfOpen	:= tfErrorCode;
    IF tfErrorCode = 0 THEN
     BEGIN
      GETMEM(tfBuffer,BufferSize);
      IF tfBuffer = NIL THEN
       BEGIN
	tfErrorCode  := ecMemory;
	tfOpen	     := tfErrorCode;
	tfBufferSize := -1;
	CLOSE(tfFile);
       END
      ELSE tfBufferSize := BufferSize
     END
  END
END;

FUNCTION tfClose : INTEGER; EXPORT;
BEGIN
 IF tfBufferSize > 0 THEN
  BEGIN
   FREEMEM(tfBuffer,tfBufferSize);
   {$I-}
   Close(tfFile);
   {$I+}
   tfErrorCode	:= IORESULT;
   tfBufferSize := -1;
   tfBuffer	:= NIL
  END
 ELSE tfErrorCode := ecNotOpen;
 tfClose := tfErrorCode;
END;

FUNCTION tfEOF : INTEGER; EXPORT;
BEGIN
 IF tfBufferSize > 0 THEN
  BEGIN
   {$I-}
   tfEOF := ORD(EOF(tfFile));
   {$I+}
   tfErrorCode := IORESULT
  END
 ELSE tfErrorCode := ecNotOpen;
 IF tfErrorCode <> 0 THEN tfEOF := ORD(TRUE)
END;

FUNCTION tfReadLine : PCHAR; EXPORT;
BEGIN
 IF tfBufferSize > 0 THEN
  BEGIN
   {$I-}
   READLN(tfFile,tfBuffer^);
   {$I+}
   tfErrorCode := IORESULT
  END
 ELSE tfErrorCode := ecNotOpen;
 IF tfErrorCode <> 0 THEN tfBuffer^[0] := #0;
 tfReadLine := tfBuffer^
END;

FUNCTION tfError : INTEGER; EXPORT;
BEGIN
 tfError := tfErrorCode
END;

EXPORTS
 MaxInteger	   INDEX 1,
 MaxLong	   INDEX 2,
 MaxDouble	   INDEX 3,
 FieldCount	   INDEX 4,
 FieldCountPrim    INDEX 5,
 GetField	   INDEX 6,
 GetFieldPrim	   INDEX 7,
 FieldPosition	   INDEX 8,
 FieldPositionPrim INDEX 9,
 tfOpen 	   INDEX 10,
 tfClose	   INDEX 11,
 tfEOF		   INDEX 12,
 tfReadLine	   INDEX 13,
 tfError	   INDEX 14,
 PreProcess	   INDEX 15; {**.01}

BEGIN
END.
