;.............................................................................
;
;   Program Name  :  OKMSG.SC          
;   Copyright     :  Benson Software Systems, Inc.                                                   
;							 50 California Street, Suite 430
;							 San Francisco, CA 94111
;							 (415)433-2000  Fax: (415)433-4558
;
;   Date Created  :  11/24/92
;
;   Author        :  Brendan Delumpa                                    
; 
;   Description   :  Multiple line dialog box with word wrap
;
;   Contents      :  DisplayMsgOK(MSG,Title)
;                      MsgProc()
;                      WrapMSG()  
;.............................................................................
;You are free to use this code in any of your programs provided you credit
;Benson Software Systems, Inc. in your applications that use this procedure 
;.............................................................................
;One of the most exciting things to me in Paradox 4.0 is the windowing 
;interface; especially with regards to putting messages in boxes above
;my work.  In previous versions of Paradox, developers were forced to
;program all their graphical routines.  Talk about slow!  But with the new
;version, boxes and other graphical objects are only a few calls away,
;as opposed to a few hundred lines of code that had to written before.
;And dialog boxes are a real boon to productivity, and introduce a whole
;new realm of interacting with the user.
;
;One particular area of user interaction that I am concerned with is
;status messages.  Dialog boxes are ideal for this because of the 
;built in pushbutton functions.  There are lots of utilities that let
;you build message boxes, but the one I've seen only allow for a couple
;of lines to be displayed, or make the programmer put in a new line 
;in the middle of a string to create a word wrap.  I work in a group
;environment where we share each other's tools.  And the thing I stress
;is that your tools should be designed such that they're easy to use,
;and if they require any type of input, make the input as simple as 
;possible to leave the guesswork to the code, not the programmer.
;
;Below is a script listing of a procedure that splits apart long strings, 
;then calculates the width and height of a dialog box based upon how many 
;lines the string was split into, to allow for multiple lines to be 
;written in the box. If the string is only one line, which means it's 
;length is less than 64 (which is the maximum width I set for the box, then 
;the string is centered in the box.  Multiple line messages are left 
;justified.
;
;There are a couple of things you should note in the code.  The first thing
;is that I embedded the dialog and word wrap procedures within the
;scope of the main procedure.  You might say that these procedures are
;"private" to the message procedure, though you can split them out, if you
;want to use them for other procedures.
;
;The other thing is the use of a "bag" to hold the message excerpts.  The
;trick to doing this is loading the lines from the bottom-most line that you
;want to list and move successively up to the top-most line.  Dynarrays, like
;real bags are normally unloaded (using ForEach), from what has been loaded
;last to what has been loaded first.
;
;Anyway, use this proc as you see fit, tear it up if you want.  If you see
;that improvements can be made, feel free to share them with me.
;Call me up, or send me E-mail at my CompuServe ID#: 72410,520

Proc DisplayMsgOK(MSG,			     ;String, any length up to 9999
						 Title)			  ;Dialog box title

  Private       ExitValue,        ;Logical exit value - Always true
                MaxWid,           ;Maximum Width of the window
                MinWid,           ;Minimum width of the window
                Strlen,           ;String Length
                StrCol,           ;Starting column of string
                DialogRow,        ;Starting Row of the dialog box
                DialogCol,        ;Starting Column of the dialog box
                DHeight,           ;Dialog Height
                DWidth,           ;Dialog Width
                ButtonCol,        ;Starting column of the PushButton
                MsgBag,           ;Dynarray name
                LineCount         ;# Lines created


;I. Initialize Variables and embedded procedures

  MaxWid = 66                     ;Sets the limits of the dialog
  MinWid = 44
  Strlen = Len(MSG)
  LineCount = 0                   ;Global variable to count # lines in message
  Dynarray MsgBag[]


  Proc MsgProc(EType,TagVal,EVal,ElVal)
     Private MsgLine,                 ;MsgBag element used in ForEach
             BotLine,                 ;Bottom-most line of the bag
             MsgWinAtts,              ;Dynarray to set window attrib.
             CanvasWidth,             ;Width of the canvas window
             CanvasHeight,            ;Height of the canvas window
             StringPos                ;String Position if Len(MSG) < 60

                                      
     BotLine = ButtonRow - 1          ;One row above the Button Row
     CanvasWidth = DWidth - 4
     CanvasHeight = LineCount

	   Window Handle Dialog to MSGWindow  
     Setcanvas MSGWindow               ;Set window attributes

     If (LineCount = 1) then           ;If Len(MSG) evaluated to < 60

        StringPos = Int(CanvasWidth/2) - Int(Strlen/2)+1
        @BotLine-1,StringPos           ;Centers top to bottom
        ?? MsgBag[Strval(LineCount)]

     Else

	      ForEach MsgLine in MsgBag         ;for strings longer than 60
		      BotLine = BotLine - 1          ;Create a space between 
                                          ;text and button for multiple lines
 		      @BotLine,2
   	      ?? MsgBag[MsgLine]             ;Write value out from MsgBag
        EndForEach

     Endif

  Endproc


  Proc WrapMSG(MSG)               ;Sends string into a dynarray, returns
                                  ;leftover of cut MSG. 
     Private cut                  ;Position in MSG that is a space

    cut = 62

    While Substr(MSG,cut,1)<>" "  ;While the substring is not equal 
      cut = cut - 1               ;go back one space at a time until
    Endwhile                      ;you find a space. 

    LineCount = LineCount + 1     ;Increment the number of lines you've
                                  ;generated (a little faster than doing
                                  ;DynArraySize(MsgBag). Nothing to evaluate

    MsgBag[Strval(LineCount)] = Substr(MSG,1,cut-1) ;Add the valid piece of
                                                    ;message to bag, then
                                                    ;remove the space from the 
                                                    ;string

    Return Substr(MSG,cut+1,9999) ;Return the leftover portion to be 
                                  ;cut if necessary
  Endproc


;II. Calculate Dialog box Maximum width based on string width
;    If String width > MaxWid - 4 (60) then take apart the string
;    and throw the pieces into a bag.


  Switch
  Case (Strlen > MaxWid):             

    While (Strlen > MaxWid)
      MSG = WrapMSG(MSG)
      Strlen = Len(MSG)
    Endwhile

    DWidth = MaxWid               ;Don't exceed MaxWid of Dialog

  Case (Strlen >= MinWid) AND     ;Strlen is between 44 and 64
    (Strlen < MaxWid) :

    DWidth = Strlen + 4
    
  Otherwise: DWidth = MinWid      ;MinWid + 2 because Strlen can only be 
                                  ;< MinWid at this point
  Endswitch

    LineCount = LineCount + 1     ;Increment the line counter after 
                                  ;doing the switch statements above
                                  ;because exiting the switch, you'll
                                  ;always have something to add to the bag

    MsgBag[Strval(LineCount)] = MSG ;Add to the bag


;III.Calculate Horizontal Dimensions and Positions for Strings,
;    Dialog Box, and OKButton.


  StrCol = 1 ;Int(((DWidth-2) - Strlen)/2)  ;MSG Starting column
  DialogCol = Int((80 - DWidth)/2)-1     ;Starting column of the dialog box
                                         ;assuming 80 column screen width

  ButtonCol = Int((DWidth - 6)/2)-1      ;Button -> Offset by 1 to center,
                                         ;hard coded button width of 6



;IV. Calculate Vertical Dimensions and Positions for Strings
;    Dialog Box, and OKButton

    DHeight = LineCount + 6
  ButtonRow = DHeight - 4
  DialogRow = Int((22 - DHeight)/2) + 1


;V. Build the dialog box using the calculated parameters
;		If you notice, the actual commands to the dialog box are very short
;		in length as a whole.  

  ShowDialog Title                       
     Proc "MsgProc"
     Trigger "OPEN"    ;Once dialog is open, write the message inside

  @DialogRow,DialogCol ;Location
  Height DHeight 			 ;Size
  Width DWidth

  Pushbutton @ButtonRow,ButtonCol Width 6
  "OK" OK Default
  Value True
  Tag "OK"
  To ExitValue

  EndDialog

Endproc



