;*******************************************************************************
;This script is sort of a tribute to Brian Smith's NOT_IN QUERY...we all
;recognize that sometimes it's a 'bear' when converting data to ensure that ALL
;the data we want has been converted and present in our tables.  This is an
;interactive script...you are first promted for the two tables you want to
;compare and then the field you want to check.  In this script, the table that
;you suspect may be missing records must be the FIRST table you select.  Error-
;checking is limited to ensuring that the field you want to compare is present
;in BOTH tables -and- IF the answer table comes up empty, a message results to
;the effect that no differences were found.  You'll also note that on lines 115-
;116 a comment to the effect that if you want the COMPLETE record(s) that are
;missing, you must substitute the two lines (115-116) for line 117.  T'ain't
;terribly pretty but it IS effective...I can run this on a 3000 record table and
;get an answer in under 20 seconds on a 20Mhz 386.  Enjoy!
;To run this script, make sure you're at the MENU...type {Script}{Play} NOT_IN
;Yep, works in 3.5 and 4.0, too!
;************************* Dickford Cohn 76226,1572 ****************************
ClearALL
BEEP
@6,0?? FORMAT("W80,AC","Remember...the FIRST table is the one we suspect is SHORT")
SLEEP 2000
PROC TablComp()
CLEAR
ClearALL
;------------------------------------------------------------------------------
; Get the name of the first table
;------------------------------------------------------------------------------
BEEP
SLEEP 100 BEEP
STYLE ATTRIBUTE 140
msay = " Select FIRST Table to COMPARE "
msaycol =INT((80-LEN(msay))/2)
@ 10, msaycol ?? msay
SHOWTABLES
DIRECTORY()
"Highlight the FIRST TABLE TO COMPARE...and Press <Enter> "
TO mtable1
msay1 = UPPER(mtable1)+".DB"
msaycol =INT((80-LEN(msay1))/2)
@ 11, msaycol ?? msay1
IF mtable1 = "Esc"
  THEN
  BEEP
  MESSAGE "You pressed <Esc>ape...returning to Paradox"
  SLEEP 5000
  QUIT
ENDIF
;------------------------------------------------------------------------------
; Get the name of the SECOND table
;------------------------------------------------------------------------------
BEEP SLEEP 50 BEEP
STYLE ATTRIBUTE 140
msay2 = " Select SECOND Table to COMPARE "
msaycol =INT((80-LEN(msay))/2)
@ 10, msaycol ?? msay2
SHOWTABLES
DIRECTORY()
"Highlight the SECOND TABLE TO COMPARE...and Press <Enter> "
TO mtable2
msay2 = UPPER(mtable2)+".DB"
msaycol =INT((80-LEN(msay2))/2)
@ 11, msaycol ?? msay2
IF mtable2 = "Esc"
  THEN
  BEEP
  MESSAGE "You pressed <Esc>ape...returning to Paradox"
  SLEEP 5000
  QUIT
ENDIF
CLEAR
CURSOR OFF
@ 10,0 ?? FORMAT("w80,ac","Preparing tables for comparison")
ENDPROC
TablComp()
;------------------------------------------------------------------------------
; Now get the structure of the table so we can SELECT field we want to compare
;------------------------------------------------------------------------------
MENU {Tools} {Info} {Structure}
TYPEIN mtable1
ENTER
CLEAR ClearALL
VIEW "Struct"
WAIT TABLE
PROMPT FORMAT("W80,AC","Move to the FIELD you want to CHECK and press <Enter>..."),
FORMAT("W80,AC","or, press <Esc>ape to QUIT")
UNTIL "Enter","Esc"
IF RETVAL = "Esc"
  THEN CLEAR ClearALL
  MESSAGE "Returning to Paradox..." SLEEP 500
  RETURN
ENDIF

IF RETVAL = "Enter"
  THEN fname = [Field Name]
  CLEAR ClearALL
  MENU {Tools} {Info} {Structure}       ;Check to see if this is a valid field
  TYPEIN mtable2                        ;in the SECOND table
  ENTER
  CLEAR ClearALL
  VIEW "Struct"
  MOVETO [Field Name]
    LOCATE fname
    IF NOT RETVAL THEN BEEP SLEEP 50 BEEP SLEEP 50 BEEP
      MESSAGE "Field "+FORMAT("CU",fname)+" is NOT PRESENT in "+FORMAT("CU",mtable2)+"..."
      SLEEP 5000
      CLEAR ClearALL
      RETURN
    ENDIF
    MESSAGE "Comparing "+FORMAT("CU",mtable1)+" to "+FORMAT("CU",mtable2)+"...please wait"
    CURSOR OFF
    MENU {Ask} SELECT mtable1
    MOVETO FIELD fname
      [] = "_c,COUNT=0"
      MENU {Ask} SELECT mtable2
;CTRLHOME CHECK                       ;Substitute THESE lines for the next one
;MOVETO fname                         ;IF you want complete records
      MOVETO FIELD fname CHECK
        [] = "_c!"
        DO_IT!
      ENDIF
      IF ISEMPTY("Answer") THEN CLEAR ClearALL BEEP
        MESSAGE "Table "+FORMAT("W8,CU",firstable)+" appears to have ALL values in "+FORMAT("W8,CU",secondtable)"..."
        SLEEP 5000
      ELSE
        CLEAR ClearALL
        VIEW "Answer"
      ENDIF
      
      
