; NLI.SC
;--------------
;
; COPYRIGHT 1993 European Paradox Association
;
;  DISCLAIMER
;  The NLI system is available as freeware. Everyone is free to use the NLI
;  system including the source code in applications, provided that:
;  1. the following copyright statement is declared in their source code and
;     in their accompanying documentation:
;                COPYRIGHT 1993 European Paradox Association
;  2. their source code and accompanying documentation contain a clear and
;    unequivocal statement that the application is usable in various language
;    versions of Paradox through incorporation of the European Paradox
;    Association's National Language Interface.
;
;  Neither the European Paradox Association nor its members assumes any
;  responsibility whatsoever for the uses made of the NLI system or for
;  decisions based on its use. The NLI system is supplied as is, without warranty
;  of any kind, either expressed or implied, respecting the contents of this
;  documentation or the NLI system itself; including, but not limited to implied
;  warranties for their quality, performance, or fitness for any particular
;  purpose. Neither the European Paradox Association nor its members shall be
;  liable to any person or entity with respect to liability, loss, or damage
;  caused, or alleged to be caused directly or indirectly by these materials or
;  use.


CLEAR
@0,0 ?? "Creating the NLI library..."

CREATELIB "NLI"

; ------------------------------------------------------------
; This is the Menu Choice Command
;
; Menu options is separated with a comma:
;
; ex. NLImenu("Tools,More,Directory")
;
;
; Selections can also be made. Instaed of having a lot of small calls to
; NLImenu, you can have only one:
;
; ex. NLImenu("Tools,More,Directory,{c:\\},view,{"+tablename+"}")
;
; Keys can be pressed by using the key-name in square-brackets [ ]
;
; ex. NLImenu("Ask,{"+tablename+"},[check],[Do_It!]")
;
;
; You do not need to specify the MENU command. NLImenu detects if it needs
; to do it, al by itself.
;
; ------------------------------------------------------------
proc NLImenu(NLI.command)
  private menucommand, errorproc, NLI.commandtext, NLI.commandoption,
          error.l, NLI.command

  errorproc = "NLImenu.ep"

  menu
  error.l = false

  while match(NLI.command,"..,..",menucommand,NLI.command)

    NLI.commandtext   = substr(menucommand,2,len(menucommand)-2)
    NLI.commandoption = substr(menucommand,1,1)

    switch
      case menucommand = ""       : enter

      case NLI.commandoption = "{": if substr(NLI.commandtext,1,1) = "~"
                                    then NLI.commandtext = varval(substr(NLI.commandtext,2,255))
                                    endif

                                    select NLI.commandtext

      case NLI.commandoption ="[" : keypress NLI.commandtext

                                    if error.l;keycode does not exist
                                              ;therefore typein word as is
                                    then error.l = false
                                         typein NLI.commandtext
                                    endif

      case NLI.commandoption = "(": NLImenu.ask()
                                    if error.l
                                    then quitloop
                                    endif

      case NLI.commandoption = "~": menucommand = varval(substr(menucommand,2,255))
                                    select NLI["menu."+menucommand]

      otherwise                   : select NLI["menu."+menucommand]
    endswitch

    if error.l
    then quitloop
    endif
  endwhile

  if not error.l
  then NLI.commandtext   = substr(NLI.command,2,len(NLI.command)-2)
       NLI.commandoption = substr(NLI.command,1,1)
       menucommand       = NLI.command
  endif

  switch
    case error.l                : ;do nothing

    case NLI.command = ""       : enter

    case NLI.commandoption = "{": if substr(NLI.commandtext,1,1) = "~"
                                  then NLI.commandtext = varval(substr(NLI.commandtext,2,255))
                                  endif

                                  select NLI.commandtext

    case NLI.commandoption = "[": keypress NLI.commandtext

                                  if error.l;keycode does not exist
                                            ;therefore typein word as is
                                  then error.l = false
                                       typein NLI.commandtext
                                  endif

    case NLI.commandoption = "(": NLImenu.ask()

    case NLI.commandoption = "~": menucommand = varval(substr(menucommand,2,255))
                                  select NLI["menu."+menucommand]

    otherwise                   : select NLI["menu."+menucommand]
  endswitch

  if error.l
  then message "Translation error - " +menucommand
       sleep 1000
       debug  ;press Ctrl T to return to PAL command after erroneous NLImenu call
  endif

endproc
; ------------------------------------------------------------
proc NLImenu.ep() ;used when translation error
     if errorcode() = 34  ;this is a translation error
     or errorcode() = 33  ;this is a translation error
     then error.l = true
     ;else      ;could be valid - eg: no regular fields to place
     endif

     return 1
endproc
; ------------------------------------------------------------
proc NLImenu.ask() ;translates ask words and oddballs

     typein NLI["ask."+ NLI.commandtext]

     if not error.l  ;ask word translated
     then return
     endif

;ask word not translated - could be an odd ball word
     error.l = false

     typein NLI["info."+ NLI.commandtext]

     if error.l  ;word not translated therefore typein word as is
     then typein NLI.commandtext
     endif

     error.l = false
endproc
; ------------------------------------------------------------
WriteLib "NLI" NLImenu, NLImenu.ep, NLImenu.ask
Release Procs   NLImenu, NLImenu.ep, NLImenu.ask

proc NLI001()
; Variables Saved Using Savevars Command

Dynarray NLI[]
NLI["MENU.GRAPH.PIC"] = "PIC"
NLI["MENU.CENTER"] = "Center"
NLI["MENU.LEFT"] = "Left"
NLI["MENU.PARENNEGATIVE"] = "ParenNegative"
NLI["MENU.SIGN-CONVENTION"] = "Sign-Convention"
NLI["MENU.VIDEO.E:A:"] = "A: VGA Wizard: 80x34"
NLI["MENU.FULLLOCK"] = "FullLock"
NLI["MODE.EDIT"] = "Edit"
NLI["MENU.CALCULATED"] = "Calculated"
NLI["MENU.EDITOR.EDIT"] = "Edit"
NLI["MENU.SUM"] = "Sum"
NLI["MENU.SCRIPTS"] = "Scripts"
NLI["MENU.RANGE"] = "Range"
NLI["MENU.SETUP CUSTOM"] = "Custom"
NLI["PROMPT.RESET STRING:"] = "Reset string:"
NLI["ASK.AVERAGE"] = "AVERAGE"
NLI["MENU.VIDEO"] = "Video"
NLI["MENU.VIDEO.H:B:"] = "B: Everex VGA: 80x60"
NLI["MENU.SAME"] = "Same"
NLI["MENU.EDIT"] = "Edit"
NLI["REPORT.PAGE HEADER"] = "Page Header"
NLI["MENU.GRAPH.PRINTER"] = "Printer"
NLI["REPORT.MINIMUM FOR"] = "Minimum for "
NLI["MENU.VIDEO.G:D:"] = "D: Compaq VGS: 132x50"
NLI["MENU.VIDEO.N:"] = "N: Video-7 VRAM VGA"
NLI["MENU.DELETE"] = "Delete"
NLI["MENU.DO_IT!"] = "DO-IT!"
NLI["MENU.AREA"] = "Area"
NLI["MENU.HIDE"] = "Hide"
NLI["ASK.OR"] = "OR"
NLI["MENU.GRAPH.DURATION"] = "Duration"
NLI["MENU.GRAPH.EPS"] = "EPS"
NLI["MENU.REMOVEBLANKS"] = "RemoveBlanks"
NLI["REPORT.CURRENT DATE"] = "Current date"
NLI["MENU.VIDEO.H:D:"] = "D: Everex VGA: 100x75"
NLI["MENU.FIELD"] = "Field"
NLI["MENU.JUSTFAMILY"] = "JustFamily"
NLI["MENU.DIRLOCK"] = "DirLock"
NLI["MENU.INSERT"] = "Insert"
NLI["REPORT.REPORT HEADER"] = "Report Header"
NLI["PROMPT.EXPRESSION:"] = "Expression:"
NLI["MODE.PASSWORD"] = "Password"
NLI["MENU.VIDEO.G:B:"] = "B: Compaq VGS: 132x28"
NLI["MENU.SETPRINTER"] = "SetPrinter"
NLI["MENU.ENTRY"] = "Entry"
NLI["MENU.REFLEX.1.0"] = "1) Reflex Release 1.0"
NLI["MENU.REFLEX.2.0"] = "3) Reflex Release 2.0"
NLI["INFO.NAME"] = "Name"
NLI["REPORT.CURRENT RECORD NUMBER"] = "Current record number"
NLI["MENU.EMPTY"] = "Empty"
NLI["MENU.TABLELOOKUP"] = "TableLookup"
NLI["MENU.REFORMAT"] = "Reformat"
NLI["TABLE.LIST"] = "List"
NLI["INFO.TUE"] = "Tue"
NLI["MENU.GRAPH.KEYSTROKE"] = "KeyStroke"
NLI["MENU.VIDEO.H:F:"] = "F: Everex VGA: 132x44"
NLI["MENU.QUATTRO.1.X"] = "1) Quattro Release 1.X"
NLI["MENU.PASSWORD"] = "Password"
NLI["MENU.SINGLE-LINE"] = "Single-line"
NLI["MENU.LINK"] = "Link"
NLI["MENU.REGROUP"] = "Regroup"
NLI["MENU.SETTING"] = "Setting"
NLI["PROMPT.SCRIPT:"] = "Script:"
NLI["ASK.EVERY"] = "EVERY"
NLI["MODE.INDEX"] = "Index"
NLI["INFO.FIELD NAME"] = "Field Name"
NLI["MENU.GRAPH.SERIES"] = "Series"
NLI["REPORT.DATE.10"] = "10) dd/mm/yy"
NLI["MENU.REDRAW"] = "Redraw"
NLI["MENU.VIDEO.F:A:"] = "A: ATI VGA: 132x25"
NLI["MENU.VIDEO.G:E:"] = "E: Compaq VGS: 132x60"
NLI["MENU.DEFAULT"] = "Default"
NLI["MENU.WIDTH"] = "Width"
NLI["TABLE.KEEPENTRY"] = "KeepEntry"
NLI["REPORT.COUNT OF"] = "Count of "
NLI["MENU.INTERFACE"] = "Interface"
NLI["MENU.IMAGE"] = "Image"
NLI["MENU.TABLEBAND"] = "TableBand"
NLI["MENU.EDITOR.WRITEBLOCK"] = "WriteBlock"
NLI["MENU.VIDEO.K:A:"] = "A: Paradise EGA/VGA: 132x25"
NLI["MENU.INDEX"] = "Index"
NLI["MENU.DD-MON-YY"] = "DD-Mon-YY"
NLI["MENU.RECORD"] = "Record"
NLI["ASK.NO"] = "NO"
NLI["MENU.FIELDSQUEZZE"] = "FieldSqueeze"
NLI["MENU.RIGHT"] = "Right"
NLI["MENU.U.S.CONVENTION"] = "InternationalConvention"
NLI["MENU.JUSTCURRENTFIELD"] = "JustCurrentField"
NLI["MENU.AUTO"] = "Auto"
NLI["MENU.#RECORD"] = "#Record"
NLI["MENU.REMOVE"] = "Remove"
NLI["MENU.TABLEOFGROUPS"] = "TableOfGroups"
NLI["MENU.GRAPH.PRINTERLAYOUT"] = "PrinterLayout"
NLI["MODE.GRAPH"] = "Graph"
NLI["MENU.VIEW"] = "View"
NLI["MENU.OUTPUT"] = "Output"
NLI["MENU.LINKED"] = "Linked"
NLI["MENU.RESIZE"] = "Resize"
NLI["ASK.SET"] = "SET"
NLI["MENU.EDITOR.REPLACE"] = "Replace"
NLI["MENU.EDITOR.NEXT"] = "Next"
NLI["MODE.SORT"] = "Sort"
NLI["MENU.VIDEO.N:C:"] = "C: Video-7 VGA: 132x43"
NLI["MENU.REGULAR"] = "Regular"
NLI["MENU.ENDOFPAGE"] = "EndOfPage"
NLI["MENU.SYMPHONY"] = "Symphony"
NLI["MENU.SYMPHONY.1.1"] = "2) Symphony Release 1.1"
NLI["MENU.FILES"] = "Files"
NLI["MENU.OVERALL"] = "Overall"
NLI["MENU.REPLACE"] = "Replace"
NLI["MENU.EDITOR.INSERTFILE"] = "InsertFile"
NLI["MENU.NEXT"] = "Next"
NLI["MENU.LINEFEED"] = "LineFeed"
NLI["MENU.ORDERTABLE"] = "OrderTable"
NLI["MENU.GRAPH"] = "Graph"
NLI["MENU.QUATTRO"] = "Quattro"
NLI["MENU.CHANGES"] = "Changes"
NLI["MENU.LOWVALUE"] = "LowValue"
NLI["INFO.DATE"] = "Date"
NLI["INFO.FILENAME"] = "FileName"
NLI["MENU.COMPATIBLE"] = "Compatible"
NLI["MENU.HIGH"] = "High"
NLI["MENU.CASCADE"] = "Cascade"
NLI["MENU.VIDEO.H:E:"] = "E: Everex VGA: 132x25"
NLI["MENU.SORT"] = "Sort"
NLI["MENU.FORMS"] = "Forms"
NLI["MENU.RENAME"] = "Rename"
NLI["MENU.QUERYSPEED"] = "QuerySpeed"
NLI["MENU.DO-IT!"] = "DO-IT!"
NLI["MENU.SHOWHIGHLIGTH"] = "ShowHighlight"
NLI["ASK.AS"] = "AS"
NLI["MENU.EDITOR.GOTO"] = "Goto"
NLI["MENU.EDITOR.XCUT"] = "XCut"
NLI["MENU.VIDEO.K:"] = "K: Paradise EGA 480/VGA 1024"
NLI["MENU.FORMAT"] = "Format"
NLI["MENU.SCRIPT"] = "Script"
NLI["MENU.ASCII"] = "ASCII"
NLI["MENU.DOUBLE-LINE"] = "Double-line"
NLI["MENU.DATE"] = "Date"
NLI["MENU.HEADINGS"] = "Headings"
NLI["REPORT.DATE.9"] = "9) dd.mm.yy"
NLI["MENU.VIDEO.D:"] = "D: EGA/VGA: 80x43/50"
NLI["MENU.OVERRIDE"] = "Override"
NLI["MENU.CALCEDIT"] = "CalcEdit"
NLI["MENU.ADJUST"] = "Adjust"
NLI["MENU.RELINK"] = "Relink"
NLI["MENU.GROUP"] = "Group"
NLI["INFO.LOCKTYPE"] = "LockType"
NLI["MENU.VIDEO.F:"] = "F: ATI VGA Wonder"
NLI["MENU.QUATTROPRO"] = "2) Quattro Pro"
NLI["FORM.EMBEDDED.END"] = " table using form "
NLI["MENU.EDITOR.CHANGETOEND"] = "ChangeToEnd"
NLI["MENU.MODIFY"] = "Modify"
NLI["MENU.INVENTORY"] = "Inventory"
NLI["MENU.QUERYSAVE"] = "QuerySave"
NLI["TABLE.FAMILY"] = "Family"
NLI["MENU.SIZE/MOVE"] = "Size/Move"
NLI["MENU.VIDEO.E:C:"] = "C: VGA Wizard: 132x25"
NLI["MENU.CROSSTAB"] = "CrossTab"
NLI["MENU.REFLEX"] = "Reflex"
NLI["MENU.REFLEX.1.1"] = "2) Reflex Release 1.1"
NLI["MODE.COEDIT"] = "CoEdit"
NLI["INFO.SAT"] = "Sat"
NLI["INFO.MON"] = "Mon"
NLI["REPORT.FORM BAND"] = "Form Band"
NLI["MENU.COUNT"] = "Count"
NLI["REPORT.GROUP FOOTER"] = "Group Footer for"
NLI["MENU.WINDOW"] = "Window"
NLI["MENU.SURFACEQUERIES"] = "SurfaceQueries"
NLI["MENU.OPEN"] = "Open"
NLI["MENU.ABOUT"] = "About"
NLI["MENU.MM/DD/YY"] = "MM/DD/YY"
NLI["MENU.DD.MM.YY"] = "DD.MM.YY"
NLI["MENU.YY.MM.DD"] = "YY.MM.DD"
NLI["MENU.PER-GROUP"] = "Per-Group"
NLI["MENU.MARGIN"] = "Margin"
NLI["MENU.EDITOR.OPEN"] = "Open"
NLI["REPORT.DATE.7"] = "7) dd-Mon-yyyy"
NLI["MENU.COEDIT"] = "CoEdit"
NLI["MENU.INFO"] = "Info"
NLI["MENU.MORE"] = "More"
NLI["MENU.AFTER"] = "After"
NLI["MENU.LENGTH"] = "Length"
NLI["MENU.VIDEO.B:"] = "B: Monochrome"
NLI["MENU.VIEWGRAPH"] = "ViewGraph"
NLI["MENU.WRITELOCK"] = "WriteLock"
NLI["MENU.UNDO"] = "Undo"
NLI["MENU.COLOR"] = "Color"
NLI["ASK.MAX"] = "MAX"
NLI["MENU.VIDEO.J:D:"] = "D: Orchid VGA: 132x44"
NLI["MENU.VIDEO.M:B:"] = "B: STB VGA: 132x44"
NLI["MENU.RANGEOUTPUT"] = "RangeOutput"
NLI["MENU.EXPORT"] = "Export"
NLI["MENU.PLACE"] = "Place"
NLI["MENU.EDITOR.COPY"] = "Copy"
NLI["MENU.FILEFORMAT"] = "FileFormat"
NLI["MENU.GRAPH.1STPRINTER"] = "1stPrinter"
NLI["MENU.GRAPH.TYPE"] = "Type"
NLI["REPORT.PER GROUP"] = " per group"
NLI["REPORT.DATE.12"] = "12) yy.mm.dd"
NLI["REPORT.DATE.11"] = "11) yy-mm-dd"
NLI["MENU.VIDEO.N:A:"] = "A: Video-7 VGA: 80x60"
NLI["MENU.KEEPSET"] = "KeepSet"
NLI["MENU.TOOLS"] = "Tools"
NLI["MENU.VISICALC"] = "VisiCalc"
NLI["MENU.FIELDNAMES"] = "Fieldnames"
NLI["ASK.FIND"] = "FIND"
NLI["ASK.ONLY"] = "ONLY"
NLI["MENU.INTERNATIONAL"] = "International"
NLI["MENU.NOCOMMAS"] = "NoCommas"
NLI["MENU.DIGITS"] = "Digits"
NLI["MENU.VIDEO.E:"] = "E: Ahead Systems VGA Wizard"
NLI["MENU.SCIENTIFIC"] = "Scientific"
NLI["MENU.COPY"] = "Copy"
NLI["MENU.GROUPSOFTABLES"] = "GroupsOfTables"
NLI["MENU.PRINTERPORT"] = "PrinterPort"
NLI["MENU.FIXED"] = "Fixed"
NLI["MENU.RECORDS"] = "Records"
NLI["INFO.SAVEVARS"] = "Savevars"
NLI["MENU.TRIMMING"] = "Trimming"
NLI["MENU.CROSSTAB.MAX"] = "3) Max"
NLI["MENU.FILE"] = "File"
NLI["MENU.SYMPHONY.1.0"] = "1) Symphony Release 1.0"
NLI["MENU.APPENDDELIMITED"] = "AppendDelimited"
NLI["MODE.FORM"] = "Form"
NLI["MENU.NUMBERRECORDS"] = "NumberRecords"
NLI["PROMPT.SETUP STRING:"] = "Setup string:"
NLI["MENU.NO-TRIMMING"] = "No-Trimming"
NLI["MENU.FORMFEED"] = "FormFeed"
NLI["MENU.MOVE"] = "Move"
NLI["MENU.PLAY"] = "Play"
NLI["MENU.DISPLAYONLY"] = "DisplayOnly"
NLI["MENU.EDITOR.COPYTOFILE"] = "CopyToFile"
NLI["REPORT.DATE.5"] = "5) dd-Mon-yy"
NLI["MENU.VIDEO.J:B:"] = "B: Orchid VGA: 132x25"
NLI["MENU.VIDEO.L:B:"] = "B: Sigma VGA: 132x44"
NLI["MENU.FORM"] = "Form"
NLI["MENU.EDITOR.AUTOINDENT"] = "AutoIndent"
NLI["MENU.EDITOR.FILE"] = "File"
NLI["MENU.GRAPH.GRAPH.WAIT"] = "Wait"
NLI["REPORT.DATE.8"] = "8) mm/dd/yyyy"
NLI["MENU.VIDEO.I:B:"] = "B: Genoa VGA: 132x28"
NLI["MENU.DESIGN"] = "Design"
NLI["MENU.CHANGE"] = "Change"
NLI["MENU.ZOOM"] = "Zoom"
NLI["MENU.CANCEL"] = "Cancel"
NLI["MENU.MULTIADD"] = "MultiAdd"
NLI["MENU.WAIT"] = "Wait"
NLI["MENU.EDITOR.NEW"] = "New"
NLI["MENU.GRAPH.MODIFY"] = "Modify"
NLI["MENU.SAVE"] = "Save"
NLI["MENU.WRITE-PROTECT"] = "Write-protect"
NLI["TABLE.CROSSTAB"] = "Crosstab"
NLI["MENU.VIDEO.E:D:"] = "D: VGA Wizard: 132x44"
NLI["MENU.WORKSHOP"] = "Workshop"
NLI["MENU.PICKFORM"] = "PickForm"
NLI["MENU.FAMILY"] = "Family"
NLI["MENU.HELPANDFILL"] = "HelpAndFill"
NLI["MENU.ALLCORRESPONDINGFIELDS"] = "AllCorrespondingFields"
NLI["MENU.PAGELAYOUT"] = "PageLayout"
NLI["INFO.THU"] = "Thu"
NLI["MENU.GRAPH.MARKERSANDFILLS"] = "MarkersAndFills"
NLI["REPORT.CURRENT PAGE NUMBER"] = "Current page number"
NLI["REPORT.DATE.6"] = "6) Mon yy"
NLI["MENU.VIDEO.G:A:"] = "A: Compaq VGS: 132x25"
NLI["MENU.VIDEO.I:"] = "I: Genoa Systems Super VGA"
NLI["MENU.CUSTOM"] = "Custom"
NLI["MENU.SUBTRACT"] = "Subtract"
NLI["MENU.EDITOR.SAVE"] = "Save"
NLI["REPORT.DATE.3"] = "3) mm/dd"
NLI["MODE.MAIN"] = "Main"
NLI["MENU.VIDEO.J:"] = "J: Orchid ProDesigner VGA"
NLI["MENU.VIDEO.L:"] = "L: Sigma VGA Legend/HP16"
NLI["MENU.NEW"] = "New"
NLI["MENU.TABLEINDEX"] = "TableIndex"
NLI["PROMPT.TABLE:"] = "Table:"
NLI["MENU.CONVERT"] = "Convert"
NLI["MENU.BORROW"] = "Borrow"
NLI["MENU.GRAPH.3RDPRINTER"] = "3rdPrinter"
NLI["REPORT.WRAP:"] = " wrap:"
NLI["MENU.VIDEO.C:"] = "C: EGA/VGA: 80x25"
NLI["MENU.ASK"] = "Ask"
NLI["MENU.DELIMITED"] = "Delimited"
NLI["MENU.PREVENTLOCK"] = "PreventLock"
NLI["MENU.SHOW"] = "Show"
NLI["MENU.UNLINK"] = "Unlink"
NLI["MENU.EDITOR.PRINT"] = "Print"
NLI["MENU.GRAPH.TITLES"] = "Titles"
NLI["REPORT.DATE.2"] = "2) M o n t h dd, yyyy"
NLI["REPORT.DATE.1"] = "1) mm/dd/yy"
NLI["MENU.VIDEO.H:A:"] = "A: Everex VGA: 80x34"
NLI["MENU.VIDEO.M:"] = "M: STB PowerGraph VGA"
NLI["TABLE.PROBLEMS"] = "Problems"
NLI["ASK.BLANK"] = "BLANK"
NLI["REPORT.TOTAL FOR"] = "Total for "
NLI["INFO.MENUCHOICE.ERROR"] = "Error"
NLI["MENU.SCREEN"] = "Screen"
NLI["MENU.NO"] = "No"
NLI["MENU.MULTI"] = "Multi"
NLI["TABLE.KEYVIOL"] = "$$nli2$$"
NLI["MENU.PERGROUP"] = "PerGroup"
NLI["MENU.NEGATIVEONLY"] = "NegativeOnly"
NLI["MENU.VIDEO.E:B:"] = "B: VGA Wizard: 80x45"
NLI["MENU.LOAD"] = "Load"
NLI["MENU.CONTINUE"] = "Continue"
NLI["MENU.FORMADD"] = "FormAdd"
NLI["INFO.USERNAME"] = "UserName"
NLI["MENU.EDITOR.SHOWCLIPBOARD"] = "ShowClipboard"
NLI["MODE.DATAENTRY"] = "DataEntry"
NLI["MENU.GRAPH.AXES"] = "Axes"
NLI["MENU.REPORT"] = "Report"
NLI["MENU.CROSSTAB.SUM"] = "1) Sum"
NLI["MENU.DBASE"] = "dBASE"
NLI["MENU.HIGHVALUE"] = "HighValue"
NLI["MENU.SORTDIRECTION"] = "SortDirection"
NLI["ASK.INSERT"] = "INSERT"
NLI["MENU.GRAPH.CURRENTPRINTER"] = "CurrentPrinter"
NLI["MENU.GRAPH.COPY"] = "Copy"
NLI["MENU.LOW"] = "Low"
NLI["MENU.COMMAS"] = "Commas"
NLI["MENU.CLOSE"] = "Close"
NLI["MENU.SETUP"] = "Setup"
NLI["MENU.DBASE.4"] = "3) dBASE IV"
NLI["PROMPT.VALUE:"] = "Value:"
NLI["MODE.FILE EDITOR"] = "File Editor"
NLI["MENU.DATAENTRY"] = "DataEntry"
NLI["MENU.123.1.A"] = "1) 1-2-3 Release 1A"
NLI["MODE.REPORT"] = "Report"
NLI["MENU.SUMMARY"] = "Summary"
NLI["REPORT.PAGE FOOTER"] = "Page Footer"
NLI["ASK.CALC"] = "CALC"
NLI["MENU.GRAPH.4THPRINTER"] = "4thPrinter"
NLI["MENU.COLUMNSIZE"] = "ColumnSize"
NLI["MENU.SAMETABLE"] = "SameTable"
NLI["MENU.TODOS"] = "ToDOS"
NLI["MENU.MONOCHROME"] = "Monochrome"
NLI["MENU.GROUPREPEATS"] = "GroupRepeats"
NLI["ASK.SUM"] = "SUM"
NLI["ASK.TODAY"] = "TODAY"
NLI["ASK.EXACTLY"] = "EXACTLY"
NLI["MENU.VIDEO.I:C:"] = "C: Genoa VGA: 132x43"
NLI["MENU.RESTRUCTURE"] = "Restructure"
NLI["MENU.ADD"] = "Add"
NLI["MENU.YES"] = "Yes"
NLI["MENU.BEFORE"] = "Before"
NLI["MENU.RETAIN"] = "Retain"
NLI["REPORT.REPORT FOOTER"] = "Report Footer"
NLI["MENU.GRAPH.2NDPRINTER"] = "2ndPrinter"
NLI["MENU.VIDEO.J:C:"] = "C: Orchid VGA: 132x28"
NLI["MENU.VIDEO.K:B:"] = "B: Paradise EGA/VGA: 132x43"
NLI["MENU.TABLES"] = "Tables"
NLI["MENU.DIRECTORY"] = "Directory"
NLI["MENU.WORDWRAP"] = "WordWrap"
NLI["TABLE.DELETED"] = "Deleted"
NLI["ASK.DELETE"] = "DELETE"
NLI["INFO.WED"] = "Wed"
NLI["MENU.EDITOR.WORDWRAP"] = "WordWrap"
NLI["MODE.RESTRUCTURE"] = "Restructure"
NLI["REPORT.MAXIMUM FOR"] = "Maximum for "
NLI["MENU.RESTART"] = "Restart"
NLI["MENU.FILLED"] = "Filled"
NLI["MENU.PAGE"] = "Page"
NLI["MENU.GRAPH.PIES"] = "Pies"
NLI["MENU.GRAPH.FILE"] = "File"
NLI["MENU.AVERAGE"] = "Average"
NLI["MENU.VIDEO.F:B:"] = "B: ATI VGA: 132x44"
NLI["MENU.123"] = "1-2-3"
NLI["MENU.EXIT"] = "Exit"
NLI["MENU.LOOKUP"] = "Lookup"
NLI["MENU.UNLINKED"] = "Unlinked"
NLI["TABLE.STRUCT"] = "Struct"
NLI["TABLE.ENTRY"] = "Entry"
NLI["MENU.GRAPH.LEGENDSANDLABELS"] = "LegendsAndLabels"
NLI["MENU.GRAPH.GRIDS"] = "Grids"
NLI["MENU.LABELS"] = "Labels"
NLI["REPORT.DATE.4"] = "4) mm/yy"
NLI["MENU.TILE"] = "Tile"
NLI["MENU.VIDEO.A:"] = "A: Auto-detect"
NLI["MENU.PRINTER"] = "Printer"
NLI["MENU.MASTER"] = "Master"
NLI["MENU.EDITOR.OPTIONS"] = "Options"
NLI["MENU.OOPS!"] = "Oops!"
NLI["MODE.CREATE"] = "Create"
NLI["MENU.VIDEO.H:C:"] = "C: Everex VGA: 100x43"
NLI["MENU.CROSSTAB.MIN"] = "2) Min"
NLI["MENU.STYLE"] = "Style"
NLI["TABLE.CHANGED"] = "Changed"
NLI["MENU.FREE-FORM"] = "Free-form"
NLI["MENU.VALUE"] = "Value"
NLI["MENU.LOCK"] = "Lock"
NLI["MENU.PRIVATELOOKUP"] = "PrivateLookup"
NLI["ASK.LIKE"] = "LIKE"
NLI["MENU.EDITOR.CASESENSITIVE"] = "CaseSensitive"
NLI["MENU.EDITOR.SEARCH"] = "Search"
NLI["REPORT.AVERAGE OF"] = "Average of "
NLI["MENU.CREATE"] = "Create"
NLI["MENU.TABLESIZE"] = "TableSize"
NLI["MENU.TEXT"] = "Text"
NLI["FORM.FORMULA"] = "Formula"
NLI["MENU.EDITOR.FIND"] = "Find"
NLI["MENU.EXPORTIMPORT"] = "ExportImport"
NLI["MENU.VALCHECK"] = "ValCheck"
NLI["ASK.MIN"] = "MIN"
NLI["MENU.GRAPH.COLORS"] = "Colors"
NLI["MENU.MAXIMIZE/RESTORE"] = "Maximize/Restore"
NLI["MENU.OK"] = "OK"
NLI["MENU.WHO"] = "Who"
NLI["MENU.GRAPH.DEVICE"] = "Device"
NLI["MENU.VIDEO.G:C:"] = "C: Compaq VGS: 132x43"
NLI["MENU.RESET"] = "Reset"
NLI["MENU.MULTIENTRY"] = "MultiEntry"
NLI["MENU.REPEATPLAY"] = "RepeatPlay"
NLI["MENU.TIME"] = "Time"
NLI["MENU.FIND"] = "Find"
NLI["MENU.LINESQUEEZE"] = "LineSqueeze"
NLI["MENU.DIFFERENTTABLE"] = "DifferentTable"
NLI["MENU.USERNAME"] = "UserName"
NLI["MENU.AUTOREFRESH"] = "AutoRefresh"
NLI["MENU.PROTECT"] = "Protect"
NLI["MENU.DEFINE"] = "Define"
NLI["REPORT.TABLE BAND"] = "Table Band"
NLI["ASK.COUNT"] = "COUNT"
NLI["INFO.SUN"] = "Sun"
NLI["MENU.DESKTOP"] = "Desktop"
NLI["MENU.VIDEO.G:"] = "G: Compaq Integrated (132 column) VGS"
NLI["MENU.VIDEO.I:A:"] = "A: Genoa VGA: 132x25"
NLI["MENU.GENERAL"] = "General"
NLI["MENU.COMMA"] = "Comma"
NLI["MENU.REQUIRED"] = "Required"
NLI["MENU.ERASE"] = "Erase"
NLI["MENU.VIDEO.J:A:"] = "A: Orchid VGA: 80x60"
NLI["MENU.VIDEO.L:A:"] = "A: Sigma VGA: 132x25"
NLI["MENU.IMPORT"] = "Import"
NLI["MENU.END-RECORD"] = "End-Record"
NLI["MENU.FILLNOHELP"] = "FillNoHelp"
NLI["MENU.BORDER"] = "Border"
NLI["TABLE.INSERTED"] = "Inserted"
NLI["MENU.EDITOR.PASTE"] = "Paste"
NLI["MENU.DBASE.3"] = "2) dBASE III"
NLI["MENU.STRUCTURE"] = "Structure"
NLI["MENU.TABULAR"] = "Tabular"
NLI["MENU.REPORT.LOOKUP"] = "Lookup"
NLI["MENU.SETUP PREDEFINED"] = "Predefined"
NLI["TABLE.ANSWER"] = "Answer"
NLI["MENU.EDITOR.ERASE"] = "Erase"
NLI["INFO.FIELD TYPE"] = "Field Type"
NLI["MENU.ALWAYSSIGN"] = "AlwaysSign"
NLI["MENU.123.2"] = "2) 1-2-3 Release 2"
NLI["MENU.NET"] = "Net"
NLI["MENU.PICTURE"] = "Picture"
NLI["MENU.OTHER"] = "Other"
NLI["MENU.JUSTIFY"] = "Justify"
NLI["MENU.SUPPRESS"] = "Suppress"
NLI["ASK.FAST"] = "FAST"
NLI["ASK.NOT"] = "NOT"
NLI["ASK.CHANGETO"] = "CHANGETO"
NLI["MENU.STANDARD"] = "Standard"
NLI["MENU.INTERNATIONALCONVENTION"] = "U.S.Convention"
NLI["MENU.CROSSTAB.COUNT"] = "4) Count"
NLI["MENU.TABLE"] = "Table"
NLI["MENU.DBASE.2"] = "1) dBASE II"
NLI["INFO.PRODUCT"] = "Product"
NLI["REPORT.GROUP HEADER"] = "Group Header for"
NLI["MENU.SETPRIVATE"] = "SetPrivate"
NLI["MENU.CLEAR"] = "Clear"
NLI["MENU.EDITOR.LOCATION"] = "Location"
NLI["MENU.GRAPH.PRINTERTOSCREEN"] = "PrinterToScreen"
NLI["MENU.GRAPH.SCREENTOPRINTER"] = "ScreenToPrinter"
NLI["MENU.GRAPH.OVERALL"] = "Overall"
NLI["MENU.VIDEO.N:B:"] = "B: Video-7 VGA: 100x60"
NLI["MENU.EDITOR"] = "Editor"
NLI["MENU.CLEARPASSWORDS"] = "ClearPasswords"
NLI["FORM.EMBEDDED.START"] = "Embedded "
NLI["INFO.FRI"] = "Fri"
NLI["MENU.VIDEO.H:"] = "H: Everex Viewpoint VGA/EV-673 VGA"
NLI["MENU.VIDEO.M:A:"] = "A: STB VGA: 132x25"
NLI["MENU.UTILITIES"] = "Utilities"
NLI["MENU.PFS"] = "PFS"

endproc
writelib "NLI"  NLI001
release  procs   NLI001

proc NLI033()
; Variables sauvegardes en utilisant la commande SaveVars

Dynarray NLI[]
NLI["MENU.GRAPH.PIC"] = "PIC"
NLI["MENU.CENTER"] = "Centr"
NLI["MENU.LEFT"] = "Gauche"
NLI["MENU.PARENNEGATIVE"] = "ParenthseNgatif"
NLI["MENU.SIGN-CONVENTION"] = "Signe"
NLI["MENU.VIDEO.E:A:"] = "A: VGA Wizard: 80x34"
NLI["MENU.FULLLOCK"] = "Total"
NLI["MODE.EDIT"] = "Edit"
NLI["MENU.CALCULATED"] = "Calcul"
NLI["MENU.EDITOR.EDIT"] = "eDition"
NLI["MENU.SUM"] = "Somme"
NLI["MENU.SCRIPTS"] = "Scripts"
NLI["MENU.RANGE"] = "Fourchette"
NLI["MENU.SETUP CUSTOM"] = "Spciale"
NLI["PROMPT.RESET STRING:"] = "Error"
NLI["ASK.AVERAGE"] = "Moyenne"
NLI["MENU.VIDEO"] = "Vido"
NLI["MENU.VIDEO.H:B:"] = "B: Everex VGA: 80x60"
NLI["MENU.SAME"] = "MmeTable"
NLI["MENU.EDIT"] = "Edition"
NLI["REPORT.PAGE HEADER"] = "En-tte Page"
NLI["MENU.GRAPH.PRINTER"] = "Imprimante"
NLI["REPORT.MINIMUM FOR"] = "Minimum pour "
NLI["MENU.VIDEO.G:D:"] = "D: Compaq VGS: 132x50"
NLI["MENU.VIDEO.N:"] = "N: Video-7 VRAM VGA"
NLI["MENU.DELETE"] = "Supprimer"
NLI["MENU.DO_IT!"] = "Excute!"
NLI["MENU.AREA"] = "Zone"
NLI["MENU.HIDE"] = "Cachs"
NLI["ASK.OR"] = "OU"
NLI["MENU.GRAPH.DURATION"] = "Dure"
NLI["MENU.GRAPH.EPS"] = "EPS"
NLI["MENU.REMOVEBLANKS"] = "Blancs"
NLI["REPORT.CURRENT DATE"] = "Date courante"
NLI["MENU.VIDEO.H:D:"] = "D: Everex VGA: 100x75"
NLI["MENU.FIELD"] = "Champ"
NLI["MENU.JUSTFAMILY"] = "UniquementFamille"
NLI["MENU.DIRLOCK"] = "Rpertoire"
NLI["MENU.INSERT"] = "Insrer"
NLI["REPORT.REPORT HEADER"] = "En-tte Etat"
NLI["PROMPT.EXPRESSION:"] = "Expression :"
NLI["MODE.PASSWORD"] = "MotDePasse"
NLI["MENU.VIDEO.G:B:"] = "B: Compaq VGS: 132x28"
NLI["MENU.SETPRINTER"] = "Paramtres"
NLI["MENU.ENTRY"] = "Entre"
NLI["MENU.REFLEX.1.0"] = "1) Reflex Version 1.0"
NLI["MENU.REFLEX.2.0"] = "3) Reflex Version 2.0"
NLI["INFO.NAME"] = "Nom"
NLI["REPORT.CURRENT RECORD NUMBER"] = "No. d'enregistrement courant"
NLI["MENU.EMPTY"] = "Vider"
NLI["MENU.TABLELOOKUP"] = "RfrenceTable"
NLI["MENU.REFORMAT"] = "Reformater"
NLI["TABLE.LIST"] = "Liste"
NLI["INFO.TUE"] = "Mar"
NLI["MENU.GRAPH.KEYSTROKE"] = "FrappeDeTouche"
NLI["MENU.VIDEO.H:F:"] = "F: Everex VGA: 132x44"
NLI["MENU.QUATTRO.1.X"] = "1) Quattro Version 1.X"
NLI["MENU.PASSWORD"] = "MotDePasse"
NLI["MENU.SINGLE-LINE"] = "TraitSimple"
NLI["MENU.LINK"] = "Chaner"
NLI["MENU.REGROUP"] = "GrouperAutrement"
NLI["MENU.SETTING"] = "Option"
NLI["PROMPT.SCRIPT:"] = "Script :"
NLI["ASK.EVERY"] = "CHACUN"
NLI["MODE.INDEX"] = "Index"
NLI["INFO.FIELD NAME"] = "Nom de Champ"
NLI["MENU.GRAPH.SERIES"] = "Sries"
NLI["REPORT.DATE.10"] = "10) jj/mm/aa"
NLI["MENU.REDRAW"] = "Redessiner"
NLI["MENU.VIDEO.F:A:"] = "A: ATI VGA: 132x25"
NLI["MENU.VIDEO.G:E:"] = "E: Compaq VGS: 132x60"
NLI["MENU.DEFAULT"] = "ParDfaut"
NLI["MENU.WIDTH"] = "LargeurPage"
NLI["TABLE.KEEPENTRY"] = "Sauvegarde"
NLI["REPORT.COUNT OF"] = "Compte de "
NLI["MENU.INTERFACE"] = "Interface"
NLI["MENU.IMAGE"] = "Image"
NLI["MENU.TABLEBAND"] = "Bande"
NLI["MENU.EDITOR.WRITEBLOCK"] = "Ecrire bloc"
NLI["MENU.VIDEO.K:A:"] = "A: Paradise EGA/VGA: 132x25"
NLI["MENU.INDEX"] = "Index"
NLI["MENU.DD-MON-YY"] = "2) JJ-Mmm-AA"
NLI["MENU.RECORD"] = "Enregistrement"
NLI["ASK.NO"] = "AUCUN"
NLI["MENU.FIELDSQUEZZE"] = "CompressionChamp"
NLI["MENU.RIGHT"] = "Droite"
NLI["MENU.U.S.CONVENTION"] = "International"
NLI["MENU.JUSTCURRENTFIELD"] = "ChampEnCours"
NLI["MENU.AUTO"] = "ValidationAuto"
NLI["MENU.#RECORD"] = "NoEnreg"
NLI["MENU.REMOVE"] = "Retirer"
NLI["MENU.TABLEOFGROUPS"] = "TableDeGroupes"
NLI["MENU.GRAPH.PRINTERLAYOUT"] = "Dispositions"
NLI["MODE.GRAPH"] = "Graphe"
NLI["MENU.VIEW"] = "Vue"
NLI["MENU.OUTPUT"] = "Impression"
NLI["MENU.LINKED"] = "AvecLien"
NLI["MENU.RESIZE"] = "Redimensionner"
NLI["ASK.SET"] = "ENSEMBLE"
NLI["MENU.EDITOR.REPLACE"] = "Remplacer"
NLI["MENU.EDITOR.NEXT"] = "Occurrence suivante"
NLI["MODE.SORT"] = "Tri"
NLI["MENU.VIDEO.N:C:"] = "C: Video-7 VGA: 132x43"
NLI["MENU.REGULAR"] = "Standard"
NLI["MENU.ENDOFPAGE"] = "FinDePage"
NLI["MENU.SYMPHONY"] = "Symphony"
NLI["MENU.SYMPHONY.1.1"] = "2) Symphony Version 1.1"
NLI["MENU.FILES"] = "Fichiers"
NLI["MENU.OVERALL"] = "Gnral"
NLI["MENU.REPLACE"] = "Remplacer"
NLI["MENU.EDITOR.INSERTFILE"] = "Insrer fichier"
NLI["MENU.NEXT"] = "Suivante"
NLI["MENU.LINEFEED"] = "SautsDeLigne"
NLI["MENU.ORDERTABLE"] = "TriImage"
NLI["MENU.GRAPH"] = "Graphe"
NLI["MENU.QUATTRO"] = "Quattro"
NLI["MENU.CHANGES"] = "cHangements"
NLI["MENU.LOWVALUE"] = "Sup()"
NLI["INFO.DATE"] = "Date"
NLI["INFO.FILENAME"] = "Nom de Fichier"
NLI["MENU.COMPATIBLE"] = "Compatible"
NLI["MENU.HIGH"] = "Haute"
NLI["MENU.CASCADE"] = "Cascade"
NLI["MENU.VIDEO.H:E:"] = "E: Everex VGA: 132x25"
NLI["MENU.SORT"] = "Tri"
NLI["MENU.FORMS"] = "Fiches"
NLI["MENU.RENAME"] = "Renommer"
NLI["MENU.QUERYSPEED"] = "Acc"
NLI["MENU.DO-IT!"] = "Excute!"
NLI["MENU.SHOWHIGHLIGTH"] = "AffichageRgion"
NLI["ASK.AS"] = "EN"
NLI["MENU.EDITOR.GOTO"] = "Aller"
NLI["MENU.EDITOR.XCUT"] = "coUper"
NLI["MENU.VIDEO.K:"] = "K: Paradise EGA 480/VGA 1024"
NLI["MENU.FORMAT"] = "Format"
NLI["MENU.SCRIPT"] = "Script"
NLI["MENU.ASCII"] = "ASCII"
NLI["MENU.DOUBLE-LINE"] = "DoubleTrait"
NLI["MENU.DATE"] = "Date"
NLI["MENU.HEADINGS"] = "En-ttes"
NLI["REPORT.DATE.9"] = "9) jj.mm.aa"
NLI["MENU.VIDEO.D:"] = "D: EGA/VGA : 80x43/50"
NLI["MENU.OVERRIDE"] = "Nouveaux"
NLI["MENU.CALCEDIT"] = "Calc"
NLI["MENU.ADJUST"] = "Ajuster"
NLI["MENU.RELINK"] = "Rviser"
NLI["MENU.GROUP"] = "Groupe"
NLI["INFO.LOCKTYPE"] = "Type de Verrou"
NLI["MENU.VIDEO.F:"] = "F: ATI VGA Wonder"
NLI["MENU.QUATTROPRO"] = "2) Quattro Pro"
NLI["FORM.EMBEDDED.END"] = " imbrique avec la fiche "
NLI["MENU.EDITOR.CHANGETOEND"] = "Tout remplacer"
NLI["MENU.MODIFY"] = "Modifier"
NLI["MENU.INVENTORY"] = "Inventaire"
NLI["MENU.QUERYSAVE"] = "SauverRequte"
NLI["TABLE.FAMILY"] = "Famille"
NLI["MENU.SIZE/MOVE"] = "Dimensions/Dplacement"
NLI["MENU.VIDEO.E:C:"] = "C: VGA Wizard: 132x25"
NLI["MENU.CROSSTAB"] = "XTab"
NLI["MENU.REFLEX"] = "Reflex"
NLI["MENU.REFLEX.1.1"] = "2) Reflex Version 1.1"
NLI["MODE.COEDIT"] = "CoEdit"
NLI["INFO.SAT"] = "Sam"
NLI["INFO.MON"] = "Lun"
NLI["REPORT.FORM BAND"] = "Bande Fiche"
NLI["MENU.COUNT"] = "Nombre"
NLI["REPORT.GROUP FOOTER"] = "Bas Groupe pour"
NLI["MENU.WINDOW"] = "feNtre"
NLI["MENU.SURFACEQUERIES"] = "FentreRequte"
NLI["MENU.OPEN"] = "Edition"
NLI["MENU.ABOUT"] = "A propos de"
NLI["MENU.MM/DD/YY"] = "1) MM/JJ/AA"
NLI["MENU.DD.MM.YY"] = "3) JJ.MM.AA"
NLI["MENU.YY.MM.DD"] = "4) AA.MM.JJ"
NLI["MENU.PER-GROUP"] = "Par-Groupe"
NLI["MENU.MARGIN"] = "Marge"
NLI["MENU.EDITOR.OPEN"] = "Ouvrir"
NLI["REPORT.DATE.7"] = "7) jj-Mmm-aaaa"
NLI["MENU.COEDIT"] = "CoEdition"
NLI["MENU.INFO"] = "Info"
NLI["MENU.MORE"] = "+"
NLI["MENU.AFTER"] = "Suivante"
NLI["MENU.LENGTH"] = "HauteurPage"
NLI["MENU.VIDEO.B:"] = "B: Monochrome"
NLI["MENU.VIEWGRAPH"] = "VueGraphique"
NLI["MENU.WRITELOCK"] = "EnEcriture"
NLI["MENU.UNDO"] = "Dfaire"
NLI["MENU.COLOR"] = "Couleur"
NLI["ASK.MAX"] = "MAX"
NLI["MENU.VIDEO.J:D:"] = "D: Orchid VGA: 132x44"
NLI["MENU.VIDEO.M:B:"] = "B: STB VGA: 132x44"
NLI["MENU.RANGEOUTPUT"] = "Slection"
NLI["MENU.EXPORT"] = "Export"
NLI["MENU.PLACE"] = "Placer"
NLI["MENU.EDITOR.COPY"] = "Copier"
NLI["MENU.FILEFORMAT"] = "FormatFichier"
NLI["MENU.GRAPH.1STPRINTER"] = "1eImprimante"
NLI["MENU.GRAPH.TYPE"] = "Type"
NLI["REPORT.PER GROUP"] = " par groupe"
NLI["REPORT.DATE.12"] = "12) aa.mm.jj"
NLI["REPORT.DATE.11"] = "11) aa-mm-jj"
NLI["MENU.VIDEO.N:A:"] = "A: Video-7 VGA: 80x60"
NLI["MENU.KEEPSET"] = "Opt"
NLI["MENU.TOOLS"] = "Outils"
NLI["MENU.VISICALC"] = "VisiCalc"
NLI["MENU.FIELDNAMES"] = "NomsDeChamps"
NLI["ASK.FIND"] = "RECHERCHER"
NLI["ASK.ONLY"] = "RIENQUE"
NLI["MENU.INTERNATIONAL"] = "Norme"
NLI["MENU.NOCOMMAS"] = "SansPoints"
NLI["MENU.DIGITS"] = "Chiffres"
NLI["MENU.VIDEO.E:"] = "E: Ahead Systems VGA Wizard"
NLI["MENU.SCIENTIFIC"] = "Scientifique"
NLI["MENU.COPY"] = "Copier"
NLI["MENU.GROUPSOFTABLES"] = "GroupesDeTables"
NLI["MENU.PRINTERPORT"] = "PortImprimante"
NLI["MENU.FIXED"] = "Fixe"
NLI["MENU.RECORDS"] = "Enregistrements"
NLI["INFO.SAVEVARS"] = "Sauvvars"
NLI["MENU.TRIMMING"] = "Tronquer"
NLI["MENU.CROSSTAB.MAX"] = "3) Max"
NLI["MENU.FILE"] = "Fichier"
NLI["MENU.SYMPHONY.1.0"] = "1) Symphony Version 1.0"
NLI["MENU.APPENDDELIMITED"] = "AjoutDlimit"
NLI["MODE.FORM"] = "Fiche"
NLI["MENU.NUMBERRECORDS"] = "NbEnregistrements"
NLI["PROMPT.SETUP STRING:"] = "Error"
NLI["MENU.NO-TRIMMING"] = "NePasTronquer"
NLI["MENU.FORMFEED"] = "PageSuivante"
NLI["MENU.MOVE"] = "Dplacer"
NLI["MENU.PLAY"] = "Lancer"
NLI["MENU.DISPLAYONLY"] = "EnAffichage"
NLI["MENU.EDITOR.COPYTOFILE"] = "copierVersFichier"
NLI["REPORT.DATE.5"] = "5) jj-Mmm-aa"
NLI["MENU.VIDEO.J:B:"] = "B: Orchid VGA: 132x25"
NLI["MENU.VIDEO.L:B:"] = "B: Sigma VGA: 132x44"
NLI["MENU.FORM"] = "Fiche"
NLI["MENU.EDITOR.AUTOINDENT"] = "Indentation"
NLI["MENU.EDITOR.FILE"] = "Fichier"
NLI["MENU.GRAPH.GRAPH.WAIT"] = "Pause"
NLI["REPORT.DATE.8"] = "8) mm/jj/aaaa"
NLI["MENU.VIDEO.I:B:"] = "B: Genoa VGA: 132x28"
NLI["MENU.DESIGN"] = "Conception"
NLI["MENU.CHANGE"] = "Modification"
NLI["MENU.ZOOM"] = "Saut"
NLI["MENU.CANCEL"] = "Annuler"
NLI["MENU.MULTIADD"] = "MultiAjout"
NLI["MENU.WAIT"] = "Arrt"
NLI["MENU.EDITOR.NEW"] = "Crer"
NLI["MENU.GRAPH.MODIFY"] = "Modifier"
NLI["MENU.SAVE"] = "Sauvegarder"
NLI["MENU.WRITE-PROTECT"] = "ProtectionEnEcriture"
NLI["TABLE.CROSSTAB"] = "Xtab"
NLI["MENU.VIDEO.E:D:"] = "D: VGA Wizard: 132x44"
NLI["MENU.WORKSHOP"] = "Workshop"
NLI["MENU.PICKFORM"] = "ChoixFiche"
NLI["MENU.FAMILY"] = "Famille"
NLI["MENU.HELPANDFILL"] = "ChercherEtRecopier"
NLI["MENU.ALLCORRESPONDINGFIELDS"] = "TousChampsCorrespondants"
NLI["MENU.PAGELAYOUT"] = "Disposition"
NLI["INFO.THU"] = "Jeu"
NLI["MENU.GRAPH.MARKERSANDFILLS"] = "Points&Motifs"
NLI["REPORT.CURRENT PAGE NUMBER"] = "No. de page courant"
NLI["REPORT.DATE.6"] = "6) Mmm aa"
NLI["MENU.VIDEO.G:A:"] = "A: Compaq VGS: 132x25"
NLI["MENU.VIDEO.I:"] = "I: Genoa Systems Super VGA"
NLI["MENU.CUSTOM"] = "Custom"
NLI["MENU.SUBTRACT"] = "Soustraire"
NLI["MENU.EDITOR.SAVE"] = "Sauvegarder"
NLI["REPORT.DATE.3"] = "3) mm/jj"
NLI["MODE.MAIN"] = "MenuPr"
NLI["MENU.VIDEO.J:"] = "J: Orchid ProDesigner VGA"
NLI["MENU.VIDEO.L:"] = "L: Sigma VGA Legend/HP16"
NLI["MENU.NEW"] = "AutreTable"
NLI["MENU.TABLEINDEX"] = "TableIndex"
NLI["PROMPT.TABLE:"] = "Table :"
NLI["MENU.CONVERT"] = "Conversion"
NLI["MENU.BORROW"] = "Reprise"
NLI["MENU.GRAPH.3RDPRINTER"] = "3eImprimante"
NLI["REPORT.WRAP:"] = " mise-en-continu : "
NLI["MENU.VIDEO.C:"] = "C: EGA/VGA : 80x25"
NLI["MENU.ASK"] = "Requte"
NLI["MENU.DELIMITED"] = "Dlimit"
NLI["MENU.PREVENTLOCK"] = "ContreVerrou"
NLI["MENU.SHOW"] = "Visibles"
NLI["MENU.UNLINK"] = "Dtruire"
NLI["MENU.EDITOR.PRINT"] = "Lancer impression"
NLI["MENU.GRAPH.TITLES"] = "Titres"
NLI["REPORT.DATE.2"] = "2) M o i s   jj, aaaa"
NLI["REPORT.DATE.1"] = "1) mm/jj/aa"
NLI["MENU.VIDEO.H:A:"] = "A: Everex VGA: 80x34"
NLI["MENU.VIDEO.M:"] = "M: STB PowerGraph VGA"
NLI["TABLE.PROBLEMS"] = "Probleme"
NLI["ASK.BLANK"] = "BLANC"
NLI["REPORT.TOTAL FOR"] = "Total pour "
NLI["INFO.MENUCHOICE.ERROR"] = "Error"
NLI["MENU.SCREEN"] = "Ecran"
NLI["MENU.NO"] = "Non"
NLI["MENU.MULTI"] = "Multi"
NLI["TABLE.KEYVIOL"] = "$$nli2$$"
NLI["MENU.PERGROUP"] = "ParGroupe"
NLI["MENU.NEGATIVEONLY"] = "NgatifSeul"
NLI["MENU.VIDEO.E:B:"] = "B: VGA Wizard: 80x45"
NLI["MENU.LOAD"] = "Charger"
NLI["MENU.CONTINUE"] = "Continuer"
NLI["MENU.FORMADD"] = "Envoi"
NLI["INFO.USERNAME"] = "Nom de l'Utilisateur"
NLI["MENU.EDITOR.SHOWCLIPBOARD"] = "Presse-papiers"
NLI["MODE.DATAENTRY"] = "Saisie"
NLI["MENU.GRAPH.AXES"] = "Axes"
NLI["MENU.REPORT"] = "Etat"
NLI["MENU.CROSSTAB.SUM"] = "1) Somme"
NLI["MENU.DBASE"] = "dBASE"
NLI["MENU.HIGHVALUE"] = "Inf()"
NLI["MENU.SORTDIRECTION"] = "OrdreTri"
NLI["ASK.INSERT"] = "Insrer"
NLI["MENU.GRAPH.CURRENTPRINTER"] = "ImprimanteCourante"
NLI["MENU.GRAPH.COPY"] = "Copier"
NLI["MENU.LOW"] = "Basse"
NLI["MENU.COMMAS"] = "Points"
NLI["MENU.CLOSE"] = "Fermer"
NLI["MENU.SETUP"] = "Configuration"
NLI["MENU.DBASE.4"] = "3) dBASE IV"
NLI["PROMPT.VALUE:"] = "Valeur :"
NLI["MODE.FILE EDITOR"] = "Editeur"
NLI["MENU.DATAENTRY"] = "Saisie"
NLI["MENU.123.1.A"] = "1) 1-2-3 Version 1A"
NLI["MODE.REPORT"] = "Etat"
NLI["MENU.SUMMARY"] = "Global"
NLI["REPORT.PAGE FOOTER"] = "Bas Page"
NLI["ASK.CALC"] = "CALC"
NLI["MENU.GRAPH.4THPRINTER"] = "4eImprimante"
NLI["MENU.COLUMNSIZE"] = "Largeur"
NLI["MENU.SAMETABLE"] = "Mme"
NLI["MENU.TODOS"] = "DOS"
NLI["MENU.MONOCHROME"] = "Monochrome"
NLI["MENU.GROUPREPEATS"] = "Rptitions"
NLI["ASK.SUM"] = "Somme"
NLI["ASK.TODAY"] = "CEJOUR"
NLI["ASK.EXACTLY"] = "IDENTIQUE"
NLI["MENU.VIDEO.I:C:"] = "C: Genoa VGA: 132x43"
NLI["MENU.RESTRUCTURE"] = "Restructuration"
NLI["MENU.ADD"] = "Ajout"
NLI["MENU.YES"] = "Oui"
NLI["MENU.BEFORE"] = "Prcdente"
NLI["MENU.RETAIN"] = "Conserver"
NLI["REPORT.REPORT FOOTER"] = "Bas Etat"
NLI["MENU.GRAPH.2NDPRINTER"] = "2eImprimante"
NLI["MENU.VIDEO.J:C:"] = "C: Orchid VGA: 132x28"
NLI["MENU.VIDEO.K:B:"] = "B: Paradise EGA/VGA: 132x43"
NLI["MENU.TABLES"] = "Tables"
NLI["MENU.DIRECTORY"] = "Rpertoire"
NLI["MENU.WORDWRAP"] = "TexteContinu"
NLI["TABLE.DELETED"] = "Supprime"
NLI["ASK.DELETE"] = "Supprimer"
NLI["INFO.WED"] = "Mer"
NLI["MENU.EDITOR.WORDWRAP"] = "RetourLigne"
NLI["MODE.RESTRUCTURE"] = "Restruct"
NLI["REPORT.MAXIMUM FOR"] = "Maximum pour "
NLI["MENU.RESTART"] = "Redmarrer"
NLI["MENU.FILLED"] = "Remplissage"
NLI["MENU.PAGE"] = "Page"
NLI["MENU.GRAPH.PIES"] = "DiagCirc"
NLI["MENU.GRAPH.FILE"] = "Fichier"
NLI["MENU.AVERAGE"] = "Moyenne"
NLI["MENU.VIDEO.F:B:"] = "B: ATI VGA: 132x44"
NLI["MENU.123"] = "1-2-3"
NLI["MENU.EXIT"] = "Quitter"
NLI["MENU.LOOKUP"] = "TableRfrence"
NLI["MENU.UNLINKED"] = "SansLien"
NLI["TABLE.STRUCT"] = "Struct"
NLI["TABLE.ENTRY"] = "Entree"
NLI["MENU.GRAPH.LEGENDSANDLABELS"] = "Lgendes&Textes"
NLI["MENU.GRAPH.GRIDS"] = "Grilles"
NLI["MENU.LABELS"] = "Etiquette"
NLI["REPORT.DATE.4"] = "4) mm/aa"
NLI["MENU.TILE"] = "Mosaque"
NLI["MENU.VIDEO.A:"] = "A: Auto-dtection"
NLI["MENU.PRINTER"] = "Imprimante"
NLI["MENU.MASTER"] = "Matre"
NLI["MENU.EDITOR.OPTIONS"] = "Options"
NLI["MENU.OOPS!"] = "Attention!"
NLI["MODE.CREATE"] = "Cration"
NLI["MENU.VIDEO.H:C:"] = "C: Everex VGA: 100x43"
NLI["MENU.CROSSTAB.MIN"] = "2) Min"
NLI["MENU.STYLE"] = "Style"
NLI["TABLE.CHANGED"] = "Modifie"
NLI["MENU.FREE-FORM"] = "FicheLibre"
NLI["MENU.VALUE"] = "Valeur"
NLI["MENU.LOCK"] = "Verrou"
NLI["MENU.PRIVATELOOKUP"] = "AccsRestreint"
NLI["ASK.LIKE"] = "COMME"
NLI["MENU.EDITOR.CASESENSITIVE"] = "Diff. Maj/Min"
NLI["MENU.EDITOR.SEARCH"] = "Rechercher"
NLI["REPORT.AVERAGE OF"] = "Moyenne de "
NLI["MENU.CREATE"] = "Crer"
NLI["MENU.TABLESIZE"] = "Hauteur"
NLI["MENU.TEXT"] = "Texte"
NLI["FORM.FORMULA"] = "Formule"
NLI["MENU.EDITOR.FIND"] = "Chercher"
NLI["MENU.EXPORTIMPORT"] = "ExpImp"
NLI["MENU.VALCHECK"] = "CtrlValidit"
NLI["ASK.MIN"] = "MIN"
NLI["MENU.GRAPH.COLORS"] = "Couleurs"
NLI["MENU.MAXIMIZE/RESTORE"] = "Restaurer/Agrandir"
NLI["MENU.OK"] = "Confirmer"
NLI["MENU.WHO"] = "Qui"
NLI["MENU.GRAPH.DEVICE"] = "Unit"
NLI["MENU.VIDEO.G:C:"] = "C: Compaq VGS: 132x43"
NLI["MENU.RESET"] = "Initialiser"
NLI["MENU.MULTIENTRY"] = "MultiEntre"
NLI["MENU.REPEATPLAY"] = "Rpter"
NLI["MENU.TIME"] = "Heure"
NLI["MENU.FIND"] = "Chercher"
NLI["MENU.LINESQUEEZE"] = "SuppressionLigne"
NLI["MENU.DIFFERENTTABLE"] = "Diffrente"
NLI["MENU.USERNAME"] = "Utilisateur"
NLI["MENU.AUTOREFRESH"] = "AutoRafrachissement"
NLI["MENU.PROTECT"] = "Prtg"
NLI["MENU.DEFINE"] = "Dfinir"
NLI["REPORT.TABLE BAND"] = "Bande Table"
NLI["ASK.COUNT"] = "Nombre"
NLI["INFO.SUN"] = "Dim"
NLI["MENU.DESKTOP"] = "esPace de travail"
NLI["MENU.VIDEO.G:"] = "G: Compaq Intgr (132 colonnes) VGS"
NLI["MENU.VIDEO.I:A:"] = "A: Genoa VGA: 132x25"
NLI["MENU.GENERAL"] = "CasGnral"
NLI["MENU.COMMA"] = "Point"
NLI["MENU.REQUIRED"] = "Obligatoire"
NLI["MENU.ERASE"] = "Oter"
NLI["MENU.VIDEO.J:A:"] = "A: Orchid VGA: 80x60"
NLI["MENU.VIDEO.L:A:"] = "A: Sigma VGA: 132x25"
NLI["MENU.IMPORT"] = "Import"
NLI["MENU.END-RECORD"] = "FinEnregistrement"
NLI["MENU.FILLNOHELP"] = "RecopierSansAide"
NLI["MENU.BORDER"] = "Bordure"
NLI["TABLE.INSERTED"] = "Insere"
NLI["MENU.EDITOR.PASTE"] = "collEr"
NLI["MENU.DBASE.3"] = "2) dBASE III"
NLI["MENU.STRUCTURE"] = "Structure"
NLI["MENU.TABULAR"] = "Tabulaire"
NLI["MENU.REPORT.LOOKUP"] = "Lien"
NLI["MENU.SETUP PREDEFINED"] = "Prdfinie"
NLI["TABLE.ANSWER"] = "Reponse"
NLI["MENU.EDITOR.ERASE"] = "Oter"
NLI["INFO.FIELD TYPE"] = "Type de Champ"
NLI["MENU.ALWAYSSIGN"] = "AffichageSigne"
NLI["MENU.123.2"] = "2) 1-2-3 Version 2"
NLI["MENU.NET"] = "GstRseau"
NLI["MENU.PICTURE"] = "Modle"
NLI["MENU.OTHER"] = "Autre"
NLI["MENU.JUSTIFY"] = "Justifier"
NLI["MENU.SUPPRESS"] = "Enlever"
NLI["ASK.FAST"] = "RAPIDE"
NLI["ASK.NOT"] = "SAUF"
NLI["ASK.CHANGETO"] = "REMPLACERPAR"
NLI["MENU.STANDARD"] = "Standard"
NLI["MENU.INTERNATIONALCONVENTION"] = "USA"
NLI["MENU.CROSSTAB.COUNT"] = "4) Compte"
NLI["MENU.TABLE"] = "Table"
NLI["MENU.DBASE.2"] = "1) dBASE II"
NLI["INFO.PRODUCT"] = "Produit"
NLI["REPORT.GROUP HEADER"] = "En-tte Groupe pour"
NLI["MENU.SETPRIVATE"] = "Personnel"
NLI["MENU.CLEAR"] = "Effacer"
NLI["MENU.EDITOR.LOCATION"] = "Localiser"
NLI["MENU.GRAPH.PRINTERTOSCREEN"] = "Imprimante->Ecran"
NLI["MENU.GRAPH.SCREENTOPRINTER"] = "Ecran->Imprimante"
NLI["MENU.GRAPH.OVERALL"] = "Gnral"
NLI["MENU.VIDEO.N:B:"] = "B: Video-7 VGA: 100x60"
NLI["MENU.EDITOR"] = "Editeur"
NLI["MENU.CLEARPASSWORDS"] = "EffacerMotsDePasse"
NLI["FORM.EMBEDDED.START"] = "Table "
NLI["INFO.FRI"] = "Ven"
NLI["MENU.VIDEO.H:"] = "H: Everex Viewpoint VGA/EV-673 VGA"
NLI["MENU.VIDEO.M:A:"] = "A: STB VGA: 132x25"
NLI["MENU.UTILITIES"] = "Utilitaires"
NLI["MENU.PFS"] = "PFS"

endproc
writelib "NLI"  NLI033
release  procs   NLI033

proc NLI039()
; Variabili archiviate con SAVEVARS

Dynarray NLI[]
NLI["MENU.GRAPH.PIC"] = "PIC"
NLI["MENU.CENTER"] = "Centro"
NLI["MENU.LEFT"] = "Sinistra"
NLI["MENU.PARENNEGATIVE"] = "Parentesi"
NLI["MENU.SIGN-CONVENTION"] = "Segno"
NLI["MENU.VIDEO.E:A:"] = "A: VGA Wizard: 80x34"
NLI["MENU.FULLLOCK"] = "Totale"
NLI["MODE.EDIT"] = "Edita"
NLI["MENU.CALCULATED"] = "Calcolato"
NLI["MENU.EDITOR.EDIT"] = "eDita"
NLI["MENU.SUM"] = "Somma"
NLI["MENU.SCRIPTS"] = "Programmi"
NLI["MENU.RANGE"] = "Intervallo"
NLI["MENU.SETUP CUSTOM"] = "Speciale"
NLI["PROMPT.RESET STRING:"] = "Error"
NLI["ASK.AVERAGE"] = "Media"
NLI["MENU.VIDEO"] = "Video"
NLI["MENU.VIDEO.H:B:"] = "B: Everex VGA: 80x60"
NLI["MENU.SAME"] = "Stessa"
NLI["MENU.EDIT"] = "Edita"
NLI["REPORT.PAGE HEADER"] = "Intestazione Pagina"
NLI["MENU.GRAPH.PRINTER"] = "Stampante"
NLI["REPORT.MINIMUM FOR"] = "Minimo di "
NLI["MENU.VIDEO.G:D:"] = "D: Compaq VGS: 132x50"
NLI["MENU.VIDEO.N:"] = "N: Video-7 VRAM VGA"
NLI["MENU.DELETE"] = "Elimina"
NLI["MENU.DO_IT!"] = "ESEGUI!"
NLI["MENU.AREA"] = "Zona"
NLI["MENU.HIDE"] = "Cela"
NLI["ASK.OR"] = "OPPURE"
NLI["MENU.GRAPH.DURATION"] = "Durata"
NLI["MENU.GRAPH.EPS"] = "EPS"
NLI["MENU.REMOVEBLANKS"] = "Comprimi"
NLI["REPORT.CURRENT DATE"] = "Data corrente"
NLI["MENU.VIDEO.H:D:"] = "D: Everex VGA: 100x75"
NLI["MENU.FIELD"] = "Campo"
NLI["MENU.JUSTFAMILY"] = "Oggetti"
NLI["MENU.DIRLOCK"] = "BloccoDir"
NLI["MENU.INSERT"] = "Inserisci"
NLI["REPORT.REPORT HEADER"] = "Intestazione Rapporto"
NLI["PROMPT.EXPRESSION:"] = "Espressione:"
NLI["MODE.PASSWORD"] = "Diritti"
NLI["MENU.VIDEO.G:B:"] = "B: Compaq VGS: 132x28"
NLI["MENU.SETPRINTER"] = "ControlloStampante"
NLI["MENU.ENTRY"] = "Raccogli"
NLI["MENU.REFLEX.1.0"] = "1) Reflex Release 1.0"
NLI["MENU.REFLEX.2.0"] = "3) Reflex Release 2.0"
NLI["INFO.NAME"] = "Nome"
NLI["REPORT.CURRENT RECORD NUMBER"] = "Numero di record corrente"
NLI["MENU.EMPTY"] = "Vuota"
NLI["MENU.TABLELOOKUP"] = "Consultazione"
NLI["MENU.REFORMAT"] = "Formatta"
NLI["TABLE.LIST"] = "Elenco"
NLI["INFO.TUE"] = "Mar"
NLI["MENU.GRAPH.KEYSTROKE"] = "Tasto"
NLI["MENU.VIDEO.H:F:"] = "F: Everex VGA: 132x44"
NLI["MENU.QUATTRO.1.X"] = "1) Quattro Release 1.X"
NLI["MENU.PASSWORD"] = "ParolaD'Ordine"
NLI["MENU.SINGLE-LINE"] = "SingolaRiga"
NLI["MENU.LINK"] = "Collega"
NLI["MENU.REGROUP"] = "Riorganizza"
NLI["MENU.SETTING"] = "Imposta"
NLI["PROMPT.SCRIPT:"] = "Programma:"
NLI["ASK.EVERY"] = "OGNI"
NLI["MODE.INDEX"] = "Indice"
NLI["INFO.FIELD NAME"] = "Nome Campo"
NLI["MENU.GRAPH.SERIES"] = "Serie"
NLI["REPORT.DATE.10"] = "10) gg/mm/aa"
NLI["MENU.REDRAW"] = "Ridisegna"
NLI["MENU.VIDEO.F:A:"] = "A: ATI VGA: 132x25"
NLI["MENU.VIDEO.G:E:"] = "E: Compaq VGS: 132x60"
NLI["MENU.DEFAULT"] = "Ordinario"
NLI["MENU.WIDTH"] = "Ampiezza"
NLI["TABLE.KEEPENTRY"] = "Conserva"
NLI["REPORT.COUNT OF"] = "Conto di "
NLI["MENU.INTERFACE"] = "Interfaccia"
NLI["MENU.IMAGE"] = "Fissa"
NLI["MENU.TABLEBAND"] = "ZonaTab"
NLI["MENU.EDITOR.WRITEBLOCK"] = "BloccoScrivi"
NLI["MENU.VIDEO.K:A:"] = "A: Paradise EGA/VGA: 132x25"
NLI["MENU.INDEX"] = "iNdice"
NLI["MENU.DD-MON-YY"] = "GG-Mes-AA"
NLI["MENU.RECORD"] = "Record"
NLI["ASK.NO"] = "NESSUN"
NLI["MENU.FIELDSQUEZZE"] = "Spazi"
NLI["MENU.RIGHT"] = "Destra"
NLI["MENU.U.S.CONVENTION"] = "ConvenzioneInternazionale"
NLI["MENU.JUSTCURRENTFIELD"] = "SoloCorrente"
NLI["MENU.AUTO"] = "AutoSpostamento"
NLI["MENU.#RECORD"] = "Enumerativo"
NLI["MENU.REMOVE"] = "Rimuovi"
NLI["MENU.TABLEOFGROUPS"] = "TabellaDiGruppi"
NLI["MENU.GRAPH.PRINTERLAYOUT"] = "ImpiantoStampa"
NLI["MODE.GRAPH"] = "Grafico"
NLI["MENU.VIEW"] = "Dati"
NLI["MENU.OUTPUT"] = "Produci"
NLI["MENU.LINKED"] = "Collegata"
NLI["MENU.RESIZE"] = "Ridimensiona"
NLI["ASK.SET"] = "INSIEME"
NLI["MENU.EDITOR.REPLACE"] = "Sostituisci"
NLI["MENU.EDITOR.NEXT"] = "Avanti"
NLI["MODE.SORT"] = "Ordina"
NLI["MENU.VIDEO.N:C:"] = "C: Video-7 VGA: 132x43"
NLI["MENU.REGULAR"] = "Normale"
NLI["MENU.ENDOFPAGE"] = "FinePagina"
NLI["MENU.SYMPHONY"] = "Symphony"
NLI["MENU.SYMPHONY.1.1"] = "2) Symphony Release 1.1"
NLI["MENU.FILES"] = "Files"
NLI["MENU.OVERALL"] = "Globale"
NLI["MENU.REPLACE"] = "Sostituisci"
NLI["MENU.EDITOR.INSERTFILE"] = "InserisciFile"
NLI["MENU.NEXT"] = "Avanti"
NLI["MENU.LINEFEED"] = "LineFeed"
NLI["MENU.ORDERTABLE"] = "OrdineTabella"
NLI["MENU.GRAPH"] = "Grafico"
NLI["MENU.QUATTRO"] = "Quattro"
NLI["MENU.CHANGES"] = "Variazioni"
NLI["MENU.LOWVALUE"] = "Inf"
NLI["INFO.DATE"] = "Data"
NLI["INFO.FILENAME"] = "NomeFile"
NLI["MENU.COMPATIBLE"] = "Compatibile"
NLI["MENU.HIGH"] = "Alto"
NLI["MENU.CASCADE"] = "Sovrapponi"
NLI["MENU.VIDEO.H:E:"] = "E: Everex VGA: 132x25"
NLI["MENU.SORT"] = "Ordina"
NLI["MENU.FORMS"] = "Schede"
NLI["MENU.RENAME"] = "Rinomina"
NLI["MENU.QUERYSPEED"] = "Indici"
NLI["MENU.DO-IT!"] = "ESEGUI!"
NLI["MENU.SHOWHIGHLIGTH"] = "Ripetizione"
NLI["ASK.AS"] = "NOMINA"
NLI["MENU.EDITOR.GOTO"] = "Vai"
NLI["MENU.EDITOR.XCUT"] = "Taglia"
NLI["MENU.VIDEO.K:"] = "K: Paradise EGA 480/VGA 1024"
NLI["MENU.FORMAT"] = "Formato"
NLI["MENU.SCRIPT"] = "Programma"
NLI["MENU.ASCII"] = "ASCII"
NLI["MENU.DOUBLE-LINE"] = "DoppiaRiga"
NLI["MENU.DATE"] = "Data"
NLI["MENU.HEADINGS"] = "Titoli"
NLI["REPORT.DATE.9"] = "9) gg.mm.aa"
NLI["MENU.VIDEO.D:"] = "D: EGA/VGA: 80x43/50"
NLI["MENU.OVERRIDE"] = "Forza"
NLI["MENU.CALCEDIT"] = "Ricalcola"
NLI["MENU.ADJUST"] = "Aggiusta"
NLI["MENU.RELINK"] = "Ricollega"
NLI["MENU.GROUP"] = "Gruppo"
NLI["INFO.LOCKTYPE"] = "TipoBlocco"
NLI["MENU.VIDEO.F:"] = "F: ATI VGA Wonder"
NLI["MENU.QUATTROPRO"] = "2) Quattro Pro"
NLI["FORM.EMBEDDED.END"] = " con scheda "
NLI["MENU.EDITOR.CHANGETOEND"] = "sostituisciFine"
NLI["MENU.MODIFY"] = "Muta"
NLI["MENU.INVENTORY"] = "Lista"
NLI["MENU.QUERYSAVE"] = "SalvaQuesito"
NLI["TABLE.FAMILY"] = "Famiglia"
NLI["MENU.SIZE/MOVE"] = "Ridimensiona/Sposta"
NLI["MENU.VIDEO.E:C:"] = "C: VGA Wizard: 132x25"
NLI["MENU.CROSSTAB"] = "Incroci"
NLI["MENU.REFLEX"] = "Reflex"
NLI["MENU.REFLEX.1.1"] = "2) Reflex Release 1.1"
NLI["MODE.COEDIT"] = "CoEdita"
NLI["INFO.SAT"] = "Sab"
NLI["INFO.MON"] = "Lun"
NLI["REPORT.FORM BAND"] = "Zona Scheda"
NLI["MENU.COUNT"] = "Conto"
NLI["REPORT.GROUP FOOTER"] = "Fondo Gruppo per"
NLI["MENU.WINDOW"] = "Finestra"
NLI["MENU.SURFACEQUERIES"] = "MostraQuesiti"
NLI["MENU.OPEN"] = "Apri"
NLI["MENU.ABOUT"] = "informaZioni"
NLI["MENU.MM/DD/YY"] = "MM/GG/AA"
NLI["MENU.DD.MM.YY"] = "GG.MM.AA"
NLI["MENU.YY.MM.DD"] = "AA.MM.GG"
NLI["MENU.PER-GROUP"] = "Per-Gruppo"
NLI["MENU.MARGIN"] = "Margine"
NLI["MENU.EDITOR.OPEN"] = "Apri"
NLI["REPORT.DATE.7"] = "7) gg-Mes-aaaa"
NLI["MENU.COEDIT"] = "CoEdita"
NLI["MENU.INFO"] = "Mostra"
NLI["MENU.MORE"] = "Altro"
NLI["MENU.AFTER"] = "Dopo"
NLI["MENU.LENGTH"] = "Lunghezza"
NLI["MENU.VIDEO.B:"] = "B: Monocromatico"
NLI["MENU.VIEWGRAPH"] = "Visualizza"
NLI["MENU.WRITELOCK"] = "Parziale"
NLI["MENU.UNDO"] = "Ripristina"
NLI["MENU.COLOR"] = "Colora"
NLI["ASK.MAX"] = "MAX"
NLI["MENU.VIDEO.J:D:"] = "D: Orchid VGA: 132x44"
NLI["MENU.VIDEO.M:B:"] = "B: STB VGA: 132x44"
NLI["MENU.RANGEOUTPUT"] = "Ridotto"
NLI["MENU.EXPORT"] = "Fuori"
NLI["MENU.PLACE"] = "Posiziona"
NLI["MENU.EDITOR.COPY"] = "Duplica"
NLI["MENU.FILEFORMAT"] = "FormatoFile"
NLI["MENU.GRAPH.1STPRINTER"] = "PrimaStampante"
NLI["MENU.GRAPH.TYPE"] = "Tipo"
NLI["REPORT.PER GROUP"] = " per gruppo"
NLI["REPORT.DATE.12"] = "12) aa.mm.gg"
NLI["REPORT.DATE.11"] = "11) aa-mm-gg"
NLI["MENU.VIDEO.N:A:"] = "A: Video-7 VGA: 80x60"
NLI["MENU.KEEPSET"] = "Cineteca"
NLI["MENU.TOOLS"] = "Varie"
NLI["MENU.VISICALC"] = "VisiCalc"
NLI["MENU.FIELDNAMES"] = "NomiCampi"
NLI["ASK.FIND"] = "Trova"
NLI["ASK.ONLY"] = "SOLO"
NLI["MENU.INTERNATIONAL"] = "Internazionale"
NLI["MENU.NOCOMMAS"] = "SenzaSeparatori"
NLI["MENU.DIGITS"] = "Cifre"
NLI["MENU.VIDEO.E:"] = "E: Ahead Systems VGA Wizard"
NLI["MENU.SCIENTIFIC"] = "Scientifico"
NLI["MENU.COPY"] = "Duplica"
NLI["MENU.GROUPSOFTABLES"] = "GruppiDiTabelle"
NLI["MENU.PRINTERPORT"] = "UscitaStampante"
NLI["MENU.FIXED"] = "Fisso"
NLI["MENU.RECORDS"] = "Records"
NLI["INFO.SAVEVARS"] = "Salvavar"
NLI["MENU.TRIMMING"] = "Troncamento"
NLI["MENU.CROSSTAB.MAX"] = "3) Max"
NLI["MENU.FILE"] = "File"
NLI["MENU.SYMPHONY.1.0"] = "1) Symphony Release 1.0"
NLI["MENU.APPENDDELIMITED"] = "AggiungiDelimitato"
NLI["MODE.FORM"] = "Scheda"
NLI["MENU.NUMBERRECORDS"] = "NumeroDiRecord"
NLI["PROMPT.SETUP STRING:"] = "Error"
NLI["MENU.NO-TRIMMING"] = "Nessun-Troncamento"
NLI["MENU.FORMFEED"] = "FormFeed"
NLI["MENU.MOVE"] = "Sposta"
NLI["MENU.PLAY"] = "Lancia"
NLI["MENU.DISPLAYONLY"] = "Lettura"
NLI["MENU.EDITOR.COPYTOFILE"] = "CopiaInFile"
NLI["REPORT.DATE.5"] = "5) gg-Mes-aa"
NLI["MENU.VIDEO.J:B:"] = "B: Orchid VGA: 132x25"
NLI["MENU.VIDEO.L:B:"] = "B: Sigma VGA: 132x44"
NLI["MENU.FORM"] = "Scheda"
NLI["MENU.EDITOR.AUTOINDENT"] = "Rientro"
NLI["MENU.EDITOR.FILE"] = "File"
NLI["MENU.GRAPH.GRAPH.WAIT"] = "Attesa"
NLI["REPORT.DATE.8"] = "8) mm/gg/aaaa"
NLI["MENU.VIDEO.I:B:"] = "B: Genoa VGA: 132x28"
NLI["MENU.DESIGN"] = "Disegna"
NLI["MENU.CHANGE"] = "Modifica"
NLI["MENU.ZOOM"] = "Posto"
NLI["MENU.CANCEL"] = "Annulla"
NLI["MENU.MULTIADD"] = "Multi+"
NLI["MENU.WAIT"] = "Attesa"
NLI["MENU.EDITOR.NEW"] = "Nuovo"
NLI["MENU.GRAPH.MODIFY"] = "Muta"
NLI["MENU.SAVE"] = "Salva"
NLI["MENU.WRITE-PROTECT"] = "Scrittura"
NLI["TABLE.CROSSTAB"] = "Incroci"
NLI["MENU.VIDEO.E:D:"] = "D: VGA Wizard: 132x44"
NLI["MENU.WORKSHOP"] = "Workshop"
NLI["MENU.PICKFORM"] = "Vista"
NLI["MENU.FAMILY"] = "Famiglia"
NLI["MENU.HELPANDFILL"] = "Guidata"
NLI["MENU.ALLCORRESPONDINGFIELDS"] = "TuttiCorrispondenti"
NLI["MENU.PAGELAYOUT"] = "Impianto"
NLI["INFO.THU"] = "Gio"
NLI["MENU.GRAPH.MARKERSANDFILLS"] = "Marcatori-Tratteggi"
NLI["REPORT.CURRENT PAGE NUMBER"] = "Numero di pagina corrente"
NLI["REPORT.DATE.6"] = "6) Mes aa"
NLI["MENU.VIDEO.G:A:"] = "A: Compaq VGS: 132x25"
NLI["MENU.VIDEO.I:"] = "I: Genoa Systems Super VGA"
NLI["MENU.CUSTOM"] = "Configurazione"
NLI["MENU.SUBTRACT"] = "Togli"
NLI["MENU.EDITOR.SAVE"] = "Salva"
NLI["REPORT.DATE.3"] = "3) mm/gg"
NLI["MODE.MAIN"] = "Base"
NLI["MENU.VIDEO.J:"] = "J: Orchid ProDesigner VGA"
NLI["MENU.VIDEO.L:"] = "L: Sigma VGA Legend/HP16"
NLI["MENU.NEW"] = "Nuova"
NLI["MENU.TABLEINDEX"] = "IndiceTabella"
NLI["PROMPT.TABLE:"] = "Tabella:"
NLI["MENU.CONVERT"] = "Converti"
NLI["MENU.BORROW"] = "Riproduci"
NLI["MENU.GRAPH.3RDPRINTER"] = "TerzaStampante"
NLI["REPORT.WRAP:"] = " linee:"
NLI["MENU.VIDEO.C:"] = "C: EGA/VGA: 80x25"
NLI["MENU.ASK"] = "Quesiti"
NLI["MENU.DELIMITED"] = "Delimitato"
NLI["MENU.PREVENTLOCK"] = "InibizioneBlocco"
NLI["MENU.SHOW"] = "Svela"
NLI["MENU.UNLINK"] = "Scollega"
NLI["MENU.EDITOR.PRINT"] = "sTampa"
NLI["MENU.GRAPH.TITLES"] = "Titoli"
NLI["REPORT.DATE.2"] = "2) M e s e   gg, aaaa"
NLI["REPORT.DATE.1"] = "1) mm/gg/aa"
NLI["MENU.VIDEO.H:A:"] = "A: Everex VGA: 80x34"
NLI["MENU.VIDEO.M:"] = "M: STB PowerGraph VGA"
NLI["TABLE.PROBLEMS"] = "Problemi"
NLI["ASK.BLANK"] = "VUOTO"
NLI["REPORT.TOTAL FOR"] = "Totale di "
NLI["INFO.MENUCHOICE.ERROR"] = "Error"
NLI["MENU.SCREEN"] = "Video"
NLI["MENU.NO"] = "No"
NLI["MENU.MULTI"] = "Multi"
NLI["TABLE.KEYVIOL"] = "$$nli2$$"
NLI["MENU.PERGROUP"] = "PerGruppo"
NLI["MENU.NEGATIVEONLY"] = "Negativi"
NLI["MENU.VIDEO.E:B:"] = "B: VGA Wizard: 80x45"
NLI["MENU.LOAD"] = "Carica"
NLI["MENU.CONTINUE"] = "Continua"
NLI["MENU.FORMADD"] = "+Scheda"
NLI["INFO.USERNAME"] = "NomeUtente"
NLI["MENU.EDITOR.SHOWCLIPBOARD"] = "MostraClipboard"
NLI["MODE.DATAENTRY"] = "Immetti"
NLI["MENU.GRAPH.AXES"] = "X-Y"
NLI["MENU.REPORT"] = "Rapporto"
NLI["MENU.CROSSTAB.SUM"] = "1) Somma"
NLI["MENU.DBASE"] = "dBASE"
NLI["MENU.HIGHVALUE"] = "Sup"
NLI["MENU.SORTDIRECTION"] = "Ordine"
NLI["ASK.INSERT"] = "Inserisci"
NLI["MENU.GRAPH.CURRENTPRINTER"] = "StampanteCorrente"
NLI["MENU.GRAPH.COPY"] = "Duplica"
NLI["MENU.LOW"] = "Basso"
NLI["MENU.COMMAS"] = "UsaSeparatori"
NLI["MENU.CLOSE"] = "Chiudi"
NLI["MENU.SETUP"] = "Prepara"
NLI["MENU.DBASE.4"] = "3) dBASE IV"
NLI["PROMPT.VALUE:"] = "Valore:"
NLI["MODE.FILE EDITOR"] = "Editor"
NLI["MENU.DATAENTRY"] = "Immetti"
NLI["MENU.123.1.A"] = "1) 1-2-3 Release 1A"
NLI["MODE.REPORT"] = "Rapporto"
NLI["MENU.SUMMARY"] = "Statistico"
NLI["REPORT.PAGE FOOTER"] = "Fondo Pagina"
NLI["ASK.CALC"] = "CALC"
NLI["MENU.GRAPH.4THPRINTER"] = "QuartaStampante"
NLI["MENU.COLUMNSIZE"] = "Larghezza"
NLI["MENU.SAMETABLE"] = "StessaTabella"
NLI["MENU.TODOS"] = "Sistema"
NLI["MENU.MONOCHROME"] = "Monocromatico"
NLI["MENU.GROUPREPEATS"] = "Ripetizioni"
NLI["ASK.SUM"] = "Somma"
NLI["ASK.TODAY"] = "OGGI"
NLI["ASK.EXACTLY"] = "PROPRIO"
NLI["MENU.VIDEO.I:C:"] = "C: Genoa VGA: 132x43"
NLI["MENU.RESTRUCTURE"] = "Ristruttura"
NLI["MENU.ADD"] = "Aggiungi"
NLI["MENU.YES"] = "S"
NLI["MENU.BEFORE"] = "Prima"
NLI["MENU.RETAIN"] = "Mantieni"
NLI["REPORT.REPORT FOOTER"] = "Fondo Rapporto"
NLI["MENU.GRAPH.2NDPRINTER"] = "SecondaStampante"
NLI["MENU.VIDEO.J:C:"] = "C: Orchid VGA: 132x28"
NLI["MENU.VIDEO.K:B:"] = "B: Paradise EGA/VGA: 132x43"
NLI["MENU.TABLES"] = "Tabelle"
NLI["MENU.DIRECTORY"] = "Dir"
NLI["MENU.WORDWRAP"] = "Linee"
NLI["TABLE.DELETED"] = "Tolti"
NLI["ASK.DELETE"] = "TOGLI"
NLI["INFO.WED"] = "Mer"
NLI["MENU.EDITOR.WORDWRAP"] = "A-Capo"
NLI["MODE.RESTRUCTURE"] = "Ristruttura"
NLI["REPORT.MAXIMUM FOR"] = "Massimo di "
NLI["MENU.RESTART"] = "Riavvia"
NLI["MENU.FILLED"] = "Pieno"
NLI["MENU.PAGE"] = "Pagina"
NLI["MENU.GRAPH.PIES"] = "Fette"
NLI["MENU.GRAPH.FILE"] = "File"
NLI["MENU.AVERAGE"] = "Media"
NLI["MENU.VIDEO.F:B:"] = "B: ATI VGA: 132x44"
NLI["MENU.123"] = "1-2-3"
NLI["MENU.EXIT"] = "Esci"
NLI["MENU.LOOKUP"] = "ConsultaTabella"
NLI["MENU.UNLINKED"] = "Scollegata"
NLI["TABLE.STRUCT"] = "Strutt"
NLI["TABLE.ENTRY"] = "Dati"
NLI["MENU.GRAPH.LEGENDSANDLABELS"] = "Legende-Etichette"
NLI["MENU.GRAPH.GRIDS"] = "Griglie"
NLI["MENU.LABELS"] = "Etichette"
NLI["REPORT.DATE.4"] = "4) mm/aa"
NLI["MENU.TILE"] = "Affianca"
NLI["MENU.VIDEO.A:"] = "A: Rilevamento Automatico"
NLI["MENU.PRINTER"] = "Stampante"
NLI["MENU.MASTER"] = "Principale"
NLI["MENU.EDITOR.OPTIONS"] = "Opzione"
NLI["MENU.OOPS!"] = "Opl!"
NLI["MODE.CREATE"] = "Crea"
NLI["MENU.VIDEO.H:C:"] = "C: Everex VGA: 100x43"
NLI["MENU.CROSSTAB.MIN"] = "2) Min"
NLI["MENU.STYLE"] = "Stile"
NLI["TABLE.CHANGED"] = "Variati"
NLI["MENU.FREE-FORM"] = "Formato-Libero"
NLI["MENU.VALUE"] = "Valore"
NLI["MENU.LOCK"] = "Blocco"
NLI["MENU.PRIVATELOOKUP"] = "Privata"
NLI["ASK.LIKE"] = "COMME"
NLI["MENU.EDITOR.CASESENSITIVE"] = "Distinzione M/m"
NLI["MENU.EDITOR.SEARCH"] = "Cerca"
NLI["REPORT.AVERAGE OF"] = "Media di "
NLI["MENU.CREATE"] = "Crea"
NLI["MENU.TABLESIZE"] = "Altezza"
NLI["MENU.TEXT"] = "Testo"
NLI["FORM.FORMULA"] = "Formula"
NLI["MENU.EDITOR.FIND"] = "Trova"
NLI["MENU.EXPORTIMPORT"] = "Porta"
NLI["MENU.VALCHECK"] = "Verifica"
NLI["ASK.MIN"] = "MIN"
NLI["MENU.GRAPH.COLORS"] = "Colori"
NLI["MENU.MAXIMIZE/RESTORE"] = "Massimizza/Ripristina"
NLI["MENU.OK"] = "Conferma"
NLI["MENU.WHO"] = "Utenti"
NLI["MENU.GRAPH.DEVICE"] = "Dispositivo"
NLI["MENU.VIDEO.G:C:"] = "C: Compaq VGS: 132x43"
NLI["MENU.RESET"] = "Ricomincia"
NLI["MENU.MULTIENTRY"] = "Multipli"
NLI["MENU.REPEATPLAY"] = "Itera"
NLI["MENU.TIME"] = "Ora"
NLI["MENU.FIND"] = "Trova"
NLI["MENU.LINESQUEEZE"] = "Righe"
NLI["MENU.DIFFERENTTABLE"] = "AltraTabella"
NLI["MENU.USERNAME"] = "NomeUtente"
NLI["MENU.AUTOREFRESH"] = "AutoRidisegno"
NLI["MENU.PROTECT"] = "Proteggi"
NLI["MENU.DEFINE"] = "Definisci"
NLI["REPORT.TABLE BAND"] = "Zona Tabella"
NLI["ASK.COUNT"] = "Conto"
NLI["INFO.SUN"] = "Dom"
NLI["MENU.DESKTOP"] = "SpazioDiLavoro"
NLI["MENU.VIDEO.G:"] = "G: Compaq Integrated (132 column) VGS"
NLI["MENU.VIDEO.I:A:"] = "A: Genoa VGA: 132x25"
NLI["MENU.GENERAL"] = "Generale"
NLI["MENU.COMMA"] = "ConSeparatori"
NLI["MENU.REQUIRED"] = "Necessario"
NLI["MENU.ERASE"] = "Cancella"
NLI["MENU.VIDEO.J:A:"] = "A: Orchid VGA: 80x60"
NLI["MENU.VIDEO.L:A:"] = "A: Sigma VGA: 132x25"
NLI["MENU.IMPORT"] = "Qui"
NLI["MENU.END-RECORD"] = "TerminaRegistrazione"
NLI["MENU.FILLNOHELP"] = "Automatica"
NLI["MENU.BORDER"] = "Bordo"
NLI["TABLE.INSERTED"] = "Inseriti"
NLI["MENU.EDITOR.PASTE"] = "Incolla"
NLI["MENU.DBASE.3"] = "2) dBASE III"
NLI["MENU.STRUCTURE"] = "Struttura"
NLI["MENU.TABULAR"] = "Tabulare"
NLI["MENU.REPORT.LOOKUP"] = "Esterno"
NLI["MENU.SETUP PREDEFINED"] = "Predefinita"
NLI["TABLE.ANSWER"] = "Risposta"
NLI["MENU.EDITOR.ERASE"] = "Cancella"
NLI["INFO.FIELD TYPE"] = "Tipo Campo"
NLI["MENU.ALWAYSSIGN"] = "Sempre"
NLI["MENU.123.2"] = "2) 1-2-3 Release 2"
NLI["MENU.NET"] = "LAN"
NLI["MENU.PICTURE"] = "Maschera"
NLI["MENU.OTHER"] = "AltroElemento"
NLI["MENU.JUSTIFY"] = "Allinea"
NLI["MENU.SUPPRESS"] = "Sopprimi"
NLI["ASK.FAST"] = "VELOCE"
NLI["ASK.NOT"] = "NON"
NLI["ASK.CHANGETO"] = "VARIA IN"
NLI["MENU.STANDARD"] = "Standard"
NLI["MENU.INTERNATIONALCONVENTION"] = "U.S.A."
NLI["MENU.CROSSTAB.COUNT"] = "4) Conto"
NLI["MENU.TABLE"] = "Tabella"
NLI["MENU.DBASE.2"] = "1) dBASE II"
NLI["INFO.PRODUCT"] = "Prodotto"
NLI["REPORT.GROUP HEADER"] = "Intestazione Gruppo per"
NLI["MENU.SETPRIVATE"] = "DirPrivata"
NLI["MENU.CLEAR"] = "Revoca"
NLI["MENU.EDITOR.LOCATION"] = "Posizione"
NLI["MENU.GRAPH.PRINTERTOSCREEN"] = "Stampa-Video"
NLI["MENU.GRAPH.SCREENTOPRINTER"] = "Video-Stampa"
NLI["MENU.GRAPH.OVERALL"] = "Globale"
NLI["MENU.VIDEO.N:B:"] = "B: Video-7 VGA: 100x60"
NLI["MENU.EDITOR"] = "Editor"
NLI["MENU.CLEARPASSWORDS"] = "AnnullaDiritti"
NLI["FORM.EMBEDDED.START"] = "Tabella intercalata "
NLI["INFO.FRI"] = "Ven"
NLI["MENU.VIDEO.H:"] = "H: Everex Viewpoint VGA/EV-673 VGA"
NLI["MENU.VIDEO.M:A:"] = "A: STB VGA: 132x25"
NLI["MENU.UTILITIES"] = "ProgrammiDiServizio"
NLI["MENU.PFS"] = "PFS"

endproc
writelib "NLI"  NLI039
release  procs   NLI039

proc NLI045()
; Variablerne er gemt med kommandoen Savevars

Dynarray NLI[]
NLI["MENU.GRAPH.PIC"] = "PIC"
NLI["MENU.CENTER"] = "Centreret"
NLI["MENU.LEFT"] = "Venstre"
NLI["MENU.PARENNEGATIVE"] = "Parentes"
NLI["MENU.SIGN-CONVENTION"] = "Fortegn"
NLI["MENU.VIDEO.E:A:"] = "A: VGA Wizard: 80x34"
NLI["MENU.FULLLOCK"] = "Fuld-ls"
NLI["MODE.EDIT"] = "Redigr"
NLI["MENU.CALCULATED"] = "Beregnet"
NLI["MENU.EDITOR.EDIT"] = "Redigr"
NLI["MENU.SUM"] = "Sum"
NLI["MENU.SCRIPTS"] = "Makro"
NLI["MENU.RANGE"] = "Interval"
NLI["MENU.SETUP CUSTOM"] = "PPAS"
NLI["PROMPT.RESET STRING:"] = "Termineringsstreng:"
NLI["ASK.AVERAGE"] = "AVERAGE"
NLI["MENU.VIDEO"] = "vIdeo"
NLI["MENU.VIDEO.H:B:"] = "B: Everex VGA: 80x60"
NLI["MENU.SAME"] = "Samme"
NLI["MENU.EDIT"] = "Redigr"
NLI["REPORT.PAGE HEADER"] = "Side Toptekst"
NLI["MENU.GRAPH.PRINTER"] = "Printer"
NLI["REPORT.MINIMUM FOR"] = "Minimum for "
NLI["MENU.VIDEO.G:D:"] = "D: Compaq VGS: 132x50"
NLI["MENU.VIDEO.N:"] = "N: Video-7 VRAM VGA"
NLI["MENU.DELETE"] = "Slet"
NLI["MENU.DO_IT!"] = "Udfr"
NLI["MENU.AREA"] = "Omrde"
NLI["MENU.HIDE"] = "Skjult"
NLI["ASK.OR"] = "OR"
NLI["MENU.GRAPH.DURATION"] = "Sekunder"
NLI["MENU.GRAPH.EPS"] = "EPS"
NLI["MENU.REMOVEBLANKS"] = "Tomme"
NLI["REPORT.CURRENT DATE"] = "Aktuel dato"
NLI["MENU.VIDEO.H:D:"] = "D: Everex VGA: 100x75"
NLI["MENU.FIELD"] = "Felt"
NLI["MENU.JUSTFAMILY"] = "Objektgruppe"
NLI["MENU.DIRLOCK"] = "Biblioteksls"
NLI["MENU.INSERT"] = "Indst"
NLI["REPORT.REPORT HEADER"] = "Rapport Toptekst"
NLI["PROMPT.EXPRESSION:"] = "Udtryk:"
NLI["MODE.PASSWORD"] = "Kodeord"
NLI["MENU.VIDEO.G:B:"] = "B: Compaq VGS: 132x28"
NLI["MENU.SETPRINTER"] = "Printervalg"
NLI["MENU.ENTRY"] = "Indtastning"
NLI["MENU.REFLEX.1.0"] = "1) Reflex version 1.0"
NLI["MENU.REFLEX.2.0"] = "3) Reflex version 2.0"
NLI["INFO.NAME"] = "Navn"
NLI["REPORT.CURRENT RECORD NUMBER"] = "Aktuelt nummer for post"
NLI["MENU.EMPTY"] = "Tm"
NLI["MENU.TABLELOOKUP"] = "Tabelopslag"
NLI["MENU.REFORMAT"] = "Reformatr"
NLI["TABLE.LIST"] = "Liste"
NLI["INFO.TUE"] = "Tir"
NLI["MENU.GRAPH.KEYSTROKE"] = "Tastetryk"
NLI["MENU.VIDEO.H:F:"] = "F: Everex VGA: 132x44"
NLI["MENU.QUATTRO.1.X"] = "1) Quattro version 1.X"
NLI["MENU.PASSWORD"] = "Kodeord"
NLI["MENU.SINGLE-LINE"] = "Enkeltlinie"
NLI["MENU.LINK"] = "Lnkning"
NLI["MENU.REGROUP"] = "retGruppe"
NLI["MENU.SETTING"] = "Opstninger"
NLI["PROMPT.SCRIPT:"] = "Makro:"
NLI["ASK.EVERY"] = "EVERY"
NLI["MODE.INDEX"] = "Indeks"
NLI["INFO.FIELD NAME"] = "Feltnavn"
NLI["MENU.GRAPH.SERIES"] = "Serier"
NLI["REPORT.DATE.10"] = "10) dd/mm/"
NLI["MENU.REDRAW"] = "Gentegn"
NLI["MENU.VIDEO.F:A:"] = "A: ATI VGA: 132x25"
NLI["MENU.VIDEO.G:E:"] = "E: Compaq VGS: 132x60"
NLI["MENU.DEFAULT"] = "Standard"
NLI["MENU.WIDTH"] = "Bredde"
NLI["TABLE.KEEPENTRY"] = "GemIndtast"
NLI["REPORT.COUNT OF"] = "Optlling for "
NLI["MENU.INTERFACE"] = "Brugerflade"
NLI["MENU.IMAGE"] = "Billede"
NLI["MENU.TABLEBAND"] = "Bnd"
NLI["MENU.EDITOR.WRITEBLOCK"] = "Blok"
NLI["MENU.VIDEO.K:A:"] = "A: Paradise EGA/VGA: 132x25"
NLI["MENU.INDEX"] = "Indeks"
NLI["MENU.DD-MON-YY"] = "DD-mn-"
NLI["MENU.RECORD"] = "Post"
NLI["ASK.NO"] = "NO"
NLI["MENU.FIELDSQUEZZE"] = "Felter"
NLI["MENU.RIGHT"] = "Hjre"
NLI["MENU.U.S.CONVENTION"] = "International"
NLI["MENU.JUSTCURRENTFIELD"] = "Dette"
NLI["MENU.AUTO"] = "Auto"
NLI["MENU.#RECORD"] = "Post#"
NLI["MENU.REMOVE"] = "Fjerne"
NLI["MENU.TABLEOFGROUPS"] = "Tabel-gruppe"
NLI["MENU.GRAPH.PRINTERLAYOUT"] = "Layout"
NLI["MODE.GRAPH"] = "Graf"
NLI["MENU.VIEW"] = "Vis"
NLI["MENU.OUTPUT"] = "udSkriv"
NLI["MENU.LINKED"] = "Lnket"
NLI["MENU.RESIZE"] = "RetBredde"
NLI["ASK.SET"] = "SET"
NLI["MENU.EDITOR.REPLACE"] = "Erstat"
NLI["MENU.EDITOR.NEXT"] = "Nste"
NLI["MODE.SORT"] = "Sortr"
NLI["MENU.VIDEO.N:C:"] = "C: Video-7 VGA: 132x43"
NLI["MENU.REGULAR"] = "Almindeligt"
NLI["MENU.ENDOFPAGE"] = "Side-skift"
NLI["MENU.SYMPHONY"] = "Symphony"
NLI["MENU.SYMPHONY.1.1"] = "2) Symphony version 1.1"
NLI["MENU.FILES"] = "Filer"
NLI["MENU.OVERALL"] = "Globalt"
NLI["MENU.REPLACE"] = "Erstat"
NLI["MENU.EDITOR.INSERTFILE"] = "IndstFil"
NLI["MENU.NEXT"] = "Nste"
NLI["MENU.LINEFEED"] = "Linieskift"
NLI["MENU.ORDERTABLE"] = "Sortering"
NLI["MENU.GRAPH"] = "Graf"
NLI["MENU.QUATTRO"] = "Quattro"
NLI["MENU.CHANGES"] = "Opdatering"
NLI["MENU.LOWVALUE"] = "Laveste"
NLI["INFO.DATE"] = "Dato"
NLI["INFO.FILENAME"] = "Filnavn"
NLI["MENU.COMPATIBLE"] = "Kompatibel"
NLI["MENU.HIGH"] = "Hj"
NLI["MENU.CASCADE"] = "Stak"
NLI["MENU.VIDEO.H:E:"] = "E: Everex VGA: 132x25"
NLI["MENU.SORT"] = "Sortr"
NLI["MENU.FORMS"] = "Formular"
NLI["MENU.RENAME"] = "Omdb"
NLI["MENU.QUERYSPEED"] = "2.indeks"
NLI["MENU.DO-IT!"] = "Udfr"
NLI["MENU.SHOWHIGHLIGTH"] = "Omrder"
NLI["ASK.AS"] = "AS"
NLI["MENU.EDITOR.GOTO"] = "Hop"
NLI["MENU.EDITOR.XCUT"] = "kLip"
NLI["MENU.VIDEO.K:"] = "K: Paradise EGA 480/VGA 1024"
NLI["MENU.FORMAT"] = "Format"
NLI["MENU.SCRIPT"] = "Makroer"
NLI["MENU.ASCII"] = "ASCII"
NLI["MENU.DOUBLE-LINE"] = "Dobbeltlinie"
NLI["MENU.DATE"] = "Dato"
NLI["MENU.HEADINGS"] = "Overskrifter"
NLI["REPORT.DATE.9"] = "9) dd.mm."
NLI["MENU.VIDEO.D:"] = "D: EGA/VGA: 80x43/50"
NLI["MENU.OVERRIDE"] = "Brugervalgt"
NLI["MENU.CALCEDIT"] = "Beregning"
NLI["MENU.ADJUST"] = "Tilpasning"
NLI["MENU.RELINK"] = "RetLnkning"
NLI["MENU.GROUP"] = "Gruppe"
NLI["INFO.LOCKTYPE"] = "Lsetype"
NLI["MENU.VIDEO.F:"] = "F: ATI VGA Wonder"
NLI["MENU.QUATTROPRO"] = "2) Quattro Pro"
NLI["FORM.EMBEDDED.END"] = " med formularen "
NLI["MENU.EDITOR.CHANGETOEND"] = "Resten"
NLI["MENU.MODIFY"] = "Tilpas"
NLI["MENU.INVENTORY"] = "Filoversigt"
NLI["MENU.QUERYSAVE"] = "Foresprgsel"
NLI["TABLE.FAMILY"] = "Objgrup"
NLI["MENU.SIZE/MOVE"] = "Skalr/flyt"
NLI["MENU.VIDEO.E:C:"] = "C: VGA Wizard: 132x25"
NLI["MENU.CROSSTAB"] = "Krydstabulr"
NLI["MENU.REFLEX"] = "Reflex"
NLI["MENU.REFLEX.1.1"] = "2) Reflex version 1.1"
NLI["MODE.COEDIT"] = "Samred"
NLI["INFO.SAT"] = "Lr"
NLI["INFO.MON"] = "Man"
NLI["REPORT.FORM BAND"] = "Formular Bnd"
NLI["MENU.COUNT"] = "Optl"
NLI["REPORT.GROUP FOOTER"] = "Gruppe Bundtekst for"
NLI["MENU.WINDOW"] = "Vindue"
NLI["MENU.SURFACEQUERIES"] = "Arrangr"
NLI["MENU.OPEN"] = "Hent"
NLI["MENU.ABOUT"] = "Om"
NLI["MENU.MM/DD/YY"] = "MM/DD/"
NLI["MENU.DD.MM.YY"] = "DD.MM."
NLI["MENU.YY.MM.DD"] = ".MM.DD"
NLI["MENU.PER-GROUP"] = "gRuppe-vis"
NLI["MENU.MARGIN"] = "Margen"
NLI["MENU.EDITOR.OPEN"] = "Hent"
NLI["REPORT.DATE.7"] = "7) dd-Mn-"
NLI["MENU.COEDIT"] = "sAmredigr"
NLI["MENU.INFO"] = "Info"
NLI["MENU.MORE"] = "Mere"
NLI["MENU.AFTER"] = "Efter"
NLI["MENU.LENGTH"] = "Lngde"
NLI["MENU.VIDEO.B:"] = "B: Monokrom"
NLI["MENU.VIEWGRAPH"] = "VisGraf"
NLI["MENU.WRITELOCK"] = "Skrivels"
NLI["MENU.UNDO"] = "Fortryd"
NLI["MENU.COLOR"] = "Farve"
NLI["ASK.MAX"] = "MAX"
NLI["MENU.VIDEO.J:D:"] = "D: Orchid VGA: 132x44"
NLI["MENU.VIDEO.M:B:"] = "B: STB VGA: 132x44"
NLI["MENU.RANGEOUTPUT"] = "Intervaller"
NLI["MENU.EXPORT"] = "Eksport"
NLI["MENU.PLACE"] = "Placr"
NLI["MENU.EDITOR.COPY"] = "Kopir"
NLI["MENU.FILEFORMAT"] = "Filformat"
NLI["MENU.GRAPH.1STPRINTER"] = "1. printer"
NLI["MENU.GRAPH.TYPE"] = "Type"
NLI["REPORT.PER GROUP"] = " pr. gruppe"
NLI["REPORT.DATE.12"] = "12) .mm.dd"
NLI["REPORT.DATE.11"] = "11) -mm-dd"
NLI["MENU.VIDEO.N:A:"] = "A: Video-7 VGA: 80x60"
NLI["MENU.KEEPSET"] = "Behold"
NLI["MENU.TOOLS"] = "Ekstra"
NLI["MENU.VISICALC"] = "VisiCalc"
NLI["MENU.FIELDNAMES"] = "Navne"
NLI["ASK.FIND"] = "FIND"
NLI["ASK.ONLY"] = "ONLY"
NLI["MENU.INTERNATIONAL"] = "Tegnkonvention"
NLI["MENU.NOCOMMAS"] = "Fra"
NLI["MENU.DIGITS"] = "Cifre"
NLI["MENU.VIDEO.E:"] = "E: Ahead Systems VGA Wizard"
NLI["MENU.SCIENTIFIC"] = "Eksponentielt"
NLI["MENU.COPY"] = "Kopir"
NLI["MENU.GROUPSOFTABLES"] = "Gruppe-tabel"
NLI["MENU.PRINTERPORT"] = "Printerport"
NLI["MENU.FIXED"] = "Fast"
NLI["MENU.RECORDS"] = "Poster"
NLI["INFO.SAVEVARS"] = "Savevars"
NLI["MENU.TRIMMING"] = "Tilrettet"
NLI["MENU.CROSSTAB.MAX"] = "3) Max"
NLI["MENU.FILE"] = "Fil"
NLI["MENU.SYMPHONY.1.0"] = "1) Symphony version 1.0"
NLI["MENU.APPENDDELIMITED"] = "Indfj"
NLI["MODE.FORM"] = "Formular"
NLI["MENU.NUMBERRECORDS"] = "Antal"
NLI["PROMPT.SETUP STRING:"] = "Opstningsstreng:"
NLI["MENU.NO-TRIMMING"] = "Ikke-tilrettet"
NLI["MENU.FORMFEED"] = "Sideskift"
NLI["MENU.MOVE"] = "fLyt"
NLI["MENU.PLAY"] = "afsPil"
NLI["MENU.DISPLAYONLY"] = "Vist"
NLI["MENU.EDITOR.COPYTOFILE"] = "TilFil"
NLI["REPORT.DATE.5"] = "5) dd-Mn-"
NLI["MENU.VIDEO.J:B:"] = "B: Orchid VGA: 132x25"
NLI["MENU.VIDEO.L:B:"] = "B: Sigma VGA: 132x44"
NLI["MENU.FORM"] = "Formularer"
NLI["MENU.EDITOR.AUTOINDENT"] = "Indrykning"
NLI["MENU.EDITOR.FILE"] = "Fil"
NLI["MENU.GRAPH.GRAPH.WAIT"] = "Vent"
NLI["REPORT.DATE.8"] = "8) mm/dd/"
NLI["MENU.VIDEO.I:B:"] = "B: Genoa VGA: 132x28"
NLI["MENU.DESIGN"] = "Design"
NLI["MENU.CHANGE"] = "Ret"
NLI["MENU.ZOOM"] = "Zoom"
NLI["MENU.CANCEL"] = "Annullr"
NLI["MENU.MULTIADD"] = "Multi+"
NLI["MENU.WAIT"] = "Vent"
NLI["MENU.EDITOR.NEW"] = "Ny"
NLI["MENU.GRAPH.MODIFY"] = "Tilpas"
NLI["MENU.SAVE"] = "Gem"
NLI["MENU.WRITE-PROTECT"] = "Skrivebeskyt"
NLI["TABLE.CROSSTAB"] = "Krydstab"
NLI["MENU.VIDEO.E:D:"] = "D: VGA Wizard: 132x44"
NLI["MENU.WORKSHOP"] = "Workshop"
NLI["MENU.PICKFORM"] = "formularValg"
NLI["MENU.FAMILY"] = "Objekter"
NLI["MENU.HELPANDFILL"] = "Udfyldningshjlp"
NLI["MENU.ALLCORRESPONDINGFIELDS"] = "Tilsvarende"
NLI["MENU.PAGELAYOUT"] = "Sidelayout"
NLI["INFO.THU"] = "Tor"
NLI["MENU.GRAPH.MARKERSANDFILLS"] = "Mnstre"
NLI["REPORT.CURRENT PAGE NUMBER"] = "Aktuelt sidenummer"
NLI["REPORT.DATE.6"] = "6) Mn "
NLI["MENU.VIDEO.G:A:"] = "A: Compaq VGS: 132x25"
NLI["MENU.VIDEO.I:"] = "I: Genoa Systems Super VGA"
NLI["MENU.CUSTOM"] = "PPAS"
NLI["MENU.SUBTRACT"] = "-Fratrk"
NLI["MENU.EDITOR.SAVE"] = "Gem"
NLI["REPORT.DATE.3"] = "3) mm/dd"
NLI["MODE.MAIN"] = "Menu"
NLI["MENU.VIDEO.J:"] = "J: Orchid ProDesigner VGA"
NLI["MENU.VIDEO.L:"] = "L: Sigma VGA Legend/HP16"
NLI["MENU.NEW"] = "Ny"
NLI["MENU.TABLEINDEX"] = "Tabelindeks"
NLI["PROMPT.TABLE:"] = "Tabel:"
NLI["MENU.CONVERT"] = "Konvertr"
NLI["MENU.BORROW"] = "Struktur"
NLI["MENU.GRAPH.3RDPRINTER"] = "3. printer"
NLI["REPORT.WRAP:"] = " delt:"
NLI["MENU.VIDEO.C:"] = "C: EGA/VGA: 80x25"
NLI["MENU.ASK"] = "Sg"
NLI["MENU.DELIMITED"] = "Kommasepareret"
NLI["MENU.PREVENTLOCK"] = "Rettigheder"
NLI["MENU.SHOW"] = "Vise"
NLI["MENU.UNLINK"] = "SletLnkning"
NLI["MENU.EDITOR.PRINT"] = "Udskrift"
NLI["MENU.GRAPH.TITLES"] = "Titler"
NLI["REPORT.DATE.2"] = "2) M  n e d dd, "
NLI["REPORT.DATE.1"] = "1) mm/dd/"
NLI["MENU.VIDEO.H:A:"] = "A: Everex VGA: 80x34"
NLI["MENU.VIDEO.M:"] = "M: STB PowerGraph VGA"
NLI["TABLE.PROBLEMS"] = "Problem"
NLI["ASK.BLANK"] = "BLANK"
NLI["REPORT.TOTAL FOR"] = "Total for "
NLI["INFO.MENUCHOICE.ERROR"] = "Error"
NLI["MENU.SCREEN"] = "Skrm"
NLI["MENU.NO"] = "Nej"
NLI["MENU.MULTI"] = "Multi"
NLI["TABLE.KEYVIOL"] = "$$nli2$$"
NLI["MENU.PERGROUP"] = "Gruppevis"
NLI["MENU.NEGATIVEONLY"] = "Negative"
NLI["MENU.VIDEO.E:B:"] = "B: VGA Wizard: 80x45"
NLI["MENU.LOAD"] = "Indls"
NLI["MENU.CONTINUE"] = "Fortst"
NLI["MENU.FORMADD"] = "Formular+"
NLI["INFO.USERNAME"] = "Brugernavn"
NLI["MENU.EDITOR.SHOWCLIPBOARD"] = "klippeBord"
NLI["MODE.DATAENTRY"] = "DataInd"
NLI["MENU.GRAPH.AXES"] = "Akser"
NLI["MENU.REPORT"] = "Rapport"
NLI["MENU.CROSSTAB.SUM"] = "1) Sum"
NLI["MENU.DBASE"] = "dBASE"
NLI["MENU.HIGHVALUE"] = "Hjeste"
NLI["MENU.SORTDIRECTION"] = "Rkkeflge"
NLI["ASK.INSERT"] = "INSERT"
NLI["MENU.GRAPH.CURRENTPRINTER"] = "AktuelPrinter"
NLI["MENU.GRAPH.COPY"] = "Kopir"
NLI["MENU.LOW"] = "Lav"
NLI["MENU.COMMAS"] = "Adskillelsestegn"
NLI["MENU.CLOSE"] = "Luk"
NLI["MENU.SETUP"] = "Opstning"
NLI["MENU.DBASE.4"] = "3) dBASE IV"
NLI["PROMPT.VALUE:"] = "Vrdi:"
NLI["MODE.FILE EDITOR"] = "Fil-editor"
NLI["MENU.DATAENTRY"] = "DataInd"
NLI["MENU.123.1.A"] = "1) 1-2-3 version 1A"
NLI["MODE.REPORT"] = "Rapport"
NLI["MENU.SUMMARY"] = "Opsummeret"
NLI["REPORT.PAGE FOOTER"] = "Side Bundtekst"
NLI["ASK.CALC"] = "CALC"
NLI["MENU.GRAPH.4THPRINTER"] = "4. printer"
NLI["MENU.COLUMNSIZE"] = "Kolonne"
NLI["MENU.SAMETABLE"] = "SammeTabel"
NLI["MENU.TODOS"] = "DOS"
NLI["MENU.MONOCHROME"] = "Monokrom"
NLI["MENU.GROUPREPEATS"] = "Gengangere"
NLI["ASK.SUM"] = "SUM"
NLI["ASK.TODAY"] = "TODAY"
NLI["ASK.EXACTLY"] = "EXACTLY"
NLI["MENU.VIDEO.I:C:"] = "C: Genoa VGA: 132x43"
NLI["MENU.RESTRUCTURE"] = "Omstrukturr"
NLI["MENU.ADD"] = "+Tilfj"
NLI["MENU.YES"] = "Ja"
NLI["MENU.BEFORE"] = "Fr"
NLI["MENU.RETAIN"] = "Medtag"
NLI["REPORT.REPORT FOOTER"] = "Rapport Bundtekst"
NLI["MENU.GRAPH.2NDPRINTER"] = "2. printer"
NLI["MENU.VIDEO.J:C:"] = "C: Orchid VGA: 132x28"
NLI["MENU.VIDEO.K:B:"] = "B: Paradise EGA/VGA: 132x43"
NLI["MENU.TABLES"] = "Tabeller"
NLI["MENU.DIRECTORY"] = "Bibliotek"
NLI["MENU.WORDWRAP"] = "Deling"
NLI["TABLE.DELETED"] = "Slettet"
NLI["ASK.DELETE"] = "DELETE"
NLI["INFO.WED"] = "Ons"
NLI["MENU.EDITOR.WORDWRAP"] = "Deling"
NLI["MODE.RESTRUCTURE"] = "Struktur"
NLI["REPORT.MAXIMUM FOR"] = "Maksimum for "
NLI["MENU.RESTART"] = "Genstart"
NLI["MENU.FILLED"] = "Udfyldt"
NLI["MENU.PAGE"] = "Side"
NLI["MENU.GRAPH.PIES"] = "Cirkel"
NLI["MENU.GRAPH.FILE"] = "Fil"
NLI["MENU.AVERAGE"] = "Gennemsnit"
NLI["MENU.VIDEO.F:B:"] = "B: ATI VGA: 132x44"
NLI["MENU.123"] = "1-2-3"
NLI["MENU.EXIT"] = "Afslut"
NLI["MENU.LOOKUP"] = "Opslag"
NLI["MENU.UNLINKED"] = "IkkeLnket"
NLI["TABLE.STRUCT"] = "Struktur"
NLI["TABLE.ENTRY"] = "Ind"
NLI["MENU.GRAPH.LEGENDSANDLABELS"] = "Ledetekster"
NLI["MENU.GRAPH.GRIDS"] = "Gitre"
NLI["MENU.LABELS"] = "Adressemrkater"
NLI["REPORT.DATE.4"] = "4) mm/"
NLI["MENU.TILE"] = "Fordl"
NLI["MENU.VIDEO.A:"] = "A: Automatisk"
NLI["MENU.PRINTER"] = "Printer"
NLI["MENU.MASTER"] = "Master"
NLI["MENU.EDITOR.OPTIONS"] = "Muligheder"
NLI["MENU.OOPS!"] = "Hovsa!"
NLI["MODE.CREATE"] = "Opret"
NLI["MENU.VIDEO.H:C:"] = "C: Everex VGA: 100x43"
NLI["MENU.CROSSTAB.MIN"] = "2) Min"
NLI["MENU.STYLE"] = "Desktop"
NLI["TABLE.CHANGED"] = "Rettet"
NLI["MENU.FREE-FORM"] = "Fri-rapport"
NLI["MENU.VALUE"] = "Vrdi"
NLI["MENU.LOCK"] = "Ls"
NLI["MENU.PRIVATELOOKUP"] = "Auto-udfyld"
NLI["ASK.LIKE"] = "LIKE"
NLI["MENU.EDITOR.CASESENSITIVE"] = "Bogstaver"
NLI["MENU.EDITOR.SEARCH"] = "fInd"
NLI["REPORT.AVERAGE OF"] = "Gennemsnit for "
NLI["MENU.CREATE"] = "Opret"
NLI["MENU.TABLESIZE"] = "Hjde"
NLI["MENU.TEXT"] = "Tekst"
NLI["FORM.FORMULA"] = "Formel"
NLI["MENU.EDITOR.FIND"] = "Sgning"
NLI["MENU.EXPORTIMPORT"] = "Eksport/import"
NLI["MENU.VALCHECK"] = "Validering"
NLI["ASK.MIN"] = "MIN"
NLI["MENU.GRAPH.COLORS"] = "Farver"
NLI["MENU.MAXIMIZE/RESTORE"] = "Maksimr/genskab"
NLI["MENU.OK"] = "OK"
NLI["MENU.WHO"] = "Brugere"
NLI["MENU.GRAPH.DEVICE"] = "Enhed"
NLI["MENU.VIDEO.G:C:"] = "C: Compaq VGS: 132x43"
NLI["MENU.RESET"] = "Nulstil"
NLI["MENU.MULTIENTRY"] = "MultiInd"
NLI["MENU.REPEATPLAY"] = "Gentag"
NLI["MENU.TIME"] = "Tid"
NLI["MENU.FIND"] = "Sgning"
NLI["MENU.LINESQUEEZE"] = "Linier"
NLI["MENU.DIFFERENTTABLE"] = "AndenTabel"
NLI["MENU.USERNAME"] = "Brugernavn"
NLI["MENU.AUTOREFRESH"] = "Skrmopdatering"
NLI["MENU.PROTECT"] = "Koder"
NLI["MENU.DEFINE"] = "Definr"
NLI["REPORT.TABLE BAND"] = "Tabel Bnd"
NLI["ASK.COUNT"] = "COUNT"
NLI["INFO.SUN"] = "Sn"
NLI["MENU.DESKTOP"] = "Arbejdsomrde"
NLI["MENU.VIDEO.G:"] = "G: Compaq Integrated (132 kolonner) VGS"
NLI["MENU.VIDEO.I:A:"] = "A: Genoa VGA: 132x25"
NLI["MENU.GENERAL"] = "Generelt"
NLI["MENU.COMMA"] = "Komma"
NLI["MENU.REQUIRED"] = "Obligatorisk"
NLI["MENU.ERASE"] = "Fjern"
NLI["MENU.VIDEO.J:A:"] = "A: Orchid VGA: 80x60"
NLI["MENU.VIDEO.L:A:"] = "A: Sigma VGA: 132x25"
NLI["MENU.IMPORT"] = "Import"
NLI["MENU.END-RECORD"] = "SlutOptag"
NLI["MENU.FILLNOHELP"] = "Auto-udfyldt"
NLI["MENU.BORDER"] = "Ramme"
NLI["TABLE.INSERTED"] = "Indsat"
NLI["MENU.EDITOR.PASTE"] = "Indstte"
NLI["MENU.DBASE.3"] = "2) dBASE III"
NLI["MENU.STRUCTURE"] = "Strukturer"
NLI["MENU.TABULAR"] = "Tabel-rapport"
NLI["MENU.REPORT.LOOKUP"] = "Opslag"
NLI["MENU.SETUP PREDEFINED"] = "Defineret"
NLI["TABLE.ANSWER"] = "Svar"
NLI["MENU.EDITOR.ERASE"] = "Fjern"
NLI["INFO.FIELD TYPE"] = "Felttype"
NLI["MENU.ALWAYSSIGN"] = "Altid"
NLI["MENU.123.2"] = "2) 1-2-3 version 2"
NLI["MENU.NET"] = "Net"
NLI["MENU.PICTURE"] = "Billedmaske"
NLI["MENU.OTHER"] = "Andet"
NLI["MENU.JUSTIFY"] = "Justr"
NLI["MENU.SUPPRESS"] = "Udelad"
NLI["ASK.FAST"] = "FAST"
NLI["ASK.NOT"] = "NOT"
NLI["ASK.CHANGETO"] = "CHANGETO"
NLI["MENU.STANDARD"] = "AutoValgt"
NLI["MENU.INTERNATIONALCONVENTION"] = "Amerikansk"
NLI["MENU.CROSSTAB.COUNT"] = "4) Optl"
NLI["MENU.TABLE"] = "Tabel"
NLI["MENU.DBASE.2"] = "1) dBASE II"
NLI["INFO.PRODUCT"] = "Produkt"
NLI["REPORT.GROUP HEADER"] = "Gruppe Toptekst for"
NLI["MENU.SETPRIVATE"] = "Privat"
NLI["MENU.CLEAR"] = "Ophv"
NLI["MENU.EDITOR.LOCATION"] = "Position"
NLI["MENU.GRAPH.PRINTERTOSCREEN"] = "Printer-skrm"
NLI["MENU.GRAPH.SCREENTOPRINTER"] = "Skrm-printer"
NLI["MENU.GRAPH.OVERALL"] = "Globalt"
NLI["MENU.VIDEO.N:B:"] = "B: Video-7 VGA: 100x60"
NLI["MENU.EDITOR"] = "Editor"
NLI["MENU.CLEARPASSWORDS"] = "FjernKodeord"
NLI["FORM.EMBEDDED.START"] = "Den indsatte tabel "
NLI["INFO.FRI"] = "Fre"
NLI["MENU.VIDEO.H:"] = "H: Everex Viewpoint VGA/EV-673 VGA"
NLI["MENU.VIDEO.M:A:"] = "A: STB VGA: 132x25"
NLI["MENU.UTILITIES"] = "Programmer"
NLI["MENU.PFS"] = "PFS"

endproc
writelib "NLI"  NLI045
release  procs   NLI045

proc NLI031()
; variabelen opgeslagen met opdracht Varopslg

Dynarray NLI[]
NLI["MENU.GRAPH.PIC"] = "PIC"
NLI["MENU.CENTER"] = "Gecentreerd"
NLI["MENU.LEFT"] = "Links"
NLI["MENU.PARENNEGATIVE"] = "Haakjes"
NLI["MENU.SIGN-CONVENTION"] = "PositiefNegatief"
NLI["MENU.VIDEO.E:A:"] = "A: VGA Wizard: 80x34"
NLI["MENU.FULLLOCK"] = "Volledig"
NLI["MODE.EDIT"] = "Bewerken"
NLI["MENU.CALCULATED"] = "Berekend"
NLI["MENU.EDITOR.EDIT"] = "Bewerk"
NLI["MENU.SUM"] = "Som"
NLI["MENU.SCRIPTS"] = "Scripts"
NLI["MENU.RANGE"] = "Bereik"
NLI["MENU.SETUP CUSTOM"] = "OpMaat"
NLI["PROMPT.RESET STRING:"] = "Herstelreeks:"
NLI["ASK.AVERAGE"] = "GEMIDDELDE"
NLI["MENU.VIDEO"] = "GrafischeWeergave"
NLI["MENU.VIDEO.H:B:"] = "B: Everex VGA: 80x60"
NLI["MENU.SAME"] = "Zelfde"
NLI["MENU.EDIT"] = "Alleen"
NLI["REPORT.PAGE HEADER"] = "Paginatitel"
NLI["MENU.GRAPH.PRINTER"] = "Printer"
NLI["REPORT.MINIMUM FOR"] = "Minimum voor "
NLI["MENU.VIDEO.G:D:"] = "D: Compaq VGS: 132x50"
NLI["MENU.VIDEO.N:"] = "N: Video-7 VRAM VGA"
NLI["MENU.DELETE"] = "Verwijder"
NLI["MENU.DO_IT!"] = "DOEN!"
NLI["MENU.AREA"] = "Gebied"
NLI["MENU.HIDE"] = "Verbergen"
NLI["ASK.OR"] = "OF"
NLI["MENU.GRAPH.DURATION"] = "Periode"
NLI["MENU.GRAPH.EPS"] = "EPS"
NLI["MENU.REMOVEBLANKS"] = "Aansluiten"
NLI["REPORT.CURRENT DATE"] = "Huidige datum"
NLI["MENU.VIDEO.H:D:"] = "D: Everex VGA: 100x75"
NLI["MENU.FIELD"] = "Veld"
NLI["MENU.JUSTFAMILY"] = "alleenVerwant"
NLI["MENU.DIRLOCK"] = "DirVergendeling"
NLI["MENU.INSERT"] = "Invoegen"
NLI["REPORT.REPORT HEADER"] = "Rapporttitel"
NLI["PROMPT.EXPRESSION:"] = "Formule:"
NLI["MODE.PASSWORD"] = "Wachtwoord"
NLI["MENU.VIDEO.G:B:"] = "B: Compaq VGS: 132x28"
NLI["MENU.SETPRINTER"] = "Printerinstelling"
NLI["MENU.ENTRY"] = "InvoerTabel"
NLI["MENU.REFLEX.1.0"] = "1) Reflex Release 1.0"
NLI["MENU.REFLEX.2.0"] = "3) Reflex Release 2.0"
NLI["INFO.NAME"] = "Naam"
NLI["REPORT.CURRENT RECORD NUMBER"] = "Huidig recordnummer"
NLI["MENU.EMPTY"] = "Legen"
NLI["MENU.TABLELOOKUP"] = "Opzoeken"
NLI["MENU.REFORMAT"] = "Opmaken"
NLI["TABLE.LIST"] = "Lijst"
NLI["INFO.TUE"] = "din"
NLI["MENU.GRAPH.KEYSTROKE"] = "Interactie"
NLI["MENU.VIDEO.H:F:"] = "F: Everex VGA: 132x44"
NLI["MENU.QUATTRO.1.X"] = "1) Quattro Release 1.X"
NLI["MENU.PASSWORD"] = "Wachtwoord"
NLI["MENU.SINGLE-LINE"] = "Enkel"
NLI["MENU.LINK"] = "Koppelen"
NLI["MENU.REGROUP"] = "Hergroeperen"
NLI["MENU.SETTING"] = "Instelling"
NLI["PROMPT.SCRIPT:"] = "Script:"
NLI["ASK.EVERY"] = "ELKE"
NLI["MODE.INDEX"] = "Index"
NLI["INFO.FIELD NAME"] = "Veldnaam"
NLI["MENU.GRAPH.SERIES"] = "Series"
NLI["REPORT.DATE.10"] = "10) dd/mm/jj"
NLI["MENU.REDRAW"] = "Hertekenen"
NLI["MENU.VIDEO.F:A:"] = "A: ATI VGA: 132x25"
NLI["MENU.VIDEO.G:E:"] = "E: Compaq VGS: 132x60"
NLI["MENU.DEFAULT"] = "sTandaard"
NLI["MENU.WIDTH"] = "Breedte"
NLI["TABLE.KEEPENTRY"] = "Ontkoppel"
NLI["REPORT.COUNT OF"] = "Telling van "
NLI["MENU.INTERFACE"] = "AndereInterface"
NLI["MENU.IMAGE"] = "Beeld"
NLI["MENU.TABLEBAND"] = "Tabelzone"
NLI["MENU.EDITOR.WRITEBLOCK"] = "BlokOpslaan"
NLI["MENU.VIDEO.K:A:"] = "A: Paradise EGA/VGA: 132x25"
NLI["MENU.INDEX"] = "Index"
NLI["MENU.DD-MON-YY"] = "2) DD-Mnd-JJ"
NLI["MENU.RECORD"] = "Record"
NLI["ASK.NO"] = "GEEN"
NLI["MENU.FIELDSQUEZZE"] = "SpatiesOnderdrukken"
NLI["MENU.RIGHT"] = "Rechts"
NLI["MENU.U.S.CONVENTION"] = "Europa"
NLI["MENU.JUSTCURRENTFIELD"] = "alleenHuidige"
NLI["MENU.AUTO"] = "Auto"
NLI["MENU.#RECORD"] = "Recordnummer"
NLI["MENU.REMOVE"] = "Weghalen"
NLI["MENU.TABLEOFGROUPS"] = "TabelVanGroepen"
NLI["MENU.GRAPH.PRINTERLAYOUT"] = "Printerlayout"
NLI["MODE.GRAPH"] = "Grafiek"
NLI["MENU.VIEW"] = "Toon"
NLI["MENU.OUTPUT"] = "Uitvoer"
NLI["MENU.LINKED"] = "Gekoppeld"
NLI["MENU.RESIZE"] = "Formaat"
NLI["ASK.SET"] = "SET"
NLI["MENU.EDITOR.REPLACE"] = "Vervangen"
NLI["MENU.EDITOR.NEXT"] = "voLgende"
NLI["MODE.SORT"] = "Sort"
NLI["MENU.VIDEO.N:C:"] = "C: Video-7 VGA: 132x43"
NLI["MENU.REGULAR"] = "Normaal"
NLI["MENU.ENDOFPAGE"] = "EindePagina"
NLI["MENU.SYMPHONY"] = "Symphony"
NLI["MENU.SYMPHONY.1.1"] = "2) Symphony Release 1.1"
NLI["MENU.FILES"] = "Bestanden"
NLI["MENU.OVERALL"] = "Globaal"
NLI["MENU.REPLACE"] = "Vervangen"
NLI["MENU.EDITOR.INSERTFILE"] = "VoegIn"
NLI["MENU.NEXT"] = "voLgende"
NLI["MENU.LINEFEED"] = "Regeldoorvoer"
NLI["MENU.ORDERTABLE"] = "Rangschikking"
NLI["MENU.GRAPH"] = "Grafiek"
NLI["MENU.QUATTRO"] = "Quattro"
NLI["MENU.CHANGES"] = "Wijziging"
NLI["MENU.LOWVALUE"] = "Laagste"
NLI["INFO.DATE"] = "Datum"
NLI["INFO.FILENAME"] = "Bestandsnaam"
NLI["MENU.COMPATIBLE"] = "Compatibel"
NLI["MENU.HIGH"] = "Hoog"
NLI["MENU.CASCADE"] = "Trapsgewijs"
NLI["MENU.VIDEO.H:E:"] = "E: Everex VGA: 132x25"
NLI["MENU.SORT"] = "Volgorde"
NLI["MENU.FORMS"] = "Formulier"
NLI["MENU.RENAME"] = "Hernoem"
NLI["MENU.QUERYSPEED"] = "snelQuery"
NLI["MENU.DO-IT!"] = "DOEN!"
NLI["MENU.SHOWHIGHLIGTH"] = "ToonMarkering"
NLI["ASK.AS"] = "ALS"
NLI["MENU.EDITOR.GOTO"] = "GaNaar"
NLI["MENU.EDITOR.XCUT"] = "Uitknippen"
NLI["MENU.VIDEO.K:"] = "K: Paradise EGA 480/VGA 1024"
NLI["MENU.FORMAT"] = "Opmaak"
NLI["MENU.SCRIPT"] = "Script"
NLI["MENU.ASCII"] = "ASCII"
NLI["MENU.DOUBLE-LINE"] = "Dubbel"
NLI["MENU.DATE"] = "Datum"
NLI["MENU.HEADINGS"] = "Groeptitels"
NLI["REPORT.DATE.9"] = "9) dd.mm.jj"
NLI["MENU.VIDEO.D:"] = "D: EGA/VGA: 80x43/50"
NLI["MENU.OVERRIDE"] = "Anders"
NLI["MENU.CALCEDIT"] = "wijzigFormule"
NLI["MENU.ADJUST"] = "Aanpassen"
NLI["MENU.RELINK"] = "AndersKoppelen"
NLI["MENU.GROUP"] = "Groep"
NLI["INFO.LOCKTYPE"] = "Vergrendelingstype"
NLI["MENU.VIDEO.F:"] = "F: ATI VGA Wonder"
NLI["MENU.QUATTROPRO"] = "2) Quattro Pro"
NLI["FORM.EMBEDDED.END"] = ", gebruik makend van formulier "
NLI["MENU.EDITOR.CHANGETOEND"] = "TotEinde"
NLI["MENU.MODIFY"] = "Wijzig"
NLI["MENU.INVENTORY"] = "Inventaris"
NLI["MENU.QUERYSAVE"] = "QueryOpname"
NLI["TABLE.FAMILY"] = "Verwant"
NLI["MENU.SIZE/MOVE"] = "Formaat/Verplaats"
NLI["MENU.VIDEO.E:C:"] = "C: VGA Wizard: 132x25"
NLI["MENU.CROSSTAB"] = "Kruistabulatie"
NLI["MENU.REFLEX"] = "Reflex"
NLI["MENU.REFLEX.1.1"] = "2) Reflex Release 1.1"
NLI["MODE.COEDIT"] = "Samen"
NLI["INFO.SAT"] = "zat"
NLI["INFO.MON"] = "maa"
NLI["REPORT.FORM BAND"] = "Formlrzone"
NLI["MENU.COUNT"] = "Telling"
NLI["REPORT.GROUP FOOTER"] = "Groepvoetregel voor"
NLI["MENU.WINDOW"] = "KiesVenster"
NLI["MENU.SURFACEQUERIES"] = "QueriesVooraan"
NLI["MENU.OPEN"] = "Open"
NLI["MENU.ABOUT"] = "Info"
NLI["MENU.MM/DD/YY"] = "1) MM/DD/JJ"
NLI["MENU.DD.MM.YY"] = "3) DD.MM.JJ"
NLI["MENU.YY.MM.DD"] = "4) JJ.MM.DD"
NLI["MENU.PER-GROUP"] = "Per-groep"
NLI["MENU.MARGIN"] = "Marge"
NLI["MENU.EDITOR.OPEN"] = "Open"
NLI["REPORT.DATE.7"] = "7) dd-mnd-jjjj"
NLI["MENU.COEDIT"] = "Samen"
NLI["MENU.INFO"] = "Informatie"
NLI["MENU.MORE"] = "Meer"
NLI["MENU.AFTER"] = "Na"
NLI["MENU.LENGTH"] = "Lengte"
NLI["MENU.VIDEO.B:"] = "B: Monochroom"
NLI["MENU.VIEWGRAPH"] = "weerGeven"
NLI["MENU.WRITELOCK"] = "Schrijven"
NLI["MENU.UNDO"] = "hersteL"
NLI["MENU.COLOR"] = "Kleur"
NLI["ASK.MAX"] = "MAX"
NLI["MENU.VIDEO.J:D:"] = "D: Orchid VGA: 132x44"
NLI["MENU.VIDEO.M:B:"] = "B: STB VGA: 132x44"
NLI["MENU.RANGEOUTPUT"] = "Bestemming"
NLI["MENU.EXPORT"] = "Exporteer"
NLI["MENU.PLACE"] = "Plaatsen"
NLI["MENU.EDITOR.COPY"] = "Kopiren"
NLI["MENU.FILEFORMAT"] = "Bestandsindeling"
NLI["MENU.GRAPH.1STPRINTER"] = "1ePrinter"
NLI["MENU.GRAPH.TYPE"] = "Type"
NLI["REPORT.PER GROUP"] = " per groep"
NLI["REPORT.DATE.12"] = "12) jj.mm.dd"
NLI["REPORT.DATE.11"] = "11) jj-mm-dd"
NLI["MENU.VIDEO.N:A:"] = "A: Video-7 VGA: 80x60"
NLI["MENU.KEEPSET"] = "PermInst"
NLI["MENU.TOOLS"] = "Extra"
NLI["MENU.VISICALC"] = "VisiCalc"
NLI["MENU.FIELDNAMES"] = "Veldnamen"
NLI["ASK.FIND"] = "ZOEK"
NLI["ASK.ONLY"] = "ALLEEN"
NLI["MENU.INTERNATIONAL"] = "Internationaal"
NLI["MENU.NOCOMMAS"] = "GeenDuizendscheider"
NLI["MENU.DIGITS"] = "Cijfers"
NLI["MENU.VIDEO.E:"] = "E: Ahead Systems VGA Wizard"
NLI["MENU.SCIENTIFIC"] = "Wetenschappelijk"
NLI["MENU.COPY"] = "Kopiren"
NLI["MENU.GROUPSOFTABLES"] = "GroepenVanTabellen"
NLI["MENU.PRINTERPORT"] = "Printerpoort"
NLI["MENU.FIXED"] = "Vast"
NLI["MENU.RECORDS"] = "Records"
NLI["INFO.SAVEVARS"] = "Varopslg"
NLI["MENU.TRIMMING"] = "Inkorten"
NLI["MENU.CROSSTAB.MAX"] = "3) Max"
NLI["MENU.FILE"] = "bEstand"
NLI["MENU.SYMPHONY.1.0"] = "1) Symphony Release 1.0"
NLI["MENU.APPENDDELIMITED"] = "VoegToe"
NLI["MODE.FORM"] = "Formlr"
NLI["MENU.NUMBERRECORDS"] = "AantalRecords"
NLI["PROMPT.SETUP STRING:"] = "Instelreeks:"
NLI["MENU.NO-TRIMMING"] = "Niet-inkorten"
NLI["MENU.FORMFEED"] = "Paginadoorvoer"
NLI["MENU.MOVE"] = "Verplaats"
NLI["MENU.PLAY"] = "afSpelen"
NLI["MENU.DISPLAYONLY"] = "AlleenTonen"
NLI["MENU.EDITOR.COPYTOFILE"] = "KopieNaar"
NLI["REPORT.DATE.5"] = "5) dd-mnd-jj"
NLI["MENU.VIDEO.J:B:"] = "B: Orchid VGA: 132x25"
NLI["MENU.VIDEO.L:B:"] = "B: Sigma VGA: 132x44"
NLI["MENU.FORM"] = "Formlr"
NLI["MENU.EDITOR.AUTOINDENT"] = "Inspringen"
NLI["MENU.EDITOR.FILE"] = "bEstand"
NLI["MENU.GRAPH.GRAPH.WAIT"] = "Wachten"
NLI["REPORT.DATE.8"] = "8) mm/dd/jjjj"
NLI["MENU.VIDEO.I:B:"] = "B: Genoa VGA: 132x28"
NLI["MENU.DESIGN"] = "Ontwerp"
NLI["MENU.CHANGE"] = "Verander"
NLI["MENU.ZOOM"] = "Zoom"
NLI["MENU.CANCEL"] = "Annuleer"
NLI["MENU.MULTIADD"] = "mUltiPlus"
NLI["MENU.WAIT"] = "Wachten"
NLI["MENU.EDITOR.NEW"] = "Nieuw"
NLI["MENU.GRAPH.MODIFY"] = "Wijzig"
NLI["MENU.SAVE"] = "SlaOp"
NLI["MENU.WRITE-PROTECT"] = "Schrijfbeveiliging"
NLI["TABLE.CROSSTAB"] = "Kruistab"
NLI["MENU.VIDEO.E:D:"] = "D: VGA Wizard: 132x44"
NLI["MENU.WORKSHOP"] = "Workshop"
NLI["MENU.PICKFORM"] = "kiesFormulier"
NLI["MENU.FAMILY"] = "OverVerwanten"
NLI["MENU.HELPANDFILL"] = "BladerenEnInvullen"
NLI["MENU.ALLCORRESPONDINGFIELDS"] = "AlleOvereenkomende"
NLI["MENU.PAGELAYOUT"] = "Layout"
NLI["INFO.THU"] = "don"
NLI["MENU.GRAPH.MARKERSANDFILLS"] = "Markering&Patroon"
NLI["REPORT.CURRENT PAGE NUMBER"] = "Huidig paginanummer"
NLI["REPORT.DATE.6"] = "6) Mnd jj"
NLI["MENU.VIDEO.G:A:"] = "A: Compaq VGS: 132x25"
NLI["MENU.VIDEO.I:"] = "I: Genoa Systems Super VGA"
NLI["MENU.CUSTOM"] = "OpMaat"
NLI["MENU.SUBTRACT"] = "Min"
NLI["MENU.EDITOR.SAVE"] = "SlaOp"
NLI["REPORT.DATE.3"] = "3) mm/dd"
NLI["MODE.MAIN"] = "Hoofd"
NLI["MENU.VIDEO.J:"] = "J: Orchid ProDesigner VGA"
NLI["MENU.VIDEO.L:"] = "L: Sigma VGA Legend/HP16"
NLI["MENU.NEW"] = "Nieuw"
NLI["MENU.TABLEINDEX"] = "TabelIndex"
NLI["PROMPT.TABLE:"] = "Tabel:"
NLI["MENU.CONVERT"] = "Converteer"
NLI["MENU.BORROW"] = "Overnemen"
NLI["MENU.GRAPH.3RDPRINTER"] = "3ePrinter"
NLI["REPORT.WRAP:"] = " regels:"
NLI["MENU.VIDEO.C:"] = "C: EGA/VGA: 80x25"
NLI["MENU.ASK"] = "Vraag"
NLI["MENU.DELIMITED"] = "MaakNieuw"
NLI["MENU.PREVENTLOCK"] = "BeletVergrendeling"
NLI["MENU.SHOW"] = "Tonen"
NLI["MENU.UNLINK"] = "Ontkoppelen"
NLI["MENU.EDITOR.PRINT"] = "Afdrukken"
NLI["MENU.GRAPH.TITLES"] = "Titels"
NLI["REPORT.DATE.2"] = "2) M a a n d dd, jjjj"
NLI["REPORT.DATE.1"] = "1) mm/dd/jj"
NLI["MENU.VIDEO.H:A:"] = "A: Everex VGA: 80x34"
NLI["MENU.VIDEO.M:"] = "M: STB PowerGraph VGA"
NLI["TABLE.PROBLEMS"] = "Probleem"
NLI["ASK.BLANK"] = "LEEG"
NLI["REPORT.TOTAL FOR"] = "Totaal voor "
NLI["INFO.MENUCHOICE.ERROR"] = "Error"
NLI["MENU.SCREEN"] = "Scherm"
NLI["MENU.NO"] = "Nee"
NLI["MENU.MULTI"] = "Multi"
NLI["TABLE.KEYVIOL"] = "$$nli2$$"
NLI["MENU.PERGROUP"] = "PerGroep"
NLI["MENU.NEGATIVEONLY"] = "Minteken"
NLI["MENU.VIDEO.E:B:"] = "B: VGA Wizard: 80x45"
NLI["MENU.LOAD"] = "Laden"
NLI["MENU.CONTINUE"] = "Doorgaan"
NLI["MENU.FORMADD"] = "FormPlus"
NLI["INFO.USERNAME"] = "Gebruikersnaam"
NLI["MENU.EDITOR.SHOWCLIPBOARD"] = "ToonKlembord"
NLI["MODE.DATAENTRY"] = "Batch"
NLI["MENU.GRAPH.AXES"] = "Assen"
NLI["MENU.REPORT"] = "Rapport"
NLI["MENU.CROSSTAB.SUM"] = "1) Som"
NLI["MENU.DBASE"] = "dBASE"
NLI["MENU.HIGHVALUE"] = "Hoogste"
NLI["MENU.SORTDIRECTION"] = "Sortering"
NLI["ASK.INSERT"] = "VOEGIN"
NLI["MENU.GRAPH.CURRENTPRINTER"] = "HuidigePrinter"
NLI["MENU.GRAPH.COPY"] = "Kopiren"
NLI["MENU.LOW"] = "Laag"
NLI["MENU.COMMAS"] = "Duizendscheider"
NLI["MENU.CLOSE"] = "SluitVenster"
NLI["MENU.SETUP"] = "Instelreeks"
NLI["MENU.DBASE.4"] = "3) dBASE IV"
NLI["PROMPT.VALUE:"] = "Waarde:"
NLI["MODE.FILE EDITOR"] = "EditBestand"
NLI["MENU.DATAENTRY"] = "BatchInvoer"
NLI["MENU.123.1.A"] = "1) 1-2-3 Release 1A"
NLI["MODE.REPORT"] = "Rapport"
NLI["MENU.SUMMARY"] = "Overzicht"
NLI["REPORT.PAGE FOOTER"] = "Paginavoetregel"
NLI["ASK.CALC"] = "REKEN"
NLI["MENU.GRAPH.4THPRINTER"] = "4ePrinter"
NLI["MENU.COLUMNSIZE"] = "Kolommaat"
NLI["MENU.SAMETABLE"] = "ZelfdeTabel"
NLI["MENU.TODOS"] = "NaarDOS"
NLI["MENU.MONOCHROME"] = "Monochroom"
NLI["MENU.GROUPREPEATS"] = "Groepherhalingen"
NLI["ASK.SUM"] = "SOM"
NLI["ASK.TODAY"] = "VANDAAG"
NLI["ASK.EXACTLY"] = "EXACT"
NLI["MENU.VIDEO.I:C:"] = "C: Genoa VGA: 132x43"
NLI["MENU.RESTRUCTURE"] = "Herstructureer"
NLI["MENU.ADD"] = "Plus"
NLI["MENU.YES"] = "Ja"
NLI["MENU.BEFORE"] = "Voor"
NLI["MENU.RETAIN"] = "Behouden"
NLI["REPORT.REPORT FOOTER"] = "Rapportvoetregel"
NLI["MENU.GRAPH.2NDPRINTER"] = "2ePrinter"
NLI["MENU.VIDEO.J:C:"] = "C: Orchid VGA: 132x28"
NLI["MENU.VIDEO.K:B:"] = "B: Paradise EGA/VGA: 132x43"
NLI["MENU.TABLES"] = "Tabellen"
NLI["MENU.DIRECTORY"] = "Directory"
NLI["MENU.WORDWRAP"] = "Regelovergang"
NLI["TABLE.DELETED"] = "Verwdrd"
NLI["ASK.DELETE"] = "VERWIJDER"
NLI["INFO.WED"] = "woe"
NLI["MENU.EDITOR.WORDWRAP"] = "Regelovergang"
NLI["MODE.RESTRUCTURE"] = "Herstruct"
NLI["REPORT.MAXIMUM FOR"] = "Maximum voor "
NLI["MENU.RESTART"] = "Herstarten"
NLI["MENU.FILLED"] = "Compleet"
NLI["MENU.PAGE"] = "Pagina"
NLI["MENU.GRAPH.PIES"] = "Cirkels"
NLI["MENU.GRAPH.FILE"] = "bEstand"
NLI["MENU.AVERAGE"] = "Gemiddelde"
NLI["MENU.VIDEO.F:B:"] = "B: ATI VGA: 132x44"
NLI["MENU.123"] = "1-2-3"
NLI["MENU.EXIT"] = "Uit"
NLI["MENU.LOOKUP"] = "Opzoek"
NLI["MENU.UNLINKED"] = "Ontkoppeld"
NLI["TABLE.STRUCT"] = "Struct"
NLI["TABLE.ENTRY"] = "Invoer"
NLI["MENU.GRAPH.LEGENDSANDLABELS"] = "Legenda&Label"
NLI["MENU.GRAPH.GRIDS"] = "Rasters"
NLI["MENU.LABELS"] = "Etiketten"
NLI["REPORT.DATE.4"] = "4) mm/jj"
NLI["MENU.TILE"] = "NaastElkaar"
NLI["MENU.VIDEO.A:"] = "A: Automatisch"
NLI["MENU.PRINTER"] = "Printer"
NLI["MENU.MASTER"] = "Hoofd"
NLI["MENU.EDITOR.OPTIONS"] = "Opties"
NLI["MENU.OOPS!"] = "Oeps!"
NLI["MODE.CREATE"] = "Maken"
NLI["MENU.VIDEO.H:C:"] = "C: Everex VGA: 100x43"
NLI["MENU.CROSSTAB.MIN"] = "2) Min"
NLI["MENU.STYLE"] = "Stijl"
NLI["TABLE.CHANGED"] = "Gewzgd"
NLI["MENU.FREE-FORM"] = "EigenOpmaak"
NLI["MENU.VALUE"] = "Waarde"
NLI["MENU.LOCK"] = "Vergrendel"
NLI["MENU.PRIVATELOOKUP"] = "Priv-koppeling"
NLI["ASK.LIKE"] = "ZOALS"
NLI["MENU.EDITOR.CASESENSITIVE"] = "ABC<>abc"
NLI["MENU.EDITOR.SEARCH"] = "Zoek"
NLI["REPORT.AVERAGE OF"] = "Gemiddelde van "
NLI["MENU.CREATE"] = "Maak"
NLI["MENU.TABLESIZE"] = "Tabelmaat"
NLI["MENU.TEXT"] = "Tekst"
NLI["FORM.FORMULA"] = "Formule"
NLI["MENU.EDITOR.FIND"] = "Zoeken"
NLI["MENU.EXPORTIMPORT"] = "ExportImport"
NLI["MENU.VALCHECK"] = "Validatie"
NLI["ASK.MIN"] = "MIN"
NLI["MENU.GRAPH.COLORS"] = "Kleuren"
NLI["MENU.MAXIMIZE/RESTORE"] = "Maximum/Herstel"
NLI["MENU.OK"] = "OK"
NLI["MENU.WHO"] = "Wie"
NLI["MENU.GRAPH.DEVICE"] = "UitvoerNaar"
NLI["MENU.VIDEO.G:C:"] = "C: Compaq VGS: 132x43"
NLI["MENU.RESET"] = "Beginwaarde"
NLI["MENU.MULTIENTRY"] = "MultiInvoer"
NLI["MENU.REPEATPLAY"] = "HerhaalAfspelen"
NLI["MENU.TIME"] = "Tijd"
NLI["MENU.FIND"] = "Zoeken"
NLI["MENU.LINESQUEEZE"] = "RegelsOnderdrukken"
NLI["MENU.DIFFERENTTABLE"] = "AndereTabel"
NLI["MENU.USERNAME"] = "Gebruikersnaam"
NLI["MENU.AUTOREFRESH"] = "AutoOpfris"
NLI["MENU.PROTECT"] = "Beveilig"
NLI["MENU.DEFINE"] = "Definiren"
NLI["REPORT.TABLE BAND"] = "Tabelzone"
NLI["ASK.COUNT"] = "TELLING"
NLI["INFO.SUN"] = "zon"
NLI["MENU.DESKTOP"] = "Bureaublad"
NLI["MENU.VIDEO.G:"] = "G: Compay Intern (132 koloms) VGS"
NLI["MENU.VIDEO.I:A:"] = "A: Genoa VGA: 132x25"
NLI["MENU.GENERAL"] = "Algemeen"
NLI["MENU.COMMA"] = "Komma"
NLI["MENU.REQUIRED"] = "Verplicht"
NLI["MENU.ERASE"] = "Wissen"
NLI["MENU.VIDEO.J:A:"] = "A: Orchid VGA: 80x60"
NLI["MENU.VIDEO.L:A:"] = "A: Sigma VGA: 132:25"
NLI["MENU.IMPORT"] = "Importeer"
NLI["MENU.END-RECORD"] = "EindeOpname"
NLI["MENU.FILLNOHELP"] = "AlleenInvullen"
NLI["MENU.BORDER"] = "Kader"
NLI["TABLE.INSERTED"] = "Ingvgd"
NLI["MENU.EDITOR.PASTE"] = "Plakken"
NLI["MENU.DBASE.3"] = "2) dBASE III"
NLI["MENU.STRUCTURE"] = "Structuur"
NLI["MENU.TABULAR"] = "Kolommen"
NLI["MENU.REPORT.LOOKUP"] = "opZoek"
NLI["MENU.SETUP PREDEFINED"] = "Vooringesteld"
NLI["TABLE.ANSWER"] = "Antwrd"
NLI["MENU.EDITOR.ERASE"] = "Wissen"
NLI["INFO.FIELD TYPE"] = "Veldtype"
NLI["MENU.ALWAYSSIGN"] = "Beide"
NLI["MENU.123.2"] = "2) 1-2-3 Release 2"
NLI["MENU.NET"] = "Netwerk"
NLI["MENU.PICTURE"] = "Sjabloon"
NLI["MENU.OTHER"] = "Overig"
NLI["MENU.JUSTIFY"] = "Uitlijnen"
NLI["MENU.SUPPRESS"] = "Onderdrukken"
NLI["ASK.FAST"] = "SNEL"
NLI["ASK.NOT"] = "NIET"
NLI["ASK.CHANGETO"] = "WIJZIGIN"
NLI["MENU.STANDARD"] = "Standaard"
NLI["MENU.INTERNATIONALCONVENTION"] = "VerenigdeStaten"
NLI["MENU.CROSSTAB.COUNT"] = "4) Aantal"
NLI["MENU.TABLE"] = "Tabel"
NLI["MENU.DBASE.2"] = "1) dBASE II"
NLI["INFO.PRODUCT"] = "Produkt"
NLI["REPORT.GROUP HEADER"] = "Groeptitel voor"
NLI["MENU.SETPRIVATE"] = "PrivDir"
NLI["MENU.CLEAR"] = "Schonen"
NLI["MENU.EDITOR.LOCATION"] = "Lokatie"
NLI["MENU.GRAPH.PRINTERTOSCREEN"] = "Printer->Scherm"
NLI["MENU.GRAPH.SCREENTOPRINTER"] = "Scherm->Printer"
NLI["MENU.GRAPH.OVERALL"] = "gLobaal"
NLI["MENU.VIDEO.N:B:"] = "B: Video-7 VGA: 100x60"
NLI["MENU.EDITOR"] = "Editor"
NLI["MENU.CLEARPASSWORDS"] = "Vrijgeven"
NLI["FORM.EMBEDDED.START"] = "Geneste tabel "
NLI["INFO.FRI"] = "vri"
NLI["MENU.VIDEO.H:"] = "H: Everex Viewpoint VGA/EV-673 VGA"
NLI["MENU.VIDEO.M:A:"] = "A: STB VGA: 132x25"
NLI["MENU.UTILITIES"] = "Hulpmiddelen"
NLI["MENU.PFS"] = "PFS"

endproc
writelib "NLI"  NLI031
release  procs   NLI031

