; nlitest.sc
; ----------
;
; This script shows some of the usage of the EPA Language NLI
;
; Copyright (c) 1993 C&B International, Denmark
;                    Richplum Ltd., United Kingdom
;
; Author: Flemming Christensen, Phil Goulson
;

autolib = "NLI"

sysinfo to sysinfo.y

execproc "NLI"+sysinfo.y["Language"]

;begin test

echo fast

create "nlitest" "Name" : "A40"
tablename = "nlitest"

NLImenu("Modify,Edit,{~tablename}")
  [name]="Testing..."
  Do_it!

NLImenu("Ask,{nliTest}")
check
do_it!

if not isempty(NLI["table.answer"]) then
  message "The query gave an answer"
  sleep 1000
endif

clearall

NLImenu("Tools,Info,Inventory,Tables,{"+directory()+"}")
if not isempty(NLI["table.List"]) then
  moveto field NLI["info.date"]
  NLImenu("Image,OrderTable,[enter],[enter],Ok")
  sleep 1000
endif

NLImenu("Ask,{"+NLI["table.List"]+"},[check],[Do_It!]")
if imagetype() = "Query" then 
  debug
endif

reset

NLImenu("Ask,{"+NLI["table.List"]+"},(set),,[_a]")
down
typein NLI["ask.every"] +" _a" right check do_it!
if imagetype() = "Query" then 
  debug
endif
reset

NLImenu("Ask,{"+NLI["table.List"]+"},(set),,[_a]")
down
typein NLI["ask.no"]+" _a" right check do_it!
if imagetype() = "Query" then 
  debug
endif
reset

NLImenu("Ask,{"+NLI["table.List"]+"},(set),,[_a]")
down
typein NLI["ask.exactly"]+" _a" right check do_it!
if imagetype() = "Query" then 
  debug
endif
reset

NLImenu("Ask,{"+NLI["table.List"]+"},(set),,[_a]")
down
typein NLI["ask.only"]+" _a" right check do_it!
if imagetype() = "Query" then 
  debug
endif
reset

NLImenu("Ask,{"+NLI["table.List"]+"},,(changeto),[ \"abc\"],[Do_it!]")
if imagetype() = "Query" then 
  debug
endif
reset

NLImenu("Ask,{"+NLI["table.List"]+"},(Find),,[\"abc\"],[Do_it!]")
if imagetype() = "Query" then 
  debug
endif
reset

