;*****************************************************************************
;N2W.PROC                            PARADOX 3.5                   1.0
;CONVERT DOLLARS TO WORDS              11-24-90                    LARRY DROWN
;******************************************************************************

PROC n2w(m_number)

;******************************************************************************
; RETURN "INVALID NUMBER" IF OUT OF RANGE
;******************************************************************************

IF (m_number <= 0) OR (m_number > 999999999999.99)
    THEN RETURN "INVALID NUMBER"
ENDIF

;******************************************************************************
; INITIALIZE       Handles Alphanumeric or Numeric
;******************************************************************************

word = ""
temp = strval(m_number)     ;If field type is $ then
m_number = numval(temp)     ;this code is needed.
orig = m_number
cent = (m_number - INT(m_number))*100
cents = int(round(cent,2))

;******************************************************************************
;IF LESS THAN $1.00 START WITH ZERO
;******************************************************************************

IF INT(m_number) = 0
   THEN word = "ZERO "
ENDIF

;******************************************************************************
; SET UP ARRAYS
;******************************************************************************

ARRAY mone[19] ARRAY mten[9]

mone[1] = "ONE "
mone[2] = "TWO "
mone[3] = "THREE "
mone[4] = "FOUR "
mone[5] = "FIVE "
mone[6] = "SIX "
mone[7] = "SEVEN "
mone[8] = "EIGHT "
mone[9] = "NINE "
mone[10] = "TEN "
mone[11] = "ELEVEN "
mone[12] = "TWELVE "
mone[13] = "THIRTEEN "
mone[14] = "FOURTEEN "
mone[15] = "FIFTEEN "
mone[16] = "SIXTEEN "
mone[17] = "SEVETEEN "
mone[18] = "EIGHTEEN "
mone[19] = "NINETEEN "

mten[1] = "TEN "
mten[2] = "TWENTY "
mten[3] = "THIRTY "
mten[4] = "FOURTY "
mten[5] = "FIFTY "
mten[6] = "SIXTY "
mten[7] = "SEVENTY "
mten[8] = "EIGHTY "
mten[9] = "NINETY "

;******************************************************************************
; HANDLE BILLIONS
;******************************************************************************

x = INT(m_number/1000000000)
IF x > 0
    THEN mkwords(x,word)
    word = word + "BILLION "
ENDIF
m_number = m_number - (x * 1000000000)

;******************************************************************************
; HANDLE MILLIONS
;******************************************************************************

x = INT(m_number/1000000)
IF x > 0
    THEN mkwords(x,word)
    word = word + "MILLION "
ENDIF
m_number = m_number - (x * 1000000)

;******************************************************************************
; HANDLE THOUSANDS
;******************************************************************************

x = INT(m_number/1000)
IF x > 0
     THEN mkwords(x,word)
     word = word + "THOUSAND "
ENDIF
m_number = m_number - (x * 1000)

;******************************************************************************
;HANDLE THE REST
;******************************************************************************

IF m_number >= 1
   THEN mkwords(INT(m_number),word)
ENDIF

;******************************************************************************
; SET UP DOLLARS AND CENTS
;******************************************************************************

IF orig >= 2 OR INT(orig) = 0
   THEN word = word + "DOLLARS AND "
ENDIF
IF INT(orig) = 1
   THEN word = word + "DOLLAR AND "
ENDIF

IF cents <= 99
  THEN IF cents < 10
      THEN word = word + "0" + STRVAL(cents) + "/100"
  ELSE
      word = word + STRVAL(cents) + "/100"
  ENDIF

  ELSE
      word = word + "00/100"
ENDIF

RETURN word
ENDPROC

;******************************************************************************
; PROCEDURE MKWORDS             Makes the words
;******************************************************************************

PROC mkwords(numb,string)

nstr = STRVAL(numb)
word = string

WHILE (""<>nstr)
nlen = LEN(nstr)
     SWITCH
           CASE nlen = 3 :
              word = word + mone[NUMVAL(SUBSTR(nstr,1,1))]
              word = word + "HUNDRED "
              nstr = SUBSTR(nstr,2,2)
           CASE nlen = 2 :
               IF NUMVAL(SUBSTR(nstr,1,2)) = 0
                  THEN nstr = ""
               ELSE
               IF NUMVAL(SUBSTR(nstr,1,2)) < 20
                  THEN word = word + mone[NUMVAL(SUBSTR(nstr,1,2))]
                  nstr = ""
               ELSE
               IF NUMVAL(SUBSTR(nstr,1,2)) > 20
                  THEN word = word + mten[NUMVAL(SUBSTR(nstr,1,1))]
                  nstr = SUBSTR(nstr,2,1)
               ELSE
               IF NUMVAL(SUBSTR(nstr,1,2)) = 20
                  THEN word = word + mten[NUMVAL(SUBSTR(nstr,1,1))]
                  nstr = ""
                  ENDIF
                 ENDIF
                ENDIF
               ENDIF
            CASE nlen = 1 :
               IF NUMVAL(nstr) > 0
               THEN word = word + mone[NUMVAL(SUBSTR(nstr,1,1))]
               nstr = ""
               ELSE nstr =""
            ENDIF
        ENDSWITCH
      ENDWHILE
    RETURN word
ENDPROC

;*****************************************************************************
; DELEATE FROM HERE DOWN... TESTING ONLY
;*****************************************************************************

WHILE TRUE
CLEAR
@ 5,0
? "ENTER A NUMBER : "
ACCEPT "N" TO X
IF RETVAL = FALSE THEN
RELEASE PROCS ALL
RELEASE VARS ALL
RETURN
ENDIF
@ 6,0  ? n2w(x)
;print "\13"
;print n2w(X)
;print "\13"
;print "\10"
sleep 5000
ENDWHILE
