CODE LISTINGS
;-------------------------------------------------------------------------
PROC MessageWindow.u(msg.a,            ; Message to display (<70 chars)
	  row.n,	                        ; Row to begin message window
	  col.n,	                        ; Column to begin message window
       att.n,                          ; Color for message
       beep.n,                         ; Number of beeps
       sleep.n)                        ; # of Seconds to pause
Private  proc.a,                       ; Name of this proc
         w,                            ; Current Window Handle
         n                             ; Loop incrementer
;Global  g_msg.y,                      ; Global message window dynamic array
;        g_msg.w,                      ; Global message window handle
   proc.a = "MessageWindow.u"
   Cursor OFF
   Window HANDLE CURRENT To w          ; Save current window handle
   IF NOT IsAssigned(g_msg.w) THEN     ; Must be first time, or var released
      DynArray g_msg.y[]               ; Create a dynamic array for specs
         g_msg.y["CanClose"] = False
         g_msg.y["CanMaximize"] = False
         g_msg.y["CanMove"] = False
         g_msg.y["CanResize"] = False
         g_msg.y["Echo"] = True
         g_msg.y["HasFrame"] = False   ; If Framed, window is *5* rows!!!
         g_msg.y["Style"] = Int(att.n/16) * 16  ; Black on message background
      Window CREATE  FLOATING @ 0,2
                     HEIGHT 3 WIDTH 76
                     ATTRIBUTES g_msg.y To g_msg.w
   ENDIF
   Canvas OFF
   Window MOVE g_msg.w To row.n,col.n  ; Bring window to screen
   SetCanvas g_msg.w                   ; Set Canvas to Message Window
   PaintCanvas FILL " " ATTRIBUTE Int(att.n/16) * 16 ALL ; Clear Canvas
   Frame DOUBLE FROM 0,0 To 2,75 ;Len(msg.a) + 9         ; Frame Canvas
   Style ATTRIBUTE att.n               ; Message Color
   @ 1,Int((76 - Len(msg.a))/2)        ; Place message
   ?? msg.a
   Style ATTRIBUTE att.n + 128         ; Add blinking ellipsis
      ?? "..."
   Style
   Canvas ON                           ; Show screen
   FOR n from 1 to Min(5,beep.n)
      Beep Sleep 100                   ; Beep for desired # of Beeps
   ENDFOR
   Sleep sleep.n * 1000                ; Sleep for desired # of seconds
   IF IsWindow(w) THEN                 ; In case there wasn't any window
      Window SELECT w                  ; Restore original Window
   ENDIF
   Return
ENDPROC
;-------------------------------------------------------------------------
PROC WindowPark.u(w)
   IF IsWindow(w) THEN                 ; Make sure it still exists
      Window MOVE w To -10000,-10000   ; Park it in left field
   ENDIF
ENDPROC
