; ------------------------------------------------------------------------ 
; MSCFFW.SC / 10-30-92
; 
;              MOUSE SCROLL CONTROLS FOR FRAMELESS WINDOWS 
; 
; This script creates a set of procedures that demonstrate a way to place 
; mouse scroll controls on a frameless window.  It is not generic, being
; designed to work with a standard approach to lookup table form design I'm 
; using right now.  The forms are constructed like this, with a 6-row multi 
; record area: 
;
;   Column 012345678901234567890123456789...  Overall color Lt Grn on
;    Row 0 Ŀ       Dk Grn (attribute 42)
;        1   Code  Description       
;        2 H           Scroll bar arrow controls
;        3    fields are         are chr(30/31)
;        4    style black        
;        5    on lt. gray        Mouse bar is floating window
;        6    (att. 112)         6 rows x 1 column, att. 42,
;        7 E           with up/down arrows in middle
;        8        painted att. 40
;           \
;            \___ mouse bar window located at lookup window coordinates 2,1
;
; You can try this out on any form, though, just bring up a form and press 
; the setkey (CtrlA).  The first field (the lookup field) is highlighted
; white on red (att. 79) and the current field (cursor location) is painted 
; blinking.  F2 and Esc trigger the usual actions, simulated here, by 
; returning the name of a procedure to execproc.  Mouse clicks and cursor 
; keys move about the table.  Mouse clicks on the floating window are 
; localized and the row value translated to an array index, and the array 
; element value (a keyname) keypressed.  A doubleclick selects like pressing 
; F2, except that because it can be so easy to accidentally double click the 
; user is asked (dialog box) to verify the selection.
;
;
; Features lacking / Problems to be resolved:  
;
; - It might be nice to have a drag button - probably a chr(254) "" block 
;   just above the [H]ome button.
;
; - Field highlighting routine only handles type Annn fields now - needs to 
;   have numeric and date detection added.
;
; - Probably lots of other things too, so send your gripes and suggestions 
;   to:  Steve Caple  CIS ID 76711,520
;
; Steve Caple, Sacramento Paradox Users Roundtable 
; ------------------------------------------------------------------------ 




LibName = "Mscffw"
createlib LibName



; ------------------------------------------------------------
; MouseSelectionConfirmed
; ------------------------------------------------------------
proc MouseSelectionConfirmed()
   private CurrentProc,
           R
   CurrentProc = "MouseSelectionConfirmed"
   synccursor
   R = iif(row()>16,row()-9,row())
   showdialog ""
      @ R+1, LUOC+2 height 7 width 28
      paintcanvas fill "    [Enter]     [Esc]     "
                  attribute 120  0,0,0,25
      pushbutton @1,2 width 10
         "~O~K"
         ok
         default
         value "OK"
         tag "OK"
         to ConfirmButton
      pushbutton @1,13 width 10
         "~C~ancel"
         cancel
         value "cancel"
         tag "Cancel"
         to ConfirmButton
      paintcanvas fill " Please Confirm or Cancel "
                  attribute 112  3,0,3,25
      paintcanvas fill "   DoubleClick Selection  "
                  attribute 112  4,0,4,25
   enddialog
   return retval   ;ConfirmButton
endproc

writelib LibName MouseSelectionConfirmed
release procs MouseSelectionConfirmed




; ------------------------------------------------------------
; PaintMouseScrollBar -
; ------------------------------------------------------------
proc PaintMouseScrollBar()
   private CurrentProc,
           MBwAtt,
           R,
           C

   CurrentProc = "PaintMouseScrollBar"

   dynarray MBwAtt[]                  ; - mouse bar window attribs

   if isformview() and formtype("MultiRecord")
      and not(ismultiform(table(),form())) then
      R = LUOR+2
      C = LUOC+1
   else
      R = 18
      C = 0
   endif

   MBwAtt["HASSHADOW"] = false
   MBwAtt["HASFRAME"]  = false
   MBwAtt["STYLE"]     = 42      ; - my lookup forms are this color,
   window create floating        ;   with black on lt. gray fields
      @ R, C
      height 6   width 1         ; - my lookup tables are at least
      attributes MBwAtt          ;   6 rows deep
      to MouseBarHandle          ; - global for use by calling proc

   setcanvas MouseBarHandle      ; - canvas coords window relative

   array MouseBarActions[6]   ; - global for use by calling proc
         MouseBarActions[1] = "home"
         MouseBarActions[2] = "pgup"
         MouseBarActions[3] = "up"
         MouseBarActions[4] = "down"
         MouseBarActions[5] = "pgdn"
         MouseBarActions[6] = "end"

   @ 0,0 ?? "H"     ; Home
          ? ""     ; PgUp
          ? ""     ; Up         ;<- these arrows are dk. gray on
          ? ""     ; Down       ;<  green instead of the lt. green
          ? ""     ; PgDn       ;   on green (42)
          ? "E"     ; End
   paintcanvas attribute 40 2,0,3,0  ;this paints them dk. gray

   window select LookupHandle
   setcanvas default
   echo normal
   echo off

endproc

writelib Libname PaintMouseScrollBar
release procs PaintMouseScrollBar




; ------------------------------------------------------------
; LookupMan.GetEvent
; ------------------------------------------------------------
proc LookupMan.GetEvent()
   private CurrentProc,
           LookupHandle,
           LUwAtt,
           LUOR,
           LUOC,
           R,
           C1,
           C2,
           EventBag,
           EventType,
           Action,
           ConfirmButton,
           MouseBarHandle,
           MouseBarActions,
           FromField

   CurrentProc = "LookupMan.GetEvent"

   dynarray LUwAtt[]                           ; - lookup window attribs

   MouseBarHandle = 0
   LookupHandle = getwindow()                  ; - when this is called,
   window getattributes LookupHandle to LUwAtt ;   l/u window has focus
   LUOR =LUwAtt["ORIGINROW"]
   LUOC =LUwAtt["ORIGINCOL"]

   PaintMouseScrollBar()

   while true

      ; field highlighting
      FromField = field()    ; remember where we are
      ctrlhome               ; move to first field of record
      ; get lookup field coordinates
      fieldview
         home   synccursor   C1 = col()   R = row()
         end    synccursor   C2 = col()-1
      do_it!
      if field() = FromField then
         ; paint lookup field blinking (current) white on red
         paintcanvas attribute  79+128 R,C1,R,C2
      else
         ; paint lookup field white on red
         paintcanvas attribute  79 R,C1,R,C2
         moveto field FromField ; go back where we were
         ; get current field coordinates
         fieldview
            home   synccursor   C1 = col()   R = row()
            end    synccursor   C2 = col()-1
         do_it!
         ; paint current field blinking
         paintcanvas blink R,C1,R,C2
      endif

      getevent key "all" mouse "down","auto" to EventBag

      EventType = EventBag["Type"]
      switch
         case EventType = "KEY":
            switch
               case EventBag["KEYCODE"] = asc("Right"):     right
               case EventBag["KEYCODE"] = asc("Left"):      left
               case EventBag["KEYCODE"] = asc("Down"):      down
               case EventBag["KEYCODE"] = asc("Up"):        up
               case EventBag["KEYCODE"] = asc("PgDn"):      pgdn
               case EventBag["KEYCODE"] = asc("PgUp"):      pgup
               case EventBag["KEYCODE"] = asc("CtrlPgDn"):  ctrlpgdn
               case EventBag["KEYCODE"] = asc("CtrlPgUp"):  ctrlpgup
               case EventBag["KEYCODE"] = asc("End"):       end
               case EventBag["KEYCODE"] = asc("Home"):      home

               case EventBag["KEYCODE"] = asc("Do_It!"):
                  ctrlhome
                  return "You passed "+[]+" to LookupMan.Select"
               case EventBag["KEYCODE"] = asc("Esc"):
                  return "LookupMan.Cancel"
               case EventBag["KEYCODE"] = asc("F9"):
                  return "LookupMan.Edit"
            endswitch
            ; clean up the prior paint
            echo normal
            echo off

         case EventType = "MOUSE":

            ; if user clicked on mouse bar, do the action picked
            if windowat(EventBag["ROW"],
                        EventBag["COL"]) = MouseBarHandle then
               switch
                  case EventBag["Action"] = "DOWN":
                     localizeevent EventBag
                     Action = MouseBarActions[EventBag["ROW"]+1]
                     echo normal     ; - must echo normal to see
                     keypress Action ;   keypress take effect
                     echo off        ; - then keep things quiet
                     loop            ; - back to top of the while loop
                  case EventBag["Action"] = "AUTO":
                     echo normal
                     keypress Action ; - keep doing it while button down
                     echo off
                     loop
               endswitch
            endif

            ; otherwise make sure mouse click is on lookup window
            if windowat(EventBag["ROW"],
                        EventBag["COL"]) = LookupHandle then
               ; must be in echo normal to make mouse execevents
               ; affect the workspace
               echo normal
               execevent EventBag
               echo off
               if EventBag["DOUBLECLICK"] then
                  do_it!  ; end the fieldview

                  ; field highlighting
                  FromField = field()    ; remember where we are
                  ctrlhome               ; move to first field of record
                  ; get lookup field coordinates
                  fieldview
                     home   synccursor   C1 = col()   R = row()
                     end    synccursor   C2 = col()-1
                  do_it!

                  if field() = FromField then
                     ; paint lookup field blinking (current) white on red
                     paintcanvas attribute  79+128 R,C1,R,C2
                  else
                     ; paint lookup field white on red
                     paintcanvas attribute  79 R,C1,R,C2
                     moveto field FromField ; go back where we were
                     ; get current field coordinates
                     fieldview
                        home   synccursor   C1 = col()   R = row()
                        end    synccursor   C2 = col()-1
                     do_it!
                     ; paint current field blinking
                     paintcanvas blink R,C1,R,C2
                  endif

                  if MouseSelectionConfirmed() then
                     ctrlhome            ; move to first field of record
                     return "You passed "+[]+" to LookupMan.Select"
                  endif
               endif
            endif

      endswitch

   endwhile

endproc

writelib Libname LookupMan.GetEvent
release procs LookupMan.GetEvent



autolib = "Mscffw"

setkey 1  message LookupMan.GetEvent()   beep  sleep 1000


