;SETUP.SC THE SETUP MRP RUN FILE

;clean out the inventory file for a clean slate
EMPTY "PLANRCPT"
EMPTY "INVENTRY"
EMPTY "ALLPLANR"
EMPTY "FINALRCT"
EMPTY "MRP"
EMPTY "PEGGEDRQ"
EMPTY "REQUIRE"

@ 2,2
?? "cleared the empty routines"

;used to write the static information such as item, period, safety stock
; and leadtime to the inventory file and create records for each period.

Query

 Inventry | ITEM  | PERIOD  | SS  | LEADTIME  | 
 INSERT   | _ITEM | _PERIOD | _SS | _LEADTIME | 
          |       |         |     |           | 
          |       |         |     |           | 

 Inventry | TYPE  | 
          | _TYPE | 
          |       | 
          |       | 

 Bucket | PERIOD  | 
        | _PERIOD | 
        |         | 
        |         | 

 Invref | ITEM  | LT&STDHRS | SS  |   TYPE   | 
        | _ITEM | _LEADTIME | _SS | FG,_TYPE | 
        |       |           |     |          | 
        |       |           |     |          | 

Endquery
Do_it!
ClearAll
@ 2,2
?? "cleared the insert FG period routine"

DELETE "INSERTED"

Query

 Inventry | ITEM  | PERIOD  | SS  | LEADTIME  | 
 INSERT   | _ITEM | _PERIOD | _SS | _LEADTIME | 
          |       |         |     |           | 
          |       |         |     |           | 

 Inventry | TYPE  | 
          | _TYPE | 
          |       | 
          |       | 

 Bucket | PERIOD  | 
        | _PERIOD | 
        |         | 
        |         | 

 Invref | ITEM  | LT&STDHRS | SS  |   TYPE   | 
        | _ITEM | _LEADTIME | _SS | WP,_TYPE | 
        |       |           |     |          | 
        |       |           |     |          | 

Endquery

Do_it!
ClearAll
@ 2,2
?? "cleared the insert WP period routine"

DELETE "INSERTED"

Query

 Inventry | ITEM  | PERIOD  | SS  | LEADTIME  | 
 INSERT   | _ITEM | _PERIOD | _SS | _LEADTIME | 
          |       |         |     |           | 
          |       |         |     |           | 

 Inventry | TYPE  | 
          | _TYPE | 
          |       | 
          |       | 

 Bucket | PERIOD  | 
        | _PERIOD | 
        |         | 
        |         | 

 Invref | ITEM  | LT&STDHRS | SS  |   TYPE   | 
        | _ITEM | _LEADTIME | _SS | RM,_TYPE | 
        |       |           |     |          | 
        |       |           |     |          | 

Endquery
Do_it!
ClearAll
@ 2,2
?? "cleared the insert RM period routine"

DELETE "INSERTED"

; here we change the item's onhand balance for all periods. We will revise
; the onhand balance in future steps. However, if the item has no gross
; requirements or scheduled reciepts, then the balance should be the same
; for all time periods.

Query

 Inventry | ITEM  |      ONHAND      |
          | _ITEM | CHANGETO _ONHAND |
          |       |                  |
          |       |                  |

 Invref | ITEM  | ONHAND1 |
        | _ITEM | _ONHAND |
        |       |         |
        |       |         |

Endquery
Do_it!
DELETE "CHANGED"
@ 2,2
?? "cleared the insert on hand routine"

clearall
;NEED TO DO THIS TO BE SURE THAT ANY ITEMS WITH NEGATIVE BALANCES ARE FLAGGED
;OR IF ON HAND IS LESS THAN SAFETY STOCK

Query

 Inventry | ITEM  | PERIOD |  CHANGED   |
          | _ITEM | 1      | CHANGETO Y |
          |       |        |            |
          |       |        |            |

 Inventry |
          |
          |
          |

 Invref | ITEM  | ONHAND1 |
        | _ITEM | <0      |
        |       |         |
        |       |         |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"
@ 2,2
?? "cleared the negbalance routines"

Query

 Inventry | ITEM  | PERIOD |  CHANGED   |
          | _ITEM | 1      | CHANGETO Y |
          |       |        |            |
          |       |        |            |

 Inventry |
          |
          |
          |

 Invref | ITEM  | ONHAND1 | SS  |
        | _ITEM | <_SS    | _SS |
        |       |         |     |
        |       |         |     |

Endquery
dO_IT!
CLEARALL
DELETE "CHANGED"

@ 2,2
?? "cleared the second negative bal routines"

;TO ADD MASTER SCHEDULE INFORMATION TO THE INVENTRY DATABASE FOR THE 1ST RUN

;FIRST MUST ASSURE THAT IF THERE IS TWO OR MORE MASTER RECORDS FOR THE
;SAME ITEM FOR THE SAME TIME PERIOD, THAT WE SUM THEM HERE BEFORE WE
;ADD THE RECORDS TO INVENTRY IN THE NEXT QUERY

Query

 Mastschd |  ITEM  | DUEPERIOD |       QTY       |
          | Check  | Check     | CALC SUM UNIQUE |
          |        |           |                 |
          |        |           |                 |

Endquery
DO_IT!


CLEARALL

;HERE WE ADD THE MASTER SCHEDULE AMOUNTS TO THE INVENTRY RECORDS FOR THE
;PROPER PERIOD.

Query

 Inventry | ITEM  | PERIOD  |  CHANGED   |                GRREQ                 |
          | _ITEM | _PERIOD | CHANGETO Y | _OLDGREQ, CHANGETO _OLDGREQ + _GRREQ |
          |       |         |            |                                      |
          |       |         |            |                                      |

 Inventry |
          |
          |
          |

 Answer | ITEM  | DUEPERIOD | Sum of QTY |
        | _ITEM | _PERIOD   | _GRREQ     |
        |       |           |            |
        |       |           |            |

Endquery
DO_IT!

CLEARALL
DELETE "CHANGED"
DELETE "ANSWER"
@ 2,2
?? "cleared the add master schedule routines"

;SCHRADD.SC
; TO ADD THE SUM OF ALL OPEN SCHEDULED RECIEPTS (PO'S AND WORK ORDERS)
; TO THE INVENTRY FILE.

CLEARALL
Query

 Schrcpt |  ITEM  | PERIOD |       QTY       |
         | Check  | Check  | CALC SUM UNIQUE |
         |        |        |                 |
         |        |        |                 |

Endquery
DO_IT!

ClearALL
@ 2,2
?? "cleared the sum sched recpt routines"

; ADD THE SCHRECPT AMOUNT TO THE INVENTRY FILE FOR EACH PERIOD AND SET
; CHANGED FLAG FOR FUTURE NET CHANGE DETECTION

Query

 Inventry | ITEM  | PERIOD  |  CHANGED   |    SCHRECPT    |
          | _ITEM | _PERIOD | CHANGETO Y | CHANGETO _NEWS |
          |       |         |            |                |
          |       |         |            |                |

 Answer | ITEM  | PERIOD  | Sum of QTY |
        | _ITEM | _PERIOD | _NEWS      |
        |       |         |            |
        |       |         |            |

Endquery

Do_IT!
CLEARALL
DELETE "ANSWER"
DELETE "CHANGED"
@ 2,2
?? "cleared the add sched reciept routines"

play "netcalc"
