;NETCALC.SC

;THIS IS THE BRAINS OF THE PROGRAM
;IT GENERATES NET REQUIREMENTS FOR ALL INVENTORY ITEMS
;USING THE FORMULA. (SEE ORLICKEY PAGES 76 AND, FOR SS, PAGE 79)
;GROSS REQ - (SCH RECP + (ON HAND - SS)) = NET REQ

@ 14,2
?? "THE START TIME WAS "+STRVAL(TIME())

;SET INDEX TO GET US THROUGH THE FIRST LOOP FOR THE ORIGINAL MASTER SCHEDULE

STILL_REQUIREMENTS = True

;======================================================================
;THIS IS WHERE THE BIG LOOP STARTS FOR THE PROCESSING OF REQUIREMENTS.
;IT ENDS AT THE END OF THIS SCRIPT. NOTE: BIGINDEX IS JUST FOR UPDATING
;THE SCREEN TO TELL US HOW MANY LOOPS WE HAVE GONE THROUGH.
;======================================================================
BIGINDEX = 0

WHILE  STILL_REQUIREMENTS

BIGINDEX = BIGINDEX + 1
@ 2,2
?? "THE NUMBER OF TIMES WE HAVE GENERATED REQUIREMENTS IS "+STRVAL(BIGINDEX)

;============================================================================
;THIS IS THE INNER FOR-ENDFOR LOOP THAT DETERMINES THE NECESSARY
;PLANNED ORDERS FOR EACH ITEM THAT HAD IT'S REQUIREMENT CHANGED OR HAD IT'S
;ON HAND BALANCE ADJUSTED BY AN EARLIER LOOP.
;
; CMAX("BUCKET","PERIOD") CAUSES PARADOX TO FIND THE MAXIMUM VALUE IN THE
; PERIOD COLUMN IN THE BUCKET "TABLE" (DATAFILE). THIS SHOULD BE THE LAST
; POSSIBLE PERIOD FOR OUR MRP RUN.
;============================================================================

FOR PERIODINDEX
     FROM 1 TO CMAX("BUCKET","PERIOD")

@ 4,2
?? "I AM NOW WORKING ON PERIOD "+STRVAL(PERIODINDEX)

;THIS IS THE BEGINNING OF THE EXPLOSION LOOP FOR EACH PERIOD BASED ON THE
;CURRENT "MASTER SCHEDULE" POSTING (THE MASTER SCHEDULE CAN BE THE ORIGINAL
;TOP LEVEL MASTER SCHEDULE OR A LATER GROSS REQUIREMENTS BASED ON EXPLOSION.

Query

 Inventry |    PERIOD    | CHANGED | ONHAND | SCHRECPT | PLANRECPT | 
          | ~PERIODINDEX | Y       | _ONH   | _SCH     | _PLAN     | 
          |              |         |        |          |           | 
          |              |         |        |          |           | 

 Inventry | GRREQ  | SS  |                    NETREQ                     | 
          | _GROSS | _SS | changeto _GROSS-(_SCH + _PLAN + (_ONH - _SS)) | 
          |        |     |                                               | 
          |        |     |                                               | 

 Inventry | 
          | 
          | 
          | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;CHECK TO SEE IF THE NET REQUIREMENTS ARE NEGATIVE
;IF SO, SET THEM BACK TO ZERO

Query

 Inventry |    PERIOD    | CHANGED |     NETREQ     |
          | ~PERIODINDEX | Y       | <=0,CHANGETO 0 |
          |              |         |                |
          |              |         |                |

 Inventry |
          |
          |
          |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;HERE WE CALCULATE PLANNED ORDERS BASED ON PLANNED SCHEDULED RECIEPTS
;FROM THE ABOVE RESULTS.

;THE LEADTIME OFFSETS ARE BASED ON THE DATA IN THE LEADTIME FIELDS
; NOTE THAT RM'S HAVE LEADTIMES IN WEEKS
;           FG'S AND WIP USE THE HRS PER UNIT TO PRODUCE
; THIS RESULTS IN A FUNNY ROUTINE TO GET ROUND UP TO AN INTEGER FOR THE
; PERIOD

;POST NON-RM NET REQUIREMENTS TO A PLANNED RECIEPTS FILE

Query

 Inventry | ITEM  |    PERIOD    | CHANGED |   NETREQ   | 
          | _ITEM | ~PERIODINDEX | Y       | >0,_NETREQ | 
          |       |              |         |            | 
          |       |              |         |            | 

 Inventry | LEADTIME  |  TYPE  | 
          | _LEADTIME | not RM | 
          |           |        | 
          |           |        | 

 Planrcpt | ITEM  |  DUEPERIOD   |   QTY   |                 LAUNCHPERIOD                  | 
 INSERT   | _ITEM | ~PERIODINDEX | _NETREQ | ~PERIODINDEX -((_LEADTIME*_NETREQ)/(40*4.33)) | 
          |       |              |         |                                               | 
          |       |              |         |                                               | 

 Planrcpt | 
          | 
          | 
          | 

Endquery
DO_IT!
CLEARALL
DELETE "INSERTED"

;POST RM NET REQUIREMENTS TO A PLANNED RECIEPTS FILE

Query

 Inventry | ITEM  |    PERIOD    | CHANGED |   NETREQ   | 
          | _ITEM | ~PERIODINDEX | Y       | >0,_NETREQ | 
          |       |              |         |            | 
          |       |              |         |            | 

 Inventry | LEADTIME  | TYPE | 
          | _LEADTIME | RM   | 
          |           |      | 
          |           |      | 

 Planrcpt | ITEM  |  DUEPERIOD   |   QTY   |          LAUNCHPERIOD          | 
 INSERT   | _ITEM | ~PERIODINDEX | _NETREQ | ~PERIODINDEX -(_LEADTIME/4.33) | 
          |       |              |         |                                | 
          |       |              |         |                                | 

 Planrcpt | 
          | 
          | 
          | 

Endquery
DO_IT!
CLEARALL

DELETE "INSERTED"

;CHANGE NEGATIVE OR SHORT DATED PLANNED ORDERS TO PERIOD 1
;AND SET THE PASTDUE ID

Query

 Planrcpt | LAUNCHPERIOD  | PASTDUEID  |
          | <1,CHANGETO 1 | CHANGETO 1 |
          |               |            |
          |               |            |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;FIX THE ROUNDING PROBLEM WITH THE LAUNCHPERIOD FIELD SO THAT IT IS AN
;INTEGER

Query

 Planrcpt |        LAUNCHPERIOD        |
          | >_LOW,<_HIGH,CHANGETO _LOW |
          |                            |
          |                            |

 Rounder | LOWLIMIT | UPLIMIT |
         | _LOW     | _HIGH   |
         |          |         |
         |          |         |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;POST LAUNCH DATES TO THE PLANNED ORDERS FILE

Query

 Planrcpt | LAUNCHPERIOD |     LAUNCHDATE      |
          | _PERIOD      | CHANGETO _STARTDATE |
          |              |                     |
          |              |                     |

 Bucket | PERIOD  | STARTDATE  |
        | _PERIOD | _STARTDATE |
        |         |            |
        |         |            |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;POST DUE DATES TO PLANNED ORDER FILE

Query

 Planrcpt | DUEPERIOD |       DUEDATE       |
          | _PERIOD   | CHANGETO _STARTDATE |
          |           |                     |
          |           |                     |

 Bucket | PERIOD  | STARTDATE  |
        | _PERIOD | _STARTDATE |
        |         |            |
        |         |            |

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;POST PLANNED RECEIPTS BACK TO THE INVENTORY MASTER FILE
;FOR THIS PERIOD (THE ONLY RECIEPTS IN THE FILE SHOULD BE DUE(!) THIS
;PERIOD.

Query

 Inventry | ITEM  |    PERIOD    |                PLANRECPT                | 
          | _ITEM | ~PERIODINDEX | _OLDPLAN, CHANGETO _OLDPLAN + _PLANRCPT | 
          |       |              |                                         | 
          |       |              |                                         | 

 Inventry | 
          | 
          | 
          | 

 Planrcpt | ITEM  |  DUEPERIOD   |    QTY    | 
          | _ITEM | ~PERIODINDEX | _PLANRCPT | 
          |       |              |           | 
          |       |              |           | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;POST PLANNED LAUNCH OF ORDERS TO THE PLANNED RELEASE FIELD FOR THE PROPER
;PERIOD

Query

 Inventry | ITEM  |    PERIOD     |               PLANREL               | 
          | _ITEM | _LAUNCHPERIOD | _OLDREL, CHANGETO _NEWREL + _OLDREL | 
          |       |               |                                     | 
          |       |               |                                     | 

 Inventry | 
          | 
          | 
          | 

 Planrcpt | ITEM  |  DUEPERIOD   |   QTY   | LAUNCHPERIOD  | 
          | _ITEM | ~PERIODINDEX | _NEWREL | _LAUNCHPERIOD | 
          |       |              |         |               | 
          |       |              |         |               | 

 Planrcpt | 
          | 
          | 
          | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;SINCE WE HAVE CHANGED THE EXPECTED ENDING BALANCE FOR THE INVENTORY ITEMS
;THAT HAD EITHER NEW GROSS REQUIEREMENTS OR A PLANNED RECIEPT FOR THE
;PERIOD (THE VARIABLE PERIODINDEX  FOR THIS LOOP),
;WE MUST UPDATE THE BEGINNING BALANCE FOR THE NEXT PERIOD IN THE FUTURE.
;WE DO NOT NEED TO UPDATE THE BALANCES MORE THAN ONE OUT SINCE WE WILL
;GET TO THEM AS THE PERIODINDEX LOOPS OUT.
;WHEN WE REACH THE LAST PERIOD, THE QUERY SHOULD FIND NOTHING TO CHANGE
;EVEN THOUGH IT SHOULD TRY TO MATCH TO A NON-EXISTENT RECORD.

Query

 Inventry | ITEM  |     PERIOD     |  CHANGED   |             ONHAND              | 
          | _ITEM | ~PERIODINDEX   | Y          | _BI1                            | 
          | _ITEM | ~PERIODINDEX+1 | CHANGETO Y | CHANGETO _BI1+_SCH1+_PLAN1-_GR1 | 
          |       |                |            |                                 | 

 Inventry | SCHRECPT | PLANRECPT | GRREQ | 
          | _SCH1    | _PLAN1    | _GR1  | 
          |          |           |       | 
          |          |           |       | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

;WE WANT TO ELIMINATE THOSE ITEMS THAT WE PROCESSES IN THIS LOOP OF THE
;MRP PROCESSOR. FOR NOW, WE WILL SET THE ITEMS "CHANGED" FLAG TO BLANK SINCE
;THE GROSS OHBAL ETC NOW COVER REQUIREMENTS. IF A FUTURE EXPLOSION, SETS UP
;NEW REQUIREMENTS FOR THESE ITEMS, THE EXPLOSION WILL RESET THE CHANGED FLAG
;TO "Y" AND WE WILL REPROCESS THE RECORD. THIS LOGIC IS PART OF THE NET
;CHANGE MRP LOGIC. BASICALLY, YOU ONLY ATTEMPT TO PROCESS THOSE RECORDS THAT
;CHANGED DURING THE LAST LOOP. HOPEFULLY, YOU CAN CUT YOUR PROCESSING TIME
;DRAMATICALLY AFTER THE FIRST FEW ITERATIONS.

;THIS QUERY ALSO SETS THE NET REQUIRMENTS BACK SO THAT IT "LOOKS" RIGHT BY
;NOT INCLUDING THE PLANNED RECIEPTS. IF WE DIDN'T DO THIS THE NET REQUIRED
;WOULD BE ZERO OR ELSE THE NET AMOUNT BEFORE WE ENTERED A PLANNED ORDER TO 
;COVER A POTENTIAL SHORTAGE.

Query

 Inventry |    PERIOD    |     CHANGED      | ONHAND | SCHRECPT | 
          | ~PERIODINDEX | Y,CHANGETO BLANK | _ONH   | _SCH     | 
          |              |                  |        |          | 
          |              |                  |        |          | 

 Inventry | GRREQ  | SS  |                NETREQ                 | 
          | _GROSS | _SS | CHANGETO _GROSS - (_SCH + (_ONH-_SS)) | 
          |        |     |                                       | 
          |        |     |                                       | 

 Inventry | 
          | 
          | 
          | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

Query

 Inventry |     NETREQ     | 
          | <=0,CHANGETO 0 | 
          |                | 
          |                | 

Endquery
DO_IT!
CLEARALL
DELETE "CHANGED"

; FOR PROCESSING EFFICIENCY, MOVE THE POSTED PLANNED RECIEPTS TO A HOLDING
; FILE (ALLPLANR) AND CLEAN OUT THE PLANNED RECIEPTS WORK FILE (PLANRCPT).
; NOTE: WE WILL DUMP ALLPLANR TO FINALPLN AT THE END OF THE EXPLOSION OF
; ALL PERIODS FOR THIS ROUND WITH THE FIRST MASTER SCHEDULE

;WHEN THE VARIABLE PERIODINDEX = THE MAXIMUM PERIOD THEN ALLPLAN REPRESENTS
;ALL THE NEEDED PLANNED ORDERS TO MAKE THE CURRENT MASTER SCHEDULE. WE THEN
;MUST RELOAD THESE PLANNED ORDERS TO PLAN LOWER LEVEL COMPONENTS. ULTIMATELY,
;WHEN WE DON'T ADD ANY NEW RECORDS TO THE ALLPLANR FILE AFTER CHECKING ALL
;PERIODS, THEN WE ARE FINISHED. ALL THE CHANGED INVENTRY RECORDS GROSS
;REQUIREMENTS CAN BE COVERED BY THE PLANNED INVENTORY BALANCE AND SCHEDULED
;AND PLANNED RECEIPTS.

;I USED NET CHANGE LOGIC, SEE ORLICKY PAGE 115 TO DO THE EXPLOSION. IT IS
;A LITTLE TRICKY KEEPING TRACK OF WHETHER AN INVENTORY RECORD WAS "CHANGED"
;BUT, ACCORDING TO ORLICKY, WITH NET CHANGE LOGIC, YOU DO NOT NEED LOWER
;LEVEL CODING IN YOUR BILL OF MATERIAL. SINCE PHOTODYNE DOESN'T INCLUDE
;LEVELS IN THE BOM, THIS APPEARED TO BE THE ONLY WAY TO GO.

;PUT THIS PERIOD'S PLANNED ORDERS IN AN INTERMEDIATE HOLDING FILE

ADD "PLANRCPT" "ALLPLANR"
EMPTY "PLANRCPT"

Query

 Inventry | CHANGED |
          | Check Y |
          |         |
          |         |

Endquery
DO_IT!
CLEARALL

IF ISEMPTY("ANSWER")
    THEN PERIODINDEX = CMAX("BUCKET","PERIOD") + 1
ENDIF
DELETE "ANSWER"
;============================================================================
;HERE IS THE END OF THE LOOP FOR THIS PASS USING THE CURRENT "MASTER SCHEDULE"
;WE GENERATED A NEW "MASTERSCHEDULE" IN "ALLPLANR" AND RETURN TO THE TOP TO
;POST NEW GROSS REQUIREMENTS TO COMPONENT RECORDS. WE ARE LOOPING HERE UNTIL
;WE GET TO THE LAST PERIOD FOR THIS ITERATION.
;============================================================================

ENDFOR

@ 6,2
?? "THE INVENTRY FILE CONTAINS "+STRVAL(NRECORDS("INVENTRY"))+" RECORDS"
@ 8,2
?? "THE PLANRCPT FILE CONTAINS "+STRVAL(NRECORDS("PLANRCPT"))+" RECORDS"
@ 10,2
?? "THE ALLPLANR FILE CONTAINS "+STRVAL(NRECORDS("ALLPLANR"))+" RECORDS"
@ 12,2
?? "THE FINALRCT FILE CONTAINS "+STRVAL(NRECORDS("FINALRCT"))+" RECORDS"

;=============================================================================
;HERE IS THE FINAL LOOP TEST. ONCE WE HAVE NO NEW REQUIREMENTS IN THE ALLPLANR
;FILE, WE ARE DONE.
;=============================================================================

IF ISEMPTY("ALLPLANR")
    THEN STILL_REQUIREMENTS = False
    QUITLOOP
ENDIF

;RUN THE EXPLOSION SCRIPT TO GENERATE NEW REQUIREMENTS FOR THE 
;PLANNED ORDERS GENERATED DURING THIS LOOP.

PLAY "EXPLODE"

ENDWHILE

BEEP
@ 16,2
?? "THE END TIME FOR THE MRP RUN WAS "+STRVAL(TIME())

CLEARALL
PLAY "MRPFORM"
@ 18,2
?? "THE END TIME FOR LOADING RESULTS INTO MRP TABLE WAS "+STRVAL(TIME())
