;This file is copyright (c) 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : Procedure Money
;Source File     : MONEY.SC
;Author          : Christopher M Reid
;                  Insight Research
;                  P O Box 73001
;                  Davis, CA  95617
;                  (916) 758-4945
;
;Informant Issue : June 1991
;
;Description     : Procedure that converts numbers to words for check printing
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740


PROC Money(amount,lngth)

   PRIVATE nums, tens, teens,
           amount, cents, dashes, gopast1, gopast2, i,
           lngth, moneystr, n, n2, posit, rs

   ARRAY nums[10]
   nums[1]  = ""
   nums[2]  = "one"
   nums[3]  = "two"
   nums[4]  = "three"
   nums[5]  = "four"
   nums[6]  = "five"
   nums[7]  = "six"
   nums[8]  = "seven"
   nums[9]  = "eight"
   nums[10] = "nine"

   ARRAY tens[10]
   tens[1]  = ""
   tens[2]  = "one"
   tens[3]  = "twenty"
   tens[4]  = "thirty"
   tens[5]  = "forty"
   tens[6]  = "fifty"
   tens[7]  = "sixty"
   tens[8]  = "seventy"
   tens[9]  = "eighty"
   tens[10] = "ninety"

   ARRAY teens[10]
   teens[1]  = "ten"
   teens[2]  = "eleven"
   teens[3]  = "twelve"
   teens[4]  = "thirteen"
   teens[5]  = "fourteen"
   teens[6]  = "fifteen"
   teens[7]  = "sixteen"
   teens[8]  = "seventeen"
   teens[9]  = "eighteen"
   teens[10] = "nineteen"

   rs       = ""
   gopast1  = "N"
   gopast2  = "N"
   moneystr = STRVAL(amount);
   cents    = SUBSTR(moneystr,LEN(moneystr)-1,2)

   FOR i FROM 1 TO (LEN(moneystr) - 3)

      posit = LEN(moneystr) - i + 1
      n     = NUMVAL(SUBSTR(moneystr,i,1))
      n2    = NUMVAL(SUBSTR(moneystr,i+1,1))

      SWITCH

         CASE posit = 9 :
            rs = rs + nums[n+1] + " hundred "

         CASE posit = 8 :
            IF n <> 0
              THEN IF n = 1
                     THEN rs = rs + teens[n2+1] + " "
                          gopast1 = "Y"
                     ELSE rs = rs + tens[n+1]
                   ENDIF
            ENDIF

         CASE posit = 7 :
            IF (n <> 0) and (gopast1 = "N")
              THEN IF i <> 1
                     THEN rs = rs + "-"
                   ENDIF
                   rs = rs + nums[n+1] + " "
            ENDIF
            rs = rs + "thousand "

         CASE posit = 6 :
            IF n <> 0
              THEN rs = rs + nums[n+1] + " hundred "
            ENDIF

         CASE posit = 5 :
            IF n <> 0
              THEN IF n = 1
                     THEN rs = rs + teens[n2+1] + " "
                          gopast2 = "Y"
                     ELSE rs = rs + tens[n+1]
                   ENDIF
            ENDIF

         CASE posit = 4 :
            IF (n <> 0) and (gopast2 = "N")
              THEN IF i <> 1
                     THEN rs = rs + "-"
                   ENDIF
                   rs = rs + nums[n+1] + " "
            ENDIF
            rs = rs + "dollars and "

      ENDSWITCH

   ENDFOR

   rs     = rs + cents + "/100 "
   dashes = lngth - LEN(rs)

   FOR i FROM 1 TO dashes
      rs = rs + "-"
   ENDFOR

   RETURN(rs)

ENDPROC
