;******************************************************************************
; mocalc() -- calculates an ending date given a starting date and a number of
;   months from that starting date.  Accommodates leap years but not leap
;   centuries.
;               Copyright (c) 1992, The Codecrafters Guild.
;   Permission is granted to freely use this procedure as long as the above
; copyright notice is retained in the code and any written documentation
; incorporates the sense of: "Portions of this code Copyright 1992, The Code-
; crafters Guild".
;
;   Upl by author: Rich Shepard [73557,2367] on 10/14/92.
;******************************************************************************

proc mocalc(sdate,nmonths)
  private sdate,                  ; period start date
          nmonths,                ; period duration
          ndx,                    ; where to enter the days/month array
          i

  ndx = month(sdate)

  array dpm[12]                     ; days per month
  dpm[1] = 31
  dpm[2] = 28
  dpm[3] = 31
  dpm[4] = 30
  dpm[5] = 31
  dpm[6] = 30
  dpm[7] = 31
  dpm[8] = 31
  dpm[9] = 30
  dpm[10] = 31
  dpm[11] = 30
  dpm[12] = 31
  if (mod(year(sdate),4)=0) then    ; leap year
    dpm[2] = 29
  endif

  edate = sdate + dpm[ndx] - 1      ; number of days in starting month
  for i from 1 to (nmonths - 1)     ; accumulate days for period duration
    if (mod(year(edate),4)=0) then  ; leap year
      dpm[2] = 29
    else
      dpm[2] = 28
    endif
    ndx = ndx + 1
    if (ndx <= 12) then             ; still in array range
      edate = edate + dpm[ndx]      ; add succeeding months
    else                            ; we've reached the array's end so,
      ndx = 1                       ; roll over to beginning of array
      edate = edate + dpm[ndx]
    endif
  endfor
  return edate                      ; calculated ending date
endproc
