;multiline() enables Paradox programmers to print several lines
;of text to the screen or a printer with full word wrap capabilities.
;This program accepts three parameters: the variable to be word-wrapped,
;which line number we wish to print, and the width of that line number.
;To print out lines 1-4 of a character field with a width of 240 
;(and assuming line lengths of 60) one would do the following:
;
;		? multiline(var_to_be_printed,1,60)
;		? multiline(var_to_be_printed,2,60)
;		? multiline(var_to_be_printed,3,60)
;		? multiline(var_to_be_printed,4,60)
;
;Or, to save typing, put the above command in a for loop and,
;well, you get the idea. This command will return "" for any
;line number and line width combinations that exceed the variable
;length. So to tell if you're done displaying the variable, you
;might want to check multiline() to see if it has returned "".
;If the line length is too short and there aren't any spaces to
;word wrap on, multiline() will split the long (or short) word
;between two lines. Heck, if someone wants to display 
;"Evangelical anti-establishement consolidators wreaking
;destruction" on lines with a width of 5 characters, then 
;multiline() won't save you. I do not presume multiline() will
;detect programmer ignorance, laziness or bad housekeeping.
;
; Have fun!    Vince Kellen

; ---------------------------------------------------------------------------
; multiline() returns a line from a long character field without
; breaking in the middle of a word - used for simulating word-wrapping
; ---------------------------------------------------------------------------
proc multiline(var,line,width)
	private	procname,
			var,          ; the character string to evaluate
			line,         ; which line number we want
			width,        ; the width of the line
			start,        ; used to keep track of where we're at in var
			offset,       ; used to keep track of where we're at in width
			t_line,       ; keeps count of what line# we're examining
			c             ; holds the current character we're examining

	procname = "multiline"

	If IsBlank(var) Or SubStr(Type(var),1,1)<>"A" Then
		Return ""
	EndIf

	t_line = 0
	offset = 0
	start  = 0

	While t_line<>line         ; stop as soon as we're on the line we want

		; set the starting position to be 1 character ahead of
		; where we last left off
		start  = start + offset + 1

		; set the offset from the start position
		; we will work backward from the start position
		offset = width - 1

		While True

			; get the character to examine
			c=SubStr(var,start+offset,1)

   			; if it is empty or a space, we've reached an end of word
			If c=" " Or c="" Then
				QuitLoop
			EndIf

			; decrement the offset counter so we can examine the
			; next character, moving from right to left
			offset = offset - 1

			; if offset < 0  then there are no word breaks in the
			; line, therefore we must return the whole line
			If offset  < 0 Then
				offset = width - 1
				QuitLoop
			EndIf

		EndWhile

		; increment the temporary line counter
		t_line = t_line + 1

	EndWhile

	; this if statment works to truncate the last space of the line
	; if the last char is not a space, make sure we include it
	If SubStr(var,start+offset,1)<>" " Then
		offset=offset+1
	EndIf

	Return SubStr(var, start, offset)

Endproc
