
Clear Reset
Release Vars  All
libname = "mp_lib3"
Message "Building ", libname
CreateLib libname Size 50

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Copyright_1992_William_Mekeel()
    copyright.a = "   Copyright (c) 1992 William Mekeel  All Rights Reserved   "
    version.a   = "   MENUPAL version 1.00  "
EndProc

WriteLib libname   copyright_1992_William_Mekeel
Release  Procs     copyright_1992_William_Mekeel

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_reorder_mp_box.u(application_name.p,offset.p)
    Private mp_procname.a

    mp_procname.a = "mp_reorder_mp_box.u"

    Array ord_old[cmax("mp_box","box_no")]

    MoveTo [mp_box->application_name]

    Locate application_name.p
    If Not RetVal Then
        mp_error_in_retval.u(0124)
    EndIf

    While [application_name] = application_name.p
        And Not Eot()
        offset.p = offset.p + 1
        ord_old[[box_no]] = offset.p
        Skip
    EndWhile

EndProc

WriteLib libname mp_reorder_mp_box.u
Release  Procs   mp_reorder_mp_box.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_reorder2.u(application_name.p,table.p)
    Private mp_procname.a
    ,seq_no_value.n

    mp_procname.a = "mp_reorder2.u"

    MoveTo table.p

    MoveTo [application_name]
    Locate application_name.p
    If Not RetVal Then
        mp_error_in_retval.u(0100)
    EndIf

    seq_no_value.n = 0

    While [application_name] = application_name.p
        And Not Eot()
        If IsBlank([seq_no])  Then
            seq_no_value.n          = seq_no_value.n + 1
            [seq_no]                = seq_no_value.n

            If table.p         = "mp_line" Then
                If Not IsBlank([child_box_no]) Then
                    [child_box_no]  = ord_old[[child_box_no]]
                EndIf
            Else
                If [parent_box_no] > 0 Then
                    [parent_box_no] = ord_old[[parent_box_no]]
                EndIf
            EndIf

            If [box_no] = ord_old[[box_no]] Then
                Skip
            Else
                [box_no] = ord_old[[box_no]]
                Skip 0
            EndIf

        Else
            Skip
        EndIf

    EndWhile

    mp_clear_seq_no.u(application_name.p,table.p)

EndProc

WriteLib libname mp_reorder2.u
Release  Procs   mp_reorder2.u

;***********************************************

Proc mp_clear_seq_no.u(application_name.p,table.p)
    Private mp_procname.a
    ,blank_num

    mp_procname.a = "mp_clear_seq_no.u"

    MoveTo table.p
    MoveTo [application_name]
    Locate application_name.p
    If RetVal Then
        blank_num = BlankNum()
        MoveTo [seq_no]
        While [application_name] = application_name.p
            And Not Eot()
            If Not IsBlank([seq_no])  Then
                [] = blank_num
            EndIf
            Skip
        EndWhile
    EndIf

EndProc

WriteLib libname mp_clear_seq_no.u
Release  Procs   mp_clear_seq_no.u

;***********************************************

Proc mp_reorder3.l(application_name.p,append_application_name.p,table.p)
    Private mp_procname.a
    ,temp1.r

    mp_procname.a = "mp_reorder3.l"

    MoveTo  table.p

    MoveTo [application_name]
    Locate append_application_name.p

    If Not RetVal Then        ;this application may not have an mct
        Canvas On
        Message "No records found for ",append_application_name.p," in table ",table.p
        Beep
        Sleep 2000
        Return False
    EndIf

    While [application_name] = append_application_name.p
        And Not Eot()

        CopyToArray temp1.r
        temp1.r["Application_name"] = application_name.p
        temp1.r["Box_no"]           = ord_old[[box_no]]

        If table.p = "mp_line" Then
            If Not IsBlank([child_box_no]) Then
                temp1.r["Child_box_no"]     = ord_old[[child_box_no]]
            EndIf
        Else
            If [parent_box_no] > 0 Then
                temp1.r["Parent_box_no"]    = ord_old[[parent_box_no]]
            Else
                temp1.r["Parent_box_no"]    = BlankNum()
                temp1.r["Action_box"]       = ""      ;clear [action_box]
            EndIf
        EndIf

        Ins
        CopyFromArray temp1.r

        skip 0     ;post record

        if [application_name] = append_application_name.p then
           Skip
        else
           skip 2
        endif

    EndWhile

    Return True

EndProc

WriteLib libname mp_reorder3.l
Release  Procs   mp_reorder3.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  Closed mp_make_reports.l()
    UseVars AutoLib

    mp_procname.a = "mp_make_reports.l"

    ErrorProc = "mp_error_proc.n"
    ReadLib "mp_drive" mp_error_proc.n

    l=mp_make_reports_1.l()
    if not l then
        Return false
    endif

    l=mp_make_reports_2.l()
    if not l then
        Return false
    endif

    Return True

EndProc

WriteLib libname mp_make_reports.l
Release Procs    mp_make_reports.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_make_reports_1.l()

    mp_procname.a = "mp_make_reports_1.l"

    mp_message_24.u(True,True," Building Report Control Screen",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    View "mp_sys"
    setpopup2("mp_sys","application_name",0)

    If Not IsEmpty("mp_rept") Then
        Empty "mp_rept"
    EndIf

    CoEdit "mp_rept"

    While True

        PickForm "F"

        Prompt " [F2]->Do_it [F6]->List",
        " [Esc]->Quit"

        Wait Record
        Until "f6"
        ,-24    ;alt o
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,15     ;ctrl o
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,"f2"
        ,"esc"

        Switch
            Case RetVal = "f2" :
                If  IsBlank([application_name]) Then
                    Message "Application name is a required field"
                    MoveTo [application_name]
                    Beep Sleep 1000
                    Loop
                Else
                    MoveTo [mp_sys->application_name]
                    Locate [mp_rept->application_name]
                    MoveTo [mp_rept->application_name]
                    If Not RetVal Then
                        Message "Application name not found"
                        Beep Sleep 1000
                        Loop
                    EndIf
                EndIf

                If  IsBlank([output_device]) Then
                    Message "Output Device is a required field"
                    MoveTo [output_device]
                    Beep  Sleep 1000
                    Loop
                Else
                    If  [output_device] = "F" Then
                        If IsBlank([directory]) Then
                            Message "Directory is a required field"
                            MoveTo [directory]
                            Beep Sleep 1000
                            Loop
                        Else
                            n = DirExists([directory])
                            If n=1 Then
                                ;ok
                            Else
                                If n=0 Then
                                    Message "Directory does not exist"
                                    MoveTo [directory]
                                    Beep Sleep 1000
                                    Loop
                                Else
                                    Message "Invalid path"
                                    MoveTo [directory]
                                    Beep Sleep 1000
                                    Loop
                                EndIf
                            EndIf
                        EndIf
                    EndIf
                EndIf

                l=do_it(mp_procname.a,01)
                If Not l Then
                    Return False
                EndIf
                QuitLoop

            Case RetVal = "esc" :
                Menu {undo} {yes}
                l=do_it(mp_procname.a,02)
                Return False

            Case RetVal = "f6" :
                selection = Popup2(06,60,9,1,"Applications")
                If Not IsBlank(selection) Then
                    [application_name] = selection
                EndIf

             otherwise :
                beep

        EndSwitch

    EndWhile

    Return True

EndProc

WriteLib libname mp_make_reports_1.l
Release Procs    mp_make_reports_1.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_make_reports_2.l()

    mp_procname.a = "mp_make_reports_2.l"

    Cursor Off

    mp_message_24.u(True,True," Building Report Selection Screen",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    application_name.a = [application_name]
    output_device.a    = [output_device]
    directory.a        = [directory]
    directory_len.n    = len(directory.a)
    if substr(directory.a,directory_len.n,1) <> "\\" then
       directory.a     = directory.a+"\\"
    endif

    ClearImage

    coedit "mp_util"
    [application_name] = application_name.a
    do_it!

    l = mp_checkbox_driver_1.u("f",7,"mp_rept.hlp")
    If Not l Then
        Return False
    EndIf

    check_1.a = [check_1]
    check_2.a = [check_2]
    check_3.a = [check_3]
    check_4.a = [check_4]
    check_5.a = [check_5]
    check_6.a = [check_6]
    check_7.a = [check_7]

    If  check_1.a = "X"
        Or  check_2.a = "X"
        Or  check_3.a = "X"
        Or  check_4.a = "X" Then
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_message_24.u(True,True," Extracting Report data",79)

        l=mp_extract_mp_line2_dd.l(application_name.a)
        If Not l Then
            Return False
        EndIf

    EndIf

    If  check_1.a = "X"
        Or  check_2.a = "X" Then
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_message_24.u(True,True," Processing Box Report data",79)

        View "mp_box"
        View "entry998"
        View "mp_line"

        Array marker[Cmax("entry998","box_no")]

        current_row = 1

        If Not IsEmpty("entry998") Then
            Empty "entry998"
        EndIf

        CoEditKey

        ;build box tree
        max_key_length = mp_build_tree_keys.n(application_name.a,65,1)
        mp_build_tree_diag.u(0,NRecords("entry998"),max_key_length,1)

        l=do_it(mp_procname.a,03)
        If Not l Then
            Return False
        EndIf
    EndIf

    If  check_1.a = "X" Then
        mp_message_24.u(True,True," Building Box Tree Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_report_out.u(output_device.a,"entry998","R",directory.a,application_name.a,"RP1")
    EndIf

    If  check_2.a = "X" Then
        mp_message_24.u(True,True," Building Box Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        l=mp_box_report.l(application_name.a)
        If l Then
            mp_report_out.u(output_device.a,"answer","R",directory.a,application_name.a,"RP2")
        EndIf
    EndIf

    If  check_3.a = "X" Then
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_message_24.u(True,True," Processing Line Report Data",79)

        max_key_length = mp_build_tree_keys_2.n()
        mp_build_tree_diag.u(0,NRecords("entry998"),max_key_length,1)

        l=do_it(mp_procname.a,04)
        If Not l Then
            Return False
        EndIf

        mp_message_24.u(True,True," Building Line Tree Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        mp_report_out.u(output_device.a,"entry998","1",directory.a,application_name.a,"RP3")

    EndIf

    If  check_4.a = "X" Then
        mp_message_24.u(True,True," Building Line Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        CoEdit "entry999"

        Scan   For Substr([literal],1,1) = "-"
            Del
        EndScan

        l=do_it(mp_procname.a,05)
        If Not l Then
            Return False
        EndIf

        CopyReport "mp_line2" "R" "entry999" "R"

        mp_report_out.u(output_device.a,"entry999","R",directory.a,application_name.a,"RP4")

        Canvas On
    EndIf

    If  check_5.a = "X" Then
        mp_message_24.u(True,True," Building Splash Screen Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        l=mp_splash_screen_report.l(application_name.a)
        If l Then
            mp_report_out.u(output_device.a,"answer","R",directory.a,application_name.a,"RP5")
        EndIf
    EndIf

    If  check_6.a = "X" Then
        mp_message_24.u(True,True," Building Options Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        l=mp_options_report.l(application_name.a)
        If l Then
            mp_report_out.u(output_device.a,"answer","R",directory.a,application_name.a,"RP6")
        EndIf
    EndIf

    If  check_7.a = "X" Then
        mp_message_24.u(True,True," Building Color Report",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

        l=mp_colors_report.l(application_name.a)
        If l Then
            mp_report_out.u(output_device.a,"answer","R",directory.a,application_name.a,"RP7")
        EndIf
    EndIf

    ClearAll

    Return True

EndProc

WriteLib libname mp_make_reports_2.l
Release Procs    mp_make_reports_2.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_extract_mp_line2_dd.l(application_name.p)
    Private mp_procname.a

    mp_procname.a = "mp_extract_mp_line2_dd.l"

    View "mp_util"
    View "mp_line"
    View "mp_box"

    l=mp_load_mp_box2.l(application_name.p)
    If Not l Then
        Return False
    EndIf

    CoEditKey

    l = mp_build_tree.l(application_name.p,False,True,"mp_box")
    If Not l Then
        Return False
    EndIf

    n=mp_condition_temp_table.n()

    If n=0 Then
        Return False
    EndIf
    l=mp_extract_mct.l(application_name.p)

    Return True

EndProc

WriteLib libname mp_extract_mp_line2_dd.l
Release  Procs   mp_extract_mp_line2_dd.l

;**************************************************

Proc mp_extract_mct.l(application_name.p)
    Private mp_procname.a
    ,applname

    mp_procname.a = "mp_extract_mct.l"

    applname = application_name.p

Query

     entry998 | Box_no |
              | _boxno |

     mp_line | Application_name | Box_no           | Line_no  |  Literal  |
             |  ~applname       | checkplus _boxno |checkplus | checkplus |

     mp_line | Cursor_ptr | Child_box_no | Help_msg  |
             | checkplus  | checkplus    | checkplus |

     mp_line | Shortcut_ascii_code | Hot_key_position |
             | checkplus           | checkplus        |

     mp_line | Clear_display | Recycle_menu |
             | checkplus     | checkplus    |

     mp_line | exec_proc_in_test | Execute_proc |
             | checkplus         | checkplus    |

     mp_line | initial_state | release_vars | form_proc |
             | checkplus     | checkplus    | checkplus |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "entry998(q)"
    ClearImage
    MoveTo "mp_line(q)"
    ClearImage

    If IsTable("entry999") Then
        Delete "entry999"
    EndIf

    Rename "answer" "entry999"

    Return True

EndProc

WriteLib libname mp_extract_mct.l
Release  Procs   mp_extract_mct.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_box_report.l(application_name.p)
    Private mp_procname.a
    ,applname

    mp_procname.a = "mp_box_report.l"

    applname = application_name.p

Query

     mp_box | Application_name    | Box_no    | seq_no    | Parent_box_no | box_alias |
            | Checkplus ~applname | Checkplus | Checkplus | Checkplus     | checkplus |

     mp_box | Box_entry_proc | Build_box_entry_proc_stub | Box_depart_proc |
            | Checkplus      | Checkplus                 | Checkplus       |

     mp_box | Build_depart_proc_stub | Action_box |
            | Checkplus              | Checkplus  |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_box(q)"
    ClearImage

    Menu {Tools} {Copy} {Report} {DifferentTable} {mp_box} {R} {ANSWER}
    {R} Menu {Scripts} {End-Record}

    Return True

EndProc

WriteLib libname mp_box_report.l
Release Procs    mp_box_report.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_splash_screen_report.l(application_name.p)
    Private mp_procname.a
    ,applname

    mp_procname.a = "mp_splash_screen_report.l"

    applname = application_name.p

Query

 mp_splsh | Application_name    | Literal_1 | Literal_2 | Literal_3 |
          | Checkplus ~applname | Checkplus | Checkplus | Checkplus |

 mp_splsh | Literal_4 | Literal_5 | Literal_6 |
          | Checkplus | Checkplus | Checkplus |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_splsh(Q)"
    ClearImage

    Menu {Tools} {Copy} {Report} {DifferentTable} {mp_splsh} {R} {ANSWER}
    {R} Menu {Scripts} {End-Record}

    Return True

EndProc

WriteLib libname mp_splash_screen_report.l
Release Procs    mp_splash_screen_report.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_options_report.l(application_name.p)
    Private mp_procname.a
    ,applname

    mp_procname.a = "mp_options_report.l"

    applname = application_name.p

Query

     mp_sys | Application_name    | Checkbox | Capitalize_style_sw | Box_band_char |
            | checkplus ~applname | checkplus    | checkplus       | checkplus     |

     mp_sys | Line_attach_pt | Box_vert_overlap | Box_horiz_overlap |
            | checkplus      | checkplus        | checkplus         |

     mp_sys | Bar_horiz_overlap | Use_help_messages | Overwrite_second_line |
            | checkplus         | checkplus         | checkplus         |

     mp_sys | initial_splash_screen | splash_screen_delay | exec_proc_in_test |
            | checkplus             | checkplus           | checkplus |

     mp_sys | release_vars | clear_display | recycle_menu | Autolibs  |
            | checkplus    | checkplus     | checkplus    | checkplus |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_sys(q)"
    ClearImage

    Menu {Tools} {Copy} {Report} {DifferentTable} {mp_sys} {R} {ANSWER} {R}

    Return True

EndProc

WriteLib libname mp_options_report.l
Release Procs    mp_options_report.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_colors_report.l(application_name.p)
    Private mp_procname.a
    ,applname

    mp_procname.a = "mp_colors_report.l"

    applname = application_name.p

Query

     mp_color | Application_name    | Background_color | Bar_color | Bar_select_color |
              | checkplus ~applname | Checkplus        | Checkplus | Checkplus        |

     mp_color | Inactive_color | Box_color | Box_select_color | Bar_help_color |
              | Checkplus      | Checkplus | Checkplus        | Checkplus      |

     mp_color | Key_select_color_box | Key_select_color_bar | Shadow_color | Show_shadow_sw |
              | Checkplus            | Checkplus            | Checkplus    | Checkplus      |

     mp_color | Border_color | Paint_border_sw | Background_pattern |
              | Checkplus    | Checkplus       | Checkplus          |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_color(q)"
    ClearImage

    Menu {Tools} {Copy} {Report} {DifferentTable} {mp_color} {R} {ANSWER} {R}

    Return True

EndProc

WriteLib libname mp_colors_report.l
Release Procs    mp_colors_report.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_make_menu.l()
    Private mp_procname.a
    ,application_name.a
    ,production_name.a
    ,Item
    ,mp_help_message.r
    ,mp_string.r
    ,mp_var
    ,literal.a
    ,directory.a
    ,selection
    ,LastPos
    ,mp_procname.a
    ,do_it_mp_procname.a
    ,do_it_seq_no
    ,file_name.a
    ,proclib_sc
    ,LastIdx
    ,Redraw
    ,width
    ,mp_line_intensity.r

    mp_procname.a = "mp_make_menu.l"

    mp_message_24.u(True,True," Building Menu Copy Screen",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    View "mp_sys"
    setpopup2("mp_sys","application_name",0)

    If Not IsEmpty("mp_rept") Then
        Empty "mp_rept"
    EndIf

    CoEdit "mp_rept"

    PickForm "1"

    Prompt " [F1]->Help [F2]->Do_it [F6]->List",
    " [Esc]->Quit"

    While True
        Wait Record
        Until "f1"
        ,-24    ;alt o
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,15     ;ctrl o
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,"f6"
        ,"f2"
        ,"esc"

        Switch
            Case RetVal = "f2" :
                If Not IsBlank([application_name]) Then
                    l=do_it(mp_procname.a,01)
                    If Not l Then
                        Return False
                    EndIf
                    QuitLoop
                Else
                    Beep
                    Message "Required field"
                    sleep 1000
                EndIf

            Case RetVal = "esc" :
                Menu {undo} {yes}
                l=do_it(mp_procname.a,02)
                Return False

            Case RetVal = "f6" :
                selection = Popup2(06,60,9,1,"Applications")
                If Not IsBlank(selection) Then
                    [application_name] = selection
                EndIf

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_copy.hlp") Then
                    Run noshell "readme mp_copy.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            otherwise :
                beep

        EndSwitch

    EndWhile

    Cursor Off

    application_name.a = [application_name]
    If IsBlank([production_name]) Then
        production_name.a  = [application_name]
    Else
        production_name.a  = [production_name]
    EndIf

    Lock application_name.a FL
    If Not RetVal Then
        Beep Sleep 100 Beep
        Message ErrorMessage()
        n=GetChar()
        Return False
    EndIf

    MoveTo [mp_sys->application_name]
    Locate application_name.a
    If Not RetVal Then
        UnLock application_name.a FL
        Beep Sleep 100 Beep
        Message "This application does not exist"
        n=GetChar()
        Return False
    EndIf

    if not isfile(application_name.a+"!.lib") then
        UnLock application_name.a FL
        Beep Sleep 100 Beep
        Message "Procedure library for this application does not exist"
        n=GetChar()
        Return False
    EndIf

    mp_message_24.u(True,True," Building System Scripts",79)

    mp_script_build.u(application_name.a,production_name.a,"PROD")

    mp_build_box_variable_script.u(application_name.a,production_name.a,"PROD")

    mp_build_help_variable_script.u(application_name.a,production_name.a,"PROD")

    mp_build_splash_screen_script.u(application_name.a,production_name.a,"PROD")

    l = mp_build_color_var_script.l(application_name.a,production_name.a,"PROD")

    release vars   mp_colors.r

    If Not l Then
        UnLock application_name.a FL
        Return False
    EndIf

    mp_message_24.u(True,True," Copying Driver Script",79)

    Run NoRefresh "copy "+production_name.a+"$.sc"+"+"+"mp_drive.sc /b >nul"

    If Not IsBlank([directory]) Then
        directory.a = [directory]
        Run NoRefresh "copy "+production_name.a+"$.sc "+directory.a+">nul"
        Run NoRefresh "del  "+production_name.a+"$.sc>nul"

        Run NoRefresh "copy "+production_name.a+".sc "+directory.a+">nul"
        Run NoRefresh "del  "+production_name.a+".sc>nul"
        ;Run NoRefresh "copy "+production_name.a+"@.sc "+directory.a+">nul"
        ;Run NoRefresh "del  "+production_name.a+"@.sc>nul"

    EndIf

    UnLock application_name.a FL

    Return True

EndProc

WriteLib libname   mp_make_menu.l
Release Procs      mp_make_menu.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  Closed mp_menu_play.u()
    UseVars autolib

    mp_procname.a = "menu_play"

    ErrorProc = "mp_error_proc.n"
    ReadLib "mp_drive" mp_error_proc.n

    mp_message_24.u(True,True," Building Application Screen",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    View "mp_sys"

    application_name.a = mp_get_application_name.a(false)

    If Not IsBlank(application_name.a) Then
        If IsFile(application_name.a+"#.sc") Then
            AutoLib = application_name.a + "!"
            Play application_name.a + "#"
        Else
            Beep
            Message "Application not found"
            Sleep 1000
        EndIf
    EndIf

EndProc

WriteLib libname   mp_menu_play.u
Release Procs      mp_menu_play.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_set_swappoint.u()
    Private mp_procname.a
    ,mp_orig_private_directory.a

    mp_procname.a = "mp_set_swappoint.u"

    CoEdit "mp_opt"

    PickForm "F"

    Prompt "[F1]->Help [F2]->Do_it [Esc]->Quit",""

    While True

        Wait Record
        Until "esc"
        ,-24    ;alt o
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,15     ;ctrl o
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,"f1"
        ,"f2"

        Switch
            Case RetVal = "f2" :
                If  Not IsBlank([idealmem])
                    And Not IsBlank([criticalmem]) Then
                    If  [criticalmem] > [idealmem] Then
                        MoveTo [criticalmem]
                        Beep Sleep 100 Beep
                        Message "Critical memory is greater than ideal memory"
                        n=GetChar()
                        Loop
                    EndIf
                EndIf

                l=do_it(mp_procname.a,01)
                If l Then
                    If  Not IsBlank([idealmem])
                        And Not IsBlank([criticalmem]) Then
                        mp_set_swap.u([idealmem],[criticalmem])
                    EndIf
                EndIf

                ClearImage
                Return

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_sys.hlp") Then
                    Run noshell "readme mp_sys.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            Case RetVal = "esc" :
                ClearImage
                Menu {undo} {yes}
                l=do_it(mp_procname.a,02)

                Return

            otherwise :
                beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname   mp_set_swappoint.u
Release Procs      mp_set_swappoint.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_report_out.u(out_mode.p,table.p,rept_seq.p,directory.p,application_name.p,extension.p)
    Private  mp_procname.a

    mp_procname.a = "mp_report_out.u"

    If out_mode.p = "P" Then
        l=mp_check_printer.l()
        if l then
           Menu {Report} {Output} Select table.p Select rept_seq.p {Printer}
        else
           message "Report cancelled; printer not ready"
           canvas on ;canvas off
           beep sleep 100 beep
           n=getchar()
        endif
    Else
        If out_mode.p = "S" Then
            Menu {Report} {Output} Select table.p Select rept_seq.p {Screen}
        Else
          if IsFile (directory.p+application_name.p+"."+extension.p) then
             Menu {Report} {Output} Select table.p Select rept_seq.p
             {File} Select StrVal(directory.p+application_name.p)+"."+extension.p {replace}
          else
             Menu {Report} {Output} Select table.p Select rept_seq.p
             {File} Select StrVal(directory.p+application_name.p)+"."+extension.p
          endif
        EndIf
    EndIf

EndProc

WriteLib libname mp_report_out.u
Release Procs    mp_report_out.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc        mp_clearkeyboard.u()
    private mp_procname.a

    mp_procname.a = "mp_clearkeyboard.u"

    While CharWaiting()
        n = GetChar()
    EndWhile

EndProc

WriteLib libname mp_clearkeyboard.u
Release Procs    mp_clearkeyboard.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_printer.l()
    private mp_procname.a

    mp_procname.a = "mp_check_printer.l"

    if printerstatus() then
       return true
    else
       message "Printer is disabled; correct and press any key to continue"
       beep sleep 100 beep
       canvas on
       n=getchar()
       if printerstatus() then
         return true
       else
         return false
       endif
    endif

EndProc

WriteLib libname mp_check_printer.l
Release Procs    mp_check_printer.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc        do_it(mp_procname.p,seq_no.p)
    Private msg

    do_it_mp_procname.a = mp_procname.p
    do_it_seq_no        = seq_no.p

    Do_it!

    msg = Window()

    If msg = "" Then
        Return True
    Else
        Beep Sleep 100 Beep
        Message msg, " (", mp_procname.p, "/", seq_no.p, ")"
        Canvas On
        n = GetChar()
        Return False
    EndIf

EndProc

WriteLib libname do_it
Release Procs    do_it

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_play_proclib.l()
    Private mp_procname.a
    ,proclib
    ,proclib_sc

    mp_procname.a = "mp_play_proclib.l"

    proclib             = application_name.p+"!"
    proclib_sc          = application_name.p+"!.sc"

    If IsFile(proclib_sc) Then

        Play  proclib       ;load application proc library

        View "mp_opt"

        If [mp_opt->delete_proclib_script] = "Y" Then
            Run NoRefresh "del "+proclib_sc+" >nul"
        EndIf

        ClearImage

    Else
        Beep Sleep 100 Beep
        Message.a = " Script "+PROCLIB_SC+" has not been built"
        mp_message_24.u(True,False,message.a,79)
        Canvas On
        n=GetChar()
        Canvas Off
        Return False
    EndIf

    Return True

EndProc

WriteLib libname mp_play_proclib.l
Release  Procs   mp_play_proclib.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc    mp_savevars_1.u(application_name.p,proclib_sc,mp_temp_directory.p)
    Private mp_procname.a

    mp_procname.a = "mp_savevars_1.u"

    SaveVars
    mp_row_1.r
    ,mp_row_2.r
    ,mp_box_col_start.r
    ,mp_box_col_end.r
    ,mp_box_group.r

    literal.a = "proc " + application_name.p + "1()"
    Print File proclib_sc literal.a, " \n"

    Run NoRefresh "copy " + proclib_sc + "+" + mp_temp_directory.p + "savevars.sc /b >nul"

    literal.a = "endproc"
    Print File proclib_sc "\n", literal.a, " \n"

    literal.a = "writelib libname " + application_name.p + "1"
    Print File proclib_sc literal.a, " \n"

    literal.a = "release  procs   " + application_name.p + "1"
    Print File proclib_sc literal.a, " \n"

EndProc

WriteLib libname mp_savevars_1.u
Release Procs    mp_savevars_1.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc    mp_savevars_2.u(application_name.p,proclib_sc,mp_temp_directory.p)
    Private mp_procname.a

    mp_procname.a = "mp_savevars_2.u"

    SaveVars
    mp_hotkey_position.r
    ,mp_hotkey.r
    ,mp_line_intensity.r
    ,mp_box_offset.r
    ,mp_control_box.r
    ,mp_first_pulldown_list.r
    ,mp_bar_offset.r
    ,mp_max_tree_depth.n
    ,mp_use_help_message.l
    ,mp_overwrite_second_line.l
    ,mp_accelerator_key.r
    ,mp_box_group_to.r

    literal.a = "proc " + application_name.p + "2()"
    Print File proclib_sc literal.a, " \n"

    Run NoRefresh "copy " + proclib_sc + "+" + mp_temp_directory.p + "savevars.sc /b >nul"

    literal.a = "endproc"
    Print File proclib_sc "\n", literal.a, " \n"

    literal.a = "writelib libname " + application_name.p + "2"
    Print File proclib_sc literal.a, " \n"

    literal.a = "release  procs   " + application_name.p + "2"
    Print File proclib_sc literal.a, " \n"

EndProc

WriteLib libname mp_savevars_2.u
Release Procs    mp_savevars_2.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc    mp_savevars_3.u(application_name.p,proclib_sc,mp_temp_directory.p)
    Private mp_procname.a

    mp_procname.a = "mp_savevars_3.u"

    SaveVars
    mp_control_line.r

    mp_release_vars_box.u()

    literal.a = "proc " + application_name.p + "3()"
    Print File proclib_sc literal.a, " \n"

    Run NoRefresh "copy " + proclib_sc + "+" + mp_temp_directory.p + "savevars.sc /b >nul"

    literal.a = "endproc"
    Print File proclib_sc "\n", literal.a, " \n"

    literal.a = "writelib libname " + application_name.p + "3"
    Print File proclib_sc literal.a, " \n"

    literal.a = "release  procs   " + application_name.p + "3"
    Print File proclib_sc literal.a, " \n"

EndProc

WriteLib libname mp_savevars_3.u
Release Procs    mp_savevars_3.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_return_to_menu_check.l()
    Private mp_procname.a

    mp_procname.a = "mp_return_to_menu_check.l"

    While True

        ShowMenu
            "Leave"  :    "Leave the box construction form",
            "Return" :    "Return to the box construction form"
            Default "Leave"
        To choice

        Switch

            Case choice = "Leave" :
                Return True

            Case choice = "Return" :
                Return False

            OtherWise :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_return_to_menu_check.l
Release Procs    mp_return_to_menu_check.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++
