
Clear Reset
Release Vars  All
libname = "mp_lib5"
Message "Building ", libname
CreateLib libname Size 50

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Copyright_1992_William_Mekeel()
    copyright.a = "     Copyright (c) 1992 William Mekeel  All Rights Reserved     "
    version.a   = "   MENUPAL version 1.00  "
EndProc

WriteLib libname   copyright_1992_William_Mekeel
Release  Procs     copyright_1992_William_Mekeel

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc         mp_edit_system.l()
   private mp_procname.a
   ,mp_shortcut_ascii.r
   ,application_name.a
   ,literal.a
   ,current_mp_box2_box_no
   ,mp_check.r
   ,mp_help_message.r
   ,mp_box_string_used_positions.r
   ,char.a
   ,original_row
   ,setpopup2.l
   ,LastPos
   ,in_sort_order.l
   ,ord_old
   ,mp_process_system_table.a
   ,mp_offset.n
   ,applname
   ,file_name.a
   ,l
   ,proclib_sc
   ,mp_string.r
   ,current_box_no_in_box_table
   ,LastIdx
   ,len_tree_key_1
   ,original_box_no
   ,x
   ,choice
   ,current_field_name
   ,mp_var
   ,libname
   ,current_box_no_in_temp_table
   ,Redraw
   ,width

    mp_procname.a = "mp_edit_system.l"

    mp_message_24.u(True,True," Building Application Screen",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    view "mp_sys"

    application_name.a=mp_get_application_name.a(true)

    If Not IsBlank(application_name.a) Then

        Lock application_name.a FL
        If Not RetVal Then
            Beep Sleep 100 Beep
            Message ErrorMessage()
            n=GetChar()
            Return False
        EndIf

        mp_message_24.u(True,True," Building Function Selection Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79

    Else
        Return False
    EndIf

    l = mp_checkbox_driver_1.u("1",7,"mp_func.hlp")
    If Not l Then
        UnLock application_name.a FL
        Return False
    EndIf

    array mp_check.r[7]
    mp_check.r[1] = [check_1]
    mp_check.r[2] = [check_2]
    mp_check.r[3] = [check_3]
    mp_check.r[4] = [check_4]
    mp_check.r[5] = [check_5]
    mp_check.r[6] = [check_6]
    mp_check.r[7] = [check_7]

    ClearImage

    If mp_check.r[1] = "X" Then
        mp_message_24.u(True,True," Building Autolib Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_clearkeyboard.u()
        l=mp_set_proc_lib.l(application_name.a)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf

    EndIf

    If mp_check.r[2] = "X" Then
        mp_message_24.u(True,True," Building Append Applications Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_clearkeyboard.u()
        l=mp_checkbox_driver_2.u("mp_sys",3)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
        l=mp_append_applications.l(application_name.a)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
    EndIf

    If mp_check.r[3] = "X"  Then
        mp_message_24.u(True,True," Building Splash Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_clearkeyboard.u()
        l=mp_splash_screen_create.l(application_name.a)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf

    EndIf

    If mp_check.r[4] = "X" Then
        mp_message_24.u(True,True," Building Color Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_clearkeyboard.u()
        l = mp_screen_colors.l(application_name.a,True)
        release vars  mp_colors.r

        Canvas On
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
    EndIf

    If mp_check.r[5] = "X" Then
        mp_message_24.u(True,True," Building Option Screen",79)
        PaintCanvas Fill " " Attribute 30 0,0,23,79
        mp_clearkeyboard.u()
        l = mp_set_options.l(application_name.a)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
    EndIf

    If mp_check.r[6] = "X" Then
        mp_clearkeyboard.u()
        l=mp_construct_system.l(application_name.a)
        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
    EndIf

    If mp_check.r[7] = "X" Then
        if mp_check.r[6] = "X" then
           l=mp_build_system.l(application_name.a,true)
        else
           l=mp_build_system.l(application_name.a,false)
        endif

        If Not l Then
            UnLock application_name.a FL
            Return False
        EndIf
    EndIf

    UnLock application_name.a FL

    Return True

EndProc

WriteLib libname mp_edit_system.l
Release Procs    mp_edit_system.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_build_system.l(application_name.p,tables_exist.p)
    Private mp_procname.a
    ,mp_ord_old.r
    ,mp_line_intensity.r
    ,mp_shortcut_ascii.r
    ,mp_help_message.r

    mp_procname.a = "mp_build_system.l"

    if not tables_exist.p then

       mp_message_24.u(True,True," Building MENUPAL tables (Part 1 of 3)",79)
       PaintCanvas Fill " " Attribute 30 0,0,23,79

       View "mp_line"
       View "mp_box"

       moveto [application_name]
       locate application_name.p
       if not retval then
          beep sleep 100 beep
          message "Boxes for this application have not been built"
          n=getchar()
          return false
       endif

       l = mp_load_mp_box2.l(application_name.p)
       If Not l Then
           Return False
       EndIf

       mp_message_24.u(True,True," Building MENUPAL tables (Part 2 of 3)",79)
       PaintCanvas Fill " " Attribute 30 0,0,23,79

       CoEditKey
       mp_clear_seq_no.u(application_name.p,"mp_box")

       box_count.n = mp_box_count_in_mp_line.n(application_name.p)

       If box_count.n > NRecords("entry998") Then
           Beep  Sleep 100 Beep
           Message "Mismatch in box count between the line and box tables (",
           box_count.n,"/",NRecords("entry998"),")"
           n=GetChar()
           l=do_it(mp_procname.a,01)
           Return False
       EndIf

       mp_message_24.u(True,True," Building MENUPAL tables (Part 3 of 3)",79)
       PaintCanvas Fill " " Attribute 30 0,0,23,79

       MoveTo [mp_box->application_name]
       Locate application_name.p
       If Not RetVal Then
           mp_error_in_retval.u(0206)
       EndIf

       l=mp_construct_box_edit_check.l(application_name.p,false)
       if not l then
          return false
       endif

    endif

    mp_message_24.u(True,True," Compressing Control Tables (Part 1 of 4)",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    MoveTo "entry998"

    Array mp_ord_old.r[cmax("entry998","box_no")]

    in_sort_order.l = True

    if sysmode() <> "Coedit" then
       CoEditKey
    endif

    Scan
        mp_ord_old.r[[box_no]] = [#]
        If [box_no] <> [#] Then
            in_sort_order.l = False
        EndIf
    EndScan

    If Not in_sort_order.l Then
        Scan
            [box_no] = mp_ord_old.r[[box_no]]
            If [parent_box_no] > 0 Then
                [parent_box_no] = mp_ord_old.r[[parent_box_no]]
            EndIf
        EndScan

        mp_message_24.u(True,True," Compressing Control Tables (Part 2 of 4)",79)

        mp_reorder2.u(application_name.p,"mp_line")

        mp_message_24.u(True,True," Compressing Control Tables (Part 3 of 4)",79)

        mp_reorder2.u(application_name.p,"mp_box")
    EndIf

    mp_message_24.u(True,True," Compressing Control Tables (Part 4 of 4)",79)

    MoveTo "mp_util" ClearImage

    mp_max_tree_depth.n = mp_condition_temp_table.n()

    mp_message_24.u(True,True," Building Boxes (setup)",79)

    mp_box_bld.u(application_name.p)

    mp_message_24.u(True,True," Building System Scripts",79)

    mp_script_build.u(application_name.p,"","TEST")

    mp_build_box_variable_script.u(application_name.p,"","TEST")

    mp_build_help_variable_script.u(application_name.p,"","TEST")

    mp_build_splash_screen_script.u(application_name.p,"","TEST")

    l = mp_build_color_var_script.l(application_name.p,"","TEST")
    If Not l Then
        Return False
    EndIf

    mp_message_24.u(True,True," Creating Procedure Library",79)

    l = mp_play_proclib.l()
    If Not l Then
        Return False
    EndIf

    Return True

EndProc

WriteLib libname mp_build_system.l
Release  Procs   mp_build_system.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_load_mp_box2.l(application_name.p)
    Private mp_procname.a

    mp_procname.a = "mp_load_mp_box2.l"

    Copy "mp_box2" "entry998"

    View "entry998"

    MoveTo [mp_box->application_name]
    Locate application_name.p
    If Not RetVal Then
        CoEditKey
        Ins
        [application_name] = application_name.p     ;add dummy record
        [box_no]           = 1            ;top of box
        [box_alias]        = "FIRST BOX"

        MoveTo "mp_line"
        ins
        [application_name]    = application_name.p
        [box_no]              = 1
        [line_no]             = 1
        [literal]             = "FIRST LINE"

        MoveTo "entry998"
        Down
        [box_no]    = 1
        [box_alias] = "FIRST BOX"
        [display]   = "FIRST BOX"

        l=do_it(mp_procname.a,01)
        If Not l Then
            Return False
        EndIf

    Else

        applname = application_name.p

        Query

         mp_box  | Application_name | Box_no | Parent_box_no | Box_alias |
                 | ~applname        | _boxno | _parentboxno  | _boxalias |

         entry998 | tree_key | Box_no | Parent_box_no | Box_alias  | Display   | cursor_ptr |
         insert   |          | _boxno | _parentboxno  | _boxalias  | _boxalias |            |

        EndQuery

        l=do_it(mp_procname.a,02)
        If Not l Then
            Return False
        EndIf

        Delete "inserted"

        MoveTo "entry998(q)"
        ClearImage

        MoveTo "mp_box(q)"
        ClearImage

    EndIf

    Return True

EndProc

WriteLib libname mp_load_mp_box2.l
Release  Procs   mp_load_mp_box2.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_box_count_in_mp_line.n(application_name.p)
    Private mp_procname.a
    ,box_count.n
    ,prior_box_no.n
    ,blank_num

    mp_procname.a = "mp_box_count_in_mp_line.n"

    box_count.n    = 0
    prior_box_no.n = ""
    blank_num      = BlankNum()

    MoveTo [mp_line->application_name]
    Locate application_name.p
    If RetVal Then
        Array mp_accelerator_key.r[245]
        MoveTo [seq_no]
        While [application_name] = application_name.p
            And Not Eot()
            If Not IsBlank([seq_no])  Then
                [] = blank_num
            EndIf
            If [box_no] <> prior_box_no.n Then
                box_count.n = box_count.n + 1
                prior_box_no.n = [box_no]
            EndIf
            If Not IsBlank([shortcut_ascii_code]) Then
                If [shortcut_ascii_code] < 0 Then
                    mp_offset.n = 260 + [shortcut_ascii_code]
                Else
                    mp_offset.n = [shortcut_ascii_code]
                EndIf
                If IsAssigned(mp_accelerator_key.r[mp_offset.n]) Then
                    mp_accelerator_key.r[mp_offset.n] = 1 + mp_accelerator_key.r[mp_offset.n]
                Else
                    mp_accelerator_key.r[mp_offset.n] = 1
                EndIf
            EndIf
            Skip
        EndWhile
    EndIf

    Return box_count.n

EndProc

WriteLib libname mp_box_count_in_mp_line.n
Release  Procs   mp_box_count_in_mp_line.n

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_checkbox_driver_1.u(form.p,max_table_records.p,help_file.p)
    Private mp_procname.a
    ,toggle_set_to_clear
    ,tmessage

    mp_procname.a = "mp_checkbox_driver_1.u"

    tmessage = ""
    toggle_set_to_clear = True

    CoEdit "mp_check"

    [check_1] = " "
    [check_2] = " "
    [check_3] = " "
    [check_4] = " "
    [check_5] = " "
    [check_6] = " "
    [check_7] = " "

    skip 0

    PickForm form.p
    MoveTo [check_1]

    Prompt " [F1]->Help [F2]->Do_it [F9]->Toggle all [Enter]->Toggle current",
    " [Esc]->Quit"

    While True

        Wait Record
            Message tmessage
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-117   ;ctrl end
        ,-119   ;ctrl home
        ,-108     ; [Alt F5] fieldview.
        ,6        ; [ctrl f] fieldview.
        ,"home"
        ,"end"
        ,"esc"
        ,"f1"
        ,"f2"
        ,"f9"
        ,"enter"
        ,32
        ,13
        ,"right"
        ,"left"
        ,"down"
        ,"up"

        tmessage = ""

        Switch
            Case RetVal = "f2" :
                l=do_it(mp_procname.a,01)
                Return l

            Case RetVal = "down"
                Or RetVal = "enter"
                Or RetVal = "right" :
                If max_table_records.p = 6 Then
                    If Field() <> "Check_6" Then
                        Right
                    Else
                        MoveTo Field "Check_1"
                    EndIf
                Else
                    If Field() <> "Check_7" Then
                        Right
                    Else
                        MoveTo Field "Check_1"
                    EndIf
                EndIf

            Case RetVal = "f9" :
                current_field_name = Field()
                If toggle_set_to_clear Then
                    toggle_set_to_clear = False
                    char.a = "X"
                Else
                    toggle_set_to_clear = True
                    char.a = " "
                EndIf

                [check_1] = char.a
                [check_2] = char.a
                [check_3] = char.a
                [check_4] = char.a
                [check_5] = char.a
                [check_6] = char.a
                [check_7] = char.a

                SKIP 0

                MoveTo Field current_field_name

            Case RetVal = "up"
                Or RetVal = "left" :
                If Field() <> "Check_1" Then
                    Left
                Else
                    If max_table_records.p = 6 Then
                        MoveTo Field "Check_6"
                    Else
                        MoveTo Field "Check_7"
                    EndIf
                EndIf

            Case RetVal = "esc" :
                Menu {undo} {yes}
                l=do_it(mp_procname.a,02)

                Return  False

            Case RetVal = 13 :
                If [] = " "  Then
                    [] = "X"
                Else
                    [] = " "
                EndIf

                SKIP 0

            Case RetVal = "home"  :
                MoveTo Field "Check_1"

            Case RetVal = "end"   :
                If max_table_records.p = 6 Then
                    MoveTo Field "Check_6"
                Else
                    MoveTo Field "Check_7"
                EndIf

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile(help_file.p) Then
                    Run noshell "readme "+help_file.p
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            OtherWise               :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_checkbox_driver_1.u
Release  Procs   mp_checkbox_driver_1.u

;+++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_checkbox_driver_2.u(table.p,form.p)
    Private mp_procname.a
    ,max_table_records
    ,checkbox_array
    ,toggle_set_to_clear
    ,current_record_no
    ,tmessage

    mp_procname.a = "mp_checkbox_driver_2.u"

    tmessage = ""
    toggle_set_to_clear = True

    max_table_records = NRecords(table.p)

    CoEdit table.p

    Scan for [checkbox] <> " "
        [checkbox] = " "
    EndScan

    Home

    PickForm form.p
    MoveTo [checkbox]

    Prompt " [F1]->Help [F2]->Do_it [F9]->Toggle all [Enter]->Toggle current",
    " [Esc]->Quit"

    While True

        Wait Record
        Message tmessage
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-117   ;ctrl end
        ,-119   ;ctrl home
        ,-108     ; [Alt F5] fieldview.
        ,6        ; [ctrl f] fieldview.
        ,-73
        ,-81
        ,"home"
        ,"end"
        ,"esc"
        ,"f1"
        ,"f2"
        ,"f9"
        ,"enter"
        ,32
        ,13
        ,"right"
        ,"left"
        ,"down"
        ,"up"

        tmessage = ""

        Switch
            Case RetVal = "f2" :
                l=do_it(mp_procname.a,01)
                Return l

            Case RetVal = "down"
                Or RetVal = "enter"
                Or RetVal = "right" :
                If [#] = max_table_records  Then
                    Beep
                    mp_clearkeyboard.u()
                Else
                    Down
                EndIf

            Case RetVal = "f9" :
                current_record_no = [#]
                If toggle_set_to_clear Then
                    toggle_set_to_clear = False
                    Scan
                        [checkbox] = "X"
                    EndScan
                Else
                    toggle_set_to_clear = True
                    Scan
                        [checkbox] = " "
                    EndScan
                EndIf

                SKIP 0

                MoveTo Record current_record_no

            Case RetVal = "up"
                Or RetVal = "left" :
                If [#] <> 1 Then
                    Up
                Else
                    Beep
                    mp_clearkeyboard.u()
                EndIf

            Case RetVal = "esc" :
                Menu {undo} {yes}
                l=do_it(mp_procname.a,02)

                Return  False

            Case RetVal = 13 :
                If [checkbox] = " "
                or [checkbox] = "" Then
                    [checkbox] = "X"
                Else
                    [checkbox] = " "
                EndIf

                SKIP 0

            Case RetVal = "home"  :
                Home

            Case RetVal = "end"  :
                End

            Case RetVal = -73
                Or RetVal = -81    :  ; -73=pgdn, -81=pgdn
                KeyPress RetVal

            Case RetVal = "f1"  :
                If strval(form.p) = "3" Then
                    If  IsFile("readme.com")
                        And IsFile("mp_appnd.hlp") Then
                        Run noshell "readme mp_appnd.hlp"
                    Else
                        Message "No help is available"
                        Sleep 1000
                    EndIf
                Else
                    If  IsFile("readme.com")
                        And IsFile("mp_del.hlp") Then
                        Run noshell "readme mp_del.hlp"
                    Else
                        Message "No help is available"
                        Sleep 1000
                    EndIf
                EndIf

            OtherWise :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_checkbox_driver_2.u
Release  Procs   mp_checkbox_driver_2.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_get_application_name.a(update_mode.p)
    Private mp_procname.a
    ,mp_application_name.a
    ,selection
    ,temp1.r
    ,item

    mp_procname.a = "mp_get_application_name.a"

    Prompt " [F2]->Do_it [F6]->Choice Box",
    " [Esc]->Quit"

    echo off

    setpopup2("mp_sys","application_name",0)

    view "mp_util"
    if not isempty("mp_util") then
       empty "mp_util"
    endif

    CoEditKey

    PickForm "2"

    mp_clearkeyboard.u()

    While True

        Wait Record
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-108     ; [Alt F5] fieldview.
        ,6        ; [ctrl f] fieldview.
        ,"up"
        ,"left"
        ,"right"
        ,"esc"
        ,"f2"
        ,"f6"

        Switch
            Case RetVal = "f2" :
                mp_application_name.a = mp_get_application_name_f2.a(update_mode.p)
                If Not IsBlank(mp_application_name.a) Then
                    Return mp_application_name.a
                EndIf

            Case RetVal = "f6" :
                [application_name] = Popup2(06,60,9,1,"Applications")

            Case RetVal = "esc" :
                l=do_it(mp_procname.a,01)
                Return ""

            OtherWise :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_get_application_name.a
Release  Procs   mp_get_application_name.a

;******************************************

Proc mp_get_application_name_f2.a(update_mode.p)
    Private mp_procname.a
        ,mp_application_name.a
        ,entered_checkbox

    mp_procname.a = "mp_get_application_name_f2.a"

    If IsBlank([application_name]) Then
        Beep
        Message "Required field"
        sleep 1000
        Return ""
    Else
        mp_application_name.a = [application_name]
        if update_mode.p then
           moveto [mp_sys->application_name]
           Locate mp_application_name.a
           If Not RetVal Then
                   Locate "DEFAULT"
                   If RetVal Then
                       CopyToArray temp1.r
                       temp1.r[2] = mp_application_name.a
                       ins
                       CopyFromArray temp1.r
                       Locate mp_application_name.a
                       If Not RetVal Then
                           mp_error_in_retval.u(0133)
                       EndIf
                   Else
                       ins
                       [application_name]      = mp_application_name.a
                       [checkbox]              = ""
                       [capitalize_style_sw]   = "N"
                       [box_band_char]         = "S"
                       [line_attach_pt]        = "E"
                       [box_vert_overlap]      = 0
                       [box_horiz_overlap]     = 0
                       [bar_horiz_overlap]     = 0
                       [use_help_messages]     = "N"
                       [overwrite_second_line] = "N"
                       [Initial_splash_screen] = "Y"
                       [Splash_screen_delay]   = 0

                       [Exec_proc_in_test]     = "N"
                       [Release_vars]          = "N"
                       [Clear_display]         = "C"
                       [Recycle_menu]          = "N"

                       [autolibs]              = ""
                   EndIf
           EndIf
        endif

        l=do_it(mp_procname.a,01)
        If Not l Then
            Return ""
        EndIf

        Return mp_application_name.a

    EndIf

EndProc

WriteLib libname mp_get_application_name_f2.a
Release  Procs   mp_get_application_name_f2.a

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_set_proc_lib.l(application_name.p)
    Private mp_procname.a
    ,n
    ,original_row
    ,temp1.r
    ,setpopup2.l

    mp_procname.a = "mp_set_proc_lib.l"

    setpopup2.l = False

    CoEdit "mp_sys"
    MoveTo [application_name]
    Locate application_name.p
    If Not RetVal Then
        mp_error_in_retval.u(0136)
    EndIf

    CopyToArray original_row

    MoveTo [autolibs]
    PickForm "1"
    Prompt " [F1]->Help [F2]->Do_it [F6]->Select [Ctrl F]->Fieldview",
    " [Alt F6]->Restore [Esc]->Quit"

    mp_clearkeyboard.u()

    While True

        Wait Record
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-108     ; [Alt F5] fieldview.
        ,6        ; [ctrl f] fieldview.
        ,"esc"
        ,"f2"
        ,"f1"
        ,"f6"
        ,"f36"    ;checkplus

        Switch
            Case RetVal = "f2" :
                l=do_it(mp_procname.a,01)
                Return l

            Case RetVal = "f6" :
                mp_set_proc_lib_f6.u()

            Case RetVal = "f36" :
                CopyFromArray original_row

            Case RetVal = -108
                Or RetVal = 6     : ; fieldview
                KeyPress RetVal

                Wait Record
                Until "Dos"
                ,"DosBig"
                ,-44    ;alt z
                ,-38    ;alt l
                ,-37    ;alt k
                ,-103   ;ctrl f10
                ,26     ;ctrl z
                ,18     ;ctrl r
                ,6        ; [ctrl f]
                ,-108     ; [Alt F5] fieldview.
                ,"esc"
                ,"f2"
                ,"enter"
                ,"down"
                ,"up"

            Case RetVal = "esc" :
                l=do_it(mp_procname.a,02)
                Return False

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_plib.hlp") Then
                    Run noshell "readme mp_plib.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            OtherWise :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_set_proc_lib.l
Release  Procs   mp_set_proc_lib.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_set_proc_lib_f6.u()
    Private mp_procname.a
    ,selection

    mp_procname.a = "mp_set_proc_lib_f6.u"

    FormKey

    If Not setpopup2.l Then
        setpopup2("mp_sys","application_name",7)
        setpopup2.l = True
    EndIf
    selection = popup2(6,64,10,1,"Copy From:")

    If Not IsBlank(selection) Then
        MoveTo [application_name]
        Locate selection
        If RetVal Then
            CopyToArray temp1.r
            temp1.r[2]= application_name.p
            Locate application_name.p
            If Not RetVal Then
                mp_error_in_retval.u(0137)
            EndIf
            CopyFromArray temp1.r
            moveto [autolibs]
            skip 0
        Else
            Message "Option record not found for this application"
            Beep
            Sleep 1000
        EndIf
    EndIf

    FormKey

EndProc

WriteLib libname mp_set_proc_lib_f6.u
Release  Procs   mp_set_proc_lib_f6.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_construct_box_edit_check.l(application_name.p,formkey.p)
    Private mp_procname.a
    ,action_box_no
    ,action_box_len
    ,ctr
    ,mp_data_in_box_ind.r

    mp_procname.a = "mp_construct_box_edit_check.l"

    mp_message_24.u(True,True," Performing Edit Checks",79)

    Canvas Off

    MoveTo "mp_box"
    Skip 0
    if formkey.p then
       FormKey
    endif

    nrecords_mp_box2 = NRecords("entry998")

    If NRecords_mp_box2 < 2 Then
        Beep
        mp_message_24.u(True,False,"",79)
        Message "More boxes are needed to construct menu"
        Canvas On
        n=GetChar()
        Return False
    EndIf

    l=mp_build_tree.l(application_name.p,False,False,"mp_box")
    If Not l Then
        Beep
        mp_message_24.u(True,False,"",79)
        Message "Action box is required"
        Canvas On
        n=GetChar()
        Return False
    EndIf

    MoveTo "entry998"
    Home
    action_box_no = [box_no]

    MoveTo "mp_line"
    Locate application_name.p,action_box_no
    action_box_len = 1

    While [application_name] = application_name.p
        And   [box_no]           = action_box_no
        And Not Eot()
        If Substr([literal],1,1) = "-" Then
            Beep Sleep 100 Beep
            Canvas On
            mp_message_24.u(True,False,"",79)
            Message "Divider lines not allowed in Action Box"
            n=GetChar()
            Return False
        Else
            ;do not allow launch from action bar
            If IsBlank([child_box_no]) Then
                Beep Sleep 100 Beep
                Canvas On
                mp_message_24.u(True,False,"",79)
                Message "Each Action Box entry must have a pulldown menu"
                n=GetChar()
                Return False
            EndIf
        EndIf
        action_box_len = action_box_len + Len([literal]) + 2

        Skip

    EndWhile

    mp_empty_terminal_procs.n = 0

    Locate application_name.p,action_box_no

    While [application_name] = application_name.p
        And Not Eot()
        If  IsBlank([execute_proc])
            And IsBlank([child_box_no])
            And Substr([literal],1,1) <> "-"  Then
            mp_empty_terminal_procs.n = 1 + mp_empty_terminal_procs.n
        EndIf

        If  Not IsBlank([shortcut_ascii_code])
            And Not IsBlank([child_box_no])  Then
            Beep Sleep 100 Beep
            Canvas On
            mp_message_24.u(True,False,"",79)
            Message "Accelerator key assigned to a non-terminal node (",[box_no],":",[line_no],")"
            n=GetChar()
            Return False
        EndIf

        Skip

    EndWhile

    If action_box_len > 80 Then
        Beep Sleep 100 Beep
        Canvas On
        mp_message_24.u(True,False,"",79)
        Message "Action box length is greater than 80 characters: (",action_box_len, ")"
        n=GetChar()
        Return False
    EndIf

    Array mp_data_in_box_ind.r[cmax("entry998","box_no")]

    MoveTo [application_name]
    Locate application_name.p
    While [application_name] = application_name.p
        And Not Eot()
        If Not IsAssigned(mp_data_in_box_ind.r[[box_no]]) Then
            mp_data_in_box_ind.r[[box_no]] = "N"
        EndIf
        If IsBlank([literal]) Then
            Beep Sleep 100 Beep
            Canvas On
            mp_message_24.u(True,False,"",79)
            Message "Blank line in box number ", [box_no]
            n=GetChar()
            Return False
        Else
            If Substr([literal],1,1) <> "-" Then
                mp_data_in_box_ind.r[[box_no]] = "Y"
            EndIf
        EndIf
        Skip
    EndWhile

    For ctr From 1 To nrecords_mp_box2
        If IsAssigned(mp_data_in_box_ind.r[ctr])
            And   mp_data_in_box_ind.r[ctr] = "N" Then
            Beep Sleep 100 Beep
            Canvas On
            mp_message_24.u(True,False,"",79)
            Message "No line descriptions in box number ", ctr
            n=GetChar()
            Return False
        EndIf
    EndFor

    Return True

EndProc

WriteLib libname mp_construct_box_edit_check.l
Release  Procs   mp_construct_box_edit_check.l

;***********************************************

Proc mp_utilities.u()
    Private mp_procname.a

    mp_procname.a = "mp_utilities.u"

                x       = "SysOptions"

                While True
                    PaintCanvas Fill " " Attribute 30 2,0,24,79

                    SetMargin Off
                    Style Attribute 30
                    @ 4,0

Text
      Ŀ
       [SysOptions]: Set Swappoint and Delete Proclib switch          
                                                                      
       [TableCheck]: Check MENUPAL table pointers                     
                                                                      
       [Exit]      : Exit Utilities                                   
      
EndText

                    ShowMenu
                        "SysOptions" : "Set Swappoint and Delete Proclib switch",
                        "TableCheck" : "Check MENUPAL table pointers",
                        "Exit"       : "Exit Utilities"
                        Default x
                    To x

                    Switch

                        Case x = "SysOptions" :
                            mp_set_swappoint.u()
                            ClearAll
                            x = "SysOptions"

                        Case x = "TableCheck" :
                            View "mp_sys"
                            application_name.a=mp_get_application_name.a(true)
                            ClearAll
                            If Not IsBlank(application_name.a) Then
                                l=mp_check_tables.l(application_name.a)
                                If l Then
                                    View "mp_refin"
                                    MoveTo [application_name]
                                    Locate application_name.a
                                    If Not RetVal Then
                                        Beep
                                        Message "No errors were found"
                                        Sleep 1000
                                    Else
                                        Echo Normal
                                        While True
                                            Prompt " Current application: "+ application_name.a,
                                            " Press [F2] to exit"
                                            k=GetChar()
                                            Switch
                                                Case k = -68 :  ;[f10]
                                                Case k = -60 :
                                                    Echo Off
                                                    QuitLoop
                                                Case k = 27  :
                                                    Echo Off
                                                    QuitLoop
                                                OtherWise :
                                                    KeyPress k
                                            EndSwitch
                                        EndWhile
                                        ClearImage
                                    EndIf
                                EndIf
                            EndIf
                            x = "TableCheck"

                        Case x = "Exit":
                            QuitLoop

                        Case x = "Esc":
                            QuitLoop

                    EndSwitch

                    mp_clearkeyboard.u()

                EndWhile

EndProc

WriteLib libname   mp_utilities.u
Release  Procs     mp_utilities.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_append_applications.l(application_name.p)
    Private mp_procname.a
    ,max_box_no.n

    mp_procname.a = "mp_append_applications.l"

    MoveTo [mp_sys->checkbox]

    Locate  "X"

    If RetVal Then

        View "mp_box"
        View "mp_line"

        CoEdit "mp_sys"

        [checkbox] = ""

        While True

            If [application_name] <> application_name.p Then
                mp_message_24.u(True,True," Appending application: "+[application_name],79)
                copy_from_app_name = [application_name]

                max_box_no.n = 0
                MoveTo [mp_box->application_name]

                Locate application_name.p
                If RetVal Then
                    While [application_name] = application_name.p
                        And Not Eot()
                        max_box_no.n = [box_no]
                        Skip
                    EndWhile
                EndIf

                mp_reorder_mp_box.u(copy_from_app_name,max_box_no.n)

                l=mp_reorder3.l(application_name.p,copy_from_app_name,"mp_line")
                If Not l Then
                    Return False
                EndIf

                l=mp_reorder3.l(application_name.p,copy_from_app_name,"mp_box")
                If Not l Then
                    Return False
                EndIf

                Skip
            Else
                Skip
            EndIf

            MoveTo [mp_sys->checkbox]

            Locate Next "X"
            If Not RetVal Then
                QuitLoop
            EndIf

            [checkbox] = ""

        EndWhile

        l=do_it(mp_procname.a,01)
        If Not l Then
            Return False
        EndIf

    EndIf

    Return True

EndProc

WriteLib libname mp_append_applications.l
Release Procs    mp_append_applications.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_delete_apps.l()
    Private mp_procname.a

    mp_procname.a = "mp_delete_apps.l"

    mp_message_24.u(True,True," Deleting records from the \"MP_COLOR\" table",79)

Query

    mp_sys | Application_name | Checkbox  |
           | _a               | "X"       |

    mp_color | Application_name |
    delete   | _a               |

EndQuery

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_color(q)"
    ClearImage

    mp_message_24.u(True,True," Deleting records from the \"MP_SPLSH\" table",79)

Query

    mp_sys | Application_name | Checkbox  |
           | _a               | "X"       |

    mp_splsh | Application_name |
    delete   | _a               |

EndQuery

    l=do_it(mp_procname.a,02)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_splsh(q)"
    ClearImage

    mp_message_24.u(True,True," Deleting records from the \"MP_LINE\" table",79)

Query

    mp_sys | Application_name | Checkbox  |
           | _a               | "X"       |

    mp_line  | Application_name |
    delete   | _a               |

EndQuery

    l=do_it(mp_procname.a,03)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_line(q)"
    ClearImage

    mp_message_24.u(True,True," Deleting records from the \"MP_BOX\" table",79)

Query

    mp_sys | Application_name | Checkbox  |
           | _a               | "X"       |

    mp_box   | Application_name |
    delete   | _a               |

EndQuery

    l=do_it(mp_procname.a,04)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_box(q)"
    ClearImage

    mp_message_24.u(True,True," Deleting records from the \"MP_REFIN\" table",79)

Query

    mp_sys | Application_name | Checkbox  |
           | _a               | "X"       |

    mp_refin | Application_name |
    delete   | _a               |

EndQuery

    l=do_it(mp_procname.a,05)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_refin(q)"
    ClearImage

    mp_message_24.u(True,True," Deleting records from the \"MP_SYS\" table",79)

Query

    mp_sys | Checkbox  |
    delete | "X"       |

EndQuery

    l=do_it(mp_procname.a,06)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_sys(q)"
    ClearImage

    If IsTable("deleted") Then
        Delete "deleted"
    EndIf

    mp_message_24.u(True,True," Restructuring the \"MP_COLOR\" table",79)

    {Modify} {Restructure} {mp_color} Do_it!

    mp_message_24.u(True,True," Restructuring the \"MP_SPLSH\" table",79)

    {Modify} {Restructure} {mp_splsh} Do_it!

    mp_message_24.u(True,True," Restructuring the \"MP_LINE\" table",79)

    {Modify} {Restructure} {mp_line} Do_it!

    mp_message_24.u(True,True," Restructuring the \"MP_BOX\" table",79)

    if not istable("entry998") then
       copy "mp_box2" "entry998"
    endif

    {Modify} {Restructure} {mp_box} Do_it!

    mp_message_24.u(True,True," Restructuring the \"MP_REFIN\" table",79)

    {Modify} {Restructure} {mp_refin}
    l=do_it(mp_procname.a,07)
    If Not l Then
        Return False
    EndIf

    mp_message_24.u(True,True," Restructuring the \"MP_SYS\" table",79)

    {Modify} {Restructure} {mp_sys}
    l=do_it(mp_procname.a,08)
    If Not l Then
        Return False
    EndIf

    Return True

EndProc

WriteLib libname mp_delete_apps.l
Release Procs    mp_delete_apps.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++
