
Clear Reset
Release Vars  All
libname = "mp_lib4"
Message "Building ", libname
CreateLib libname Size 50

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Copyright_1992_William_Mekeel()
    copyright.a = "   Copyright (c) 1992 William Mekeel  All Rights Reserved  "
    version.a   = "   MENUPAL version 1.00  "
EndProc

WriteLib libname   copyright_1992_William_Mekeel
Release  Procs     copyright_1992_William_Mekeel

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_condition_temp_table.n()
    Private mp_procname.a
    ,max_tree_depth.n

    mp_procname.a = "mp_condition_temp_table.n"

    MoveTo "entry998"

    max_tree_depth.n = 0

    CoEditKey

    Scan
        If [tree_key] < "B" Then
            If Len([tree_key]) > max_tree_depth.n Then
                max_tree_depth.n =  Len([tree_key])
            EndIf
        Else
            Del
            Up
        EndIf
    EndScan

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return 0
    EndIf

    Return max_tree_depth.n

EndProc

WriteLib libname mp_condition_temp_table.n
Release  Procs   mp_condition_temp_table.n

;**************************************************

Proc mp_set_options.l(application_name.p)
    Private waitchar
    ,mp_procname.a
    ,tmessage
    ,temp
    ,item
    ,width
    ,temp1.r
    ,original_row

    mp_procname.a = "mp_set_options.l"

    CoEdit "mp_sys"

    MoveTo [application_name]

    Locate application_name.p
    If Not RetVal Then
        mp_error_in_retval.u(0160)
    EndIf

    CopyToArray  original_row

    PickForm "2"

    tmessage = ""
    Prompt " [F1]->Help [F2]->Do_it [F6]->Select [Alt F6]->Restore",
    " [F10]->Clear [Esc]->Quit"

    mp_clearkeyboard.u()

    While True

        If Field() = "Capitalize_style_sw"
            Or Field() = "Box_band_char"
            Or Field() = "Line_attach_pt" Then
            tmessage = "Press [F4] for selection box"
        EndIf

        Wait Record
            Message tmessage
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,"f1"
        ,"f6"
        ,"f36"
        ,"ctrlhome"
        ,"ctrlend"
        ,"home"
        ,"end"
        ,"esc"
        ,"f10"
        ,"f4"
        ,"f2"
        ,"enter"
        ,"right"
        ,"left"
        ,"up"
        ,"down"

        waitchar = RetVal
        tmessage = ""

        Switch
            Case waitchar = "f2" :
                l = mp_set_options_f2.l()
                If l Then
                    Return True
                Else
                    Loop
                EndIf

            Case waitchar = "f10" :
                mp_set_options_f10.u()

                Loop

            Case waitchar = "f4" :
                If Field() = "Capitalize_style_sw"
                    Or Field() = "Box_band_char"
                    Or Field() = "Line_attach_pt" Then
                    original_field = Field()
                    l = mp_ActivatePopup2.l(application_name.p)
                Else
                    Beep
                EndIf

                Loop

            Case waitchar = "esc" :
                CopyFromArray original_row

                l=do_it(mp_procname.a,02)

                Return False

            Case waitchar = "f6" :
                mp_set_options_f6.u(application_name.p)
                Loop

            Case waitchar = "f36" :
                CopyFromArray original_row
                Loop

            Case waitchar = "home" :
                MoveTo [INITIAL_SPLASH_SCREEN]
                Loop

            Case waitchar = "end" :
                MoveTo [recycle_menu]
                Loop

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_optns.hlp") Then
                    Run noshell "readme mp_optns.hlp"
                    Loop
                Else
                    Message "No help is available"
                    Sleep 1000
                    Loop
                EndIf

            Case waitchar = "dos" :
                Loop

            Case waitchar = "dosbig" :
                Loop

        EndSwitch

        PassChar = True

        Switch

            Case Field() = "Initial_splash_screen" :
                If waitchar = "up"
                    Or waitchar = "left" Then
                    Beep
                    PassChar = False
                    mp_clearkeyboard.u()
                EndIf

            Case Field() = "Splash_screen_delay" :
                If waitchar = "up" Then
                    Beep
                    PassChar = False
                    mp_clearkeyboard.u()
                EndIf

            Case Field() = "Recycle_menu" :
                If waitchar = "enter"
                    Or waitchar = "right"
                    Or waitchar = "down" Then
                    Beep
                    PassChar = False
                    mp_clearkeyboard.u()
                EndIf

        EndSwitch

        If PassChar Then
            KeyPress waitchar
        Else
            Loop
        EndIf

    EndWhile

    Return True

EndProc

WriteLib libname mp_set_options.l
Release  Procs   mp_set_options.l

;*************************************************************

Proc mp_set_options_f2.l()
    Private mp_procname.a

    mp_procname.a = "mp_set_options_f2.l"

    l = mp_record_depart_2.l()
    If l Then
        l=do_it(mp_procname.a,01)
        If Not l Then
            Return False
        EndIf
        If IsTable("changed") Then
            Delete "changed"
        EndIf
        Return True
    Else
        Return False
    EndIf

EndProc

WriteLib libname mp_set_options_f2.l
Release  Procs   mp_set_options_f2.l

;*************************************************************

Proc mp_set_options_f6.u(application_name.p)
    Private mp_procname.a
    ,selection

    mp_procname.a = "mp_set_options_f6.u"

    formkey

    setpopup2("mp_sys","application_name",7)
    selection = popup2(6,64,10,1,"Copy From:")

    If Not IsBlank(selection) Then
        MoveTo [application_name]
        Locate selection
        If RetVal Then
            CopyToArray temp1.r
            temp1.r[2] = application_name.p
            Locate application_name.p
            If Not RetVal Then
                mp_error_in_retval.u(0161)
            EndIf
            CopyFromArray temp1.r
            skip 0
        Else
            Beep
            Message "Options record not found for this application"
            Sleep 1000
        EndIf
    EndIf

    FormKey

EndProc

WriteLib libname mp_set_options_f6.u
Release  Procs   mp_set_options_f6.u

;*************************************************************

Proc mp_set_options_f10.u()
    Private mp_procname.a

    mp_procname.a = "mp_set_options_f10.u"

    [application_model]     = ""
    [Checkbox]              = ""
    [capitalize_style_sw]   = ""
    [box_band_char]         = ""
    [line_attach_pt]        = ""
    [Box_vert_overlap]      = BlankNum()
    [Box_horiz_overlap]     = BlankNum()
    [Bar_horiz_overlap]     = BlankNum()
    [use_help_messages]     = ""
    [overwrite_second_line] = ""
    [initial_splash_screen] = ""
    [Splash_screen_delay]   = 0
    [Autolibs]              = ""

EndProc

WriteLib libname mp_set_options_f10.u
Release  Procs   mp_set_options_f10.u

;*************************************************************

Proc mp_record_depart_2.l()
    Private mp_procname.a

    mp_procname.a = "mp_record_depart_2.l"

    MoveTo "mp_sys"

    If IsBlank([application_name]) Then
        Beep
        tmessage = "Required field"
        MoveTo [application_name]
        Return False
    EndIf

    If IsBlank([capitalize_style_sw]) Then
        Beep
        tmessage = "Required field"
        MoveTo [capitalize_style_sw]
        Return False
    EndIf

    If IsBlank([box_band_char]) Then
        Beep
        tmessage = "Required field"
        MoveTo [box_band_char]
        Return False
    EndIf

    If IsBlank([line_attach_pt]) Then
        Beep
        tmessage = "Required field"
        MoveTo [line_attach_pt]
        Return False
    EndIf

    If IsBlank([Box_vert_overlap]) Then
        Beep
        tmessage = "Required field"
        MoveTo [box_vert_overlap]
        Return False
    EndIf

    If IsBlank([Box_horiz_overlap]) Then
        Beep
        tmessage = "Required field"
        MoveTo [box_horiz_overlap]
        Return False
    EndIf

    If IsBlank([overwrite_second_line]) Then
        Beep
        tmessage = "Required field"
        MoveTo [overwrite_second_line]
        Return False
    EndIf

    Return True

EndProc

WriteLib libname mp_record_depart_2.l
Release  Procs   mp_record_depart_2.l

;************************************************************

Proc mp_ActivatePopup2.l(application_name.p)
    Private mp_procname.a
    ,selection

    mp_procname.a = "mp_activatepopup2.l"

    Switch

        Case Field() = "Capitalize_style_sw" :
            mp_cap_style.u()
            selection = Popup2(10,62,7,1,"Cap. Style")
            If Not IsBlank(selection) Then
                [] = selection
            Else
                Return False
            EndIf

        Case Field() = "Box_band_char" :
            mp_band_style.u()
            selection = Popup2(12,62,7,1,"Band Type")
            If Not IsBlank(selection) Then
                [] = selection
            Else
                Return False
            EndIf

        Case Field() = "Line_attach_pt" :
            mp_attach_pt.u()
            selection = Popup2(14,62,7,1,"Attach Pt.")
            If Not IsBlank(selection) Then
                [] = selection
            Else
                Return False
            EndIf

    EndSwitch

    Return True

EndProc

WriteLib libname mp_activatepopup2.l
Release  Procs   mp_activatepopup2.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_splash_screen_create.l(application_name.p)
    Private mp_procname.a
    ,PassChar
    ,tmessage
    ,item
    ,width
    ,temp1.r
    ,item

    mp_procname.a = "mp_splash_screen_create.l"

    CoEdit "mp_splsh"

    setpopup2.l = False

    MoveTo [application_name]
    Locate application_name.p
    If Not RetVal Then
        End
        Down
        [application_name] = application_name.p
        Skip 0
        Locate application_name.p
        If Not RetVal Then
            mp_error_in_retval.u(0162)
        EndIf

    EndIf

    CopyToArray original_row

    PickForm "F"
    Prompt " [F2]->Do_it [F10]->Clear [Ctrl F]->Fieldview",
    " [F6]->Select [Alt F6]->Restore [Esc]->Quit"

    While True

        Wait Record
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,6        ; 6   [Ctrl F] fieldview.
        ,-108     ;-108 [Alt F5] fieldview.
        ,"f10"
        ,"esc"
        ,"f2"
        ,"f6"
        ,"f36"
        ,"enter"
        ,"right"
        ,"left"
        ,"down"
        ,"up"

        waitchar = RetVal
        tmessage = ""

        Switch
            Case waitchar = "f2" :
                l=do_it(mp_procname.a,01)
                If Not l Then
                    Return False
                EndIf
                ClearImage
                QuitLoop

            Case waitchar = "f6" :
                mp_splash_screen_create_f6.u(application_name.p)
                Loop

            Case waitchar = "f36" :
                CopyFromArray original_row
                Loop

            Case waitchar = "f10" :
                [literal_1] = ""
                [literal_2] = ""
                [literal_3] = ""
                [literal_4] = ""
                [literal_5] = ""
                [literal_6] = ""
                Loop

            Case waitchar = "esc" :
                CopyFromArray original_row
                l=do_it(mp_procname.a,02)
                ClearImage
                Return False

            Case waitchar = -108
                Or waitchar = 6     : ; fieldview
                KeyPress waitchar

                Wait Record
                Until "Dos"
                ,"DosBig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
                ,6
                ,-108     ;-108 [Alt F5] fieldview.
                ,"esc"
                ,"f2"
                ,"enter"
                ,"down"
                ,"up"

                Loop

            Case waitchar = "dos" :
                Beep
                Loop

            Case waitchar = "dosbig" :
                Beep
                Loop

        EndSwitch

        PassChar = True

        Switch
                ;first
            Case Field() = "Literal_1" :
                If waitchar = "up" Or waitchar = "left" Then
                    Beep
                    PassChar = False
                    mp_clearkeyboard.u()
                EndIf

            Case Field() = "Literal_6" :
                If waitchar = "enter" Or waitchar = "right" Or waitchar = "down" Then
                    Beep
                    PassChar = False
                    mp_clearkeyboard.u()
                EndIf

        EndSwitch

        If PassChar Then
            KeyPress waitchar
        EndIf

    EndWhile

    Return True

EndProc

WriteLib libname   mp_splash_screen_create.l
Release Procs      mp_splash_screen_create.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_splash_screen_create_f6.u(application_name.p)
    Private mp_procname.a
    ,selection

    mp_procname.a = "mp_splash_screen_create_f6.u"

    FormKey
    If Not setpopup2.l Then
        setpopup2("mp_splsh","application_name",7)
        setpopup2.l = True
    EndIf
    selection = popup2(6,64,10,1,"Copy From:")
    If Not IsBlank(selection) Then
        MoveTo [application_name]
        Locate selection
        If RetVal Then
            CopyToArray temp1.r
            temp1.r[2]= application_name.p
            Locate application_name.p
            If Not RetVal Then
                mp_error_in_retval.u(0163)
            EndIf
            CopyFromArray temp1.r
        Else
            Beep
            Message "Splash screen not found for this application"
            Sleep 1000
        EndIf
    EndIf
    FormKey

EndProc

WriteLib libname   mp_splash_screen_create_f6.u
Release Procs      mp_splash_screen_create_f6.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_cap_style.u()
    Private mp_procname.a

    mp_procname.a = "mp_cap_style.u"

    Array Item[4]
    Item[1] = "Upper"
    Item[2] = "Lower"
    Item[3] = "First"
    Item[4] = "None"
    Width = 05

EndProc

WriteLib libname mp_cap_style.u
Release  Procs   mp_cap_style.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_band_style.u()
    Private mp_procname.a

    mp_procname.a = "mp_band_style.u"

    Array Item[2]
    Item[1] = "Single"
    Item[2] = "Double"
    Width = 06

EndProc

WriteLib libname mp_band_style.u
Release  Procs   mp_band_style.u

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_attach_pt.u()
    Private mp_procname.a

    mp_procname.a = "mp_attach_pt.u"

    Array Item[2]
    Item[1] = "Start"
    Item[2] = "End"
    Width = 05

EndProc

WriteLib libname mp_attach_pt.u
Release  Procs   mp_attach_pt.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_tables_1.u()
    Private mp_procname.a

    mp_procname.a = "mp_check_tables_1.u"

    MoveTo "mp_line"

    Locate application_name.p,[mp_box->box_no]
    If Not RetVal Then
        seq_no = seq_no + 1
        mp_update_refin.u("box number in mp_box but not in mp_line",seq_no)
    EndIf

EndProc

WriteLib libname mp_check_tables_1.u
Release  Procs   mp_check_tables_1.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_tables_2.u()
    Private mp_procname.a

    mp_procname.a = "mp_check_tables_2.u"

    ;check for unique action box
    If [parent_box_no] = 0 Then
        If action_box_ctr.l = False Then
            action_box_ctr.l = True   ;the first one is ok
        Else
            seq_no = seq_no + 1
            mp_update_refin.u("multiple action box",seq_no)
        EndIf
    EndIf

EndProc

WriteLib libname mp_check_tables_2.u
Release  Procs   mp_check_tables_2.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_tables_3.u()
    Private mp_procname.a

    mp_procname.a = "mp_check_tables_3.u"

    If Not IsBlank([mp_box->parent_box_no])
        And [mp_box->parent_box_no] <> 0 Then

        ;see if parent box exists
        MoveTo "mp_line"
        Locate application_name.p,[mp_box->parent_box_no]
        If RetVal Then
            MoveTo [child_box_no]
            Locate Next [mp_box->box_no]
            If RetVal
                And [application_name] = application_name.p
                And [box_no] = [mp_box->parent_box_no] Then
                ;ok
            Else
                seq_no = seq_no + 1
                mp_update_refin.u("parent/child pointers do not match",seq_no)
            EndIf
        Else
            seq_no = seq_no + 1
            mp_update_refin.u("parent ptr. in mp_box but no box in mp_line",seq_no)
        EndIf

    EndIf

EndProc

WriteLib libname mp_check_tables_3.u
Release  Procs   mp_check_tables_3.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_tables_4.u()
    Private mp_procname.a

    mp_procname.a = "mp_check_tables_4.u"

    MoveTo "mp_box"

    Locate application_name.p,[mp_line->box_no]
    If Not RetVal Then
        seq_no = seq_no + 1
        mp_update_refin.u("box number in mp_line but not in mp_box",seq_no)
    EndIf

EndProc

WriteLib libname mp_check_tables_4.u
Release  Procs   mp_check_tables_4.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  mp_check_tables_5.u()
    Private mp_procname.a

    mp_procname.a = "mp_check_tables_5.u"

    If Not IsBlank([mp_line->child_box_no]) Then
        MoveTo "mp_box"
        Locate application_name.p,[mp_line->child_box_no]
        If RetVal Then
            ;see if child box points back to parent box
            If [mp_line->box_no] <> [parent_box_no] Then
                seq_no = seq_no + 1
                mp_update_refin.u("parent/child pointers do not match",seq_no)
            EndIf
        Else
            seq_no = seq_no + 1
            mp_update_refin.u("child ptr. in mp_line but no box in mp_box",seq_no)
        EndIf
    EndIf

EndProc

WriteLib libname mp_check_tables_5.u
Release  Procs   mp_check_tables_5.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc     mp_check_tables.l(application_name.p)
    Private mp_procname.a
    ,seq_no

    mp_procname.a = "mp_check_tables.l"

    Cursor Off

    mp_message_24.u(True,True," Building MP_REFIN Table",79)
    PaintCanvas Fill " " Attribute 30 0,0,23,79

    If SysMode() <> "Main" Then
        l=do_it(mp_procname.a,01)
        If Not l Then
            Return False
        EndIf
    EndIf

    View "mp_line"
    View "mp_box"
    View "mp_refin"
    CoEditKey

    seq_no = 0

    MoveTo [application_name]
    Locate application_name.p
    If RetVal Then
        While [application_name] = application_name.p
            And Not Eot()
            Del
        EndWhile
    EndIf

    ;mp_box table edits
    MoveTo [mp_box->application_name]
    Locate application_name.p
    If Not RetVal Then
        seq_no = seq_no + 1
        mp_update_refin.u("mp_box table not found",seq_no)
    Else
        action_box_ctr.l = False
        While [application_name] = application_name.p
            And Not Eot()

            mp_check_tables_1.u()
            MoveTo "mp_box"
            mp_check_tables_2.u()
            MoveTo "mp_box"
            mp_check_tables_3.u()
            MoveTo "mp_box"
            Skip

        EndWhile

    EndIf

    ;mp_line table edits
    MoveTo [mp_line->application_name]
    Locate application_name.p
    If Not RetVal Then
        seq_no = seq_no +1
        mp_update_refin.u("mp_line table not found",seq_no)
    Else
        While [application_name] = application_name.p
            And Not Eot()

            mp_check_tables_4.u()
            MoveTo "mp_line"
            mp_check_tables_5.u()
            MoveTo "mp_line"
            Skip

        EndWhile

    EndIf

    l=do_it(mp_procname.a,02)
    If Not l Then
        Return False
    Else
        MoveTo "mp_line" ClearImage
        MoveTo "mp_box" ClearImage
        MoveTo "mp_refin" ClearImage
        Return True
    EndIf

EndProc

WriteLib libname mp_check_tables.l
Release  Procs   mp_check_tables.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_update_refin.u(msg.p,seq_no.p)
    Private mp_procname.a

    mp_procname.a = "mp_update_refin.u"

    MoveTo "mp_refin"
    Ins
    [application_name]      = application_name.p
    [date]                  = Today()
    [time]                  = Time()
    [mp_line_box_no]        = [mp_line->box_no]
    [mp_line_line_no]       = [mp_line->line_no]
    [mp_line_child_box_no]  = [mp_line->child_box_no]
    [mp_box_box_no]         = [mp_box->box_no]
    [mp_box_parent_box_no]  = [mp_box->parent_box_no]
    [seq_no]                = seq_no.p
    [message]               = msg.p

EndProc

WriteLib libname mp_update_refin.u
Release  Procs   mp_update_refin.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc        mp_message_24.u(blank.p,blink.p,message.p,attribute.p)

    Private mp_procname.a

    mp_procname.a = "mp_message_24.u"

    If blank.p Then
        Style Attribute  attribute.p
        @ 24, 0
        ?? Spaces(80)
    EndIf

    If blink.p  Then
        @ 24, 0
        ?? message.p
        Style Attribute (attribute.p + 128)
        ?? "... "
    Else
        @ 24, 0
        ?? message.p
    EndIf

EndProc

WriteLib libname mp_message_24.u
Release Procs    mp_message_24.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_set_swap.u(ideal.p, critical.p)
    Private mp_procname.a

    mp_procname.a = "mp_set_swap.u"

    If Version() > 3.01 Then
        If  critical.p > 0
            And ideal.p    > 0 Then
            If MemLeft() < (critical.p + ideal.p) Then
                SetSwap critical.p
            Else
                SetSwap (MemLeft() - ideal.p)
            EndIf
        EndIf
    Else
        If  critical.p > 0 Then
            SetSwap critical.p
        EndIf
    EndIf

EndProc

WriteLib libname mp_set_swap.u
Release Procs    mp_set_swap.u

;*******************************************

Proc mp_error_in_retval.u(seq_no.p)

    Canvas On

    SetMargin Off

    PaintCanvas Fill " "
    Attribute 30 0,0,24,79

    Style Attribute 30

    @ 5,0

Text
        Ŀ
                                                                     
           A 'LOCATE' instruction failed.                            
                                                                     
           Reviewing table MP_REFIN may help to identify the         
           invalid records.                                          
                                                                     
           Press any key to continue.                                
                                                                     
        
EndText

    Message "Locate error number: ", seq_no.p, "; table: ", Table()

    n=GetChar()

    l=mp_check_tables.l([mp_util->application_name])

    mp_error_proc.n()

EndProc

WriteLib libname mp_error_in_retval.u
Release Procs    mp_error_in_retval.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc   mp_box_edit.l(application_name.p,next_box_no.p,current_box_no.p,type.p)
    Private mp_procname.a
    ,original_action_box
    ,resort_temp_table.l
    ,old_display_name
    ,temp_mp_box.r

    mp_procname.a = "mp_box_edit.l"

    original_action_box = [action_box]
    resort_temp_table.l = False
    tmessage.a          = ""

    If type.p = "NEW" Then     ;set switch for "new" record
        Ins  ;make new row in mp_box

        [Application_name] = application_name.p
        [Box_no]           = next_box_no.p
        [Box_alias]        = ""
        LockRecord
        UnLockRecord
    Else
        CopyToArray temp_mp_box.r
    EndIf

    PgDn       ;go to second page of form
    MoveTo [box_alias]
    old_display_name = [box_alias]

    Prompt " [F1]->Help [F2]->Do_it", " [Esc]->Quit"

    While True

        Wait Record
            Message tmessage.a
        Until "dos"
        ,"dosbig"
        ,"pgup"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,"pgdn"
        ,-117   ;ctrl end
        ,-119   ;ctrl home
        ,-108   ;fieldview
        ,6      ;fieldview
        ,"home"
        ,"end"
        ,-15 ;shift tab
        ,9   ;tab
        ,"del"
        ,"left"
        ,"right"
        ,"esc"
        ,"f2"
        ,"f1"
        ,"up"
        ,"down"
        ,"enter"

        tmessage.a = ""

        Switch
            Case RetVal = "f2" :
                l = mp_box_edit_f2.l(application_name.p,next_box_no.p,current_box_no.p,type.p)
                If l Then
                    QuitLoop
                Else
                    Loop
                EndIf

            Case RetVal = "down"
                Or RetVal  = "enter"
                Or RetVal  = "right" :
                If Field() <> "Build_depart_proc_stub"  Then
                    Down
                Else
                    Beep
                EndIf

            Case RetVal = "up"
                Or RetVal = "left" :
                If Field() <> "Box_alias" Then
                    Up
                Else
                    Beep
                EndIf

            Case RetVal = "esc" :
                mp_box_edit_esc.u(application_name.p,next_box_no.p,current_box_no.p,type.p)
                QuitLoop

            Case RetVal = "home"  :
                MoveTo [box_alias]

            Case RetVal = "end"  :
                MoveTo [Build_depart_proc_stub]

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_box.hlp") Then
                    Run noshell "readme mp_box.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            OtherWise:
                Beep

        EndSwitch

    EndWhile

    Return resort_temp_table.l

EndProc

WriteLib libname mp_box_edit.l
Release  Procs   mp_box_edit.l

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_line_view.u(application_name.p,box_no.p)
    Private mp_procname.a
    ,tmessage.a
    ,waitchar
    ,ctr
    ,temp_key_no
    ,current_key
    ,start_key
    ,current_line_no_mp_line
    ,num_rows
    ,current_box_no_mp_box2
    ,mp_line_box_no
    ,mp_line_line_no
    ,child_box_no
    ,temp_line.r

    mp_procname.a          = "mp_line_view.u"

    tmessage.a          = ""

    MoveTo "mp_line"
    Home

    While True

        Prompt " [F1]->Help [F2]->Do_it [F4]->Link [Alt-F4]->UnLink [Del]->Del [Ins]->Ins",
        " [F7]->Up [F8]->Down [F9]->Detail Edit [F10]->Tree Build [Ctrl F]->Fieldview"

        MoveTo [literal]

        Wait Record
        Message tmessage.a
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-117   ;ctrl end
        ,-119   ;ctrl home
        ,9 ;tab
        ,-15 ;shift tab
        ,-108    ;fieldview
        ,6       ;fieldview
        ,"pgdn"
        ,"pgup"
        ,"home"
        ,"end"
        ,"f10"
        ,"del"
        ,"ins"
        ,"esc"
        ,"f1"
        ,"f2"
        ,"f4"
        ,"f7"
        ,"f8"
        ,"f9"
        ,-107 ;alt-f4
        ,"left"
        ,"up"
        ,"enter"
        ,"down"
        ,"right"

        tmessage.a = ""

        Switch
            Case RetVal = "down"
                Or RetVal = "right"
                Or RetVal = "enter" :
                mp_line_view_down.u(application_name.p,box_no.p)

            Case RetVal = "up"
                Or RetVal = "left" :
                mp_line_view_up.u(application_name.p)

            Case RetVal = "f4"  :
                mp_line_view_f4.u(application_name.p)

            Case RetVal = -107   :   ;alt-f4
                mp_line_view_alt_f4.u(application_name.p)

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_const.hlp") Then
                    Run noshell "readme mp_const.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            Case RetVal = "f2" :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    num_rows = NImageRecords()
                    For ctr From 1 To num_rows
                        MoveTo Record ctr
                        [line_no] = ctr
                    EndFor

                    MoveTo "mp_box"

                    Return
                EndIf

            Case RetVal = "f7" :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    mp_line_swap.u("UP")
                    MoveTo [literal]
                EndIf

            Case RetVal = "f8" :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    mp_line_swap.u("DOWN")
                    MoveTo [literal]
                EndIf

            Case RetVal = "f9" :
            If Substr([literal],1,1) <> "-" Then
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                   l=mp_line_edit.l()
                endif
            else
                Beep
                Message "Edit not possible on this row"
                Sleep 1000
            endif

            Case RetVal = "f10" :
                mp_line_view_f10.u(application_name.p)

            Case RetVal = "esc" :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    num_rows = NImageRecords()
                    For ctr From 1 To num_rows
                        MoveTo Record ctr
                        [line_no] = ctr
                    EndFor

                    MoveTo "mp_box"

                    Return

                EndIf

            Case RetVal = -108
                Or RetVal = 6    :
                KeyPress RetVal  ;go into fieldview
                Wait Record
                Until "enter"

            Case RetVal = "del" :
                mp_line_view_del.u(application_name.p,box_no.p)

            Case RetVal = "ins" :
                mp_line_view_ins.u(application_name.p,box_no.p)

            Case RetVal = "home"  :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    Home
                EndIf

            Case RetVal = "end"  :
                tmessage.a = mp_record_depart.a(RetVal)
                If IsBlank(tmessage.a) Then
                    End
                EndIf

            OtherWise :
                Beep

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_line_view.u
Release  Procs   mp_line_view.u

;+++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_line_edit.l()
    Private mp_procname.a
    ,orig_shortcut_ascii_code.n

    mp_procname.a = "mp_line_edit.l"

    current_box_no  = [box_no]
    current_line_no = [line_no]

    CopyToArray mp_line_hold

    l=do_it(mp_procname.a,01)
    If Not l Then
        Return False
    EndIf

    MoveTo "mp_box"
    FormKey

    MoveTo "mp_line"
    Locate application_name.p,current_box_no,current_line_no
    If Not RetVal Then
        mp_error_in_retval.u(0158)
    EndIf

    orig_shortcut_ascii_code.n = [shortcut_ascii_code]

    MoveTo [literal]
    CoEditKey
    PickForm "F"

    Prompt " [F1]->Help [F2]->Do_it [Ctrl F]->Fieldview",
    " [Esc]->Quit"

    While True

        Wait Record
        Until "dos"
        ,"dosbig"
        ,-44    ;alt z
        ,-38    ;alt l
        ,-37    ;alt k
        ,-103   ;ctrl f10
        ,26     ;ctrl z
        ,18     ;ctrl r
        ,-108
        ,6
        ,"home"
        ,"end"
        ,"del"
        ,"ins"
        ,"esc"
        ,"enter"
        ,"f1"
        ,"f2"
        ,"right"
        ,"left"
        ,"down"
        ,"up"

        Switch

            Case RetVal = "home" :
                MoveTo [literal]

            Case RetVal = "end"  :
                MoveTo [recycle_menu]

            Case RetVal = "up"
                Or RetVal = "left" :
                If Field() <> "Literal" Then
                    Up
                Else
                    Beep
                EndIf

            Case RetVal = "enter"
                Or RetVal = "right"
                Or RetVal = "down" :
                If Field() <> "Recycle_menu" Then
                    Down
                Else
                    Beep
                EndIf

            Case RetVal = "esc"  :
                CopyFromArray mp_line_hold
                QuitLoop

            Case RetVal = "f1"  :
                If  IsFile("readme.com")
                    And IsFile("mp_line.hlp") Then
                    Run noshell "readme mp_line.hlp"
                Else
                    Message "No help is available"
                    Sleep 1000
                EndIf

            Case RetVal = "f2"   :
                 l=mp_line_edit_f2.l()
                 if l then
                    quitloop
                 endif

            Case RetVal = -108
                Or RetVal = 6    :

                If Field() = "Help_msg" Then
                    KeyPress RetVal  ;go into fieldview
                    Wait Field
                    Until "enter"
                Else
                    Beep
                EndIf

            OtherWise:
                Beep

        EndSwitch

    EndWhile

    l=do_it(mp_procname.a,02)
    If Not l Then
        Return False
    EndIf

    FormKey
    MoveTo "mp_box"
    CoEditKey
    PickForm "F"

    MoveTo "mp_line"
    Locate application_name.p,current_box_no,current_line_no
    If Not RetVal Then
        mp_error_in_retval.u(0159)
    EndIf

    MoveTo [literal]

    Return True

EndProc

WriteLib libname mp_line_edit.l
Release  Procs   mp_line_edit.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_record_depart.a(waitchar.p)
    Private mp_procname.a

    mp_procname.a = "mp_record_depart.a"

    tmessage.a = ""

    if isblank([literal]) then
       if RetVal = "f2"
       or RetVal = "esc" then
          if  NImageRecords() > 1 then
              Beep
              tmessage.a  = "Line description cannot be blank"
          endif
       else
          Beep
          tmessage.a  = "Line description cannot be blank"
       endif
       mp_clearkeyboard.u()
       Return tmessage.a
    endif

    switch

    case waitchar.p = "down"
        Or waitchar.p = "right"
        Or waitchar.p = "enter" :
        If RowNo()           = 21 Then
            Beep
            tmessage.a = "End of box"
            mp_clearkeyboard.u()
        else
        If IsBlank([literal])
        Or [literal] = Spaces(len([literal])) Then
           If  waitchar.p = "f2"
               And NImageRecords() = 1 Then
            ; ok
           Else
               If  waitchar.p = "esc"
                   And NImageRecords() = 1 Then
                   ; ok
               Else
                   Beep
                   tmessage.a = "Required field"
               EndIf
           EndIf
        endif
        endif

    case  waitchar.p = "up"
        Or waitchar.p = "left" :
        If AtFirst()    Then
            Beep
            tmessage.a = "Top of box"
            mp_clearkeyboard.u()
        EndIf

    case waitchar.p = "ins"   :
        If NImageRecords()   = 21  Then
            Beep
            tmessage.a = "Box full"
        EndIf

    endswitch

    Return tmessage.a

EndProc

WriteLib libname mp_record_depart.a
Release  Procs   mp_record_depart.a

;+++++++++++++++++++++++++++++++++++++++++++++++++++
