
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Copyright_1992_William_Mekeel()
    copyright.a = "   Copyright (c) 1992 William Mekeel  All Rights Reserved  "
    version.a   = "   MENUPAL version 1.00  "
EndProc

WriteLib libname   copyright_1992_William_Mekeel
Release  Procs     copyright_1992_William_Mekeel

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Closed mp_system_driver.l(application_name.p,production.p)
    UseVars AutoLib

    private  mp_line_intensity_temp.r

    mp_procname.a = "mp_system_driver.l"

    ErrorProc = "mp_error_proc.n"
    If production.p Then
        ReadLib application_name.p+"$"  mp_error_proc.n
    Else
        ReadLib "mp_drive" mp_error_proc.n
    EndIf

    l = mp_menu_set.l(application_name.p)
    If Not l Then
        Clear ClearAll
        Return False
    EndIf

    While True

        If mp_stack_box_no[mp_stack_ptr] > 1  Then
            mp_pulldown_1.u(mp_stack_box_no[mp_stack_ptr],mp_stack_line_no[mp_stack_ptr],
            False,application_name.p)
            n=mp_pulldown_2.n(mp_stack_box_no[mp_stack_ptr],mp_stack_line_no[mp_stack_ptr],
            mp_field2_temp.a,False,application_name.p)
        Else
            mp_action_bar_1.u(mp_stack_line_no[mp_stack_ptr],
            False,application_name.p)
            n=mp_action_bar_2.n(mp_stack_line_no[mp_stack_ptr],
            mp_field2_temp.a,False,application_name.p)
        EndIf

        If n > 0 Then
            n2=mp_system_driver_not_esc.n(application_name.p,production.p,
            (mp_box_offset.r[mp_stack_box_no[mp_stack_ptr]] + mp_stack_line_no[mp_stack_ptr] - 1),
            False)
            If n2 > 0 Then
                ;ok
            Else
                If n2 < 0 Then    ;error
                    Clear ClearAll
                    Return False
                Else              ;exit proc called
                    Clear ClearAll
                    Return True
                EndIf
            EndIf
        Else
            If n < 0 Then
                mp_stack_ptr = 1       ;return to action bar
                n2=mp_system_driver_not_esc.n(application_name.p,
                production.p, (-n) - 1, False)
                If n2 > 0 Then
                    ;ok
                Else
                    If n2 < 0 Then    ;error
                        Clear ClearAll
                        Return False
                    Else              ;exit proc called
                        Clear ClearAll
                        Return True
                    EndIf
                EndIf
            Else
                l=mp_system_driver_esc.l()
                If l Then
                    Clear ClearAll
                    Return True
                EndIf
            EndIf
        EndIf

    EndWhile

EndProc

WriteLib libname mp_system_driver.l
Release  Procs   mp_system_driver.l

;*******************************************

Proc  mp_system_driver_not_esc.n (application_name.p,production.p,
      control_line_ptr.p,invoked_via_accelerator.p)
    Private mp_procname.a
    ,mp_retval_esc.l
    ,mp_original_autolib.a

    mp_procname.a = "mp_system_driver_not_esc.n "

    l = Match(mp_control_line.r[control_line_ptr.p],
    "..,..,..,..,..,..,..",
    mp_field1.a,mp_field2.a,mp_field3.a,mp_field4.a,
    mp_field5.a,mp_field6.a,mp_field7.a)

    ;mp_field1.a = [child_box_no]
    ;mp_field2.a = [clear_display]
    ;mp_field3.a = [recycle_menu]
    ;mp_field4.a = [exec_proc_in_test]
    ;mp_field5.a = [release_vars]
    ;mp_field6.a = [execute_proc]
    ;mp_field7.a = [form_proc]

    If Not l Then
        Beep Sleep 100 Beep
        Message "Error in match command"
        Canvas On
        n=GetChar()
        Return -1
    EndIf

    If Not IsBlank(mp_field1.a) Then
        mp_use_stack_push.u(NumVal(mp_field1.a),1)
    Else
        mp_original_autolib.a = AutoLib
        mp_retval_esc.l     = False

        If mp_field5.a = "Y" Then    ;release most menupal variables
            If mp_use_help_message.l Then
                Release Vars mp_help_message.r
            EndIf
            mp_release_vars_box.u()
            mp_release_vars_misc.u()
        EndIf

        If mp_field6.a = "mp_exit_from_menupal.u" Then
            Return 0
        Else
            If production.p
                Or mp_field4.a = "Y" Then
                mp_retval.l = true
                ErrorProc = "mp_execproc_not_assigned.n"
                ExecProc mp_field6.a
                ErrorProc = "mp_error_proc.n"
                if mp_retval.l then
                   mp_field2_temp.a = mp_field2.a
                   mp_field7_temp.a = mp_field7.a
                else
                   mp_field2_temp.a = "C"
                   mp_field7_temp.a = ""   ;don't process form
                endif
            Else
                Message "Play script ", mp_field6.a  ;simulate [execute_proc]
                Canvas On Canvas Off
                sleep 1000                   ;set `play script' sleep time
                While CharWaiting()
                    n=GetChar()
                EndWhile
                mp_field2_temp.a = "C"
                mp_field7_temp.a = ""
            EndIf
        EndIf

        Canvas Off

        If Not IsAssigned(mp_retval_esc.l) Then
            mp_retval_esc.l = False
        EndIf

        If IsAssigned(mp_original_autolib.a) Then
            AutoLib = mp_original_autolib.a
        EndIf

        If mp_field5.a = "Y" Then    ;reset menupal variables
            array  mp_line_intensity_temp.r[arraysize(mp_line_intensity.r)]
            for ctr from 1 to arraysize(mp_line_intensity.r)
                mp_line_intensity_temp.r[ctr] = mp_line_intensity.r[ctr]
            endfor
            ExecProc  application_name.p + "1"
            ExecProc  application_name.p + "2"
            ExecProc  application_name.p + "3"
            If mp_use_help_message.l Then
                ExecProc application_name.p + "H"
            EndIf
            for ctr from 1 to arraysize(mp_line_intensity_temp.r)
              mp_line_intensity.r[ctr] = mp_line_intensity_temp.r[ctr]
            endfor
            release vars mp_line_intensity_temp.r
            Play PrivDir()+"mp_savev"
        EndIf

        If mp_field2_temp.a = "C" Then
            PaintCanvas
            Fill       Chr(mp_colors.r[16])
            Attribute  mp_colors.r[3]
            1,0,24,79
        EndIf

        If mp_field3.a = "Y"            ;[recycle_menu]
            And Not invoked_via_accelerator.p Then
            If not mp_retval_esc.l Then
                mp_use_stack_clear.u(1,1)
            Else                        ;esc key pressed
                mp_walk_stack.u()
            EndIf
        Else
            mp_walk_stack.u()
        EndIf
    EndIf

    Return 1

EndProc

WriteLib libname mp_system_driver_not_esc.n
Release  Procs   mp_system_driver_not_esc.n

;*******************************************

Proc mp_execproc_not_assigned.n()

    If ErrorCode() = 34 Then
        mp_field2.a = "C"    ;force a clear of the screen
        mp_retval.l = false
        Beep
        Message "Procedure ",mp_field6.a," or variable not assigned"
        Canvas On Canvas Off
        Sleep 1000
        While CharWaiting()
           n=GetChar()
        EndWhile
    EndIf
    Return 1

EndProc

WriteLib libname mp_execproc_not_assigned.n
Release  Procs   mp_execproc_not_assigned.n

;*******************************************

Proc mp_execproc_not_assigned2.n()

    If ErrorCode() = 34 Then
        mp_field2_temp.a = "C"  ;force a clear of the canvas
        mp_field7_temp.a = ""   ;don't process form
        Beep
        Message "Procedure ",mp_field7_temp.a," or variable not assigned"
        Canvas On Canvas Off
        Sleep 1000
        While CharWaiting()
           n=GetChar()
        EndWhile
    EndIf
    Return 1

EndProc

WriteLib libname mp_execproc_not_assigned2.n
Release  Procs   mp_execproc_not_assigned2.n

;*******************************************

Proc  mp_walk_stack.u()
    Private mp_procname.a
    ,stack_walk_ptr

    mp_procname.a = "mp_walk_stack.u"

    For stack_walk_ptr From 1 To mp_stack_ptr-1
        If mp_stack_box_no[stack_walk_ptr] > 1 Then
            mp_pulldown_1.u(mp_stack_box_no[stack_walk_ptr],
            mp_stack_line_no[stack_walk_ptr],True,application_name.p)
        Else
            mp_action_bar_1.u(mp_stack_line_no[stack_walk_ptr],
            True,application_name.p)
        EndIf
    EndFor

EndProc

WriteLib libname mp_walk_stack.u
Release  Procs   mp_walk_stack.u

;*******************************************

Proc  mp_system_driver_esc.l()
    Private mp_procname.a

    mp_procname.a = "mp_system_driver_esc.l"

    If mp_stack_ptr = 1 Then
        Return True
    Else
        mp_use_stack_pop.u("","")
        If mp_field2_temp.a = "E"  Then
            If not IsRuntime() Then
                Echo Normal Echo Off
                if not isblank(mp_field7_temp.a) then
                   ErrorProc = "mp_execproc_not_assigned2.n"
                   ExecProc mp_field7_temp.a
                   ErrorProc = "mp_error_proc.n"
                endif
            else
                tkEcho Normal tkEcho Off
                if not isblank(mp_field7_temp.a) then
                   ErrorProc = "mp_execproc_not_assigned2.n"
                   ExecProc mp_field7_temp.a
                   ErrorProc = "mp_error_proc.n"
                endif
            EndIf
            mp_action_bar_1.u(mp_stack_line_no[1],True,application_name.p)
        Else
                if not isblank(mp_field7_temp.a) then
                   ErrorProc = "mp_execproc_not_assigned2.n"
                   ExecProc mp_field7_temp.a
                   ErrorProc = "mp_error_proc.n"
                endif
            PaintCanvas
            Fill       Chr(mp_colors.r[16])
            Attribute  mp_colors.r[3] 1,0,24,79
        EndIf

        If mp_overwrite_second_line.l Then
            Style Attribute   mp_colors.r[4]
            @1,0 ?? Spaces(80)
        EndIf

        For stack_walk_ptr From 2 To mp_stack_ptr-1
            If mp_stack_box_no[stack_walk_ptr] <> 1              Then
                mp_pulldown_1.u(mp_stack_box_no[stack_walk_ptr],
                mp_stack_line_no[stack_walk_ptr],True,application_name.p)
            Else
                mp_action_bar_1.u(mp_stack_line_no[stack_walk_ptr],True,application_name.p)
            EndIf
        EndFor
    EndIf

    Return False

EndProc

WriteLib libname mp_system_driver_esc.l
Release  Procs   mp_system_driver_esc.l

;*******************************************

Proc mp_menu_set.l(application_name.p)
    Private mp_procname.a
    ,mp_privdir_mp_clr.a

    mp_procname.a = "mp_menu_set.l"

    mp_application_name.a = application_name.p

    Canvas Off
    Cursor Off

    Release Vars mp_splash_screen.r

    ExecProc  application_name.p + "1"
    ExecProc  application_name.p + "2"
    ExecProc  application_name.p + "3"

    mp_privdir_mp_clr.a = privdir()+"mp_clr"

    if isfile(privdir()+"mp_clr.db")
    and not isempty(mp_privdir_mp_clr.a) then
        view mp_privdir_mp_clr.a
        moveto [application_name]
        locate application_name.p
        if retval then
           copytoarray mp_colors.r
        else
           ExecProc  application_name.p + "C"
        endif
        clearimage
    else
        ExecProc  application_name.p + "C"
    endif

    If mp_use_help_message.l Then
        ExecProc application_name.p + "H"
    EndIf

    PaintCanvas
    Fill       Chr(mp_colors.r[16])
    Attribute  mp_colors.r[3]
    1,0,24,79

    array_size       = 15
    mp_field2_temp.a = "C"
    mp_field7_temp.a = ""

    Array mp_stack_box_no[mp_max_tree_depth.n]
    Array mp_stack_line_no[mp_max_tree_depth.n]
    mp_stack_ptr = 0

    first_time_thru=True

    mp_use_stack_push.u(1,1)

    first_time_thru=False

    Array hotkey_pos.r[len(mp_hotkey.r[1])]
    For x From 1 To Len(mp_hotkey.r[1])
        hotkey_pos.r[x] = mp_bar_offset.r[x] + NumVal(Substr(mp_hotkey_position.r[1],(2*x)-1,2))
    EndFor

    array mp_global.r[10]

    Return True

EndProc

WriteLib libname mp_menu_set.l
Release Procs    mp_menu_set.l

;*******************************************

Proc mp_action_bar_1.u(bar_selection.p,rebuild.p,application_name.p)
    Private mp_procname.a
    ,x

    mp_procname.a = "mp_action_bar_1.u"

    PaintCanvas
    Fill mp_box_group.r[1]
    Attribute mp_colors.r[4]
    0,0,0,79

    If mp_overwrite_second_line.l Then
        Style Attribute            mp_colors.r[4]
        @1,0 ?? Spaces(80)
    EndIf

    Style Attribute mp_colors.r[11]
    For x From 1 To Len(mp_hotkey.r[1])
        @  0,hotkey_pos.r[x] ?? Substr(mp_hotkey.r[1],x,1)
    EndFor

    PaintCanvas Attribute            mp_colors.r[5]
    0,mp_bar_offset.r[bar_selection.p],0,mp_bar_offset.r[bar_selection.p+1]-1

EndProc

WriteLib libname mp_action_bar_1.u
Release  Procs   mp_action_bar_1.u

;*******************************************

Proc mp_action_bar_2.n(bar_selection.p,clear_display.p,rebuild.p,application_name.p)
    Private mp_procname.a
    ,keycode
    ,box_height.n

    mp_procname.a = "mp_action_bar_2.n"

    box_height.n = ArraySize(mp_bar_offset.r) - 1

    While True

        If mp_use_help_message.l Then
            mp_help_process.u(1,bar_selection.p,clear_display.p,application_name.p)
        EndIf

        Canvas On
        keycode=GetChar()
        Canvas Off

        Switch
            Case keycode=13           : ; enter
                mp_use_stack_update.u(1,bar_selection.p)
                Return 1

            Case keycode=27           : ; esc
                Return 0

            Case keycode=-75            : ; Left
                mp_reset_old_select_bar.u(bar_selection.p)
                If bar_selection.p > 1        Then
                    bar_selection.p = bar_selection.p - 1
                Else
                    bar_selection.p = box_height.n
                EndIf

            Case keycode=-77              ; Right
                Or keycode=32             : ; space
                mp_reset_old_select_bar.u(bar_selection.p)
                If bar_selection.p < box_height.n  Then
                    bar_selection.p = bar_selection.p + 1
                Else
                    bar_selection.p = 1
                EndIf

            Case keycode=-71               : ; Home
                mp_reset_old_select_bar.u(bar_selection.p)
                bar_selection.p=1

            Case keycode=-79                 : ; End
                mp_reset_old_select_bar.u(bar_selection.p)
                bar_selection.p=box_height.n

            OtherWise                         : ; Bad key
                If  keycode>32
                    And  keycode<127 Then
                    n=mp_action_bar_2_string.n(application_name.p,bar_selection.p)
                    If n=0 Then       ;unique hot-key
                        Return 1
                    Else
                        If n>0 Then       ;duplicate hot-keys
                            bar_selection.p = n
                            PaintCanvas Attribute mp_colors.r[5]
                            0,mp_bar_offset.r[bar_selection.p],0,
                            mp_bar_offset.r[bar_selection.p+1]-1
                            beep
                            Loop
                        EndIf
                    EndIf
                EndIf

                If keycode <> 0 Then
                    n=mp_action_bar_2_shortcut.n(application_name.p,keycode)
                    If n < 0 Then
                        mp_use_stack_update.u(1,bar_selection.p)
                        Return n
                    EndIf
                EndIf

                Beep

        EndSwitch

        PaintCanvas Attribute mp_colors.r[5]
        0,mp_bar_offset.r[bar_selection.p],
        0,mp_bar_offset.r[bar_selection.p+1]-1

    EndWhile

EndProc

WriteLib libname mp_action_bar_2.n
Release  Procs   mp_action_bar_2.n

;*******************************************

Proc mp_action_bar_2_string.n(application_name.p,bar_selection.p)
    Private mp_procname.a
    ,mp_hotkey_position.n

    mp_procname.a = "mp_action_bar_2_string.n"

    mp_hotkey_position.n=Search(Chr(keycode),mp_hotkey.r[1])

    If mp_hotkey_position.n > 0 Then

        mp_reset_old_select_bar.u(bar_selection.p)

        ; check for unique letter match
        If Search(Chr(keycode),Substr(mp_hotkey.r[1],mp_hotkey_position.n+1,21))=0 Then
            PaintCanvas Attribute            mp_colors.r[5]
            0,mp_bar_offset.r[mp_hotkey_position.n],0,mp_bar_offset.r[mp_hotkey_position.n+1]-1
            mp_use_stack_update.u(1,mp_hotkey_position.n)
            Return 0
        Else
            Return mp_hotkey_position.n
        EndIf

    EndIf

    Return -1

EndProc

WriteLib libname mp_action_bar_2_string.n
Release  Procs   mp_action_bar_2_string.n

;*******************************************

Proc  mp_action_bar_2_shortcut.n(application_name.p,keycode.p)
    Private mp_procname.a

    mp_procname.a = "mp_action_bar_2_shortcut.n"

    If keycode.p < 0 Then
        keycode.p = keycode.p + 260
    EndIf

    If IsAssigned(mp_accelerator_key.r[keycode.p]) Then
        Return -mp_accelerator_key.r[keycode.p]
    Else
        Return 0
    EndIf

EndProc

WriteLib libname mp_action_bar_2_shortcut.n
Release  Procs   mp_action_bar_2_shortcut.n

;*******************************************

Proc mp_reset_old_select_bar.u(bar_selection.p)
    Private mp_procname.a
    ,hotkey_pos

    mp_procname.a = "mp_reset_old_select_bar.u"

    PaintCanvas Attribute            mp_colors.r[4]
    0,mp_bar_offset.r[bar_selection.p],0,mp_bar_offset.r[bar_selection.p+1]-1

    hotkey_pos = mp_bar_offset.r[bar_selection.p]+
                 NumVal(Substr(mp_hotkey_position.r[1],(2*bar_selection.p)-1,2))

    Style Attribute mp_colors.r[11]
    @ 0,hotkey_pos ?? Substr(mp_hotkey.r[1],bar_selection.p,1)

EndProc

WriteLib libname mp_reset_old_select_bar.u
Release  Procs   mp_reset_old_select_bar.u

;*******************************************

Proc mp_help_process.u(box_no.p,line_no.p,clear_display.p,application_name.p)
    Private mp_procname.a
    ,help_message_item.n

    mp_procname.a = "mp_help_process.u"

    help_message_item.n = (mp_box_offset.r[box_no.p] + line_no.p - 1)

    If IsAssigned(mp_help_message.r[help_message_item.n])
        Then
        Style Attribute  mp_colors.r[9]
        @24,0 ?? (mp_help_message.r[help_message_item.n]+
                 Spaces(80-Len(mp_help_message.r[help_message_item.n])))
    Else
        If clear_display.p = "C" Then
            Style Attribute  mp_colors.r[3]
            @24,0 ?? Fill(Chr(mp_colors.r[16]),80)
        Else
            Style Attribute  mp_colors.r[9]
            @24,0 ?? Spaces(80)
        EndIf
    EndIf

EndProc

WriteLib libname mp_help_process.u
Release Procs    mp_help_process.u

;*******************************************

Proc mp_pulldown_1.u(box_no.p,line_no.p,rebuild.p,application_name.p)
    Private  mp_procname.a
    ,mp_hotkey_position.n
    ,col_2_1
    ,n
    ,from_box_no.n
    ,to_box_no.n
    ,loop_max

    mp_procname.a = "mp_pulldown_1.u"

    If box_no.p <> 1 Then
        from_box_no.n = mp_box_group_to.r[box_no.p-1]+1
    Else
        from_box_no.n = 1
    EndIf
    to_box_no.n   = mp_box_group_to.r[box_no.p]

    If  mp_colors.r[13]  = "Y" Then
        mp_row_2_1 = mp_row_2.r[to_box_no.n]+1    ;check for off of page
        If mp_row_2_1 > 24 Then
            mp_row_2_1 = 24
        EndIf
        col_2_1 = mp_box_col_end.r[box_no.p]+2    ;check for off of page
        If col_2_1 > 79 Then
            col_2_1 = 79
        EndIf

        PaintCanvas  Attribute mp_colors.r[12]
        mp_row_1.r[from_box_no.n]+1,
        mp_box_col_start.r[box_no.p]+2,
        mp_row_2_1, col_2_1
    EndIf

    For array_loop From from_box_no.n To to_box_no.n
        PaintCanvas
        Fill mp_box_group.r[array_loop]
        Attribute            mp_colors.r[7]
        mp_row_1.r[array_loop],mp_box_col_start.r[box_no.p],
        mp_row_2.r[array_loop],mp_box_col_end.r[box_no.p]
    EndFor

    If mp_colors.r[15]  = "Y" Then
        PaintCanvas  Border
        Attribute    mp_colors.r[14]
        mp_row_1.r[from_box_no.n],mp_box_col_start.r[box_no.p],
        mp_row_2.r[to_box_no.n],mp_box_col_end.r[box_no.p]
    EndIf

    Style Attribute mp_colors.r[10]
    loop_max = Len(mp_hotkey.r[box_no.p])

    For x From 1 To loop_max
        If x <> line_no.p Then
            If Substr(mp_line_intensity.r[box_no.p],x,1) = "2" Then
                mp_hotkey_position.n = (Substr(mp_hotkey_position.r[box_no.p],(2*x)-1,2))
                hotkey_pos_row = mp_row_1.r[from_box_no.n] + x
                hotkey_pos_col = mp_box_col_start.r[box_no.p] + 1 +
                NumVal(mp_hotkey_position.n)
                @ hotkey_pos_row,hotkey_pos_col ?? Substr(mp_hotkey.r[box_no.p],x,1)
            Else
                If Substr(mp_line_intensity.r[box_no.p],x,1) = "1" Then
                    PaintCanvas Attribute   mp_colors.r[6]
                    mp_row_1.r[from_box_no.n] + x, mp_box_col_start.r[box_no.p] + 1,
                    mp_row_1.r[from_box_no.n] + x, mp_box_col_end.r[box_no.p] - 1
                EndIf
            EndIf
        Else
            PaintCanvas Attribute     mp_colors.r[8]
            mp_row_1.r[from_box_no.n] + line_no.p,mp_box_col_start.r[box_no.p] + 1,
            mp_row_1.r[from_box_no.n] + line_no.p,mp_box_col_end.r[box_no.p] - 1
        EndIf
    EndFor

EndProc

WriteLib libname mp_pulldown_1.u
Release  Procs   mp_pulldown_1.u

;*******************************************

Proc mp_pulldown_2.n(box_no.p,line_no.p,clear_display.p,rebuild.p,application_name.p)
    Private  mp_procname.a
    ,mp_hotkey_position.n
    ,n
    ,from_box_no.n
    ,to_box_no.n
    ,box_height.n
    ,mp_row_2.r_1

    mp_procname.a = "mp_pulldown_2.n"

    If box_no.p <> 1 Then
        from_box_no.n = mp_box_group_to.r[box_no.p-1]+1
    Else
        from_box_no.n = 1
    EndIf
    to_box_no.n   = mp_box_group_to.r[box_no.p]

    box_height.n = mp_row_2.r[mp_box_group_to.r[box_no.p]] -
                   mp_row_1.r[mp_box_group_to.r[box_no.p-1]+1]+1

    While True
        If mp_use_help_message.l Then
            mp_help_process.u(box_no.p,line_no.p,clear_display.p,application_name.p)
        EndIf

        Canvas On
        keycode=GetChar()
        Canvas Off

        Switch
            Case keycode=-80 Or keycode=32  : ; Down
                mp_reset_old_select_line.u(line_no.p, from_box_no.n, box_no.p)
                line_no.p = mp_next_line_in_box.n(box_no.p,line_no.p,"DOWN",box_height.n)

            Case keycode=-72                : ; Up
                mp_reset_old_select_line.u(line_no.p, from_box_no.n, box_no.p)
                line_no.p = mp_next_line_in_box.n(box_no.p,line_no.p,"UP",box_height.n)

            Case keycode=-75                : ; left
                l = mp_check_for_first_pulldown.l(box_no.p)
                If  l Then
                    mp_sideways_process.u(-75,box_no.p)
                    Return 1
                Else
                    Beep
                EndIf

            Case keycode=-77                : ; right
                l = mp_check_for_first_pulldown.l(box_no.p)
                If  l Then
                    mp_sideways_process.u(-77,box_no.p)
                    Return 1
                Else
                    Beep
                EndIf

            Case keycode=-71               : ; Home
                mp_reset_old_select_line.u(line_no.p, from_box_no.n, box_no.p)
                line_no.p = mp_next_line_in_box.n(box_no.p,0,"DOWN",box_height.n)

            Case keycode=-79               : ; End
                mp_reset_old_select_line.u(line_no.p, from_box_no.n, box_no.p)
                line_no.p = mp_next_line_in_box.n(box_no.p,box_height.n-1,"UP",box_height.n)

            Case keycode=13                 : ; enter
                If Substr(mp_line_intensity.r[box_no.p],line_no.p,1) = "1" Then
                    Beep
                    Loop
                EndIf
                mp_use_stack_update.u(box_no.p,line_no.p)
                Return 1

            Case keycode=27                 : ; esc
                mp_use_stack_update.u(box_no.p,0)
                Return 0

            OtherWise                      : ; check shortcut keys
                If  keycode > 32
                    And keycode < 127 Then
                    l=mp_pulldown_2_string.l(application_name.p)
                    If l Then
                        Return 1
                    EndIf
                EndIf

                n=mp_pulldown_2_shortcut.n(application_name.p,keycode)
                If n < 0 Then
                    Return n
                EndIf

                Beep

        EndSwitch

        PaintCanvas Attribute  mp_colors.r[8]
        mp_row_1.r[from_box_no.n] + line_no.p,mp_box_col_start.r[box_no.p] + 1,
        mp_row_1.r[from_box_no.n] + line_no.p,mp_box_col_end.r[box_no.p] - 1

    EndWhile

EndProc

WriteLib libname mp_pulldown_2.n
Release  Procs   mp_pulldown_2.n

;*******************************************

Proc  mp_pulldown_2_string.l(application_name.p)
    Private mp_procname.a
    ,mp_hotkey_position.n

    mp_procname.a = "mp_pulldown_2_string.l"

    mp_hotkey_position.n=Search(Chr(keycode),mp_hotkey.r[box_no.p])

    If mp_hotkey_position.n > 0 Then ; letter match
        mp_reset_old_select_line.u(line_no.p, from_box_no.n, box_no.p)
        PaintCanvas Attribute            mp_colors.r[8]
        mp_row_1.r[from_box_no.n] + mp_hotkey_position.n,mp_box_col_start.r[box_no.p] + 1,
        mp_row_1.r[from_box_no.n] + mp_hotkey_position.n,mp_box_col_end.r[box_no.p] - 1
        ; check for unique letter match
        If Search(Chr(keycode),Substr(mp_hotkey.r[box_no.p],mp_hotkey_position.n+1,21))=0 Then
            If Substr(mp_line_intensity.r[box_no.p],mp_hotkey_position.n,1) = "1" Then
                line_no.p = mp_hotkey_position.n
                Beep
                Return False ;Loop
            Else
                If mp_use_help_message.l Then
                    mp_help_process.u(box_no.p,mp_hotkey_position.n,
                                      clear_display.p,application_name.p)
                EndIf
                mp_use_stack_update.u(box_no.p,mp_hotkey_position.n)
                Return True
            EndIf
        Else
            line_no.p = mp_hotkey_position.n
            Return False
        EndIf
    Else
        Return False ;Loop

    EndIf

EndProc

WriteLib libname mp_pulldown_2_string.l
Release  Procs   mp_pulldown_2_string.l

;*******************************************

Proc  mp_pulldown_2_shortcut.n(application_name.p,keycode.p)
    Private mp_procname.a

    mp_procname.a = "mp_pulldown_2_shortcut.n"

    If keycode.p < 0 Then
        keycode.p = keycode.p + 260
    EndIf

    If IsAssigned(mp_accelerator_key.r[keycode.p]) Then
        Return -mp_accelerator_key.r[keycode.p]
    Else
        Return 0
    EndIf

EndProc

WriteLib libname mp_pulldown_2_shortcut.n
Release  Procs   mp_pulldown_2_shortcut.n

;*******************************************

Proc  mp_next_line_in_box.n(box_no.p,line_no.p,direction.p,box_height.p)
    Private mp_procname.a

    mp_procname.a = "mp_next_line_in_box.n"

    If direction.p = "DOWN" Then
        While True
            If line_no.p <> box_height.p-2 Then
                line_no.p = line_no.p + 1
            Else
                line_no.p =  1
            EndIf
            If Substr(mp_line_intensity.r[box_no.p],line_no.p,1) <> "0" Then
                QuitLoop
            EndIf
        EndWhile
    Else
        While True
            If line_no.p <> 1 Then
                line_no.p = line_no.p - 1
            Else
                line_no.p = box_height.p-2
            EndIf
            If  Substr(mp_line_intensity.r[box_no.p],line_no.p,1) <> "0" Then
                QuitLoop
            EndIf
        EndWhile
    EndIf

    Return line_no.p

EndProc

WriteLib libname mp_next_line_in_box.n
Release  Procs   mp_next_line_in_box.n

;*******************************************

Proc mp_check_for_first_pulldown.l(box_no.p)
    Private mp_procname.a
    ,mp_size_first_pulldown_list.n
    ,ptr

    mp_procname.a = "mp_check_for_first_pulldown.l"

    mp_size_first_pulldown_list.n = ArraySize(mp_first_pulldown_list.r)
    For ptr From 1 To mp_size_first_pulldown_list.n
        If Not IsAssigned(mp_first_pulldown_list.r[ptr]) Then
            Return False
        Else
            If mp_first_pulldown_list.r[ptr] = box_no.p Then
                Return True
            Else
                If mp_first_pulldown_list.r[ptr] > box_no.p Then
                    Return False
                EndIf
            EndIf
        EndIf
    EndFor

    Return False

EndProc

WriteLib libname mp_check_for_first_pulldown.l
Release  Procs   mp_check_for_first_pulldown.l

;*******************************************

Proc mp_reset_old_select_line.u(line_no.p,from_box_no.p,box_no.p)
    Private mp_procname.a
        ,hotkey_pos_row
        ,hotkey_pos_col

    mp_procname.a = "mp_reset_old_select_line.u"

    If Substr(mp_line_intensity.r[box_no.p],line_no.p,1) = "2" Then
        PaintCanvas Attribute  mp_colors.r[7]
        mp_row_1.r[from_box_no.p] + line_no.p, mp_box_col_start.r[box_no.p] + 1,
        mp_row_1.r[from_box_no.p] + line_no.p, mp_box_col_end.r[box_no.p] - 1

        hotkey_pos_row = mp_row_1.r[from_box_no.p] + line_no.p
        hotkey_pos_col = mp_box_col_start.r[box_no.p] + 1 +
        NumVal(Substr(mp_hotkey_position.r[box_no.p], (2*line_no.p)-1, 2))

        Style Attribute mp_colors.r[10]
        @ hotkey_pos_row,hotkey_pos_col ?? Substr(mp_hotkey.r[box_no.p],line_no.p,1)

    Else
        PaintCanvas Attribute   mp_colors.r[6]
        mp_row_1.r[from_box_no.n] + line_no.p, mp_box_col_start.r[box_no.p] + 1,
        mp_row_1.r[from_box_no.n] + line_no.p, mp_box_col_end.r[box_no.p] - 1
    EndIf

EndProc

WriteLib libname mp_reset_old_select_line.u
Release  Procs   mp_reset_old_select_line.u

;*******************************************

Proc  mp_use_stack_pop.u(box_no.p,line_no.p)
    Private   mp_procname.a

    mp_procname.a = "mp_use_stack_pop.u"

    If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
        l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
        If l
            And Not IsBlank(mp_stack_field2.a) Then
            ExecProc mp_stack_field2.a
        EndIf
    EndIf

    mp_stack_ptr = mp_stack_ptr - 1

    If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
        l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
        If l
            And Not IsBlank(mp_stack_field1.a) Then
            ExecProc mp_stack_field1.a
        EndIf
    EndIf

EndProc

WriteLib libname mp_use_stack_pop.u
Release  Procs   mp_use_stack_pop.u

;*******************************************

Proc  mp_use_stack_push.u(box_no.p,line_no.p)
    Private   mp_procname.a

    mp_procname.a = "mp_use_stack_push.u"

    If Not first_time_thru Then
        If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
            l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
            If l
                And Not IsBlank(mp_stack_field2.a) Then
                ExecProc mp_stack_field2.a
            EndIf
        EndIf
    EndIf

    ;the generating program must make sure that the stack limit is not exceeded!
    mp_stack_ptr                   = mp_stack_ptr + 1
    mp_stack_box_no[mp_stack_ptr]  = box_no.p
    mp_stack_line_no[mp_stack_ptr] = line_no.p

    If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
        l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
        If l
            And Not IsBlank(mp_stack_field1.a) Then
            ExecProc mp_stack_field1.a
        EndIf
    EndIf

EndProc

WriteLib libname mp_use_stack_push.u
Release  Procs   mp_use_stack_push.u

;*******************************************

Proc  mp_use_stack_clear.u(box_no.p,line_no.p)
    Private   mp_procname.a

    mp_procname.a = "mp_use_stack_clear.u"

    If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
        l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
        If l
            And Not IsBlank(mp_stack_field2.a) Then
            ExecProc mp_stack_field2.a
        EndIf
    EndIf

    mp_stack_ptr                   = 1
    mp_stack_box_no[mp_stack_ptr]  = box_no.p
    mp_stack_line_no[mp_stack_ptr] = line_no.p

    If IsAssigned(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]]) Then
        l = Match(mp_control_box.r[mp_stack_box_no[mp_stack_ptr]], "..,..", mp_stack_field1.a, mp_stack_field2.a)
        If l
            And Not IsBlank(mp_stack_field1.a) Then
            ExecProc mp_stack_field1.a
        EndIf
    EndIf

EndProc

WriteLib libname mp_use_stack_clear.u
Release  Procs   mp_use_stack_clear.u

;*******************************************

Proc  mp_use_stack_update.u(box_no.p,line_no.p)
    Private   mp_procname.a

    mp_procname.a = "mp_use_stack_update.u"

    mp_stack_box_no[mp_stack_ptr]  = box_no.p
    mp_stack_line_no[mp_stack_ptr] = line_no.p

EndProc

WriteLib libname mp_use_stack_update.u
Release  Procs   mp_use_stack_update.u

;*******************************************

Proc mp_sideways_process.u(direction.p,box_no.p)
    private mp_procname.a
    ,from_box_no.n
    ,to_box_no.n
    ,old_choice
    ,choice
    ,box_height.n

    mp_procname.a = "mp_sideways_process.u"

    box_height.n = ArraySize(mp_bar_offset.r) - 1

    If box_no.p <> 1 Then
        from_box_no.n = mp_box_group_to.r[box_no.p-1]+1
    Else
        from_box_no.n = 1
    EndIf
    to_box_no.n   = mp_box_group_to.r[box_no.p]

    mp_use_stack_pop.u("","")

    old_bar_selection.n = mp_stack_line_no[mp_stack_ptr]
    If direction.p = -75 Then
        If old_bar_selection.n <> 1 Then
            bar_selection.n = old_bar_selection.n - 1
        Else
            bar_selection.n = box_height.n
        EndIf
    Else
        If old_bar_selection.n < box_height.n Then
            bar_selection.n = old_bar_selection.n + 1
        Else
            bar_selection.n = 1
        EndIf
    EndIf

    If  mp_field2_temp.a = "E" Then
        If not IsRuntime() Then
            Echo Normal Echo Off
            if not isblank(mp_field7_temp.a) then
               ErrorProc = "mp_execproc_not_assigned2.n"
               ExecProc mp_field7_temp.a
               ErrorProc = "mp_error_proc.n"
            endif
        else
            tkEcho Normal tkEcho Off
            if not isblank(mp_field7_temp.a) then
               ErrorProc = "mp_execproc_not_assigned2.n"
               ExecProc mp_field7_temp.a
               ErrorProc = "mp_error_proc.n"
            endif
        EndIf
        mp_action_bar_1.u(bar_selection.n,True,application_name.p)
    Else
            if not isblank(mp_field7_temp.a) then
               ErrorProc = "mp_execproc_not_assigned2.n"
               ExecProc mp_field7_temp.a
               ErrorProc = "mp_error_proc.n"
            endif
        PaintCanvas  Attribute  mp_colors.r[4]
        0,mp_bar_offset.r[old_bar_selection.n],0,mp_bar_offset.r[old_bar_selection.n+1]-1

        Style Attribute            mp_colors.r[11]

        @ 0, mp_bar_offset.r[old_bar_selection.n] + NumVal(Substr(mp_hotkey_position.r[1],(2*old_bar_selection.n)-1,2))
        ?? Substr(mp_hotkey.r[1],old_bar_selection.n,1)

        If mp_colors.r[13]  = "Y" Then
            mp_row_2.r_1 = mp_row_2.r[to_box_no.n]+1    ;check for off of page
            If mp_row_2.r_1 > 24 Then
                mp_row_2.r_1 = 24
            EndIf
            col_2_1 = mp_box_col_end.r[box_no.p]+2    ;check for off of page
            If col_2_1 > 79 Then
                col_2_1 = 79
            EndIf
            PaintCanvas Fill Chr(mp_colors.r[16])
            Attribute   mp_colors.r[3]
            mp_row_1.r[from_box_no.n],mp_box_col_start.r[box_no.p],
            mp_row_2.r_1, col_2_1
        Else
            PaintCanvas Fill Chr(mp_colors.r[16])
            Attribute   mp_colors.r[3]
            mp_row_1.r[from_box_no.n],mp_box_col_start.r[box_no.p],
            mp_row_2.r[to_box_no.n],mp_box_col_end.r[box_no.p]
        EndIf

        PaintCanvas Attribute mp_colors.r[5]
        0,mp_bar_offset.r[bar_selection.n],0,mp_bar_offset.r[bar_selection.n+1]-1

    EndIf

    If mp_overwrite_second_line.l Then
        Style Attribute  mp_colors.r[4]
        @1,0 ?? Spaces(80)
    EndIf

    mp_use_stack_update.u(1,bar_selection.n)

EndProc

WriteLib libname mp_sideways_process.u
Release Procs    mp_sideways_process.u

;*******************************************

Proc        mp_error_proc.n()
    Private returncode

    ErrorProc  = ""
    Canvas On
    returncode = mp_error_menu.n()
    Return returncode

EndProc

WriteLib libname mp_error_proc.n
Release Procs    mp_error_proc.n

;*******************************************

Proc        mp_error_menu.n()
    Private ecode
    ,emsg
    ,choice

    ecode = ErrorCode()

    If IsAssigned(mp_procname.a) Then
        emsg = ErrorMessage() + " (" + mp_procname.a + ":" + StrVal(ecode) + ")"
    Else
        emsg = ErrorMessage() + " (" + StrVal(ecode) + ")"
    EndIf

    Beep Sleep 100 Beep

    Canvas On
    Message emsg

    ShowMenu
        "Stop":        "Stop this program and return to Paradox"
        ;   "TryAgain":    "Repeat the operation that caused the error"
        Default "Stop"
    To choice

    While True
        Switch
            Case choice = "Stop" :
                mp_error_dump.u()
                Clear ClearAll Reset
                Quit

            Case choice = "Esc" :
                mp_error_dump.u()
                Clear ClearAll Reset
                Quit

            OtherWise :
                Beep
        EndSwitch
    EndWhile

EndProc

WriteLib libname mp_error_menu.n
Release Procs    mp_error_menu.n

;*******************************************

Proc        mp_error_dump.u()
    Private err_file
    ,err_file_part

    If SysMode() <> "Main" Then
        Do_it!
    EndIf

    err_file_part = PrivDir() + "ERRDUMP"
    err_file      = err_file_part + ".SC"

    If IsFile(err_file) Then
        Menu {Tools} {Delete} {Script} Select err_file_part {ok}
    EndIf

    Canvas On

    Message "Creating error diagnosis files"

    Print File err_file "-----------------------------------------------------------", "\n"
    Print File err_file "Date         : ", Today(), "\n"
    Print File err_file "Time         : ", Time(), "\n"
    Print File err_file "UserName     : ", UserName(), "\n"
    Print File err_file "ErrorMessage : ", ErrorMessage(), "\n"
    Print File err_file "ErrorCode    : ", ErrorCode(), "\n"

    If  IsAssigned(mp_procname.a) Then
        Print File err_file "mp_ProcName.a: ", mp_procname.a, "\n"
    EndIf

    Print File err_file "Directory    : ", Directory(), "\n"
    Print File err_file "DriveSpace  ", Substr( Directory(), 1, 1 ), ": ",
    DriveSpace(Substr(Directory(), 1, 1 )), "\n"
    Print File err_file "IsBlankZero  : ", IsBlankZero(), "\n"
    Print File err_file "IsRunTime    : ", IsRuntime(), "\n"
    Print File err_file "MemLeft      : ", MemLeft(), "\n"
    Print File err_file "MenuChoice   : ", MenuChoice(), "\n"
    Print File err_file "Monitor      : ", Monitor(), "\n"
    Print File err_file "NetType      : ", NetType(), "\n"
    Print File err_file "Nimages      : ", NImages(), "\n"

    If NImages() > 0 Then
        Print File err_file "Table        : ", Table(), "\n"
        Print File err_file "ImageNo      : ", ImageNo(), "\n"
        Print File err_file "ImageType    : ", ImageType(), "\n"
    EndIf

    Print File err_file "PrivDir      : ", PrivDir(), "\n"
    Print File err_file "QueryOrder   : ", QueryOrder(), "\n"
    Print File err_file "RetryPeriod  : ", RetryPeriod(), "\n"
    Print File err_file "Sdir         : ", SDir(), "\n"
    Print File err_file "SortOrder    : ", SortOrder(), "\n"
    Print File err_file "Sysmode      : ", SysMode(), "\n"
    Print File err_file "Version      : ", Version(), "\n"

    Print File err_file "-----------------------------------------------------------", "\n"

    savevars_date = Today()
    savevars_time = Time()

    SaveVars All

EndProc

WriteLib libname mp_error_dump.u
Release Procs    mp_error_dump.u

;*******************************************

Proc mp_splash_screen_draw.u(box_color.p,back_pattern.p,back_color.p,start_row.p)
    Private mp_procname.a

    mp_procname.a = "mp_splash_screen_draw.u"

    PaintCanvas Fill Chr(back_pattern.p) Attribute (back_color.p)
    start_row.p,0,24,79

    Style Attribute (box_color.p)

    @ 08,18
    SetMargin 18
    ?? "",Fill("",44),""
    ? " ",mp_splash_screen.r[1] + Fill(" ",42 - Len(mp_splash_screen.r[1]))," "
    ? " ",mp_splash_screen.r[2] + Fill(" ",42 - Len(mp_splash_screen.r[2]))," "
    ? " ",mp_splash_screen.r[3] + Fill(" ",42 - Len(mp_splash_screen.r[3]))," "
    ? " ",mp_splash_screen.r[4] + Fill(" ",42 - Len(mp_splash_screen.r[4]))," "
    ? " ",mp_splash_screen.r[5] + Fill(" ",42 - Len(mp_splash_screen.r[5]))," "
    ? " ",mp_splash_screen.r[6] + Fill(" ",42 - Len(mp_splash_screen.r[6]))," "
    ? "",Fill("",44),""

EndProc

WriteLib libname mp_splash_screen_draw.u
Release  Procs   mp_splash_screen_draw.u

;*******************************************

Proc mp_release_vars_box.u()
    Private mp_procname.a

    mp_procname.a = "mp_release_vars_box.u"

  ;  array  mp_line_intensity_temp.r[arraysize(mp_line_intensity.r)]

    Release Vars
    mp_row_1.r
    ,mp_row_2.r
    ,mp_box_col_start.r
    ,mp_box_col_end.r
    ,mp_box_group_to.r
    ,mp_box_group.r
    ,mp_hotkey.r
    ,mp_hotkey_position.r
    ,mp_box_offset.r
    ,mp_control_line.r
    ,mp_control_box.r
    ,mp_first_pulldown_list.r
    ,mp_bar_offset.r
    ,mp_max_tree_depth.n
    ,mp_use_help_message.l
    ,mp_overwrite_second_line.l
    ,mp_accelerator_key.r

EndProc

WriteLib libname mp_release_vars_box.u
Release  Procs   mp_release_vars_box.u

;*******************************************

Proc  mp_release_vars_misc.u()
    Private mp_procname.a

    mp_procname.a = "mp_release_vars_misc.u"

    SaveVars  application_name.p
    ,array_loop
    ,array_size
    ,AutoLib
    ,do_it_mp_procname.a
    ,do_it_seq_no
    ,entered_checkbox
    ,first_time_thru
    ,hotkey_pos.r
    ,hotkey_pos_col
    ,hotkey_pos_row
    ,mp_hotkey_position.n
    ,keycode
    ,l
    ,LastIdx
    ,LastPos
    ,mp_stack_box_no
    ,mp_stack_line_no
    ,mp_stack_ptr
    ,mp_field1.a
    ,mp_field3.a
    ,mp_procname.a
    ,production.p
    ,record_count
    ,Redraw
    ,x

    Run NoRefresh "copy "+PrivDir()+"savevars.sc "+PrivDir()+"mp_savev.sc >nul"

    Release Vars application_name.p
    ,array_loop
    ,array_size
    ,do_it_mp_procname.a
    ,do_it_seq_no
    ,entered_checkbox
    ,first_time_thru
    ,hotkey_pos.r
    ,hotkey_pos_col
    ,hotkey_pos_row
    ,mp_hotkey_position.n
    ,keycode
    ,l
    ,LastIdx
    ,LastPos
    ,mp_stack_box_no
    ,mp_stack_line_no
    ,mp_stack_ptr
    ,mp_field1.a
    ,mp_field3.a
    ,record_count
    ,Redraw
    ,x

EndProc

WriteLib libname mp_release_vars_misc.u
Release  Procs   mp_release_vars_misc.u

;*******************************************
