
libname = "mp_clr"
Message "Building ", libname

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Copyright_1992_William_Mekeel()
    copyright.a = "   Copyright (c) 1992 William Mekeel  All Rights Reserved  "
    version.a   = "   MENUPAL version 1.00  "
EndProc

WriteLib libname   copyright_1992_William_Mekeel
Release  Procs     copyright_1992_William_Mekeel

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_screen_colors_enter.u()
    Private mp_procname.a

    mp_procname.a = "mp_screen_colors_enter.u"

    If  mp_hot > 0
        And mp_hot < 11 Then
        mp_hot_1_10.u()
    Else
        If mp_hot = 11 Then
            mp_hot_11_13.u(17,13,1)
        Else
            If mp_hot = 12 Then
                mp_hot_12.u()
            Else
                If mp_hot = 13 Then
                    mp_hot_11_13.u(20,15,11)
                Else
                    mp_hot_14.u()
                EndIf
            EndIf
        EndIf
    EndIf

EndProc

WriteLib libname mp_screen_colors_enter.u
Release  Procs   mp_screen_colors_enter.u

;**********************************************************************

Proc        mp_hot_1_10.u()
    Private mp_procname.a

    mp_procname.a = "mp_hot_1_10.u"

    PaintCanvas Attribute mp_screen_box_color.n
    6+mp_hot, 4, 6+mp_hot, 24
    Cursor box
    mp_process_row.u(mp_hot)
    mp_paint_choice_info.u()
    Cursor Off

EndProc

WriteLib libname mp_hot_1_10.u
Release Procs    mp_hot_1_10.u

;**********************************************************************

Proc        mp_hot_12.u()
    Private mp_procname.a

    mp_procname.a = "mp_hot_12.u"

    PaintCanvas Attribute mp_screen_box_color.n
    19, 4, 19, 24
    Cursor box
    mp_process_row.u(mp_hot)
    mp_paint_choice_info.u()
    Cursor Off

EndProc

WriteLib libname mp_hot_12.u
Release Procs    mp_hot_12.u

;**********************************************************************

Proc        mp_hot_11_13.u(row.p,color.p,paint.p)
    Private mp_procname.a

    mp_procname.a = "mp_hot_11_13.u"

    mp_paint_info_2.u()
    PaintCanvas Attribute mp_screen_box_color.n
    row.p, 4, row.p, 24
    Cursor box
    @ row.p, 26
    Style Attribute mp_screen_back_color.n
    Canvas On

    Accept "a1"
    Picture "{Y,y,N,n}"
    default  mp_colors_temp.r[color.p]
    Required
    To mp_answer
    If Not RetVal Then      ;esc
        mp_answer = mp_colors_orig.r[color.p]
        mp_colors_temp.r[15]      = mp_answer
        @ row.p, 26
        ?? mp_answer
    EndIf

    PaintCanvas Attribute mp_screen_box_color.n
    row.p, 26, row.p, 26

    Cursor Off
    Canvas Off
    mp_colors_temp.r[color.p]      = upper(mp_answer)
    if paint.p = 1 then
      mp_paint_mini_screen_1.u()
    else
      mp_paint_mini_screen_11.u()
    endif
    mp_paint_choice_info.u()

EndProc

WriteLib libname mp_hot_11_13.u
Release Procs    mp_hot_11_13.u

;**********************************************************************

Proc        mp_hot_14.u()
    Private mp_procname.a

    mp_procname.a = "mp_hot_14.u"

    mp_paint_info_3.u()
    PaintCanvas Attribute mp_screen_box_color.n
    22, 4, 22, 24
    Cursor box
    mp_process_row2.u()
    mp_paint_choice_info.u()
    Cursor Off

EndProc

WriteLib libname mp_hot_14.u
Release Procs    mp_hot_14.u

;**********************************************************************

Proc mp_screen_colors_up.u()
    Private mp_procname.a

    mp_procname.a = "mp_screen_colors_up.u"

    If mp_hot > 1  Then
        mp_hot = mp_hot - 1
    Else
        mp_hot = 14
    EndIf

    Switch
        Case mp_hot = 14 :
            PaintCanvas Attribute mp_screen_box_color.n
            7, 4, 7, 24

        Case mp_hot > 0
            And  mp_hot < 11 :
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+7, 4, mp_hot+7, 24

        Case mp_hot > 10
            And  mp_hot <  13 :
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+8,4, mp_hot+8, 24

        Case mp_hot =  13 :
            PaintCanvas Attribute mp_screen_box_color.n
            22, 4, 22, 24

    EndSwitch

EndProc

WriteLib libname mp_screen_colors_up.u
Release  Procs   mp_screen_colors_up.u

;**********************************************************************

Proc mp_screen_colors_down.u()
    Private mp_procname.a

    mp_procname.a = "mp_screen_colors_down.u"

    If mp_hot < 14 Then
        mp_hot = mp_hot + 1
    Else
        mp_hot = 1
    EndIf

    Switch
        Case mp_hot = 1 :
            PaintCanvas Attribute mp_screen_box_color.n
            22, 4, 22, 24

        Case mp_hot > 1
            And  mp_hot < 13 :
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+5, 4, mp_hot+5, 24

        Case mp_hot > 12
            And  mp_hot < 15 :
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+6, 4, mp_hot+6, 24

    EndSwitch

EndProc

WriteLib libname mp_screen_colors_down.u
Release  Procs   mp_screen_colors_down.u

;**********************************************************************

Proc mp_screen_colors_esc.l()
    Private mp_procname.a

    mp_procname.a = "mp_screen_colors_esc.l"

    If   mp_hot < 12 Then
        PaintCanvas Attribute mp_screen_box_color.n
        6+mp_hot,4, 6+mp_hot, 24
    Else
        If   mp_hot <  14 Then
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+7,4, mp_hot+7, 24
        Else
            PaintCanvas Attribute mp_screen_box_color.n
            mp_hot+8,4, mp_hot+8, 24
        EndIf
    EndIf

    mp_paint_quit_box.u()
    Cursor box
    Canvas On
    @ 19, 58
    Accept "a1"
    Picture "{Y,y,N,n}"
    Default "N"
    Required
    To mp_answer
    Cursor Off
    Canvas Off
    If Not RetVal Then      ;Esc key pressed
        Return False ;QuitLoop
    Else
        If mp_answer = "Y" Then
            Return False ;QuitLoop
        Else
            mp_paint_choice_info.u()
            mp_hot = 1
        EndIf
    EndIf

    Return True

EndProc

WriteLib libname mp_screen_colors_esc.l
Release  Procs   mp_screen_colors_esc.l

;**********************************************************************

Proc mp_screen_colors_f6.u(application_name.p,process_system_table.p)
    Private mp_procname.a
    ,mp_selection.a

    mp_procname.a = "mp_screen_colors_f6.u"

    if process_system_table.p then
       setpopup2("mp_color","application_name",0)
    else
       if isblank(privdir()) then
          mp_temp_directory.a = directory()
       else
          mp_temp_directory.a = privdir()
       endif
       mp_privdir_mp_clr.a = mp_temp_directory.a+"mp_clr"
       setpopup2(mp_privdir_mp_clr.a,"application_name",0)
    endif

    mp_selection.a = popup2(06,34,6,1,"Select From:      ")

    Canvas Off

    if not isblank(mp_selection.a) then
       MoveTo [application_name]
       Locate mp_selection.a
       copytoarray mp_colors_temp.r
    endif

    MoveTo [application_name]
    Locate application_name.p
            mp_colors_temp.r[2] = application_name.p
            copyfromarray mp_colors_temp.r

    skip 0

    If not IsRuntime() Then
       Echo Normal Echo Off
    else
       tkEcho Normal tkEcho Off
    EndIf

    paintcanvas attribute 51 0,0,1,79
    paintcanvas fill application_name.p+spaces(7-len(application_name.p))
                attribute 30 3,43,3,49

    mp_paint_mini_screen_99.u()

    Cursor Off
    Canvas On

EndProc

WriteLib libname mp_screen_colors_f6.u
Release  Procs   mp_screen_colors_f6.u

;**********************************************************************

Proc mp_paint_mini_screen_1.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_mini_screen_1.u"

    PaintCanvas          Attribute mp_colors_temp.r[3]
    8,35,12,38
    PaintCanvas          Attribute mp_colors_temp.r[3]
    13,35,13,39
    PaintCanvas          Attribute mp_colors_temp.r[3]
    8,51,13,54

    if upper(mp_colors_temp.r[13]) = "Y" then
    PaintCanvas fill "0"         Attribute mp_colors_temp.r[12]
        9,50,13,50
    PaintCanvas fill "0"         Attribute mp_colors_temp.r[12]
        13,40,13,49
    PaintCanvas fill "1"         Attribute mp_colors_temp.r[3]
        8,50,8,50
    Else
    PaintCanvas fill "1"         Attribute mp_colors_temp.r[3]
        8,50,13,50
    PaintCanvas fill "1"         Attribute mp_colors_temp.r[3]
        13,40,13,49
    EndIf

EndProc

WriteLib libname mp_paint_mini_screen_1.u
Release  Procs   mp_paint_mini_screen_1.u

;**********************************************************************

Proc mp_paint_mini_screen_10.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_mini_screen_10.u"

    if upper(mp_colors_temp.r[13]) = "Y" then
    PaintCanvas fill "0"         Attribute mp_colors_temp.r[12]
        9,50,13,50
    PaintCanvas fill "0"         Attribute mp_colors_temp.r[12]
        13,40,13,49
    Else
    PaintCanvas fill "1"         Attribute mp_colors_temp.r[3]
        9,50,13,50
    PaintCanvas fill "1"         Attribute mp_colors_temp.r[3]
        13,40,13,49
    EndIf

EndProc

WriteLib libname mp_paint_mini_screen_10.u
Release  Procs   mp_paint_mini_screen_10.u

;**********************************************************************

Proc mp_paint_mini_screen_11.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_mini_screen_11.u"

    if upper(mp_colors_temp.r[15]) = "Y" then
    PaintCanvas border  Attribute mp_colors_temp.r[14]
        8,39,12,49
    Else
    PaintCanvas border  Attribute mp_colors_temp.r[7]
        8,39,12,49
    EndIf

EndProc

WriteLib libname mp_paint_mini_screen_11.u
Release  Procs   mp_paint_mini_screen_11.u

;**********************************************************************

Proc mp_paint_mini_screen_99.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_mini_screen_99.u"

    PaintCanvas          Attribute mp_colors_temp.r[3]
    8,35,13,54
    PaintCanvas          Attribute mp_colors_temp.r[4]
    7,35,7,54
    PaintCanvas          Attribute mp_colors_temp.r[5]
    7,39,7,44
    PaintCanvas          Attribute mp_colors_temp.r[11]
    7,40,7,40
    PaintCanvas          Attribute mp_colors_temp.r[10]
    9,40,9,40

    mp_paint_mini_screen_10.u()

    mp_paint_mini_screen_11.u()

    PaintCanvas          Attribute mp_colors_temp.r[7]
    9,41,9,48
    PaintCanvas          Attribute mp_colors_temp.r[8]
    10,40,10,48
    PaintCanvas          Attribute mp_colors_temp.r[6]
    11,40,11,48
    PaintCanvas          Attribute mp_colors_temp.r[9]
    14,35,14,54

EndProc

WriteLib libname mp_paint_mini_screen_99.u
Release  Procs   mp_paint_mini_screen_99.u

;**********************************************************************

Proc mp_draw_mini_screen_2_7.u()
    Private mp_procname.a

    mp_procname.a = "mp_draw_mini_screen_2_7.u"

    @08,35 ?? "1111Ŀ11111"
    @09,35 ?? "111185555555511111"
    @10,35 ?? "111166666666611111"
    @11,35 ?? "111144444444411111"
    @12,35 ?? "111111111"
    @13,35 ?? "11111111111111111111"

EndProc

WriteLib libname mp_draw_mini_screen_2_7.u
Release  Procs   mp_draw_mini_screen_2_7.u

;**********************************************************************

Proc mp_paint_choice_info.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_choice_info.u"

            PaintCanvas
            Fill " "  Attribute mp_screen_back_color.n
            18, 34, 24, 70

    Style Attribute mp_screen_box_color.n
    @18,0
    SetMargin 34

Text
 INFO Ŀ
  keys scroll selections;         
 Esc key quits *without* save;     
 F2 key quits *with* save;         
 F6 key copies color values;       
 Enter key selects color edit mode 

EndText

EndProc

WriteLib libname mp_paint_choice_info.u
Release Procs    mp_paint_choice_info.u

;**********************************************************************

Proc mp_paint_palette_info.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_palette_info.u"

            PaintCanvas
            Fill " "  Attribute mp_screen_back_color.n
            18, 34, 24, 70

    Style Attribute mp_screen_box_color.n
    @18,0
    SetMargin 34

Text
 INFO Ŀ
  keys increment by +/-1;        
  keys increment by +/-16;       
 'B' key toggles blinking;        
 Esc key restores original value; 
 Enter key saves current value.   

EndText

EndProc

WriteLib libname mp_paint_palette_info.u
Release Procs    mp_paint_palette_info.u

;**********************************************************************

Proc mp_paint_info_2.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_info_2.u"

            PaintCanvas
            Fill " "  Attribute mp_screen_back_color.n
            18, 34, 24, 70

    Style Attribute mp_screen_box_color.n
    @18,0
    SetMargin 34

Text
 INFO Ŀ
 Esc key restores original value; 
 Enter key saves current value.   

EndText

EndProc

WriteLib libname mp_paint_info_2.u
Release Procs    mp_paint_info_2.u

;**********************************************************************

Proc mp_paint_info_3.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_info_3.u"

            PaintCanvas
            Fill " "  Attribute mp_screen_back_color.n
            18, 34, 24, 70

    Style Attribute mp_screen_box_color.n
    @18,0
    SetMargin 34

Text
 INFO Ŀ
  keys increment by +/-1;        
  keys increment by +/-16;       
 Esc key restores original value; 
 Enter key saves current value.   

EndText

EndProc

WriteLib libname mp_paint_info_3.u
Release Procs    mp_paint_info_3.u

;**********************************************************************

Proc mp_paint_quit_box.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_quit_box.u"

            PaintCanvas
            Fill " "  Attribute mp_screen_back_color.n
            18, 34, 24, 70

    Style Attribute mp_screen_box_color.n
    @18,0
    SetMargin 34

Text
Ŀ
          Quit (Y/N)?:      

EndText

    SetMargin Off

EndProc

WriteLib libname mp_paint_quit_box.u
Release Procs    mp_paint_quit_box.u

;**********************************************************************

Proc mp_process_row_string.u()
    Private mp_procname.a

    mp_procname.a = "mp_process_row_string.u"

    input_string.a = input_string.a + StrVal(Chr(x))
    input_string.n = NumVal(input_string.a)

    If input_string.n > 255 Then
        Beep
        Message "Number ", input_string.n, " is too large"
        Canvas On
        Sleep 500
        Canvas Off
        input_string.a = Substr(input_string.a,1,Len(input_string.a) - 1)
        input_string.n = NumVal(input_string.a)
    EndIf

EndProc

WriteLib libname mp_process_row_string.u
Release  Procs   mp_process_row_string.u

;**********************************************************************

Proc mp_select_paint_mini_screen.u(box_num.p)
    Private mp_procname.a

    mp_procname.a = "mp_select_paint_mini_screen.u"

    Switch
        Case  box_num.p = 0 :  ; mp_paint_mini_screen_00.u()
    PaintCanvas fill chr(chr.n)  Attribute mp_colors_temp.r[3]
    8,35,13,54

        Case  box_num.p = 1 :   mp_paint_mini_screen_1.u()

        Case  box_num.p = 2 :  ; mp_paint_mini_screen_2.u()
    PaintCanvas          Attribute mp_colors_temp.r[4]
    7,35,7,54
    PaintCanvas          Attribute mp_colors_temp.r[5]
    7,39,7,44
    PaintCanvas          Attribute mp_colors_temp.r[11]
    7,40,7,40

        Case  box_num.p = 3 :   ;mp_paint_mini_screen_3.u()
    PaintCanvas          Attribute mp_colors_temp.r[5]
    7,39,7,44
    PaintCanvas          Attribute mp_colors_temp.r[11]
    7,40,7,40

        Case  box_num.p = 4 :  ; mp_paint_mini_screen_4.u()
    PaintCanvas          Attribute mp_colors_temp.r[6]
    11,40,11,48

        Case  box_num.p = 5 :  ; mp_paint_mini_screen_5.u()
    PaintCanvas          Attribute mp_colors_temp.r[7]
    9,41,9,48

    mp_paint_mini_screen_11.u()

        Case  box_num.p = 6 :  ; mp_paint_mini_screen_6.u()
    PaintCanvas          Attribute mp_colors_temp.r[8]
    10,40,10,48

        Case  box_num.p = 7 :  ; mp_paint_mini_screen_7.u()
    PaintCanvas          Attribute mp_colors_temp.r[9]
    14,35,14,54

        Case  box_num.p = 8 :  ; mp_paint_mini_screen_8.u()
    PaintCanvas          Attribute mp_colors_temp.r[10]
    9,40,9,40

        Case  box_num.p = 9 :  ; mp_paint_mini_screen_9.u()
    PaintCanvas          Attribute mp_colors_temp.r[11]
    7,40,7,40

        Case  box_num.p = 10 :  mp_paint_mini_screen_10.u()
        Case  box_num.p = 12 :  mp_paint_mini_screen_11.u()
        OtherWise :
            Beep Sleep 100 Beep
            Message "Invalid box_num.p in select_paint_mini_screen (", box_num.p, ")"
            Canvas On Canvas Off
            n=GetChar()

    EndSwitch

EndProc

WriteLib libname mp_select_paint_mini_screen.u
Release  Procs   mp_select_paint_mini_screen.u

;**********************************************************************

Proc       mp_set_temp_colors_table.l(application_name.p)
    Private mp_procname.a
            ,mp_temp1.r

    mp_procname.a = "mp_set_temp_colors_table.l"

    MoveTo [application_name]
    Locate application_name.p
    If Not RetVal Then
        Locate "DEFAULT"
        If RetVal Then
            CopyToArray mp_temp1.r
            mp_temp1.r[2] = application_name.p
            Ins
            CopyFromArray mp_temp1.r
            Locate application_name.p
        Else
            ins
            [Application_name]          =  application_name.p
            [Background_color]          =  31
            [Bar_color]                 =  02
            [Bar_select_color]          =  59
            [Inactive_color]            =  56
            [Box_color]                 =  63
            [Box_select_color]          =  02
            [Bar_help_color]            =  81
            [Key_select_color_box]      =  52
            [Key_select_color_bar]      =  67
            [Shadow_color]              =  07
            [Show_shadow_sw]            =  "Y"
            [Border_color]              =  44
            [Paint_border_sw]           =  "N"
            [Background_pattern]        =  177
            skip 0
            Locate application_name.p
        EndIf
    EndIf

    CopyToArray mp_colors_orig.r

    copytoarray mp_colors_temp.r

    return true

EndProc

WriteLib libname mp_set_temp_colors_table.l
Release Procs    mp_set_temp_colors_table.l

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc mp_screen_colors_local.u()
    Private mp_procname.a
    ,mp_temp_directory.a

    mp_procname.a = "mp_screen_colors_local.u"

    ErrorProc = "mp_error_proc.n"

    if isblank(privdir()) then
       mp_temp_directory.a = directory()
    else
       mp_temp_directory.a = privdir()
    endif

    if isfile(mp_temp_directory.a+"mp_clr.db") then
       mp_screen_colors.l(mp_application_name.a,False)
       mp_privdir_mp_clr.a = mp_temp_directory.a+"mp_clr"
       view mp_privdir_mp_clr.a
       MoveTo [application_name]
       Locate mp_application_name.a
       pickform "F"
       if  mp_retval_esc.l then
           echo normal echo off
            If not IsRuntime() Then
                Echo Normal Echo Off
            else
                tkEcho Normal tkEcho Off
            EndIf
           mp_paint_mini_screen.u()
       endif
    else
       mp_retval.l = false
       beep
       message "Table `MP_CLR' with form `F' must be in private directory"
       canvas on
       sleep 1000
    endif

EndProc

WriteLib libname mp_screen_colors_local.u
Release Procs    mp_screen_colors_local.u

;**********************************************************************

Proc mp_paint_mini_screen.u()
    Private mp_procname.a

    mp_procname.a = "mp_paint_mini_screen.u"

    PaintCanvas          Attribute mp_colors.r[3]
    8,35,13,54
    PaintCanvas          Attribute mp_colors.r[4]
    7,35,7,54
    PaintCanvas          Attribute mp_colors.r[5]
    7,39,7,44
    PaintCanvas          Attribute mp_colors.r[11]
    7,40,7,40
    PaintCanvas          Attribute mp_colors.r[10]
    9,40,9,40

    If Upper(mp_colors.r[13]) = "Y" Then
        PaintCanvas Fill "0" Attribute mp_colors.r[12]
        9,50,13,50
        PaintCanvas Fill "0" Attribute mp_colors.r[12]
        13,40,13,49
    Else
    PaintCanvas fill "1"   Attribute mp_colors.r[3]
        9,50,13,50
    PaintCanvas fill "1"   Attribute mp_colors.r[3]
        13,40,13,49
    EndIf

    If Upper(mp_colors.r[15]) = "Y" Then
    PaintCanvas border   Attribute mp_colors.r[14]
        8,39,12,49
    Else
    PaintCanvas border   Attribute mp_colors.r[7]
        8,39,12,49
    EndIf

    PaintCanvas           Attribute mp_colors.r[7]
    9,41,9,48
    PaintCanvas           Attribute mp_colors.r[8]
    10,40,10,48
    PaintCanvas           Attribute mp_colors.r[6]
    11,40,11,48
    PaintCanvas           Attribute mp_colors.r[9]
    14,35,14,54

EndProc

WriteLib libname mp_paint_mini_screen.u
Release  Procs   mp_paint_mini_screen.u

;**********************************************************************

Proc mp_process_row2.u()
    private mp_procname.a

    mp_procname.a = "mp_process_row2.u"

    input_string.n      = mp_colors_temp.r[16]
    input_string.a      = StrVal(input_string.n)
    mp_original_values_col = 16

    While True
        If input_string.n > 0 Then
            chr.n = input_string.n
        Else
            chr.n = 255
        EndIf

    PaintCanvas fill chr(chr.n)   Attribute mp_colors_temp.r[3]
    8,35,13,54
        Style Attribute mp_screen_back_color.n
        @ 22, 26 ?? "   "
        @ 22, 26 ?? input_string.n
        Canvas On  Canvas Off
        x = GetChar()
        While CharWaiting()
            x = GetChar()
        EndWhile

        Switch
            Case x =  13  : ;enter
                mp_process_row2_enter.u()
                QuitLoop

            Case x >  47
                And  x <  58  :
                mp_process_row_string.u()

            Case x =  -77  : ;right arrow
                If input_string.n < 255 Then
                    input_string.n = input_string.n + 1
                Else
                    input_string.n = 1
                EndIf
                input_string.a = StrVal(input_string.n)

            Case x =  -75  : ;left arrow
                If input_string.n > 1   Then
                    input_string.n = input_string.n - 1
                Else
                    input_string.n = 255
                EndIf
                input_string.a = StrVal(input_string.n)

            Case x =  -72  : ;up    arrow
                If input_string.n < 240 Then
                    input_string.n = input_string.n + 16
                Else
                    If input_string.n = 240 Then
                        input_string.n = 255
                    Else
                        input_string.n = input_string.n + 16 - 256
                    EndIf
                EndIf
                input_string.a = StrVal(input_string.n)

            Case x =  -80  : ;down arrow
                If input_string.n > 16  Then
                    input_string.n = input_string.n - 16
                Else
                    If input_string.n = 16  Then
                        input_string.n = 255
                    Else
                        input_string.n = input_string.n - 16 + 256
                    EndIf
                EndIf
                input_string.a = StrVal(input_string.n)

            Case x =  127  : ;ctrl backspace
                input_string.a = "0"
                input_string.n = 0

            Case x =  8
                Or   x = -83  :
                input_string.a = Substr(input_string.a,1,Len(input_string.a) - 1)
                input_string.n = NumVal(input_string.a)
                If IsBlank(input_string.a) Then
                    input_string.a = "0"
                    input_string.n = 0
                EndIf

            Case x =  27  : ;esc
                mp_process_row2_esc.u()
                QuitLoop

            OtherWise :
                Beep
                Message "Invalid key pressed"
                Canvas On
                Sleep 500
                Canvas Off

        EndSwitch

    EndWhile

EndProc

WriteLib libname mp_process_row2.u
Release Procs    mp_process_row2.u

;**********************************************************************

Proc mp_process_row2_enter.u()
    Private mp_procname.a

    mp_procname.a = "mp_process_row2_enter.u"

    If input_string.n > 0 Then
        mp_colors_temp.r[16] = input_string.n
    Else
        mp_colors_temp.r[16] = 255
    EndIf

    Style Attribute mp_screen_box_color.n
    @ 22, 26 ?? "   "
    @ 22, 26 ?? mp_colors_temp.r[16]

    mp_draw_mini_screen_2_7.u()
    mp_paint_mini_screen_99.u()

EndProc

WriteLib libname mp_process_row2_enter.u
Release  Procs   mp_process_row2_enter.u

;**********************************************************************

Proc mp_process_row2_esc.u()
    Private mp_procname.a

    mp_procname.a = "mp_process_row2_esc.u"

    input_string.n = mp_colors_orig.r[mp_original_values_col]
    mp_temp_background_pattern = input_string.n
    mp_colors_temp.r[16] = input_string.n
    Style Attribute mp_screen_box_color.n
    @ 22, 26 ?? "   "
    @ 22, 26 ?? input_string.n

    mp_draw_mini_screen_2_7.u()
    mp_paint_mini_screen_99.u()

EndProc

WriteLib libname mp_process_row2_esc.u
Release  Procs   mp_process_row2_esc.u

;**********************************************************************
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Copyright (c) 1988, 1989 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  DCY 12/15/88
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc setpopup2(PopTbl.p,Fld.p,width.p)
    private mp_procname.a

    ;  Private;PopTbl.p,      ;Source table for items of menu
    ;  Fld.p,         ;Source field for items of menu
    ;  Global ;Item,        ;Array of items of menu
    ;         ;Width        ;Width of widest item

    mp_procname.a = "setpopup2"

    If NRecords(PopTbl.p) > 0 Then
        Array Item[NRecords(PopTbl.p)]    ;Dimension Item array.  One item per record
        MoveTo PopTbl.p                   ;  in PopTbl.
        MoveTo Field Fld.p
        width = width.p
        if width = 0 then
           Scan
             Item[[#]] = []
             Width = Max(Len([]),Width)
           EndScan
        else
           Scan
             Item[[#]] = []
           EndScan
        endif
    else
        Array item[1]
        item[1] = ""
        width   = 0
    EndIf

EndProc

WriteLib libname setpopup2
Release Procs    setpopup2

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Copyright (c) 1988, 1989 Borland International.  All Rights Reserved.
;
; General permission to re-distribute all or part of this script is granted,
; provided that this statement, including the above copyright notice, is not
; removed.  You may add your own copyright notice to secure copyright
; protection for new matter that you add to this script, but Borland
; International will not support, nor assume any legal responsibility for,
; material added or changes made to this script.
;
; Revs.:  DCY 12/15/88
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc Popup2(R,C,VNum,DefItem,Title)
    ;Proc Popup2(R,C,VNum,DefItem,Title,Prompt1,Prompt2)
    Private;R,           ;Row position of upper-left corner of menu box
    ;C,           ;Column position of upper-left corner menu box
    ;VNum,        ;Number of items to be displayed in one menu image
    ;DefItem,     ;Item (number) to show
    ;Title,       ;Title of popup box
    ;Prompt1,     ;First prompt line
    ;Prompt2,     ;Second prompt line
    NItems,      ;Number of items in menu list
    Char,        ;Keycode of last key pressed
    MenuPos,     ;Current (row image) position within menu
    CIndex,      ;Current choice index into Item
    X,           ;Counter variable
    PrmptColr,   ;Color attribute for prompt
    BrdrColr,    ;Color attribute for box border
    ListColr,    ;Color attribute for menu item list
    SlctColr     ;Color attribute for current menu selection
    ,mp_procname.a
    ;  Global ;Item,        ;Array of items of menu
    ;Width        ;Width of widest item

    mp_procname.a = "popup2"

    popup2_setup()

    While True

        Style Attribute SlctColr
        @ MenuPos+R+2,C+2         ;Highlight current selection
        ?? Item[CIndex]
        Style Attribute ListColr

        Canvas On                    ;Reenable immediate echoing to canvas
        Char = GetChar()
        Canvas Off                   ;disable immediate echoing to canvas

        Switch
            Case Char > 31:                        ;First character search?
                popup2_search()

            Case Char = -72 :                      ;Up
                popup2_up()

            Case Char = -80 :                      ;Down
                popup2_down()

            Case Char = -71 :                      ;Home
                popup2_home()

            Case Char = -79 :                      ;End
                popup2_end()

            Case Char = -73 :                      ;PgUp
                popup2_pgup()

            Case Char = -81 :                      ;PgDn
                popup2_pgdn()

            Case Char = 13 :                       ;Enter
                Canvas On
                Style
                Return Item[CIndex]                 ;Return selection

            Case Char = 27 :                       ;Esc
                Canvas On
                Style
                Return ""                           ;Return null selection

            OtherWise:                             ;Illegal key
                Beep

        EndSwitch

        If Redraw = -1                            ;Need to redraw entire menu?
            Then @ LastPos+R+2,C+2
            ?? Item[LastIdx]
        Else
            SetMargin C+2
            @ R+2,C+2
            For X From 1 To VNum              ;Redraw entire menu box
                ? Item[Redraw+X]+Spaces(Width-Len(Item[Redraw+X]))
            EndFor
            SetMargin Off
            @ R+3,C+1
            Style Attribute BrdrColr
            If Redraw = 0                     ;Records above?
                Then ?? " "
            Else ?? ""                    ; Yes- Show items are above
            EndIf
            @ R+VNum+2,C+1
            If Redraw+VNum = NItems           ;Records below?
                Then ?? " "
            Else ?? ""                    ; Yes- Show items are below
            EndIf
            Redraw = -1
        EndIf

        LastPos = MenuPos                         ;Update last row position
        LastIdx = CIndex                          ;Update last item index

    EndWhile

EndProc

WriteLib libname popup2
Release Procs    popup2

;*****************************************

Proc  popup2_search()
    Private mp_procname.a

    mp_procname.a = "popup2_search"

    For X From CIndex+1 To NItems       ;Search (down) item array
        If Upper(Substr(Item[X],1,1)) = Upper(Chr(Char))
            Then
            QuitLoop                 ;Found a match
        EndIf
    EndFor
    If X = NItems+1                     ;Match not found
        Then Beep
    Else
        If MenuPos+X-CIndex > VNum  ;Is next item already visible?
            Then
            Switch              ; No-
                Case X < VNum :  ;Redraw top screen
                    Redraw = 0
                    MenuPos = X
                Case X > NItems-VNum :  ;Redraw last screen
                    Redraw = NItems-VNum
                    MenuPos = X-NItems+VNum
                OtherWise :      ;Redraw intermediate screen
                    Redraw = X-1  ;Place item at top of menu
                    MenuPos = 1
            EndSwitch
        Else MenuPos = MenuPos+X-CIndex
            Redraw = -1
        EndIf
        CIndex = X                  ;Update current item
    EndIf

EndProc

WriteLib libname popup2_search
Release Procs    popup2_search

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc    popup2_setup()
    Private mp_procname.a

    mp_procname.a = "popup2_setup"

            If not IsRuntime() Then
                Echo Off
            else
                tkEcho Off
            EndIf
    Cursor Off                   ;Hide blinking cursor
    Canvas Off                   ;Disable immediate printing to canvas

    ;PrmptColr = SysColor(0)       ;Top two line prompt color
    BrdrColr  = SysColor(9)       ;Border color
    ListColr  = SysColor(17)      ;Menu list color
    SlctColr  = SysColor(18)      ;Current menu selection color

    Width     = Max(Len(Title),Width)  ;Expand box width if title is too wide
    NItems    = ArraySize(Item)        ;Set number of items in list
    If VNum > NItems
        Then VNum = NItems
    EndIf

    Switch
        Case DefItem < VNum :  ;Redraw top screen
            Redraw = 0
            MenuPos = DefItem
        Case DefItem > NItems-VNum :  ;Redraw last screen
            Redraw = NItems-VNum
            MenuPos = DefItem-NItems+VNum
        OtherWise :      ;Redraw intermediate screen
            Redraw = DefItem-1  ;Place item at top of menu
            MenuPos = 1
    EndSwitch

    ;Set default menu settings:
    CIndex = DefItem                     ;First menu item
    LastPos = MenuPos                    ;Last image position is current pos.
    LastIdx = CIndex                     ;Last menu item index

    Style Attribute BrdrColr
    SetMargin C
    @ R,C                        ;Draw menu skeleton and initial image
    ?? "",Fill("",Width+2),""
    ? " ",Format("AC,W"+StrVal(Width),Title)," "
    ? "",Fill("",Width+2),""
    For X From 1 To VNum
        ? "",Spaces(Width+2),""
    EndFor
    ?  "",Fill("",Width+2),""

    @ R+3,C+1
    If Redraw = 0                     ;Records above?
        Then ?? " "
    Else ?? ""                    ; Yes- Show items are above
    EndIf
    @ R+VNum+2,C+1
    If Redraw+VNum = NItems           ;Records below?
        Then ?? " "
    Else ?? ""                    ; Yes- Show items are below
    EndIf

    @ R+2,C+2
    SetMargin C+2
    Style Attribute ListColr
    For X From 1 To VNum
        ? Item[X+Redraw]+Spaces(Width-Len(Item[X+Redraw]))
    EndFor
    SetMargin Off

    Redraw = -1                       ;Disable menu image redraw

EndProc

WriteLib libname popup2_setup
Release Procs    popup2_setup

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_up()
    Private mp_procname.a

    mp_procname.a = "popup2_up"

    If CIndex = 1                       ;Already at first item?
        Then Beep
        while charwaiting()
           n=getchar()
        endwhile
    Else
        If MenuPos > 1              ;Can move within menu image?
            Then MenuPos = MenuPos-1 ; Yes- Move to previous item
        Else Redraw = CIndex-2   ; No-  Redraw entire menu
        EndIf
        CIndex = CIndex-1           ;Update current item
    EndIf

EndProc

WriteLib libname popup2_up
Release Procs    popup2_up

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_down()
    Private mp_procname.a

    mp_procname.a = "popup2_down"

    If CIndex = NItems                  ;On last item?
        Then Beep
        while charwaiting()
           n=getchar()
        endwhile
    Else
        If MenuPos < VNum           ;Can move within menu image?
            Then MenuPos = MenuPos+1    ; Yes-  Move to next item
        Else Redraw = CIndex-VNum+1 ; No- Redraw entire menu
        EndIf
        CIndex=CIndex+1             ;Update current item
    EndIf

EndProc

WriteLib libname popup2_down
Release Procs    popup2_down

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_home()
    Private mp_procname.a

    mp_procname.a = "popup2_home"

    If MenuPos <> CIndex                ;Already viewing top of menu?
        Then Redraw = 0                  ; No-  Redraw top of menu
    EndIf
    MenuPos = 1                         ;Position at first item
    CIndex = 1                          ;Select first item

EndProc

WriteLib libname popup2_home
Release Procs    popup2_home

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_end()
    Private mp_procname.a

    mp_procname.a = "popup2_end"

    If CIndex+VNum-MenuPos <> NItems    ;Already viewing end of menu?
        Then Redraw = NItems-VNum        ; No-  Redraw end of menu
    EndIf
    MenuPos = VNum                      ;Position at bottom of menu
    CIndex = NItems                     ;Select last item

EndProc

WriteLib libname popup2_end
Release Procs    popup2_end

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_pgup()
    Private mp_procname.a

    mp_procname.a = "popup2_pgup"

    If MenuPos = CIndex                 ;Are we within first screen?
        Then Beep                        ; Yes- Disallow PgUp
    Else
        If CIndex-MenuPos-VNum > 0
            Then CIndex = CIndex-MenuPos-VNum+1
        Else CIndex = 1
        EndIf
        Redraw = CIndex-1           ; No-  Redraw previous page
        MenuPos = 1                 ;      Position on that item
    EndIf

EndProc

WriteLib libname popup2_pgup
Release Procs    popup2_pgup

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Proc  popup2_pgdn()
    Private mp_procname.a

    mp_procname.a = "popup2_pgdn"

    If CIndex+VNum-MenuPos = NItems ;Are we within last screen?
        Then Beep                        ; Yes- Disallow PgDn
    Else
        If NItems-VNum < CIndex+VNum-MenuPos
            Then CIndex = NItems-VNum+1
        Else CIndex = CIndex+VNum-MenuPos+1
        EndIf
        Redraw = CIndex-1           ; No- Redraw next page
        MenuPos = 1                 ;     Position on that item
    EndIf

EndProc

WriteLib libname popup2_pgdn
Release Procs    popup2_pgdn

;+++++++++++++++++++++++++++++++++++++++++++++++++++
