;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure AddRec.u
;Source File     : MEMOROLL.SC
;Author          : David Orriss
;                  Borland International
;
;Informant Issue : September 1991
;
;Description     : A memo routine that simulates unlimited length memo fields
;                  within Paradox. Refer to the article "Roll Your Own Memo
;                  Fields" in the September 1991 issue of Paradox Informant.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740



;InsertLine
;Procedure to insert a blank line into a memo field
;above the current line
;
PROC InsertLine.u()
;
; The line numbering needs to be handled differently
; if we try to add a line above the first line or
; if this is the only line
;
  IF (((NIMAGERECORDS() =1) OR (RECNO()=1)) AND Retval="Ins")
     THEN NewValue.n=[Line number]/2
          INS
          [Line number]=NewValue.n
          RETURN
  ENDIF

;
; Add a new line to the end of the memo field by
; taking the previous line number and adding 1
;
   IF (NIMAGERECORDS()=RECNO())
     THEN NewValue.n=[Line number] + 1
          DOWN
          [Line number]=NewValue.n
          RETURN
     ELSE
;
; Not trying to add a new line to the end of
; the memo or between two lines - just moving
; down a line
;
       IF (Retval="Enter" OR Retval="Down")
         THEN DOWN
              RETURN
       ENDIF
   ENDIF

;
; If we're not adding a line to the end or before
; the beginning we must be adding a line between
; two existing lines. To do this, we get the line
; number from the lower line, get the line number
; from the upper line, subtract the numbers, divide
; by 2, and add it to the lower number. Since
; [Line number] is a numeric type, inserted lines
; will  maintain their proper sequence (e.g. 2,
; 2.5, 2.75)
;

   HighValue.n=[Line number]
   UP
   LowValue.n=[Line number]
   NewValue.n=((HighValue.n-LowValue.n)/2)+LowValue.n
   DOWN
   INS
   [Line number]=NewValue.n
ENDPROC

;
; Deleteline
; Procedure will delete line and check if number for
; line 1 needs to be reinserted. Because of the way
; the memo field editing code has been written, if
; all of the lines are deleted, line number 1 must
; be regenerated
;
PROC DeleteLine.u()
   DEL
   IF (ISBLANK([Line number]) AND RECNO()=1)
     THEN [Line number]=1
          RETURN
   ENDIF
ENDPROC

;
; EditTopic
; Procedure allows the editing of memo field and
; assumes a field called "Line number" and data type
; N
;
PROC EditTopic.u(MemoTab.a)
   PRIVATE SourceTab.a

;
; Store current table name before moving to Memo
; image
;
   SourceTab.a=TABLE()
   MOVETO MemoTab.a
   IF (NIMAGERECORDS()=1 AND ISBLANK([Line number]))
     THEN [Line number]=1
   ENDIF

   WHILE True
     PROMPT
     WAIT TABLE
       PROMPT "Edit topic text",
              "Press [F2] when finished"
     UNTIL "F2","Ins","Enter","Down","Del"

     SWITCH
       CASE Retval="F2":
           QUITLOOP
       CASE Retval="Ins":
           InsertLine.u()
       CASE Retval="Del":
           DeleteLine.u()
       CASE Retval="Enter" OR Retval="Down":
           InsertLine.u( )
    ENDSWITCH
   ENDWHILE

;
; Return to source table
;
   MOVETO SourceTab.a
ENDPROC

;
; AddRec - add a record to the SaleTrak table
;
PROC AddRec.u()

   VIEW "SaleTrak"
   COEDITKEY
   PICKFORM "F"
   END
   CTRLPGDN
;
; If table is empty, start with record number 1
;

   MOVETO [Contact #]
   [Contact #]=RECNO( )  [Date]=TODAY( )
   LOCKRECORD
   MOVETO [Sales rep #]
   WAIT RECORD
      PROMPT "Enter the Sale Rep ID Number"
   UNTIL "Enter"

   MOVETO "RepData"
   IF ISBLANK([Name])
     THEN WAIT RECORD
           PROMPT "Enter new Tech ID information",
                  "Press [F2] when finished."
          UNTIL "F2"
   ENDIF
;
; Move back to main table
;
  MOVETO "SaleTrak"
  MOVETO [Company name]
  WHILE True
    WAIT RECORD
      PROMPT "Continue to enter data.  Press [F2] when finished with this record",
              "Press [F9] to edit memo field."
    UNTIL "F2","F9"

    SWITCH
      CASE Retval="F9":
          EditTopic.u("Memo")
      CASE Retval="F2":
          DO_IT!
          CLEAR
          CLEARALL
          RETURN
    ENDSWITCH
  ENDWHILE
ENDPROC

AddRec.u( )
