;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure MemoEdit
;Source File     : MEMO.SC
;Author          : Jim Schwarz
;                  Paradox Informant
;
;Informant Issue : June 1991
;
;Description     : A memo routine that respects the limits of Paradox's 255
;                  character limit for alphnumeric fields. This routine will
;                  manage multiple lines of fields of this type on an embedded
;                  form.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740


  CREATELIB "Memolib"

  PROC MemoEdit()
    PRIVATE TempFld
    TempFld=FIELD()

    MOVETO [Page2]
    DOWNIMAGE
    HOME
    MemoRecs=NIMAGERECORDS()
    IF Mode="Edit"
      THEN IF ISBLANK([])
             THEN [Memo date]=TODAY()
                  GetMemoTime()
           ENDIF
    ENDIF

    WHILE True
      PROMPT " [F2]  Save/Quit    [Ins]  Add          "+
             "  Use Field View for insert mode and   ",
             " [F5]  Field view   [Del]  Delete       "+
             "  to move within field                 "
      WAIT FIELD
        UNTIL 4,13,21,27,-71,-72,-73,-79,-80,-81,
              -59,-60,-61,-62,-63,-64,-65,-66,-67,-68,
              6,7,-24,-82,-83,-89,-106,-107,-108,-111
        SYNCCURSOR
        Key=Retval
      SWITCH
        CASE Key=13 OR      ;Enter or Down
             Key=-80:
          IF MemoOK(Key)
            THEN DOWN
                 IF ISBLANK([])
                   THEN [Memo date]=TODAY()
                        GetMemoTime()
                 ENDIF
          ENDIF
        CASE Key=-79 OR     ;End or PgDn
             Key=-81:
          IF ATLAST()
            THEN BEEP
            ELSE IF MemoOK(Key)
                   THEN KEYPRESS Key
                 ENDIF
          ENDIF
        CASE Key=-71 OR     ;Home or Up or PgUp
             Key=-72 OR
             Key=-73:
          IF ATFIRST()
            THEN BEEP
            ELSE IF MemoOK(Key)
                   THEN KEYPRESS Key
                 ENDIF
          ENDIF
        CASE Key=-82 AND    ;Ins
             Mode="Edit":
          INS
          [Memo date]=TODAY()
          GetMemoTime()
        CASE Key=-83 AND    ;Del
             Mode="Edit":
          DEL
        CASE Key=-60:       ;F2
          IF MemoOK(Key)
            THEN UPIMAGE
                 MOVETO FIELD TempFld
                 RETURN
          ENDIF
        CASE Key=-63:       ;F5
          FldEdit()
        OTHERWISE:
          BEEP
      ENDSWITCH
    ENDWHILE
  ENDPROC

  PROC MemoOK(Key)
    IF MemoRecs>0
      THEN IF ISBLANK([])
             THEN IF Key=-60 OR   ;F2, Home, Up or PgUp
                     Key=-71 OR
                     Key=-72 OR
                     Key=-73
                    THEN DEL
                         DOWN
                    ELSE BEEP
                         MESSAGE " Memo field may"+
                                 " not be left blank... "
                         SLEEP 1200
                         RETURN False
                  ENDIF
           ENDIF
      ELSE IF Key<>-60      ;F2
             THEN RETURN False
           ENDIF
    ENDIF
    RETURN True
  ENDPROC

  WRITELIB "MemoLib" MemoEdit,MemoOK


  CREATELIB "UtilLib"

  PROC GetMemoTime()
    PRIVATE CurrTime,Hours,Mins,AmPm
    CurrTime=TIME()
    Hours=NUMVAL(SUBSTR(CurrTime,1,2))
    Mins=SUBSTR(CurrTime,4,2)
    AmPm=" pm"
    IF Hours<12
      THEN AmPm=" am"
      ELSE IF Hours>12
             THEN Hours=Hours-12
           ENDIF
    ENDIF
    [Memo time]=STRVAL(Hours)+":"+Mins+AmPm
    [Memo sec] =SUBSTR(CurrTime,7,2)
  ENDPROC

  PROC FldEdit()
    PRIVATE Key

    WHILE True
      FIELDVIEW
      PROMPT " [Enter]  Quit Field View               "+
             "  Use [Home], [End] and cursor keys    ",
             "                                        "+
             "  to move within field                 "
      WAIT FIELD
        UNTIL 13,
              -59,-60,-61,-62,-63,-64,-65,-66,-67,-68,
              4,-24,-82,-106,-108,-109,-110
        SYNCCURSOR
        Key=Retval

      IF Key=13 OR Key=-60 OR Key=-65
        THEN RETURN
        ELSE BEEP
             LOOP
      ENDIF
    ENDWHILE
  ENDPROC

  WRITELIB "UtilLib" GetMemoTime,FldEdit
