; PACK - removes "deleted" records from tables
;
;    parameter - string containing the table name OR a directory
;                name ending in an asterisk (which tells PACK to
;                pack all of the tables in the directory specified).
;
; Written by Tom Reese, Philadelphia Area Paradox User's Group (PA..DOX)
;            CompuServe User ID [76417,3662]
;
; Legal Statement
;
;    This source code is hereby released into the public domain,
;    and may be used freely as long as credit is given for this code.

proc Pack(Tbl)

private Tbl, Pos


Pos = search("*",Tbl)
if Pos > 0
   then                                    ; it's a directory
      Tbl = substr(Tbl,1,Pos-1)            ; get rid of the asterisk, leaving just a directory
      if direxists(Tbl) = 1
         then
            Menu {Tools} {Info} {Inventory} {Tables}
            typein Tbl
            Enter
            if not(isempty("List"))
               then
                  message "Packing databases in " + Tbl + " subdirectory..."
                  scan
                     message "Packing " + [Name]
                     execute "Menu {Modify} {Restructure}"
                     typein Tbl + [Name]
                     Enter
                     DO_IT!

                     while table() <> "List"
                        ClearImage
                     endwhile
                  endscan

                  message "Database packing completed"


                  delete "List"              ; clean up while message displayed
                  if istable("Struct")
                     then delete("Struct")
                  endif

            endif  ; if istable list
         else
            message("No such directory as " + Tbl)
            sleep 2000
      endif ; if direxists
   else
      if istable(Tbl)
         then
            message "Packing " + Tbl + ".db ..."
            execute "Menu {Modify} {Restructure}"
            typein Tbl
            Enter
            DO_IT!
         else
            message "No such table as " + Tbl
            sleep 2000
      endif
endif

clearall
endproc

; Examples:

;pack("c:\\proj\\ccr\\*")    ; packs all tables in c:\proj\ccr directory
                             ; NOTE: If no characters were to follow the
                             ;       final occurrence of "\\" in the parameter
                             ;       Paradox would truncate them--therefore,
                             ;       PACK would not be able to distinguish it
                             ;       from a table (at least in this implementation).

;pack("people")              ; packs people table in current directory

;pack("c:\\proj\\ccr\\tmem") ; packs tmem table in c:\proj\ccr directory
