; ------------------------------------------------------------
; STRU.SC  -  a simple table structure reporter script
;
; Written by Steve Caple, Sacramento Paradox Users Roundtable
; ------------------------------------------------------------


cursor off


; ------------------------------------------------------------
; splash screen for table structure printer
; ------------------------------------------------------------
proc StruSplash()

  ; splash screen background
  paintcanvas fill chr(176)     ; light dot fill
              attribute 113     ; lt gray on blue
              1,  0, 23, 79     ; wall to wall

  ; text box shadow
  paintcanvas                   ; no fill, just color it
              attribute 8       ; dk gray on black
              9, 22, 16, 61     ; offset 2 cols rt, one row dn

  ; text box
  paintcanvas fill " "          ; fill spaces for solid color
              attribute 31      ; white on blue
              8, 20, 15, 59     ; 40 char x 8 rows, centered

  ; title the box

  style attribute 112           ; black on gray for ?? text
  @ 9,20 ?? format("w40,ac","Table Structure Printer")

  style                         ; restore default attributes

endproc



; ------------------------------------------------------------
; change STRUCT table standard report for our purposes
; ------------------------------------------------------------
proc StruRepFormat(TableName)

  StruRepTitle = "Table Structure Report for " + upper(TableName)+ ".DB"

  menu {Tools} {Info} {Structure} select TableName

  menu {Report} {Change} {Struct} {R} {Standard Report}

  ins
  deleteline
  down
  deleteline
  down down
  deleteline

  menu {Setting} {Pagelayout} {Length} ctrlbackspace "60"
  menu {Setting} {Pagelayout} {Width}  ctrlbackspace "75"
  menu {Setting} {Margin}              ctrlbackspace "10"


  menu {Field} {Place} {Calculated}
      typein "\"" + StruRepTitle + "\""
      enter   ; end expression entry
      enter   ; place calc field at cursor pos
      enter   ; accept default display length

  ctrlend     ; move to end of line
  enter       ; down to next line
  enter       ; insert a line

  menu {Field} {Place} {Date} {1) mm/dd/yy}
      enter   ; place date at cursor pos
      ",  pg "

  menu {Field} {Place} {Page}
      enter   ; place page no. at cursor pos
      enter   ; accept default display length

  ctrlhome
  for n from 1 to 6
    down
  endfor

  menu {TableBand} {Insert} enter

  menu {Field} {Place} {#Record} {Overall} enter enter
  for n from 1 to 12
    right
  endfor

  menu {TableBand} {Resize}
    enter
    for n from 1 to 6
      left
    endfor
    enter

  ctrlhome up  "-----"
  ctrlhome up  "Fld #"

  do_it!

endproc




clear

StruSplash()

setmargin 20                  ; reset left margin to col 20
style attribute 31            ; white on blue for ?? text

@ 11,20 ?? format("w40,ac","Preparing list of tables,")
@ 12,20 ?? format("w40,ac","please wait")

style attribute 31+128        ; blinking white on blue
@ 14,20 ?? format("w40,ac",fill(chr(250),4))
style attribute 31            ; reset to white on blue



menu "tiit" enter             ; tools/info/inventory/tables
                              ; (enter selects default directory)

{Modify} {Restructure} {List}
         right                ; to fieldname column in top row
         ins  "Tag"           ; insert new row for Tag field
         right                ; to fieldtype column
         "A1"                 ; make it type A1
         down                 ; to next row down
         ctrlbackspace "A8"   ; clear old type, make it type A8
Do_It! {Trimming}             ; allow trimming


beep

moveto [List->Tag]
coeditkey


if version() < 4 then
  FStr_1 = "w40,al"
  FStr_2 = "w40,ar"
else
  FStr_1 = "w70,al"
  FStr_2 = "w70,al"
endif

StruWaitMsg = format(FStr_1,"Tagged tables ("+chr(251)+") will be printed") +
              format(FStr_2,"Press [F2] to print, [Esc] to cancel")


while true

  imagerights readonly        ;no unplanned-for changes
  wait field                  ;we want to stay in Tag field

    prompt format("w50,al","TABLE STRUCTURE PRINTER - Table Selection") +
           format("w30,ar","Space bar toggles Tag")

    message StruWaitMsg

  until "Dos", "DosBig", "Rotate", "ToQPro", "F1",    ; illegal keys
        32, "F2", "Esc",                              ; menu action keys
        "Up", "Down", "PgUp", "PgDn", "Home", "End"   ; movement keys

  imagerights                 ;restore full rights, program now in control

  switch

    case retval = 32:
      if isblank([]) then
        [] = chr(251)
      else
        [] = ""
      endif
      down

    case retval = "F2":             ; end edit and goto print process
      do_it!
      quitloop

    case retval = "Esc":            ; clear workspace and leave the script
      do_it!
      release procs StruSplash, StruRepFormat
      clearall
      quit "Table structure printing cancelled"

    case retval = "Up"    : up
    case retval = "Down"  : down
    case retval = "PgUp"  : pgup
    case retval = "PgDn"  : pgdn
    case retval = "Home"  : home
    case retval = "End"   : end

    otherwise             : beep    ; for illegal keys

  endswitch

endwhile



StruSplash()

setmargin 20                  ; reset left margin to col 20
style attribute 31            ; white on blue for ?? text

@ 11,20 ?? format("w40,ac","Printing selected table")
@ 12,20 ?? format("w40,ac","structure lists")

style attribute 31+128        ; blinking white on blue
@ 14,20 ?? format("w40,ac",fill(chr(250),4))
style attribute 31            ; reset to white on blue



; this scan loop traverses List.db looking for tagged table names and
; reporting them

moveto [List->Name]
scan for [Tag] = chr(251)
  StruRepFormat([])         ; current field is Name (table name)
  report "Struct" "R"
  moveto "List"
endscan


beep
clearall

release procs StruSplash, StruRepFormat
release vars StruRepTitle, StruWaitMsg, n

quit "Table structure printing completed"


