
;NOTA BENE: this is _NOT_ a running demo.  No tables are included, and 
;           parts of the program depend on Henrik Bechmann's "EVENTMAN"
;           event manager code (see EV_MAN.ZIP, Lib 13) - but maybe you 
;           can use some ideas/hints from here anyway.
;
;           No warranty of fitness or performance is made.
;
;           Have fun, Steve Caple
;




; ------------------------------------------------------------
; RunBatchMan
; ------------------------------------------------------------
proc RunBatchMan()
   private  CurrentProc,
            CustName,
            CustDiv

   CurrentProc = "RunBatchMan"

   EventMan.SetObjectTagProc = "EventMan.SetIndexedObjectTag"
   EventMan.Constructor()
   Calendar.Constructor()

   BatchMan!SetFormSpecs()
   BatchMan!LoadTables()
   BatchMan!LoadForms()

   BatchMan!SetDefaultProcs()

   BatchMan!SetLookupInfoBag()
   BatchMan!SetFieldLookupBag()
   BatchMan!GetCustInfo()

   setcanvas default
   echo normal
   EventMan.DoWait()
   EventMan.Destructor()
   Calendar.Destructor()

endproc

writelib LibName RunBatchMan
release procs RunBatchMan
? "RunBatchMan()"
ColumnSet()





; ------------------------------------------------------------
; BatchMan!SetFormSpecs
; ------------------------------------------------------------
proc BatchMan!SetFormSpecs()
   private CurrentProc
   CurrentProc = "BatchMan!SetFormSpecs"

   dynarray TableSpecBag[]

   TableSpecBag["BATCHHOLD"]      = true
   TableSpecBag["BATCHFORM"]      = 1
   TableSpecBag["BATCHWIDTH"]     = 69
   TableSpecBag["BATCHROW"]       = 2
   TableSpecBag["BATCHCOL"]       = 5
   TableSpecBag["BATCHBAR"]       = "S"

   TableSpecBag["BATCHTYPHOLD"]   = false
   TableSpecBag["BATCHTYPFORM"]   = 1
   TableSpecBag["BATCHTYPWIDTH"]  = 59
   TableSpecBag["BATCHTYPROW"]    = 5
   TableSpecBag["BATCHTYPCOL"]    = 18
   TableSpecBag["BATCHTYPBAR"]    = "F"

   TableSpecBag["CMSDHOLD"]       = false
   TableSpecBag["CMSDFORM"]       = 1
   TableSpecBag["CMSDWIDTH"]      = 42
   TableSpecBag["CMSDROW"]        = 5
   TableSpecBag["CMSDCOL"]        = 35
   TableSpecBag["CMSDBAR"]        = "F"

   TableSpecBag["MATRIXHOLD"]     = false
   TableSpecBag["MATRIXFORM"]     = 1
   TableSpecBag["MATRIXWIDTH"]    = 50
   TableSpecBag["MATRIXROW"]      = 4
   TableSpecBag["MATRIXCOL"]      = 27
   TableSpecBag["MATRIXBAR"]      = "F"

   TableSpecBag["CUSTOMERHOLD"]   = false
   TableSpecBag["CUSTOMERFORM"]   = 1
   TableSpecBag["CUSTOMERWIDTH"]  = 63
   TableSpecBag["CUSTOMERROW"]    = 5
   TableSpecBag["CUSTOMERCOL"]    = 2
   TableSpecBag["CUSTOMERBAR"]    = "S"

   TableSpecBag["CUSTTYPEHOLD"]   = false
   TableSpecBag["CUSTTYPEFORM"]   = 1
   TableSpecBag["CUSTTYPEWIDTH"]  = 40
   TableSpecBag["CUSTTYPEROW"]    = 8
   TableSpecBag["CUSTTYPECOL"]    = 9
   TableSpecBag["CUSTTYPEBAR"]    = "F"

endproc

writelib LibName BatchMan!SetFormSpecs
release procs BatchMan!SetFormSpecs
? "BatchMan!SetFormSpecs()"
ColumnSet()




; ---------------------------------------------------------
; BatchMan!LoadTables
; ---------------------------------------------------------
proc BatchMan!LoadTables()
   private wAtt,
           TblHdl
   CurrentProc = "BatchMan!LoadTables"
   dynarray wAtt[]
   ; load tableview windows for all tables in the spec bag
   foreach Element in TableSpecBag
      if match(Element,"..FORM",Tbl) then
         view Tbl
         window handle image imageno() to TblHdl
         wAtt["hasframe"]  = false
         wAtt["hasshadow"] = true
         wAtt["canresize"] = false
         window setattributes TblHdl from wAtt

         EventMan.ObjectTagWindow[TblHdl] = Tbl+"TABLE"
         EventMan.WindowObjectTag[Tbl+"TABLE"] = TblHdl

         window move TblHdl to -1000,-1000
      endif
   endforeach
endproc

writelib LibName BatchMan!LoadTables
release procs BatchMan!LoadTables
? "BatchMan!LoadTables()"




; ---------------------------------------------------------
; BatchMan!LoadForms
; ---------------------------------------------------------
proc BatchMan!LoadForms()
   private wAtt,
           FrmHdl
   CurrentProc = "BatchMan!LoadForms"
   if search("Edit",sysmode()) < 1 then
      coeditkey
   endif
   dynarray wAtt[]
   ; load formview windows for all tables in the spec bag
   foreach Element in TableSpecBag
      if match(Element,"..FORM",Tbl) then
         window select EventMan.WindowObjectTag[Tbl+"TABLE"]
         pickform TableSpecBag[Tbl+"FORM"]
         window handle form to FrmHdl
         EventMan.ObjectTagWindow[FrmHdl] = Tbl+"FORM"
         EventMan.WindowObjectTag[Tbl+"FORM"] = FrmHdl
         wAtt["hasframe"]  = false
         wAtt["hasshadow"] = true
         wAtt["canresize"] = false
         wAtt["width"]     = TableSpecBag[Tbl+"Width"]
         wAtt["originrow"] = TableSpecBag[Tbl+"Row"]
         wAtt["origincol"] = TableSpecBag[Tbl+"Col"]
                             + iif(TableSpecBag[Tbl+"HOLD"],0,-500)
         window setattributes FrmHdl from wAtt
      endif
   endforeach
endproc

writelib LibName BatchMan!LoadForms
release procs BatchMan!LoadForms
? "BatchMan!LoadForms()"





; ------------------------------------------------------------
; BatchMan!SetLookupInfoBag  - app specific lookup table info
; ------------------------------------------------------------
proc BatchMan!SetLookupInfoBag()
   private  CurrentProc

   CurrentProc = "BatchMan!SetLookupInfoBag"
   dynarray LookupInfo[]
   LookupInfo["IsEditingLookup"] = false ; initial values
   LookupInfo["IsInLookup"]      = false ;    "      "
   LookupInfo["CM/SD"]           = "No Edit"
   LookupInfo["Matrix"]          = "No Edit"
   LookupInfo["Customer"]        = "Edit OK"
endproc

writelib LibName BatchMan!SetLookupInfoBag
release procs BatchMan!SetLookupInfoBag
? "BatchMan!SetLookupInfoBag()"
ColumnSet()





; ------------------------------------------------------------
; BatchMan!SetFieldLookupBag
;
; - accessed with table()+"->"+field()
; - if isassigned, contains lookup table name
; ------------------------------------------------------------
proc BatchMan!SetFieldLookupBag()
   private  CurrentProc

   CurrentProc = "BatchMan!SetFieldLookupBag"
   dynarray FieldLookup[]

   FieldLookup["Batch->CM/SD"] = "Cmsd"
   FieldLookup["Batch->CustID"] = "Customer"
   FieldLookup["Sample->Matrix"] = "Matrix"
   ;FieldLookup["Sample->Preserv"] = "Preserv"
   FieldLookup["Customer->Cust Type"] = "Custtype"

endproc

writelib LibName BatchMan!SetFieldLookupBag
release procs BatchMan!SetFieldLookupBag
? "BatchMan!SetFieldLookupBag()"
ColumnSet()






; ------------------------------------------------------------
; BatchMan!SetDefaultProcs
; ------------------------------------------------------------
proc BatchMan!SetDefaultProcs()
   private  CurrentProc

   CurrentProc = "BatchMan!SetDefaultProcs"

   dynarray BatchMan_DefaultProcBag[]

   BatchMan_DefaultProcBag[Asc("CoEditKey")] = "BatchMan!SetCoEdit"
   BatchMan_DefaultProcBag[Asc("EditKey")] = "BatchMan!SetEdit"
   BatchMan_DefaultProcBag[Asc("Do_It!")] = "BatchMan!EndEdit"
   BatchMan_DefaultProcBag["RightDoubleDown"] = "LookupMan.Control"
   BatchMan_DefaultProcBag[Asc("F1")] = "LookupMan.Control"
   BatchMan_DefaultProcBag[Asc("F3")] = "BatchMan!UpImage"
   BatchMan_DefaultProcBag[Asc("F4")] = "BatchMan!DownImage"
   BatchMan_DefaultProcBag[Asc("F5")] = "BatchMan!SayWhere"
   BatchMan_DefaultProcBag[Asc("Dos")] = "EventMan.DisableEvent"
   BatchMan_DefaultProcBag[Asc("DosBig")] = "EventMan.DisableEvent"
   BatchMan_DefaultProcBag["DepartTable"] = "BatchMan!DepartTable"
   BatchMan_DefaultProcBag["ArriveRow"] = "BatchMan!GetCustInfo"
   ;atchMan_DefaultProcBag["ArriveTable"] = "BatchMan!GetCustInfo"

   EventMan.SetHandlersFrom(BatchMan_DefaultProcBag)

endproc

writelib LibName BatchMan!SetDefaultProcs
release procs BatchMan!SetDefaultProcs
? "BatchMan!SetDefaultProcs()"
ColumnSet()




; ------------------------------------------------------------
; BatchMan!SetCoEdit
; ------------------------------------------------------------
proc BatchMan!SetCoEdit()
   private CurrentProc
   CurrentProc = "BatchMan!SetCoEdit"

   if isassigned(EventMan.IsWait) then
      message "Setting COEDIT programmatically..."
      coeditkey
      return 1
   else
      return 0
   endif

endproc

writelib LibName BatchMan!SetCoEdit
release procs BatchMan!SetCoEdit
? "BatchMan!SetCoEdit()"
ColumnSet()





; ------------------------------------------------------------
; BatchMan!EndEdit
; ------------------------------------------------------------
proc BatchMan!EndEdit()
   private CurrentProc
   CurrentProc = "BatchMan!EndEdit"
   if isassigned(EventMan.IsWait) and
      sysmode() = "CoEdit" Or Sysmode() = "Edit" then
      message "Ending EDIT or COEDIT programmatically..."
      do_it!
      ;clearall
      return 2
   else
      return 0
   endif
endproc

writelib LibName BatchMan!EndEdit
release procs BatchMan!EndEdit
? "BatchMan!EndEdit()"
ColumnSet()






; ------------------------------------------------------------
; BatchMan!GetCustInfo
; ------------------------------------------------------------
proc BatchMan!GetCustInfo()
   private CurrentProc,
           Cust

   CurrentProc = "BatchMan!GetCustInfo"

   if table() = "Batch" then

      Cust = [CustID]

      postrecord

      window select EventMan.WindowObjectTag["CustomerTable"]

      moveto [CustID]
      locate Cust
      if retval then

         CustName = [Company]
         CustDiv  = [Div]

      else
         CustName = "n/a"
         CustDiv  = "n/a"
      endif
      window select EventMan.WindowObjectTag["BatchForm"]
      return 1
   else
      return 0
   endif

endproc

writelib LibName BatchMan!GetCustInfo
release procs BatchMan!GetCustInfo
? "BatchMan!GetCustInfo()"
ColumnSet()



; ------------------------------------------------------------
; BatchMan!DepartTable
; ------------------------------------------------------------
proc BatchMan!DepartTable()
   private CurrentProc
   CurrentProc = "BatchMan!DepartTable"
   if table() = "Sample" then
      postrecord
   endif
   return 0
endproc

writelib LibName BatchMan!DepartTable
release procs BatchMan!DepartTable
? "BatchMan!DepartTable()"
ColumnSet()





; ------------------------------------------------------------
; BatchMan!SayWhere
; ------------------------------------------------------------
proc BatchMan!SayWhere()
   private CurrentProc, x
   CurrentProc = "BatchMan!SayWhere"
   message EventMan.ObjectTagWindow[EventMan.TargetWindow],
           "/",table()
   x=getchar()
   return 1
endproc

writelib LibName BatchMan!SayWhere
release procs BatchMan!SayWhere
? "BatchMan!SayWhere()"
ColumnSet()



; ------------------------------------------------------------
; BatchMan!UpImage
; ------------------------------------------------------------
proc BatchMan!UpImage()
   private CurrentProc
   CurrentProc = "BatchMan!UpImage"
   upimage
   BatchMan!SayWhere()
   return 1
endproc

writelib LibName BatchMan!UpImage
release procs BatchMan!UpImage
? "BatchMan!UpImage()"
ColumnSet()



; ------------------------------------------------------------
; BatchMan!DownImage
; ------------------------------------------------------------
proc BatchMan!DownImage()
   private CurrentProc
   CurrentProc = "BatchMan!DownImage"
   downimage
   BatchMan!SayWhere()
   return 1
endproc

writelib LibName BatchMan!DownImage
release procs BatchMan!DownImage
? "BatchMan!DownImage()"
ColumnSet()







; ------------------------------------------------------------
; LookupMan.Control
;
; - called by event manager
; - if there is a FieldLookup[] index for the
;   current table()->field() focus
;   - sets LookupInfo["IsInLookup"] = true
;   - sets local var LookupTable to the FieldLookup[] value
;   - if there is a special lookup handler assigned for the
;     current field, execprocs that proc name
;   - else calls LookupMan.GetFocus() and then execprocs the
;     return from LookupMan.GetEvent()
; - else calls CalendarDialog() if a date, or PopupCalc() if
;   a numeric
; - returns 1 to end event and return to wait..endwait
; ------------------------------------------------------------
proc LookupMan.Control()
   private  CurrentProc,
            LookupTable,
            LookupHandle,
            CalendarSelection
   CurrentProc = "LookupMan.Control"

   if isassigned(FieldLookup[table()+"->"+field()]) then
      LookupInfo["CurrentValue"] = []
      LookupInfo["IsInLookup"] = true
      LookupTable = FieldLookup[table()+"->"+field()]
      if isassigned(LookupSpecialHandlers[table()+"->"+field()]) then
         execproc LookupSpecialHandlers[table()+"->"+field()]
      else
         LookupMan.GetFocus()
         while LookupInfo["IsInLookup"]
            execproc LookupMan.GetEvent() ; returns "LookupMan.Select"
            ;or "LookupMan.Cancel" or "LookupMan.Edit"
         endwhile
      endif
   else
      if fieldtype() = "D" then
         CalendarSelection = Calendar.Dialog(today())
         [] = iif(isblank(CalendarSelection),[],CalendarSelection)
      endif
   endif

   return 1

endproc

writelib LibName LookupMan.Control
release procs LookupMan.Control
? "LookupMan.Control()"
ColumnSet()




; ------------------------------------------------------------
; LookupMan.GetFocus
;
; - called by App!LookupHandler()
; - sets target info (FromTable, FroField, etc.) for lookup
; - sets LookupInfo["IsInLookup"] = true
; - selects lookup table form window and moves it back to
;   pre-established on-screen location
; ------------------------------------------------------------
proc LookupMan.GetFocus()
   private  CurrentProc,
            wAtt

   CurrentProc = "LookupMan.GetFocus"
   LookupInfo["LookupTable"] = FieldLookup[table()+"->"+field()]
   LookupInfo["LookupHandle"]
      = EventMan.WindowObjectTag[LookupInfo["LookupTable"]+"FORM"]
   LookupHandle = LookupInfo["LookupHandle"]
   LookupInfo["FromField"] = field()
   LookupInfo["FromTable"] = table()
   LookupInfo["FromWindow"] = getwindow()
   postrecord nopost

   window select LookupInfo["LookupHandle"]
   window getattributes LookupInfo["LookupHandle"] to wAtt
   wAtt["origincol"] = wAtt["origincol"]+500
   window setattributes LookupInfo["LookupHandle"] from wAtt
   imagerights readonly

endproc

writelib LibName LookupMan.GetFocus
release procs LookupMan.GetFocus
? "LookupMan.GetFocus()"
ColumnSet()





; ------------------------------------------------------------
; LookupMan.RestoreFocus
; ------------------------------------------------------------
proc LookupMan.RestoreFocus()
  private CurrentProc, wAtt
  CurrentProc = "LookupMan.RestoreFocus"

  dynarray wAtt[]
  window getattributes LookupInfo["LookupHandle"] to wAtt
  wAtt["origincol"] = wAtt["origincol"] - 500
  window setattributes LookupInfo["LookupHandle"] from wAtt
  imagerights

  window select LookupInfo["FromWindow"]

  ; - if focus returns to a multi-table form, make sure
  ;   we end up in the table we came from
  if table() <> LookupInfo["FromTable"] then
     moveto LookupInfo["FromTable"]
  endif


endproc

writelib LibName LookupMan.RestoreFocus
release procs LookupMan.RestoreFocus
? "LookupMan.RestoreFocus()"
ColumnSet()






; ------------------------------------------------------------
; LookupMan.HiLiteField
; ------------------------------------------------------------
proc LookupMan.HiLiteField()
   private CurrentProc,
           FromField

   CurrentProc = "LookupMan.HiLiteField"

   canvas off

   FromField = field()

   ; get lookup code field coordinates
   ctrlhome
   fieldview
   home
   synccursor
   CR1 = row()
   CC1 = col()

   CR2 = CR1
   down
   synccursor
   while row()>CR2
      CR2=row()
      down
      synccursor
   endwhile

   if CR2>CR1 then
      left
   else
      end
   endif
   synccursor
   CC2 = col()
   enter

   if FromField = LookupField then
       ; highlight lookup code field blinking (current) white on red
      paintcanvas attribute  79+128 CR1,CC1,CR2,CC2
   else
      ; - paint lookup field white on red
      paintcanvas attribute  79 CR1,CC1,CR2,CC2
      ; - highlight current cursor field blinking
      moveto field FromField
      if search(substr(fieldtype(),1,1),"MBO") > 0 then
         ; - get coordinates and paint memo, blob and other type fields
         synccursor
         R1=row() C1=col()
         R2=R1    C2=C1+2
         paintcanvas fill "[*]" attribute 79 R1,C1,R2,C2
      else
         ; - get coordinates and paint regular type fields
         fieldview
         home
         synccursor
         R1 = row()
         C1 = col()
         R2 = R1
         down
         synccursor
         while row()>R2
            R2=row()
            down
            synccursor
         endwhile
         if R2>R1 then
            left
         else
            end
         endif
         synccursor
         C2 = col()
         enter
         paintcanvas blink R1,C1,R2,C2
      endif
   endif

   canvas on
   ;echo normal echo off

endproc

writelib LibName LookupMan.HiLiteField
release procs LookupMan.HiLiteField
? "LookupMan.HiLiteField()"
ColumnSet()





; ------------------------------------------------------------
; LookupMan.GetEvent
; ------------------------------------------------------------
proc LookupMan.GetEvent()
   private  CurrentProc,
            LUwAtt,
            LUOR,
            LUOC,
            CR1,
            CR2,
            CC1,
            CC2,
            R1,
            R2,
            C1,
            C2,
            EventBag,
            EventType,
            Action,
            ConfirmButton,
            MouseBarHandle,
            MouseBarActions,
            x,
            LookupField,
            Vret,
            BBwAtt

   CurrentProc = "LookupMan.GetEvent"

   dynarray LUwAtt[]                           ; - lookup window attribs
   dynarray BBwAtt[]                           ; - base bar menu cover window


   MouseBarHandle = 0

   ctrlhome
   locate Lookupinfo["CurrentValue"]

   window getattributes LookupInfo["LookupHandle"] to LUwAtt ;   l/u window has focus
   LUOR =LUwAtt["ORIGINROW"]
   LUOC =LUwAtt["ORIGINCOL"]

   PaintMouseScrollBar()

   BBwAtt["HASSHADOW"] = false
   BBwAtt["HASFRAME"]  = false
   BBwAtt["STYLE"]     = 118
   window create floating
      @ 22, 7
      height 2   width 73
      attributes BBwAtt
      to BaseBarHandle
   setcanvas BaseBarHandle
   paintcanvas fill("")  attribute   8   0,  0,  0, 68
   paintcanvas fill("")  attribute 113   0, 69,  0, 72
   paintcanvas fill("")  attribute 113   1,  0,  1, 72


   window select LookupInfo["LookupHandle"]
   setcanvas default
   echo normal
   echo off


   ctrlhome
   LookupField = field()

   while true

      LookupMan.HiLiteField()

      getevent key "all" mouse "down","auto" to EventBag

      EventType = EventBag["Type"]
      switch
         case EventType = "KEY":
            switch

               ; | G. Crickard -
               case EventBag["KEYCODE"] > 32 and EventBag["KEYCODE"] < 127:
                  IncZoom(EventBag["KEYCODE"] )

              ;case EventBag["KEYCODE"] = asc("Del"):
              ;   release vars ZmKy   ;   Reset Zoom on use of cursor
              ;   LookEd()
              ;; - G. Crickard |

               case EventBag["KEYCODE"] = asc("Right"):
                  release vars ZmKy
                  right
               case EventBag["KEYCODE"] = asc("Left"):
                  release vars ZmKy
                  left
               case EventBag["KEYCODE"] = asc("Down"):
                  release vars ZmKy
                  down
               case EventBag["KEYCODE"] = asc("Up"):
                  release vars ZmKy
                  up
               case EventBag["KEYCODE"] = asc("PgDn"):
                  release vars ZmKy
                  pgdn
               case EventBag["KEYCODE"] = asc("PgUp"):
                  release vars ZmKy
                  pgup
               case EventBag["KEYCODE"] = asc("CtrlPgDn"):
                  release vars ZmKy
                  ctrlpgdn
               case EventBag["KEYCODE"] = asc("CtrlPgUp"):
                  release vars ZmKy
                  ctrlpgup
               case EventBag["KEYCODE"] = asc("End"):
                  release vars ZmKy
                  end
               case EventBag["KEYCODE"] = asc("Home"):
                  release vars ZmKy
                  home

               case EventBag["KEYCODE"] = asc("Do_It!"):
                  release vars ZmKy
                  ctrlhome
                  Vret = "LookupMan.Select"
                  quitloop
               case EventBag["KEYCODE"] = asc("Esc"):
                  release vars ZmKy
                  Vret = "LookupMan.Cancel"
                  quitloop
               case EventBag["KEYCODE"] = asc("F9"):
                  release vars ZmKy
                  Vret = "LookupMan.Edit"
                  quitloop
            endswitch
            ; clean up the prior paint
            echo normal
            echo off

         case EventType = "MOUSE":

            ; if user clicked on mouse bar, do the action picked
            if windowat(EventBag["ROW"],
                        EventBag["COL"]) = MouseBarHandle then
               switch
                  case EventBag["Action"] = "DOWN":
                     release vars ZmKy
                     localizeevent EventBag
                     Action = MouseBarActions[EventBag["ROW"]+1]
                     switch
                        case isblank(Action): beep
                        case Action = "esc":
                           Vret = "LookupMan.Cancel"
                           quitloop
                        otherwise: keypress Action
                     endswitch
                     echo normal
                     echo off
                     loop
                  case EventBag["Action"] = "AUTO":
                     release vars ZmKy
                     switch
                        case isblank(Action): beep
                        case Action = "esc":
                           Vret = "LookupMan.Cancel"
                           quitloop
                        otherwise: keypress Action
                     endswitch
                     echo normal
                     echo off
                     loop
               endswitch
            endif

            ; otherwise make sure mouse click is on lookup window
            if windowat(EventBag["ROW"],
                        EventBag["COL"]) = LookupInfo["LookupHandle"] then
               ; must be in echo normal to make mouse execevents
               ; affect the workspace
               release vars ZmKy
               echo normal
               execevent EventBag
               echo off
               if EventBag["DOUBLECLICK"] then
                  release vars ZmKy
                  do_it!  ; end the fieldview

                  LookupMan.HiLiteField()

                  if MouseSelectionConfirmed() then
                     ctrlhome            ; move to first field of record
                     Vret = "LookupMan.Select"
                     quitloop
                  endif
               endif
            endif

      endswitch

   endwhile


   window select MouseBarHandle
   window close

   window select BaseBarHandle
   window close

   window select LookupHandle

   return Vret

endproc

writelib Libname LookupMan.GetEvent
release procs LookupMan.GetEvent
? "LookupMan.GetEvent()"
ColumnSet()






; ------------------------------------------------------------
; LookupMan.Select
;
; - proc name returned by LookupMan.GetEvent and called via
;   execproc from the lookup handler proc
; - moves to the first field, grabs field value, assigns
;   it to LookupInfo["LookupReturn"]
; - relocates lookup window off-screen
; - restores focus to LookupInfo["FromWindow"]
; - moves to appropriate table and field and pastes in
;   the LookupReturn value
; - sets LookupInfo["IsInLookup"] to false
;
; ------------------------------------------------------------
proc LookupMan.Select()
  private CurrentProc
  CurrentProc = "LookupMan.Select"

  LookupInfo["LookupReturn"] = []


  LookupMan.RestoreFocus()

  moveto field LookupInfo["FromField"]
  [] = LookupInfo["LookupReturn"]

  LookupInfo["IsInLookup"] = false

endproc

writelib LibName LookupMan.Select
release procs LookupMan.Select
? "LookupMan.Select()"
ColumnSet()




; ------------------------------------------------------------
; LookupMan.Cancel
;
; - proc name returned by LookupMan.GetEvent and called via
;   execproc from the lookup handler proc
; - relocates lookup window off-screen
; - restores focus to LookupInfo["FromWindow"]
; - moves to appropriate table and field
; - sets LookupInfo["IsInLookup"] to false
; - returns 1
; ------------------------------------------------------------
proc LookupMan.Cancel()
  private CurrentProc
  CurrentProc = "LookupMan.Cancel"

  LookupMan.RestoreFocus()

  ; - if focus returns to a multi-table form, make sure
  ;   we end up in the table we came from
  if table() <> LookupInfo["FromTable"] then
     moveto LookupInfo["FromTable"]
  endif

  moveto field LookupInfo["FromField"]

  LookupInfo["IsInLookup"] = false

endproc

writelib LibName LookupMan.Cancel
release procs LookupMan.Cancel
? "LookupMan.Cancel()"
ColumnSet()




; ------------------------------------------------------------
; LookupMan.Edit
; ------------------------------------------------------------
proc LookupMan.Edit()
   private CurrentProc
   CurrentProc = "LookupMan.Edit"
   echo normal
   wait table
      proc "LookupMan.EditEventControl"     all
   endwait
endproc

writelib LibName LookupMan.Edit
release procs LookupMan.Edit
? "LookupMan.Edit()"
ColumnSet()




; ------------------------------------------------------------
; LookupMan.EditEventControl
; ------------------------------------------------------------
proc LookupMan.EditEventControl(Trigger,EventBag,Cycle)
   private CurrentProc
   CurrentProc = "LookupMan.EditEventControl"

   EventType = EventBag["Type"]
   switch
      case EventType = "KEY":
         switch
            case EventBag["KEYCODE"] = asc("Right"):     right
            case EventBag["KEYCODE"] = asc("Left"):      left
            case EventBag["KEYCODE"] = asc("Down"):      down
            case EventBag["KEYCODE"] = asc("Up"):        up
            case EventBag["KEYCODE"] = asc("PgDn"):      pgdn
            case EventBag["KEYCODE"] = asc("PgUp"):      pgup
            case EventBag["KEYCODE"] = asc("CtrlPgDn"):  ctrlpgdn
            case EventBag["KEYCODE"] = asc("CtrlPgUp"):  ctrlpgup
            case EventBag["KEYCODE"] = asc("End"):       end
            case EventBag["KEYCODE"] = asc("Home"):      home

            case EventBag["KEYCODE"] = asc("Zoom"):
               echo normal
               zoom
               echo off

            case EventBag["KEYCODE"] = asc("ZoomNext"):
               zoomnext
               echo normal
               echo off

            case EventBag["KEYCODE"] = asc("Ins"):       ins
            case EventBag["KEYCODE"] = asc("Del"):       del
            case EventBag["KEYCODE"] = asc("Undo"):      undo

            case EventBag["KEYCODE"] = asc("Do_It!"):
               ctrlhome
               return "LookupMan.Select"

            case EventBag["KEYCODE"] = asc("Esc"):
               return "LookupMan.Cancel"

            case EventBag["KEYCODE"] = asc("F9"):
               return "LookupMan.Edit"

         endswitch
         ; this is required to clean up the prior paint
         echo normal
         echo off

      case EventType = "MOUSE":

   endswitch


endproc

writelib LibName LookupMan.EditEventControl
release procs LookupMan.EditEventControl
? "LookupMan.EditEventControl()"
ColumnSet()





; ------------------------------------------------------------
; IncZoom
; ------------------------------------------------------------
proc IncZoom(KeyPressed)
   private CurrentProc,
           KeyPressed,         ;   holds incoming keypress
           ZoomVar,            ;   = ZoomKey + ".." for zoom wildcard
           FType,              ;   Length of lookup field
           n                   ;   used for Match Value & pause
   ;   Global Vars
   ;      ZmKy                 ;   concatenated keystrokes
   CurrentProc = "IncZoom"

   if isassigned(ZmKy) then
      ZmKy = ZmKy+chr(keypressed)
   else
      ZmKy = chr(keypressed)
   endif

   ZoomVar = ZmKy + ".."
   zoom select ZoomVar
   n=match([],Zoomvar)

   if not n then
      message ZoomVar +" Match not found"
      LookAdd()
   endif

   return

endproc

writelib LibName IncZoom
release procs IncZoom
? "IncZoom()"
ColumnSet()









; ------------------------------------------------------------
; PaintMouseScrollBar -
; ------------------------------------------------------------
proc PaintMouseScrollBar()
   private CurrentProc,
           MBwAtt,
           R,
           C,
           BarAtt1,
           BarAtt2

   CurrentProc = "PaintMouseScrollBar"

   dynarray MBwAtt[]                  ; - mouse bar window attribs

   if not(ismultiform(table(),form())) and formtype("MultiRecord") then
      R = LUOR
      C = LUOC+1
   else
      R = 16
      C = 0
   endif

   if TableSpecBag[LookupTable+"Bar"] = "F" then
      BarAtt1 = 42
      BarAtt2 = 40
   else
      BarAtt1 = 15
      BarAtt2 =  7
   endif

   MBwAtt["HASSHADOW"] = false
   MBwAtt["HASFRAME"]  = false
   MBwAtt["STYLE"]     = BarAtt1 ; - my lookup forms are this color, or..
   window create floating        ;   with black on lt. gray fields
      @ R, C
      height 8   width 1         ; - my lookup tables are at least
      attributes MBwAtt          ;   6 rows deep
      to MouseBarHandle          ; - global for use by calling proc

   setcanvas MouseBarHandle      ; - canvas coords window relative

   array MouseBarActions[8]   ; - global for use by calling proc
         MouseBarActions[1] = "esc"
         MouseBarActions[2] = ""
         MouseBarActions[3] = "home"
         MouseBarActions[4] = "pgup"
         MouseBarActions[5] = "up"
         MouseBarActions[6] = "down"
         MouseBarActions[7] = "pgdn"
         MouseBarActions[8] = "end"

   @ 0,0 ?? ""     ; Cancel
          ? ""      ;
          ? "H"     ; Home
          ? ""     ; PgUp
          ? ""     ; Up         ;<- these arrows are dk. gray on
          ? ""     ; Down       ;<  green instead of the lt. green
          ? ""     ; PgDn       ;   on green (42)
          ? "E"     ; End
   paintcanvas attribute BarAtt2 4,0,5,0  ;this paints them dk. gray or ..


endproc

writelib Libname PaintMouseScrollBar
release procs PaintMouseScrollBar
? "PaintMouseScrollBar"
ColumnSet()





; ------------------------------------------------------------
; MouseSelectionConfirmed
; ------------------------------------------------------------
proc MouseSelectionConfirmed()
   private CurrentProc,
           R
   CurrentProc = "MouseSelectionConfirmed"
   synccursor
   R = iif(row()>16,row()-9,row())
   showdialog ""
      @ R+1, LUOC+2 height 7 width 28
      paintcanvas fill "    [Enter]     [Esc]     "
                  attribute 120  0,0,0,25
      pushbutton @1,2 width 10
         "~O~K"
         ok
         default
         value "OK"
         tag "OK"
         to ConfirmButton
      pushbutton @1,13 width 10
         "~C~ancel"
         cancel
         value "cancel"
         tag "Cancel"
         to ConfirmButton
      paintcanvas fill " Please Confirm or Cancel "
                  attribute 112  3,0,3,25
      paintcanvas fill "   DoubleClick Selection  "
                  attribute 112  4,0,4,25
   enddialog
   return retval   ;ConfirmButton
endproc

writelib Libname MouseSelectionConfirmed
release procs MouseSelectionConfirmed
? "MouseSelectionConfirmed()"
ColumnSet()



