;---------------------------------------------------------------------------
;
;  written 1990 by William S. Caple          Peace REMO II Network Manager
;                                            SM-ALC/MM(3)  Bldg 250H
;  03/12/90 09:23am                          McClellan AFB, CA  95652-5609
;
;                                              Com'l:  (916) 643-3047
;                                            AUTOVON:  633-3047
;
;----------------------------------------------------------------------------


LIBNAME = sdir() + "formtool"
createlib LIBNAME
clear
?? "Creating procedure library " + upper(LIBNAME)
 ? fill("",80)
 @ row()-1, 0
ProcCount  = 0




; ---------------------------------------------------------------------------
;                                Column Set
; ---------------------------------------------------------------------------
proc ColumnSet()
  CurrentProc = "ColumnSet"
  ProcCount = ProcCount + 1
  switch
    case ProcCount = 23:   @ 1,0 setmargin 26
    case ProcCount = 46:   @ 1,0 setmargin 52
  endswitch
endproc

writelib LIBNAME ColumnSet
;release procs ColumnSet
?  "ColumnSet()"
ColumnSet()





; ---------------------------------------------------------------------------
; sets data fields in current line to current color attributes
; ---------------------------------------------------------------------------
proc SCA()
  private x
  CurrentProc = "SCA"

  ctrlhome

  while true
    if colno() = 80 then
      return
    endif
    right
    if fieldinfo() <> "" then
      menu {style} {color} {area} enter
      while fieldinfo() <> ""
        right
      endwhile
      left
      enter
      enter
      right
    endif
  endwhile

endproc

writelib LIBNAME SCA
release procs SCA
? "SCA()"
ColumnSet()





; ---------------------------------------------------------------------------
; sets data fields in current line to current monochrome attributes
; ---------------------------------------------------------------------------
proc SMA()
  private x
  CurrentProc = "SMA"

  ctrlhome
  n = 1
  while fieldinfo() = "" and n < 80
    right
    n = n+1
    if fieldinfo() <> "" then
      menu {style} {monochrome} {area} enter
      while fieldinfo() <> ""
        right
        n = n+1
      endwhile
      left
      enter
      enter
      right
    endif
  endwhile

endproc

writelib LIBNAME SMA
release procs SMA
? "SMA()"
ColumnSet()







; ---------------------------------------------------------------------------
;                               Form Page Copy
; ---------------------------------------------------------------------------
proc FPC()
  private n
  CurrentProc = "FPC"

  array FPA[23]

  if sysmode() <> "Form" then
    beep
    message "Must be in Form mode to use this"
    sleep 1000
    return
  endif

  home
  ctrlhome

  for n from 1 to 23
    FPA[n] = cursorline()
    down
  endfor

endproc

writelib LIBNAME FPC
release procs FPC
? "FPC()"
ColumnSet()




; ---------------------------------------------------------------------------
;                               Form Page Paste
; ---------------------------------------------------------------------------
proc FPP()
  private n
  CurrentProc = "FPP"

  if sysmode() <> "Form" then
    beep
    message "Must be in Form mode to use this"
    sleep 1000
    return
  endif

  if not isassigned(FPA[23]) then
    beep
    message "Array FPA must be assigned to use this"
    sleep 1000
    return
  endif

  home
  ctrlhome

  for n from 1 to 23
    typein FPA[n]
    down
  endfor

endproc

writelib LIBNAME FPP
release procs FPP
? "FPP()"
ColumnSet()



; ---------------------------------------------------------------------------
;                             Partial Form Page Copy
; ---------------------------------------------------------------------------
proc PPC()
  private n, NLines
  CurrentProc = "PPC"
  cursor off
  if sysmode() <> "Form" then
    beep
    message "Must be in Form mode to use this"
    sleep 1000
    return
  endif

  while true
    @ 0,0 ?? "How many lines shall I copy? "
    style reverse
    accept "S" max 23 to NLines
    style
    if not retval or isblank(NLines) then
      beep
      showmenu
        "Oops!" : "Let me try again",
        "Cancel": "Forget it"
      to Ans
      if Ans = "Cancel" then
        return false
      endif
    else
      quitloop
    endif
  endwhile

  array PPA[NLines]

  @ 0,0 ?? "Use "+chr(24)+", "+chr(25)+" arrow keys to move " +
           "to start line, then press Enter, or Esc to cancel"

  while charwaiting()
    retval = getchar()
  endwhile

  while true
    paintcanvas reverse rowno(), 0, rowno(), 79
    n = getchar()
    paintcanvas         rowno(), 0, rowno(), 79
    switch
      case n = -72 : up
      case n = -80 : down
      case n = 13  : quitloop
      case n = 27  : return
      otherwise    : beep
    endswitch
  endwhile
  @ 0,0 clear eol

  ctrlhome

  for n from 1 to NLines
    PPA[n] = cursorline()
    down
  endfor

  beep
  message NLines, " copied"
  sleep 1000

endproc

writelib LIBNAME PPC
release procs PPC
? "PPC()"
ColumnSet()




; ---------------------------------------------------------------------------
;                           Partial Form Page Paste
; ---------------------------------------------------------------------------
proc PPP()
  private n
  CurrentProc = "PPP"

  cursor off

  if sysmode() <> "Form" then
    beep
    message "Must be in Form mode to use this"
    sleep 1000
    return
  endif

  if not isassigned(PPA[1]) then
    beep
    message "Array PPA must be assigned to use this"
    sleep 1000
    return
  endif

  @ 0,0 ?? "Use "+chr(24)+", "+chr(25)+" arrow keys to move " +
           "to start line, then press Enter, or Esc to cancel"
  @ 1,0 ?? "(" + strval(arraysize(PPA)) + " lines stored)"

  home
  ctrlhome

  while charwaiting()
    retval = getchar()
  endwhile

  while true
    paintcanvas reverse rowno(), 0, rowno(), 79
    n = getchar()
    paintcanvas         rowno(), 0, rowno(), 79
    switch
      case n = -72 : up
      case n = -80 : down
      case n = 13  : quitloop
      case n = 27  : return
      otherwise    : beep
    endswitch
  endwhile
  @ 0,0 clear eol

  ctrlhome

  for n from 1 to arraysize(PPA)
    typein PPA[n]
    down
  endfor

endproc

writelib LIBNAME PPP
release procs PPP
? "PPP()"
ColumnSet()



; ------------------------------------------------------------
;                  HIDE WINDOW OFF SCREEN
; ------------------------------------------------------------
proc wHide()
  private w
  window handle image imageno() to w
  window move w to -1000,-1000
  formkey
endproc

writelib LibName wHide
release procs wHide
? "wHide()"
ColumnSet()




; ------------------------------------------------------------
;                       WINDOW WHERE?
; ------------------------------------------------------------
proc WinWhere()
  private CurrentProc
  CurrentProc = "WinWhere"

  dynarray scCurrWinAtt[]
  window getattributes getwindow() to scCurrWinAtt
  retval = "Window origin is at row: " + strval(scCurrWinAtt["originrow"]) +
          ", col: "+strval(scCurrWinAtt["origincol"])

  return retval

endproc

writelib LibName WinWhere
release procs WinWhere
? "WinWhere()"





; ------------------------------------------------------------
;                   NO FRAME
; ------------------------------------------------------------
proc NoFrame()
  private CurrentProc
  CurrentProc = "NoFrame"

  window list to scWinList
  if arraysize(scWinList) = 0 then
    return
  endif

  dynarray scCurrWinAtt[]
  scCurrWinAtt["hasframe"] = false
  ;scCurrWinAtt["hasshadow"] = false
  window setattributes getwindow() from scCurrWinAtt

endproc

writelib LibName NoFrame
release procs NoFrame
? "NoFrame()"




; ---------------------------------------------------------
; loads table LuTable with tableview offscreen, formview
; LuForm with no frame and narrowed by 1, logs tableview
; and formview handles in dynarrays TWHA and FWHA
; ---------------------------------------------------------
proc LoadLookup(LuTable,LuForm,TWHA,FWHA)
  private WinAtt,TH,FH

  dynarray WinAtt[]

  view LuTable

  window handle image imageno() to TH
  TWHA[LuTable] = TH
  window move TWHA[LuTable] to -1000,-1000

  pickform LuForm

  window handle current to FH
  FWHA[LuTable] = FH
  WinAtt["hasframe"]  = false
  WinAtt["hasshadow"] = true
  window setattributes FH from WinAtt

  ;wResize(FWHA[LuTable],0,-1)      ; get rid of black edge

endproc

writelib LibName LoadLookup
release procs LoadLookup
? "LoadLookup()"
ColumnSet()




; ---------------------------------------------------------
; loads table MTable with tableview offscreen, formview
; MForm with no frame, no shadow, and maximized, logs
; tableview and formview handles in dynarrays TWHA and FWHA
; ---------------------------------------------------------
proc LoadMaster(MTable,MForm,TWHA,FWHA)
  private WinAtt,TH,FH

  dynarray WinAtt[]

  view MTable

  window handle image imageno() to TH
  TWHA[MTable] = TH
  window move TWHA[MTable] to -1000,-1000

  pickform MForm

  window handle current to FH
  FWHA[MTable] = FH
  WinAtt["hasframe"]  = false
  WinAtt["hasshadow"] = false
  window setattributes FH from WinAtt
  window maximize FH

endproc

writelib LibName LoadMaster
release procs LoadMaster
? "LoadMaster()"
ColumnSet()










beep
message "Procedure library definition complete - press any key to continue"
retval = getchar()

autolib = "formtool"

setkey   3 FPC()   ;CtrlC
setkey  16 FPP()  ;CtrlP

setkey -46 PPC() ;AltC
setkey -25 PPP() ;AltP

setkey  19 SCA()  ;CtrlS

setkey -17 WinWhere()   ;AltW plays this

setkey -35 wHide()      ;AltH plays this

setkey -49 NoFrame()    ;AltN plays this



release procs ColumnSet

release vars LIBNAME, ProcCount


dynarray twHandle[]            ; tableview window handles
dynarray fwHandle[]            ; formview window handles





