;This file is copyright (c) 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : Procedure TabLock, TabLock2
;Source File     : LOCKS.SC
;Author          : Jerry Coffey
;                  Paradox Informant
;
;Informant Issue : March 1991
;
;Description     : Procedures for locking both one and two tables snf passing
;                  appropriate lock types
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740



proc tablock2(tabl1,tabl2,locktype)

     private tabl1,tabl2,locktype

     while true

          execute "lock \"" + tabl1 + "\" " + locktype +
                      ",\"" + tabl2 + "\" " + locktype

          if retval = true
            then quitloop
            else message "Tables in Use by " + strval(erroruser()) +
                         ", Will Retry Until Tables are Available."
                 sleep 5000
                 message "Trying"
          endif

     endwhile

endproc

proc tabunlock2(tabl1,tabl2,locktype)

     private tabl1,tabl2,locktype

     execute "unlock \"" + tabl1 + "\" " + locktype +
                   ",\"" + tabl2 + "\" " + locktype

endproc

proc tablock(tabl,locktype)

     private tabl,locktype

     while true

          execute "lock \"" + tabl + "\" " + locktype

          if retval = true
            then quitloop
            else message "Table in Use by " + strval(erroruser()) +
                         ", Will Retry Until Table is Available."
                 sleep 5000
                 message "Trying"
          endif

     endwhile

endproc


















































