/*
	Copyright 1992 Curt Hagenlocher
	Direct all inquiries to Motek, Inc.
		(213) 653-4333
*/

#include <owl.h>
#include <listbox.h>
#include <bchkbox.h>
#include <bbutton.h>
#include <assoc.h>
#include <strng.h>
#include <dict.h>
#include <bwcc.h>
#include <filedial.h>
#include <pxengine.h>

int lockflags[] = { PFL, PWL, WL, FL };

class TLockApp : public TApplication {
public:
	TLockApp(LPSTR Name, HANDLE Inst, HANDLE Prev, LPSTR Cmd, int Show) :
			TApplication(Name, Inst, Prev, Cmd, Show) { }
	virtual void InitMainWindow();
};

class TMainWindow : public TDialog {
	PTListBox lb;
	PTBCheckBox lock[4];
	PTBButton rmv;
	static Dictionary tables;
	int old;
	const char *lookup(void);
	void DoLock(int);
public:
	TMainWindow(PTWindowsObject);
	virtual void SetupWindow();
	virtual LPSTR GetClassName() { return "BORDLG"; }
	virtual void DoOpenButton(RTMessage) = [ID_FIRST + 200];
	virtual void DoCloseButton(RTMessage) = [ID_FIRST + 201];
	virtual void DoListBox(RTMessage) = [ID_FIRST + 100];
	virtual void DoPFLBox(RTMessage) = [ID_FIRST + 300];
	virtual void DoPWLBox(RTMessage) = [ID_FIRST + 301];
	virtual void DoWLBox(RTMessage) = [ID_FIRST + 302];
	virtual void DoFLBox(RTMessage) = [ID_FIRST + 303];
};

Dictionary TMainWindow::tables;

void TLockApp::InitMainWindow() {
	MainWindow = new TMainWindow(NULL);
}

TMainWindow::TMainWindow(PTWindowsObject parent) : TDialog(parent, "MAIN") {
	lb = new TListBox(this, 100);
	lock[0] = new TBCheckBox(this, 300, NULL);
	lock[1] = new TBCheckBox(this, 301, NULL);
	lock[2] = new TBCheckBox(this, 302, NULL);
	lock[3] = new TBCheckBox(this, 303, NULL);
	rmv = new TBButton(this, 201);
	old = -1;
}

void TMainWindow::SetupWindow() {
	TDialog::SetupWindow();
	for (int i = 0; i < 4; i++)
		EnableWindow(lock[i]->HWindow, 0);
	EnableWindow(rmv->HWindow, 0);
}

const char *TMainWindow::lookup() {
	char TempName[MAXPATH];
	if (lb->GetSelString(TempName, MAXPATH) < 0)
		return (const char*)0;
	String *tmp = new String(TempName);
	Association &entry = tables.lookup(*tmp);
	delete tmp;
	String *val = (String*)&(entry.value());
	return (const char*)*val;
}

void TMainWindow::DoLock(int pos) {
	char TempName[MAXPATH];
	lb->GetSelString(TempName, MAXPATH);
	char *val = (char*)lookup();
	int err;
	if (val[pos] == '1') {
		PXNetFileUnlock(TempName, lockflags[pos]);
		lock[pos]->Uncheck();
		val[pos] = '0';
	}
	else if (err = PXNetFileLock(TempName, lockflags[pos]), err) {
		if (err == 4) {
			char erruser[31];
			PXNetErrUser(30, erruser);
			wsprintf(TempName, "File in use by %s", erruser);
		}
		else
			lstrcpy(TempName, PXErrMsg(err));
		BWCCMessageBox(HWindow, TempName, "Mozart", MB_OK);
	}
	else {
		lock[pos]->Check();
		val[pos] = '1';
	}
}

void TMainWindow::DoListBox(RTMessage msg) {
	char TempName[MAXPATH];
	int i;
	if (msg.LP.Hi == LBN_SELCHANGE) {
		if (old == -1) {
			for (i = 0; i < 4; i++)
				EnableWindow(lock[i]->HWindow, 1);
		}
		old = lb->GetSelIndex();
		const char *l = lookup();
		for (i=0; i < 4; i++)
			if (l[i] == '0')
				lock[i]->Uncheck();
			else
				lock[i]->Check();
	}
}

void TMainWindow::DoOpenButton(RTMessage) {
	char TempName[MAXPATH];
	int err;
	_fstrcpy(TempName, "*.db");
	if (GetApplication()->ExecDialog(new TFileDialog(this, SD_FILEOPEN,
			TempName)) == IDOK) {
		if (lb->FindExactString(TempName, -1) >= 0) {
			BWCCMessageBox(HWindow, "File already listed", "Mozart", MB_OK);
		}
		else if (err = PXNetFileLock(TempName, PFL), err) {
			if (err == 4) {
				char erruser[31];
				PXNetErrUser(30, erruser);
				wsprintf(TempName, "File in use by %s", erruser);
			}
			else
				lstrcpy(TempName, PXErrMsg(err));
			BWCCMessageBox(HWindow, TempName, "Mozart", MB_OK);
		}
		else {
			String *tab = new String(TempName);
			String *val = new String("1000");
			Association *entry = new Association(*tab, *val);
			tables.add(*entry);
			lb->AddString(TempName);
			EnableWindow(rmv->HWindow, 1);
			char *v = (char*)lookup();
			if (v) {
				for (int i=0; i < 4; i++)
					if (v[i] == '0')
						lock[i]->Uncheck();
					else
						lock[i]->Check();
			}
		}
	}
}

void TMainWindow::DoCloseButton(RTMessage) {
	char TempName[MAXPATH];
	if (lb->GetSelString(TempName, MAXPATH) >= 0) {
		Association &entry = tables.lookup(*new String(TempName));
		tables.detach(entry);
		lb->DeleteString(lb->GetSelIndex());
		delete (String*)&(entry.key());
		delete (String*)&(entry.value());
		delete (Association*)&entry;
		for (int i = 0; i < 4; i++) {
			EnableWindow(lock[i]->HWindow, 0);
			lock[i]->Uncheck();
		}
		EnableWindow(rmv->HWindow, 0);
		old = -1;
	}
}

void TMainWindow::DoPFLBox(RTMessage) {
	DoLock(0);
}

void TMainWindow::DoPWLBox(RTMessage) {
	DoLock(1);
}

void TMainWindow::DoWLBox(RTMessage) {
	DoLock(2);
}

void TMainWindow::DoFLBox(RTMessage) {
	DoLock(3);
}

int PASCAL WinMain(HANDLE Inst, HANDLE Prev, LPSTR Cmd, int Show) {
	TLockApp LockApp("Mozart", Inst, Prev, Cmd, Show);
	PXWinInit("Mozart", PXSHARED);
	BWCCGetVersion();
	LockApp.Run();
	PXExit();
	return LockApp.Status;
}
