#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "idapi.h"

#pragma argsused
int _pascal WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
            int nCmdShow)
{
    hDBIDb      hDb;      // Database handle
    DBIResult   rslt;
    CRTblDesc   crTblDesc;           // Table Descriptor
    BOOL        bOverwrite = FALSE;  // Overwrite, yes/no flag

    FLDDesc fldDesc[] =
    {
        {1, "Field 1", fldZSTRING, 0,         50, 0, 0, 0, 0, 0, 0},
        {2, "Field 2", fldZSTRING, 0,         20, 0, 0, 0, 0, 0, 0},
        {3, "Field 3", fldZSTRING, 0,         10, 0, 0, 0, 0, 0, 0},
        {4, "Field 4", fldBLOB, fldstMEMO,    20, 0, 0, 0, 0, 0, 0},   
        {5, "Field 5", fldBLOB, fldstBINARY,  10, 0, 0, 0, 0, 0, 0},
        {6, "Field 6", fldBLOB, fldstFMTMEMO, 0,  0, 0, 0, 0, 0, 0}
    };
 
    memset(&crTblDesc, 0, sizeof(CRTblDesc)); // Clear the buffer.

    rslt = DbiInit(NULL);
    if (rslt != DBIERR_NONE)
       return;

    rslt = DbiOpenDatabase(NULL, NULL, dbiREADWRITE, dbiOPENSHARED, NULL, NULL,
            NULL, NULL, &hDb);

    if (rslt != DBIERR_NONE)
       return;

    /* Create the table */
    strcpy (crTblDesc.szTblName, "TABLE");
    strcpy (crTblDesc.szTblType, szPARADOX);
    crTblDesc.iFldCount = 6;         
    crTblDesc.pfldDesc = fldDesc;
 
    rslt = DbiCreateTable(hDb, bOverwrite, &crTblDesc);
    if (rslt != DBIERR_NONE)
    {
      char buf[32];
      sprintf (buf, "%X", rslt);
      MessageBox (NULL, buf, "Result from DbiCreateTable", MB_OK);
    }

    rslt = DbiCloseDatabase(&hDb);
    rslt = DbiExit();

}

