; LineIt! for Paradox 4.x DOS  Version 1.0
; Copyright (c) 4/88, 5/94 Daniel J. Latner

Proc Lsettings()
Private d, r, c, si, i, n, mc, mn, tmp, tmp1, tmp2, cs, sc, b, bi, br, bc, bb,
        brr, bcc, sp, mu, sf, sfs

; d  = direction of line
; r  = row, for current character position
; c  = column, for current character position
; si = sysinfo, screen width & height
; i  = incrementer
; rl = roll, how often to increase the length of the line, roughly
; n  = string of musical notes
; mc = music counter, incrementer
; mn = music notes, # of notes in song before it must repeat
; cs = check string, stores all black areas as single number for quick check
; sc = score
; b  = bonus, random number between 1 and 9, hit and add *10 to score
; bb = bonus interval, how long to leave number on screen
; bi = bonus incrementer
; br = bonus location, row - random position
; bc = bonus location, col
; brr, bcc = hold br and bc positions for clear char
; sp  = speed
; spd = speed setting
; mu  = song selection
; sfs = sound effects switch on/off
; sf  = sound effects frequency

Sysinfo to si
spd = 50    ;---default speed

While True
  d = -77   ;---direction, right to start
  i = 1     ;---incrementer
  rl = 20   ;---increase length of line every rl paces
  r = 10    ;---row & col start position
  c = 5
  tmp = Strval(10 * si["SCREENWIDTH"] + 3)
  cs = Fill("0", 5 - Len(tmp)) + tmp + ","
  tmp = Strval(10 * si["SCREENWIDTH"] + 4)
  cs = cs + Fill("0", 5 - Len(tmp)) + tmp + ","
  tmp = Strval(10 * si["SCREENWIDTH"] + 5)
  cs = cs + Fill("0", 5 - Len(tmp)) + tmp + "," ;--start line as 3 chrs @10,3
  sc = 0     ;---initial score
  bb = 75    ;---move bonus char every bb paces
  bi = 1     ;---bonus incrementer
  b = Round(Rand() * 8, 0) + 1  ;---random # between 1-9, bonus points
  br = Round(Rand() * (si["SCREENHEIGHT"] - 3), 0) + 1 ;rand pos row
  bc = Round(Rand() * (si["SCREENWIDTH"] - 3), 0) + 1  ;rand pos col
  brr = br         ;----hold last position for clear character
  bcc = bc

  Clear
  SHOWDIALOG ""
     @Int((si["SCREENHEIGHT"] - 16) / 2), Int((si["SCREENWIDTH"] - 61) / 2) - 1
     HEIGHT 16 WIDTH 61
     Style Attribute 113
     @0,15 ?? "LineIt!  -  For Paradox 4.5"
     @1,15 ?? "  by: Daniel J. Latner  "
     Style Attribute 112
     @5,4 ?? "Slow                SPEED: " + Strval(Int(spd))
     @5,48 ?? "Fast"

     SLIDER @4,4
       HORIZONTAL
       LENGTH 50
       MIN 1
       MAX 100
       ARROWSTEP 1
       PAGESTEP 1
       TAG ""
       TO spd

     RADIOBUTTONS @8,2 HEIGHT 2 WIDTH 14
       "Boogie!!",
       "No Music"
       TAG ""
       TO mu

     RADIOBUTTONS @8,20 HEIGHT 2 WIDTH 19
       "Sound Effects",
       "No Sound"
       TAG ""
       TO sfs

     PUSHBUTTON @12,0 WIDTH 21
       "Let's ~G~o Already!"
       OK
       DEFAULT
       VALUE ""
       TAG ""
       TO nul

     PUSHBUTTON @12,30 WIDTH 8
       "~H~uh?"
       VALUE Huh()
       TAG ""
       TO nul

     PUSHBUTTON @12,47 WIDTH 11
       "I ~Q~uit!"
       CANCEL
       VALUE ""
       TAG ""
       TO nul
  ENDDIALOG

  If Not Retval Then
    Quit
  Endif

  Picksong()            ;----let user pick from several songs
  sp = 125 - Int(spd)   ;----(if I ever get around to writing more)
  If mn = 0 Then
    sp = Int(sp * 4)    ;----if no music, then force a delay
  Endif
  If sfs = 1 Then       ;----set sound effects (beep) on or off
    sf = 300
  Else
    sf = 50000   ;----too high to hear (if you hear this, you're not human!)
  Endif
  Cursor off
  Mouse Hide
  Lineit()
  Cursor Normal
  Mouse Show
Endwhile

Endproc
;===========================================================================
Proc Huh()       ;------instructions for game, can scroll
Private t, ti

ti = 0   ;---text incrementer, allows text to scroll
Array t[29]
t[1]  = " It's easy.  Use the arrow keys to move your line"
t[2]  = "  around the screen.  Don't touch the sides of the"
t[3]  = "  screen or your own line, or you will die!       "
t[4]  = ""
t[5]  = " As you move around, your line will grow longer  "
t[6]  = "  and your score will increase 5 points each time "
t[7]  = "  this happens.  For extra points, eat the bonus  "
t[8]  = "  numbers, 1=10 points, 2=20 points, etc.         "
t[9]  = ""
t[10] = " This game can be played in any screen resolution/"
t[11] = "  size, and from anywhere in Paradox.  To pop up   "
t[12] = "  the game at any time, you can set a hot key, and "
t[13] = "  play anywhere, in any Paradox mode, (Main, Edit/ "
t[14] = "  CoEdit, Report/Form Designer, in the script      "
t[15] = "  editor... anywhere!!).  Your work will not be    "
t[16] = "  disrupted or affected.                           "
t[17] = ""
t[18] = " Setting a hot key is as easy as <Alt-F10>        "
t[19] = "  {MiniScript}, and typing:                        "
t[20] = "  SETKEY \"F1\" PLAY \"LINEIT\"                    "
t[21] = "  Now every time you press F1 you'll be having     "
t[22] = "  the time of your life!                           "
t[23] = ""
t[24] = " If you find that your PC is too slow to play     "
t[25] = "  the game smoothly... get a faster PC!!!          "
t[26] = "  (Or, for you cheapskates, turn music off.)       "
t[27] = ""
t[28] = " Have fun!                               DL 5/94  "
t[29] = ""

SHOWDIALOG ""
   @Int((si["SCREENHEIGHT"] - 16) / 2), Int((si["SCREENWIDTH"] - 61) / 2) - 1
   HEIGHT 16 WIDTH 61
   Style Attribute 113
   @0,15 ?? "LineIt!  -  For Paradox 4.5"
   @1,15 ?? "  by: Daniel J. Latner  "
   Style Attribute 112
   @3,1  ?? t[1 + Int(ti)]
   @4,1  ?? t[2 + Int(ti)]
   @5,1  ?? t[3 + Int(ti)]
   @6,1  ?? t[4 + Int(ti)]
   @7,1  ?? t[5 + Int(ti)]
   @8,1  ?? t[6 + Int(ti)]
   @9,1  ?? t[7 + Int(ti)]
   @10,1 ?? t[8 + Int(ti)]
   Style Attribute 126
   @11,56 ?? IIF(ti < 20, "\31", "")
   @7,56  ?? IIF(ti < 20, "M", "")
   @8,56  ?? IIF(ti < 20, "O", "")
   @9,56  ?? IIF(ti < 20, "R", "")
   @10,56 ?? IIF(ti < 20, "E", "")

   SLIDER @0,58
     VERTICAL
     LENGTH 14
     MIN 0
     MAX 20
     ARROWSTEP 1
     PAGESTEP 1
     TAG ""
     TO ti

   PUSHBUTTON @12,2 WIDTH 19
     "~Y~eah, I Get It."
     OK
     DEFAULT
     VALUE ""
     TAG ""
     TO nul

   PUSHBUTTON @12,27 WIDTH 27
     "~W~ho Is This Guy Anyway?"
     VALUE Showdan()
     TAG ""
     TO nul

   PUSHBUTTON @300,300 WIDTH 1
     "~X~"
     CANCEL
     VALUE ""
     TAG ""
     TO nul
ENDDIALOG
Return True

Endproc
;===========================================================================
Proc Showdan()  ;-if you stand about 10 feet back & squint, it looks like me

SHOWDIALOG ""
  @Int((si["SCREENHEIGHT"] - 24) / 2), Int((si["SCREENWIDTH"] - 80) / 2)
  HEIGHT 25 WIDTH 80
  @0,1  ?? "          ۲         Dan Latner is one of the leading"
  @1,1  ?? "      ۲۲       New York based Paradox developers, "
  @2,1  ?? "    ۲       and has worked extensively with "
  @3,1  ?? "  ۲       Paradox since 1987."
  @4,1  ?? "  ۲۲۲"
  @5,1  ?? "۱    ۲     Other products from Dan Latner"
  @6,1  ?? "۲  ۲     include Paradox Utilities and "
  @7,1  ?? "۱  ۲۲     Report Tools, with over 2,000 "
  @8,1  ?? "۲     copies sold since 1989.       "
  @9,1  ?? "  ۱۲"
  @10,1 ?? "  ۱۲۲      If you'd like to get in touch,"
  @11,1 ?? "  ۰۲۰      here's the address:"
  @12,1 ?? "    "
  @13,1 ?? "  ۱  ۰             PO BOX 1353        "
  @14,1 ?? "  ۱۲               MURRAY HILL STATION"
  @15,1 ?? "                 NEW YORK  NY 10156 "
  @16,1 ?? "    "
  @17,1 ?? "      \"Sometimes you need to view things at"
  @18,1 ?? "             a distance to see them clearly.\""
  @19,1 ?? "      ۲  "
  @20,1 ?? "      ۲"
  @21,1 ?? "    ۲"
  @22,1 ?? "  ۰"
  Paintcanvas Attribute 112 all  ;--don't even try to figure this out - DL.
  Paintcanvas Attribute 120 0,11,0,12
  Paintcanvas Attribute 120 0,15,0,30
  Paintcanvas Attribute 120 1,9,1,16
  Paintcanvas Attribute 120 1,19,1,20
  Paintcanvas Attribute 120 1,23,1,24
  Paintcanvas Attribute 120 1,29,1,30
  Paintcanvas Attribute 120 1,33,1,34
  Paintcanvas Attribute 120 2,5,2,12
  Paintcanvas Attribute 120 2,17,2,18
  Paintcanvas Attribute 120 2,23,2,28
  Paintcanvas Attribute 120 3,5,3,18
  Paintcanvas Attribute 120 3,21,3,32
  Paintcanvas Attribute 120 3,37,3,38
  Paintcanvas Attribute 120 4,3,5,6
  Paintcanvas Attribute 120 4,11,4,16
  Paintcanvas Attribute 120 4,23,4,26
  Paintcanvas Attribute 120 4,29,4,36
  Paintcanvas Attribute 120 5,9,5,10
  Paintcanvas Attribute 120 5,13,5,18
  Paintcanvas Attribute 120 5,23,5,24
  Paintcanvas Attribute 127 5,27,5,28
  Paintcanvas Attribute 120 5,31,5,36
  Paintcanvas Attribute 120 5,39,5,40
  Paintcanvas Attribute 120 6,1,6,20
  Paintcanvas Attribute 120 6,23,6,26
  Paintcanvas Attribute 127 6,27,6,30
  Paintcanvas Attribute 120 6,33,6,34
  Paintcanvas Attribute 120 6,37,6,38
  Paintcanvas Attribute 120 7,7,7,8
  Paintcanvas Attribute 120 7,11,7,16
  Paintcanvas Attribute 120 7,23,7,24
  Paintcanvas Attribute 127 7,27,7,32
  Paintcanvas Attribute 120 7,33,7,36
  Paintcanvas Attribute 120 8,1,8,6
  Paintcanvas Attribute 120 8,9,8,16
  Paintcanvas Attribute 120 8,23,8,24
  Paintcanvas Attribute 127 8,25,8,32
  Paintcanvas Attribute 120 8,33,8,34
  Paintcanvas Attribute 120 8,39,8,40
  Paintcanvas Attribute 120 9,3,9,4
  Paintcanvas Attribute 120 9,11,9,12
  Paintcanvas Attribute 120 9,19,9,28
  Paintcanvas Attribute 127 9,29,9,32
  Paintcanvas Attribute 120 9,35,9,38
  Paintcanvas Attribute 120 10,3,10,12
  Paintcanvas Attribute 120 10,15,10,16
  Paintcanvas Attribute 120 10,21,10,24
  Paintcanvas Attribute 120 10,29,10,36
  Paintcanvas Attribute 120 11,5,11,10
  Paintcanvas Attribute 120 11,13,11,14
  Paintcanvas Attribute 120 11,17,11,18
  Paintcanvas Attribute 127 11,21,12,22
  Paintcanvas Attribute 120 11,25,11,26
  Paintcanvas Attribute 120 11,29,11,30
  Paintcanvas Attribute 127 11,31,12,34
  Paintcanvas Attribute 120 11,35,11,38
  Paintcanvas Attribute 120 12,7,12,10
  Paintcanvas Attribute 127 12,29,12,34
  Paintcanvas Attribute 120 13,7,14,12
  Paintcanvas Attribute 127 13,21,14,24
  Paintcanvas Attribute 127 13,27,13,36
  Paintcanvas Attribute 120 14,3,14,4
  Paintcanvas Attribute 120 14,7,14,12
  Paintcanvas Attribute 120 14,17,14,18
  Paintcanvas Attribute 120 14,21,14,24
  Paintcanvas Attribute 127 14,27,17,32
  Paintcanvas Attribute 120 15,15,15,16
  Paintcanvas Attribute 127 15,23,15,24
  Paintcanvas Attribute 120 15,33,18,34
  Paintcanvas Attribute 127 15,35,18,36
  Paintcanvas Attribute 120 16,15,16,20
  Paintcanvas Attribute 120 16,23,16,24
  Paintcanvas Attribute 120 17,5,17,6
  Paintcanvas Attribute 120 17,11,17,12
  Paintcanvas Attribute 120 17,15,17,22
  Paintcanvas Attribute 120 18,15,18,18
  Paintcanvas Attribute 120 18,21,18,22
  Paintcanvas Attribute 127 18,29,18,32
  Paintcanvas Attribute 120 19,9,19,14
  Paintcanvas Attribute 120 19,17,19,28
  Paintcanvas Attribute 127 19,29,19,30
  Paintcanvas Attribute 127 19,33,19,36
  Paintcanvas Attribute 120 20,9,20,18
  Paintcanvas Attribute 120 20,23,20,28
  Paintcanvas Attribute 127 20,31,20,36
  Paintcanvas Attribute 120 21,9,21,10
  Paintcanvas Attribute 120 21,13,21,24
  Paintcanvas Attribute 127 21,29,21,38
  Paintcanvas Attribute 120 22,9,22,12
  Paintcanvas Attribute 120 22,23,22,24
  Paintcanvas Attribute 127 22,27,22,40

  PUSHBUTTON @21,40 WIDTH 37
    "~G~et This Ugly Mug Off The Screen!"
    OK
    DEFAULT
    VALUE ""
    TAG ""
    TO nul

  PUSHBUTTON @300,300 WIDTH 1
    "~X~"
    CANCEL
    VALUE ""
    TAG ""
    TO nul
ENDDIALOG
Return True

Endproc
;===========================================================================
Proc Lineit()   

Clear
Paintcanvas Border Attribute 48 All    ;----clear the screen & create border
Paintcanvas Border Attribute 0 0, 0, si["SCREENHEIGHT"] - 1, si["SCREENWIDTH"] - 1
Style Attribute 11
@0,Int((si["SCREENWIDTH"] - 31) / 2) ?? "LineIt!  -  by Daniel J. Latner"
Style Attribute 14
@ si["SCREENHEIGHT"] - 1, 3 ?? "SCORE: 0"
Paintcanvas Attribute 0 10,3,10,5
@br, bc ?? b     ;----display first bonus point @ random location on screen

While True
  mc = mc + .5           ;-----play one note of song (every other char)
  If Int(mc) = mc Then
    Sound Numval(Substr(n, mc * 5 - 4, 5)) sp
    If mc = mn Then      ;-----when you get to end of song, loop
      mc = 0
    Endif
  Else
    For x from 1 to sp endfor  ;---if no note, put in delay, sleep 1 too slow
  Endif

  If Charwaiting() Then   ;---if user presses a key, otherwise continue in
    d = Getchar()         ;   the same direction as before
  Endif

  i = i + 1         ;----increment counter
  If i > rl Then    ;----time to increase length of line by 1 char
    i = 1           ;----reset to 1, start count again
    sc = sc + 5     ;----5 points every time line increases
    @ si["SCREENHEIGHT"] - 1, 10 ?? sc   ;----update score on screen
  Else           ;------move entire line by 1 character, keep same length
                 ;      by blanking last tail character
     tmp = Numval(Substr(cs, 1, 5))       ;---determine position of tail
     tmp1 = Int(tmp / si["SCREENWIDTH"])  ;---row
     tmp2 = Mod(tmp, si["SCREENWIDTH"])   ;---col
     Paintcanvas Attribute 51 tmp1, tmp2, tmp1, tmp2   ;---blank last char
     cs = Substr(cs, 7, Len(cs) - 6) ;---remove 1st 6 chrs of cs (tail string)
  Endif

  bi = bi + 1        ;----bonus incrementer
  If bi > bb Then    ;----time to move bonus char
    br = Round(Rand() * (si["SCREENHEIGHT"] - 3), 0) + 1 ;rand pos row
    bc = Round(Rand() * (si["SCREENWIDTH"] - 3), 0) + 1  ;rand pos col
    tmp = Strval(br * si["SCREENWIDTH"] + bc)
    tmp = Fill("0", 5 - Len(tmp)) + tmp + ","
    If Search(tmp, cs) = 0 Then     ;---bonus point is clear of line
      If brr > 0 Then               ;---blank bonus point if still there
        Paintcanvas Attribute 51 brr, bcc, brr, bcc
      Endif
      brr = br         ;----hold last position for clear character
      bcc = bc
      b = Round(Rand() * 8, 0) + 1  ;---random # between 1-9
      @br, bc ?? b                  ;---draw new bonus character on screen
      bi = 1                        ;---reset incrementer
    Endif
  Endif

  Switch
  Case d = -77: ;right
    c = c + 1
  Case d = -75: ;left
    c = c - 1
  Case d = -72: ;up
    r = r - 1
  Case d = -80: ;down
    r = r + 1
  Case d = 32 or d = 27:    ;space or esc
    Return
  Endswitch

  Paintcanvas Attribute 0 r,c,r,c    ;----draw new character

  ;------------------check here for overlap of line or crash into borders
  If r = 0 or r = si["SCREENHEIGHT"] - 1 or c = 0 or c = si["SCREENWIDTH"] - 1 Then
    Youlose()
    Return
  Endif

  ;------create unique number for current location, and look for it in cs
  tmp = Strval(r * si["SCREENWIDTH"] + c)
  tmp = Fill("0", 5 - Len(tmp)) + tmp + ","
  If Search(tmp, cs) > 0 Then   ;----you've overlapped part of the line
    Youlose()
    Return
  Endif
  cs = cs + tmp                 ;----add new position to line tracking string

  ;----------------------------------------------check here for bonus points
  If r = br and c = bc Then   ;------got bonus, add to score
    Sound sf 10               ;------bonus beep
    sc = sc + (b * 10)        ;------increase score by bonus * 10
    @ si["SCREENHEIGHT"] - 1, 10 ?? sc   ;-----display new score
    brr = 0                   ;------indicate that bonus point was taken
  Endif

Endwhile

Endproc
;===========================================================================
Proc Picksong()   ;-------let user select song (only one right now)

If mu = 2 Then    ;-------user selected no music
  mn = 0
  mc = .1
  n = ""
Else              ;-------user selected music
  mc = 0
  mn = 595        ;-------number of notes in song, boogie
  n = "5000000164001640016400164001640016400164001100011000130001460015400164" +
  "0015400164001100011000130001460015400164001540016400110001100013000146" +
  "0015400164001540016400164001460013000110500000008200097001030011000110" +
  "0013000146001540016400154001640011000110001300014600154001640015400164" +
  "0011000110001300014600154001640015400164001640014600130001105000000110" +
  "0013000138001460014600174001940020600220002060022000146001460017400194" +
  "0020600220002060022000146001460017400194002060022000206002200022000194" +
  "0017400146500000016400146001300011000110001300014600154001640015400164" +
  "0011000110001300014600154001640015400164001100011000130001460015400164" +
  "0015400164001640014600130001105000000164001640016400164001640014600130" +
  "0014600164500005000000146001460013000110001300014650000500000011000110" +
  "0013800138001460014600154001540016400164001840018400194001940020600206" +
  "0022050000500000022050000001640019400206002205000050000002205000000164" +
  "0019400206002205000050000002205000000164001940020600220500005000000220" +
  "5000000220002600027600292500005000000292500000022000260002760029250000" +
  "5000000292500000032800292002600022050000500000022050000001640019400206" +
  "0022050000500000022050000001940022000194001640016400146001645000000164" +
  "0016400154001460014600130001465000000130001460013000110001100009700110" +
  "5000000097001100009700082000820008200082000820008200097001030011000110" +
  "0011000097000820008200097001030011000110001100009700082000820009700103" +
  "0011000110001100009700082000820009700103001105000050000500005000000110" +
  "0013000138001460014600146001300011000110001300013800146001460014600130" +
  "0011000082000970010300110001100011000097000820008200097001030011000110" +
  "0011000097000820012300146001540016400164001640014600123001230016400154" +
  "0014600146001460013000110001100014600130001100011000110000970008200082" +
  "0011000097000825000050000500005000000082000970010300110500000011000110" +
  "0011000082000970010300110000820013000110500000008200097001030011050000" +
  "0011000110001100008200097001030016400146001300011050000001100013000138" +
  "0014650000001460014600146001100013000138001460014600146001740022000206" +
  "0019400146001740014600130001100013000110001740014650000500005000050000" +
  "0016400164001640016400164001460013000146001100013000146001540014600130" +
  "0011000146001300009700110500005000050000500005000050000001640016400154" +
  "0015400146001460015400154001640016400154001540014600146001540015400110" +
  "5000050000001105000050000500005000000220002200020600206001940019400206" +
  "0020600220002200020600206001940019400206002060014650000500000014650000" +
  "5000050000500000013000130001100013000164001460013000110001940016400146" +
  "0013000154001460013000110500005000050000001105000000110500000011050000" +
  "0011050000001100011000103001105000000103001100011000116500000011650000" +
  "0011650000001165000000116001160012300116500000009200116001380014650000" +
  "0014650000001465000000146500000014600146001640014650000000920014600138" +
  "0012350000001235000000123500000012350000000820008200082000825000000082" +
  "0008200087000920008700092500005000000092000870009250000500005000000082" +
  "00082500000008250000000825000000082" ;---every 5 chrs is a note frequency
Endif

Endproc
;===========================================================================
Proc Youlose()   ;------losing screen 
Private x

Beep
While True
  Message "YOU LOSE !!! - Press <Esc> to exit, or <Space> to replay"
  x = Getchar()
  Switch
  Case x = 27:
    Quit
  Case x = 32:
    Return
  Endswitch
Endwhile

Endproc
;===========================================================================

;-------------------all the procs are in memory, start game
Lsettings()

