;LINE/BOX DRAWING SCRIPT
;
;This script is meant for report+form design.  You should use a line like
;SETKEY -48 PLAY "c:\\paradox2\\data\\LINE" in your init.sc.  -48 is Alt-B.
;This line will let you call up the script from within the report generator.
;The commands are simple:
;  <SPACE BAR>- toggles drawing characters
;               to delete, toggle to the blank characters
;  <Q>- quits back to paradox
;  <ARROW KEYS>- draws lines/corners
;
;The rules:
;  This script will only draw on the screen that was visible when the
;     script was called. (You cannot move around a report within the script)
;  The script turns insert off so any space that you need has to already
;     be in the report/form
;  The script will allow you to cross group lines/table line etc, but your
;     results will be wrong because the cursor on the screen will be
;     forced out of sync with the cursor on the report.  So, don't cross
;     any lines, except those that you have put in.
;
;
;Author: George Kappel
;Date: 11/03/89
;CIS ID: 76630,1016
;
;I find this script extremely useful for making fancy reports and
;hope that it might be useful to others.
;Any comments or suggestions are welcome
;
;P.S. putting this into a procedure library will speed it up greatly.


PROC LUP(X)
   ?? X
   TYPEIN(X)
   @ ROW()-1,COL()-1
   Up
   Left
ENDPROC

PROC LDOWN(X)
  ?? X
  @ ROW()+1,COL()-1
  TYPEIN(X)
  Down
  Left
ENDPROC

PROC LRIGHT(X)
  temp = col();
  ?? X
  TYPEIN(X)
ENDPROC

PROC LLEFT(X)
  ?? X
  @ ROW(),COL()-2
  TYPEIN(X)
  Left
  Left
ENDPROC


;LINE CHARACTER DEFINITIONS
PROC INITC()
;HORIZONTAL CHARACTER
  HC[1] = ""
  HC[2] = ""
  HC[3] = "-"
  HC[4] = ""
  HC[5] = ""
  HC[6] = " "
;VERTICAL CHARACTER
  VC[1] = ""
  VC[2] = ""
  VC[3] = "|"
  VC[4] = ""
  VC[5] = ""
  VC[6] = " "
;CORNER CHARACTERS
  C1[1] = ""
  C2[1] = ""
  C3[1] = ""
  C4[1] = ""
  C1[2] = ""
  C2[2] = ""
  C3[2] = ""
  C4[2] = ""
  C1[3] = "*"
  C2[3] = "*"
  C3[3] = "*"
  C4[3] = "*"
  C1[4] = ""
  C2[4] = ""
  C3[4] = ""
  C4[4] = ""
  C1[5] = ""
  C2[5] = ""
  C3[5] = ""
  C4[5] = ""
  C1[6] = " "
  C2[6] = " "
  C3[6] = " "
  C4[6] = " "
ENDPROC


; DRAWING CHARACTER ARRAYS
ARRAY HC[6]
ARRAY VC[6]
ARRAY C1[6]
ARRAY C2[6]
ARRAY C3[6]
ARRAY C4[6]

;NUMBER OF CHARACTER SETS
dcnum = 6

INITC()
L = 1  ;INITIAL CHARACTRE SET
SYNCCURSOR
MESSAGE "PRESS Q TO QUIT"
IF ISINSERTMODE() THEN INS
ENDIF
LAST = "UNDEFINED"
WHILE TRUE
C = GETCHAR()
SWITCH
  CASE C = -72 :             ;UP
    IF ROW() > 3 THEN
    SWITCH
      CASE LAST = "UP" : LUP(VC[L])
      CASE LAST = "DOWN" : LUP(VC[L])
      CASE LAST = "RIGHT" : LUP(C2[L])
      CASE LAST = "LEFT" : LUP(C3[L])
      OTHERWISE : LUP(VC[L])
    ENDSWITCH
    LAST = "UP"
    ENDIF
  CASE C = -80 :             ;DOWN
    IF ROW() < 23 THEN
    SWITCH
      CASE LAST = "UP" : LDOWN(VC[L])
      CASE LAST = "DOWN" : LDOWN(VC[L])
      CASE LAST = "RIGHT" : LDOWN(C1[L])
      CASE LAST = "LEFT" : LDOWN(C4[L])
      OTHERWISE : LDOWN(VC[L])
    ENDSWITCH
    LAST = "DOWN"
    ENDIF
  CASE C = -77 :             ;RIGHT
    IF COL() < 78 THEN
    SWITCH
      CASE LAST = "UP" : LRIGHT(C4[L])
      CASE LAST = "DOWN" : LRIGHT(C3[L])
      CASE LAST = "RIGHT" : LRIGHT(HC[L])
      CASE LAST = "LEFT" : LRIGHT(HC[L])
      OTHERWISE : LRIGHT(HC[L])
    ENDSWITCH
    LAST = "RIGHT"
    ENDIF
  CASE C = -75 :             ;LEFT
    IF COL() > 0 THEN
    SWITCH
      CASE LAST = "UP" : LLEFT(C1[L])
      CASE LAST = "DOWN" : LLEFT(C2[L])
      CASE LAST = "RIGHT" : LLEFT(HC[L])
      CASE LAST = "LEFT" : LLEFT(HC[L])
      OTHERWISE : LLEFT(HC[L])
    ENDSWITCH
    LAST = "LEFT"
    ENDIF
  CASE C = asc(" ") :        ;TOGGLE CHARACTER SET
    IF L < DCNUM THEN
      L = L + 1
    ELSE L = 1
    ENDIF
    MESSAGE "LINE CHARACTERS = "+HC[L]+" "+VC[L]+" "+C1[L]
  CASE C = asc("Q") or C = asc("q") :             ;QUIT
    QUIT
ENDSWITCH
ENDWHILE
