;=====================================================================
; lib_menu.sc is the main menu for working with LIBraries and
; PROCedures.  It uses the library "Library.LIB".
;---------------------------------------------------------------------
;                   *** When using this program ***
;
; Writing PROCedures to a LIBrary does NOT require the usual CREATELIB
; or WRITELIB statements in the script. (In fact, these statements may
; cause an error.)
;
; When adding PROCedures to a LIBrary you must have enough memory
; available to run/load all the PROCedures in the script.  This
; should not be a problem as most Paradox programmers usually have
; two or more Megabytes of extended memory.
;
; You will need to know the names of all PROCedures you want to add to
; a LIBrary because each PROCedure name must be typed in separately. 
; You should have a hard copy of the PROCedure names before starting.
;
; This program only works in the current directory.  It does not accept
; pathnames. 
;=====================================================================

RELEASE PROCS ALL
RELEASE VARS ALL

Errorproc="liberror"
AUTOLIB="library"
READLIB "library" liberror

WHILE (True)
  ClearAll
  CLEAR
  RESET
  Open.p()
  Message24(" Current directory is "+DIRECTORY()+" ") ;Keep track of directory.
  CANVAS ON
  SHOWMENU
    "Add" :"Add PROCedures to a LIBrary",
    "Copy" :"Copy PROCedures from one LIBrary to another",
    "Create" :"Create a new LIBrary",
    "LIBraries" :"List the LIBraries in this directory",
    "PROCedures" :"List the PROCedures in a LIBrary",
    "Restructure" :"Restructure a LIBrary",
    "Rename" :"Rename a LIBrary",
    "Scripts" :"View the scripts in this directory",
    "Quit" :"Quit the LIBrary program"
  TO choice
  SWITCH
    CASE choice="Add": libadd("","")
    CASE choice="Copy": libcopy()
    CASE choice="Create": libmake()
    CASE choice="LIBraries": libshow()
    CASE choice="PROCedures": liblist()
    CASE choice="Restructure": librestr()
    CASE choice="Rename": libren()
    CASE choice="Scripts": scriptview()
    CASE choice="Quit": QUITLOOP
  ENDSWITCH
ENDWHILE

RELEASE PROCS ALL
RELEASE VARS ALL
QUIT
