; Licensed software Copyright (C) 1993 Financial Modeling Specialists, Inc.
; Sample dialog box query routine.
; Dialog.sc
; 02/03/93-LC

if not isassigned(Libname.a) then Libname.a = "adhoc" endif

; OVERVIEW
; Example of using a dialog box for filter input.

; PROCESS
; Display dialog box.  When completed, process results.

; PROCEDURE       DESCRIPTION               CREATED     MODIFIED    CALLED BY
; QueryEngine42.u Query engine in 4         02/03/93-LC
; DialogFilter2.l Dialog filter routine     02/03/93-LC             *QueryEngine4.u
; DialogCtrl2.l   Dialog box control proc   02/03/93-LC             *DialogFilter.l

; MODIFICATIONS

; Main procedure to enter selections and perform query.
; INPUT: Filter.t       Table with filter criteria (may already contain data).
;        Enter.l        TRUE if user enters filters, FALSE if passing pre-selected data.
; Called by QueryDemo.u, LateInvoices.u.
proc QueryEngine42.u(Filter.t)
  private TempInv.t, TempCust.t, InvTemp.t, CustTemp.t, Combine.t,
          Output.t, ok.l
  DlgMsg.u_FMS("Loading query engine", "", FALSE)
  clearall
  SetVars.u()
  while TRUE
    ok.l = DialogFilter2.l(Filter.t)            ; Get user input.
    if ok.l then                                  ; Begin retrieving data.
      view Filter.t
        if [Invoice] = ""
          then Group.a = "Invoices"
          else Group.a = "Customers"
        endif
      clearimage
      QueryData.l(Filter.t)                       ; Run queries to extract data.
      if retval then                              ; ...returns FALSE if no data found.
        CreateOutput.u(Group.a, Combine.t)        ; Create output table.
        switch                                    ;View results.
          case Group.a = "Invoices"  : ViewOutput4.u(Group.a, Output.t, "1", "F", "1")
          case Group.a = "Customers" : ViewOutput4.u(Group.a, Output.t, "1", "", "1")
        endswitch
      else
        ShowMsg.u("No data found")
        sleep 1000
      endif
    else
      quitloop
    endif
  endwhile
  DlgMsg.u_FMS("Leaving query engine", "", FALSE)
  setdir directory()                            ;Delete temporary tables.
  window select Msg.w
  window close
endproc
writelib libname.a QueryEngine42.u
release procs      QueryEngine42.u

; Filter input in a dialog box.
; INPUT: Filter.t       Input table with previous filter selections.
;                       User selections are placed here.
; Called by QueryEngine4.u
proc DialogFilter2.l(Filter.t)
  private Salesman.t, recs.n, Salesman.r, x,
          Group.n, Salesman.a, Salesman.n, ShipLow.d, ShipHigh.d,
          BalanceLow.n, BalanceHigh.n, State.a, ok.l
  Salesman.t = "Salesman"                              ; Lookup table.
  recs.n = nrecords(Salesman.t) + 1
  array Salesman.r[recs.n]
  view Salesman.t
    Salesman.r[1] = "NONE"
    x = 2
    scan
      Salesman.r[x] = [Salesman ID]
      x = x + 1
    endscan
  clearimage

  ; Set initial values of dialog box.
  view Filter.t
    if [Invoice] = ""
      then Group.n = 1
      else Group.n = 2
    endif
    Salesman.a    = [Salesman]
    Salesman.n = 1
    if Salesman.a <> "" then
      for x from 1 to recs.n                       ; Determine current selection.
        if Salesman.a = Salesman.r[x] then
          Salesman.n = x
          quitloop
        endif
      endfor
    endif
    ShipLow.d     = [ShipDateLow]
    ShipHigh.d    = [ShipDateHigh]
    BalanceLow.n  = [BalanceLow]
    BalanceHigh.n = [BalanceHigh]
    State.a       = [State]
  clearimage

  showpulldown endmenu                 ; Remove menus
  DlgMsg.u_FMS("", "", FALSE)          ; Remove message box
  setcanvas default

  SHOWDIALOG "Enter Filter Options"
     PROC "DialogCtrl2.l"
     @2,2 HEIGHT 21 WIDTH 77

     FRAME SINGLE FROM 0,27 TO 12,72
     PAINTCANVAS ATTRIBUTE 127 0,27,0,72
     PAINTCANVAS ATTRIBUTE 112 12,27,12,72
     PAINTCANVAS ATTRIBUTE 127 0,27,12,27
     PAINTCANVAS ATTRIBUTE 112 0,72,12,72

     FRAME SINGLE FROM 13,2 TO 17,22
     PAINTCANVAS ATTRIBUTE 127 13,2,13,22
     PAINTCANVAS ATTRIBUTE 112 17,2,17,22
     PAINTCANVAS ATTRIBUTE 127 13,2,17,2
     PAINTCANVAS ATTRIBUTE 112 13,22,17,22

     FRAME DOUBLE FROM 0,2 TO 4,21
     PAINTCANVAS ATTRIBUTE 112 0,2,0,21
     PAINTCANVAS ATTRIBUTE 127 4,2,4,21
     PAINTCANVAS ATTRIBUTE 112 0,2,4,2
     PAINTCANVAS ATTRIBUTE 127 0,21,4,21

     @1,42  ?? "Invoice Fields"
     @3,30  ?? "Salesman"
     @8,30  ?? "Ship Date"
     @8,40  ?? ">="
     @8,56  ?? "<="
     @10,30 ?? "Balance"
     @10,40 ?? ">"
     @10,56 ?? "<="
     @14,5  ?? "Customer Fields"
     @16,8  ?? "State"

     PAINTCANVAS FILL " " ATTRIBUTE 112 1,7,1,17
     @1,7   ?? "Data Group"
     PAINTCANVAS ATTRIBUTE 112 1,7,1,17

     RADIOBUTTONS @2,5 HEIGHT 2 WIDTH 14
       "Invoice",
       "Customer"
       TAG "Group"
     TO Group.n

     PICKARRAY @3,40 HEIGHT 4 WIDTH 9
       Salesman.r
       TAG "Salesman"
     TO Salesman.n

     ACCEPT @8,43 WIDTH 11 "D"
       TAG "ShipDateLow"
     TO ShipLow.d

     ACCEPT @8,59 WIDTH 11 "D"
       TAG "ShipDateHigh"
     TO ShipHigh.d

     ACCEPT @10,43 WIDTH 9 "N"
       TAG "BalanceLow"
      TO BalanceLow.n

     ACCEPT @10,59 WIDTH 9 "N"
       TAG "BalanceHigh"
     TO BalanceHigh.n

     ACCEPT @16,14 WIDTH 5 "A2"
       PICTURE "!!"
       TAG "State"
     TO State.a

     PUSHBUTTON @15,40 WIDTH 10 "~O~k"
       OK
       DEFAULT
       VALUE "Ok"
       TAG "Ok"
     TO Tag.a

     PUSHBUTTON @15,55 WIDTH 10
       "~C~ancel"
       CANCEL
       VALUE "Cancel"
       TAG "Cancel"
     TO Tag.a
  ENDDIALOG

  ok.l = retval
  if ok.l then             ; Store results in Filter table.
    DlgMsg.u_FMS("Retrieving data", "", FALSE)
    coedit Filter.t
      if Group.n = 1 then
        [Invoice]  = ""
        [Customer] = ""
      else
        [Invoice]  = ""
        [Customer] = ""
      endif
      if Salesman.n = 1
        then [Salesman] = ""
        else [Salesman] = Salesman.r[Salesman.n]
      endif
      [ShipDateLow]  = ShipLow.d
      [ShipDateHigh] = ShipHigh.d
      [BalanceLow]   = BalanceLow.n
      [BalanceHigh]  = BalanceHigh.n
      [State]        = State.a
    do_it! clearimage
  endif
  return ok.l
endproc
writelib Libname.a DialogFilter2.l
release procs  DialogFilter2.l

; Dialog box control procedure.
; INPUT: standard dialog proc parameters.
; Returns TRUE if finished.
; Called by DialogFilter.l
proc DialogCtrl2.l(Trigger.a, Tag.a, Event.r, Element.a)
  private key.v, item.r, x, recs.n, x, M
  switch
    case Trigger.a = "EVENT" and Event.r["Type"] = "KEY" :
      key.v = KeyCode.v(Event.r["Keycode"])
      if key.v = "F1" and Tag.a = "Salesman" then
        recs.n = nrecords(Salesman.t)
        array item.r[recs.n]
        array desc.r[recs.n]
        view Salesman.t
          x = 1
          scan
            item.r[x] = [Salesman ID]
            desc.r[x] = [Name]
            x = x + 1
          endscan
        clearimage
        showarray
          item.r desc.r
        to M
        if M <> "Esc" then
          Salesman.a = M
        endif
        REFRESHCONTROL "Salesman"
     endif
  endswitch
endproc
writelib Libname.a DialogCtrl2.l
release procs      DialogCtrl2.l
