; Licensed software Copyright (C) 1992-93 Financial Modeling Specialists, Inc.
;
; You are welcome to use the procedures in this script provided you include
; our copyright notice at the top of your script.
;
; 04/10/92-Created by Ned Levy
; 04/12/92-Modified by Luke Chung

? "09/21/93-LC Compiling Demo2.sc"
if not isassigned(Libname.a) then Libname.a = "adhoc" endif


; 1993 Paradox Conference in Washington, DC.
;
; Presentation: Developing Ad Hoc Query Modules in Paradox DOS Applications
;
;           by: Luke Chung
;               President
;               Financial Modeling Specialists, Inc.
;               8027 Leesburg Pike, Suite 410
;               Vienna, Virginia 22182
;               USA
;               703-356-4700, fax 703-448-3861
;               Compuserve: 73710,463

; OVERVIEW
; This script demonstrate different methods user input of data grouping
; for the ad hoc query system described in the paper.  Three methods are:
;       1.  Multi-record table list of choices.
;       2.  Form with checkboxes.
;       3.  Showmenu with choices.
; The ShowMenuQuery.u procedure produces an overdue invoice list by using the
; showmenu method and then prompting for "Number of days late" to be entered
; by a simple "Accept" command.
; The accompanying script (QUERY) shows a more sophisticated query engine.

; PROCEDURE        DESCRIPTION               CREATED     MODIFIED    CALLED BY
; Demo.u           Select demo to run        04/10/92-NL 04/23/92-LC this script
;;CheckKeys.u      Key tables                04/22/92-LC             Demo.u
; GetGroupTable.a  Demo of table selection   04/10/92-NL             Demo.u
; SelectGroup.a    Demo of group selection   04/10/92-NL             Demo.u
; ShowMenuSelect.a Demo of showmenu select   04/10/92-NL             Demo.u
; ShowMenuQuery.u  Demo of showmenu w/query  04/10/92-NL 04/13/92-LC Demo.u
;;HelpText.u       Help screen               04/13/92-LC 04/13/92-LC Demo.u, ShowMenuSelect.a

; Select and run ad hoc query examples.
; Called by this script.
proc Demo.u()
  private choice.a, group.a
  choice.a = "Table"
  CheckKeys.u("Customer", 1)           ; Make sure tables are keyed.
  CheckKeys.u("Invoice", 2)
  while TRUE
    group.a = ""
    HelpText.u("Main")
    showmenu
      "Table"  : "Select a group from a multi-record form.",
      "Check"  : "Select a group by checking the selection.",
      "Menu"   : "Select a group from a showmenu of choices.",
      "Query"  : "Select by showmenu and get list of late invoices",
      "Exit"   : "Exit Demo"
      default choice.a
    to choice.a
    switch
      case choice.a = "Table"  : group.a = GetGroupTable.a()
      case choice.a = "Check"  : group.a = SelectGroup.a()
      case choice.a = "Menu"   : group.a = ShowMenuSelect.a()
      case choice.a = "Query"  : ShowMenuQuery.u()
      case choice.a = "Exit"   : quitloop
      case choice.a = "Esc"    : quitloop
    endswitch
    if choice.a <> "Query" then
      if group.a = ""
        then message "No group selected..." sleep 1500
        else message group.a," selected..." sleep 1500
      endif
    endif
  endwhile
  message "End of demonstration..." sleep 1500
endproc
writelib libname.a Demo.u
release procs      Demo.u

; Check key fields.
; This application does not index the tables until you run it the first time.
; This allows it to use your sort order.
; INPUT: Table.t        Table to place key fields.
;        KeyFld.n       Number of key fields.
; Called by CreateReport.u.
;proc CheckKeys.u(Table.t, KeyFld.n)
;  private proc.a, x
;  proc.a = "CheckKeys.u"
;  if nkeyfields(Table.t) = 0 then
;    ? "Keying "+Table.t+" table to your sort order"
;    Menu {Modify} {Restructure}
;      select Table.t
;      right right
;      for x from 1 to KeyFld.n
;        "*"  down                           ; Add "*" to end of field type.
;      endfor
;    do_it!  clearall
;  endif
;endproc
;writelib libname.a CheckKeys.u
;release procs      CheckKeys.u

; Display a table for user to select from.
; Returns Group selected if [F2] pressed, blank if [Esc] pressed.
; Called by Demo.u.
proc GetGroupTable.a()
  private group.a                     ;Group to be selected.
  group.a = ""                        ;Default: no selection.
  view "Groups"                       ;Get table with groups to select.
    pickform "F"                      ;View in multi-record form.
    wait table                        ;Wait table until selection made.
      prompt "Move to group desired and press [F2] to select, [Esc] to cancel.",""
    until "F2", "Esc"
    if retval = "F2" then
      group.a = [Group]               ;Get group in current record.
    endif
  clearimage
  return group.a
endproc
writelib libname.a GetGroupTable.a
release procs      GetGroupTable.a

; Display a form for user to select form with the [F6] key.
; Returns Group selected if [F2] pressed, blank if [Esc] pressed.
; Called by Demo.u.
proc SelectGroup.a()
  private key.v, group.a                    ;Key pressed, group selected.
  group.a = ""                              ;Default: no selection.
  edit "Filter"                             ;Table with group options.
  pickform "F"                              ;Use single record form.
  while TRUE
    wait record                       ;Wait on record until selection.
      prompt "Move to group desired and press [F6] to select.",
             "Press [F2] to finish, [Esc] to cancel."
    until "F2", "Esc", "F6", "", "Backspace", "CtrlBackspace"
    key.v = retval
    switch
      case key.v = "F6" or key.v = "" :    ;Alt 251 is the check key.
        [Customer] = ""                     ;Remove all checks.
        [Invoice]  = ""
        []         = ""                    ;Place check in current field.
      case key.v = "F2" :
        switch                              ;Determine group selected.
          case [Customer] = "" : group.a = "Customers" quitloop
          case [Invoice]  = "" : group.a = "Invoices"  quitloop
          otherwise             : beep
                                  message "Select group or cancel..."
                                  sleep 1000
        endswitch
      case key.v = "Esc" : canceledit quitloop
      otherwise : beep                      ;Prevent deleting checks.
    endswitch
  endwhile
  do_it! clearimage
  return group.a
endproc
writelib libname.a SelectGroup.a
release procs      SelectGroup.a

; Demonstrate technique to select group by using a showmenu.
; Returns Group selected, blank if "Quit" or [Esc] selected.
; Called by Demo.u.
proc ShowMenuSelect.a()
  private choice.a                          ;Selection made.
  HelpText.u("Group")
  showmenu
    "Invoices"  : "Retrieve invoices with outstanding balances.",
    "Customers" : "Retrieve customers with outstanding balances.",
    "Quit"      : "Cancel selection."
  to choice.a
  if choice.a = "Quit" or choice.a = "Esc"
    then return ""
    else return choice.a
  endif
endproc
writelib libname.a ShowMenuSelect.a
release procs      ShowMenuSelect.a

; Asks user to select a report, enter a filter value, create and show results.
; Called by Demo.u.
proc ShowMenuQuery.u()
  private M, days.n
  clear
  showmenu
    "Late Invoices" : "Retrieve invoices with outstanding balances.",
    "Quit"          : "Cancel selection."
  to M
  if M = "Late Invoices" then
    clear                                   ;Clear screen
    @10,10??"Enter days late: "             ;Prompt user for number of day late.
    cursor normal
      accept "S" to days.n                  ;Get user entry.
    cursor off
    if retval then                          ;If [Esc] not pressed then run
      Query                                 ; query saved with {Querysave}.

        Invoice  | Invoice No |        Ship Date        |  Balance |
                 | Check      | Check <=today - ~days.n | Check >0 |

      Endquery
      do_it! clearall                       ;Execute query.
      if not isempty("Answer") then         ;If data found then view results.
        view "Answer"
        wait table
          prompt "List of invoices more than "+strval(days.n)+" days late",
                 "Press [Esc] to return."
        until "Esc"
        clearimage
      endif
    endif
  endif
endproc
writelib libname.a ShowMenuQuery.u
release procs      ShowMenuQuery.u

; Help screen for menus.
; INPUT: Menu.a         Determines which screen to display.
; Called by Demo.u, ShowMenuSelect.a.
;proc HelpText.u(Menu.a)
;  canvas off
;  clear
;  @5,0
;  switch
;    case Menu.a = "Main" :
;      text
;                 AD HOC QUERY TECHNIQUES IN PARADOX APPLICATIONS
;
;      Simple ad hoc query features for getting information from users.
;      Includes procedures described in the paper.
;
;       TABLE      Selection from a multi-record form.
;                   Move to choice and press [F2] to select grouping.
;
;       CHECK      Selection by using checks in a single record form.
;
;       MENU       Select a group from a showmenu of choices with a
;                   screen explaining the options.
;
;       QUERY      A simple ad hoc query system with user selection of
;                   what to view and filter criteria.
;
;       EXIT       Exit to Paradox.
;      endtext
;    case Menu.a = "Group" :
;      text
;                           SELECT GROUPING FOR QUERY
;
;
;
;       Invoices        Retrieve invoices with outstanding balances.
;
;       Customers       Retrieve customers with outstanding balances.
;
;       Quit            Cancel selection.
;      endtext
;  endswitch
;  if monitor() = "Color" then
;    paintcanvas attribute 31 0,0,24,79      ; Color the entire screen.
;  endif
;  canvas on
;endproc
;writelib libname.a HelpText.u
;release procs      HelpText.u

;Demo.u()
