; Licensed software Copyright (C) 1992-93 Financial Modeling Specialists, Inc.
;
; You are welcome to use the procedures in this script provided you include
; our copyright notice at the top of your script.
;
; 09/21/93-Created by Luke Chung
;
; 1993 Paradox Conference in Washington, DC.
;
; Presentation: Developing Ad Hoc Query Modules in Paradox DOS Applications
;
;           by: Luke Chung
;               President
;               FMS, Inc.
;               8027 Leesburg Pike, Suite 410
;               Vienna, Virginia 22182
;               703-356-4700, Fax 703-448-3861
;               Compuserve: 73710,463

; OVERVIEW
; This presentation presents a technique to develop powerful ad hoc query
; modules within a Paradox DOS application which is both easy to use,
; easy to develop and easy to maintain.

; See the conference paper for more details.

; PROCEDURE      DESCRIPTION               CREATED     MODIFIED    CALLED BY
; DemoMenu.u     Main presentation menu    09/21/93-LC
; Overview       Presentation overview     09/21/93-LC             *DemoMenu.u
; ViewTable.u    View a table/form         09/21/93-LC             *DemoMenu.u
; ViewScript.u   View a script             04/30/92-LC             *DemoMenu.u

proc DemoMenu.u()
  private Filter.t, Invoice.t, Customer.t, Orders.t,
          autolib, Tag.a
  autolib = sdir() + "adhoc"
  Filter.t    = "Filter"     ; User input of group and filter options.
  Invoice.t   = "Invoice"    ; Main invoice table  (contains data).
  Customer.t  = "Customer"   ; Main customer table (contains data).
  Orders.t    = "Orders"     ; Main orders table (contains data).
  Tag.a     = "Overview"
  while TRUE
    echo normal
    echo off
    showpulldown
      "" : "" : "",
      "Overview"  : "Presentation overview" : "Overview",
      "View Data" : "View the data for this presentation" : "View"
        SUBMENU
          "Invoices"  : "View invoices"  : "Invoices",
          "Customers" : "View customers" : "Customers",
          "Orders"    : "View orders"    : "Orders"
        ENDSUBMENU,
      "Simple AdHoc"  : "Example of a simple Ad Hoc Query system"  : "Simple"
        SUBMENU
          "Play"   : "Play script"    : "SimplePlay",
          "Script" : "Display script" : "SimpleScript"
        ENDSUBMENU,
      "General AdHoc" : "Example of a general Ad Hoc Query system" : "General"
        SUBMENU
          "Run/View Script" : "Run or view the script" : "GenRun"
            SUBMENU
              "Play"   : "Play script"    : "GenPlay",
              "Script" : "Display script" : "GenScript"
            ENDSUBMENU,
          "Procedure Overview" : "View procedure flow diagram"  : "Flow",
          "Data ~G~rouping"    : "Data Grouping"                : "Group",
          "Filter Input"       : "Filter input"                 : "Filter",
          "Creating Queries in PAL" : "Creating queries in PAL" : "PALQueries",
          "General Query Module"    : "General Query module"    : "QModule",
          "Data Retrieval"          : "Data retrieval module"   : "Retrieval",
          "Viewing Results"         : "Viewing results"         : "ViewResults",
          separator,
          "Dialog Box Input~1~" : "Use a dialog box input"  : "Dialog1"
            SUBMENU
              "Play"   : "Play script"    : "Dlg1Play",
              "Script" : "Display script" : "Dlg1Script"
            ENDSUBMENU,
          "Dialog Box Input~2~" : "Use a dialog box input"  : "Dialog2"
            SUBMENU
              "Play"   : "Play script"    : "Dlg2Play",
              "Script" : "Display script" : "Dlg2Script"
            ENDSUBMENU
        ENDSUBMENU,
      "Non AdHoc" : "Example of a non ad hoc query"  : "NonAdHoc"
        SUBMENU
          "Play"   : "Play script"    : "NonPlay",
          "Script" : "Display script" : "NonScript"
        ENDSUBMENU,
      "Quit" : "Quit" : "Quit"
    endmenu
    getmenuselection default Tag.a to Tag.a
    clearpulldown
    switch
      case Tag.a = "Overview"     : Overview.u()

      case Tag.a = "Invoices"     : ViewTable.u(Invoice.t,  "F", "1", "Viewing invoice information")
      case Tag.a = "Customers"    : ViewTable.u(Customer.t, "F", "",  "Viewing customer records")
      case Tag.a = "Orders"       : ViewTable.u(Orders.t,   "2", "",  "Viewing order records")

      case Tag.a = "SimplePlay"   : ShowMenuQuery.u()
      case Tag.a = "SimpleScript" : ViewScript.u("Demo2", 185)

      case Tag.a = "GenPlay"      : QueryEngine.u(Filter.t, TRUE)
      case Tag.a = "GenScript"    : ViewScript.u("Query", 237)

      case Tag.a = "Flow"         : ViewTable.u("Diagram", "F", "",  "Viewing General Ad Hoc Query Procedure Flow Diagram")
      case Tag.a = "Group"        : ViewScript.u("Query", 316)
      case Tag.a = "Filter"       : ViewScript.u("Query", 354)
      case Tag.a = "PALQueries"   : ViewScript.u("Query", 828)
      case Tag.a = "QModule"      : ViewScript.u("Query", 291)
      case Tag.a = "Retrieval"    : ViewScript.u("Query", 546)
      case Tag.a = "ViewResults"  : ViewScript.u("Query", 642)

      case Tag.a = "Dlg1Play"     : QueryEngine4.u("Filter", TRUE)
      case Tag.a = "Dlg1Script"   : ViewScript.u("Dialog", 70)

      case Tag.a = "Dlg2Play"     : QueryEngine42.u("Filter")
      case Tag.a = "Dlg2Script"   : ViewScript.u("Dialog2", 65)

      case Tag.a = "NonPlay"      : LateInvoices.u()
      case Tag.a = "NonScript"    : ViewScript.u("Query", 215)

      case Tag.a = "Quit" or Tag.a = "Esc" : quitloop
    endswitch
  endwhile
endproc

proc Overview.u()
  private win.w, attrib.r, width.n, height.n, lastRow.n
  dynarray attrib.r[]
  attrib.r["HasFrame"] = FALSE
  width.n  = 75
  height.n = 20
  window create floating @2,2
    height height.n width width.n
    attributes attrib.r
  to win.w
  window select win.w
  @3,0
  text
                      Developing Ad Hoc Query Modules
                        in Paradox DOS Applications



                Understand the distinction between data
                 grouping and data filtering.

                Create powerful, yet easy to maintain query
                 engines within your applications.

                Leverage ad hoc query features throughout all
                 the reports in an application.
  endtext
  offset.n = 5
  paintcanvas attribute 31 2, offset.n, 5, width.n-offset.n
  lastRow.n = height.n - 1
  @lastRow.n,0 ?? format("w"+strval(width.n)+",ac", "presented by Luke Chung, President, FMS, Inc.")
  paintcanvas attribute 63 lastRow.n, 0, lastRow.n, width.n
  while TRUE
    if getchar() = 27 then quitloop endif      ; Wait for [Esc].
  endwhile
  window close
  setcanvas default
endproc

; View a table with option to switch between table and form views.
; INPUT: Table.t        Name of table.
;        Form1.a        Name of main form.
;        Form2.a        Name of switch form (may be blank).
;        Prompt.a       Prompt to show.
proc ViewTable.u(Table.t, Form1.a, Form2.a, Prompt.a)
  private key.v, win.w, winMax.r, setWindow.l
  dynarray winMax.r[]
  winMax.r["Maximized"] = TRUE
  setWindow.l = TRUE
  showpulldown endmenu
  view Table.t
    if form1.a <> "" then
      pickform Form1.a
    endif
    while TRUE
      if setWindow.l then
        window handle current to win.w
        winMax.r["HasFrame"] = not isformview()
        window setattributes win.w from winMax.r
        setWindow.l = FALSE
      endif
      wait table
        prompt prompt.a
      until "Esc", "F7", "F3", "F4"
      key.v = retval
      switch
        case key.v = "Esc"             : quitloop
        case key.v = "F7" and form2.a <> "" :
          if form() = form1.a
            then pickform form2.a
            else pickform form1.a
          endif
          setWindow.l = TRUE
        case key.v = "F3" or key.v = "F4" : keypress key.v
      endswitch
    endwhile
  clearall
  echo normal
  echo off
endproc

; View a script on a particular line via Playright.
; INPUT: Script.a       Script name.
;        Line.n         Line number.
; Called by DemoMenu.u
proc ViewScript.u(Script.a, Line.n)
  ShowMsg.u("Retrieving script")
  cursor normal
  run norefresh "pr "+ script.a + " " + strval(line.n)
  cursor off
endproc

DemoMenu.u()
