;------------------------------------------------------------------------------
; Finds Center position on Y Axis
;------------------------------------------------------------------------------

Proc Center_Y(Center_String)
   Return Int((80 - Len(Center_String)) / 2)
EndProc

;------------------------------------------------------------------------------
; Sums and Displays Current Field
;------------------------------------------------------------------------------

Proc Sum_Field()

Private Mx, Y_Pos

If SysMode() <> "Edit" then
  If (FieldType() = "$") or (FieldType() = "N") and Field() <> "#" then
     Y_Pos = Center_Y("Sum of " + Field() + " is " + StrVal(Csum(Table(),Field()))) - 2
     Box_Msg(10,Y_Pos,95,1,"Sum of " + Field() + " is " + StrVal(Csum(Table(),Field())),95)
     Mx = GetChar()
  Else
     Y_Pos = Center_Y("Field is Not Numeric in Nature...") - 2
     Box_Msg(10,Y_Pos,79,1,"Field is Not Numeric in Nature...",79)
     Mx = GetChar()
   Endif
Else
   Y_Pos = Center_Y("Must Be in View Mode to Use Sum Function...") - 2
   Box_Msg(10,Y_Pos,79,1,"Must Be in View Mode to Use Sum Function...",79)
   mx = getchar()
Endif

EndProc

;------------------------------------------------------------------------------
; Allows View to Be Changed During Session
;------------------------------------------------------------------------------

Proc Pick_Form(Table_Name)

  Private Mx, Y_Pos

  If Recno() <> 0 then
    Get_Form(Table_Name)
    If Retval <> "Esc" and RetVal <> "None" then
       Pickform RetVal
    Endif
  Else
    Y_Pos = Center_Y("Unable to Place in Form Mode...") - 2
    Box_Msg(10,Y_Pos,79,1,"Unable to Place in Form Mode...",79)
    mx = getchar()
  Endif

EndProc

;------------------------------------------------------------------------------
; Allows Report to be output during session
;------------------------------------------------------------------------------

Proc Pick_Report(Table_Name)

   Private Mx, Y_Pos

   If SysMode() <> "Edit" then
     Get_Report(Table_Name)
     If RetVal <> "Esc" and RetVal <> "None" then
         If PrinterStatus() then
           Report Table_Name Retval
         else
           Y_Pos = Center_Y("Printer is not Ready...")
           Box_Msg(10,Y_Pos,79,1,"Printer is not Ready...",79)
           Mx = GetChar()
         endif
     Endif
   Else
     Y_Pos = Center_Y("Must be in View Mode...")
     Box_Msg(10,Y_Pos,79,1,"Must be in View Mode...",79)
     Mx = GetChar()
   Endif

EndProc

;------------------------------------------------------------------------------
; General Paradox Table Routine
;------------------------------------------------------------------------------

Proc Use_Table(Table_Name)

Private Menu_Choice

Menu_Choice = 1

View Table_Name

while (true)

  wait table
    prompt "[F10] to Exit" , "[Alt-M] Option Menu"
  until -50, "F7", -33, "F2", "F6", "F9", -110, -31, "F10", -112, -24

  ;------------------------------------------------
  ; -50  is Alt-M  (Menu)                         ;
  ; F7             (FormKey)                      ;
  ; -33  is Alt-F  (Pick Form)                    ;
  ; F2             (View Mode)                    ;
  ; F6             (No Function)                  ;
  ; F9             (Edit Mode)                    ;
  ; -110 is Alt-F7 (Instant Report)               ;
  ; -31  is Alt-S  (Sum Field)                    ;
  ; F10            (Leave Table)                  ;
  ; -112           (No Function)                  ;
  ; -24            (No Function)                  ;
  ;------------------------------------------------

  If Retval = -50 then

      Make_Menu(3,0,",","View Mode    {F2},Edit Mode    {F9},Pick Form    {Alt-F},Report       {Alt-F7},Sum Field    {Alt-S}," +
                        "Leave Table  {F10}",31,1,79,Menu_Choice)

      ; Set Selected Item Number for Make_Menu Call

      If RetVal <> "Esc" then
         Menu_Choice = RetVal
      Endif

      ; Set Retval for Following Instructions

      switch

         Case Retval = 1  :  Retval = "F2"
         Case Retval = 2  :  Retval = "F9"
         Case Retval = 3  :  Retval = -33
         Case RetVal = 4  :  Retval = -110
         Case RetVal = 5  :  Retval = -31
         Case RetVal = 6  :  Retval = "F10"

      endswitch

  Endif

  switch

     case RetVal = "F2"  :   if SysMode() = "Edit" then
                                Do_It!
                             Endif

     case RetVal = "F9"  :   If SysMode() <> "Edit" then
                                EditKey
                             Endif

     case RetVal = -33   :   Pick_Form(Table_Name)

     case RetVal = -110  :   Pick_Report(Table_Name)

     case RetVal = "F7"  :   FormKey

     case RetVal = -31   :   Sum_Field()

     case Retval = "F10" :   Make_Menu(3,0,",","Exit Session,Resume Session",95,1,79,2)
                             If RetVal = 1 then
                                If SysMode() = "Edit" then
                                   Do_It!
                                Endif
                                ClearImage
                                Quitloop
                             Endif
  endswitch

endwhile

endproc

;-------------------------------------------------------------------------------
; Calling Instructions
;-------------------------------------------------------------------------------

; Check for Library File

If Not IsFile("Jtools.lib") and IsFile("Jtools.sc") then
   Play "Jtools"
Endif

AutoLib = "Jtools"
Use_Table("Checking")

