;*******************************************************************************
;       NAME: LOCK.SC
;       DATE: 06/01/92
;    VERSION: 1.0
;DESCRIPTION: Locking and posting procedures
;*******************************************************************************

;*******************************************************************************
;     Copyright Computer Resource Center 1994. All Rights Reserved.
;*******************************************************************************

;===============================================================================
;  LOCK.SC.  This file contains procedures for generic table lockling
;-------------------------------------------------------------------------------

;===============================================================================
PROC TableLock_l(tablelock_y,screen_l)
;
         PRIVATE; locklist_y,  ;= DYNARRAY of table names and lock types
;                                  ie. locklist_y["D/Customer"] = "FL"
;                                      locklist_y["D/Orders"]   = "WL"
;                                      locklist_y["V/Lookup"]   = "PWL"
;                                  Note that directories must use a "/" not "\"
;                                  character because of Paradox's treatment
;                                  of the "\" character.
;                 screen_l,    ;= TRUE  - Show progress screens
;                                 FALSE - Do not show progress screens
                  messwin_h,   ;= Message window handle
                  oldwin_h,    ;= Previous window
                  lockstring_a,;= String to process with lock type
                  lock_a,      ;= Lock type (FL,PFL,WL,PWL)
                  script_m,    ;= Lock script variable
                  a1,          ;= Tag name of DYNARRAY locklist_y
                  sysbag_y,    ;= System information
                  erroruser_a, ;= User who has locked the table
                  second_n,    ;= Retry interval in seconds
                  minute_n,    ;= Retry duration in minutes
                  success_l    ;= Was lock successful or not?
;    GLOBAL VARS; none
;    SYSTEM VARS; retval
;     PROCEDURES; TableLockDialog_l()
;                 Message_h()
;        RETURNS; TRUE  - If table lock is successful
;                 FALSE - If table lock is unsuccessful
;         AUTHOR; Joseph T. Saturnia, Jr.
;                 Computer Resource Center
;                 Copyright 1994, All Rights Reserved
;        CREATED; 06/01/92  v4.0
;    ATTRIBUTION; none
;    DESCRIPTION; Attempt to lock one or more tables and if already locked by,
;                 another user keep trying every user specified seconds for
;                 user specified minutes until success, cancel or timeout.
;  EXAMPLE USAGE; DYNARRAY locklist_y[]
;                    locklist_y["D/Customer"] = "FL"      ; Note use of "/" instead od "\"
;                    locklist_y["D/Orders"]   = "WL,PWL"  ; Combine locks on same table in string
;                    locklist_y["V/Items"]    = "PFL"     ;
;                    locklist_y["E/Users"]    = "PWL"
;                 retval = TableLock_l(locklist_y,TRUE)
;-------------------------------------------------------------------------------

IF screen_l                                                          ; If the user wants to see progress screens
   THEN oldwin_h  = GETWINDOW()
        messwin_h = Message_h("Attempting to place table lock")
ENDIF

script_m = "LOCK "                                                   ; Begin to build variable for ZZZZLOCK.SC script

FOREACH a1 IN locklist_y                                             ; Fill variable with table name and lock type
   lockstring_a = locklist_y[a1]                                     ; save lock string to a variable
   WHILE MATCH(lockstring_a,"..,..",lock_a,lockstring_a)             ; Parse out lock string ie. ("PFL,FL,PWL,WL")
      script_m = script_m + "\"" + a1 + "\" " + lock_a + ",\010"     ; Save lock to a variable
   ENDWHILE
   script_m = script_m + "\"" + a1 + "\" " + lockstring_a + ",\010"  ; Save last lock to a variable
ENDFOREACH
script_m = SUBSTR(script_m,1,LEN(script_m)-2)      ; Remove last comma and <CR> from string
FILEWRITE PRIVDIR()+"ZZZZLOCK.SC" FROM script_m    ; Write variable to script
PLAY PRIVDIR()+"ZZZZLOCK"                          ; Play lock script, this is used instead of a EXECUTE command
                                                   ; because EXECUTE will only allow 255 characters which
                                                   ; creates a problem with large amounts of tables

IF NOT retval                                      ; If the lock was unsuccessful
   THEN IF ISBLANK(ERRORUSER())
           THEN erroruser_a = "another user"
           ELSE erroruser_a = ERRORUSER()
        ENDIF
        second_n = 3
        minute_n = 5
        GETCOLORS to systemcolors_y         ; Save system colors to DYNARRAY
        DYNARRAY dialogcolors_y[]
           dialogcolors_y[1031] = 79        ; Inactive dialog box frame color White on Red
           dialogcolors_y[1032] = 79        ; Active dialog box frame color White on Red
           dialogcolors_y[1033] = 79        ; Selectd dialog box frame color White on Red
           dialogcolors_y[1036] = 78        ; Dialog box background text color Yellow on Red
           dialogcolors_y[1037] = 78        ; Dialog box inactive label color Yellow on Red
           dialogcolors_y[1038] = 79        ; Dialog box active label color White on Red
           dialogcolors_y[1045] = 64        ; Dialog box push button color Black on Red

        SETCOLORS FROM dialogcolors_y       ; set new dialog box colors

        SYSINFO TO sysbag_y                 ; Get system information

        SOUND 300 100                       ; Play warning beep
        SOUND 400 50

        SHOWDIALOG "Warning"

           @ INT(sysbag_y["SCREENHEIGHT"]/2)-8,
             INT(sysbag_y["SCREENWIDTH"]/2)-25
           HEIGHT 16 WIDTH 50

           FRAME SINGLE FROM 0,1 TO 5,11
           PAINTCANVAS ATTRIBUTE 64 0,1,0,11
           PAINTCANVAS ATTRIBUTE 64 0,1,5,1
           PAINTCANVAS ATTRIBUTE 79 5,2,5,11
           PAINTCANVAS ATTRIBUTE 79 0,11,5,11

           STYLE ATTRIBUTE 78
           @1,6 ?? ""
           @2,6 ?? ""
           @3,6 ?? ""
           @4,6 ?? ""

           STYLE ATTRIBUTE 79
           @1,15 ?? FORMAT("W32,AC","The table(s) you are attempting")
           @2,15 ?? FORMAT("W32,AC","to lock are controlled")
           @3,15 ?? FORMAT("W32,AC","by "+erroruser_a+".")

           @6,23 ?? IIF(second_n = 0,
                        " Continuously retry",
                        IIF(second_n = 1,
                            " Retry every second",
                            "Retry every "+STRVAL(second_n)+" seconds"))

           @10,24 ?? IIF(minute_n = 0,
                         "Retry until cancel",
                         IIF(minute_n = 1,
                             "Retry for 1 minute",
                             "Retry for "+STRVAL(minute_n)+" minutes"))

           PUSHBUTTON @8,6 WIDTH 10
              "~R~etry"
              OK
              VALUE TableLockDialog_l()
              TAG "Retry"
              TO success_l

           PUSHBUTTON @11,6 WIDTH 10
              "~C~ancel"
              CANCEL
              DEFAULT
              VALUE FALSE
              TAG "Cancel"
              TO success_l

           SLIDER @7,26
              HORIZONTAL
              LENGTH 15
              MIN 0
              MAX 60
              ARROWSTEP 1
              PAGESTEP 3
              TAG "Interval"
              TO second_n

           LABEL @8,25
              "015304560"
              FOR "Interval"

           SLIDER @11,26
              HORIZONTAL
              LENGTH 15
              MIN 0
              MAX 60
              ARROWSTEP 1
              PAGESTEP 3
              TAG "Timeout"
              TO minute_n

           LABEL @12,25
              "015304560"
              FOR "Timeout"

        ENDDIALOG

        SETCOLORS FROM systemcolors_y                           ; Reset system colors

        IF NOT retval OR NOT success_l                          ; If retries are unsuccessful
           THEN IF screen_l                                     ; If screen messages are enabled
                   THEN WINDOW SELECT messwin_h WINDOW CLOSE    ; Move to message window and remove it
                        IF oldwin_h <> 0                        ; Set focus to original window
                           THEN WINDOW SELECT oldwin_h
                        ENDIF
                        MESSAGE "Table lock attempt canceled!"  ; Warn user of failure
                ENDIF
                EDITOR NEW PRIVDIR()+"ZZZZLOCK.SC"              ; Delete lock script
                CANCELEDIT
                RETURN FALSE
        ENDIF
ENDIF

EDITOR NEW PRIVDIR()+"ZZZZLOCK.SC"                              ; Delete lock script
CANCELEDIT

IF screen_l                                                     ; If screen messages enabled
   THEN WINDOW SELECT messwin_h WINDOW CLOSE                    ; Remove message window
        IF oldwin_h <> 0                                        ; Set focus to original window
           THEN WINDOW SELECT oldwin_h
        ENDIF
        MESSAGE "Table lock successful!"                        ; Inform user of lock success
ENDIF
RETURN TRUE                                                     ; Return successful

ENDPROC

;WRITELIB libname_a TableLock_l
;RELEASE PROCS TableLock_l


;===============================================================================
PROC TableLockDialog_l()
;
       PRIVATE  attempt_n, ;= retry attempt number
                curtime_n, ;= Current system time in TICKS
                curdate_d, ;= Current system date
                timeout_n, ;= Time to stop trying lock in TICKS
                timeout_d, ;= date to stop trying lock
                retry_n,   ;= Interval to retry lock in TICKS
                retry_d,   ;= Date interval to retry lock
                start_n,   ;= Start time of retries in TICKS
                start_d    ;= Start date of retries
;  GLOBAL VARS; second_n,  ;= Interval between retries in seconds
;               minute_n,  ;= Duration of retries in minutes
;  SYSTEM VARS; none
;   PROCEDURES; TableLockDialogProc_u()
;      RETURNS; TRUE  - If table lock is successful
;               FALSE - If table lock is unsuccessful
;       AUTHOR; Joseph T. Saturnia, Jr.
;               Computer Resource Center
;               Copyright 1994, All Rights Reserved
;      CREATED; 06/01/92  v4.0
;  ATTRIBUTION; none
;  DESCRIPTION; Dialog box to retry table lock until cancel, timeout or success
;EXAMPLE USAGE; N/A
;-------------------------------------------------------------------------------

attempt_n = 1                     ; Initialize retry attempt
curdate_d = TODAY()               ; Initialize current date
curtime_n = TICKS()               ; Initialize current time
start_d   = curdate_d             ; Initialize starting date
start_n   = curtime_n             ; Initialize starting time
retry_n   = curtime_n             ; Initialize retry date
retry_d   = curdate_d             ; Initialize retry time

SWITCH
   CASE minute_n = 0                              : timeout_n = 0
   CASE (minute_n * 60000) + curtime_n > 86400000 : timeout_n = (minute_n*60000)+curtime_n-86400000
   OTHERWISE                                      : timeout_n = (minute_n*60000)+curtime_n
ENDSWITCH


SWITCH
   CASE minute_n = 0                              : timeout_d = 0
   CASE (minute_n * 60000) + curtime_n > 86400000 : timeout_d = curdate_d+1
   OTHERWISE                                      : timeout_d = curdate_d
ENDSWITCH

SHOWDIALOG "Retry Table Lock"                           ; Dialog to show retry status
   PROC "TablelockDialogProc_l"
      IDLE
   @ INT(sysbag_y["SCREENHEIGHT"]/2)-5,
     INT(sysbag_y["SCREENWIDTH"]/2)-19
   HEIGHT 10 WIDTH 38

   STYLE ATTRIBUTE 78
   @1,3 ?? "Retry interval:"
   @2,3 ?? "  Retry period:"
   @3,3 ?? "  Elapsed time:"
   @4,3 ?? "       Retry #:"

   STYLE ATTRIBUTE 79
   @1,19 ?? IIF(second_n = 0,"Continuous",STRVAL(second_n)+" "+
                IIF(second_n > 1,"seconds","second"))
   @2,19 ?? IIF(minute_n = 0,"Until cancel",STRVAL(minute_n)+" "+
                IIF(minute_n > 1,"minutes","minute"))
   @3,19 ?? SUBSTR(FORMAT("W3,EZ",(curdate_d-start_d)*24+INT((curtime_n-start_n)/3600000)),2,2)+":"+
            SUBSTR(FORMAT("W3,EZ",INT(MOD(ABS(curtime_n-start_n),360000)/60000)),2,2)+":"+
            SUBSTR(FORMAT("W3,EZ",INT(MOD(ABS(curtime_n-start_n),60000)/1000)),2,2)

   @4,19 ?? STRVAL(attempt_n)

   PUSHBUTTON @6,13 WIDTH 10
      "~C~ancel"
      CANCEL
      DEFAULT
      VALUE FALSE
      TAG "Cancel"
      TO success_l

ENDDIALOG

RETURN retval

ENDPROC

;WRITELIB libname_a TableLockDialog_l
;RELEASE PROCS TableLockDialog_l


;===============================================================================
PROC TableLockDialogProc_l(eventtype_a,tagvalue_a,eventvalue_y,elementvalue_a)
;
;      PRIVATE; eventtype_a,   ;= class of event
;               tagvalue_a,    ;= Tag value
;               eventvalue_y,  ;= Event array
;               elementvalue_a ;= Value of element
;  GLOBAL VARS; curdate_d      ;= Current system date
;               curtime_n      ;= Current system time
;               timeout_n      ;= Time to stop trying lock
;               timeout_d      ;= Date to stop trying lock
;               second_n       ;= Retry period in seconds
;               minute_n       ;= Minutes to retry for
;               attempt_n      ;= Lock attempt number
;               locklist_y     ;= Array of tables and locks
;               tagname_a      ;= Tag of DYNARRAY locklist_y
;  SYSTEM VARS; retval
;   PROCEDURES; none
;      RETURNS: no value
;       AUTHOR; Joseph T. Saturnia, Jr.
;               Computer Resource Center
;               Copyright 1994, All Rights Reserved
;      CREATED; 06/01/92
;  ATTRIBUTION; none
;  DESCRIPTION; Dialog procedure to attempt a table lock for a user specified
;               time and user specified duration.
;EXAMPLE USAGE; N/A
;-------------------------------------------------------------------------------

curdate_d = TODAY()                                ; Initialize current date
curtime_n = TICKS()                                ; Initialize current time
IF timeout_n <> 0 AND                              ; If a retry period is set and
   timeout_n <= curtime_n AND                      ; if time limit is exceeded and
   timeout_d <= curdate_d                          ; if date limit is exceeded
   THEN CANCELDIALOG                               ; cancel lock retries
ENDIF
IF retry_n <= curtime_n AND retry_d <= curdate_d   ; If retry interval
   THEN attempt_n = attempt_n + 1                  ; Increment attempt #
        PLAY PRIVDIR()+"ZZZZLOCK"                  ; Play lock script, this is used instead of a EXECUTE command
                                                   ; because EXECUTE will only allow 255 characters which
                                                   ; creates a problem with large amounts of tables
        IF retval                                  ; If success
           THEN ACCEPTDIALOG                       ; Accept and escape
           ELSE IF (second_n*1000) + curtime_n > 86400000             ; Otherwise reset retry second interval
                   THEN retry_n = (second_n * 1000) + curtime_n - 86400000
                   ELSE retry_n = (second_n * 1000) + curtime_n
                ENDIF
                IF (second_n * 1000) + curtime_n > 86400000           ; Reset retry date interval
                   THEN retry_d = curdate_d + 1
                   ELSE retry_d = curdate_d
                ENDIF
                REPAINTDIALOG                                         ; Repaint the dialog box
        ENDIF
   ELSE REPAINTDIALOG                                                ; Repaint the dialog box
ENDIF

ENDPROC

;WRITELIB libname_a TableLockDialogProc_l
;RELEASE PROCS TableLockDialogProc_l


;===============================================================================
PROC Message_h(message_a)
;
       PRIVATE; message_a     ;= Message to display
                canvas_h,     ;= Current canvas
                sysbag_y,     ;= DYNARRAY of system information
                winattr_y,    ;= DYNARRAY of window attributes
                messagewin_h  ;= Message window handle
;  GLOBAL VARS; none
;  SYSTEM VARS; none
;   PROCEDURES; none
;      RETURNS: Window handle
;       AUTHOR; Joseph T. Saturnia, Jr.
;               Computer Resource Center
;               Copyright 1994, All Rights Reserved
;      CREATED; 06/01/92
;  ATTRIBUTION; none
;  DESCRIPTION; Displays message with blinking dots at the end, returns window
;               handle so it can be cleared later
;EXAMPLE USAGE; N/A
;-------------------------------------------------------------------------------

MESSAGE ""                                  ; Clear any message
canvas_h = GETCANVAS()
SYSINFO TO sysbag_y

DYNARRAY winattr_y[]                        ; Set DYNARRAY of window attributes
   winattr_y["CANCLOSE"]    = FALSE
   winattr_y["CANMAXIMIZE"] = FALSE
   winattr_y["CANMOVE"]     = FALSE
   winattr_y["CANRESIZE"]   = FALSE
   winattr_y["FLOATING"]    = TRUE
   winattr_y["HASFRAME"]    = FALSE
   winattr_y["HEIGHT"]      = 1
   winattr_y["ORIGINCOL"]   = sysbag_y["SCREENWIDTH"]-7-LEN(message_a)
   winattr_y["ORIGINROW"]   = sysbag_y["SCREENHEIGHT"] - 3
   winattr_y["WIDTH"]       = LEN(message_a)+5

WINDOW CREATE ATTRIBUTES winattr_y TO messagewin_h
SETCANVAS messagewin_h
STYLE ATTRIBUTE 79
@ 0,0 ?? " "+message_a
STYLE ATTRIBUTE 207
?? "... "
STYLE
IF ISWINDOW(canvas_h)
   THEN SETCANVAS canvas_h
   ELSE SETCANVAS DEFAULT
ENDIF

RETURN messagewin_h                         ; Return handle of message window

ENDPROC

;WRITELIB libname_a Message_h
;RELEASE PROCS Message_h

