;==============================================================================
; This procedure was produced by the programmers at
;
;                   Tipton Cole + Co.
;                   P.O. Box 161563
;                   Austin Tx, 78716
;                   512-329-0060
;
;==============================================================================
PROC JOBTIME(current_count,total_count)                                     ;01
     PRIVATE percent_done, timenow, position, calcsec, tdiff, tleft,        ;02
             workhrs, workmin, worksec                                      ;03
  IF NOT ISASSIGNED(tcc_op_1) THEN                                          ;04
    tcc_op_1 = 0                                                            ;05
    timenow  = TIME()                                                       ;06
    @23,00 ?? "Beg " + timenow + " "                                       ;07
    @23,14 ?? "0%       % Completed     50%         75%        100% End"   ;08
    @24,00 ?? "Now " + timenow + " "                                       ;09
    @24,66 ?? " Run"                                                       ;10
    tcc_ss_1 = (3600 * (NUMVAL(SUBSTR(timenow,1,2)))) +                     ;11
               (60   * (NUMVAL(SUBSTR(timenow,4,2)))) +                     ;12
                       (NUMVAL(SUBSTR(timenow,7,2)))                        ;13
  ENDIF                                                                     ;14
  IF ((total_count > 0) AND (current_count <= total_count)) THEN            ;15
    percent_done = INT((current_count / total_count) * 100)                 ;16
    IF percent_done <> tcc_op_1 THEN                                        ;17
      IF percent_done < tcc_op_1 THEN                                       ;18
        @24,15 ?? FILL(" " , 50)                                            ;19
      ENDIF                                                                 ;20
      tcc_op_1 = percent_done                                               ;21
      position = INT(percent_done / 2)                                      ;22
      @24,15 ?? FILL("" , position)                                        ;23
      IF MOD(percent_done , 2) <> 0 THEN                                    ;24
        @24,15 + position ?? ""                                            ;25
      ENDIF                                                                 ;26
      timenow = TIME()                                                      ;27
      workhrs = NUMVAL(SUBSTR(timenow,1,2))                                 ;28
      workmin = NUMVAL(SUBSTR(timenow,4,2))                                 ;29
      worksec = NUMVAL(SUBSTR(timenow,7,2))                                 ;30
      calcsec = (3600 * workhrs) + (60 * workmin) + worksec                 ;31
      tdiff   = calcsec - tcc_ss_1                                          ;32
      IF tdiff < 0 THEN                                                     ;33
        tdiff = tdiff + 86400                                               ;34
      ENDIF                                                                 ;35
      tleft   = tdiff * ((total_count - current_count) / current_count)     ;36
      calcsec = calcsec + tleft                                             ;37
      @23,20 ?? percent_done                                                ;38
      workhrs = INT(calcsec / 3600)                                         ;39
      workmin = INT((MOD(calcsec , 3600)) / 60)                             ;40
      worksec = INT(MOD((MOD(calcsec , 3600)) , 60))                        ;41
      @23,71 ?? FORMAT("W3,AR,EZ",workhrs)                                  ;42
      @23,74 ?? FORMAT("W3,AR,EZ",workmin)                                  ;43
      @23,77 ?? FORMAT("W3,AR,EZ",worksec)                                  ;44
      @23,74 ?? ":"                                                         ;45
      @23,77 ?? ":"                                                         ;46
      @24,04 ?? timenow                                                     ;47
      workhrs = INT(tdiff / 3600)                                           ;48
      workmin = INT((MOD(tdiff , 3600)) / 60)                               ;49
      worksec = INT(MOD((MOD(tdiff , 3600)) , 60))                          ;50
      @24,71 ?? FORMAT("W3,AR,EZ",workhrs)                                  ;51
      @24,74 ?? FORMAT("W3,AR,EZ",workmin)                                  ;52
      @24,77 ?? FORMAT("W3,AR,EZ",worksec)                                  ;53
      @24,74 ?? ":"                                                         ;54
      @24,77 ?? ":"                                                         ;55
      IF percent_done > 99 THEN                                             ;56
        RELEASE VARS tcc_op_1, tcc_ss_1                                     ;57
      ENDIF                                                                 ;58
    ENDIF                                                                   ;59
  ELSE                                                                      ;60
    MESSAGE "From JOBTIME: Unable to compute percentage"                    ;61
  ENDIF                                                                     ;62
ENDPROC                                                                     ;63
;==============================================================================
; Description:
;   This procedure reports the time that a job started, the estimated
;   completion time of the process, the time that this procedure executes
;   and the number of hours, miuntes, and seconds that the process has
;   been running.  It also reports the percentage of the process that has
;   been completed along with a graphic representation of the percentage.
;==============================================================================
; Use:
;   JOBTIME is a procedure that must be 'played' or put in a libaray
;   and loaded before it is called.  The calling script should determine 
;   the total number of records to be read. The call should be placed 
;   inside the a loop that 'reads' the records to be processed.
;
;   Example:
;            .
;            .
;            .
;     play "jobtime"
;     view "Codes"
;     j = 0
;     k = 0
;     l = NRECORDS("Codes")
;     FOR i from 1 TO l
;       jobtime(i,l)
;       MOVETO "Codes"
;       j = i + k
;       MOVETO RECORD j
;            .
;            .
;     ENDFOR
;            .
;            .
;            .
;==============================================================================
; Theory:
;   One of the primary complaints of end users is that they do not know how 
;   long any particular computer process will take. In the workplace this can 
;   be very costly.  Users often sit idle waiting on the computer to finish its
;   work.  JOBTIME is a simple procedure that will tell the users how long they
;   can expect to wait for the computer to finish.  It may allow them to put
;   that waiting time to better use.
;
;   NOTE #1: The estimated completion time algrorithm becomes more accurate 
;            the farther into the process it goes
;   NOTE #2: To run more than one of these at a time, copy JOBTIME to JOBTIME2,
;            rename tcc_op_1 and tcc_ss_1 to tcc_op_2 and tcc_ss_2,
;            respectively, then call JOBTIME2 with the approiate parameters.
;   NOTE #3: The calling program has complete control over the percentage
;            to be displayed by means of the passed parameters.
;==============================================================================
; Annotation:
;   Lines 01 - 03  Declaration of passed and private variables.
;  
;   Lines 04 - 04  Check the existence of a global variable. If this 
;                  variable does not have a value then this is the 
;                  first time that JOBTIME has been called.
;
;   Lines 05 - 05  Setup the global variable tcc_op_1. This variable
;                  serves two functions. One, it is the 'flag' that 
;                  tells JOBTIME whether this is the first time
;                  it has been called. Two, it serves as a logical
;                  efficieny flag (See Line 17). The variable name tcc_op_1
;                  is cryptic by design; the 'op' part of the variable
;                  stands for 'old percent.' Note that, if an application
;                  uses the variable name tcc_op_1, complications may arise.
;
;                  NOTE: A very common occurance is that the calling 
;                  procedure will fail and tcc_op_1 will not be reset.                  
;
;   Lines 06 - 06  Setup the time that the job started.
;
;   Lines 07 - 10  Display the text and the time that the job started.
;
;   Lines 11 - 13  Setup global variable tcc_ss_1. This variable is the
;                  relative seconds of the current time. It is used for
;                  calculations in subsequent calls to the this
;                  procedure.  The variable name tcc_ss_1 is cryptic
;                  by design; the 'ss' part of the variable stands for
;                  'start seconds.' Note that, if an application uses the
;                  variable name tcc_ss_1, complications may arise.
;
;   Lines 14 - 14  Necessary syntax.
;
;   Lines 15 - 15  Test to see that the next calculation will not cause a
;                  division by 0 or yield a percentage > 100.
;
;   Lines 16 - 16  Calculate the percent completed so far.
;
;   Lines 17 - 17  Check to see if another display of the information is
;                  necessary. The decision is based upon whether the
;                  percentage completed has changed. If the percentage
;                  completed has not changed, no other processing is done.
;          
;                  NOTE: This means that the following calculations and
;                  displays will be performed at most 100 times.
;
;   Lines 18 - 20  Test to see if the percentage is smaller than the
;                  last time the routine was called, if so the graphic
;                  display is completely erased so the next display
;                  will show the correct proportion.
;
;   Lines 21 - 21  Assign the tcc_op_1 (the old percent) to the percent
;                  done.
;
;   Lines 22 - 22  Calculate the relative size of the graphic display
;                  'bar'. The 'bar' can be 50 characters wide, i.e.,
;                  2% = 1 character.
;
;   Lines 23 - 23  Display the bar in 2% increments.
;
;   Lines 24 - 26  If the percent completed is an odd number (a 1%
;                  increment), then the procedure will add a 1/2 character
;                  to the 'bar'.
;
;   Lines 27 - 31  Setup local variable timenow and calculate the relative
;                  second of the day.
;
;   Lines 32 - 34  Calculate the local variable tdiff. This is the difference
;                  in seconds from the start of the procedure to the 
;                  current time.
;
;   Lines 35 - 35  Compensate for 24 hour overflow. If the start time is
;                  11:00 PM and the current time is 1:30 AM this will 
;                  adjust the number of elapsed seconds so the remaining 
;                  calculations will work.
;  
;   Lines 36 - 36  Calculate the approximate seconds left to go based upon
;                  the number of seconds elapsed times the fraction of the
;                  records processed so far.
;
;   Lines 37 - 37  Calculate the relative seconds of the day that the 
;                  procedure is expected to complete.
;
;   Lines 38 - 38  Display the percentage completed.
;
;   Lines 39 - 46  Convert the relative seconds of expected completion time
;                  into a 'time' format and display that time.
;
;   Lines 47 - 47  Display the current time.
;
;   Lines 48 - 55  Convert the number of seconds that the job has been 
;                  runing into an hour:minute:second format and display
;                  that time.
;
;   Lines 56 - 58  If the percent done is > 99, the procedure is finished
;                  and should not be called again by the same calling 
;                  procedure. At this point JOBTIME releases it's global
;                  variables so that the next time it is called it will 
;                  start a new display (see Lines 04)
;
;   Lines 59 - 60  Necessary syntax.
;
;   Lines 61 - 61  If the total_count = 0 or current_count > total_count
;                  then the calling procedure needs to be checked for logical
;                  consistancy.
;                  
;   Lines 62 - 63  Necessary syntax.
;==============================================================================
