/* Struct.C
   Reports structure of passed Paradox table.

   Author:  Jonathan M. Matcho

   Date:    July 13, 1993

*/

#include <string.h>
#include "pxengine.h"

#define MAXFLEN         26            // Maximum "Field Name" length

//#define NETWORK                     // Uncomment this line to run on net
#ifdef NETWORK
#define NETDIR          "F:\\PDOXDATA"
#define NETTYPE         LOCALSHARE|OTHERNET
#define NETUSERNAME     "Struct"
#endif

// Function prototypes:
void HandleStructure(char *, int);
int Error(int rc);

TABLEHANDLE tblhandle;
FIELDHANDLE fieldhandle;

int main(int argc, char *argv[])
{
  int withfrills;

  if ((argc > 3  || argc == 1) ||
      (argc == 3 && strcmpi("-a",argv[1]) ))
     {
     printf("\nStruct  v1.2  7/13/93\nParadox table structure dumper\n\n");
     printf("Usage:  Struct [-a] tablename\n\n");
     printf("The -a switch dumps to ASCII delimited.\n\n");
     printf("Jonathan Matcho\n765 Park Ave.\nBound Brook, NJ  08805\n");
     printf("\nPhone:  (908) 563-6844\nCIS:    71760,2720\n");
     return(2);
     }

  if (argc == 3)
     withfrills = 0;
  else
     withfrills = 1;

#ifdef NETWORK
  if (Error(PXNetInit(NETDIR, NETTYPE, NETUSERNAME)))
#else
  if (Error(PXInit()))
#endif
     return(1);

  if (!Error(PXTblOpen(argv[2 - withfrills], &tblhandle, 0, 0)))
     {
     HandleStructure(argv[2 - withfrills], withfrills);
     Error(PXTblClose(tblhandle));
     }

  return(Error(PXExit()));

}

void HandleStructure(char *tablename, int withfrills)
{
  int nfields, nkeyfields, x, s;
  char fname[MAXFLEN], ftype[6];
  RECORDNUMBER nRecords;

  Error(PXRecNFlds(tblhandle, &nfields));
  Error(PXKeyNFlds(tblhandle, &nkeyfields));

  if (withfrills)
     {
     printf("\nTable Name: %s\n\n", tablename);
     printf("STRUCTField NameField Type\n");
     }

  for (x = 1; x <= nfields; x++)
    if (!Error(PXFldName(tblhandle, x, MAXFLEN, fname)) &&
       !Error(PXFldType(tblhandle, x, 6, ftype)))
       {
       if (withfrills)
          printf("    %2d   ", x);
       printf("%s", fname);
       if (withfrills)
          {
          for (s = 1; s < (MAXFLEN - strlen(fname)); s++)
              printf(" ");
          printf("   %s", ftype);
          }
       else
          printf(",%s", ftype);
          if (x <= nkeyfields)
             printf("*");
          else
             if (withfrills)
                printf(" ");
       if (withfrills)
          {
          for (s = 1; s < (7 - strlen(ftype)); s++)
            printf(" ");

          printf(" ");
          }
       printf("\n");
       }

  if (withfrills)
     {
     Error(PXTblNRecs(tblhandle, &nRecords));
     printf("\nTotal records: %d\n",nRecords);
     }
}

int Error(int rc)
{
  if (rc != PXSUCCESS)
     printf("Error: %s\n", PXErrMsg(rc));

  return rc;
}
