Clear
ClearAll
Reset
Release Vars All
Release Procs All


;------------------------------------------------------------------------------
; Error_Handler - Error Proc for the application
;------------------------------------------------------------------------------

Proc Error_Handler()
DEBUG
; Show error On Screen
  Clear
   @3,15  ?? "E R R O R   S T A T U S"
   @8,7 ?? "      ErrorCode() = " + StrVal(ErrorCode())
   @9,7 ?? "   ErrorMessage() = " + ErrorMessage()
  @12,7 ?? "   SQLErrorCode() = " + StrVal(SQLErrorCode())
  @13,7 ?? "SQLErrorMessage() = " + SQLErrorMessage()

; Give user choice of COMMITTING or ROLLINGBACK the transaction

    ShowMenu
      "Commit"   : "Cleanup SQL environment by COMMITTING CHANGES ON SERVER",
      "RollBack" : "Cleanup SQL environment by ROLLINGBACK CHANGES ON SERVER",
      "Quit"     : "Rollback Transaction & QUIT Application"
    DEFAULT "Commit"
    To Choice

    Switch
    Case Choice = "Commit" :
      Message "Committing Changes On Server"
      SQLCOMMIT

    Case Choice = "RollBack" :
      Message "Rolling Back Changes On Server"
      SQLROLLBACK

    Case Choice = "Quit" :
      SQLROLLBACK
      SQLAUTOCOMMIT YES
      QUIT "Application aborted.  Transaction ROLLED BACK.."
    ENDSwitch

   RETURN 1
EndProc  ; Error_Handler

;----------------------------------------------------------------------
;   Get_Table_Names - Prompt user for the source & target tables.
;----------------------------------------------------------------------
Proc Get_Table_Name()

  IF ISBLANK(SQLCONNECTINFO("TITLE","")) THEN
    QUIT "Connection Information has NOT been set.  Please Login to the Server..."
  ENDIF

  @0,0
  TEXT
  R E M O T E   D A T A   I N S E R T  /  U P D A T E

     Ŀ
                                                 
                                                 
                                                 
                                                 
     

      Script Expects :

         Source - Local Paradox Table Name.
         Target - Replica Table Name.  (Created by Paradox - NOT SQLSetup)
         5 or less consecutive Paradox keys on Replica table.
         Inserts/Updates are done within a TRANSACTION, user may COMMIT
           or ROLLBACK changes at the end of the script.
         If a Server error occurs, user will have option of COMMITTING/
           ROLLINGBACK work, or QUITING.
         Pressing ESC will abort script at either prompt.

  ENDTEXT
  PaintCanvas ATTRIBUTE 62   2,5,7,51
  badtable = true
  WHILE badtable
    STYLE ATTRIBUTE 62
    @4,10  ?? "                           "
    @4,10  ?? "SOURCE Table Name : "
    STYLE ATTRIBUTE 49
    ACCEPT "A8" TO SourceTableName
    IF NOT RETVAL THEN
      QUIT
    ENDIF
    IF SourceTableName = "" Then                         ; show list of tables
      ShowTables
        ""
        "HighLight name of SOURCE table to use, then press Enter"
      To SourceTableName
      IF (NOT RETVAL) OR (SourceTableName = "Esc") THEN    ; user press Esc
        QUIT
      ENDIF
    EndIF
    STYLE
    IF ISTABLE(SourceTableName) THEN
      badtable = false
    ELSE
      MESSAGE  SourceTableName + " Does NOT Exist!!  Please Re-Try!!"
    ENDIF
  ENDWHILE
  STYLE ATTRIBUTE 49
  @4,30  ?? SourceTableName
  STYLE

  badtable = true
  KeyedTable = False
  NumKeyFields = 0

  WHILE badtable
    STYLE ATTRIBUTE 62
    @5,10  ?? "                           "
    @5,10  ?? "TARGET Table Name : "
    STYLE ATTRIBUTE 49

; Force UPPERCASE for the target table.  Paradox will always create uppercase
; table names.  May be modified for longer or non-case sensitive names.

    ACCEPT "A8"  Picture "!*!" TO TargetTableName
    IF NOT RETVAL THEN
      QUIT
    ENDIF
    IF TargetTableName = "" Then                         ; show list of tables
      ShowTables
        ""
        "HighLight TARGET table to use, then press Enter"
      To TargetTableName
      IF (NOT RETVAL) OR (TargetTableName = "Esc") THEN    ; user pressed Esc
        QUIT
      ENDIF
      TargetTableName = UPPER(TargetTableName)             ; Convert to all uppercase
    EndIF
    STYLE

    IF (UPPER(SourceTableName) = TargetTableName) Then          ; Source = Target - NO!!
      Message "Source Table = Target Table!!  Choose DIFFERENT Target!!"
      Loop
    EndIF
    IF SQLISREPLICA(TargetTableName) THEN
      badtable = FALSE
      FullTargetTableName = SQLMAPINFO("TABLENAME",TargetTableName)  ; Get full table name on server
      IF Nkeyfields(TargetTableName) > 0 Then                        ; If replica has keys, set flag
        KeyedTable = True
        NumKeyFields = NKeyfields(TargetTableName)
        IF Nkeyfields(TargetTableName) > 5 Then                      ; too many keys, quit
           Quit TargetTableName + " Has TOO Many Keys.  Expecting 5 or less Key Fields."
        EndIF
      EndIF
    ELSE
      MESSAGE  TargetTableName + " Does NOT Exist!!  Please Re-Try!!"
    ENDIF
  ENDWHILE

  STYLE ATTRIBUTE 49
  @5,30  ?? TargetTableName
  STYLE
EndProc  ; Get_Table_Name

;-----------------------------------------------------------------------------
;     Create_Field_List - Get structure of replica, and save in variable(s)
;-----------------------------------------------------------------------------
Proc Create_Field_List(TargetTable)
  PerformUpdate = FALSE               ; Set update flag to false
  Array ValueList[40]                 ; Array to hold VALUES or UPDATE string
  Array FieldName[10]                 ; Array to hold table field names
  Array ActualFieldName[NFields(TargetTable) + 1]  ; Array to hold actual target table field names

; Assign variables blanks
  FieldList = ""       

  FOR I From 1 TO 10                  ; Clear out FieldName Array w/ BLANKS
    FieldName[I] = ""
  EndFor

  Message "Preparing SQL Statements..."
;  Get the structure of the replica (target) table.

  Menu {Tools} {Info} {Structure} Select TargetTable

  IF KeyedTable Then              ; Find the key fields of the Target Table
    Get_Key_Info()
  EndIF

  MoveTo [Struct -> Field Name]
  TotalListChars = 0
  NameIndex = 1
  I = 2

; Create field list, delimited by commas
  Scan
    Temp = [] + ","                                ; Get field name & add a comma
    ActualFieldName[I] = []                        ; Get actual field name in array (for updates)
    I = I + 1                                      ; Increment counter by 1
;    IF (TotalListChars + LEN(Temp) > 255) Then     ; Move to next element when full
;      NameIndex = NameIndex + 1
;      TotalListChars = 0                           ; Reset character counter
;    EndIf

    FieldList = FieldList + Temp  ; Add current field name to element
;    TotalListChars = TotalListChars + LEN(Temp)         ; Add the length of new element to total
  EndScan

; Remove last comma from last fieldlist

  FieldList = SubStr(FieldList,1,LEN(FieldList)-1)

EndProc  ; Create_SQL_Statement

;-----------------------------------------------------------------------------
;     Get_Key_Info - Create list of the key fields of the remote table
;-----------------------------------------------------------------------------
Proc Get_Key_Info()
    Array KeyArray[5]
    Array KeyValueArray[5]        ; Find the key fields of the Target Table
    KeyArray[1] = ""              ; and save them in KeyArray.
    KeyArray[2] = ""
    KeyArray[3] = ""
    KeyArray[4] = ""
    KeyArray[5] = ""
    KeyValueArray[1] = ""
    KeyValueArray[2] = ""
    KeyValueArray[3] = ""
    KeyValueArray[4] = ""
    KeyValueArray[5] = ""
    Home
    Moveto [Struct ->Field Name]

    For I from 1 To NumKeyFields   ; Prepare key field list delimited by commas
      KeyArray[I] = [] + ","
      Down
    EndFOR

; Remove final comma from last entry
    KeyArray[NumKeyFields] = Substr(KeyArray[NumKeyFields],1,LEN(KeyArray[NumKeyFields]) - 1)

EndProc  ; Get_Key_Info

;-----------------------------------------------------------------------------
;    Check_For_Update - On keyed tables, see if the key field(s) value(s) exist
;                       in remote table.  If true set PerformUpdate flag and
;                       prepare an UPDATE statement.
;-----------------------------------------------------------------------------
Proc Check_For_Update()

; Create key field list with values & append the word AND (ex. F1='abc' AND F2="r")
    For I from 1 To NumKeyFields
      KeyValueArray[I] = ActualFieldName[I + 1] + " = " + SQLVAL([]) + " AND "
      Right
    EndFor

; Remove the last "AND"  from the final key field
 KeyValueArray[NumKeyFields] = SubStr(KeyValueArray[NumKeyFields],1,LEN(KeyValueArray[NumKeyFields]) - 5)

    CTRLHOME                     ; Move back to beginning of same row.
    Right

    Key1 = KeyArray[1]           ; Transfer the key field names from the array
    Key2 = KeyArray[2]           ; to a variable.
    Key3 = KeyArray[3]
    Key4 = KeyArray[4]
    Key5 = KeyArray[5]
    KeyValue1 = KeyValueArray[1]   ; Transfer key field values to variables
    KeyValue2 = KeyValueArray[2]
    KeyValue3 = KeyValueArray[3]
    KeyValue4 = KeyValueArray[4]
    KeyValue5 = KeyValueArray[5]

; Perform NoFetch query using the key fields & values to see if record exists

    SQL NoFetch
      Select ~Key1~ ~Key2~ ~Key3~ ~Key4~ ~Key5~
        From ~FullTargetTableName~
        WHERE ~KeyValue1~ ~KeyValue2~ ~KeyValue3~ ~KeyValue4~ ~KeyValue5~
    ENDSQL

    SQLFETCH Buff             ; Fetch record from server (if possible)
    IF Retval Then
      PerformUpdate = TRUE    ; Record fetched, set PerformUpdate flag true
    EndIF
    SQLRelease                ; Release Cursor

EndProc  ; Check_For_Update

Proc Process_Current_Row()
;----------------------------------------------------------------------------
; Process_Current_Row() -  Build INSERT or UPDATE SQL statement
; ValueList Array elements are filled up to the 255 (or less) limit.  Then, the
; next element is used.  Current set up is for 40 elements of 255 chars (10,200 chars).
; Move thru fields of local table using the function SQLVAL() to properly format
; the data from each field.  Build either an INSERT or UPDATE statement.
;----------------------------------------------------------------------------
    ValueList = ""                    ; Set INSERT/UPDATE string to blank
    CopyToArray CurrentRecord         ; Copy current row to array CurrentRecord

    For I From 2 to FieldsInTable
      IF PerformUpdate Then
        Temp = ActualFieldName[I] + " = " + SQLVAL(CurrentRecord[I])  ; Build Update statement
      Else
        Temp = SQLVAL(CurrentRecord[I])                     ; Build Insert statement
      EndIF

      IF I <> FieldsInTable Then
        Temp = Temp + ", "          ; add a comma on every entry, except last
      EndIF

      ValueList = ValueList + Temp                           ; Build INSERT/UPDATE statement

    EndFor
EndProc  ; Process_Current_Row

;----------------------------------------------------------------------------
;   Perform_Inserts - Insert/Update values from local table into remote table
;----------------------------------------------------------------------------
Proc Perform_Inserts(LocalTable,RemoteTable)
  SQLAUTOCOMMIT NO                               ; Set AutoCommit to NO
  SQLSTARTTRANS                                  ; Start a transaction on server
  @20,10 ?? "Records to Insert/Update : ",NRecords(LocalTable)
  @22,10 ?? "Transaction Started On Server..."   ; Put message on screen
  View LocalTable
  Right
  Insert_Count = 0                               ; Number of records inserted
  Update_Count = 0                               ; Number of records updated
  CurrentVarCount = 0                            ; Character counter for each variable (limit 255 chars)
  FieldsInTable = NFields(LocalTable) + 1        ; Number of field in record

  Scan
    PerformUpdate = False      ; Set update flag to false

    IF KeyedTable Then         ; If the table is keyed, check to see if row exists
      Check_For_Update()
    EndIF

    Process_Current_Row()      ; Convert current row into valid insert/update statement

; Perform either an UPDATE or INSERT to the remote table.
; PAL limitation : Alpha Variables are limited to 255 chars.  SQL statements
;     must be built before sending to server in increments of 255 chars.  Arrays
;     are NOT able to be sent.  Any variables that are blank will pass straight
;     through w/o any problem.
;

    IF PerformUpdate Then
      Update_Count = Update_Count + 1             ; Increment number of records updated
      @24,40 Clear EOL
      @24,40 ?? "Performing Update on Record : " + StrVal(RecNo())
      SQL
        UPDATE  ~FullTargetTableName~
          SET ~ValueList~
          WHERE ~KeyValue1~ ~KeyValue2~ ~KeyValue3~ ~KeyValue4~ ~KeyValue5~
      EndSQL
     Else
      Insert_Count = Insert_Count + 1             ; Increment number of records inserted
      @24,40 Clear EOL
      @24,40 ?? "Performing Insert on Record : " + StrVal(RecNo())
      SQL
        INSERT INTO ~FullTargetTableName~  (~FieldList~)
            Values (~ValueList~)
      EndSQL
     EndIf

  EndScan
EndProc  ; Perform_Inserts

;----------------------------------------------------------------------------
;   Wrap_Up_Transaction - Prompt user to COMMIT/ROLLBACK transaction on server
;----------------------------------------------------------------------------
Proc Wrap_Up_Transaction()
  Clear
  ClearAll
  @5,15 ?? "Transaction Was Sucessfull!"
  @7,18 ?? "Statistics :"
  @9,12 ?? "Records INSERTED : ", Insert_Count
 @10,12 ?? "Records UPDATED  : ", Update_Count

  ShowMenu
    "Commit"   : "COMMIT Changes On Server",
    "RollBack" : "ROLLBACK Changes On Server"
  DEFAULT "Commit"
  To Choice

  IF Choice = "Commit" Then
    Message "Committing Changes On Server"       ; Commit changes
    SQLCOMMIT
   Else
    Message "Rolling Back Changes On Server"     ; Rollback changes
    SQLROLLBACK
  ENDIF
  SQLAUTOCOMMIT YES                              ; Reset AutoCommit to YES
EndProc  ; Wrap_Up_Transaction

;*******************************************************************
;**                   M A I N L I N E                             **
;*******************************************************************

  Clear
  ClearAll
  ErrorProc = "Error_Handler"                        ; Set error proc variable
  Get_Table_Name()                                   ; Prompt user for table names
  Create_Field_List(TargetTableName)                 ; Create field list for SQL Statements
  Perform_Inserts(SourceTableName,TargetTableName)   ; Insert/Update records from local to remote table
  Wrap_Up_Transaction()                              ; Prompt user for Commit/Rollback of transaction
  Reset                                              ; Reset & restore environment.
  Release Vars All
  Release Procs All

