;   HP_PROCS.SC
;        These procedure are free for anyone to use as long as
;        they don't sell them as code or claim them as their own,
;        and they agree to use them AT THEIR OWN RISK.
;
;        If you want to use these to put boxes, lines, etc into
;        Reports as embedded variables, be careful: the boxes should
;        work okay but the text stuff will almost certainly leave the
;        HP with the new font.  You may want to improve the function
;        to push/pop the Font or reset it.  In any case, instead of PRINTing
;        the control string, change the functions to return a string of
;        all the commands concatinated.
;
;        Also, these functions have _not_ been tested in landscape mode
;        at all.
;
;
;        Let me know about any bugs, failures, or improvements, okay?
;        
;        Enjoy
;             Richard 
;

MESSAGE "Compiling init_hp_print"
PROC init_hp_print()
    hp_laser_TR_10      = "\027(7J\027(s1p10v0s0b5T"
    hp_laser_TRI_10     = "\027(7J\027(s1p10v1s0b5T"
    hp_laser_TRI_14     = "\027(7J\027(s1p14v1s0b5T"
    hp_laser_LP_16      = "\027(s0p16.66h8.5v0s0b0T"
    hp_laser_UNI_14     = "\027(7J\027(s1p14v0s0b52T"
    hp_laser_UNI_18     = "\027(7J\027(s1p18v0s0b52T"
    hp_laser_CR_10      = "\027(s0p10h12v0s0b3T"

ENDPROC
WRITELIB libraryname    init_hp_print
RELEASE  PROCS          init_hp_print

MESSAGE "Compiling hp_print"
PROC hp_print(position,font,txt)
;        ARGUMENTS      --   position  in inches from left
;                            font      can be pre-defined font string
    hp_print_hmove(position)

    IF NOT IsBlank(font) THEN
         PRINT font
    ENDIF
    IF NOT IsBlank(txt) THEN
         PRINT txt
    ENDIF

    RETURN retval
ENDPROC
WRITELIB libraryname    hp_print
RELEASE  PROCS          hp_print

MESSAGE "Compiling hp_print_vmove"
PROC hp_print_vmove(position)
;                            position in inches from top
    IF NOT IsBlank(position) AND (position > 0.00) THEN
         PRINT "\027&a" +
              SUBSTR(TRIM(FORMAT("W15.2,AL",(position * 720))),2,255) + "V"
    ENDIF
ENDPROC
WRITELIB libraryname    hp_print_vmove
RELEASE  PROCS          hp_print_vmove

MESSAGE "Compiling hp_print_hmove"
PROC hp_print_hmove(position)
;                                 position in inches from left
    IF NOT IsBlank(position) AND (position > 0.00) THEN
         PRINT "\027&a" +
              SUBSTR(TRIM(FORMAT("W15.2,AL",(position * 720))),2,255) + "H"
    ENDIF
ENDPROC
WRITELIB libraryname    hp_print_hmove
RELEASE  PROCS          hp_print_hmove

MESSAGE "Compiling hp_print_hline"
PROC hp_print_hline(Y,X1,X2)
;        ARGUMENTS      --   Y    distance in inches from top
;                            X1   left limit of line from left edge
;                            X2   right limit of line from left edge
;
;        EXIT           --   in same cursor position as ENTRY

    PRINT "\027&f0S"              ;    push current position

    hp_print_vmove(Y)
    hp_print_hmove(MIN(X1,X2))
    PRINT "\027*c5H"              ;    5 decipoints wide
    PRINT "\027*c" + STRVAL((ABS(X1 - X2) * 720)) + "V"
    PRINT "\027*c0P"

    PRINT "\027&f1S"              ;    pop current position

    RETURN
ENDPROC
WRITELIB libraryname    hp_print_hline
RELEASE  PROCS          hp_print_hline

MESSAGE "Compiling hp_print_vline"
PROC hp_print_vline(X,Y1,Y2)
;        ARGUMENTS      --   X    distance from left edge
;                            Y1   top limit of line from top edge
;                            Y2   bottom limit of line from top edge
;
;        EXIT           --   in same cursor position as ENTRY

    PRINT "\027&f0S"              ;    push current position

    hp_print_hmove(X)
    hp_print_vmove(MIN(Y1,Y2))
    PRINT "\027*c5V"              ;    5 decipoints wide
    PRINT "\027*c" + STRVAL((ABS(Y1 - Y2) * 720)) + "H"
    PRINT "\027*c0P"

    PRINT "\027&f1S"              ;    pop current position

    RETURN
ENDPROC
WRITELIB libraryname    hp_print_vline
RELEASE  PROCS          hp_print_vline

MESSAGE "Compiling hp_print_box"
PROC hp_print_box(Y1,X1,Y2,X2)
;        ARGUMENTS      --   X1   upper-left distance from top
;                            Y1   upper-left distance from left
;                            X2   lower-right distance from top
;                            Y2   lower-right distance from left
;
;        EXIT           --   in same cursor position as ENTRY

    hp_print_hline(Y1,X1,X2)
    hp_print_hline(Y2,X1,X2)
    hp_print_hline(X1,Y1,Y2)
    hp_print_hline(X2,Y1,Y2)
    RETURN
ENDPROC
WRITELIB libraryname    hp_print_box
RELEASE  PROCS          hp_print_box


7ESSAGE "Compiling hp_print_fill_box"
PROC hp_print_fill_box(Y1,X1,Y2,X2,fill_strength)
;        ARGUMENTS      --   Y1   upper-left distance from top       (row)
;                            X1   upper-left distance from left      (col)
;                            Y2   lower-right distance from top      (row)
;                            X2   lower-right distance from left     (col)
;                            fill_strength       how much grey
;
;        EXIT           --   in same cursor position as ENTRY

    PRINT "\027&f0S"              ;    push current position

    hp_print_hmove(MIN(X1,X2))
    hp_print_vmove(MIN(Y1,Y2))
    PRINT "\027*c" + STRVAL((ABS(Y1 - Y2) * 720)) + "V"
    PRINT "\027*c" + STRVAL((ABS(X1 - X2) * 720)) + "H"
    IF IsBlank(fill_strength) OR (fill_strength < 0) THEN
         fill_strength = 20
    ENDIF
    PRINT "\027*c" + STRVAL(MIN(fill_strength,100)) + "G"
    PRINT "\027*c2P"              ;    print filled box

    PRINT "\027&f1S"              ;    pop current position

    RETURN
ENDPROC
WRITELIB libraryname    hp_print_fill_box
RELEASE  PROCS          hp_print_fill_box

;   EOF       HP_PROCS.SC

